#include <iostream>
#include <time.h>

#include <TestCases/TestCaseDescription.h>
#include <TestCases/TestCaseGenerator.h>

const TestCaseDescription& TestCaseDescription_case_00011_various_elem_math        (void);
const TestCaseDescription& TestCaseDescription_case_00021_bernoulli                (void);
const TestCaseDescription& TestCaseDescription_case_00022_euler                    (void);
const TestCaseDescription& TestCaseDescription_case_00023_stirling2                (void);
const TestCaseDescription& TestCaseDescription_case_00051_factorial                (void);
const TestCaseDescription& TestCaseDescription_case_00052_factorial2               (void);
const TestCaseDescription& TestCaseDescription_case_00071_various_int_func         (void);
const TestCaseDescription& TestCaseDescription_case_00101_sin                      (void);
const TestCaseDescription& TestCaseDescription_case_00102_cos                      (void);
const TestCaseDescription& TestCaseDescription_case_00103_exp                      (void);
const TestCaseDescription& TestCaseDescription_case_00104_log                      (void);
const TestCaseDescription& TestCaseDescription_case_00105_sqrt                     (void);
const TestCaseDescription& TestCaseDescription_case_00106_rootn                    (void);
const TestCaseDescription& TestCaseDescription_case_00111_sin_small_x              (void);
const TestCaseDescription& TestCaseDescription_case_00112_cos_x_near_pi_half       (void);
const TestCaseDescription& TestCaseDescription_case_00113_atan_x_small_to_large    (void);
const TestCaseDescription& TestCaseDescription_case_00114_various_trig             (void);
const TestCaseDescription& TestCaseDescription_case_00115_various_elem_trans       (void);
const TestCaseDescription& TestCaseDescription_case_00121_sinh                     (void);
const TestCaseDescription& TestCaseDescription_case_00122_cosh                     (void);
const TestCaseDescription& TestCaseDescription_case_00123_tanh                     (void);
const TestCaseDescription& TestCaseDescription_case_00124_asinh                    (void);
const TestCaseDescription& TestCaseDescription_case_00125_acosh                    (void);
const TestCaseDescription& TestCaseDescription_case_00126_atanh                    (void);
const TestCaseDescription& TestCaseDescription_case_00201_gamma                    (void);
const TestCaseDescription& TestCaseDescription_case_00202_gamma_medium_x           (void);
const TestCaseDescription& TestCaseDescription_case_00203_gamma_small_x            (void);
const TestCaseDescription& TestCaseDescription_case_00204_gamma_tiny_x             (void);
const TestCaseDescription& TestCaseDescription_case_00205_gamma_near_neg_n         (void);
const TestCaseDescription& TestCaseDescription_case_00221_various_gamma_func       (void);
const TestCaseDescription& TestCaseDescription_case_00307_polygamma                (void);
const TestCaseDescription& TestCaseDescription_case_00308_polygamma_fixed_n        (void);
const TestCaseDescription& TestCaseDescription_case_00411_bessel_iv                (void);
const TestCaseDescription& TestCaseDescription_case_00412_bessel_jv                (void);
const TestCaseDescription& TestCaseDescription_case_00413_bessel_kv                (void);
const TestCaseDescription& TestCaseDescription_case_00414_bessel_yv                (void);
const TestCaseDescription& TestCaseDescription_case_00415_bessel_jv_negative_v     (void);
const TestCaseDescription& TestCaseDescription_case_00416_bessel_yv_negative_v     (void);
const TestCaseDescription& TestCaseDescription_case_00421_bessel_iv_medium_v       (void);
const TestCaseDescription& TestCaseDescription_case_00422_bessel_jv_medium_v       (void);
const TestCaseDescription& TestCaseDescription_case_00423_bessel_kv_medium_v       (void);
const TestCaseDescription& TestCaseDescription_case_00424_bessel_yv_medium_v       (void);
const TestCaseDescription& TestCaseDescription_case_00431_bessel_iv_small_v_small_x(void);
const TestCaseDescription& TestCaseDescription_case_00432_bessel_jv_small_v_small_x(void);
const TestCaseDescription& TestCaseDescription_case_00433_bessel_kv_small_v_small_x(void);
const TestCaseDescription& TestCaseDescription_case_00434_bessel_yv_small_v_small_x(void);
const TestCaseDescription& TestCaseDescription_case_00441_bessel_jv_zeros          (void);
const TestCaseDescription& TestCaseDescription_case_00442_bessel_jn_zeros          (void);
const TestCaseDescription& TestCaseDescription_case_00443_bessel_jv_small_v_zeros  (void);
const TestCaseDescription& TestCaseDescription_case_00451_bessel_in                (void);
const TestCaseDescription& TestCaseDescription_case_00452_bessel_jn                (void);
const TestCaseDescription& TestCaseDescription_case_00453_bessel_kn                (void);
const TestCaseDescription& TestCaseDescription_case_00454_bessel_yn                (void);
const TestCaseDescription& TestCaseDescription_case_00460_bessel_jv_yv_asymp       (void);
const TestCaseDescription& TestCaseDescription_case_00461_bessel_jv_asymp          (void);
const TestCaseDescription& TestCaseDescription_case_00462_bessel_yv_asymp          (void);
const TestCaseDescription& TestCaseDescription_case_00463_bessel_iv_kv_asymp       (void);
const TestCaseDescription& TestCaseDescription_case_00471_bessel_jn_asymp          (void);
const TestCaseDescription& TestCaseDescription_case_00472_bessel_yn_asymp          (void);
const TestCaseDescription& TestCaseDescription_case_00481_bessel_iv_at_v_1_3       (void);
const TestCaseDescription& TestCaseDescription_case_00482_bessel_jv_at_v_1_3       (void);
const TestCaseDescription& TestCaseDescription_case_00483_bessel_kv_at_v_1_3       (void);
const TestCaseDescription& TestCaseDescription_case_00484_bessel_yv_at_v_1_3       (void);
const TestCaseDescription& TestCaseDescription_case_00486_bessel_iv_at_v_301_3     (void);
const TestCaseDescription& TestCaseDescription_case_00487_bessel_jv_at_v_301_3     (void);
const TestCaseDescription& TestCaseDescription_case_00488_bessel_kv_at_v_301_3     (void);
const TestCaseDescription& TestCaseDescription_case_00489_bessel_yv_at_v_301_3     (void);
const TestCaseDescription& TestCaseDescription_case_00491_bessel_iv_large_x        (void);
const TestCaseDescription& TestCaseDescription_case_00492_bessel_jv_large_x        (void);
const TestCaseDescription& TestCaseDescription_case_00493_bessel_kv_large_x        (void);
const TestCaseDescription& TestCaseDescription_case_00494_bessel_yv_large_x        (void);
const TestCaseDescription& TestCaseDescription_case_00501_bessel_iv_order0_v       (void);
const TestCaseDescription& TestCaseDescription_case_00502_bessel_jv_order0_v       (void);
const TestCaseDescription& TestCaseDescription_case_00503_bessel_kv_order0_v       (void);
const TestCaseDescription& TestCaseDescription_case_00504_bessel_yv_order0_v       (void);
const TestCaseDescription& TestCaseDescription_case_00511_bessel_iv_order1_v       (void);
const TestCaseDescription& TestCaseDescription_case_00512_bessel_jv_order1_v       (void);
const TestCaseDescription& TestCaseDescription_case_00513_bessel_kv_order1_v       (void);
const TestCaseDescription& TestCaseDescription_case_00514_bessel_yv_order1_v       (void);
const TestCaseDescription& TestCaseDescription_case_00521_bessel_iv_order2_v       (void);
const TestCaseDescription& TestCaseDescription_case_00522_bessel_jv_order2_v       (void);
const TestCaseDescription& TestCaseDescription_case_00523_bessel_kv_order2_v       (void);
const TestCaseDescription& TestCaseDescription_case_00524_bessel_yv_order2_v       (void);
const TestCaseDescription& TestCaseDescription_case_00531_bessel_iv_order3_v       (void);
const TestCaseDescription& TestCaseDescription_case_00532_bessel_jv_order3_v       (void);
const TestCaseDescription& TestCaseDescription_case_00533_bessel_kv_order3_v       (void);
const TestCaseDescription& TestCaseDescription_case_00534_bessel_yv_order3_v       (void);
const TestCaseDescription& TestCaseDescription_case_00541_bessel_iv_order4_v       (void);
const TestCaseDescription& TestCaseDescription_case_00542_bessel_jv_order4_v       (void);
const TestCaseDescription& TestCaseDescription_case_00543_bessel_kv_order4_v       (void);
const TestCaseDescription& TestCaseDescription_case_00544_bessel_yv_order4_v       (void);
const TestCaseDescription& TestCaseDescription_case_00551_various_bessel           (void);
const TestCaseDescription& TestCaseDescription_case_00571_airy_ai                  (void);
const TestCaseDescription& TestCaseDescription_case_00572_airy_ai_prime            (void);
const TestCaseDescription& TestCaseDescription_case_00573_airy_bi                  (void);
const TestCaseDescription& TestCaseDescription_case_00574_airy_bi_prime            (void);
const TestCaseDescription& TestCaseDescription_case_00581_airy_ai_small_x          (void);
const TestCaseDescription& TestCaseDescription_case_00582_airy_ai_prime_small_x    (void);
const TestCaseDescription& TestCaseDescription_case_00583_airy_bi_small_x          (void);
const TestCaseDescription& TestCaseDescription_case_00584_airy_bi_prime_small_x    (void);
const TestCaseDescription& TestCaseDescription_case_00591_airy_ai_zeros            (void);
const TestCaseDescription& TestCaseDescription_case_00592_airy_bi_zeros            (void);
const TestCaseDescription& TestCaseDescription_case_00601_legendre_pvu_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00602_legendre_pvu_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00603_legendre_pvu_vary_03     (void);
const TestCaseDescription& TestCaseDescription_case_00604_legendre_pvu_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00605_legendre_pvu_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00606_legendre_pvu_vary_06     (void);
const TestCaseDescription& TestCaseDescription_case_00607_legendre_pvu_vary_07     (void);
const TestCaseDescription& TestCaseDescription_case_00608_legendre_pvu_vary_08     (void);
const TestCaseDescription& TestCaseDescription_case_00609_legendre_pvu_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00610_legendre_pvu_vary_10     (void);
const TestCaseDescription& TestCaseDescription_case_00611_legendre_pvu_vary_11     (void);
const TestCaseDescription& TestCaseDescription_case_00612_legendre_pvu_vary_12     (void);
const TestCaseDescription& TestCaseDescription_case_00613_legendre_pvu_vary_13     (void);
const TestCaseDescription& TestCaseDescription_case_00614_legendre_pvu_vary_14     (void);
const TestCaseDescription& TestCaseDescription_case_00615_legendre_pvu_vary_15     (void);
const TestCaseDescription& TestCaseDescription_case_00616_legendre_pvu_vary_16     (void);
const TestCaseDescription& TestCaseDescription_case_00621_legendre_qvu_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00622_legendre_qvu_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00623_legendre_qvu_vary_03     (void);
const TestCaseDescription& TestCaseDescription_case_00624_legendre_qvu_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00625_legendre_qvu_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00626_legendre_qvu_vary_06     (void);
const TestCaseDescription& TestCaseDescription_case_00627_legendre_qvu_vary_07     (void);
const TestCaseDescription& TestCaseDescription_case_00628_legendre_qvu_vary_08     (void);
const TestCaseDescription& TestCaseDescription_case_00629_legendre_qvu_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00630_legendre_qvu_vary_10     (void);
const TestCaseDescription& TestCaseDescription_case_00631_legendre_qvu_vary_11     (void);
const TestCaseDescription& TestCaseDescription_case_00632_legendre_qvu_vary_12     (void);
const TestCaseDescription& TestCaseDescription_case_00633_legendre_qvu_vary_13     (void);
const TestCaseDescription& TestCaseDescription_case_00634_legendre_qvu_vary_14     (void);
const TestCaseDescription& TestCaseDescription_case_00635_legendre_qvu_vary_15     (void);
const TestCaseDescription& TestCaseDescription_case_00636_legendre_qvu_vary_16     (void);
const TestCaseDescription& TestCaseDescription_case_00641_legendre_pvm_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00642_legendre_pvm_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00644_legendre_pvm_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00645_legendre_pvm_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00648_legendre_pvm_vary_08     (void);
const TestCaseDescription& TestCaseDescription_case_00649_legendre_pvm_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00652_legendre_pvm_vary_12     (void);
const TestCaseDescription& TestCaseDescription_case_00653_legendre_pvm_vary_13     (void);
const TestCaseDescription& TestCaseDescription_case_00656_legendre_pvm_vary_16     (void);
const TestCaseDescription& TestCaseDescription_case_00661_legendre_qvm_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00662_legendre_qvm_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00664_legendre_qvm_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00665_legendre_qvm_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00668_legendre_qvm_vary_08     (void);
const TestCaseDescription& TestCaseDescription_case_00669_legendre_qvm_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00672_legendre_qvm_vary_12     (void);
const TestCaseDescription& TestCaseDescription_case_00673_legendre_qvm_vary_13     (void);
const TestCaseDescription& TestCaseDescription_case_00676_legendre_qvm_vary_16     (void);
const TestCaseDescription& TestCaseDescription_case_00681_legendre_pnu_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00682_legendre_pnu_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00683_legendre_pnu_vary_03     (void);
const TestCaseDescription& TestCaseDescription_case_00684_legendre_pnu_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00685_legendre_pnu_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00689_legendre_pnu_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00691_legendre_qnu_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00692_legendre_qnu_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00693_legendre_qnu_vary_03     (void);
const TestCaseDescription& TestCaseDescription_case_00694_legendre_qnu_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00695_legendre_qnu_vary_05     (void);
const TestCaseDescription& TestCaseDescription_case_00699_legendre_qnu_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00701_legendre_pnm_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00702_legendre_pnm_vary_02     (void);
const TestCaseDescription& TestCaseDescription_case_00703_legendre_pnm_vary_03     (void);
const TestCaseDescription& TestCaseDescription_case_00704_legendre_pnm_vary_04     (void);
const TestCaseDescription& TestCaseDescription_case_00709_legendre_pnm_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00721_legendre_qnm_vary_01     (void);
const TestCaseDescription& TestCaseDescription_case_00729_legendre_qnm_vary_09     (void);
const TestCaseDescription& TestCaseDescription_case_00733_legendre_qnm_vary_13     (void);
const TestCaseDescription& TestCaseDescription_case_00741_legendre_pv_vary_01      (void);
const TestCaseDescription& TestCaseDescription_case_00742_legendre_pv_vary_02      (void);
const TestCaseDescription& TestCaseDescription_case_00751_legendre_qv_vary_01      (void);
const TestCaseDescription& TestCaseDescription_case_00752_legendre_qv_vary_02      (void);
const TestCaseDescription& TestCaseDescription_case_00761_various_legendre_pnm_qnm (void);
const TestCaseDescription& TestCaseDescription_case_00771_legendre_pvu_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00772_legendre_pvm_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00773_legendre_pnm_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00781_legendre_qvu_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00782_legendre_qvm_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00783_legendre_qnm_zero_x      (void);
const TestCaseDescription& TestCaseDescription_case_00788_legendre_qvm_tiny_x      (void);
const TestCaseDescription& TestCaseDescription_case_00791_legendre_pv_zero_x       (void);
const TestCaseDescription& TestCaseDescription_case_00792_legendre_qv_zero_x       (void);
const TestCaseDescription& TestCaseDescription_case_00801_conf_hyperg_vary1_mpx    (void);
const TestCaseDescription& TestCaseDescription_case_00802_conf_hyperg_vary2_mpx    (void);
const TestCaseDescription& TestCaseDescription_case_00803_conf_hyperg_vary3_mpx    (void);
const TestCaseDescription& TestCaseDescription_case_00804_conf_hyperg_vary4_mpx    (void);
const TestCaseDescription& TestCaseDescription_case_00811_conf_hyperg_vary1_mnx    (void);
const TestCaseDescription& TestCaseDescription_case_00821_conf_hyperg_pos_x        (void);
const TestCaseDescription& TestCaseDescription_case_00826_various_conf_hyperg      (void);
const TestCaseDescription& TestCaseDescription_case_00831_laguerre_vary1_mpx       (void);
const TestCaseDescription& TestCaseDescription_case_00832_laguerre_vary2_mpx       (void);
const TestCaseDescription& TestCaseDescription_case_00833_laguerre_vary3_mpx       (void);
const TestCaseDescription& TestCaseDescription_case_00834_laguerre_vary4_mpx       (void);
const TestCaseDescription& TestCaseDescription_case_00835_various_laguerre         (void);
const TestCaseDescription& TestCaseDescription_case_00851_weber_d_pos_x_pos_v      (void);
const TestCaseDescription& TestCaseDescription_case_00852_weber_d_neg_x_neg_v      (void);
const TestCaseDescription& TestCaseDescription_case_00853_weber_d_neg_x_pos_v      (void);
const TestCaseDescription& TestCaseDescription_case_00854_weber_d_pos_x_neg_v      (void);
const TestCaseDescription& TestCaseDescription_case_00855_weber_d_med_x_med_v      (void);
const TestCaseDescription& TestCaseDescription_case_00861_weber_d_asymp_v          (void);
const TestCaseDescription& TestCaseDescription_case_00871_hermite_pos_x_pos_v      (void);
const TestCaseDescription& TestCaseDescription_case_00901_zeta_small_x             (void);
const TestCaseDescription& TestCaseDescription_case_00902_zeta_all_x               (void);
const TestCaseDescription& TestCaseDescription_case_00903_zeta_neg_x               (void);
const TestCaseDescription& TestCaseDescription_case_00931_hurw_zeta_all_x_small_a  (void);
const TestCaseDescription& TestCaseDescription_case_00932_hurw_zeta_all_x_large_a  (void);
const TestCaseDescription& TestCaseDescription_case_00936_various_hurw_zeta        (void);
const TestCaseDescription& TestCaseDescription_case_00951_polylog_med_x_med_pos_n  (void);
const TestCaseDescription& TestCaseDescription_case_00952_polylog_med_x_small_pos_n(void);
const TestCaseDescription& TestCaseDescription_case_00953_polylog_neg_x_pos_n      (void);
const TestCaseDescription& TestCaseDescription_case_00954_polylog_neg_x_neg_n      (void);
const TestCaseDescription& TestCaseDescription_case_00955_polylog_pos_x_neg_n      (void);
const TestCaseDescription& TestCaseDescription_case_00956_polylog_x_small_neg_n    (void);
const TestCaseDescription& TestCaseDescription_case_00957_polylog_x_large_neg_n    (void);
const TestCaseDescription& TestCaseDescription_case_00958_polylog_x_one_neg_n      (void);
const TestCaseDescription& TestCaseDescription_case_01001_comp_ellint_1            (void);
const TestCaseDescription& TestCaseDescription_case_01002_ellint_1                 (void);
const TestCaseDescription& TestCaseDescription_case_01003_comp_ellint_2            (void);
const TestCaseDescription& TestCaseDescription_case_01004_ellint_2                 (void);
const TestCaseDescription& TestCaseDescription_case_01021_poly_legendre_p          (void);
const TestCaseDescription& TestCaseDescription_case_01022_poly_legendre_q          (void);
const TestCaseDescription& TestCaseDescription_case_01023_poly_chebyshev_t         (void);
const TestCaseDescription& TestCaseDescription_case_01024_poly_chebyshev_u         (void);
const TestCaseDescription& TestCaseDescription_case_01025_poly_hermite_h           (void);
const TestCaseDescription& TestCaseDescription_case_01026_poly_laguerre_l          (void);
const TestCaseDescription& TestCaseDescription_case_01027_various_poly_legendre_p  (void);
const TestCaseDescription& TestCaseDescription_case_01028_various_poly             (void);
const TestCaseDescription& TestCaseDescription_case_02101_z_sin                    (void);
const TestCaseDescription& TestCaseDescription_case_02102_z_cos                    (void);
const TestCaseDescription& TestCaseDescription_case_02103_z_exp                    (void);
const TestCaseDescription& TestCaseDescription_case_02104_z_log                    (void);
const TestCaseDescription& TestCaseDescription_case_02105_z_sqrt                   (void);
const TestCaseDescription& TestCaseDescription_case_02106_z_rootn                  (void);
const TestCaseDescription& TestCaseDescription_case_02111_z_asin                   (void);
const TestCaseDescription& TestCaseDescription_case_02112_z_acos                   (void);
const TestCaseDescription& TestCaseDescription_case_02113_z_atan                   (void);
const TestCaseDescription& TestCaseDescription_case_02114_z_various_trig           (void);
const TestCaseDescription& TestCaseDescription_case_02115_z_various_elem_trans_log (void);
const TestCaseDescription& TestCaseDescription_case_02116_z_various_elem           (void);
const TestCaseDescription& TestCaseDescription_case_02121_z_sinh                   (void);
const TestCaseDescription& TestCaseDescription_case_02122_z_cosh                   (void);
const TestCaseDescription& TestCaseDescription_case_02123_z_tanh                   (void);
const TestCaseDescription& TestCaseDescription_case_02124_z_asinh                  (void);
const TestCaseDescription& TestCaseDescription_case_02125_z_acosh                  (void);
const TestCaseDescription& TestCaseDescription_case_02126_z_atanh                  (void);
const TestCaseDescription& TestCaseDescription_case_02201_z_gamma                  (void);
const TestCaseDescription& TestCaseDescription_case_02202_z_gamma_medium_x         (void);
const TestCaseDescription& TestCaseDescription_case_02901_z_zeta_small_x           (void);
const TestCaseDescription& TestCaseDescription_case_02902_z_zeta_all_x             (void);
const TestCaseDescription& TestCaseDescription_case_02903_z_zeta_neg_x             (void);
const TestCaseDescription& TestCaseDescription_case_02911_z_zeta_crit_strip        (void);
const TestCaseDescription& TestCaseDescription_case_02931_z_hurw_zeta_all_x_small_a(void);
const TestCaseDescription& TestCaseDescription_case_02932_z_hurw_zeta_all_x_large_a(void);
const TestCaseDescription& TestCaseDescription_case_02936_z_various_hurw_zeta      (void);
const TestCaseDescription& TestCaseDescription_case_03023_z_poly_chebyshev_t       (void);
const TestCaseDescription& TestCaseDescription_case_03024_z_poly_chebyshev_u       (void);
const TestCaseDescription& TestCaseDescription_case_03025_z_poly_hermite_h         (void);
const TestCaseDescription& TestCaseDescription_case_03026_z_poly_laguerre_l        (void);

namespace
{
  static void GenerateAllTestCases(void)
  {
    ::TestCaseGenerator(::TestCaseDescription_case_00011_various_elem_math        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00021_bernoulli                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00022_euler                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00023_stirling2                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00051_factorial                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00052_factorial2               ());
    ::TestCaseGenerator(::TestCaseDescription_case_00071_various_int_func         ());
    ::TestCaseGenerator(::TestCaseDescription_case_00101_sin                      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00102_cos                      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00103_exp                      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00104_log                      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00105_sqrt                     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00106_rootn                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00111_sin_small_x              ());
    ::TestCaseGenerator(::TestCaseDescription_case_00112_cos_x_near_pi_half       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00113_atan_x_small_to_large    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00114_various_trig             ());
    ::TestCaseGenerator(::TestCaseDescription_case_00115_various_elem_trans       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00121_sinh                     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00122_cosh                     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00123_tanh                     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00124_asinh                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00125_acosh                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00126_atanh                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00201_gamma                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00202_gamma_medium_x           ());
    ::TestCaseGenerator(::TestCaseDescription_case_00203_gamma_small_x            ());
    ::TestCaseGenerator(::TestCaseDescription_case_00204_gamma_tiny_x             ());
    ::TestCaseGenerator(::TestCaseDescription_case_00205_gamma_near_neg_n         ());
    ::TestCaseGenerator(::TestCaseDescription_case_00221_various_gamma_func       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00307_polygamma                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00308_polygamma_fixed_n        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00411_bessel_iv                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00412_bessel_jv                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00413_bessel_kv                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00414_bessel_yv                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00415_bessel_jv_negative_v     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00416_bessel_yv_negative_v     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00421_bessel_iv_medium_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00422_bessel_jv_medium_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00423_bessel_kv_medium_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00424_bessel_yv_medium_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00431_bessel_iv_small_v_small_x());
    ::TestCaseGenerator(::TestCaseDescription_case_00432_bessel_jv_small_v_small_x());
    ::TestCaseGenerator(::TestCaseDescription_case_00433_bessel_kv_small_v_small_x());
    ::TestCaseGenerator(::TestCaseDescription_case_00434_bessel_yv_small_v_small_x());
    ::TestCaseGenerator(::TestCaseDescription_case_00441_bessel_jv_zeros          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00442_bessel_jn_zeros          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00443_bessel_jv_small_v_zeros  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00451_bessel_in                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00452_bessel_jn                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00453_bessel_kn                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00454_bessel_yn                ());
    ::TestCaseGenerator(::TestCaseDescription_case_00460_bessel_jv_yv_asymp       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00461_bessel_jv_asymp          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00462_bessel_yv_asymp          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00463_bessel_iv_kv_asymp       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00471_bessel_jn_asymp          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00472_bessel_yn_asymp          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00481_bessel_iv_at_v_1_3       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00482_bessel_jv_at_v_1_3       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00483_bessel_kv_at_v_1_3       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00484_bessel_yv_at_v_1_3       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00486_bessel_iv_at_v_301_3     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00487_bessel_jv_at_v_301_3     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00488_bessel_kv_at_v_301_3     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00489_bessel_yv_at_v_301_3     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00491_bessel_iv_large_x        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00492_bessel_jv_large_x        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00493_bessel_kv_large_x        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00494_bessel_yv_large_x        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00501_bessel_iv_order0_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00502_bessel_jv_order0_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00503_bessel_kv_order0_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00504_bessel_yv_order0_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00511_bessel_iv_order1_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00512_bessel_jv_order1_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00513_bessel_kv_order1_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00514_bessel_yv_order1_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00521_bessel_iv_order2_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00522_bessel_jv_order2_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00523_bessel_kv_order2_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00524_bessel_yv_order2_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00531_bessel_iv_order3_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00532_bessel_jv_order3_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00533_bessel_kv_order3_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00534_bessel_yv_order3_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00541_bessel_iv_order4_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00542_bessel_jv_order4_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00543_bessel_kv_order4_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00544_bessel_yv_order4_v       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00551_various_bessel           ());
    ::TestCaseGenerator(::TestCaseDescription_case_00571_airy_ai                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00572_airy_ai_prime            ());
    ::TestCaseGenerator(::TestCaseDescription_case_00573_airy_bi                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00574_airy_bi_prime            ());
    ::TestCaseGenerator(::TestCaseDescription_case_00581_airy_ai_small_x          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00582_airy_ai_prime_small_x    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00583_airy_bi_small_x          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00584_airy_bi_prime_small_x    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00591_airy_ai_zeros            ());
    ::TestCaseGenerator(::TestCaseDescription_case_00592_airy_bi_zeros            ());
    ::TestCaseGenerator(::TestCaseDescription_case_00601_legendre_pvu_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00602_legendre_pvu_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00603_legendre_pvu_vary_03     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00604_legendre_pvu_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00605_legendre_pvu_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00606_legendre_pvu_vary_06     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00607_legendre_pvu_vary_07     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00608_legendre_pvu_vary_08     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00609_legendre_pvu_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00610_legendre_pvu_vary_10     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00611_legendre_pvu_vary_11     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00612_legendre_pvu_vary_12     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00613_legendre_pvu_vary_13     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00614_legendre_pvu_vary_14     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00615_legendre_pvu_vary_15     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00616_legendre_pvu_vary_16     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00621_legendre_qvu_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00622_legendre_qvu_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00623_legendre_qvu_vary_03     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00624_legendre_qvu_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00625_legendre_qvu_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00626_legendre_qvu_vary_06     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00627_legendre_qvu_vary_07     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00628_legendre_qvu_vary_08     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00629_legendre_qvu_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00630_legendre_qvu_vary_10     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00631_legendre_qvu_vary_11     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00632_legendre_qvu_vary_12     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00633_legendre_qvu_vary_13     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00634_legendre_qvu_vary_14     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00635_legendre_qvu_vary_15     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00636_legendre_qvu_vary_16     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00641_legendre_pvm_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00642_legendre_pvm_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00644_legendre_pvm_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00645_legendre_pvm_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00648_legendre_pvm_vary_08     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00649_legendre_pvm_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00652_legendre_pvm_vary_12     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00653_legendre_pvm_vary_13     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00656_legendre_pvm_vary_16     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00661_legendre_qvm_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00662_legendre_qvm_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00664_legendre_qvm_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00665_legendre_qvm_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00668_legendre_qvm_vary_08     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00669_legendre_qvm_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00672_legendre_qvm_vary_12     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00673_legendre_qvm_vary_13     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00676_legendre_qvm_vary_16     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00681_legendre_pnu_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00682_legendre_pnu_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00683_legendre_pnu_vary_03     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00684_legendre_pnu_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00685_legendre_pnu_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00689_legendre_pnu_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00691_legendre_qnu_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00692_legendre_qnu_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00693_legendre_qnu_vary_03     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00694_legendre_qnu_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00695_legendre_qnu_vary_05     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00699_legendre_qnu_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00701_legendre_pnm_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00702_legendre_pnm_vary_02     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00703_legendre_pnm_vary_03     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00704_legendre_pnm_vary_04     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00709_legendre_pnm_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00721_legendre_qnm_vary_01     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00729_legendre_qnm_vary_09     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00733_legendre_qnm_vary_13     ());
    ::TestCaseGenerator(::TestCaseDescription_case_00741_legendre_pv_vary_01      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00742_legendre_pv_vary_02      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00751_legendre_qv_vary_01      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00752_legendre_qv_vary_02      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00761_various_legendre_pnm_qnm ());
    ::TestCaseGenerator(::TestCaseDescription_case_00771_legendre_pvu_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00772_legendre_pvm_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00773_legendre_pnm_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00781_legendre_qvu_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00782_legendre_qvm_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00783_legendre_qnm_zero_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00788_legendre_qvm_tiny_x      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00791_legendre_pv_zero_x       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00792_legendre_qv_zero_x       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00801_conf_hyperg_vary1_mpx    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00802_conf_hyperg_vary2_mpx    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00803_conf_hyperg_vary3_mpx    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00804_conf_hyperg_vary4_mpx    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00811_conf_hyperg_vary1_mnx    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00821_conf_hyperg_pos_x        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00826_various_conf_hyperg      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00831_laguerre_vary1_mpx       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00832_laguerre_vary2_mpx       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00833_laguerre_vary3_mpx       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00834_laguerre_vary4_mpx       ());
    ::TestCaseGenerator(::TestCaseDescription_case_00835_various_laguerre         ());
    ::TestCaseGenerator(::TestCaseDescription_case_00851_weber_d_pos_x_pos_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00852_weber_d_neg_x_neg_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00853_weber_d_neg_x_pos_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00854_weber_d_pos_x_neg_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00855_weber_d_med_x_med_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00861_weber_d_asymp_v          ());
    ::TestCaseGenerator(::TestCaseDescription_case_00871_hermite_pos_x_pos_v      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00901_zeta_small_x             ());
    ::TestCaseGenerator(::TestCaseDescription_case_00902_zeta_all_x               ());
    ::TestCaseGenerator(::TestCaseDescription_case_00903_zeta_neg_x               ());
    ::TestCaseGenerator(::TestCaseDescription_case_00931_hurw_zeta_all_x_small_a  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00932_hurw_zeta_all_x_large_a  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00936_various_hurw_zeta        ());
    ::TestCaseGenerator(::TestCaseDescription_case_00951_polylog_med_x_med_pos_n  ());
    ::TestCaseGenerator(::TestCaseDescription_case_00952_polylog_med_x_small_pos_n());
    ::TestCaseGenerator(::TestCaseDescription_case_00953_polylog_neg_x_pos_n      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00954_polylog_neg_x_neg_n      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00955_polylog_pos_x_neg_n      ());
    ::TestCaseGenerator(::TestCaseDescription_case_00956_polylog_x_small_neg_n    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00957_polylog_x_large_neg_n    ());
    ::TestCaseGenerator(::TestCaseDescription_case_00958_polylog_x_one_neg_n      ());
    ::TestCaseGenerator(::TestCaseDescription_case_01001_comp_ellint_1            ());
    ::TestCaseGenerator(::TestCaseDescription_case_01002_ellint_1                 ());
    ::TestCaseGenerator(::TestCaseDescription_case_01003_comp_ellint_2            ());
    ::TestCaseGenerator(::TestCaseDescription_case_01004_ellint_2                 ());
    ::TestCaseGenerator(::TestCaseDescription_case_01021_poly_legendre_p          ());
    ::TestCaseGenerator(::TestCaseDescription_case_01022_poly_legendre_q          ());
    ::TestCaseGenerator(::TestCaseDescription_case_01023_poly_chebyshev_t         ());
    ::TestCaseGenerator(::TestCaseDescription_case_01024_poly_chebyshev_u         ());
    ::TestCaseGenerator(::TestCaseDescription_case_01025_poly_hermite_h           ());
    ::TestCaseGenerator(::TestCaseDescription_case_01026_poly_laguerre_l          ());
    ::TestCaseGenerator(::TestCaseDescription_case_01027_various_poly_legendre_p  ());
    ::TestCaseGenerator(::TestCaseDescription_case_01028_various_poly             ());
    ::TestCaseGenerator(::TestCaseDescription_case_02101_z_sin                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_02102_z_cos                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_02103_z_exp                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_02104_z_log                    ());
    ::TestCaseGenerator(::TestCaseDescription_case_02105_z_sqrt                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02106_z_rootn                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_02111_z_asin                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02112_z_acos                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02113_z_atan                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02114_z_various_trig           ());
    ::TestCaseGenerator(::TestCaseDescription_case_02115_z_various_elem_trans_log ());
    ::TestCaseGenerator(::TestCaseDescription_case_02116_z_various_elem           ());
    ::TestCaseGenerator(::TestCaseDescription_case_02121_z_sinh                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02122_z_cosh                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02123_z_tanh                   ());
    ::TestCaseGenerator(::TestCaseDescription_case_02124_z_asinh                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_02125_z_acosh                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_02126_z_atanh                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_02201_z_gamma                  ());
    ::TestCaseGenerator(::TestCaseDescription_case_02202_z_gamma_medium_x         ());
    ::TestCaseGenerator(::TestCaseDescription_case_02901_z_zeta_small_x           ());
    ::TestCaseGenerator(::TestCaseDescription_case_02902_z_zeta_all_x             ());
    ::TestCaseGenerator(::TestCaseDescription_case_02903_z_zeta_neg_x             ());
    ::TestCaseGenerator(::TestCaseDescription_case_02911_z_zeta_crit_strip        ());
    ::TestCaseGenerator(::TestCaseDescription_case_02931_z_hurw_zeta_all_x_small_a());
    ::TestCaseGenerator(::TestCaseDescription_case_02932_z_hurw_zeta_all_x_large_a());
    ::TestCaseGenerator(::TestCaseDescription_case_02936_z_various_hurw_zeta      ());
    ::TestCaseGenerator(::TestCaseDescription_case_03023_z_poly_chebyshev_t       ());
    ::TestCaseGenerator(::TestCaseDescription_case_03024_z_poly_chebyshev_u       ());
    ::TestCaseGenerator(::TestCaseDescription_case_03025_z_poly_hermite_h         ());
    ::TestCaseGenerator(::TestCaseDescription_case_03026_z_poly_laguerre_l        ());
  }
}

int main(int, char**)
{
  const ::clock_t start = ::clock();

  ::GenerateAllTestCases();

  const double elapsed = static_cast<double>(::clock() - start) / static_cast<double>(CLOCKS_PER_SEC);
  std::cout << "Elapsed time: " << elapsed << " (seconds)" << std::endl;
}
