
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00582_airy_ai_prime_small_x : public TestCaseReal
    {
    public:
      TestCase_case_00582_airy_ai_prime_small_x() { }
      virtual ~TestCase_case_00582_airy_ai_prime_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00582_airy_ai_prime_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_a_prime(((e_float(k) / 5) - 10) * ef::euler_gamma());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.71402639122585449192565409280719105635484250458427104462000490743380128903596562898114846393457621578157965953976213518071794791598424651553384905057119451077431178529356039443562802347012237995488799493191042344265717131054282240445217887395653983873723323367958013558041177271929798933286991781901213782324637748222351178556152804954721981055067206911927364659839868481030745173749968185760493974685"),
           e_float("0.8205914414586431899300917430097243342427600620572335519969527116042359043150220172457462441816870891228379205079660184013135941521569139875807630177021600855992952534225120175807290193792056404201713240663512197806500593619948219877986880339069892222097291788644470127759158394544244510560962209267919733897099090023454339019847904488237204915490583386230874582671361309898040419099087105311339156367"),
           e_float("0.86417730102336763629649897451337950080747672015102336636259205863370344351433566325576767803465427831500396123808372435313487646817079696457808437350563990636901712823815737908964330947956023294859816835641886431212278323813784534085380898301276028848704784930488938336126384012971952932119325768529422552477745929493810817479598413482843541760007137271594185821458207656301709838950394063322834793806"),
           e_float("0.84410336339326205166826292525961357682079365934871119821308999132514933637536273163411985674150093041949476293581012411822668939662299299733242397873603522361759886276478453770246916638985936475722276415543228229755126540026518121521297088112443707849069157757133625183971146617799205059355378816391528183163677125106812031049032521617608714974140539622038763340869126876213554602399082202930919596327"),
           e_float("0.76441618942260825630493069251784452376626897787332889214783117661643674186876773370391946071498143055490299141011878170412276874961448398916469398796185154137262938734025714828258747717904385650868829026553159628434533741583308315954406462977429001347514840197477133641437165112243360628168162757119005564583235065976533440144341877965105987201869052297212237496149048068476462738727007881266517973049"),
           e_float("0.63322139164393797789707517657212862058616488684475683337262697172353848782457445377492859851143043965844282032862561027094281083258018338005498683436805491527511654831263033218289052951669385197510669200013548802129022207783045005162007625705523168318169694404713545993263234806717680713413485180253369163234360594925302685264192394685085950433426891880979022598561841367973443849623909738370889716416"),
           e_float("0.46176961875501055249809961928040039057727151754906365495065769159388783440045376177634506170061250969893040006324718748818680184293709176484509630512150441909054967622808082148110805435496833276901316204159375113872538212987119194921590401996958861333734985954001356299304834807120640493338504461400406930373294019437921322709409177649706554429286287239231877759798420048297775496166140925295081844859"),
           e_float("0.26339451786827958603916921697477999284453186798978362737404080441801049227607783535059020131439471594916164759991249967375760795682544997237042578250779453259112075831805712092958385429359730692442012299116112657150207000081656523375044159545484703456514670782773023370492348421680019615061989680379756572599472273014846106159478097429575811638617928936972708260508612700239761880039302873812402323378"),
           e_float("0.052400488864377002663795973045205853814229237657693165567642100372142167860398327710207540151738509657014867475307213071561891020084036552027282797917074957618458961058478064314914902930897228314195029369793729743793981683371574513039634564817374113088772237205922884533666541427298158312699284010795722707564202890894136204122663160580610284513665246064909991924420022793738195114561546586964908138062"),
           e_float("-0.15701004309663739114413719841898568866570759005537118392608481625476434373264520298805511982821100036144030824089154085526518621699493784571197738448427269415234918972725990536258666255510634585530164759177626639811574915487426170403314804451390866524252586926001523449176314644114744399416219112653603527757895068182017903366259965434106910422471668077450087823460809461579879216116059556957129846845"),
           e_float("-0.35169438562236225297319417091947761893998576780856251910332162240011067374975170464388989229004005645019934550234184028046842090504061568033027668525703246447509788269651735882179565109799943837958838620665935835908661768519451457158137534933125609749482039658308639723619304109932892271135970083591084733330155253596860768387479130799112080550938547500397004352501590549537407770977769237244335316403"),
           e_float("-0.52035528621174776986412307318262695949538989762336567691463633292846745503805422629010873037416604697545255399755820742089244308954720282903168892356925715943622945361318150336428938185095592248464034107575191276517188713823921038072248476806257192323606584561924725025829689470189225117615983072612800298055364397348978053413078453483603246162507862925631023929054615233144972323370892873044683342362"),
           e_float("-0.65411785456680740569049612637122431463125725904872812631605886098696188196747648822800425165398555697660263430615123407447370382121561476993959170293983838984333372223102211888186656924608032840617750452449894701047672440941497792598217981879141196666410151636617535776429184377174716677475218853685460353693249941623448302518939688752080289628729676766602867834462440276539995089792386734207842398632"),
           e_float("-0.74688133906886926310171858009311311322542229479763513948976443830877646543954795106358308039605746508954485575869505382238939955320507786101954475154722554704101553234679343822727005623003644409011760194284091107173894705382654441135609786679786884051828110550125074586839392489046521155345817993421891294231522397459603516727460337381294475113991360247944637773092236745721680368400425325793828663645"),
           e_float("-0.79544814945164771785147584956339570006180878747665642266454634629078652506937193651501249317054327922146674877435853130175662438484007994952994736383405908216046629962251558498329553412430134017332830533766392820832375689122997939751666172636304258626353604689813327432946507582086588966577942333508001425131163508841959840881113569587401873560336155203774975392874193643599383769200665153459403948553"),
           e_float("-0.79944840365660356445795602896276830154291551664274053957944106202405305423155337760909261308637683956907151287914249895027883041002574697775882037057511450197884467440108276046451483217691081697820593989801552657099047552377677604185668367932997037452737064579848307540077899678288040927681855962607725076701669300400893353404091695062946214168738429781949278817791946051146589210334297961982021434351"),
           e_float("-0.76109048544001227965631431905656738930572853419074241629334552594079013906474714591591898719391862418255564734000785037976343194385485657690898205554356125864107053597243261983733481341186710411975314131543599714854366648496334039380542938410213971062298714744736261128184682526748111456437273035621346579552643664839345791645923655018467863653307228285633515908151301079688609375803768095526221008323"),
           e_float("-0.68477625121890310378529339427788185711795994892722784782303522332436210255774670208187168331481687983382051136977435550639080242483307801943265577191551588488298736080608013937504235026770719291650308137872517777707954459493299112733741869027096781889249790727894756104977388702256633143060225345229594448133808288396072917314503524476451926934993269035409171211856003737191329685905260053372319985242"),
           e_float("-0.57662362914031154861546480527735541296439355743111627073347056042761793537430117341612453532912145785236417349592092780482535428485507360222446743885538686747527139904921247237450873567477357474864858261584110401375439724033353730817328291823323991032778489590189013416412256819490537053888691687868828281825419217244933087858592105434007710410346175808236172540720999209955286445593485477836361763506"),
           e_float("-0.44393973999468481483881750834216915243965912941966912005242223108072354125285870610323514448452755376364406972101004178820005006977960953484018350888511928094923416368647163805371006531772873088009487504570111386430106437525990385880864927354209108889442313958106912089368380742552473426356235053777471360785380319418062873071403721270077691841372284546540395219041032586352936416115458258341342933794"),
           e_float("-0.29468490509681777140518367459995473731904382722838869474937123119205032875422427056027366001799063602246840077813593170741859649183850636266247019067454138022216159070395411284206509067639027680135364621674308779734112096048867505194785293911312955505964191184013913847771116881335451535697709531250385775640114028647933807512653276190781566154668833909774476056915853181495207562328526663680992236048"),
           e_float("-0.13696270657274938509377248473318817505058541745234758517775209598016516383030291025161035250966387384084912145590327113335121697524559076726501465875115791092032123547262838073647190046734144412446804603817418329511791801117319442386943021369509787413383610353865356268485061238838948086974523843241349768601755041912630689291093496521305345255482878924821629158264842600668069262761870397610642287014"),
           e_float("0.021435588404859115229142949108905399118498864602856643123589705710400512755088147043758739966294646966050919648769625265396609449023208619993337148448094363735215547716916696931233711180229365514907905444442742472263604856808377645413120169417295465337133331354982904502858786621304317928543762770091317377237122981680946139840562613456739014476759691920169959649768708693585883146640925516978322488328"),
           e_float("0.1734116638900194835142012118306935208410761070644007758525387167877529938282259249465910218405816211698879283534750871861637920620120265859453856414815200282462199008649310399576894695666410303354291774445870242153805533956367225898955571508155574785165248476431122014331137528600507470406720803701088731889017873102221811767033285931873124321534670340072523002810549824773307248808662224031537404125"),
           e_float("0.31285319055998922489602406443088658738890454944726855954764219920213717230130031257968409880440839804871867215202521503218452256615684079140629283966965384849993773935392538204588410278382907577054971799337975586426151808663217691844151928187185818266114181968169982418577147819890852820985115887433102443664665801281383166983665591648572487667748615554759809809205392342714955633624674369127258370429"),
           e_float("0.43483409789611104036286132239153811309873951706501275777951886981623913365835761105461080193274672414256296158311366577573211386953769606503367240649092788731159313301150827947811442057306584437802528728432153395972228507904202515965008008483804356640394512214806325508759351053886920316168015266362660930040037202868225248172737735465510778557092635287870139681969221594279461141384143466451282023531"),
           e_float("0.53572354762477153638289648639883843543642709056577293110480686327203236094452691029766957331980422018477777483136998195254632246058509244033294452495191757061158243805304960468992065591990714034638698063924626525203553124679421431762811090479758213215437535307641263572038553644838820605198504917566660719145758381605442928337520749161280576997910826029347043959324311199609456406225299750637796018632"),
           e_float("0.61321051619027136960505015747666946277460970242923523060093594686260765533904681170666420703463274858442659892928282394128874501163107550919595148620691330905441979343465244112132936806174968054567314464118150963509445758575732540670988047357791085027060956214516284209059385891291099676003225242156377015414252012999905935446157009444890078117302157819471611813250592623053602087935693039720919072904"),
           e_float("0.66625498460488855259841486321293850978342689663163799823939487339561034242252201178925717675306260901509367198802452419237409728252475069639570809611863318012375455708316849308549517033213387506639719076173535541776931988463106648174283423726217996534114117794013075914033176438233442561914411302033337024244413697412227983247582763003258523521590958111862707514628484578151882027863669111152701922808"),
           e_float("0.6949794305782379219005077022765281811736792367172807951303095402625211131948116479871407016544808575006930427475274805637111645009424262061975912271843534871036747359913769836444710110528612375015813133952013519916067256114724829406032213858917526308030031355932930663733219033014499127943688118704551559532432972656156790033406944881134138570088282674819772278091502154740380710201450661417496639482"),
           e_float("0.70051568564502825542098928455947084803576857990952000708329828996120787727290801102736029011248395377750191467478883985103957493788261799258279105567582373829486857470566186245819653325890255937975569731849272800297763910651022096098733309263475643571136422437223352598487202302462922480583959670372318188502562264496209553217927365744385098330627843350674707664493225630863181367307894162462220677207"),
           e_float("0.68482240561132605265919334279145037539252638225272114562563534469764541100894821407375612478040845890358625900705069440516079461915693439212725109562065515122269019481146940231235189565425831495396321102160457246602461827587082911166302564548263460086275917688414791537332382346460894316453194747760308428804936488740945048440418497964262994488100536044056029667217246734314410176968654565559315046038"),
           e_float("0.65048760732396822207289659627078272978482250600844816882757582561345944520339914558398788353370506727149902047655915871029072232839754023901104639555940440903026343531333067393451959756085792745199327192836121646010634480335377161776013698341794245102002957474721043389711149697887722812868939596798961877887423650536008470467912844431600898492589640213098464627177063037420960386791434429517831142565"),
           e_float("0.60052917932312638594335980340621531070328073775796500316275790413039734518400955119475420179732125981090135095087376979174308155737499466244342135014818337816405496410323244152541837105607525500117710406801348563037021874912698594623122309897083619007412509038081229847450872969392672169008461180609469958124004275803056326740994417812482495851247968870122818019647744370110059882167147111658229448717"),
           e_float("0.53820421627092863026167368607650347462194174194813186176331884994817592474860781585972127563624528085734434742398987982604104737585970968302642343552266016586742761033593449399087422582094434350865910267052298820672036639061613259182549810085738235488300803792709633380604843894947004684533905480721899452975061239200183655959185224536875168793266936139129948847371926721779159467210893717136309074116"),
           e_float("0.46683568386311622050014746747963681157563674990892909587907390496164376468687867547930606148599344127762485266667741804173305033394701140906919315868273510749571087255133195060628365058598898046105946594997890391789684402051632780466427010090909003573976743723264472728561640847100622580109444290091249557700267945461823694569971086631844091900003142916647065990629313418178294890754618221446018372115"),
           e_float("0.38966249400732102572801535759902667580415509769124655180281352962581646353918780891797753683717936182306617722996958064920917090787993218729102172740393780968052801459615609353950794416176917983403419065482952459277277226217567673326634264346617901367064099043829249713827342759481449660732609697488771161573987396811623400823984962898115178965575340604632180825641313857697831423089799707729932244775"),
           e_float("0.3097167272030510952509136739706305534773522295021105970677966590300367820420603831246161979064817476373158882908876804841639794665514455439203110147885080634471882912774841253400065662914786055647413401702816290084061340089818728832650324094225524789687087944951174252180136018794228064657973610677996340921086639669826730930625102977247118101277540306812095832679758459906328195931669783147942605322"),
           e_float("0.22972960943831076781126506122132005318154879520743860090452459949347374822978241767158129566634783277112694965239871650432347071638952636672149544273042178907478886996604552863324349673657234848978736939745253542968429598684786870630739494233329920493722675403081065045146294248026244787323611865311952201621647883569655562677701651229600216207443359377039338418770505369835302310015377768183750582623"),
           e_float("0.15206602409969052702965801968478915244153009790824439746010729726878566185877119905810635386309109340060137404621913839319710886814606956306177716796658803415910363591194804353329026145229313715977093011722666209116169061847722455393468548044881864851766707821967715810566817431483547072881702906272294322320271307772861823481555988768754211847888407418742682819441858150393041053867797278452999817841"),
           e_float("0.078685867468482986298876528904851870537337286651304533720290387208909601127882265478803872233609631720956957460651640101215997380479526899799740473134766377023574459300334483212556649530794982598247610091064322674189456561050550474124160023004044178307219270878255447412111876473700812905916432458675651776965072482167544666087832623538387383818240419725248809059098312249420707187958190369685954003169"),
           e_float("0.011129458254990045742935267342601289724210627394040094817963849207502649890432768619153242835561694623054392523105553659623701243378044007675667373206375732152511542105834946705382759003745887389143058544503292166738987362274022588381815145275915850765849799940783870986403202646649460735107170500058728752870903501585254232331836149912473913022560434604000905438584816619354247539185313510959690024937"),
           e_float("-0.049476521263115820893786173775808956589556872596735539238744137347664463824153889248839928030141708688671063992513207325136217285985562936510980327112165544174359777390620015792735662894086630804418531980798515068432698392204605448352732908369628198876552811410030446893347335893550304726802837783580536527130171082962616908042704953371469010156160250092988597501112984646592563698239347458152561849226"),
           e_float("-0.10239647225742416476053664087440724876947315793129557467611254960229582859239071480398729887322050130445261430341915210818604954924627502056312363702016207524071069005224991233700047437460656249344701795216517329871363491707866257922718657349634311661198471419138579969553996377328823885309645932925027672618557144261304338051629573414031182599215408397389869523139737771845893713766805743943552223276"),
           e_float("-0.1472507403781461213859875902444936206172291157497293067503520514535788151017855814060339069470921890655661279617665547063079391008566768868040762260959815239702442093137285556529900546046210864225334158399977644697928674715595150629322416178475889050591741332912959874722434571933989891188265261710284518802614219676968026404501558806573201199398341069498298104726142922111723086571358629167878394762"),
           e_float("-0.18397178449630047973081883593396402466669078170175566071954211487370386985169529749893824226007694732095849725572755848014152384802050441358440883662038626610620003540999319129584892106678551268230561744541152205770846273055596122179731993707199977117268634060597101528383813640220670134209365285923032138018528209900574851127327574484464625632386935273331971394151876308545633643195543348039914829004"),
           e_float("-0.2127552327700820665358534122789602153760992698316008127349125702294910014953226397433624941553117874379478027725548897077999679179882686218838499821939000885948127839211366608868508744916305819069957638841445684155592648917338968256293617913611664005367162407448421599213382779880887790767488069063328982437703655291816103501489653872091036309077168854922045808347022154084252774621144493938765047913"),
           e_float("-0.23400896497867571529877817143336698811130821248145948346758983886172752497300521463174159540941780178367307698403649833009180140247288174005943260268812603066884348491745084310374559686067798429239123903743748782576385645911855082000631346192667981132978717305603649343077895487158644402807849892848233200645654069477910977868179625485847816937401652540775386750053949599762827231007566592118041604353"),
           e_float("-0.24830284390505183507044676787779959500731848398768689706062573111896170670388641195079967627476108012128081504803509632357843377065129402258598578804592688456000241191861388671243095981538130098547496751449878262953512283161093409961769789495600303428893160114864154004035441019519183843736152047454507355159083956565251179622434258901077965675540739051495467495781660193644596182450636315055604698344"),
           e_float("-0.25632117144713082904513912934178081415615958008091022496708172787643012121705966674634714692194505789920578957935760707817069534648026578260274134443972160431620578927758563983097256525628561818073051505053205975650554380534178150054738367291134147838110339621622267844764873065035089824738184896667253027436416207580502748503484638611041086603701468007872029973991096067174430721168517060891831429488"),
           e_float("-0.25881940379280679840518356018920396347909113835493458221000181385610277267679028065419640582727538431337119321178913338127503595216762601478505098984841944663202964488880560187838330512695052512829334249799988357074907925906015895105094432208938405967357771932802510665017017568983657860752558311354781713186204495829272133259132682105203140001182996722445166103044385530003968535953695549959290311145"),
           e_float("-0.25658615274519617471261451414574317297418675622789605180054207615548819635070563985155322336296199123155895023929651355976287813809448354192311601849666399477097873803028164547415890240344226130474832993773399980670367897829763255311275987844471264725525575271739512074918325305791297593074930585623423916954090727668475147586305409382956209720873520251545066726553737845281072468891807285491782230956"),
           e_float("-0.25041104725445764880230936567231387629773518020370361218997655145597891577517275007373779426575145249769143765043658850598765709646951105476817958070835181007589525953956331673859682596668119403457285670813104788702547903972336887988951113492095834586446331297725666759879698533944410596343762775861250826310604860067470618338657200063271164151270528512563397231996061312533415497999967444900933301597"),
           e_float("-0.24105864295575425040632365580182205338768862445142581670429343537715341319913656542327649903635493867239315964506314545013212841325737985971485687131914387978975844841964164525153383050119745797134024102616472670835336584400365601709016964741137315546091169412364071235411009668169969542174670427988731398156917000630604264077711591114949793807731634801528365341255688438507626461193743837435662428443"),
           e_float("-0.22924825398736234481413000648117532934479524155199024785454259849560665270093218810721226007957162461995983488295891571341610885426461134369041298600490930995985722589581583157009293611998753116873755727411851056593099237973596625345705334953360453471591636263755042931910026878212250625995762397196826801647704715678929071215679987158300189563549721574699400908539109778285611160890108427622955177973"),
           e_float("-0.21563934109225795245021583089083557673619362197671063450489293059964809257235096684459906726915548448381041729900011467176712380476978999138502814223857656215436942636021120211859899544802418122521131549923732315994354174863933669704669539843032290617811260813547600483657944824412002032413629029086915903009741429996359686400610129792898441414684928412476794248511271009315853841382057329667660518798"),
           e_float("-0.20082191930802697698480210387165714631827693121663276924317376463748959695631992968842204850917825305328133189453870309269606578937400816443375934220420325548995598396284882160838438958734106139873318503844428461823159412184574188281545860963105692778597715710009450543893211649798514162072653639844118230048669092763979427483805327350945117936303718426263723908227010036574215849110361587602779489387"),
           e_float("-0.18531134073209739306601268322923253025532877989134569642041924936969814757469946657005223323394543054571088613495549987713220131443364167743098219314452213987548058848055781531126357202942606688668425273983602735005274381832543686144311911297880236190541202258047061035984391466619902588873246812838568016755865047336813835569120928438734563247369560669511914935137731953200522077132949199524186763985"),
           e_float("-0.16954675430838576751754233025034902715278682487530651730682433469311237743569054586481982250981152446788429741845034869597177580599197641365500846385023711143252144225656258859777655661304731229436781945010444367937986090212789484678292866080483123893728679144397407634434103757784095751683578646107249110398327228823680832788235827390669578764647456314682301712415545655207363478588143690336786707677"),
           e_float("-0.15389253575148887280769939085094160348009873437942485504055083547998863238570312173479693162223154276843831065266482158378979058604739829888759336302495529835355023614368183003881374363699765458523134038838565660784917582176028687082783263083216332661542068671676134105979568428925178651637203669571024454297504678476001808304394938368729552298293796268202884361808634384358111404170621060196963706751"),
           e_float("-0.13864200685551448701000844413697362976468373330965660969550155498856408892333291003371645421379746051910058547937452298320925709705881433824294044654420824995049075535544206984187794156995666361008420672317917629292533748860122135551521518256124735578387359756751211530727630878037167202691725854866233426885902304466822129317286804841993747398394510311896372872490542916670808940112778259424983756682"),
           e_float("-0.1240228151922423627004439144685098954060253237045723476732390866070413233207199752268518672629241841269693933169364812919335597613738538369847568494414923609670739636311038983294774952948233763436183531217320151289354789599605860784945220496803320167669995233507152520009729729770288034327321950984415271488727750958775342029944037712650958372416884776126093216674963513474399183823868355602277008085"),
           e_float("-0.11020341409680265047532993611818796824887771556029983965850326356137917964006929011117752955374413492908132344468400527111678930160741885029128657120996015149617582301671349553169021312962362554160483491078459853524548163073705870622129771327073033975220817878853481566943978659842539874410394064077129347641518958744182669733999049304309500433973280656707397674292576126472649809092010335519539420662"),
           e_float("-0.097300161493449592803423794635382797305597390202364003426006707863802210581350861701676653349243811616440501565650301433384113665981271756290926372715066377168274226346531677970053774947006676077045568641210243566671328557054306913314052626963617477007915359919390006323354901184675437972525671536065488750981168759873697068198681644437531922674911481459769070891032528398850502978838960762821393888939"),
           e_float("-0.085384638408815833106796927502651154922840500433705144979428138644375235504692187222142694955944590546451794356316563929566450584987140692194770440732544370735752833150484455803288317042489701311650663387199195550843576452908952026607788504199121346502460648113319882462325284316418123988238178349029679750905276245244756160419047056590338419341667440650632473318770468320200687244015784896658775838853"),
           e_float("-0.074490869119955256044152781131551248623336741133818941035454054223810998187859715158262905539718335247058694625515632836350017123362020926251205261329035546367152169694498868407616976480911809938633735033380300471620194191020634108781083968309944153005797869515863597175599194008485893236886249670981181670140980133716725643987614529913390006641984054131393440143595571580838153100613413336681818120764"),
           e_float("-0.064622201187569953669201063351154367221420775175028230750893559447790401362579432180579422917172123922443826552773148036884170872984487577229451510991433388941345010440815620724913828322847078922867818468131368205937197976747310075677645640558519063940338009237231156856020078446699931797267335576769437007914822326291216111249832255400298070469255897730569884760736679629019979969582600397278374941678"),
           e_float("-0.055757672652472168599846765432210459001260382477754037245222440998040925093209892799631636096713818083404670102433511870051087446838975212179189334695092542923518067668534481987354182385655977178722748219559691452593848641928018251701651401546418233714890497116207973079419727474077478592094323887594657761480024099666389709137980610060079794455352499490359316647077151481248332925206281532216782217023"),
           e_float("-0.047857753923786071585849742249206285134273336731560073588452534191664654507996110638293102123951700551681306377564344817734501311328955633021427581017790933644941895520130812257128765760840564415981680785106550553500036427986648111151921585448740371657787699562301953359545178669686776448303282819764624994165195728126537126832527147821363994384220760659563146555526384710795783712600907511668589192064"),
           e_float("-0.040869402670935906670708559036753393333331695944449893422235524827087384601743879897465156755154915147452771256560190531590583595346586178613263592762389005351909685648553937481473127998899262354898134892209608471517718332074051029389659276761139942900344534289793921267057193027679992032415338788937630069573078937179263172693168710097003537634352051307305903503976594285524035949763974875375890278535"),
           e_float("-0.034730411302023917787545034214757249614921422491204503343497943101554129615673246196152389782576440284787981223490763470959799946139507484643330420389872810296168926738502039639907088707783056697350971739975425689650904913065364950593458468699771754587513339964856803089523039616212652313969013954095418515774274884442906813939115701922522343074512176494163686799160021969352614684713310329441831413391"),
           e_float("-0.029373058805225572824657739151687878226817893192266947517640715808988000169073197896803639195601783685440102473284051434997504398268625698506180371032985564971481895756481340197795729330972740213336478537135135662819364585620784071756568892503305822660837994712742584923581512157541567127379361216918283356848085942501182609295728328593309070775157665371146366850410921205722455842480785812450730516267"),
           e_float("-0.024727102620066959011513037040310610108861920449074007435671748085272861265430409438668893508518209236685825301783951026964696328007584167889382490263050289939801681163355781713654532176313250159756305110015187764180281409342967489289857539128559163261136770522833289184181065857053895063027000975234417622936310786408904225219759112792985859258417130590112722436070170137392587603440700119784805924532"),
           e_float("-0.020722162774222520806492580862245699926304536690121892627431159654728209483501088432601699168815333938285847811044537351636769183920212654965002159622141457388035705923520635631360798011236137700150073967201465148687575998584289631653735524940201091302564499619820369236029635869074950978432623202577501411403061111127481433358408241235199946151109742913110106003387303944448608802449316687376220765079"),
           e_float("-0.017289560855662162689960232368128911234672542459277083646363162357924297516079933857192810678114136300260527438436628065611041532976413704021741873484317315979594084705054249647542350555434833877299056557053436820889698815642231922689184523123195234569303226359616929285876615582655583939525340158711098986745880324849665256572841228391011662018691466743613680167642454109688298016351131885655381703535"),
           e_float("-0.014363681597980725265844371818467034139392985835326163662026555725381257008251863221740344622860092135508076908197959403595923601253670575474684100738468611974165708310300718199974890287173726579994184962165146305406713456776857669750144436476895377309173429675994350211449781732649352413983464616115731349903076981252228553458050815625657152631271876431920373257400942967543546979971367942454409793686"),
           e_float("-0.011882926006266241416953558757382373716934897286612218982394454317352928491665242303685942978409879646173826800080678024901273795530540134313161259590129501977738695903245338859843081184177780169183810790720300371402395026656535557396419063811953691373112935803719305088249930220708724729013753211462666406051175783797186663694200114372044308894088473722811996946712990193742274895660065200373614816381"),
           e_float("-0.0097903230254860480981535255177785740595839411701794518579733723725172645365041402732104464068453578203321162470422029763383412096536359027956294674991056425855811787856487960729716703595102086141676282928678083658940039110710460965250583500200755605385348738300328052127017283651876272189354950119353238059335964906834162345647174159628910364653035851832557456680143559344509882974922177514518117577105"),
           e_float("-0.0080338626252468732472227888031873563755794702985426547577350332252470596180363416466123119366208794371407311340971799315880162405026958732725986661042414992636223133155258598871954345413666611191868712214438576455257315252856836484368334398077377353409910201665737924933076665432106484811481258339244801959868924936576708171407065453777227169790192700209691064289339566444791901228862858105710808045254"),
           e_float("-0.0065666075906259678730746196600187072798055115863362492420561473311844456475010167240965548615791740136199577050126178803786389954231972709555986998113721005939824211330953409375192837821565584392502613826248225913533336514327458742062152675958151406369573663613177824791032201769247270845813573952234184826200522465996581371322733106790194952343902404659935349751222563704659652845454092598894105706977"),
           e_float("-0.0053466348862437505753736224883913434807973829372053996106793962667025993890685455515229500775319216530462555142698363568201300915810158438943893021109222133533212036495480395914734756484909365664115070169614330718198706444655499757811889932601245350219557775632121526571176360201403843486532981570729695804230381041026609993501449339500408270095994217223630251555422869088969980771176547416239173220267"),
           e_float("-0.0043368506926421387748469072420751652947732104952458310248982951977001520724276980927092199133089240434805743312721881638757427735368788130694344797410878755202713507009205381754638019006263041987022980440889991913594203476749339807238450591586259459598542277592865161618495518762222961719962287819229575891173520801400678445597072696411042017195779096085474324722971008687387990659892200085137258917594"),
           e_float("-0.0035047164777948266905404484938414426669926927868004617101551301229538539115553964186730676870586295002033550419458179658290113462826290296931937903474888456116930708231864073305242923378098119722027301618216292703895818023165897853471238959764695373058048389487429633687317559161981590405457837455928979800013583564538025115498860597326825524564560073789580388711651660050051201999200669084394565784385"),
           e_float("-0.0028219170372163815610803651104852539518397850479404670564701808508439554882371751665422944328473705471417853791472663535476078023172945344537521294079887940383214145932391322340414463640668760006951003606861090089598617295565823623090375434424732091201660036824807866766381017037021397812815879909765629359174368748077893222487230815123458247736348813714990387511667163240066107895428855578901431619044"),
           e_float("-0.0022639955008481701491925176930516877377165324799196787121775059077948204616725953735934973597991775753696669451954932123677782051076732304179613019347026669764052137601621164696018795182444528071590004856090951395154748061915332864792761368252811892340912483267996351637903290893843414481440869720400773041503638281127856336943606557746847705582960885132803757734615383061982165587125685356154727231459"),
           e_float("-0.0018099749781168350855545865387356342751798353792246907010767557494480758068708738256181741244406301524770162091277747481175873135536775795125156644272618905387219284384916953545916410016318369911842305733525012634040286367693064572241637879962670080934395423263876012306755785575863346940416168907182407925412934423971080370039404119986107898741699996415151001511496594927188711022522887129594167542145"),
           e_float("-0.0014419818505326362812525129149230772440339689080240528652014079319242848848643891509818743681362046457246246747736248758782428558625818267977595661031738644268028761670890491542254277056089897251566138683561028429179072364194788870796634017975698345139715929883938859667341414661083216456878160048261921542970234258986165024072756350035546552716029537974867711505236573412521387122492552778148133384147"),
           e_float("-0.0011448817354102957848004491314430276436844973725271122607424407386171374824253826408028850993683722496483204194192421605127978703261619909075903430688816812906594642112824274103625546968938328347217160990684676712800989095012484346612870976097926692900677827131293662516655797958846293445918560914487091161162485751968674186433637505070508703561887106697169184274849256539528940497264916225574998247787"),
           e_float("-0.00090593581338873743490039527970362519282496974729157235092214292300344999183623390572046956382599489297257496266074811731369727053990739340556357316279595828837540883346285641307922792339152186650352343012765418406205052822608173286934422235415232698489570169222830588313476229366204552114120417138643738107460833887621539717726838617689587511185365393809329166431255814771851518782956814637605389948101"),
           e_float("-0.00071448249235742255127219248339493861782277419054691992844538922573001377555818677237420781624635316872367309541512235232640194324950871387110733591604617163129678206915076222197155870310402838873394264378524018747483684235120863421639677251026862025848860907759141528399029721693411907741730718506644570972548484216857905076917463793858196765272040344534840277524906287022152478346311036885287256382026"),
           e_float("-0.0005616472128643695779522083100745524364310979135543188429134158653210810760809814590658952454589026374262079202749766068488417207078853516146015406422093156803889021366218822003645748711609436840145393145587201885539581692912738232290710191195424570459707670409275435696164525481076306665186980466910897966786646761862588306485234117378161044094352588695070872880784115122817525037007623042672853848391"),
           e_float("-0.00044008151924069399589746058366250698968145910153932328292180486254750884399518628427087935260291027882555492506172514409742022272006934157023018692441461625206818958180439732190678920352668426172574085743960000664128111337655663022141416703383657084500522463890741839456392067042056262125651203383568526527394796156452409691520128737528588746864331374121600328826754314407017392780720728413327289141943"),
           e_float("-0.00034373125830589506785179257228125303009886320293874334532523614555380092239130986874872544627960605578680939097250488163298535027142830111321830998532352572435519942032290547477526909077231035650908660423507936572834747539648540805868798409373973457365979229959257717738791342560055861363020698510243842039382361466238425922734567846230709866607087532989327108673104165156112171204634854972503312061202"),
           e_float("-0.00026763285680850081764968212059549621214035276722095262352731977897309926479853058753191117755644764477921005888813824936570466858554003525509556040493839700026400724299244443352159834620470850366151093618426675254361344050080149039565135359142135168836004826847607830399489004210014088786615621117185219032224115350514143774652448434389643169121691360499804431004102714463031081111587185389801704234438"),
           e_float("-0.00020773600694138515817577438961213695249120619074610243625459250520041468051988829694854279411800440730921916623304899389131975115586005713058485800796754751646629791807907794827093073014633744709536169854571184431909328805965154403285131079352883193856840114248158293839842579621133140687476041309274563743929786089947239881896313152400062100374005195260556021385875060535932438914962146199204021417031"),
           e_float("-0.00016075069929541049960952592422173252501052911719771494684243886843357254015905979880533935760528187498674470677716298255878347576420768636484821704418972385649331661446370304036579291011613279459451088361078924965550928750634037513106891463801054894278186075110615645232219382062366103672046219940314004840946835081324038993850920091706413603928805363743214674319724653815619356413405581325187427892034"),
           e_float("-0.00012401633404569116181943706936951550520683473810866555222321592716900515008735328472285204485144955306177459659648952027897258969717217560618408438076643629620341395736521738593584852931262274058259660068839132122774811953325932955893445118163334707271555321783694656783460971557374609218625321403903394755507599351994065006196485793529907737172542149050960971486037792381638823845149235566350623883937"),
           e_float("-0.000095390570517421582431607977744776377430762368571264464834092812913661845709204520116789562458579520498726467369096164027768066284553954170396267649564640069896744665198944517860766744978143884217302133415636383668293568579424501637989166730348681541598201924369926827007926099159820781534631903936557990232871171791424782073948840932421103745768733457666273566307627077560475699350667903203208873615792"),
           e_float("-0.000073155605919945505240996317147110420365723811423148990488518180453026960614614590986619231557622754678792577667700361350786988703296236095676925141016228723946336692266064698102769197448537386276623523719031405291815630167436874746584195239710929634969523005243565405827067812872845202117390782996097008078497345383164870075917850680636485260437552770950142684751300242872676310150014889385702619628218"),
           e_float("-0.000055939675795749661161228664417113108800419243532549099288662162808678707487692165567160859526409123030105925949719189363130120008759088673846435444133395737548746143928930260689377603163961076033619194829049129320743369929909780371281167672582957390382758553707577494121871263245710271543470668027701556609633956492117441585381350390809990318569314285963593663205458644927808301541614788516431328723818"),
           e_float("-0.000042651717315203348815447677944655827991957874112938275141420755280557126842851117709338426848382487376085149185088587705227066341312179373239257754894159986874288524618020627922505432938464597626039263939988369089106961844074795023930266690272878473208254159672252220577809336326190648496001442058868553133557564335068319583852675736314723101648164543625260547203425447484831987339996845652838542915688"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00582_airy_ai_prime_small_x(const bool b_write_output)
    {
      return TestCase_case_00582_airy_ai_prime_small_x().execute(b_write_output);
    }
  }
}
