
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00105_sqrt : public TestCaseReal
    {
    public:
      TestCase_case_00105_sqrt() { }
      virtual ~TestCase_case_00105_sqrt() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00105_sqrt");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::sqrt(ef::pi() * k);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0"),
           e_float("1.7724538509055160272981674833411451827975494561223871282138077898529112845910321813749506567385446654162268236242825706662361528657244226025250937096027870684620376986531051228499251730289508262289320953792679628001746390153514797205167001901852340185854469744949126403139217755259062164054193325009063984076137334774751534336679897893658518364087954511651617387600590673934317913328098548462481849021"),
           e_float("2.506628274631000502415765284811045253006986740609938316629923576342293654607841974946595838378057266116009972665203879644866323618126736180957855655966147931913435480458123731137327804313019938802647150234465504898425802329413862779668683613033675823844181156078490095600041375150275291651461225843861864920699060926664091188015739697252377702538748247848633488642597506589513095738763427251926880402"),
           e_float("3.0699801238394654654386548746677945821221293132529234536092078633942877416889511494096190816646754176075937074244926190270345429405099416216417975877667492169521054332143197658279274969526803993603118331066475990710709664118358901594985707262626428113026982211562266383695623138538180531502756293265592878111781185072888638355377253555018107077854544789544383440520575813285321747411416665951698336554"),
           e_float("3.5449077018110320545963349666822903655950989122447742564276155797058225691820643627499013134770893308324536472485651413324723057314488452050501874192055741369240753973062102456998503460579016524578641907585359256003492780307029594410334003803704680371708939489898252806278435510518124328108386650018127968152274669549503068673359795787317036728175909023303234775201181347868635826656197096924963698041"),
           e_float("3.9633272976060110133450287651201830315223597563961947927072580621967387180265716572287741878596340312327405647932953536228865576823564748759947646553751734998345995939694212511640273087471173966245241872854466233365203399138209787201764302154653389399844478265349330231414848625437655715466042970013389483751348124861944502103329498799507208968519689075130370544887031405163197191213743249921794351351"),
           e_float("4.3416075273496059561780877637447746072326533687072755618572739666222092317177743715006976894086930825786781544103546196765147228208117261527925650444366222660658062788515204204290333579229705891625284205192508929083683171545403426350581368076912529151526695869265253040752801155830676216390514320781159868843187117008896251829228661529973809619044473853320316190549204385101682005396209108634347068051"),
           e_float("4.6894720998347514072224884956178300284641581320824106981633983758453256799744598320502835518976559264849872655758786968460389643339445673551269229241587961003379434250163073293499620997874074698516457801989721178630024470871191608919926005831108426583129390228179129584616970283973090935125037470398636450816554023533350528106738423929159432353981681442386558251657700009494385592281294126884159744657"),
           e_float("5.0132565492620010048315305696220905060139734812198766332598471526845873092156839498931916767561145322320199453304077592897326472362534723619157113119322958638268709609162474622746556086260398776052943004689310097968516046588277255593373672260673516476883623121569801912000827503005505833029224516877237298413981218533281823760314793945047554050774964956972669772851950131790261914775268545038537608041"),
           e_float("5.3173615527165480818945024500234355483926483683671613846414233695587338537730965441248519702156339962486804708728477119987084585971732678075752811288083612053861130959593153685497755190868524786867962861378038884005239170460544391615501005705557020557563409234847379209417653265777186492162579975027191952228412004324254603010039693680975555092263863534954852162801772021802953739984295645387445547062"),
           e_float("5.6049912163979286993112824338688008938543237752107832649583533936522833776518879743363843375245853739417146705744562990455542075539831517566644946677745451618612727648966621311978378350382925082779759505143787044093893128068035895930171543641983336476166511254286056162309665822553855728700099730566135263229310482770603702313599779589939672325828370865928422053430400072831171741334547285379289682272"),
           e_float("5.8785643816741282350544208778970709719984349210386743751731421071573245581781685524668778017649261234929950374883647452602146761146149358621791392549585140581629668270696079138391334037573962811189827061481326675520008356479940776678802748553233235202402722469819906081593819717286567095640228930465862438974894553668787148856578760128886389981154414656617912505436134549129966633314429654846358015259"),
           e_float("6.1399602476789309308773097493355891642442586265058469072184157267885754833779022988192381633293508352151874148489852380540690858810198832432835951755334984339042108664286395316558549939053607987206236662132951981421419328236717803189971414525252856226053964423124532767391246277076361063005512586531185756223562370145777276710754507110036214155709089579088766881041151626570643494822833331903396673108"),
           e_float("6.3906732428334428261259345606683697744186991536295350856572952536792334275205803679271798801956028881370696845677932311660934936022581339690170211061979607805733455201951479794666965209869986063436354009130926493418080814534089804341799659379279227089093453978416225274321462755382516029668891204905799575745973313377842838152883214737404214320108342272339141901742347633007754961396966894396055218335"),
           e_float("6.6319150439565422209346322551709504425716735849288353552017602534239577421171265746820083094212110964436394134010761548512808504941585541646833262349861354253649509838599508444233906260858397863860491814334791305676062694775880372125594128993954478298062410594772628739424601593453063666245276274089103412069272086098919187261711687627099337914569206834456380008016156884529727902326858088262113926506"),
           e_float("6.8646842464782674501407002511771796402482345158456677029870019960868679981055033418327138403618402473871307535713830436350072970119200914833099051433782215491766416984101933198510637348024255711982258019646531673420782186308197017640254188794990907965118086055013577841433086632978528558423768612444566483278359963402485448887021894326224663275495307768561423891711354763179723690983043995316901267288"),
           e_float("7.0898154036220641091926699333645807311901978244895485128552311594116451383641287254998026269541786616649072944971302826649446114628976904101003748384111482738481507946124204913997006921158033049157283815170718512006985560614059188820668007607409360743417878979796505612556871021036248656216773300036255936304549339099006137346719591574634073456351818046606469550402362695737271653312394193849927396082"),
           e_float("7.3080144438162192957641041416982527245725757227305100451197343989892588739821761414808182301620094920283430190134112374199876901202971502696155007476535432232511740870601931279580970011543206100142223236655886609010356942017275197137478321035055972286226075962614582069104333896744606536872975969818688237536119023271082556121464860312141980207823280639488597150891408230800059272527978401067077953752"),
           e_float("7.5198848238930015072472958544331357590209602218298149498897707290268809638235259248397875151341717983480299179956116389345989708543802085428735669678984437957403064413743711934119834129390598164079414507033965146952774069882415883390060508391010274715325434682354702868001241254508258749543836775315855947620971827799922735640472190917571331076162447435459004659277925197685392872162902817557806412061"),
           e_float("7.7259472181866523240047447857321216411382058048896371981452984461525717139136608383759839184128073783247516939318227254188667186252920148976230121738172757350696910761931890703374371352358496474852223543486038624030825959222662530865956553207195355499692117829480399491662056117052329890340838528765941430191040119361471649248115254864172681901246179411702783591299133670884083665071028145395467905989"),
           e_float("7.9266545952120220266900575302403660630447195127923895854145161243934774360531433144575483757192680624654811295865907072457731153647129497519895293107503469996691991879388425023280546174942347932490483745708932466730406798276419574403528604309306778799688956530698660462829697250875311430932085940026778967502696249723889004206658997599014417937039378150260741089774062810326394382427486499843588702701"),
           e_float("8.1224039375904999377505608579034490537406469390188453967144182984533857877290325940614418824321939803516927684051300838316226942055451781105993601208197552034439458355062514914010489070985895267530389722733907460105781807411858969857115513607918067972038272323523153845863300953401051857105777813389049407583848705460609239380620914585791645607237224057116980335542916058764975650602331697086068450513"),
           e_float("8.3135454758469596794056637871226727528862453946735918624095026138842010906353046929837281458679232254339472365667835656180555764317605853990925880640952695214325626531682928857436719230013491132666257954067248287299135662202926101799336433744666850543864886828346127739925910374766049639016834422078705626669128492094502607019895812459974265416556762885336564093974655530945349099945854007412027682568"),
           e_float("8.5003900517896968140560669406685714433987187446432157683182522591265374787311356353957620692173960349646676819100596310150960821656523158016643597684118372232800409169139557083780710669356964332570202113507421938631568719639718297731072485795933970567341061565566173805049809290766392136448216369341299035269967401098236132846311584581915310373661351551853853444420939639104451552704753437006616697649"),
           e_float("8.6832150546992119123561755274895492144653067374145511237145479332444184634355487430013953788173861651573563088207092393530294456416234523055851300888732445321316125577030408408580667158459411783250568410385017858167366343090806852701162736153825058303053391738530506081505602311661352432781028641562319737686374234017792503658457323059947619238088947706640632381098408770203364010792418217268694136103"),
           e_float("8.8622692545275801364908374167057259139877472806119356410690389492645564229551609068747532836927233270811341181214128533311807643286221130126254685480139353423101884932655256142496258651447541311446604768963398140008731950767573986025835009509261700929272348724745632015696088776295310820270966625045319920380686673873757671683399489468292591820439772558258086938002953369671589566640492742312409245103"),
           e_float("9.0377767727099026972694942617286283519638707297067360423044656369897256312879279757777821069900749950044557425089876204493377875035177412255299561756483293212989442985024715332632332359674718551451382911466759962124284189582809463459910475239066062631635959736116080550697706078586467289296679727180578661286024444872547183386534308509666500269688916003034333222621461052151120014437539157953639737316"),
           e_float("9.2099403715183963963159646240033837463663879397587703608276235901828632250668534482288572449940262528227811222734778570811036288215298248649253927633002476508563162996429592974837824908580411980809354993199427972132128992355076704784957121787879284339080946634686799151086869415614541594508268879796778634335343555218665915066131760665054321233563634368633150321561727439855965242234249997855095009663"),
           e_float("9.3789441996695028144449769912356600569283162641648213963267967516906513599489196641005671037953118529699745311517573936920779286678891347102538458483175922006758868500326146586999241995748149397032915603979442357260048941742383217839852011662216853166258780456358259169233940567946181870250074940797272901633108047066701056213476847858318864707963362884773116503315400018988771184562588253768319489314"),
           e_float("9.5449561001664121805331805088802752995271020253115319957577421074579216968677586712228633689301398077088311039352276247681835887608812952471054772558240075235037900668496782095699528477874731344527911180393401955463971510372217637805322797423365420146482689917834696038570131901274302300283422182521267833006285359393142295438279095927378336768120882908112575029657358394527378572761652822503523073037"),
           e_float("9.7081295627784962702001300843202309014239162997075295338190725567740867768360828377797213369985222605738422125153205809614310720383763405854578937000465002140881359434675879559012762493638090947752116234678266669492794549428222971705363614488937056614823310418806119084118208768665243016864006604622872546517235887590814184637647435563763625009597343962143998069332678679995949595625752510047376769469"),
           e_float("9.8686053858325691182072112788747533886058057201411380476476456712628079750259677966540684132469441944845346447517503807626845356172247759078119619345186680215080975949071260888809391129195428784313017526586710196446975545314396408422675567403935100395356341294811788475428908479858626488242639666149638195038312462497821769798554375186844561183275752651214811690182399175358793738641461618652775991586"),
           e_float("10.026513098524002009663061139244181012027946962439753266519694305369174618431367899786383353512229064464039890660815518579465294472506944723831422623864591727653741921832494924549311217252079755210588600937862019593703209317655451118674734452134703295376724624313960382400165500601101166605844903375447459682796243706656364752062958789009510810154992991394533954570390026358052382955053709007707521608"),
           e_float("10.181972184624311615821119525392646566614334777981507304797991128872845411935855045687447106020270650309180533858862699802452616670765042577313665825807440090307057847512919113426271458183092072699581551465382478938467355504032255882264015569014213825098166114446059843169833192986444108942840506996523623715072210566481161204920674164962676130998460012958025127031857745585310129294054842583903606686"),
           e_float("10.335093140463368369194743647270744470970869361548018260412395037033434954444302167923137950092164921880086359392676052875666101107812632184449266829146247839347650312553659121907050973521042894776187579282867330188754139851333707822660813843642659379040498993205802303976963038480061139480627996652519324110663045988145350403266422896739974552818525729859458145898707780132492595810710069483709616997"),
           e_float("10.485978393819184450541593598855581216998391038666955618731153780797160148941518448029432453424375096293506458743106555413233965573260145046667734677176640468352558693946707494977637683951611790027770744751949296502577300781357035084119423389099318378785160701550868259776821786756050171108775480133925239818616956336860985197400338717780301525607287576543821416712628079932173339130152141281524936833"),
           e_float("10.634723105433096163789004900046871096785296736734322769282846739117467707546193088249703940431267992497360941745695423997416917194346535615150562257616722410772226191918630737099551038173704957373592572275607776801047834092108878323100201141111404111512681846969475841883530653155437298432515995005438390445682400864850920602007938736195111018452772706990970432560354404360590747996859129077489109412"),
           e_float("10.781415870970860097347086002569754013483313106913200202187513520048043712278512261111348167752270787807827044005214735609272769552792030217118319247865527486947266834539351039872232355517952920779295855320877662434434089302868383880854490418955953060861828833022956166078549446407677882309027526266764943581836604667447009735143063508187804312221807902016203318428080812848859262617506901631056404484"),
           e_float("10.926139338138249418394948518774535514239264300129320003780439933689850327924622206216861373106327795446382986541097387057719208036647206296404050944003327874361582341281080807890889880787061319999797409840564399938369028699154596465019693581401702995072256439155901828510666479433850274478604710483110368760249425996181639834293503287006547476391343675449556976797862780800361545757368573258815323922"),
           e_float("11.06897075115848051178114346592360054790751225726540302613781325417663994648010534522689154363395052648690999602611864735807868417839407991190718628442039357569977371968270131812518244771818655226966561256042843867368054126790999954427565212628829680859010057375985048181200629605336234528792323216018627284394365650824130654190684379749960413601595348763566769123659605593998962030711530297996631109"),
           e_float("11.209982432795857398622564867737601787708647550421566529916706787304566755303775948672768675049170747883429341148912598091108415107966303513328989335549090323722545529793324262395675670076585016555951901028757408818778625613607179186034308728396667295233302250857211232461933164510771145740019946113227052645862096554120740462719955917987934465165674173185684410686080014566234348266909457075857936454"),
           e_float("11.349242212464298392610285658298501528539506746683292704338035654856239080485360828460205074304281603179304760097806255228463147327169830108042093067800293527086021375553337641095043483168312926670841786279105684958531871509131651122477280457930695269239120342802270691155290589721502201125592305692096859835744595168676715800717585850328384113754784770216906888175704141625668202687511966586138689496"),
           e_float("11.486813807613115307809355167215211082379289672043820620858981542835886683139127150291615174043283349892373335303488265357426140211488562306351746628698313560931134742861605848764176458004039113239912373535418892499572608431667264556464452240410101014511349682690566153385156486931102628456780783577079308426737658296507891772476075136809898570922049321898908119541008410725370277134653232606047953378"),
           e_float("11.622757164475265300727734810950869136366250850775675675103670116706112045368165235882961201344951218672069233183763229866495319155659488490374792371109115979803795182321120105254011624290383337645277922708894963432033544765028110116592451203025661365050867782024140543770476276220678204795976767514166142764541148954132005264256215811527038353628432725649155000008199699094629246514703895814051248301"),
           e_float("11.757128763348256470108841755794141943996869842077348750346284214314649116356337104933755603529852246985990074976729490520429352229229871724358278509917028116325933654139215827678266807514792562237965412296265335104001671295988155335760549710646647040480544493963981216318763943457313419128045786093172487794978910733757429771315752025777277996230882931323582501087226909825993326662885930969271603052"),
           e_float("11.889981892818033040035086295360549094567079269188584378121774186590216154079714971686322563578902093698221694379886060868659673047069424627984293966125520499503798781908263753492081926241352189873572561856339870009561019741462936160529290646396016819953343479604799069424454587631296714639812891004016845125404437458583350630998849639852162690555906722539111163466109421548959157364122974976538305405"),
           e_float("12.021366896702325047512148370523129868500863831336365554094968238961326486689613290630609864218702661853221321521170144826739118836804766785357157269477553635675326417440397275525273224383182704417613920902492439425058136861846204626155795604149515361113916782624367244364805538377594330304168849066367137313615505351036054026784342300533235365305626284568959522499820909662710078078441813899168007885"),
           e_float("12.151331396958947321546025714556865120149751887789792242805026251328834724212197338975462680992513495564542856143237780070708286761588671182939823052704607214915211775783314118543447776586990218385020548327676785144266827587041679291236998809169833652034346885774675107188363717375427120958548330331469713644263714560973379556087401639283796742412962466979669807549620252885888038363577488350118588327"),
           e_float("12.279920495357861861754619498671178328488517253011693814436831453577150966755804597638476326658701670430374829697970476108138171762039766486567190351066996867808421732857279063311709987810721597441247332426590396284283865647343560637994282905050571245210792884624906553478249255415272212601102517306237151244712474029155455342150901422007242831141817915817753376208230325314128698964566666380679334622"),
           e_float("12.407176956338612191087172383388016279582846192856709897496654528970378992137225269624654597169812657913587765369977994663653070060070958217675655967219509479234263890571735859949476211202655783602524667654875739601222473107460358043616901331296638130098128821464388482197452428681343514837935327506344788853296134342326074035675928525560962854861568158156132171320413471754022539329668983923737294314"),
           e_float("12.53314137315500251207882642405522626503493370304969158314961788171146827303920987473297919189028633058004986332601939822433161809063368090478927827983073965956717740229061865568663902156509969401323575117232752449212901164706931389834341806516837911922090578039245047800020687575137645825730612921930932460349530463332045594007869848626188851269374123924316744321298753294756547869381713625963440201"),
           e_float("12.657852319136902268774845164792088421135161808965517945523128473136824363883193009269209734457043707990147945768735771850922659087939277511584226597559704972434156306141869703126860783026363074957510823322218307776858151286948305635221192680870601025159853336795122235254709338570514335130167369800379884747089903762281584689350599843615480943120877060478385159492967618565239777860563171974700594693"),
           e_float("12.781346485666885652251869121336739548837398307259070171314590507358466855041160735854359760391205776274139369135586462332186987204516267938034042212395921561146691040390295958933393041973997212687270801826185298683616162906817960868359931875855845417818690795683245054864292551076503205933778240981159915149194662675568567630576642947480842864021668454467828380348469526601550992279393378879211043667"),
           e_float("12.903658808270584524837154363200375169745690840774169241078436884878608872508906572537587380452008766699694274634572683484063997575550636271724653470644222116629862120750427362283465850548658876022606030340287534831876059275988640705535030144354363210242251009786303368432070884750488539702567688880560860857563258835290820838217726051097677070824752411130297718422198873037383148768947802251879541624"),
           e_float("13.024822582048817868534263291234323821697960106121826685571821899866627695153323114502093068226079247736034463231063859029544168462435178458377695133309866798197418836554561261287100073768911767487585261557752678725104951463621027905174410423073758745458008760779575912225840346749202864917154296234347960652956135102668875548768598458992142885713342155996094857164761315530504601618862732590304120415"),
           e_float("13.144869567532369703435413653931342518067740699025339623141355353215828472920177249101100071067765021905490369373865624919713235361781704313989935557374066820403290956743429603874630415006274130921897795214176147246606564445416505741569346364219413607323060794720326291947944072987907139328701736835753824779102737278004452916595869434574114960991640537914399673850290672639531054905749913587677194565"),
           e_float("13.263830087913084441869264510341900885143347169857670710403520506847915484234253149364016618842422192887278826802152309702561700988317108329366652469972270850729901967719901688846781252171679572772098362866958261135212538955176074425118825798790895659612482118954525747884920318690612733249055254817820682413854417219783837452342337525419867582913841366891276001603231376905945580465371617652422785301"),
           e_float("13.381733118494712177838769415668363136693460917853586922473464683953085883088277884543132016555752708286716738574100724123397234966834133579930312055894987491473163259667229253648684025236934307557806266139484672929088612080633523093147067612558483695818827536275063195935514841373590920865965312578548954529988065057157198978981673627647254889933136041368681534023007231776113961710869320159667705337"),
           e_float("13.49860636911114642459358030571634453334465888809545052183878432218118664778145097027262019948683840900856995174297398771305025250783532430038321980650780572061258675589431807213585169525934929261000167914426347007424971894853755903478955153674190248106782011276139620636507795882584271293035478532473175580070278864979183505217356484769621601133034831695071383225633005792357284236385529593207735858"),
           e_float("13.614476360176244437992652165124010849348942994806267539289974901165636798182245517885383466885359131822710017177747823047886229391043506105903448210261769449935362361092960808325221972886007181477749623755496282578986043666471300738088582325762070505557101653785908332333215528357372693553823245805882631589902970439410267849152146509417834583229229656869363779274739391530153058374399344402589683807"),
           e_float("13.729368492956534900281400502354359280496469031691335405974003992173735996211006683665427680723680494774261507142766087270014594023840182966619810286756443098353283396820386639702127469604851142396451603929306334684156437261639403528050837758998181593023617211002715568286617326595705711684753722488913296655671992680497089777404378865244932655099061553712284778342270952635944738196608799063380253458"),
           e_float("13.843307114594308080228438262394272564345963431637029583240249081158469052183791491684039537760243230438634632151602246770081706304258619208947181121555949109643060376549010534247946473402803168501401798859700886609956343474750915165635990740345802222770885528894449519285586683416492340458031775111481023344097481374008848545235590455121882858118351182839281932280042314361125165296526825458755105679"),
           e_float("13.956315578352589716302829873401945109198453712022825800945047218826731843806713506320236853413543088508394629854930633075647798955617836866562243675418009347632488093795950654785453808337001941625657577694831670791784231090389461985759139354822791165710146844931160825962396468466501611937704664704804958138610109693667041306322225916233920219127362826337256387581504195730954720065862316612737195428"),
           e_float("14.068416299504254221667465486853490085392474396247232094490195127535977039923379496150850655692967779454961796727636090538116893001833702065380768772476388301013830275048921988049886299362222409554937340596916353589007341261357482675977801749332527974938817068453738875385091085191927280537511241119590935244966207060005158432021527178747829706194504432715967475497310002848315677684388238065247923397"),
           e_float("14.179630807244128218385339866729161462380395648979097025710462318823290276728257450999605253908357323329814588994260565329889222925795380820200749676822296547696301589224840982799401384231606609831456763034143702401397112122811837764133601521481872148683575795959301122511374204207249731243354660007251187260909867819801227469343918314926814691270363609321293910080472539147454330662478838769985479216"),
           e_float("14.289979792964598888046537025443929046349268690964636578475665109896668898160471038052184926128242082008071899344418492114005094607229573377783255206983187149713770987548494300509284453832960172186602825751752512740011206822965310731878663221408732182835419428674418921388428247682017853292902641094633654925031641157363239954497643638130492825559275734408219193654081845577502824457995610506588347991"),
           e_float("14.399483155201312771128205693735119100150409368172849193283383259397943499400343097146699820101799211280532901097982868866065091616972220786072353233159181246251291666898296600872888597521470039336674892211278156066944280526085074727923215099315369244314973758177163795161905224659231453738958954759692535888585135313785224088858851114397375930143280080631232806768837383757811100735506790734241356142"),
           e_float("14.508160041525463782196810772461415937984681525001596663279698630294663935908428439756213479497787337122567348801168744730052437263877739149127104404701300967284676515346229296805236190281514801622180654355551641687098356104648569744546852559008969056173614451568235018709148732753388030273661774352691760355549492167313040490929262056910773064824444033384277728019069474988708219182391801225541693935"),
           e_float("14.61602888763243859152820828339650544914515144546102009023946879797851774796435228296163646032401898405668603802682247483997538024059430053923100149530708644650234817412038625591619400230864122002844464733117732180207138840345503942749566420701119445724521519252291641382086677934892130737459519396373764750722380465421651122429297206242839604156465612789771943017828164616001185450559568021341559075"),
           e_float("14.723107453852795047660891850891348521019392896043801015617971628447783989965629640672866077356179147930039264054884436242337612281568551505460575065987584693479589826744627929483999892320528426925051155319040406737336570522942634239674703047310686338476335923532963117635039796288802156148141351666029297701497040980317238592980791463337224993212730297458845130688595199892451695017449401650874288673"),
           e_float("14.829412859290334246310862079120981116215413675054277728460153169122428030531791551314608952543420254520474051699795429624440231166188714141339453291154149160307170860994018007001626101791576255751027842245708752403881346737835127200458159845732446774737303087761617897753731524877979274694284246989924515961238107617606034599749358785428854546203389668405763983263427124792153857226338962692134292775"),
           e_float("14.934961613773077251874220527850221390835466676976882941215420887391409941569982643090524050005551945256610875794604586439205076677328137831885915476923937188476319884303388028434778637885660437004576928003169458451279164932299027997584048683596586922839913541602495362116464353240069317035849303355081215425573060479512202737316638230608336142262048918028633468554185638406802946342865126132844574834"),
           e_float("15.039769647786003014494591708866271518041920443659629899779541458053761927647051849679575030268343596696059835991223277869197941708760417085747133935796887591480612882748742386823966825878119632815882901406793029390554813976483176678012101678202054943065086936470940573600248250901651749908767355063171189524194365559984547128094438183514266215232489487091800931855585039537078574432580563511561282412"),
           e_float("15.143852340539209919669694152668075754802130564520529114229055107020254596987080606065177179266558949005546167801108989466486322639120015544612100116126475848822295714630667404278002543054087765126012369520774988292980482378607240819831183403574109472290470399416907492752726605411715253325510753261994252828188462682810154109677323956353529409565238339361711344464981722604499214446881247473198801415"),
           e_float("15.247224546311525337004063635408328366688778670871498563977766898883017695500718397562791377885264468934146929755054408018559707733171577715334636002100724249512539221477485126428071589422606639367264374525385748313792960737408667516619228196176535880477098918773859144321945753279661701266364778960943177407574056743200803896101394393730713481442086031230604416350429704383528396355475201590099114842"),
           e_float("15.349900619197327327193274373338972910610646566264617268046039316971438708444755747048095408323377088037968537122463095135172714702549708108208987938833746084760527166071598829139637484763401996801559165533237995355354832059179450797492853631313214056513491105781133191847811569269090265751378146632796439055890592536444319177688626777509053538927272394772191720260287906642660873705708332975849168277"),
           e_float("15.451894436373304648009489571464243282276411609779274396290596892305143427827321676751967836825614756649503387863645450837733437250584029795246024347634551470139382152386378140674874270471699294970444708697207724806165191844532506173191310641439071099938423565896079898332411223410465978068167705753188286038208023872294329849623050972834536380249235882340556718259826734176816733014205629079093581198"),
           e_float("15.553219419991929097391447827110150978276147342755611087132612856263542587794892243906527633373900129242231785993922632274254453378155136866947691413591367716787056987199223748707467009025071039158554274945537967635091771197351723187066327453183887178046363960719814297174200677165073465692725493619076089149843317017809607596662107883796994364174947841232638766495324678472146142625602614264235678696"),
           e_float("15.653888557799428533661532247337596699165609502143573736324609963676016536620219650233947025955941767418394468430088744792011863372700125171657152344359691884844467537973207254356056413344833677019845894722403336263492187594473529648820105313588218738589863121077164638145443372177511689907229285786639401142720480840361807890924894118341348723302140201727278896670612158646957973089749997574886849052"),
           e_float("15.753914422567924620983011231186756248927500048298297966046797894473026288195693602724718689673345950533773458261077009361447048732755177208182393190558955000510862906901264875534878251422852119708834699869325135138115458649625715331447841946651213506247785763655954618727631238085210998597640478337632316374699558747521521322958958007061686783767533791960628390158818930229551073161600125867700021792"),
           e_float("15.85330919042404405338011506048073212608943902558477917082903224878695487210628662891509675143853612493096225917318141449154623072942589950397905862150069399933839837587768500465610923498846958649809674914178649334608135965528391488070572086186135575993779130613973209256593945017506228618641718800535579350053924994477780084133179951980288358740787563005214821795481256206527887648549729996871774054"),
           e_float("15.952084658149644245683507350070306645177945105101484153924270108676201561319289632374555910646901988746041412618543135996125375791519803422725843386425083616158339287877946105649326557260557436060388858413411665201571751138163317484650301711667106167269022770454213762825295979733155947648773992508157585668523601297276380903011908104292666527679159060486455648840531606540886121995288693616233664118"),
           e_float("16.050252259524242304765819675794450638017457570575983927825323032144525082963948191096147193145311656453873849743947855717510860973988659112083956949050053482287530484973632648820968563125979705559716208799062595086459726936476696439381910220384322311324311842667158228425675297979222265812106596748979173989790155646435957100594433524698909367347330792212795303074381195611252785521380020853492164213"),
           e_float("16.147823080773235880405791115635997557864326968336419500556329380232598367900898497414264871456444239647173004031647690209887509450260015358377350981847404025422287378732373648981765201137038640626625054151148020200007297959878815562787393121096595035600314225225829183114125474497018547223659528472930900422571056329570935652356761026639723378971526771480442539666833071774260326796995470405776697508"),
           e_float("16.244807875180999875501121715806898107481293878037690793428836596906771575458065188122883764864387960703385536810260167663245388411090356221198720241639510406887891671012502982802097814197179053506077944546781492021156361482371793971423102721583613594407654464704630769172660190680210371421155562677809881516769741092121847876124182917158329121447444811423396067108583211752995130120466339417213690103"),
           e_float("16.341217076923383960696369420161248669121212808135654273983491452937095658109553619994922766756319666975188172033084786774938321749356282450853819283481043653079525140374828081598688868309044496356854434283025399835051607515358702243412387084009896448573365043827048092425743953483386894323518311923913690941609208424884900176315736258863356896904842838787088633319141807219561302676306271570497938951"),
           e_float("16.437060814169977953327247404361277316133609673377048855107248395882567096603010277067169202635116275806042691595212970108586780272931810640625169517986388546454661584514822804714353912243137592516024763283438958227839402433048048710441109095172462035564435115216917054500940736255985371596025417460999236751644500293733791545234403402763313780467186900924301219121627362814381042265364554244922063244"),
           e_float("16.532348921502715844688082576333627653976665425427208876480987568125771090198651469125133728158959771903048097921398391233385160724013876315451069276292964513405939027110844786864417344898464954584607502706435338641340198705784007825954758491636479758251565454590803621730664169376188515867591916106130400067381048724859197544495864321744604824010272768413212368063633927635680949445491291877351894002"),
           e_float("16.627090951693919358811327574245345505772490789347183724819005227768402181270609385967456291735846450867894473133567131236111152863521170798185176128190539042865125306336585771487343846002698226533251590813449657459827132440585220359867286748933370108772977365669225547985182074953209927803366884415741125333825698418900521403979162491994853083311352577067312818794931106189069819989170801482405536514"),
           e_float("16.721296186883706959605742705233010783899326523984270864686085184270332637146646055028529386107385333643018392715062510774480808240365813021854787737722340862660933836784188253900670608552564136025173808090739064412712504259523027988063714336820233104689334204836546487559659633964043151984340548060532718923362128881432934135325567300871046043987974739750202594174747157312786841203825015000569906569"),
           e_float("16.814973649193786097933847301606402681562971325632349794875060180956850132955663923009153012573756121825144011723368897136662622661949455269993484003323635485583818294689986393593513505114877524833927851543136113228167938420410768779051463092595000942849953376285816848692899746766156718610029919169840578968793144831181110694079933876981901697748511259778526616029120021849351522400364185613786904682"),
           e_float("16.908132110811980070323724133825443669074486306220411933324368366059977522675356589320971338976776616316134235802112798127138113465084701628640560443298729802233609863856357626793535493930184649436981665533778324622620988007501131586355391858595913504065552289654660238871963950906549509361444433014511210945609775277269846879360970012281095853461600076871591771412527553822562541374853347368516919083"),
           e_float("17.00078010357939362811213388133714288679743748928643153663650451825307495746227127079152413843479206992933536382011926203019216433130463160332871953682367444656008183382791141675614213387139286651404042270148438772631374392794365954621449715918679411346821231311323476100996185815327842728964327386825980705399348021964722656926231691638306207473227031037077068888418792782089031054095068740132333953"),
           e_float("17.092925928109873230856890966518170609049635890295121605225309418908275818470576879572890960685410581830840991105430126130887790543881945170122581670877506416385845881122034595711744339948691879348516227414909772352427723381307136312192527194398703992339257139025461873121242339773525646882099071218455368070360012094043767404721710936020967834426862977103157516068354293085070758241766981055235066209"),
           e_float("17.184577662469350439927855242766012175901435587217348622500720382402437284043691040754973131531272064166131201551424433897942349835349079351126685371244284352588634150544638769966985677717022600144009093735325965072805119643341927076098445506587163233137151789343227901578709257933753169161253949701854384420333694583107005741557086141652266134114205529376278344127778702038153204605578398292401917015"),
           e_float("17.275743170440754085190445015394979038018668745865422068491523038650327582540706316060451728873454611950564439169497072829566902102398394981985975990083088007962977970505915486567012863555181572053681584109963952561485141768953808491468086742419682163408958624144213019203883451244657001188829080210013359418255598633772348738641653443346826322446562330527464133013054079541191939171126793437194110759"),
           e_float("17.366430109398423824712351054979098428930613474829102247429095866488836926871097486002790757634772330314712617641418478706058891283246904611170260177746489064263225115406081681716133431691882356650113682077003571633473268618161370540232547230765011660610678347706101216301120462332270486556205728312463947537274846803558500731691464611989523847617789541328126476219681754040672802158483643453738827221"),
           e_float("17.456645937814341319169222501542608627403113623558293524363238531385820187770170403648403252074964213113377845095534227202560251082915822197277767058606166170134732818652676480521208063952545598229201593834632528912430284433244772566961770292191780850052527418760053662080114781916361358783723872887199722599102508052518044253446686455582486241466233995573362181026486277618737441990128524043149017597"),
           e_float("17.546397922417003516910356993677316771048907184269568216409465034396055582254893824626170868646400862812069808656427157514064265326887153266704989591763035523394048363206866117961294630191139571618530051641258534288980616305897039457680785291235730766909268092549430669200289626051927041560228580907033054444893426486648638316110177880766643917771237734940434420498182546126591670171343990763488162814"),
           e_float("17.635693145022384705163262633691212915995304763116023125519426321471973674534505657400633405294778370478985112465094235780644028343844807586537417764875542174488900481208823741517400211272188843356948118444398002656002506943982233003640824565969970560720816740945971824478145915185970128692068679139758731692468366100636144656973628038665916994346324396985373751630840364738989989994328896453907404578"),
           e_float("17.724538509055160272981674833411451827975494561223871282138077898529112845910321813749506567385446654162268236242825706662361528657244226025250937096027870684620376986531051228499251730289508262289320953792679628001746390153514797205167001901852340185854469744949126403139217755259062164054193325009063984076137334774751534336679897893658518364087954511651617387600590673934317913328098548462481849021"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00105_sqrt(const bool b_write_output)
    {
      return TestCase_case_00105_sqrt().execute(b_write_output);
    }
  }
}
