
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02105_z_sqrt : public TestCaseImag
    {
    public:
      TestCase_case_02105_z_sqrt() { }
      virtual ~TestCase_case_02105_z_sqrt() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02105_z_sqrt");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const INT32 k_plus_one = static_cast<INT32>(k + static_cast<INT32>(1));
          const e_float x = ef::pi() * k_plus_one;
          const e_float y = ef::euler_gamma() * k_plus_one;
          data[static_cast<std::size_t>(k)] = efz::sqrt(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 101u> a =
        {{
           ef_complex(e_float("1.7798556259262221616563868209559734890863593605259643837165209652997880378272165299811699327565300990960492965059272868712027489696878424252064936980911848975028582397035795079119338133694542314714871335773506368863883352468573442551947943935830599665198694947540441470149339118577155502666457014275907037502436961754016214486607867810239036899917242864660748538951275871797152808256072629412571008837"), e_float("0.1621523837365052004828168329613985508660351918347885190291820732601325952958106792679933082227489257826682502623849298875240782757011788673256611687503377016237204272459827236155393021405401713064046275485116498985031364879017761357300988595090816129718451466935398446102463351043458923025077785205977044839325006211540263164669177962658420171351420090601329331167890258485163152004500877306457150356")),
           ef_complex(e_float("2.5170959652509175140543227140021035814565046580234322049869387200747016351165986990810681425942262507516826700899681833805592754345637646359904196665132865108302973650205549510319447461279363868196790088906911519932914253116113099215780756079222972745626650929251422232022391033872107934615691539118979329868088701348602109145470294066136355505159074932501202185571955347798945662814408440831616418561"), e_float("0.2293181002512921405298100779075648722903056502053369879943255508028149500869347065604415691555078456199834592074023230693899188090223203598052777878206151959764611466727863748035991029526931867763931380138284693333961628736740814161101507288193956884215366699814263036482627216448958897011038692723602651497193967240537743542142119571460474155359946006912437693699078094076589790791949724704953480704")),
           ef_complex(e_float("3.0828003742415226689047374692840825175314822032420206949919098796522507495165967919340928103366980602544050309659054217961317524683226849896587040957506137572747455980173703206666932409567402517501679964114713764065267480123418766167246725331812213714105871598209346797967113636126197244790422468438372987365403900670351360477131731193760508281319256229087677428538582953020095215093488750629498794447"), e_float("0.2808561672000323170550066704633376791143974815815369456144951291716369323779870336912189120606729032195735171984473848768470362017211418657151739962605354598177491102663557147915309501233690497108326699223328494862725338627763119229404669949049686879513742377129749328044437940303339685507150993624994123044040732958198291067013946127256881855605047136538342306440840265603220847898403146159912980001")),
           ef_complex(e_float("3.5597112518524443233127736419119469781727187210519287674330419305995760756544330599623398655130601981920985930118545737424054979393756848504129873961823697950057164794071590158238676267389084629429742671547012737727766704937146885103895887871661199330397389895080882940298678237154311005332914028551814075004873923508032428973215735620478073799834485729321497077902551743594305616512145258825142017674"), e_float("0.3243047674730104009656336659227971017320703836695770380583641465202651905916213585359866164454978515653365005247698597750481565514023577346513223375006754032474408544919654472310786042810803426128092550970232997970062729758035522714601977190181632259436902933870796892204926702086917846050155570411954089678650012423080526329338355925316840342702840181202658662335780516970326304009001754612914300712")),
           ef_complex(e_float("3.97987816970646984320139019673942761253392552062885391986823998517436829466843766309857976752416483832627381749159140990466040708043197117855012878519924364538006982037702171924036100630004266945146414961658916268669786622709542536373169657841210943908026254041868357341453066830112043626785858764134511471750864149845482873253904543870171773724004057370786638879850934233649031247317434759480428318"), e_float("0.3625837527484569753332834229402550180243906778000295342296189900242471480046307928515925927714962309462870595020923459102907452081325245594744463547947049086988968934522914986011725389932486362694036704644131738829677154051941681260399679697383774110699398380788912689927408113300967565724917442426290582730721093058618805023970129911899489799569620205747816910734629236638530414202210963389051297404")),
           ef_complex(e_float("4.3597380993412143779690205778780751518936943276758999313745847957045584466445347777536829778791896124890552250064208257801790731662599173715651585780279403277397744091450637201892087830404186455637123219209336398920714091576928183206623536153454687642926393107567443376951931211318495264626139589257290726312042973820982932789860704962237888343413758605447312547791838358945447291335150664132252793079"), e_float("0.3971906007304113150252256386719254615809052349002367761806618354944195317700984007342549347780318684075994454532778578713490031303903340744663313328819993610212639209254703709866758255065822149836023930989439226606164347475441932477099822181628312958095996399491821487297294882009435401667026020408894493378942780174621374792423113207887725365383099031875596386453618557334733616635612813658552352913")),
           ef_complex(e_float("4.7090553557999897993658369701279100512622029650461873827122641713092753288191443509377010031966022040535256926763953365880323347132597989664039015303839274561139417116845961135873109207074050955419757493266271901746799166518111088522085426916670123107616172880749479016731596709889790943926683016172914457839346624518014222113564116361044035085605288413949635414544491320753031939009487728931762892423"), e_float("0.4290148818631072309525159343901312640361567251045354557488187078930321953454608587103753344865862995112514488950673328871373753969968189417499020131805582116184169653008884904414610379935421396907837532116952178294498561498834514073457875792029200230491917190309669815247515757019029408128860071277195161764782592350237633368333616703494462008493768885675703043054466929043380814430238666376796754037")),
           ef_complex(e_float("5.0341919305018350281086454280042071629130093160468644099738774401494032702331973981621362851884525015033653401799363667611185508691275292719808393330265730216605947300411099020638894922558727736393580177813823039865828506232226198431561512158445945491253301858502844464044782067744215869231383078237958659736177402697204218290940588132272711010318149865002404371143910695597891325628816881663232837122"), e_float("0.4586362005025842810596201558151297445806113004106739759886511016056299001738694131208831383110156912399669184148046461387798376180446407196105555756412303919529222933455727496071982059053863735527862760276569386667923257473481628322203014576387913768430733399628526072965254432897917794022077385447205302994387934481075487084284239142920948310719892013824875387398156188153179581583899449409906961407")),
           ef_complex(e_float("5.3395668777786664849691604628679204672590780815778931511495628958993641134816495899435097982695902972881478895177818606136082469090635272756194810942735546925085747191107385237358014401083626944144614007320519106591650057405720327655843831807491798995596084842621324410448017355731466507999371042827721112507310885262048643459823603430717110699751728593982245616853827615391458424768217888237713026511"), e_float("0.4864571512095156014484504988841956525981055755043655570875462197803977858874320378039799246682467773480047507871547896625722348271035366019769835062510131048711612817379481708466179064216205139192138826455349496955094094637053284071902965785272448389155354400806195338307390053130376769075233355617931134517975018634620789494007533887975260514054260271803987993503670775455489456013502631919371451068")),
           ef_complex(e_float("5.628397684191500051350830477924529927151416637805000182865239049304294018306425592438437764834674403585967346025748756791598143058089454789809580778476514589362960911030440443882253277261196230033726444001765054524572401026364790011900000077255726563269072385878022539662980972000935193828628368305534394012332348670308645907088379566231519933319295422923149282421142864690983905527260842429631764783"), e_float("0.5127708606330008320162138800098718387039183640830584487256691311957979660719763026975407989302690121572251334371766754134431648207795656181417954968142534158348411775130539452107093615597504469828182579031760285613285381150964393584407507600239909772792466736644874236298829934121213983085226238190311582714586167567815027256808812294958014977556141784976179064556068434590338620711859257582923862914")),
           ef_complex(e_float("5.9031132922004355532975035115714253533443902567664501063195139219333687662022487297435039320712110475632269970079943448466486184354750541686275896455626035937516158329159868747788526943016322912511363567497809638514869662093590799798021512006724552200805001269955020621789845066832863551056180395319334887071152338655609595908833337545675526401370847198674603491795203038809281614819783396621048039282"), e_float("0.5377986157157149085988108984888832667103356501835752113865529705602689913793288235079413159248151589132138154905123030253969942648006407703136364098865508454490340630255912656825130777685077084955633581934384486542583592941279486717738468579118818232414824662480104006072544024853700319350471480115498853493033455467226197028476368315288553913315902046929622595634094788676881044847972629229500663176")),
           ef_complex(e_float("6.1656007484830453378094749385681650350629644064840413899838197593045014990331935838681856206733961205088100619318108435922635049366453699793174081915012275145494911960347406413333864819134805035003359928229427528130534960246837532334493450663624427428211743196418693595934227272252394489580844936876745974730807801340702720954263462387521016562638512458175354857077165906040190430186977501258997588894"), e_float("0.5617123344000646341100133409266753582287949631630738912289902583432738647559740673824378241213458064391470343968947697536940724034422837314303479925210709196354982205327114295830619002467380994216653398446656989725450677255526238458809339898099373759027484754259498656088875880606679371014301987249988246088081465916396582134027892254513763711210094273076684612881680531206441695796806292319825960002")),
           ef_complex(e_float("6.4173607222000473246212185487763026739784061991061044118493996883840284393104971513117491832065889983844728601027884784679663880499667199278047281774653854858146793916976698554805672961268823943544133517323430120956162647430640014432467658186211331307855306984005474662785973681499627085882987042386862909542549160235242423015600042616497115129469262618534014940889486677635019695333225545663061756513"), e_float("0.5846487340006825595524486066507063952091047520858387805219448386453924878304539738316073945513365642817157234844934361435868344031031717718481090003082304712148782117994326167948181798660503141001224290093273771620711685431736905819459851391644439560693851056090664758955069333991355520716639866755199285752027666261741063924914749974896388546149970587408656104507378352006196138345875004278154197691")),
           ef_complex(e_float("6.6596099501380061715068764956539262645972640767932178429716945274000471201963206583010867193730617036537064116514751692797661852977269362532769660351341681425026281929352654543034635386295929320723277655734717123514756744986290253129591995950064636070829446731910718709747929799673325781351622759244650288929999652439376097517779815955351564754299951658618102221296436663096155234044083496545850879199"), e_float("0.6067186643906974017586809275048106258841707354673233509470648918441350790406621506456289014189604833657419185247937995386067707763427173586694549088107503296439255648717341066492388799093834126487379083013348733979652229913793144194550379842758237416194517425512765819584150743774932918822022151009092974205359548307299154013583826012508357391848901684050976215107639185328459509946966767298541738577")),
           ef_complex(e_float("6.8933511978658363667897147030217206266421604778667729052197025625017387876679125200617371866368525935593472191420155588790094227241535293116699673071471152001422168151033718931163540065939945894445737800834687468601948187334807750956037336069661660375301643428943221934046622618199952167587494948164329142072804967503208498817664425478033412927468945823714527494261690289673411529814167633169541634355"), e_float("0.6280134817593190360713596345946004894523061914945736839866181167248231448475196571558730212727273310625463201711210727254348245159797495076630306530704127471217834572010069560942608366805251760110262726604803409965192335949916945537278073751641555797243928606038042169816405809212470101074119647906958880834409380100012749630653796111733165318080149447480513900664668912368413338071264277493564167728")),
           ef_complex(e_float("7.1194225037048886466255472838238939563454374421038575348660838611991521513088661199246797310261203963841971860237091474848109958787513697008259747923647395900114329588143180316477352534778169258859485343094025475455533409874293770207791775743322398660794779790161765880597356474308622010665828057103628150009747847016064857946431471240956147599668971458642994155805103487188611233024290517650284035348"), e_float("0.6486095349460208019312673318455942034641407673391540761167282930405303811832427170719732328909957031306730010495397195500963131028047154693026446750013508064948817089839308944621572085621606852256185101940465995940125459516071045429203954380363264518873805867741593784409853404173835692100311140823908179357300024846161052658676711850633680685405680362405317324671561033940652608018003509225828601425")),
           ef_complex(e_float("7.3385327440436490342374277858708016631885556608084326734443267646139517538755129561702128570293703134368652209556943518949103671323765173828919541047228797799541263421355102534907283185786372477669204307754949002093975045010994574641544098203148220969292348778429862840231425639143593085966688806480429828169478334403182803968971087793594030811223513430192867740203156274054173641192325288267781438323"), e_float("0.6685714055912982404459968394702554895618956252539023378416243333785524813634578728823730322633350121286255093436104905152591550900629654851603436818067592709613455099374045093396640997754739987915085751318794885259972647546908836739870570735706591366376441428809365161760795199252517812657995542499444323499203141414514754391101778039298570235001593972168350656254035621590786241753380609269175478575")),
           ef_complex(e_float("7.5512878957527525421629681420063107443695139740702966149608161602241049053497960972432044277826787522550480102699045501416778263036912939079712589995398595324908920950616648530958342383838091604590370266720734559798742759348339297647342268237668918236879952787754266696067173101616323803847074617356937989604266104045806327436410882198409066515477224797503606556715866043396836988443225322494849255684"), e_float("0.6879543007538764215894302337226946168709169506160109639829766524084448502608041196813247074665235368599503776222069692081697564270669610794158333634618455879293834400183591244107973088580795603291794140414854080001884886210222442483304521864581870652646100099442789109447881649346876691033116078170807954491581901721613230626426358714381422466079838020737313081097234282229769372375849174114860442111")),
           ef_complex(e_float("7.7582108075047340401657071863636940637039593436937518934469640293586060190157933850583475338715009820537805131075981663257865663805240876131438930137225075192811364397762951013684523793447453814026680733956636904304928739464117106936808736961829216834535111150532155021216110712808452428606500618416997250850090906604853158660384690541009454611722891951623887032537268378842103356308805542276278832423"), e_float("0.7068058541616544142170638752550070753408453695024884094844271727236864964130126847416569106074936324833270264530877145844606334604021999497961466236242982268433171353162898314369836120563796059356499204179541567565805867079812060920211290811584166728862389194532799186366644286633058981483673279335341440788073260498676517617040736931598864584080509867456160661825304722424623348309027158788788406671")),
           ef_complex(e_float("7.9597563394129396864027803934788552250678510412577078397364799703487365893368753261971595350483296766525476349831828198093208141608639423571002575703984872907601396407540434384807220126000853389029282992331783253733957324541908507274633931568242188781605250808373671468290613366022408725357171752826902294350172829969096574650780908774034354744800811474157327775970186846729806249463486951896085663599"), e_float("0.7251675054969139506665668458805100360487813556000590684592379800484942960092615857031851855429924618925741190041846918205814904162650491189488927095894098173977937869045829972023450779864972725388073409288263477659354308103883362520799359394767548221398796761577825379854816226601935131449834884852581165461442186117237610047940259823798979599139240411495633821469258473277060828404421926778102594808")),
           ef_complex(e_float("8.1563231318999191284617900781966706761738669707252702476075767664027025473638115138372183353087329875715406624821661232175105783862797466245932411290956616549628205946848468050204670761928302051379935590284070084016733815724375067596649903700183698678571409309316798301122053500002328089065546308890875162000336154717155804361743442548506229610813411071352171553298967063075126318453522944430700876529"), e_float("0.7430755725900613677761221708440489306033033142506506321531086193957722429895394142681598406356603460661245581473585888405694744033787646389001396582510420750320234168788097577061733594811547868015620140235290007919166394842254388897635282794457084333409586725303350810051744148245235026868813541212243751375766310891290769051382783015249630197695032729991412315616106919825231564399991757816166314667")),
           ef_complex(e_float("8.3482628780547471236157221792748501432210191839711987039933534143025247695478488978278059806300395313058929807678338160589733429599067951968159752790224576694426957231198583784967543833209734844322835541109683872343171770905782100795666683305965814309371217207868748442924651819490908353391031630456193122857999854933085322015847323324942482273417768886436630408438155914723152429166491079898929491818"), e_float("0.7605620961706403610419640840092461551266249257672499387618274245472156463948486454465397680045425287805964742002958663011410615893523888910376808132634979178751550054021875479476740005688809290565069607449522911996343082341279822460220320418200441163048302027846196146750916157035962560537463845065295193452348242132495758137796568395821655714459435354495360412112272342968933386181405033871542243509")),
           ef_complex(e_float("8.5358877177624679506221712041220698043844764010567246727840875724932885349306805720047780791130566545047918720455545072945379292328134702943253909560435364214785472103614288254575931402485735540114988150350007587341818138008701585207283548398127335974145896090125229434166200802300462919365610471323698249014276580131370796830427306219412101832216572333575272875857573683955798967732736869859298826728"), e_float("0.7776555135038323854399395648293040308499010196867375157475883015981878451553225481097085010355233401341823980710067537922503690629092465214513159441995713240708143097310181278267944021408673751715378350235954218661607867042556843508404417352337540325674435559950488668137064346167811517894980666455601322502472374718319956319424178586093208376173018266341952750445662663655094571547488208666389941894")),
           ef_complex(e_float("8.7194761986824287559380411557561503037873886553517998627491695914091168932890695555073659557583792249781104500128416515603581463325198347431303171560558806554795488182901274403784175660808372911274246438418672797841428183153856366413247072306909375285852786215134886753903862422636990529252279178514581452624085947641965865579721409924475776686827517210894625095583676717890894582670301328264505586158"), e_float("0.7943812014608226300504512773438509231618104698004735523613236709888390635401968014685098695560637368151988909065557157426980062607806681489326626657639987220425278418509407419733516510131644299672047861978878453212328694950883864954199644363256625916191992798983642974594589764018870803334052040817788986757885560349242749584846226415775450730766198063751192772907237114669467233271225627317104705826")),
           ef_complex(e_float("8.8992781296311108082819341047798674454317968026298219185826048264989401891360826499058496637826504954802464825296364343560137448484392121260324684904559244875142911985178975395596690668472711573574356678867531844319416762342867212759739719679152998325993474737702207350746695592885777513332285071379535187512184808770081072433039339051195184499586214323303742694756379358985764041280363147062855044185"), e_float("0.8107619186825260024140841648069927543301759591739425951459103663006629764790533963399665411137446289133412513119246494376203913785058943366283058437516885081186021362299136180776965107027008565320231377425582494925156824395088806786504942975454080648592257334676992230512316755217294615125388926029885224196625031057701315823345889813292100856757100453006646655839451292425815760022504386532285751781")),
           ef_complex(e_float("9.0755185679757069153484108370012134873803417840930112514990375214790968114957110089286083791753938443278452565451509362014258144312703226974453922211277998588199913570422552805889514130826856265406526204761621134099230868895452988817261658613675356690823414356020660013379654775522865213383955347912545407180657341929841942158058372539575476040080621446797267480646871171732488372690050803717274298251"), e_float("0.8268181688480253409197756590942383848555170467354679345052130149067050134201471462582461305300925089672167907633830561900366660085244046276811845470224687441330248335999503499727638996165773321984901201529333485702197820243769239437735526567089205025213599293665461363181021268455828193849582243853339405204567426931509270840689340041552391353194396920419199323872954073140865336225476583157436296136")),
           ef_complex(e_float("9.2484011227245680067142124078522475525944466097260620849757296389567522485497903758022784310100941807632150928977162653883952574049680549689761122872518412718242367940521109620000797228702207552505039892344141292195802440370256298501740175995436641142317614794628040393901340908378591734371267405315118962096211702011054081431395193581281524843957768687263032285615748859060285645280466251888496383341"), e_float("0.8425685016000969511650200113900130373431924447446108368434853875149107971339611010736567361820187096587205515953421546305411086051634255971455219887816063794532473307990671443745928503701071491324980097669985484588176015883289357688214009847149060638541227131389247984133313820910019056521452980874982369132122198874594873201041838381770645566815141409615026919322520796809662543695209438479738940003")),
           ef_complex(e_float("9.4181107115999795987316739402558201025244059300923747654245283426185506576382887018754020063932044081070513853527906731760646694265195979328078030607678549122278834233691922271746218414148101910839514986532543803493598333036222177044170853833340246215232345761498958033463193419779581887853366032345828915678693249036028444227128232722088070171210576827899270829088982641506063878018975457863525784846"), e_float("0.8580297637262144619050318687802625280723134502090709114976374157860643906909217174207506689731725990225028977901346657742747507939936378834998040263611164232368339306017769808829220759870842793815675064233904356588997122997669028146915751584058400460983834380619339630495031514038058816257720142554390323529565184700475266736667233406988924016987537771351406086108933858086761628860477332753593508075")),
           ef_complex(e_float("9.5848158785182461201467726031818202827167578224313886671438643470105434720139720640026414156957556755942035146182955908259330850657859524700657959526944111491303280423609108658263396858793802188410179035915508510223638409405247198379853837812738917365940726810764198412477436752840952378163188174333731003013826706584086517321534024885359637199954094793356581236929314559771470507898735133617383621242"), e_float("0.8732173102907971161020167122393384348861762181040310283513009799057291726810694060817101166518805015103439610217862934528756091569712436909495439762322851053526408595233653975627662390941717276831571378825636703342796101694381514605390750153800827505267742978426801731108615970432763110167532273575449548344819498144612473284637102706417773671241041587105798005566577982027881143685045121324484108683")),
           ef_complex(e_float("9.7486707542226864479617545792981302849855307201072288241764488940354098349333057703308549732110817474379351871715403079185320023687496096040352279356284321456076495654578912233661757249682237358751645882531626436184015948566590187040396383939451645892824927080588854234345158245399159121263359851570234624939636196203342950580510183258979983150467991074740859420659833024875542117405869594611075223055"), e_float("0.8881451832571773213219955822115250120273614551132931813087248635762819101109338892363889005304960942773834458038097168071785462564297760749105624264188672373990249917986283763168851139034105080147348238482032677391209859866461374803385406696524729922769944129997571141205923093569327358956900661154242035381535133602252602257548346584279504083224294278852044105079923391819703783393995367200667448675")),
           ef_complex(e_float("9.9098167250145421806914710437390666018583712993693172011334929671621371859307737579569734245950995650679092220635868050055350770905583574292239318372393602145372233020824644022229705676681915796360636704350342130329876952130293611199757150889237506102548734414049713958726462659609500554558251782095718731127274357462931395826162388969982081350221896668579065377902985475878304982554076944656220705503"), e_float("0.9028262635160520869011208999116640894696312882138804711776376678039841086488169331514721572134022011921493412976105715292873850746753712740378771359135448980219496519397409285763169234532599446808571972370849975074072669015986412131313337653521661267695371085823237724883846876717680575003217737954787534018493343604277538287805896486528515358049365637698828063346184397322788555529435866151063284516")),
           ef_complex(e_float("10.0683838610036700562172908560084143258260186320937288199477548802988065404663947963242725703769050030067306803598727335222371017382550585439616786660531460433211894600822198041277789845117455472787160355627646079731657012464452396863123024316891890982506603717005688928089564135488431738462766156475917319472354805394408436581881176264545422020636299730004808742287821391195782651257633763326465674245"), e_float("0.9172724010051685621192403116302594891612226008213479519773022032112598003477388262417662766220313824799338368296092922775596752360892814392211111512824607839058445866911454992143964118107727471055725520553138773335846514946963256644406029152775827536861466799257052145930508865795835588044154770894410605988775868962150974168568478285841896621439784027649750774796312376306359163167798898819813922814")),
           ef_complex(e_float("10.2244921449263383188933097687492676073712065412319822350037182035817678012517856584257670034523466114565923740783696992013403812613295369546667462927312752030553136403230044903959395020578073872251099882031500805945876681061788901680428263796529995743029847801493502525260166150995443573989940817587969408248790988315081400555980550637166527416919716495797553309575735247375995127893827648029636530706"), e_float("0.9314945266598283109916647230576756929959518914424679754813711473671562393986396279532179385043252491428299887688258753253928671103408936386357956684338197537872150946094498149910921058446286442570304357019413164915823639641133164959012631336389891157385729846952815742910086775305361131973269627806572494685136872207400307867635867890778542548875722166882238493371479300200594222659325431415955616823")),
           ef_complex(e_float("10.3782525345455734164585286064415342655676227031305107996356921495387148376502655963924233290235567360705508644459405729938477746987786701423580390475482685236736376789152594799190106649022640565339321166579631737863083918956647112570276772319410186316605825088098113759564333572644697687504932652049633021512329660598253619985797063641587775641799613890174531539231276114369914082141630403723756620391"), e_float("0.9455027492020572820219647015810594321991019162487437417238203563160228910011078782025305891464245280198166925854072362333142677582595997185980050543362761657398228673628988771179525890760920027395479444114970654467590484006478980551438938943588439258962878114058868188400169233728915401409573580835290801346841131443566705745599667760764350098277502996515178771426848272441900289677274937913929184044")),
           ef_complex(e_float("10.5297678853782357539378731515252250852896315129182699253036898963289936665126747793215176197844375606829098068611271088052640354994799464180705332501608833115011527124728732926763166637522754345937340494330380418504213170526370782535876719530931494701775305842658183074070079206005797064014865509812664954314196401195431149177078316739796515073425906492911709120664090084296985466961445794185368960361"), e_float("0.9593064392049493944114439581974079209448002264627136883925200016691316596612555491995392803301048366645113791030277989721052377452300263637699973869393377459305858147245853249352654510246834367945324039019814138270837609034658193503955758030379389546235261554919968278653557489788201365016144195323241246206591003886124311540190388585222916284773258437048646409887420492304702550273250587977457980424")),
           ef_complex(e_float("10.6791337555573329699383209257358409345181561631557863022991257917987282269632991798870195965391805945762957790355637212272164938181270545512389621885471093850171494382214770474716028802167253888289228014641038213183300114811440655311687663614983597991192169685242648820896034711462933015998742085655442225014621770524097286919647206861434221399503457187964491233707655230782916849536435776475426053022"), e_float("0.9729143024190312028969009977683913051962111510087311141750924395607955717748640756079598493364935546960095015743095793251444696542070732039539670125020262097423225634758963416932358128432410278384277652910698993910188189274106568143805931570544896778310708801612390676614780106260753538150466711235862269035950037269241578988015067775950521028108520543607975987007341550910978912027005263838742902137")),
           ef_complex(e_float("10.8264391107245087006071288017373755846847231787152987216410059859491730133788039838189700657163907099400572416111763922759503825263553556035940326702470707392521145058350218156964247967348539276908021675868316607040458987572715668830282254041929423932432434222616422740698401682643273696506148600237600148146939893708546288559203650050577261717978881308528722901657883837524505576857039098080891934151"), e_float("0.9863344439909522600954741788325712629660629789944586687095851464692113648080932467072135343902528248588375233497873817598506583683611792989579488942138973296861739887366671058354150320169345046768443442713206697877942607673797153057238038971410633561836991716566937331641190799691018029051993069932196158528044832994280883489569611536771676138126371561377407910884935252020662880848308701451124466866")),
           ef_complex(e_float("10.9717669437227162986451634616376178160513543863016590910747264632847973730883340424559705657212678428250258370322171555564910850378523471780296353955025070187573062438492035738460684484155425431655801205179959630453159127629347092668524110945616376030904664536911709299656438823752231551358412306260152765580469590363037120571114383742729363731759118838503780264269658945834744116578100157463104418025"), e_float("0.9995744249201115775946990811244371899124522167188439153062702875222738381444618532723620784510238712886877959729868584235833635096805448591411295415608090059930589015606863719968623328478274526774387866659049836455119322683739174607561142544157856208079443355742573228460103609151020378131047774289765286509720540949779722600143522253883567739247208058263203175918252844336273928250610611606000723501")),
           ef_complex(e_float("11.1151948213473855832828739182816728567932368898751079851615161850302217215138640871456382014403088703704889762887607573732140275183406417317326949352956603533220707136415532620904010027007428264000360101939131802310247746730888219010664487089924993886603163932118573702878837456076369525082276001396409653480267590888615847261141324092697355848798661357705052987894209583622370069665264570431376925623"), e_float("1.0126413118700039552862003584205897802525599154757833353361363594586827907987078983087556182210104163324783325331314499577456616263131883982021351088859631302510911094133153956797547090225674162363435450426435557695102577789938938720221247268606553683702104012860773594323116667154892417125665778106726615433442098484358482436590136214393761725158928409737200264666535279538224311513053703039714674193")),
           ef_complex(e_float("11.256795368383000102701660955849059854302833275610000365730478098608588036612851184876875529669348807171934692051497513583196286116178909579619161556953029178725921822060880887764506554522392460067452888003530109049144802052729580023800000154511453126538144771756045079325961944001870387657256736611068788024664697340617291814176759132463039866638590845846298564842285729381967811054521684859263529566"), e_float("1.0255417212660016640324277600197436774078367281661168974513382623915959321439526053950815978605380243144502668743533508268863296415591312362835909936285068316696823550261078904214187231195008939656365158063520571226570762301928787168815015200479819545584933473289748472597659868242427966170452476380623165429172335135630054513617624589916029955112283569952358129112136869180677241423718515165847725828")),
           ef_complex(e_float("11.3966366974994068669693722895798720933601860834683540885803623195977972053065936082748618624319692937725613371623121077606192549530162053182907099588496033898258440877033807458863450785145396956587728774643096992518512518869181895483702017196085161959140884395389098883144587374824756181845838442005261543864295234288360768376236655663637766926928397628991225210624621498927246901198533555361555483817"), e_float("1.0382818584607285171993482711500858791425988192675679861771074004089962778003926556365894102734436237499740749579908794961991287284973903965664277626152664582471276801506353315168093207401783814651872015394355619186527180409477027357547686855874909038667136245004021353202848630686415676337702580439830174762105983590277690986175809577275451468385839312151554899211454489075104263187828141263769329138")),
           ef_complex(e_float("11.5347827922302642351124266716672370596360095342198466563726987734900696722101636843698082413145402578668429796057571182079863049202056840570652352974533728970494704440785071821123588432053745586112404512079656677022271327860295828944239524445867117230416794789172588520870140968049814228141586296983658705456852948360604768629638466275219435441642589656730482510368955852277240860868121882442497230256"), e_float("1.0508675526250180697400934918910301320540417318115654250503862806163137517017719870322682312147041926491113620028571372811084867497670827801843841386329692226893097308396717357336662888014855072741113491906430894771570882899024948735328947562982571524740768497341153131688077768577681181890659043382762320958430715754463609639632709663368112939281792976261553260186138717148066528722870009202345248984")),
           ef_complex(e_float("11.6712938491442599447361999023295657909834573708759670875486448341369561337772813453330820092123616957993799977349770509769687955110173448573553972789075646535859381859496583011325985952715790836729926302539898590145016985454483467624782154267505652114156192831485100253557103758817949211434186629300464572307683540060858111267659974101387741957644212010236557085987558880004101371408985059841970871605"), e_float("1.0633042879211603924399435236281900940749121274261116279462046897985503752224093859163658241735330193302231441795137350134512008780200657671850016128108733278313393435359756105829754586986434903138600566712615831259607740710791153208448467116202399653831284991511935266514965135523649670976907771546858096247122353434132192951655388024831373002191891780494534069612322535646170342135501893375869421105")),
           ef_complex(e_float("11.8062265844008711065950070231428507066887805135329002126390278438667375324044974594870078641424220951264539940159886896932972368709501083372551792911252071875032316658319737495577053886032645825022727134995619277029739324187181599596043024013449104401610002539910041243579690133665727102112360790638669774142304677311219191817666675091351052802741694397349206983590406077618563229639566793242096078564"), e_float("1.0755972314314298171976217969777665334206713003671504227731059411205379827586576470158826318496303178264276309810246060507939885296012815406272728197731016908980681260511825313650261555370154169911267163868768973085167185882558973435476937158237636464829649324960208012145088049707400638700942960230997706986066910934452394056952736630577107826631804093859245191268189577353762089695945258459001326353")),
           ef_complex(e_float("11.9396345091194095296041705902182828376017765618865617596047199555231048840053129892957393025724945149788214524747742297139812212412959135356503863555977309361402094611310651577210830189001280083543924488497674880600935986812862760911950897352363283172407876212560507202435920049033613088035757629240353441525259244953644861976171363161051532117201217211235991663955280270094709374195230427844128495399"), e_float("1.0877512582453709259998502688207650540731720334000886026888569700727414440138923785547777783144886928388611785062770377308722356243975736784233390643841147260966906803568744958035176169797459088082110113932395216489031462155825043781199039092151322332098195142366738069782224339902902697174752327278871748192163279175856415071910389735698469398708860617243450732203887709915591242606632890167153892213")),
           ef_complex(e_float("12.0715681773536079149845442218413663358637896128785842343870473496904668567496254286520948358026583186062906237487370887977565579710707998763097433057597386241930322137456898628713914096048784450582231431440311206002710323252834683723504769976039007482370346687182197375989927884961058403793182702219471924818241268779955789613658191947607454109877301942450558019351130460649640110820457801124199661881"), e_float("1.0997709740513333202255885175671737496703712075961327876304596006222649545855617512845215199554512380069878821927928598608530307567476001582433232099858727527796996496454362840634118189703862449136431355999833657957824427769262660869450158153139826162894957981294074948335176037667335188527093920670482989355377402040341191869273515268569299350532528886290343872172094743794822747126022549631356175792")),
           ef_complex(e_float("12.2020754099307848651933214477144624907035253947281523563903223462035897497288345735737103212408605171560597913669174383724660847920999719918152883395106312113462872884928997404417752350088199252096360914811437576583580558585415604280518965548641652474654902978538860426442716567807703329796519639475352716470342796259076445360825380731034533188100492363612431663709770928185732896876290759583989786147"), e_float("1.1116607355291673264558178031383648688736736589257213307112244752536179432609464485808104735516390724470891343107872042893454468406954438447510644845627398902138671891623156286248855938387846404428591304823137559974974928290876310177319283647073259439728489690863597954155028227833873472527206862034123687132472960659530236784345250453828036504938610889787520566584041349347867610776918746189835247891")),
           ef_complex(e_float("12.3312014969660906756189498771363300701259288129680827799676395186090029980663871677363712413467922410176201238636216871845270098732907399586348163830024550290989823920694812826667729638269610070006719856458855056261069920493675064668986901327248854856423486392837387191868454544504788979161689873753491949461615602681405441908526924775042033125277024916350709714154331812080380860373955002517995177788"), e_float("1.1234246688001292682200266818533507164575899263261477824579805166865477295119481347648756482426916128782940687937895395073881448068845674628606959850421418392709964410654228591661238004934761988433306796893313979450901354511052476917618679796198747518054969508518997312177751761213358742028603974499976492176162931832793164268055784509027527422420188546153369225763361062412883391593612584639651920004")),
           ef_complex(e_float("12.4589893814835551315947077466918144236045155236817506860156467570985162647905157098681895292957106936723450755414910080984192427878148969764454558866382942825200076779250565553835366935861796203004099350414544582047183467280014097863635607550814197656390864632783090291045373830040088518665199099931349262517058732278113501406255074671673258299420700052625239772658931102580069657792508405887997061859"), e_float("1.1350666861555364033797178307297898560622463428435196332042745128209281670706747548759531575592424804786777518366945092126685479299082520712796281812523639113660429907218790653087751149837811991448323928395815492895219554153124329501106920165635712908029160268547789122717243457304212461175544496441839313875275043480781842152684245738608941199459940634209305318175231809396142064031506141145200052493")),
           ef_complex(e_float("12.5854798262545875702716135700105179072825232901171610249346936003735081755829934954053407129711312537584133504498409169027963771728188231799520983325664325541514868251027747551597237306396819340983950444534557599664571265580565496078903780396114863728133254646257111160111955169360539673078457695594896649340443506743010545727351470330681777525795374662506010927859776738994728314072042204158082092806"), e_float("1.1465905012564607026490503895378243614515282510266849399716277540140747504346735328022078457775392280999172960370116153469495940451116017990263889391030759798823057333639318740179955147634659338819656900691423466669808143683704070805507536440969784421076833499071315182413136082244794485055193463618013257485969836202688717710710597857302370776799730034562188468495390470382948953959748623524767403518")),
           ef_complex(e_float("12.7107115656914513988698026104276706130852007048387173580166835726634832036597503577497137727194898983286660895166615991985716794845012618334937216026992204351337064686376245882102660197371532244348781590362898566196483932949706819323240887803785648138012508594409355940374237602703501694938711408532366887594812623803641528312119351360347782415702768491950084996034946989169702402620850605943188090215"), e_float("1.1579996429718675212847872150190562656959834358122228838620531493459760902930034540929663279152910552751657960976027335689514216007615707591618551456181989154072189770362439047740806663743098090259265901923815662225212098676046051414791620171888715939158223074773208841738657173488518843864389957156072743610098029276765314198222751482854945427289287495532769667792417508602588352802524577659480536348")),
           ef_complex(e_float("12.8347214444000946492424370975526053479568123982122088236987993767680568786209943026234983664131779967689457202055769569359327760999334398556094563549307709716293587833953397109611345922537647887088267034646860241912325294861280028864935316372422662615710613968010949325571947362999254171765974084773725819085098320470484846031200085232994230258938525237068029881778973355270039390666451091326123513026"), e_float("1.1692974680013651191048972133014127904182095041716775610438896772907849756609079476632147891026731285634314469689868722871736688062063435436962180006164609424297564235988652335896363597321006282002448580186547543241423370863473811638919702783288879121387702112181329517910138667982711041433279733510398571504055332523482127849829499949792777092299941174817312209014756704012392276691750008556308395382")),
           ef_complex(e_float("12.9575445437970567664732493165616150402425655670339854788443445995022424327082722622348599715235360536133492517687476840886701406492542129315132820260585599761562068481648736089708033653029015193440048846261165823557124852412295511632180356862044736523007646769637096155673751012191928840488459573730482182764195806889279379644274720911746571695778382155947894095149974118651070638681754551271568273782"), e_float("1.1804871724105409866749531895844963560819112307320477479269319319834068028387170144545135030437600999194871717352735658894740187962114891284814536513277826026358335943814956194035949299637353579945705345354036955714917464410934520876853407619526929332812930330644151604846562547023459142404303919406240686474855931345439215477538935511203951511835054228514741222998264184317762555476220951463416619933")),
           ef_complex(e_float("13.0792142980236431339070617336342254556810829830276997941237543871136753399336043332610489336375688374671656750192624773405372194987797521146954757340838209832193232274351911605676263491212559366911369657628009196762142274730784549619870608460364062928779179322702330130855793633955485793878418767771872178936128921462948798369582114886713665030241275816341937643375515076836341874005451992396758379237"), e_float("1.1915718021912339450756769160157763847427157047007103285419855064832585953102952022027648043340956052227983363598335736140470093911710022233989939986459980830637917627764111129600274765197466449508071792968317679818493042426325797431299466544884938874287989198475464461891884646028306205001078061226683480136828340523864124377269339623663176096149297095626789159360855672004200849906838440975657058738")),
           ef_complex(e_float("13.1997626002427530063586377352260787307066745446394018431465626183535668272634484960405196752798548641193342354309785228266148637345491256091458658398357019996928296849152790870459048931499012262341451554218186769970040360147138904972738061046105218073073592494787318470375125636684597960861079912216836139503649367321304350158980078874369328752689574823363378466842132288524520830815703298300530151842"), e_float("1.2025542629456252496571139996118579096188014778701994605293778897922231626562155792836909836608358031021202845263376375602203234434178794378939724782749483320112271935653191217992690761300922880234000540628423793377309582513551099776591956655976076261037901374405239889576784033958995100089246960468573938095191497442407658702178826008167146521977351813178039488896006653496460151333720328241991515292")),
           ef_complex(e_float("13.3192199002760123430137529913078525291945281535864356859433890548000942403926413166021734387461234073074128233029503385595323705954538725065539320702683362850052563858705309086069270772591858641446555311469434247029513489972580506259183991900129272141658893463821437419495859599346651562703245518489300577859999304878752195035559631910703129508599903317236204442592873326192310468088166993091701758398"), e_float("1.2134373287813948035173618550096212517683414709346467018941297836882701580813243012912578028379209667314838370495875990772135415526854347173389098176215006592878511297434682132984777598187668252974758166026697467959304459827586288389100759685516474832389034851025531639168301487549865837644044302018185948410719096614598308027167652025016714783697803368101952430215278370656919019893933534597083477155")),
           ef_complex(e_float("13.4376152944281662173780606383710482482459985464882709505094068937825711777685649752259331973037925543189736514844942949752230556197444278368351847926003123764023251709585360302321276798035091032273922755161717457870116282884314860226878670924864098576035692884602535372994737095961831882758927573417316429480879008539824700780875855039741354673444201267297788895747254507078079698233360078107387251901"), e_float("1.2242236504951036379646146677997841410970551905131509331593567234593193945580231765486179095833993539562578037963042113360511811648116341030486257490311865870183232810109012318561455293728575037250508325627011164650260648229897143360507152767190968713881875045828158033566884509935870107030531136239070257632172124050807289438984997563095850034397814078912774671334347078922992491462576407298460965634")),
           ef_complex(e_float("13.5549766082494954755164132644558977030416938652066064991073573785027271198750753048857458793526472941116947120841292493711392309162373014090526524045835398632855820009931572650985737758196058183626381455544955746125971955683776784911051486568879640417413970161270101929452346097997002887950558562054869991601538488038573082823166164522495483981966556517013601450936653326697098652286869226403037112844"), e_float("1.2349157631122005003793849254347205037660852457780323376947897148433973376533362593420369948841198432164465119150586406165071252451565200627182957226322176572363795471113466316012568817038129499232777822760635398796319112980160794293096614725436728806571583859227200553428076562117807402086794414011429052482409943231139242766557840565297282339807953565020778136469831118869176307584780384170948137189")),
           ef_complex(e_float("13.6713304729032214411532923974847170858023227231226433581784414844335764012621689699808781445102811328279667519604238458774349023480275010658042549787413308302858951437814610603929813402191832317604829041884141075227749893286860972746483998142248134939242921098071171184596429959833324974469632101608693242360794705142804053150543424252592947207680891854710467367668582695882232717545574396976553268694"), e_float("1.2455160928444157755660429114556378689114560510368653854263521222184690677266229081096571243511875378643542900664996628145134258183166150046949965158021882228738407095881257697307464299248387473216150261938410840293145859026280157374666049055062365083836049744803158528540335834501553373904902338547122301826825090196920349894172687966350820259675680422633821155546360550266784078445273950299428368415")),
           ef_complex(e_float("13.786702395731672733579429406043441253284320955733545810439405125003477575335825040123474373273705187118694438284031117758018845448307058623339934614294230400284433630206743786232708013187989178889147560166937493720389637466961550191207467213932332075060328685788644386809324523639990433517498989632865828414560993500641699763532885095606682585493789164742905498852338057934682305962833526633908326871"), e_float("1.2560269635186380721427192691892009789046123829891473679732362334496462896950393143117460425454546621250926403422421454508696490319594990153260613061408254942435669144020139121885216733610503520220525453209606819930384671899833891074556147503283111594487857212076084339632811618424940202148239295813917761668818760200025499261307592223466330636160298894961027801329337824736826676142528554987128335456")),
           ef_complex(e_float("13.9011168255509121362171100137829939304445532869131376186575529977285959603057328909654364586143409952039018690331346887634686708084928357476313155325341083472117143418046230756764147228178057645148593099458105399751937340258211114090967831559529057801782860426817722867698016059443724209632681953463207284050204977433317735077428631232141781216358755554261591794528478935615191928785940606804969844758"), e_float("1.266450602525531198940041441771048200204744024135553167294454981572826990180830121500899262776654708055395294073410694368846603386283546682420882350919126399041585609024208581988232323379738327782988688875235847985095051198620799048905543568881865231410940099666501660890649464981746457618514029935769952553084218905761410953622005504809098914586720725248562325879200887245574029352743954455426845102")),
           ef_complex(e_float("14.0145972131472937537900246308180289683196710025551270098918407136053996936970559367376151243755305368990288536898588868098163113351832842814898752618073162184399197275983648340683671478297875832114754902042253279421756557926990973128253164419644345156714160313134680510348643281686797876876291490926886782738386787017378723513159178447291585483373308309519015737753687814097832619041450557698371594785"), e_float("1.2767891463310266748399354671707863145295285680198687297537633722013313814596009086177450868623349085488583550727680938196810567037942512949415978452478965480685759443431412285289686153039990558236678394647683850523939394799530885835594873117603988097044247879880980526541680268904787928570825062998364424568254158377709374553735649058957320688945219591870798987199690795230770450470314383953560984274")),
           ef_complex(e_float("14.127166067399969398097510910383730153786608895138562148136792513927825986457433052813103009589806612160577078029186009764097004139779396899211704591151782368341825135053788340761932762122215286625927247979881570524039749955433326556625628075001036932284851864224843705019479012966937283178004904851874337351803987355404266634069234908313210525681586524184890624363347396225909581702846318679528867727"), e_float("1.287044645589321692857547803170393792108470175313606367246456123679096586036382576131126003459758898533754346685201998661412126190990456825249706039541674634855250895902665471324383113980626419072351259635085653488349568449650354222037362737608760069147575157092900944574254727105708822438658021383158548529434777705071290010500085011048338602548130665702710912916340078713014244329071599913039026211")),
           ef_complex(e_float("14.23884500740977729325109456764778791269087488420771506973216772239830430261773223984935946205224079276839437204741829496962199175750273940165194958472947918002286591762863606329547050695563385177189706861880509509110668197485875404155835514866447973215895595803235317611947129486172440213316561142072563000194956940321297158928629424819122951993379429172859883116102069743772224660485810353005680707"), e_float("1.297219069892041603862534663691188406928281534678308152233456586081060762366485434143946465781991406261346002099079439100192626205609430938605289350002701612989763417967861788924314417124321370451237020388093199188025091903214209085840790876072652903774761173548318756881970680834767138420062228164781635871460004969232210531735342370126736137081136072481063464934312206788130521603600701845165720285")),
           ef_complex(e_float("14.349654810976449577566547585469740863368843959805585908869802248556413223446912372560373235310666214484796189366350904260819775143850174689285108472217439837583790172754815874453840602525710486934632252093288907402034335611016882827050024262748800791390323594426677845882161802144992376144978160313313173287868203904007700753385113504145344099934288943217328274013652220447321304119467585627835788445"), e_float("1.307314312184718780829834648911289302580611912893255000182030710455885459538085187581518046886674589052253262891015451237740947835834323236815972033278514508393705794872154132044122541055894020499251419414292448181818702163996892996280739665486379520337885734634867730459227619063208374521328651801243011654305585955125431435819821854953929928373804456586811430072479662901382381969528271896337111849")),
           ef_complex(e_float("14.459615459732004537362974720942112340969667169522461993105871493015586469021521969393589434662138991787697212605461530419281094005606353528649452030828640233180405376332165458218649998094852748066066367239566998867151271290294425476450372358629329667611127074492824559957108257278529341724181883798446774270393940193576971680303104653262853683530009997887516649811518118528982450530922294737325776818"), e_float("1.317332192878635753878620502352567503818448652418774607688944587902120199666051297129238235116736641032964820351643911062128560297350314976696612203493096698366531898347539686863666111321497649947048428524763343092419776268309797034645340608981398448719433280374621243578695496345270517405609301630251416890114204627840060109958043644561826024290831247936634542955082176076327029009930952367303418381")),
           ef_complex(e_float("14.568746181207976999836978875918563639735065981641550172744192667923344641374830911868068451462540620721037097689501487244434820810658059379163896097493586025965380193590838501980384624216841136300297486235421455997465972106748404225587094170801834708010797116267508039210614294417611363537738468628289640186347414602338346682317388138400374067785526370874895108249872251778196861671321219991017387096"), e_float("1.327274463683328018946770700239590551014279275359398577852809707132349388509513900280954989111018716306814352620063148895272442293487803168583152617346125335636092031594668495918637240819805811650683969008101130191699727021282579335132123055713644136407064324952673204057140716091486417069579914558460927398128902180259830500079748774353731155490358557106727101788836703097537531926811106365620736773")),
           ef_complex(e_float("14.677065488087298068474855571741603326377111321616865346888653529227903507751025912340425714058740626873730441911388703789820734264753034765783908209445759559908252684271020506981456637157274495533840861550989800418795009002198914928308819640629644193858469755685972568046285127828718617193337761296085965633895666880636560793794217558718806162244702686038573548040631254810834728238465057653556287665"), e_float("1.337142811182596480891993678940510979123791250507804675683248666757104962726915745764746064526670024257251018687220981030518310180125930970320687363613518541922691019874809018679328199550947997583017150263758977051994529509381767347974114147141318273275288285761873032352159039850503562531599108499888864699840628282902950878220355607859714047000318794433670131250807124318157248350676121853835095715")),
           ef_complex(e_float("14.784591214867743550921651319179715303005930550110149083108425200330612353621610131368055511681594337292810543117563543438247694977601039048776376412814875441135059061406131404508127543982891069939684357171782635432918619032578607457034194747634227184055416643646737106908028388878349100622428249031680786744459261605698735989526469596838161410767285041592896908671937503073943114950773113525185395881"), e_float("1.346938860174702844612739041398097214065520582568714234019250813218197601968844469309215213982165317786291801596537964652400575659785528687645343186059993629268148181441625458742742351250980558127776075689541088600858446048899998046336331066805178554508215643737645197929987204680232943933690840313603165676763474976010923324328708999266592615141670538024073655105264968957771066641682252986096798557")),
           ef_complex(e_float("14.891340552142566765917882665346549445499503171257684334405872391233205991294864058138533741179918623765734571861595842118072318965796425892401888781237649798244193208429232482071337292423424384278205970793951127144627895493588677364133858224631304724034410029837124650600065129088951634773234322490672052031306020671639927256377667518622224039361209384522648031447343307704573065772805310760584262659"), e_float("1.356664176795480413851295885203608141930407107607920211417468490830920198603732346298221117710429722850465779830739186881692373973628620133184282395483874600931740441629544362773415256842580384936106754930984637995685277839295681663769512473559301358671622698038572283790258695189502776115217160329511904172339969682312505775026833979454683569241013439203651099862981493736784821820111226227829648158")),
           ef_complex(e_float("14.997330078684902683103351616582993119516253095757541339069473761841237528081440217927756882513793093460649975933756490714423211444374911935244669805622961343156826504810774252594568862900817440179468290619641024842733339530203605174563190700233084686437629649397288237157714070077287775226699151911836498940804518217856931908228421610530487561165755446183248467324135311209636814698554505141517107554"), e_float("1.36632027144135915921143818301650969974158415036013402481287933002201804109249287616431235807514013548659829921043221528201766188292457186963500255091299088805174992797839751860372833841660382292166920299688424427256146660963816250375640888742226489427917021149381225853629698381722612903976499010050207843974423749318776926884151618854286512011746066438326674457186056178167510816113905011587721842")),
           ef_complex(e_float("15.102575791505505084325936284012621488739027948140593229921632320448209810699592194486408855565357504510096020539809100283355652607382587815942517999079719064981784190123329706191668476767618320918074053344146911959748551869667859529468453647533783647375990557550853339213434620323264760769414923471387597920853220809161265487282176439681813303095444959500721311343173208679367397688645064498969851137"), e_float("1.375908601507752843178860467445389233741833901232021927965953304816889700521608239362649414933047073719900755244413938416339512854133922158831666726923691175858766880036718248821594617716159120658358828082970816000376977242044488496660904372916374130529220019888557821889576329869375338206623215634161590898316380344322646125285271742876284493215967604147462616219446856445953874475169834822972088422")),
           ef_complex(e_float("15.207093134038120878437441357595413724031689606149097068680412746223677293026714725449973271138098062923376590149897591758522653857666843021852108179114413505461496990874965278486025713199922508219849107726363341167097547698349047051064846648205322261673590012599518611183942943620832302492092532830288792363097472907774426313220589872656015357590678462245180684852242310404518389143471285160870999215"), e_float("1.385430573956865961918186999661809804312065910301134748773319852258396363161252445035664559084845431917459163609800680561522451543712236658987056736359686940206348939023228403965029698632646083108216719573741681471268272477555645807885208920775394787351847475376828289983511784433877262186045244218452588587152986777379221350957409155770548526062294513599768623856687326465238607727091174754514122336")),
           ef_complex(e_float("15.310897022593110678549871232137949638562307288957746848753817220720746231819496166170146060365014628588285805018143030558247801623640613321139409325100769119478470256792114633052178065414333132247589159701398200757333050325920727644537878774152952943393507191424171638983974577054828439798927126262203288085684950960331583936860315030735239697890177543995397516390865769519173688155322498903447659131"), e_float("1.394887547727730589037161845619053453425218513352042484116928514325632469106885529731682453821414054751150196213211992160097667921388811645164024082566614406174265750962514380158984854865225684863211080632519728851356807327745626842468717375601042755462364028475469399545006951404640268368911002263413942748425412584762859860348691916153582953831039867451257764065472163236408565261088788981135689386")),
           ef_complex(e_float("15.414001871207613344523687346420412587657411016210103474959549398261253747582983959670464051683490301272025154829527108980658762341613424948293520478753068786373727990086851603333466204783701258750839982057356882032633740061709383083623362665906106857052935799104673398983556818063098622395211234219186493682701950335175680238565865596880254140659628114543838714269291476510047607546744375314749397224"), e_float("1.40428083600016158527503335231668839557198740790768472807247564585818466188993516845609456030336451609786758599223692438423518100860570932857586998130267729908874555133177857395765475061684524855416334961166424743136266931388155961470233497452484343975687118856487466402221897015166984275357549681249706152202036647909914553350697306362844092780252356826917115322042013280161042394920157307995649")),
           ef_complex(e_float("15.516421615009468080331414372727388127407918687387503786893928058717212038031586770116695067743001964107561026215196332651573132761048175226287786027445015038562272879552590202736904758689490762805336146791327380860985747892823421387361747392365843366907022230106431004243222142561690485721300123683399450170018181320970631732076938108201890922344578390324777406507453675768420671261761108455255766485"), e_float("1.413611708323308828434127750510014150681690739004976818968854345447372992826025369483313821214987264966654052906175429168921266920804399899592293247248596453686634270632579662873967224112759211871299840835908313513161173415962412184042258162316833345772477838906559837273328857326611796296734655867068288157614652099735303523408147386319772916816101973491232132365060944484924669661805431757757681334")),
           ef_complex(e_float("15.618169732202114013249043442296721719272267845573486001638895374220597270519273019841797287719769549701862730188471269069255640344967054404695526723647042943443769430174852379649023589769795687593900908797524268492302304054480947864118574639898320444954867894861170801999734037917054951360320350705021368332256452600701525357863104277721058006516470124880696140496228865136511516626619711631787905232"), e_float("1.422881392618574652887578663864633430895594983222115420469017994599421403826286923600197577061539884488965762650522747960078758697972623946333210295064463449866670337418812557885391814133638157909208946720233319258417905803411796708964728819484945987417141474325042142503528923940731949522472001942119435348749202035878495065841320312661366782216846119301173798508677870854294369440737940046889989755")),
           ef_complex(e_float("15.719259264768663959432801382107681838205685180362196660928265160223455242729303810848440014521645876614876779128253870126810394580321260767844564343269863005918106310564681404253562988944489780046238068023021038093081753712335747493125658310720925467500979505621750492917061570362098912441564610739840642758241412759697548975180708837355380998029339435224035669788935095281911360904182186497341316657"), e_float("1.432091077065842634230131355180452205902075876578682301328904282393769557463408093163431214527700112078087924113307639626848398388163272038806673979806377022584163402678970646373762214508931599546099980889555601632060325598251595498638037192930204457570262967255608505743732678022225341374292684077645091579450984266034787468539010532620563057152124968802671747489332240088893489770914957418027790851")),
           ef_complex(e_float("15.819702837985190861450808431675259066058086482834247530858082187064931932710154731326406940753912506356729321199601968923589220077495293139037714893799381806245752393745596022814499273084465799637042732858322558029609915835976006859804917712491543243241402519844421591167197645868866639013525120957549556411290712697478003925114021675097330938081890154224145953776320527029201394959903931189228533262"), e_float("1.44124191188122060634582814404090076941103867141048205940870769266767723658715551257892167102279955413480755788008385341645833233721636865955446848803360643179692951515069628808529852646190491791148769302024491635309703756236291398837139511953150526114356642719345939242341729620662395731899068927064506167671718094547729199625377964536632633748669647182543286374570079612348196635311190446314755851")),
           ef_complex(e_float("15.91951267882587937280556078695771045013570208251541567947295994069747317867375065239431907009665935330509526996636563961864162832172788471420051514079697458152027928150808687696144402520017067780585659846635665074679146490838170145492678631364843775632105016167473429365812267320448174507143435056538045887003456599381931493015618175480687094896016229483146555519403736934596124989269739037921713272"), e_float("1.450335010993827901333133691761020072097562711200118136918475960096988592018523171406370371085984923785148238008369383641162980832530098237897785419178819634795587573809165994404690155972994545077614681857652695531870861620776672504159871878953509644279759352315565075970963245320387026289966976970516233092288437223447522009588051964759795919827848082299126764293851694655412165680884385355620518962")),
           ef_complex(e_float("16.018700633335999454907481388603761401777234244733679453448688687698092340444948769830529394808770891864443668553345581840824740727190581826858443282820664077525724157332215571207404320325088083243384202196155731977495017221716098296753149542247539698678825452786397323134405206719439952399811312848316333752193265578614593037947081029215133209925518578194673685056148284617437527430465366471313907953"), e_float("1.459371453628546804345351496652586957794316726513096671262638659341193357662296113411939774004740332044014252361464368987716704481310609805930950518753039314613483845213844512539853719264861541757641647936604849086528228391115985221570889735581734516746606320241858601492217015939113030722570006685379340355392505590386236848202260166392578154216278081541196398051101232636646836804050789575811435321")),
           ef_complex(e_float("16.117278183042581403052673949854040265125727833102649831700908356145482408257185114360611339485295838381899330510143579136211949157085823068447905252730696440923071381081633772805780676181580059444525694153761692112787632789701695090402263559680109334008862078330373698797986618063317789731787615214659536895163740521872209073904843936180493990456595234000608300759643165641404514449135012152327895553"), e_float("1.468352285801104534075782153340620216338534839561809468601110747940536373746952794130731949028759808130369326855748296594544582588524118900149119084961166672016154145492200796901471744028261110784904167604329649441537921132359345983974772016092764931860783960988397709062809230805802961501437646450938027482522815798976355254178632275629533098191468035859984520651555685228965737247929573395842259342")),
           ef_complex(e_float("16.215256460467148535014099142387606066938847752169064186361781357455096485852578138220814942961531999262789614110395895294641874894949683254937537586740415792958923465554985712704465349307976357453155125195967776066123555047077418256194672609314835893562598499468775439103429332413657972219223819967251008969195999535807810696606188104033699272171449802450074186636350537881396482377282599637148166086"), e_float("1.47727852173134887426477731379704422342492913237436665440696358166857703728704879465115960712495500378782127546884650606077557726554327901597067685173358206678162423292183231941888376524005329015637779011933056863900195987456799748615034998755287861751045830293706664078773253443338962780393710869520092903786064649887414476992401992545617265164674232990949771832142614446410177171108834489646698118")),
           ef_complex(e_float("16.312646263799838256923580156393341352347733941450540495215153532805405094727623027674436670617465975143081324964332246435021156772559493249186482258191323309925641189369693610040934152385660410275987118056814016803346763144875013519329980740036739735714281861863359660224410700000465617813109261778175032400067230943431160872348688509701245922162682214270434310659793412615025263690704588886140175306"), e_float("1.486151145180122735552244341688097861206606628501301264306217238791544485979078828536319681271320692132249116294717177681138948806757529277800279316502084150064046833757619515412346718962309573603124028047058001583833278968450877779527056558891416866681917345060670162010348829649047005373762708242448750275153262178258153810276556603049926039539006545998282463123221383965046312879998351563233262933")),
           ef_complex(e_float("16.409458070789664147919644414372869909462126595621500848231848699189572719454219851964801591795524098644664458125730954633152277664604915399568649672661054805822956702454998766589175520612416322411803337878014212857586454911202170910642090398931814153307343344226393242467269730486473119390386437680258197827186108320791737731680132365307098354962769147611145175895910966955193667085722002532411478747"), e_float("1.494971110714725845146069193255105199562894203989849273229286628938663171972004100215017732316899980199031052149477041731216279753519286290970488473776505432736267056480421847050691820391386375071843436529719445489053097409576818710299606766673100040738084974541486688402222734531826337401664355118047812282378209279132282883681295064700881221229241374761626990375054407554286184542656074426072394486")),
           ef_complex(e_float("16.50570205190149645652463151302033532668476311871631846917876391863678839639387659113970069428410813433992570501671448737071818403346065471894380457388232130137418703656997913447683628958679938932960395965242506249270401052941511104865152609741197820159769420790352081712009837192165420080375880146079841517055470527048363896215667225182272040233246402292099894329757768376137652755928952408716869786"), e_float("1.503739344907571378958800616492349996346623359576610322696364787065444785779018572959650787219764950883576348482844682552064329976132535869344974180351299128825385588967144314579468527355709337763849944387224852862789922040480690547451721313296714633685861713981344095691119979615182811617385846591051887205839511692811755064921422581801442343950306569196941944854268995423551307889279725909425180864")),
           ef_complex(e_float("16.601388082786526272555189218855254262579035746558678918546767662325537092838192196207490501607196611904687826633631516405048516480358287802829793314458664219190140145152500610470376863363105093797815804670101050715797835909734242931346525737308347909801890975220837058779656235302554588127603569849917905815810916751753428614159589460017234819826561421705418640504171351700725433562123505598220746481"), e_float("1.5124567474722980497573157226344339848637897392605253789792360858457489963370556731568523949326991892694849467292236739922002140955669738935299356553878274408116736697728588515193941282493543296839528480141758841622788021649187508628665782670939023349951672588004684952577883683951915367177007381416147537818693554698554403173927961563131073981180008497982332850126216706167008457825715547966512046")),
           ef_complex(e_float("16.696525756109494247231444358549700286442038367942397407986706828605049539095697795655611961260079062611785961535667632117946685919813590393631950558044915338885391446239716756993508766641946968864567108221936774468634354181156420159133336661193162861874243441573749688584930363898181670678206326091238624571599970986617064403169464664988496454683553777287326081687631182944630485833298215979785898364"), e_float("1.521124192341280722083928168018492310253249851534499877523654849094431292789697290893079536009085057561192948400591732602282123178704777782075361626526995835750310010804375095895348001137761858113013921489904582399268616468255964492044064083640088232609660405569239229350183231407192512107492769013059038690469648426499151627559313679164331142891887070899072082422454468593786677236281006774308448702")),
           ef_complex(e_float("16.791124392772776509134550892497809620885734238717432560007725562021811441426398733520113832480673017454475972800280522348037205797236740417035557914226695204038399267776423699823886812628608574122037275272369647256936614090303516553076912189774412766614056781566139300165936241689613295674716642546889087028575613387636826339494900960967919207450558490882821447990455501002385180943878750582466087107"), e_float("1.529742528688192163908987751139835188682465569037423531591835622097128047714283729138375760924626467060034317385315244637209416240916627070050107259709983786556495345152362220115420789630761530222608274334541211995051915564687508880161283022322747516272285373018367883526995081919482977242671528368781156291148945842637383174358905982273664149725388974690738830585922679028423810621332767358690703634")),
           ef_complex(e_float("16.885193052574500154052491433773589781454249913415000548595717147912882054919276777315313294504023210757902038077246270374794429174268364369428742335429543768088882733091321331646759831783588690101179332005295163573717203079094370035700000231767179689807217157634067618988942916002805581485885104916603182036997046010925937721265138698694559799957886268769447847263428594072951716581782527288895294349"), e_float("1.538312581899002496048641640029615516111755092249175346177007393587393898215928908092622396790807036471675400311530026240329494462338696854425386490442760247504523532539161835632128084679251340948454773709528085683985614345289318075322252280071972931837740020993462270889648980236364194925567871457093474814375850270344508177042643688487404493266842535492853719366820530377101586213557777274877158874")),
           ef_complex(e_float("16.978740544335183131887407943608991580580985508681019231666429585220114488787557581085303644475998167030296114699949333887506050614528938545510767517756220141438740262165816811244526484848944880723909683493368537144869605805989898199477608861520723828582648559941200810108153631049629107201779576826937364492948525044436948922834692120284402439606161786735148861941691686405526140411576765135760599675"), e_float("1.546835154494558963795852636550424438860929333280761699663069613447440318923838466463259383087594542272982984081248513194093686698974257059052523285671101537694540676668173537077221754980046395896920691713393773160794943231747983831837953167933878265061879900596206159377576191957950590302635885980235925758077047902332924455724730181248203616098412211420940641563954693126594491877631974645546223504")),
           ef_complex(e_float("17.071775435524935901244342408244139608768952802113449345568175144986577069861361144009556158226113309009583744091109014589075858465626940588650781912087072842957094420722857650915186280497147108022997630070001517468363627601740317041456709679625467194829179218025045886833240160460092583873122094264739649802855316026274159366085461243882420366443314466715054575171514736791159793546547373971859765346"), e_float("1.555311027007664770879879129658608061699802039373475031495176603196375690310645096219417002071046680268364796142013507584500738125818493042902631888399142648141628619462036255653588804281734750343075670047190843732321573408511368701680883470467508065134887111990097733627412869233562303578996133291120264500494474943663991263884835717218641675234603653268390550089132532731018914309497641733277988379")),
           ef_complex(e_float("17.164306061421004588681496957314089408374086877512669465139849447927735706994094859225922122315168882377529890233697875547965318549342125231255641328261384681718127219888869806668443302817858379554473634314179799701177671263152608704910481659339207834968772925203894873323020402723092368697897604564375612022618544632508325045060215258257809740708112905609451887652276075381055703621935929249275552634"), e_float("1.563740958817370035885629366846832757950670821243966068359604108892504226935582966702261847398656035987805456175101970933578903994577552999417429603261571624056967999170439110213935068288651687704300226164989263404861971493160213669830588276649614889841701176979077618217823159252274446515090048201722860095963050105118156558024212452653672210716494603497758002343671732055228397494778570491612828728")),
           ef_complex(e_float("17.256340533823359358210749067238182167627754173967969131970897162295497467543818253007824561147823423964437785481143529895099441375380314630939680697444898067412834285209654641807744657440864111549781344906452070479176392101892174156709592514531537305114614668085214959658664986551433739009164487086522756478819176030383186816462170067113851808872188889335249952607035307973726756163209551788137913295"), e_float("1.57212568894299879601427479688377951219733431887333514898250163979060606473763791111810444656014695196664733643760124974316727712392047881170774326165045717197709212810186858302136933296647394196655919404160602071471350900074250505935219227591582988937778273209168821873753677621423753661050796178180284570156698776677545038850091693124015086427985017502221377563694488013883251751749495145815961532")),
           ef_complex(e_float("17.347886749354120887277530736379247103216991008429397668347881479161298867778834347294755384729228068225769961294997717181879322772437853047244101230845194966705709255529583056269889567242476519972686385648333868621594923394855516147800731649283716558066419560113848484763540888033665154503442421755054078897161190968343232651275648124843258644818306896926809616466358715769042704657614044244829447251"), e_float("1.580465936800261900243149997387915988136685330968399032305149165686942241059156079773599440105196185414543613410349792347509351269433325774887062270306181002223129960366483295424322184486002552553483676705048510133923751623490945806134709198438551048948092515399147089832104880942736399765226403555234103160896549285342207547636402884914119704931996960999002444769562951011584965735265147253858436463")),
           ef_complex(e_float("17.438952397364857511876082311512300607574777310703599725498339182818233786578139111014731911516758449956220900025683303120716292665039669486260634312111761310959097636580254880756835132161674582254849287683734559568285636630771273282649414461381875057170557243026977350780772484527398105850455835702916290524817189528393173115944281984895155337365503442178925019116735343578178916534060265652901117232"), e_float("1.588762402921645260100902554687701846323620939600947104722647341977678127080393602937019739112127473630397781813111431485396012521561336297865325331527997444085055683701881483946703302026328859934409572395775690642465738990176772990839928872651325183238398559796728594918917952803774160666810408163557797351577112069848549916969245283155090146153239612750238554581447422933893446654245125463420941165")),
           ef_complex(e_float("17.529544967474162455115012468606804898664861813211567846737098466217355052566598187274423464321115083270846212046029465176388588580332807700354894961764769222635184678845725120790091233763460688759060999390340904160137322748841016491835904923556378499604723427277548066453277404442468679485934083656975074253599507943828064736664645561464902289160030797408728287307628308941683882321285951561478980499"), e_float("1.597015769643115050587294901611689155818523617537895611919502240009177946556762807725320943075892940098987588074729527688893519889593684147112790224263669294261382196793573040367265225305691178077178693264264384162484894029154691677118298915284385947478107548007006423122760959873575534963956903048569395910519339514460488280401669495532422837169282690936648902434901160626216969254652574343731119678")),
           ef_complex(e_float("17.619671756756422598380258998014725070195532606164025434908571040522911445816190893567476998159583755261778690629777283663914928041946352451932937665593005575812081555143884657223613222895554707737753062234838063953039977181279169451046529255456080921938655650475995562415673723710475554230984077383285530907662090944021476401829205846295448853611352452750841529900368743459261963970085908582131492993"), e_float("1.605226701759044983708670545352954106032139551437358915960278855619704650608542945923090984088554919339884214451816261485729431663156242518636944514744306371835228026709504623625193720668852307434751966096799285333773140115718569912771055101735769818950756689869984125537839051514271227907727084906521856048035777068376420479499483700022331908751962204838706385589354665853612853554364807293467436492")),
           ef_complex(e_float("17.709339876601306659892510534714276060033170770299350318958541765800106298606746189230511796213633142689680991023983034539945855306425162505882768936687810781254847498747960624336558082904896873753409070249342891554460898628077239939406453602017365660241500380986506186536953520049859065316854118595800466121345701596682878772650001263702657920411254159602381047538560911642784484445935018986314411785"), e_float("1.613395847147144725796432695466649800131006950550725634159658911680806974137986470523823947774445476739641446471536909076190982794401922310940909229659652536347102189076773797047539233305523125486690074580315345962775077882383846015321540573735645469724447398744031201821763207456110095805141444034649656047910036640167859108542910494586566173994770614078886778690228436603064313454391788768850198953")),
           ef_complex(e_float("17.798556259262221616563868209559734890863593605259643837165209652997880378272165299811699327565300990960492965059272868712027489696878424252064936980911848975028582397035795079119338133694542314714871335773506368863883352468573442551947943935830599665198694947540441470149339118577155502666457014275907037502436961754016214486607867810239036899917242864660748538951275871797152808256072629412571008837"), e_float("1.621523837365052004828168329613985508660351918347885190291820732601325952958106792679933082227489257826682502623849298875240782757011788673256611687503377016237204272459827236155393021405401713064046275485116498985031364879017761357300988595090816129718451466935398446102463351043458923025077785205977044839325006211540263164669177962658420171351420090601329331167890258485163152004500877306457150356")),
           ef_complex(e_float("17.887327664110802874629942776617108102722847111436804461021380132257405937250796230515991147214293833592468630882014565953550266624185407080490973469462114876925390583878388993209710801255951110024702430213236491859011650732098852574408969140779687735914899240908541453609423413698164086017960809896246545506168827508097264558472259743893186502548938175375000148373205440006926992785109974168546064951"), e_float("1.629611288220143147558582369803702521024571929635327097198679605707661591694799457527810549054903929567360629262065262192809216126104145886542755555735420842234908084719159597494413661072760516448778266881079449253388804382205451175592375695960232845518290798623506468561344117367965140479076061041715742711404399104241852281487318335469939790732026004958000942845868444306121516638355337838633536777")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02105_z_sqrt(const bool b_write_output)
    {
      return TestCase_case_02105_z_sqrt().execute(b_write_output);
    }
  }
}
