! Real-valued quad precision arithmetic and manipulation functions.

SUBROUTINE QXSETDBL(DST, X)
  IMPLICIT NONE
  REAL(8) X
  REAL(16) DST
  DST = QEXTD(X)
  RETURN
END

SUBROUTINE QXSETN32(DST, N)
  IMPLICIT NONE
  INTEGER(4) N
  REAL(16) DST
  DST = QFLOAT(INT8(N))
  RETURN
END

SUBROUTINE QXSETN64(DST, N)
  IMPLICIT NONE
  INTEGER(8) N
  REAL(16) DST
  DST = QFLOAT(N)
  RETURN
END

SUBROUTINE QXSETSTR(DST, S)
  IMPLICIT NONE
  CHARACTER*48 S
  REAL(16) DST
  READ(S, '(ES47.39E4)') DST ! 40-digit precision unsigned exponential notation with a 4-digit exponent field
  RETURN
END

SUBROUTINE QXADD(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = DST + X
  RETURN
END

SUBROUTINE QXSUB(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = DST - X
  RETURN
END

SUBROUTINE QXMUL(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = DST * X
  RETURN
END

SUBROUTINE QXDIV(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = DST / X
  RETURN
END

SUBROUTINE QXMULN(DST, N)
  IMPLICIT NONE
  REAL(16) DST
  INTEGER(4) N
  DST = DST * QFLOAT(INT8(N))
  RETURN
END

SUBROUTINE QXDIVN(DST, N)
  IMPLICIT NONE
  REAL(16) DST
  INTEGER(4) N
  DST = DST / QFLOAT(INT8(N))
  RETURN
END

SUBROUTINE QXNEGATE(DST)
  IMPLICIT NONE
  REAL(16) DST
  DST = -DST
  RETURN
END

SUBROUTINE QXINV(DST)
  IMPLICIT NONE
  REAL(16) DST
  DST = 1.0Q0 / DST
  RETURN
END

SUBROUTINE QXSQRT(DST)
  IMPLICIT NONE
  REAL(16) DST
  DST = SQRT(DST)
  RETURN
END

SUBROUTINE QXISNEG(X, N)
  IMPLICIT NONE
  REAL(16) X
  INTEGER(4) N
  IF(X .LT. 0.0Q0) THEN
    N = 1
  ELSE
    N = 0
  ENDIF
  RETURN
END

SUBROUTINE QXISNAN(X, N)
  USE, INTRINSIC::IEEE_ARITHMETIC
  IMPLICIT NONE
  REAL(16) X
  INTEGER(4) N
  LOGICAL A
  A = IEEE_IS_NAN(X)
  IF(A .EQ. .TRUE.) THEN
    N = 1
  ELSE
    N = 0
  ENDIF
  RETURN
END

SUBROUTINE QXISINF(X, N)
  USE, INTRINSIC::IEEE_ARITHMETIC
  IMPLICIT NONE
  REAL(16) X
  INTEGER(4) N
  TYPE(IEEE_CLASS_TYPE) TY
  TY = IEEE_CLASS(X)
  IF(TY .EQ. IEEE_POSITIVE_INF .OR. TY .EQ. IEEE_NEGATIVE_INF) THEN
    N = 1
  ELSE
    N = 0
  ENDIF
  RETURN
END

SUBROUTINE QXISFINITE(X, N)
  USE, INTRINSIC::IEEE_ARITHMETIC
  IMPLICIT NONE
  REAL(16) X
  INTEGER(4) N
  LOGICAL A
  A = IEEE_IS_FINITE(X)
  IF(A .EQ. .TRUE.) THEN
    N = 1
  ELSE
    N = 0
  ENDIF
  RETURN
END

SUBROUTINE QXORDER2(X, N)
  IMPLICIT NONE
  REAL(16) X
  INTEGER(4) N
  N = EXPONENT(X)
  RETURN
END

SUBROUTINE QXPARTS2(X, M, E)
  IMPLICIT NONE
  REAL(16) X
  REAL(8) M
  INTEGER(4) E
  E = EXPONENT(X)
  M = DBLEQ(FRACTION(X))
  RETURN
END

SUBROUTINE QXHUGE(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = HUGE(X)
  RETURN
END

SUBROUTINE QXTINY(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = TINY(X)
  RETURN
END

SUBROUTINE QXCMP(X, Y, N)
  IMPLICIT NONE
  REAL(16) X, Y
  INTEGER(4) N
  IF(X .LT. Y) THEN
    N = -1
  ELSE IF(X .GT. Y) THEN
    N =  1
  ELSE
    N = 0
  ENDIF
  RETURN
END

SUBROUTINE QX2N64(X, N)
  IMPLICIT NONE
  REAL(16) X
  INTEGER(8) N
  N = KIQINT(X)
  RETURN
END

SUBROUTINE QX2DBL(X, D)
  IMPLICIT NONE
  REAL(16) X
  REAL(8) D
  D = DBLEQ(X)
  RETURN
END

SUBROUTINE QX2STR(X, STR)
  IMPLICIT NONE
  REAL(16) X
  CHARACTER*64 STR
  WRITE(STR, '(SP,ES53.29E19)') X ! 30-digit precision signed exponential notation with a 19-digit exponent field
  RETURN
END
