
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01026_poly_laguerre_l : public TestCaseReal
    {
    public:
      TestCase_case_01026_poly_laguerre_l() { }
      virtual ~TestCase_case_01026_poly_laguerre_l() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01026_poly_laguerre_l");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::laguerre(k, ef::euler_gamma() + (k - 10));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 111u> a =
        {{
           e_float("1."),
           e_float("9.4227843350984671393934879099175975689578406640600764011942327651151322732223353290630529367082532504853685527501929175190394959855134571637758260023550764637464996662570626622623260572074047417529050839912647960518343291467668482233884713788004984920152062549142942599700786452138533059703956745784809412244647326686007459870325794862458604508883148971920157651224127949615689060026386274469391106687"),
           e_float("43.39443231288853073109406716735359780290811521072557888351774432015245562907123162546116100139839049350520531030363037448762129481863256346539817659248099480880889853036248226677814011482349018128458496895404835328228016950108948710453780173146087839172731417156145640301789753710564157758972301378511311732102902666578717677819013205035031668000642738388637500325337955029597798330469780350107410038"),
           e_float("126.30554395184405220056551225037643057656541153127295830056224697933871441227602381854148527830255325830363081145840140969081376339407985115519448478095112860890710491375937482092712843982919982948822191717894508341327417460522128300238416827867116536002438592019517226352798171124418128849329608403169647069564602486315659585520802154630568476253733821393866099039638833435377330236536231217617689995"),
           e_float("253.25245121829444474736391021048631867957837492574202229239107397317997194699982938561012402878777274764253099946734160817060091411941797994731995291565020743636213629691935345717719444102404095394421685636505383775413191902465709182204454441571611678763823382210757685746338611368084468034404267018141484783147111338239995453707786930275312199078492710425502266856657386076542184887186402911152084143"),
           e_float("358.92719649139770926427249738647975621493192510609332029574562553149102345159850596299090983102368742375371826676441329263568009157555839478382539188879130628254092027203609135872868353456371413177156519186539904029751670022556981738461171717038822928984207793133557971795478246164884423757094837030409326691441760175467402921452340043506679823695701398924730461059597012607514636899062169248273674628"),
           e_float("354.57234486869609280371866449588054534434821930545848269275064697306344804463505576506015602840327382185698681764861625861631375357426624379223564363946542685878001815319627305548233956830387602726697393527801628426668467492100733172833165483157225311315986625101478254382597472144356021179427135657843407787983414381955091206175833393415246859108231272081917733348039388478925052959197984270866552977"),
           e_float("229.47171581760009343871508520668641253216065994525062482309627344353234423299520377425009525049292112981960367501012109420892430444090018922799783916777502416673339727224897919750597093786363804351134458413483051662339644869661911518303518288901222600605648282633040124120885001066873288879515240249687547048756255401246697952228858051000074312714543992043692323607337026949666890101965283389290868682"),
           e_float("82.618870681764318428212218883983784668105806364892580305657471070958521773632384417865904799219189009052544390598197902233700200143753127770527450500669554032203728616120162597073585517820471578022320732244382996466291076538774228293907196053236714299369666456799629296404815844577906856047990562301466672280395579514869323122638476596886504404047823694964154126906501267216161782159977572651983230613"),
           e_float("9.2631019284685992681866329393188870915478790830234332323410171040342281471337220239308533928731511843902785019494110905536554142571205119064161838248403323073214940930621384874652756468826555296452957789863988289315946942073606266535423484826933941776259865619562212919306581448772699190079523842952653769428211485438917188150911953912573670562193326826014138291362372438641488344336018853497565152499"),
           e_float("-0.27491329135011954507907096573621561586991032743665235110947005417720923418183465494785219411349685535731371099331510751998540365708496897028016982146549002334598869869510698623925900307626507377014249713365979517386607488259396400514574990302288574189425116800167081092250992087641233854864212983556523481193583717881158050572440833223460287161752689236851590226360713007481782988422981919945567238557"),
           e_float("0.11081887321631386685041886260352369180405948978960418905416249189464396555083020752929561090224545357677508673347704521023063427721014391417912394706983466365463331456377512040277069809143273457744442886689871517526841742313870161116208663536033529159808272118063579508145903766679116456569898483838474277226767186176161465756439471553278619588775356833921097855685093024761571718093725666918455981528"),
           e_float("-0.44510927280982915113204597501041781290640587409742157463993476290753296755960190855914328875975139797594913331110312669231553463248083490956472604692389272779074134846619251875833703647687268850962984841380574322357772115852012655785911688159432124097458356943362066620857177258491492617966420569329860904871857226568788375814350986780283590502403775617430970912857558867995003231426799132783580257132"),
           e_float("1.2066881127956628583691530888385060136032347604451306443173482291583461880154930856002207887448966658720333601539818492125373014034012735488384778002538877435757241667102355399600528878945840799861323964357550881794355972982226299372001543892562425607638815310246537886130548738284486089129626900458827154151771490281087653307128827621053064069615786965229030971174438511397811166046362101171669914462"),
           e_float("-1.8139664815736740136401881413521657987702392992718399687495060488748830185712458430242469210854477448488735448316541317453573063541157194311049200685647184995158976435344507752044818763954138250663904537000302048970563593813634120288093613840776043948925620850612738311066316096839077122285651231206876833618197894970471826096268120585558159480349585878133848361962497624919862408116404100006531690893"),
           e_float("0.74237710590152300645518061028662897329858188061381815907485194098060344490322099439311126797727543391309047736876230193197080170316320548964855632808879940784305609956275202896749736452644815193406259964121894257876836043861970472631683687033824548160352719815056967323214580306353265628050806225465107383670720992301291411090027206976964583531031368773750743575500838523054229032055043605951900460271"),
           e_float("3.1945797566863203972370930216759496362890838177556549744517137631905244347340146479741859218467462078345470746937313701589314473438846747266138564670057326579411328608401674989401731205368695964836290463467016359092323465102104420646769540783561751206845614047195688371759678172965859516923183315192320267498049396406048626111970086256368214031957714822882327004290344899933560055086283166115921535032"),
           e_float("-7.4480966066191160492940319200590743689959511729885118646907895065650354962513932440196680549992129535614992215173690389395607375866175109351846669635345758875082281477908225615083281569712945820275554953371722373559304113977347860562754221850803753244048408114136149000497236477966980711735018837919258684085122620803374964367961503534680134552022500583315993069973267371246495365401812558296341328528"),
           e_float("4.065693349082855490428250450322845776584817451748785212391193931445369125817031921988162199589165110701443058019885048013089131967213456391531081678401630925363250014109951982375815439340788052610998169495026819586271134286325728010884579616322208742436384433531817775943346180651074745867147619036043506612808432419156570211236310253251340410285029681278944177597213386834347084297934789931117220296"),
           e_float("12.635920282646273929468565354330650908962456007676567415301819460962560187148480476803354647973573619105089444179437321877185922563123765754054266994069899793243274499602628941325786960366983170055935654671672903498171898030417620714430850098137853781529268130677534279749320476626408076505534824891243790807112826698732353486760837489412288320227596458134039923618116213456664476976615780737249146636"),
           e_float("-29.143943646470270777018407570627410095885180656878466808186199966312487069289183477543476630775471632930224962706294189466887592947677188092579821129027294568747220718725345100960520641416479359504366056989377308735756000120009015352774540645326767958354655859615946908528594370943899590054600201601459410047443685048492820135575410828990565069354090914845278977752561082655444205478906073052194700571"),
           e_float("9.4529491734620520847136655977242569058808761973848370859202944434101186340688708331045583892202772198345834669308811175074597231067804765945058721174165571789317871581865359309750299860058243750138460666312927125447292398941897029626225568573238739630906400007782862362487534475665180454391105102766881365782758490910343543904734160227593269964237829857911325939778378186378482414255034549820841043805"),
           e_float("61.675027888375747464619095318515458235690071346071828520228254895567459488735889772442457246886070135124044678564785112670273049636442514567322451915066559245099369087199207451891500707723051357440998923282948303784313941453037848492080783834367309744480452172585739851577509717804549892176474612871382611059393583936286093007805289010583195331582531317134779091336379639118510758552477684403810870451"),
           e_float("-108.12872969252700728368403281538272401070449211295888519220676291982408810437572467121937927888412039760867814942225271994570439718033352878723707124992255477908691208376462792562391223402609188185073879387489127939216257015699611609559586844228135080014145567827626406018724147586529505444018760896923149366257831214950268829146526932693593089798908328793418565205790759099300009153171614141928766626"),
           e_float("-15.461315329636831081133941449721340207630533447974139397077057179957568786351751952575910571570223759468930263547612903662077982475152741115008781806171162242800215034340586752705908222607092306587152013804026206360895952572673213306358105719732705371932314483201477090597711842718869511854242047969725252500230648884329006214687145820311861470586307015409196979618445302345300466701667372054184097533"),
           e_float("300.11739671492531504910286977875370683853930004617624426894139026758658357509800066306626649202292647541792224311020824250051651331393050960244244442201824120514606754651399686746152575659431980043421535471466234148303247665429073975334484091663070163115651444184883467843241321464458757588241848277793035280411314528702855686354854695184215133544229928847324999983140445991155028360321414096920099505"),
           e_float("-345.72010654171964402985000164507323194798722142633254977709152599583223014394836173282737524486438980916090749557989469808186272453808133932965662404094815023819713322221943999333288168892158212886342898616196630325009378287717658740959090402062836453051644297859410897823185374742306408455815488910686743354644637439545886010478610221761363252693637517878530689783150752183321745057015047168599599318"),
           e_float("-341.90175368468049568823116064503260974499702247925078099957956823377292912933904615239330765735751306685261335923918815128177967696090507974170288125481578929732855117762259530903805008475492145461598994376716268773273575067413177607484364147179395403759990565696312970999903635817424175516836264157425539012233683987309867602452893250409281228293838907815351797857280652758528867696788793408684496137"),
           e_float("1329.0117934156521734604131740736091524061278830478246596207100994912296562462001644625298045467826779032876939980372902449124695384759274211964578620140934135202541973513909908475243304354259656594171909122608733183791053093919045320399982577541548288437868929094945374913101450554641969534282994460719719150612618515285361180835781605646143963122733925729706028606472311336110063529059125846078789107"),
           e_float("-755.58348233947464852584871166068910658136462433093211258350568065626558277940735938502432206356111054002089843463484362630241126985869260296840632006745852828349745504705692704758958271674130234513830554463515338316772241902278537644826940126397488259210128664919754531019127394539305309440262787438452818941189992841844604353689689681841179580482576188294355902751630821925123796926938425291814279345"),
           e_float("-2545.6321078835279147375404851827160423085373286935051837442583312147608104256129887182393558507456072226785095346922917474078607025816557614271837909869481201829117977556799158200068865964165086938207476332894152527333108486642376361866323815626555417816427996837939326910256379103368624120944085023615247839238490408078112893679770591340772877672230073584741536352501722243038854207238942917811855342"),
           e_float("5079.0183108811737650505201459109118374912866242547861157657585490444711306940790370797558877553843449898060132012628755279136599831412634519623001633988193860362912345973941526666012808951861603922835092452823818047677793522442898269542954538900229746049931495028215396288308490991959849822229907497984421318166213184557723472214933661424961752857240913739719656600514551045847859854939653786100294961"),
           e_float("531.16399504050317997750476416481532312713697606794497385780326738566097393338192119767010677129125448353936073031013766894237122719637703514512198527903914187809808508400636632753779785596212266816437975584687287967198665865233029103055164110791153655025312014809248988410163055493424215587955409439777337466634846494369696478965894629645583082077352071452175844890067881231142401636070471947802522425"),
           e_float("-13968.994927623748790476311001137604522311778483539780141802794286694637535225114688153678863899555355392209668381144940900121375928927660050796630494494993710384349662064029727475784334844587866022041840009369424374528758786655173803573526708236114610349617327195416434410129672842078889444763400912552889067129661064041765803606630375340626487013126355205930912008576255082366898915475483887982540491"),
           e_float("15285.131836200805254924279987381805945731790784660291752976997238776850548343523216832276922430084668939388398766753668404329774980404792238805304515544371355862807967280580133952108071444903063240801988098307109609973695645910819844819614945003675238594972587352049446271305229253554414573507802978880760237320509152838042912806408184393102865879790284705618602967197813863618061609000051717943577107"),
           e_float("18594.701015062636843265229949413394469505075276018676019623911805090491853371141188186201627073388579265407367188307479982929571483250758157836581195554999410418276538951460865977818867073901082544709163013787462457758767455680670478486958697762335295413711361735672807423938760850946785120100967691158584063375463660267278612720341394284890224094077278325956888067807195880399001411650555711403950388"),
           e_float("-62233.396195370130422342189923522529157659718053446719756628005685157567145064796901317270317919324871619819285204748925267343872850136668541652506182227322941219591694684686245154317118710690931309967628915026177360256243336435638718967796466482664839634724880179641023364892108287599814107080113159666831748180733921996080829244129981172783709499980565298930845272544702635371107270224501627123908849"),
           e_float("24218.657560502891657476800709657648788297729763601804303291092186545420778944424844498134913471101036611386885669613114261367099522878016988772858158998539201194116330840833347399806230754977515436349111679547895157371190346353347160705531166400889835964641417601471895737280994576713625576039121798981334046908894875365582953031990395386023996711584296558376006589918388269520911269761049479345386769"),
           e_float("135821.50191304877855869001157266843286066121135494525788309040845474129161570420327898913602454796897545902928966398378361313493720065352288812697659562627388923270929345379831333024333449009250867595420060289212076434909954249948254038716699477647836572629961447580327714713817958785294657848525297171255425649612880640500005088656989047386857181582331220645535056305498326736919996624663348221373361"),
           e_float("-222576.33239429396097050572233107835466682338129423086589284804487703500082613449362266710719189425963020316611102562311336790809430752915113415885697730242401664820821484155226218551312757151892625340636500382453527213553286317613981996492556822578354098385599241930786174599851253550394799714147999730383021827632284715706321728036291952016147963599772665477236146962306316000504831171398801690336398"),
           e_float("-99916.872690548217745236339832879886566825198959912330687919387245849229192507605477561815508500678325978164878224148672193477722497413181387114437400731006377694056178355830833794523533890889786231481201997115614621126072838319898472576806976502212583139881606401298331028168829832063571839457534744198222824518782738764888004809262958878240838153525553487291328839420803119519002454819193357134284095"),
           e_float("704679.25878494102010802049457867099641493688063615883327252086918287410851798433090167692885256663932621350680603656171696144290655349171138332154572063124399461937474468095959849280487089120632013610713606719786486042850202911385679009165816593027491085455785707360351601686769943909004882712560208884970567733211328686155750049303286703857967742072203618533436358506744724183198420485711897875025421"),
           e_float("-550921.0730686202535708320245589797494723305293129793572538425176862783953580096353471242671847458782112711187148225645414045524968198408142383126725735110576554960775772039150374627757253023029127758208780005090795533477296460455838030670715772593991857913430702982657311405785999111083501658896141073586811381640821708020492438597897908711625505109189051455197914230280750584409550190117312430607008"),
           e_float("-1.2307707242887235180002848980382388040199188876857041147941976544887925130334581728858185031595378600630573435740567352276108852761084991606965036606418792346195922799956710903413043575882716388522897410435077972036613667099618538140692599014537803052929264864758381009352618740730427259607922848476628553634922911993393877604348902412966760230036869468001695453681064666179675093017721077279268901659e6"),
           e_float("2.8773767093597155431518545906427257092501218624749856892750788009587953946962312428716194814334791005810496489327930916899894328800880593595724836133705445555016519615435687555162887239672423291456935692545905058952012572515872197114477077605259326689071532519820390678831180521405322255982722810665414297476823255775760153383178595254130652744754286395693816500577172864290865890626033563694427554272e6"),
           e_float("-41317.844630149556056753162410655149964408782665510809721202972393223854134270263922561539728826187299315420860381310663125762091660760344842961993043687054307983109418872361130126931364318636318244746998943001552676739300226532527763567446799212485255899536061579172025672549891378947726277019901967752369635536400374923507401664058586812255144413461233612199510138223996145713360513197911383228254908"),
           e_float("-7.5887900269069265701282668973624077697231434111530000797356652117252803390530801981382696672614332410365967689624884968974966286809821273217808742213710676691635513090929846227076190712298564645137620114373816403798599116041602660335556944536340804875632634749852156533257672247924085430540988179623769116910982640213924925560094505938127148317260943981473235260704991848727190911729322640376755981753e6"),
           e_float("8.7938284937615499500949314854608527777060489136412297820516755013949008435876435979908993463045731223553735883343261534910608435646890621106465709712442103958573110204814147992192833407730216072761817486757183116653637560063202240286180886969465608252722591499493933341698056857620499401077843009776857597154648175591985223232699605786776588055094610320984590310207030989756593753329905010611974846136e6"),
           e_float("1.0116530510980333606407351610584726883126766179710556715987257116621131191924350709503407266876712504514015528207013720329427079802123049455799010811461857782935716104455390135311956536152052925221725443568002317619426338722022124749524085269567985753189409059682923435529773806925536288443472522017033553528233550797651314570800339348332464573518894199676373986334683873139195796386673736044637181802e7"),
           e_float("-3.4912967316985673397943138838564150849031356343613022491353758032083887414767543737531890665426627349940883688546365164112910724514914655541345074933087865429797169259968249757899951686846363450577309268456093380490675228469716273494255653484801005427869181514749820426174836585472256366766481731301070657262116697425727757777999550716002395655038110567467954454092454094974019369140870285222955610001e7"),
           e_float("1.2851172382238145460553786366595210592057497780167381537023484019575405547028202480211506647054280633237897412557512452289180376060174915306105573361466837570962541689999749989351567332562541804353200311344702331235493715336000124033268231898759634967033392707691326141308819952412600440510834800204740364437263096923328423673709409910722013028575071365617458655709117980069873027373073700597746825858e7"),
           e_float("7.8281331185205003457711464527396147625053148004480903130519255658788695197428406026609878215604369924864705325896977849766145123250255681029694087219868853738265778011997683450354824201657831532053872933485773542414429278966588655146839631243885075076496133010348728498858129718852388286535082769350952373868374618549671815682732211838240379676132564476780320715741247278613373408913030032945401675286e7"),
           e_float("-1.2310413584400575076759577469610650712174828979440708170845686030032091386541990923780752669359136996431267034287227820608891729013817709210936466918077177927559804951024796592423073822711524623070236813647999611382711442800804253949987828461946851737852905334063941295399325975291855011382902811529231985028167332492190884069198832891413848971912799590912076503237808662861634365601798015143313570075e8"),
           e_float("-6.8849384301448343480002582710016265476978898163553003876248088757341361964661651606649025855709168989541481740453515817870609909564746268550704822996034900781470058056000135274155017541500203373451098249624338324092873869284850012144582961509867898654639458692772265647827352440855744447992120177892210763006106090937975637072744021888270163373114986907968485958641202735075938145291637605803701526617e7"),
           e_float("4.059702692205933484584260248768346774534389355632588487035111000414672245887088241093058082975291309392445838760213002935438034760469751836012492661278563961046550031506419410697412045303537433103920923075154272290336764695344239468369943853343876153409857992139077102028002975131368799422248979994677794909246064887634600816041782928153961290182897512975219461497414318997288069027175170769096372351e8"),
           e_float("-2.7589914171305351362666765417246222547996231346697136135834320191009795549679712289850189384596343558077566936632137064352462430086523404852645467935745525399235486237449147140354184661241859173265034813671319098623992262208329388584972647417495849035708156481845910957659595857412440859517806176426255644903608504827765424862201999146987536786040745864033863745002933660034525434441346151984081102664e8"),
           e_float("-7.7054213572097829152908919545877574841725243098659628513012961905599428927901320979528696506627264829583168940570624939490881625104928545594019459017278712299900116785745434169900013974583355332955175607075189753385890269616630263758991674647471710392279147675377555225583273737312396930854993360248188905685240325044112165295425570514332089030793263015760582771705230412824023711235113822804932579767e8"),
           e_float("1.6061162562304765324700470000832077331985443160456887493860080513571016751595260195485442514873979620416910421754659307823089596007489128172219051292221889622953323938860076468104013506810234963743991593724188560640173186339539760601594756304780912750475297322739056136347818238101576309062030173891232595598784284550482261512417103844158384268830082262062262039871043580159357253099196017112507605341e9"),
           e_float("2.4373502731368748062004483732903430193618222937435971683460675712158660015997386109548776265145823591229485428082562500643896347052740266045419091188070656510740083589460306586266029497469314963225286768416691648756231087670489713433735855365448583028816497686360000368286006013199970075540284776265023331853243294788587935210903732243923390821452074785019285408898337144679158633473784059555368503268e8"),
           e_float("-4.5617040161029577409884254746736415188632813110055480763741468991671345709713371031518049234791287065286968321550455905525172058022409081423407288529833334807005956952007151529137601926234895573787582720728577006477449649547465340169951287379364661905221543403498458978661236777620005097343768134530257145743765212926120537900242509959200962782437278010543804830553392661909360499542602124011070195846e9"),
           e_float("4.4877996496525957091649466489448628301379119023047612251294306666258141546994667332529849533716675117182147203298863353783246288919252026701048292910118847212642552575633194208569395771733402363171717018753180043384371278150779156216478639337219176846974679616245055676060922385113570439260048747107527944673639455939973310351701113475843586550519046710556432057677896333373792865383067384102337262547e9"),
           e_float("7.1321589723838199306116186688290684441608526263479005614303674447550641226168050432438089931204171308208423692325655342007299944310266475385576787011779149233625325070344418217543231859198239930938726310414971817042836995081937528213109955364949890530884212787413439810120414678679879602151453221841329883855060327381058517646406457577168826329637853540391308311541957104715717631878469034556834729748e9"),
           e_float("-2.0012102716969615169537323341879958879072012795874265528586107480722989467230450516499090148123625079986589318713989291568999056564467256283881544184501418532245212463243448391358214647776556879294878810980670326579159853401695150714925195804474023293580405255858659335027683552280368789260966372466150952621254059567672165418887552977639975004616040533300777441095431597281907585433009143185183907329e10"),
           e_float("3.4337066944571535608639120342927219146687079368669708098707175534231593776703318148625619790153323220136789129485888962344804716821446925108976099115335100172072694821635732114095851778874967727411718565752826284709080728232972117551331573104067227664283501547807592857140167027134451234067104335474071831747147691932034274555902053674283517677553718265416016222022664076131239019980777770853193700901e9"),
           e_float("4.9639726222569014566962719493025284733948160066430138057103261793640094102298320696506979375947361251605232890905747354859335010461476103895660268155194331549726817435534882615904667507728977839162156211712383901343491793096772706735961395394847765876405106202790677227264352747577100868791218807737867801105314011463162630884228776259982401294591184880168207649304736664311017348591512048447696345317e10"),
           e_float("-6.490793191600314034387433867183528300137197164661198418228477912158295580420158023065166831170694265979709781445584470592017497677011022737190464190646298232289875657573095746036050958172800794245370451400525813963190219535805059374289208850094023483770512427291678259090511656498508801001552761549906100287476283966975184130664238339331335457590753339701461623274852676918405992371645869786200699123e10"),
           e_float("-5.994570430873652611705478061545786261982047986075953328392253503152418783696534231654634682159040993559363168259521433227515744578816412045909537262896218784859455957798109728969110196759622651480026293231375207613394263139956149676505468786574632919672064605284578847314686363696781053466483981237604142965724420865201868948907882802750707082085396336702280156304501286896146228659267038091864254681e10"),
           e_float("2.408727369075694342047391300944872353817151510444751533509627319225082782055507078459179174023633068967920573680214435050597530981786898244526824620406578427444544606857389041447407637823177825446923686757206003392684942688738153715457474492431962544048072883753249655339192642367180320558921549182847114432039424666374142703164189130903485306792255410451622030371899247805494886254684898999321008104e11"),
           e_float("-1.095448369230229900452892629316705518532780861034811865683512788509490535833087959838883657136026588373773655113629971119364243024644420351938478584989385084384244504234053629510878467974780229584106386577961188481154559182762668842711822850760834524704860593548298957133013926833214874628017620019335783620841893635068037696869052782338621273923919488542760074759536745470674985673548267075717304344e11"),
           e_float("-5.2202789910709389219761117730623789678435677652846602355527119064717688682943374932613600634691109525517589877261560239527485530233521689633316560402364818964821717032688917227585340111029770051921074202258401156409532647565254976137060198281064385688824292046997833123039756121135981296002836501312898170787251375491734214122963867565555489035503369614628762505530792397273704381565505403758118833386e11"),
           e_float("8.7779185885795885088613567840689135994748176136180588038434047756867132287790957017334170539833046379209297794958610840327502265337821247888811233150841652803760122413051354790826632752424752787845381067624674416111726483103891273516757331074559594076242101586016257395641835323758274987866834391800438900277294528273640953561172969600858326276690684252354121167950145297099797701731268827145974313192e11"),
           e_float("4.1554578674375883360515489724826413619144415144429020888922007890980705735660152776903830222526195612181483559900644479784566644897409246003265244064256216488394052928303090937430674176687808375395548516764310865069232470127054821344607384448383831452362051389103515143417816083476421437462178429613292306704800334830935162272939835764756329108849204194294771347075501444088659766636529036986213928796e11"),
           e_float("-2.8160566259525930713865197095527328525124893206902091974256812403370307193711914523277748547942411321493151909031429062310003943838132106895587926045402622143418139911498064163240866360469584880438339017349626834238809915433786945860928265321292850321371574136185653773709111080786447016592556288618194009325867024725312739321150619946242242094022404844578803057577395117723703500964252452522884253547e12"),
           e_float("2.0357619916222626433404920844431330835950787869500026758190846903061367642620021298867692742376941940329942138132788832871282063889066798020767475515653593372920146536955135625008231595995608524798056458750853282580146582157318889387788754366359928774712873270434589622818060339294743889684034835598571552389488281447025702532684016558539594963700563388953173676253574534091727997158405207619990013392e12"),
           e_float("5.2704598843627460890305496246437562845000369800818896233275098198560401944569907662950841109829985856010865572089596914701919332755848502620251625474799407218682795060565735555349100065550877994898847340401023598854458087342906870187948630636011857221473957186266544445920840135654945028753703860533574328454401151478462984701450946294553057504132439942413351891082391241939536739658399052168602724849e12"),
           e_float("-1.1345464621062141429293464524895794210553070124646120098791346637215705141327803164658613337443784883166739713994070620556698820428209098703085438498049887929794247115755038656040681454672697369254742242699959668484390807241870080479540990018137072293305626039413758004198878671194608557027786254892530378721816925815602288425067058150280874296273032188803151795667722242391866261985121712497179915261e13"),
           e_float("-1.4557141901554453049162711776303620873419616892544310622481615081752696566763132276449218143573540653293826307351580319784879673030215217035173356618506842031189592883919685064365359274117590157856369339289152800749168665559772825325159424457786985764572330405017735282704013403865999978594741854156175056566228041733702742381550502418800430073797362324871340567741033069412181316824177845687139596734e12"),
           e_float("3.2045424978147398573240964674984361348126077679813966139566212036049018544348490537134400721202772525447786363419188033746475206246467437872161149177381794155866941509040916477188685801632199824395389933853437624700200203599308662582637055175274168148217906541988527490292749739958845102036930439801290624436881344074090581714229767261219716690097507423502512627233107252734774448103247192648515051065e13"),
           e_float("-3.186748300497351895344146966164684800723350591231273059754310139499062191160252532044499610336192239314319825175765622651183887414912793386248130761814175192239201149329708731774854178695705306067100928598313288654453570299027095110452296585522648008419006722440504770955096784318359076973486448433897846039545092381463132870508354313314575645345862880086406252889444746228907205750191785075433318544e13"),
           e_float("-5.0391394790241643108789667770646086459700214726046043999864030063178759812141417249802294549578914836434980283376744639482778733491986938274586529467345518894669976439611640906634359445048875088783935769333680650038149925332533760045756504815583691548385897809174380546779952098172058217855665755119718572527981998183541514385937771308129605867784438624900298568814388604153611139909459211294469755875e13"),
           e_float("1.4170740747965749419187525118866090732491714717459125207452380194814443142239643631105294928571042465001452523573622521632859910129247709898995916501538437733499763341602505235370326724163469292663345815128728989041662303086301357850920616698893828339596680817089516575982214478605654295308150453460456517418215290757932535921389455376326019987962457794381157795470030567574049036693967870881620306752e14"),
           e_float("-2.2835351210844668573574319707201525286965564695874826555677333747777979964976546124949461906619977036043048812359801699546797179823329872538864975972354479328528015088083082074932955087744871739416129304463612740616573657472569316257719182503148739558122999911714007983767819258976876099393587277942833842320331011428882330147716913776315761757519072653395985995407359846271140547191708724645617369484e13"),
           e_float("-3.5482677737254366994359533846256291838029627865938210153870323345318003294382872796333696736897491234118852332847199373340773750395242757700685336205383094749877378696547520506943325768476267313460651387704094300325567918251017160414961208890553283354771220475290602854676238311948376298654003893590127715313770156174203559565229730920329349687385237338454910261817553792682403951787521744847218316566e14"),
           e_float("4.5681361629504008013293342701770788678489338972841286650032598216869989512476492215632053723922884182664920171124972680764398548150437360409700008241439349548776047468870309028927507247440641140989649874689795368359907346143641626298970716462800853967603972714507595143695392225520142965735027541847031360489298362380726552303109917958210419919943298950835775720426951322761127473577059207585264053874e14"),
           e_float("4.4344465201570205879869591455065857528164645250894534452531741496405091242768383776511188279698798772351916789192238216023426806901759045386593399359713238868049768359234222571808403083207164044133299171997870066458877667074640150734394303485401779114171107633057508657855607637108696423297075840728426714826294078138837958643012504909805781813438060824643835267916900550811728895127455697247927143496e14"),
           e_float("-1.7205597892654168169837041981695108868592866118477845257977531942483507551511913581209955271576881225359817751062178365056603817304122358561444363695606014444005958112412195580367957921274794087294462354642406408781072791306426498760320632070438137099781566997008393788082349959658437634953451251926109163846415143299871093180810517061896128508944806360380298522603685864386758337204650118539699242e15"),
           e_float("7.257408609610570210861113157123673222602446619834248834088104459610064561179507548780205964291964964803001816113881336175366535994627968862240420756582382986502065487046372696436837605134858007581101760705313514082559433308569721502781559192115264455768370617472874513238361002885086341357387598804415709963299925518571853594743175436677397207277517753160433747125961763880272726515538791717850393827e14"),
           e_float("3.8126803815028007401488907649413016798433370863461097004009079083116256121557520286847719158527151646329410638702280433041795093395326829763578213107642414210441214718172804332503491685908012086922399911651854921641109240734362212302570973436684684952366489249725522750699870389443279695549573843722676104148845055733145883969188967611156951622117475346219247605506238768877794977396344217823426927511e15"),
           e_float("-6.1945017359375863882013940414838759929302281689301043494155591167117328428585812096836442516556468428225019667581063406040620056952960873454865880398444182238833005831190396491868042282609537688917717864313646301732688462825601859293810000340334157572332827160846394469688004512931478586125601208885197144200391287208197136813077835744434092852734552980809702757545231325269734047453554256290418761113e15"),
           e_float("-3.3469568979682827764599947942769412498543503495723987832606741280588815636229587299467992509784407291022497100514565860979895650966785532490144351248658771989865873504467657432608111069238612182984746770004917598509864675773478629248811034971655915697152157195906807462354235984842401266766936904717227625684659203367898488118294774630352019251996482270477593173145346334306039371974682901127371678296e15"),
           e_float("2.0368660338966441637192487873764851455905523377834456726690692796714047097278899794351677860792364182738193269418974209765845641227298425224420497339147706266509818533547144360791548766327430002390762522591904228506556347632532915982952116015928866608341948554604390917789081802510922712864188106140726189213434137619812109169518280146074013463631430570589456338416743672327824475338845126370577623026e16"),
           e_float("-1.3671653000597940970122360514736769618469429176639943094664078611608992608883398286719199525635332358308622537676316914131213235086214390638913446408477279621586446189428230111626084264956467389613731033534565109926686578286385173013148471994324281701595891614169115398653799382094249335117645491920240270641233079904936307372313776200223662897634110597262290808492432175427064760095879444277605072616e16"),
           e_float("-3.9531056669018970548334722930188598064911773647836842027584891356396768241006340965774373416299146611341607299977386856299326066473521799445771145776135888278321341607264807390483551064878967894804847811301203679167033930857449230690469311868226143847970017962793429711985001578030000483108626107323803047202705795624421393046956267641089573566116630751697413061405559955731537079983521371196399632821e16"),
           e_float("8.0721223547785882772626274936131742909960862458536271656407975723301422221336303077223818386153415422735607368913702928305560974547603594673650168750322399425524179692239861477344574389646669865892086640891173289906168311514130113538148063963422485829136333874083095233849609552951586757472742662667758186865115163880208449657638685502357065519496249380615156002913497450923791003635847370184407178724e16"),
           e_float("1.6491148147125325621678875245266040044611726737363721253018929937463181755311190651686520822114846606592295885556605223783895404131043199009365000982245308900603641874909864865840411975453998766885158194056547577234928547715791424863497862472683110815954621537412304981809557385900585201102135666597381733294347592466923355216618204526069811049472497935713697643354651825852422884075175554528460142384e16"),
           e_float("-2.3536184382892235952278056726731402661195789768177316413153121826798561447222290392796429995781362749758470396866351866701234234815938376882618452855159786074690392534485459853236727546199614951367396666643552667571720667640303135702561178303660847345679825862400264282781356121483687266779627413117602957879978659846955268778973452446920977066188021378311376813522707890750045808822985233721262933117e17"),
           e_float("2.1734184707096752971862398878926143469103445228933855115200727092214460480754493206326164690221670503793802763584425672058783911966991605362831831893513185551771851975188479797380928812447853832221607089659941954015585738344196968559022169665020344388292265715039655901256771146143937042558378889266089486112382570713560034418887662297132673716068487776840804549630198421893673848356669364353847390966e17"),
           e_float("3.9132030097757691524546013514394810799834100776209408030690258410317556958419670786721098398105529061004131123050715089192431018921670170134041955642742386240200859718100550598917411413343075830188340610996161458217231602986261848261867717721664821768676936076858807165818823057154103164407275943807686426664808547247525577813960791954165027707870378713920442304960832308753566826888737547868139912943e17"),
           e_float("-1.0194995477380685301248745336958767873804735147475382860744452137961238514600093438518405473484616935756384764293203540099313580252027851764565316352955874262514950231218004140820985657468223652180193835361989906190246443718487292312402598419039702333897804010016764064361170619678181609897039744137382661809720761497823042564667215051739153930958217195579725537644682939237527605503635470927494452362e18"),
           e_float("8.0456689148120401349226793418094625757143068233054194388066508465279324035369237511127881912371662985428527872580160170483768670780521783404708898725929265017286786257719300978063273069773011354907212045844184602104906407545746553404293635253012622177020321973601459570169305144169620922464350925102720848801514848653714110438139874958700164823734604185466331453726759492438830942189809401080948595176e16"),
           e_float("2.6531516663513872867917758431413180437055940591062004869550598837049081566321260867410015768073509254814986883911360009622069346224582244186931573744867213684974751584741839710074283343227313824073840132765710076015599712399093364172054265854188402737076673596140837895360723699839436441457689322447373085370107781902403175988688747641636221158954945464005912573513785855774645082039012445956613960669e18"),
           e_float("-3.1642960289331085081250878283097496593538363059986157138322763454240253272878370126317651808576922628137196395206650030259945159245102172699196842033770679527121003741580984961062217136476035264258020075651638795990158307743241917538879584872181232630504020311273133458994541175258017245972952651973703730881355430989440657494562655023273684126444722780613901434487577450055691452501258802332973187591e18"),
           e_float("-3.6234500618297427790351297837181638644306328639775993929369042782318442576978496537418972252330596996092777016609606754965987700963545287814960844195693154813153606251066681187344563056964650010228180310923192239127915339591459105098794802457362339458477169732551240616626689036580209325443323509039688870655705247675129585397695915423721789658033180277233147193211788484177389618161098681810623486637e18"),
           e_float("1.2539892605893660520104719938940102314623330967871348838038026172082984480963633040129364251012286502942323147889900672783290593354543764385469514885593031638040160789660880928837307097560520265244217902618108458970706179652875213266715251037573271398279995153864969907281117769186765273845021259974224551670600894631376786816374140865287974710074086591222525740627986731362213404708963438715096279558e19"),
           e_float("-4.1761619670465461636068614770094941348383015807714005059740772364818328332240137656024312108438984109300855174512311240150078256928324493252355365225046471331452120311972168891470131647839922670241845280011326692560842642442481092570339611538614031759560727154458891192700188749505118692774028608830829509083935456790619606797505749885396453161370208956365577222493890295781345053694017820947045180749e18"),
           e_float("-2.9113204257153993724349078526439944709158246156019169061055092778942460028980032216238702832197710521824806394303433243004289172935140375670305114090763181292304620712867558381280818638067117569054846113555541970495436433560414030402474328096998795852537515060279336548097009592422627909990903382486771222980242865958894358099532550839420147555967639323821523288040265660463853058354492398679785797013e19"),
           e_float("4.3569252925145288347750587014162117248135355107210634210997886419357463346366429824318722923358142986750372692677283152273828316240384940596035950502376146820805360560448532220319473444875310688153272424746313763932159109407351800193652242832496764798620441766606949988709257613164529378741997612520862523919425530289236656361260340347362722120542026639783521850949988681405880082770071638582659496095e19"),
           e_float("2.9997699854119980476969327723664501775977391484648542085191922940943816517829804365560596962703176104747143451746818052922750000490662135017086278326548128680835130732248045627040832204761846723697552244575189691476686394912740125616452293360840366110490546582061699896087609456101749897127793384914071482676206537923168079408946512583228165793344697860251768558285352784616291680107936960397097437965e19"),
           e_float("-1.5060326847414099209581168565768270058471850476272375611759680582043928458349678692887598090994355837738682161756658798204988259637012916172146684673327114671686092180480751519298012003227104975425347599810519575252884009522090430504675317468591284251689986623513613027919569467393030208151683605331434982905984536349712355549644009947592518206948935355588461293742248915547963696979456061805759526926e20"),
           e_float("8.6413975346904368500564409005756777382644321606311276331694055211773609943358602952251557751176783850009471737049695685453896209761499162358850570146812353095633727534956029921843307518098811683691777237609375107063111499072907582398618795145680383891718779683455037909299177526936945469052253501020548901949410262584963755619885561305206666935402508019770966789434499975739657265754834221771437755109e19"),
           e_float("3.0961918286456650418013391953354775666443568018735632292466646665407380008069037009165390298523520039641255489776659502873911484349539386814445635180410537261585402554265371909867104569491149408782856163627962554811089139014578526637096486717837481498474113042874642938789021497866310704052704542618456336441464795031627603029145124656763346101950811810964322580670554070770065680824430110928162964469e20"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01026_poly_laguerre_l(const bool b_write_output)
    {
      return TestCase_case_01026_poly_laguerre_l().execute(b_write_output);
    }
  }
}
