
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01023_poly_chebyshev_t : public TestCaseReal
    {
    public:
      TestCase_case_01023_poly_chebyshev_t() { }
      virtual ~TestCase_case_01023_poly_chebyshev_t() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01023_poly_chebyshev_t");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::chebyshev_t(k, ef::euler_gamma() + (k - 10));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 111u> a =
        {{
           e_float("1."),
           e_float("-8.4227843350984671393934879099175975689578406640600764011942327651151322732223353290630529367082532504853685527501929175190394959855134571637758260023550764637464996662570626622623260572074047417529050839912647960518343291467668482233884713788004984920152062549142942599700786452138533059703956745784809412244647326686007459870325794862458604508883148971920157651224127949615689060026386274469391106687"),
           e_float("109.19545457076638580922836539007361065996973553042170432451711515968876433050624386934022051192753597013787281921297815779816921139042259655138609835108336752526359679139342776901395200163472279111509920388607504471444604483022316263104343589543952563078760664693147153231096098671173986259572665851260493948839824531434273921649989231143438311291919035800937389203421584149136068519768219442878351617"),
           e_float("-1040.5465195651669068292812532579565492512411152107800921686031563343859911258451760096825186544408709853493230709174482396553660284737693183083903864162612417677862766863721078732129683548535714423868250903715368089030483961409933200282727784337950118103627236751747639631640273734074734792048391397983835622309419830517867566668967170467799569156857459987830864175301964927613602052025001101693249757"),
           e_float("6683.7275379820632766399502483250337665088677584545593466742281690181687921774445280934581051390319391577182685871351629260593801760896806012865930801297678070848895291075256868577554834641988152503309400187983892290381606201654505573077908696082609996610390731184893197710503256749420989424552902151367840352412002342815798519786921650868778339211038633564132426395664037371634498179940314041357661282"),
           e_float("-25368.721323026252758724267086166172458169880498094625529895030526169304023664744029231411144438365080904032448926970987125532947770220192281363788625805282803334077105843604653531782422957138494533141435629152656700367297614892848635572449433957627600152767350873399373787294859549516107644364997268833467239303450072428356315009849517410043584321332329755217179569743572195038280016141576535570484321"),
           e_float("45076.744115079760325455681112517531576365583378825108223112236541907972266480282489165580192101658834568491225753505927471429986947554869703725993409018806830822103918994002590385734859522692147250916491289957449428395838418289236936993032058532136259883211365780607023720175199986585015780621971973486969207409239709767375326264438654621904519931694995724035191486619444921201268060528746993241778043"),
           e_float("-22790.390045147971026569893648840562098845940306038485935103136501931131822948006858979215029358052924401304054155135386632590928678054335681026883436920178783761376033659100421392045576942073720746545198943701318152201043955579076749504121581471042922232972973915246490735878167534058154032478599993913652435515349319193481722312068030272945931002663735619194003130656772128455353662676919327501534799"),
           e_float("617.6963262566135716684647856687303556636971488969205063989991037096745908616242758751584115241276314001416151306701290416018487035942883974497246967855646396514542015298149568247895276580004663048067670577221384491929291055122502725647203494757462771579684556852932750885178207936857278949339526274342708611221540338674084719402374698604143469087346723924249876122497694896939752998096254852792124427"),
           e_float("0.7082720117060523391060674408864288425486769935874239590683985577036845355543349273797858887113891156014480247323723810633540580727932664414663979229297701758572963157485100811157242622994912736701030878829707890641513463586610161114754116098255251910514344769476666312671663870782063519441895472932046410664286932548165062548412969805092540793643665385431295869783720048459695748938637608866615134626"),
           e_float("-0.99155713761062612322974549790536321826627413255513325515715643103722868453545570804476157374839168716406344122615463089819761484924151613547053457784683058210208359868567833833779159589608329522386337207318722992690364715796298152577639660857616004295600529275331075325511362840337192239415864644400407086085251578947575146297578953505645138140905315214130910425217589014862459366211252940807137752684"),
           e_float("40963.956092013562333345802785440779807713820823259692369871096107604526878895395217918769843132363438124508043512958533910727933868126445890672263935012918869767202108949107417102586303039449256724147672800242371885912590611584112951907163568365765440856751809950019406081290100097619110595066862192972395446484485225536034729407229079863035872413710123161042501618557497562184083610059876951329167323"),
           e_float("1.0886247235551448782031348195458302802352523273426702244896614286946250318045089759622166991864718781689868345818300156024129085877182489502702150916716134252427315550462628064632438723807318822379452037129913787429685617316664753793251372872135658530963917263182756634661585350602130665983844371332049813602527397186369133421340179166521533781765075859184762810066903127732381886113796080429555346862e8"),
           e_float("4.9518304192846164691119790704303187498913707982897532376141708562400146211118144839980760720651532302869625768720881397082057803548413570565429989355506603860679507092708382219802364736619262236648620625808287865355368515889020729810546900594908734560950542580347865444113192725102975149384358093448138024504927532580365379852530713632547378497105003428565926168002795819204565989510367845953550270533e10"),
           e_float("1.2243991102780637561760733285541944411005032190644828620976068447549123467743401884054192203337303073931200484034696052702341017541494126780210783222457715658342822167874343191196369282312937582016008548083495802005912370030152760489293790553925130276339084855865944276665300049424481169566392888405419370101612090152568690776339575701375016862983868099688323063983209733350020153999935448956528499498e13"),
           e_float("2.2786680762008898051242877759609259157225341335410179586222394339670597043067272656119947280413343171559153152056970973674258550488472757142261356171014105815635761957862697190720128483580266088776103167455666978618933947596860062697298788218711559024508752725271824947262750534113749503187486813474511060185072705018534226126976314755786827157206184530222440581615015783921963342836331246150957254811e15"),
           e_float("3.6611179136465455072314281757898912950858443108759828137481043712409469296024881505906796679056854337398231695271664873096129029582319874172601571438558173818352682219230045189978755093016232033906193237459287610770528261865577987034515769247770592271770232629133665119747075333308073997951699603023248264687267868838583542434771520861579570042049708518518517943722869683785998766799996980528108916428e17"),
           e_float("5.4423181418284805163918836632017488875356682757572239466690194739182859402326051282693669009483652481743518952963433926844268234780968525238619058647935355375028745742650705518675543154771470310266914484201019121766144438269865950890960664249086841089497348323644556755754660822999474009863542257761804391544918357179224625266854499543804938743451119617071440173085848458772905775526482549632328753937e19"),
           e_float("7.7811318508292350660276354945672130110294148745269506731453343715215213916165679997871783221119248189796547193889344370401126500480844484572761357090221071654424046669992608763146043300588899688496586792619824527418313566425208348583440735763269559079649324268936784958572170640644578206400722031385813390984712639549350085505912720570477359954356346273989093551323898990716481229678539172442091882066e21"),
           e_float("1.0952240542336196916928270596054137434343207463774253171696492952052567354821018195181185543057900231099244988224113755121908372954362757992253995730528577975493968842949317961492594082482093916857402533166265813498188507953757107767128128446447925282955281694477197109018818479081740326817937889645433535593686352204747441230397496081684705134975071889115088682494205003452963170457740339227868924849e24"),
           e_float("1.5400057703797769674949476156552281919748700235416515371605723715626070651139691357187803461550986103410453043193572522447725072751805182128309857980636119595207567179735016739205181399172941293803490147936999814037820705495015190999743538202500394333986839743807954012042163412426022698538678201650054432830494091675699217397644882041083907209836356772793989884817440321206636837980068539206205160308e26"),
           e_float("2.1838736038177528453085254712343328208440572647034764538892440214659330125698526428577237967266273967791553283098741603290057923566103230786888604551004082661581691183394295761189675871712165132343136363803957774970865774383702031211427579896581570350127494575403742966595301818917638146526034996265392292332069444912844306684197091333504473081010367358775857531017088638146518451081639540502155222435e28"),
           e_float("3.1430632806184564143533850326119330174966020770968198335246256835474792412897823361737468914553773363120989192432331838071804593429870162410316683880947927824722836821531116145883675926223485633577800789265330845643356699441888657768739633811455191790155854599217555863551132673580942631519040710745972867698971798754761870255846716660386754247784092634504985734398510558661324636508223100182722466732e30"),
           e_float("4.6103312565333457761676326881026420889178378266227372405285107129269078400678411279708052552869617708612823705248902374788316481459616090385465377716346442684400766498762602991555982519455363373782482336847967330738762609230070833651581797033324243557429412049830108631910492172693768143857491130540986223551624647882035141357483647578144989675865699362188244521641597747861108676321701813910410111207e32"),
           e_float("6.9118673084329821978666393247403108111702434915643254046399855809941370362275390745572923931482318203139546348374435543119213937392381429756633522477507805536132901894399354055599838532379905304046625397066352978167923159899366533929583555483072655311064703639454360496851113250275390906838013268344433683246604504843612897102996646592424302006914379581151992348075341783901736636780091173941158859463e34"),
           e_float("1.0611142151183086420639191108556228243075946629373028339791874758489995818387026577867451602438915027940272534248856513093255912390141385246947887655588700399673518328106599281692864785017586788987381280942543263880775698146054397713783171568048085501804480889070085835981570158193446938679137921521476044731678605806775390344958046300339307510982247867027513696924563784764850805717964555998163440391e37"),
           e_float("1.6701853156139645961234700729069234505484289068699650672134200423849490317798183783109977662767108411416181865787306990816241737922518082866368471603214809306216982617073269292016202740493267773760530627678190845405941187645219546223363977097318324995748234776645505880043138678537828961429599187618343122803324484587423857194918241973369189068807876834724817000640713007753081559700416541296098155776e39"),
           e_float("2.6973186646436645179218170268624771678661726815488783928602854422345962818764828795360428337509594758517520237597929842519880763974236843417863272986004711468029018817328397461583647515622317813299782366570943510559444213938325010588741936013638423441415716192576842094982107283120172503634258122912238970859077909422533603072596817695123576662567418857483222986962546030327944505407585900307663669384e41"),
           e_float("4.4714548364293723765582840153082498675436345565073240005048165349012832858576122148586484148720390310584445457106800201295877680719869815217925482764062341265909909167235062093957767639641127159568264181089310277914727703916681507529022387332673018867559911733256733839470997858295092224242225163068082134065027676704774781621616196748797500779795673142859332011876391605144882905034817719868944045501e43"),
           e_float("7.6101534247019650406060959897669239935149337821524549328961839390095511885784024298272971532338590531215257826111978725418556423686664058150879556087303101327104842556699761334895962198610103365817743100195576860229475644867644568484023475708111469858468750276124777824944205515628753376768654559841311218341296439768344147810595430971450269240998950381306511048252404389830303237569999552149820526343e45"),
           e_float("1.3297461655838344388259160369309111602864357466961811219194330288648969005083462062668865010199288261813250220816730609789528518072456847772401154260819773474773641706939393002912267191004892743421690940062271593540812980390871881859241584715476536602525463110753399369999173805037093993120310529191028796793266739998902918095733482089242418254496591713205793289109458838851228665025084201008161645318e48"),
           e_float("2.3851858875602707328077772089608996689185991611728818076555729517710699781197538641057887956210661669742825826200182636679959051345264073858346988467546498814604672393541651980611240531449425564137146622172614547998894756117408874144393692826903574737604394961842484584523209935158736766072122031933848150352600277314156260557270807943047618933038184863395240791865290265661775870595088615691294132918e50"),
           e_float("4.3909752824835036533250080566872723117065260579849002998267568827335191063243460964986659196865411305624146716496346422756177580272306766446090339485031801033480229121621552193254229225810327976854317092565080511614130081580014438258789766211950447912456806781460951603991599283786663116327770569364308254635967900530670209869101257179159680536511242387743707391686894308326352396767429902737170831737e52"),
           e_float("8.2939820214801219051012542334531370922820556017703438151337243834633629977545033939473660501205525545187566091034788232799008697771160384105001413387291155961714883732600524536525241324768596054467268092409554023944347188042680910968997239768625046367956081889058718087179152802857335107698479450042831576129745089261365142231088403452779707758066991183653995627562027309165887343824049321114172960577e54"),
           e_float("1.6068888371368374842778106153342687261945294405555297449866621113945436738807266799617026066481091031004477768867595484574327308327280339062810751971893644930963609583793369304551398281180306724593150902308949884119820583201720138497622635433960235134198644422978875488490892789036235662863131727624265192168732254243680902820265585600237536052500089619750204830958730152833774794900978182387472787771e57"),
           e_float("3.1920671432255509161159960175453033245418518420745693388041536436123086640939036698564053493409769719414088138580733720304752826381383471297931309834241988870520188700684280446249575284348030185217849178674768536377276550145933298234466423711761564477679626214163229780799394873979075355796231416537858982938271378624877974145451730175831687936843614238905755027281242720075029727741348458043895194459e59"),
           e_float("6.4991207704380896053480065592285198062046689278678746110673953533889893522134900959217652488582754899593931239462079223240424845501878643499408699906467103687466472898104964805533020282994912799690296413077816303145925190606457784079521494644101612167721537430042493633753048420975042011950268307309842533960305071712315352808972775389070469283650308135172642747362014469201524141026812007545707695866e61"),
           e_float("1.3556896616369071414927091538256146532770602250366050323257625537969327193051535697951321381573981929094103273403933108473187743743073077816058176894555939021610187020432476236873657704241164943695357927332090297864383454991914989251686964658511013140181226609696132594138388336701489288013726494975047671149698329823048680357321177681470948261643958959817535727198423592239700474553140674247125156201e64"),
           e_float("2.8960905183269229730612186105366299202879365237968396723432310134038231094301805441334649090030791222893492201292861652932083047524214384748801018455472064587096199185470859654435516891836236870928965095908261476866886934529261762066011716095609024739503875610154815635180495145780428939502297680325412615689134442111257209606687256603013515568395709041056546439199664037613666831060990745115146256506e66"),
           e_float("6.3333234659861003338907174380148725265891045460082620132062842603185609895344709931790132005805160264853089059577514642051886717457563506125346634409261541725081736100811269137513224352932785594043585768110717472720043991522184424367103808908347352609605240688969797106406138959934560692704052808401691429375873445662121552996604344202100429795119515413853424542984731223671764469159719661699979517125e68"),
           e_float("1.4172301841469308047577134337121003473402639608247091694855541368860504079521855965229982821018223233144809916783487003537598969162398395099086066657478373016063025580302654923661190621471412149261089676484103181326952060516499062755432358046359311095014597160440872888377367598526880460924430448717608963001794442623444663950670894146210537299751759224466540689462026961931425273698721154223070061989e71"),
           e_float("3.2438512913996130732785034904276695709740436478628528327452376131033155893761591488548771300525228895104697756324436524982040804107150213472673537018928075602112269057537761803711161069552981762450189506622785074538206768531647099743140339543378639789891291885767272035762077427212548862201376704551840134115030946681587047821429342842142763835045920245435134595108738369364421788633872818253238003751e73"),
           e_float("7.5913312268553187711314802379274800943699485389297158625091541290130412422218523142787645303783009210354702377150081413784222688159242220254601376602191423707495050086972531230431927646082862940740453209177660663562133889122504930916223467288051759469189859315459038919656349490543363844908101920202747684608467264137781623148664857774488779124228743878529274499554332080991347466461583144656525497657e75"),
           e_float("1.8156774645411509440976682853443610344842219843852988312297973816626440423730341573857790253490093287851291078971542479538800221134503655896968476714075363886042810923020500656358701837512842071942071059688713521638752749331972026718653729974259284840119762498270089689609596447186326725122613441584136512229125273081585617944770527412075821520018823397527421692437143171676278150529978135763452948719e78"),
           e_float("4.4366344372439682838992374320368123987977264979374923723665225829811419787283531836118024277927779585638046112630001260522861897326524591106512735355920065427567328272301876193489173587083643294991624727886251611255844899405848668935593882545484211610144222588730303009089117491634528340081481782213187902546246644740814135436974593162778071713002217164287858734266510020833606669360282470787751494486e80"),
           e_float("1.1071249922296456673611169807119426670953096566089525220592645235456618240535615751471772365996058126232542887501954535309840921812356038164495021781567381644077324472791331600499621077260848657645469238460351574046703477006049533829506474618342724205575580891817359458800044625965954035504732300952684765640256573936192519798669547449397737850644663576851021358057878407467511243049909317814736596785e83"),
           e_float("2.8203649614186238719778179065926718929018647892793669572389251667591581941518578439025492491940622337006710294666250709170528661467846992337861253688484265561998546243801455784364885625808538842969116762432395221323862563946733044814245053497123416248691843974004693264159293799617635936905961986524188556071160002059439925655736826560782140789112551935034679635274193788496470484027085323265649289676e85"),
           e_float("7.3319760958082620422373273888764314229410588284456509153289504000488775756740234321279772223848619289101082012530043853415975307857055308259612776489740912097075770953133162505691142363410922559555712349642463542816211436310348027308607348228266206781575946277946733631715271337111375762177358743200553413512045975834442843579717297141869400783412614542238960706861411445734583502081820674042875062968e87"),
           e_float("1.9444160756209807704283336406662750197568394085289394824487664993543761953758383397772922061249910931744260223542777580052041024039389227102078400257660498954047175099870582907368029560575130498863193227442256510771348829810846264844878861938309821557624606921833188268047250541655221154841300384431524323375169183725496483751109687321615658156366465230467754741162815389806855931346967981569099630988e90"),
           e_float("5.2584666976559842484706109961348033948273432410157481413718021183907278715681782603276411881524006932582295720348794261679690813874588242873696457541858753872407805414968097061852662328314536745995249465776506192654030893760128747554369034732941303800064382933184615931240875397106062179166732773644347923575631737861957387999414891378859380093958984861283066550145704401342987960038251274412458216024e92"),
           e_float("1.4497199473307893175835961090094593674356319983767056470546561159070255436752377993837607337868452279770403538171428175221372265273399970521597929906066354198403621651925521411216462281109712557293469218097013481246098117426001862719726661542893472808223078778901367125232464575896081365210025161038540780450807153103386723338934221915597156858150806965898911907859716965977575291041600394280775319083e95"),
           e_float("4.0730655919293957433592999225868606109056949063282367475890071580522475238419851404457908119457412743169238245698011741816589761766385557335689520554960459881613232903435733887408571777594904284206957725827329567721582899811663876501522714224626402917739052788895805823381667566088092138653598614906278744649672647916148063925438437563804450792020052419196909559135438142631173751665379921840535035348e97"),
           e_float("1.1658216769253934821388820503621905247862160196347577093268951625134057844088835253397090151259539625971086322504128929057363556112406185348726317405539680666783962115298507648242048678477230820711151085387274678759318914768129961401706435507806445762989578691796488079262968498959063309463360792596524437215649014227262478148840082494249710315874435140873749343883755941640142740527891721132875091836e100"),
           e_float("3.3984527271040012253587462792386033422066553198781598274608072707206692153759433135717076877727607332481585219055009494488041237907769677735778743488793076085820956992328495197348301616698624033880612128992634492392439800992866829161860092199874004610753087787411828273926568474818515103096194151364695118732439574521047016841597281309268286745946271259011639976760381910241192071496658608850863605711e102"),
           e_float("1.0086428585967842551707742325736488259257378988060327346052127126159972396776124145717396164328641911777005966208058570176046092902071598945424424677859321986290678666690363492285824527618602051086528808762728967346634290635830936116198652002003603918254784739515364133364599497736521248409973519863604050036898661252254553854497788021078889564185858758746727364452662773350283168644721874489588810977e105"),
           e_float("3.0470040064037326782094801984818417597464733125608879180400978366644497312326213021347993069128023586817075514807090496652083086032398384905753233619412865824930959603438769865063507702420511466147444898918370119438789455062492888829108967078565708261748247916889904112036395582703823891374287128053611900859952319573812537278131028616417938371376739401532799731008823173517932359341036382791004314722e107"),
           e_float("9.3662114072522733785284004682916335456437485997285306583549678809396087828040801787956177786768577913243672849401159427865775567440148314523992877946134082242108845277357452312299870166723513073224397648658703222930445417556519191318917599443961001279994923530877937057470496836104941108912900634921015189307718391822562481470721232999797393744089241851468183490554986290112753465783291667115028546723e109"),
           e_float("2.9287990052857215773855440127940962260787514216076247466613618599334399587953504701619367465960324638604316916144655593031844435931103453718273271687190294742733528395676993631826647313575283475615764092406718692369234496323107538646689407800210137277982518105960202679721063193556802702071808354812510387521240229485961190322120921635228465284246358921548453955871511324532630464505417241770177768065e112"),
           e_float("9.3139215284783925483853213572096084332528097754773843686065914768518608451616550948734355612624572785231977476487422017235240171584752475207776332413530779813089248034142810844396186763731159270986238480908424779426391866000233855655847356393212259097160896706004244492136616437140279443676734217868298110658791920680669478431980815079862798055021375425719439214054287078011850058582603775218659378732e114"),
           e_float("3.0114727613446804664217001355025504837836270502863664325727817614820124760490709985346916872578768029472553203273241712168474297370488407878977061249654243235287270164996679563047424954962716620708647604909933255081959493150249381004912781969755178388355995733304997610638591080855320354595859566546611587259982422197810018702276565943060144803314038996250965962461074247699760814972283525166237940823e117"),
           e_float("9.8973237390884696973720406139697529694035771905418962922306782122366170366371684029737752738756618432204843727556953493876985420333693108316324874365377737195657186295571451272361107506946647098588294912934730341025750912941837214514653908316037636507203523597874949844778896333799421496933031624118901670701438049594371266410204705658326678459513795952664239664184993112887660608595900452948575121629e119"),
           e_float("3.3055310846963309792333855426296074046637120580396519479479823670238497568870795724425061660383201359674597232688376419053125255644134059804515463450338200927586953343220015527652057117574973971465353519820758132273121140284541333805813693470490975418531721984127248535185968763930731376290123962104577244262216214250482174969349023761142315261029942599063141442891150715317088563034572609045110742833e122"),
           e_float("1.1216166673305459184350180311258202529508830229073336008331898341852051390090896626746712751594744805912390729585701248617486574493334217344684011594298604446666303560442102926316837930462621030299065175385501222750965394254261976080990468036893825754786348263190728219486688251841211178820015511155240091488285262206522920996667781541889071797311911421996572196616777216302346624874784155517571565962e125"),
           e_float("3.8656751624364382092357686888351568453814954855313548355202477666513154992599990970745303734371097088256429218733302677102267850677968826151185199139714722356875572061678363274808853269368996472724635082592094556248122603596459007318632935277673534245314742530388803463517461990643181814248929153287484857264649720720183753825798925813150687668394329981969212253803792904038818625818702858349414334715e127"),
           e_float("1.3529590714187444513415735153106767510416730267051608530617432109512868867096185459959644810439023610024106357003627406443179711552370959572538504593283927009164177509281273853268776693242957881345407364033685255199806998763357089232417680990078419521362579686302851450285164387177522638786754284680780780762410406154682752030401659872830535812517848890467181516918067380495193973213201313144717299361e130"),
           e_float("4.8075711800435187546701081506461909409661222655650074763476791678658588133723961641745919381433561718921046402651492384389596918384830473518858203806376281159466150083112866281982677664103502664465255103935108190165180616714905863696931041501031018217973073764892178190669332334847294771481973938754983539728818062875384954190758281916823066533197785190208230450194468612526112042081307292928902047522e132"),
           e_float("1.7340215008811134280318692607092788507735191907577909006766149171826745338673522432544046029506518817217419453754142258309223531499787343785790255267436395551129269575040680862881690116090034264353824329069433124944408385637805875966153385833668865675471060548764176955650517638317901403669588619035534267097094627728672491444967285934762107009388897735286319736890075788108351768609092682603635178784e135"),
           e_float("6.3471583109041441418766057658480702603804699273620479139142906844195475226667230794653910565523647658743842453510882653224402700072375091962074107826962318579822594820843850797835870293154490710567312339219595908894071496199931361225530197728593514767159956570889515848197214149445230790792165972909546027694380392197022566475211321623247412179526062378510007859077932883628465218258366815371194307425e137"),
           e_float("2.3572794965115422152120039718836501402274556597684243242690753787978579565818366896748802833271955396687746988814372450702003767684581850474122524971737079272929570607236434646596153341090581354976463342156589833402943862823069467880632524100275537865563034513016516062030416829539327376677375228108937314925457813523221227188672315889150043345557315717319878447718486450929054279052873274623376475146e140"),
           e_float("8.8810196354205486046516177753940142461313161339812733483618955206898471792392998797971815677218437680991723181315500303284765566405575224716935235575895739069699256389693296280415655482640465305789813169592991467507173450304914916957009203245353506552151427273914818171487053747029296757568974066389524293115736897362567725037687074171023606184063230902626715550118747318546312609111034316294573034544e142"),
           e_float("3.3935161669493933558602426254153519835259522327242088370205951224363686894781852348200283419746842685903253375599185720813052167993620058195206022593354982003594201914784217662413145423255172239833345929509846906249353134256890823764823133081149054396254255905818665304344441725843504330364971141351813503495118708452940265363262639750279421656194178101845822922888769814640297725815781172259784206823e145"),
           e_float("1.314891281467547030665059354566414603062285890069554024076833487651226920446085941372249359947908922460953606104940117642609932697271993295616780337101599960590211227287958164016897598138045221577416087372883110550101869551957995471935502869133113887899324063114502513252753730170274739757887499518186001446741511441720785972298003884078059994329289154435109818237812269568074122053325781111061876209e148"),
           e_float("5.1653787175080634977870412226799885185398277099269180433847791930106630756516597966469296240362546651653920437530557316437732949995589786071035361180074704819099845740294894529291249207548645555414054519805678480669119826553638715320310486881422957787096374533943681986452881513759516551958581199701698490900454926661797187119029872425271802466001040182728252305434480234858846143979244892015318495763e150"),
           e_float("2.056877693050610470027628933564682759487735643090057540678448335291551419951976538883101036230798686637468689550369916020405777008786784448351066709503196149369391375482885943831447643464501009750062557122750357085710275766928493730475919668576335964249104852184462148959947679053697546778249361702223806661762252566755659368540452593698183958372461239911962506547358695544393590462748908168913111503e153"),
           e_float("8.3010352793025202221249502748232999612390105883260684721616315962969318445849077515489749143722844978085703612910843838425827823157164412709096270841723879085184220801104928616883184829312525271591856489232686370468812176042965607454225897811231831525000319287606510647554500286527730394671391808086914880482092863305433658881081356466786322323774732319276299905989911741198160447369628697591866574434e155"),
           e_float("3.3946807026054242997389187741232488136009440152543530764454866008586197251779739698148972278865569036301348832131444412239764862967778938402150042748135708149446782365334986161845402094711439074050821634755912337762080572257714036967548912453801712669276846478607155121730225961694601066885973739144889383940814297994154895814854005695708141540630386833108254822157234879494110828807595634562285410654e158"),
           e_float("1.4064868718327206012385952978197101401589949929672913787975530674549470513794679069341613552983951591473291299272311550944844950681267100199685732319896416877547750390708110279168444168476232492338899769776381345396350034426645704806922400921791454749419988431898113338399119533423771753274105749214955432732048429776269385209050994060203320185590089595203886817157530566528603540416355354931523262281e161"),
           e_float("5.9029820260980812613346910780209875830673924023007908616303471803882119205983743119533156440043366526426248296038997815283649998654364971233108771705711588698779632026058829085737432449378390155369434416211980215228693912852574965767011626265118245054662628977291745544065761855365486257502819839644725536130369762732707823440606511267336922246852048348124736493369634468474518907120133690691882319262e163"),
           e_float("2.5092093888944369147501022458288506855416797244015339647922595641204098148057762994602529280109432904300137472245040383579291262929657981496194792651701670342347228970115479506721681850353753640854478447265713255325264225694650192597291621562988331429721911350226212729328484652534785163765140143390963916579725930262814861264716021578170241268985323926950867636408816734878819164645775190587008694281e166"),
           e_float("1.0801007921602098745166620913505064750941480168941603632243982735547937786241358209517124750339189198973186282478557496133636972187699259933192361145734235782704202836777776306167406810965978912035599635608395971063836502850349462398915274700740574797545970862435419030564848216793749461812352517606045922660860789941129846673989199100107055012715678513244367107342494126543582784705622985698548958968e169"),
           e_float("4.7074688624911389159787330601604229032174572096569912057569805153970320732430355990776170398273322848943764440940825871007932740773146160993022865360993604713154138603419452595048995649257240233678735153733895066439517304885199326467057300908424878356163240180376493949291089029086720298030094971819952486602954714054385864632598119418881255188250458065395676012586127430835187499123798320971573279042e171"),
           e_float("2.0770253644762591403037891088694296223923786766667160260937031384506312578316752829164270973418044854527459510624087413636383607992905139771671114160411285040117091930078739721904545238068821246916936289223342278137818323988259080962122490095929104163242828630089158199092856690753016666993331209976257207985576272367466197862541146362442801812751399461082090558305784936332900445657952440454305197568e174"),
           e_float("9.2760734243867802469756464285282171320695043499573715708745276574375081426743988906057106427130237369677844873002908077034978617466599669081908529752475403861943739288626091094549645820908896984344061234913252969597150657909077055736090993622958078685865203494655819689858332018238904359603542212557801540068842373430044772711745042091150906248264650739959934086118225536457814627701517917008344388284e176"),
           e_float("4.1926912340504935772110658559513623081697951904331499263848294331594662909084224615463654919430809508021313492265016656717257722337166535682288692700961415169696653808889470625058502272604923541218218821656700378482640986218266288586651126181884967416697753017517949313405950860053115820756040447371276144432741608562145556845757307477858118654578442108621550796804891434181332934110625362621848055712e179"),
           e_float("1.9176422334268578331773202505858340833117319847583737305268399698926615289361297528921917600808034131841717059630648686419921315166715055582103167687597329916134455129917024775195512245876710359867024327830568528408081490942491839399069505512072528676565505871185905025872833757359151922248231193249595461852067565925685974520509299006134148609446646881674934007554496614488925747746431820425465628246e182"),
           e_float("8.8742020413445548445160693720572665906675501395128421064869516999617920554990261510096570056957359368499906878645051239420920285418455595883433571489921928351972012771335855833702286888856118947946505418507315717351237780348037384019851270404903308144918198640241257995580442376643160476046994110743609004351565743658742036739994429466509260099443962962180135346309740005853737167653828230089371159679e184"),
           e_float("4.1545154324273304943700615633742069749874394955835749772863351734340090519329578551603759247262493357926127883528033332810471338268717765800052691105931780584467086320515587491448479669506936796585829582673600853178071051928031617504080944742989976889778561138623006287338975030615171085372410939411118338685556285423310784563266127208030238766697091221229551991150304891178869742267815212513438666012e187"),
           e_float("1.9673623416662084556697977303211249687124660848966232466180794952036159652805136316739618423960976678384723468861495994136291840517509292320379795466249749387377674916525826258955426424867316103030069201185033509240110138715642044438633156447806189963662380260842064971413413136310611527056987812688486736453841557909046928602728285348273963139504844404670109341694541276717869053668214303083794761224e190"),
           e_float("9.4224976714787495625065446631058747037725026995131766618801450010584900085912081144535748102956155722806137717710951053354246312685352789616619412067011378947808787256293045646711489416764475615557021340561580555537801061321848754139943137277528737608788287779091969745334149370637567326942832653284385295718929998230755411842357109532685012066902948868407649024723019703939798294094590166368852688803e192"),
           e_float("4.5636402939397499907132225677317565725139366764736484612822196902521609560478897172842139811353871990368926035114026299380332206509320532740782958155430699576255975075281913203044379371458287022028187674780285930378734516888155591294545151816670310648603322233218890583931083885006945707491820952244753218244821069070107921761734665806974185054484852425970770036593688608127307055657241994552109527133e195"),
           e_float("2.2349487878929561490408925782332231925626135944499712521910995536523716585837676119030985482097438964756789259002085174737413254620901479363450895206714504743197965851941133761946145525095339039623020457717034635838596840430992260348692914794066766808046129850747363212787940332868508762144018900048222584229495358475697839980985295148529176387724213080960664121691803317116167098143463548697502177247e198"),
           e_float("1.1065799055735877991281334137537378874571927910193425487528757599929811443334376178570200125694045764275784695209554386558426802905444822564282807142869756287524327962110481734353085061048382841892458812054704351348919331498779262316476140675870345282767594837734143481557862102431723197806501183269802081951160818435803899599578860750148475608098883509057825648664926709049277157697389163415380588442e201"),
           e_float("5.5386806337904332289978322791623869518680471498605270997409215988725873599698976398053422014278777911950058757103450449325452634422882493325179505511865780453845950641359375245969861531125791255619483407692126521518303126640695629775416908210782317614312077424241905879409341469206131266553400639334038513972282564262287886122966319941552122787179807773266878331574818886667900602034992741771355833988e203"),
           e_float("2.8021318165837189772619547705402305342433487502088018978970637609548762265359890171703081774714617508172610468082698978194402065197278283974881747867597568591516464592950620224654885851958471033588901721172388144992398861984059583419137794386163661451462933716447556491548262794917424100287488826852442581034433952421217968449997290817059375306632189383972529462146570087143608681314672355485881330771e206"),
           e_float("1.4327844424358013416396920062124500523284793898058511086701430119197343376021792907240350294312467254213390915803708469334812279253211882934187168520456684479643344162754460778134726622472033646560046068647545647619936008515078155066680579810296144896538406499440318249563108310212794772548155120818926196621407232430330193070877123750215652310299101167516514069710520024940515052636275401978273107767e209"),
           e_float("7.4034740931674302711350832671411230928670336653588129723407643163577339404530200779569637661462864607412522196063199938020143546063763093865172850963935156664712560549915697030844591982811742295063468791760696788916822636371849790382629807601150126584049990044506953889288855467226856182809597968647478618978232833965611398717321425244257452703117717440664559213694978682916162367870324849852407008842e211"),
           e_float("3.8655026671703658862398403739387250489973600164334716159409466733704969889493323794340499525108629488542456226023593402130218898998554146303708419174276085038169902276814422764918037533403532940701431161900017743065955690443178336174818689968098156567627825493860293660276100782691478647610265031884012772152223715170612627158024203422770650132807521892182775959295182539853418176391727551960922435278e214"),
           e_float("2.0391366848742887461374152556927603526167751319449093788039024279192606176930171186796668576122843511526873615192553236285920363192293960663276534757301510281447025281310250993513844950429053338798353241482482403936104490140620000013407524424529426901833373784690659387782941699998672551154659217856455512406298014738021743385604958078109138438282201997767720379025975741541969716710010901943654930171e217"),
           e_float("1.0867052754921355294295368060825531176383148040066620811867909827866588359314816936955418789697682812898689868359458513925504106640957744733006792254171559207998388092481924680497478810292766216055500421038486182733201484638839537592176641432202986172993863550991216587389675883848781301341563638764814712933526790104494748228353577897044854711671311550111613247386553357838441528826798041637672652715e220"),
           e_float("5.850032753484473869822957521489050753934542585979099820092715168941745560257621857046047208617896810751404285617945332776528424869110430139692762802367313738166467182664439102224034660512676373710153610817948791535603724878634236391140137312671656838079605918120519756374997143157330284326679447367081946319069546181426262703655499608870886412153728936843450560964094626730755218842693219302246799429e222"),
           e_float("3.1808468745857875191089543463534171436083723290598605019443354980175451251781212811566197819925899008645671614817134028887954250756429555245320807248218236214904815290224250357696881611702131334181397140157779559440055339909611626625788111591862519392808377467405754442581043279452301772376569634936379704532913996633079751601986611726589352057694791416575177858895881672969491455437308259633551228908e225"),
           e_float("1.7467182400141607453025712094689540548709029068334175054099178598277300693912978282008043136414851418860231723485312066765113163244329252551128443833002002761398424538449884141243486469669926638146481603028176820071504742360710899827889907408701963786991091834080384846990799145234104038347752064143038827517942196269127024423383634973972671336187825888600509580096539353773153420176378963347377085709e228"),
           e_float("9.6862809973987047872450280465575843368911026549799657154479406048128217991540233829250607048071010645480757858473735159459642596632533966805258450141115494385504393200475350191159045802312886042326401069575079900281576610036902691486002816398694798131722827869546787531655675987035261605159286264333978830369984805199975253807012070268467792087563492695669185405429136170400589154607245618057673054037e230"),
           e_float("5.4238123711791644754674213591580408796994451650831324563484417058786298538233536710382113644181893822827574650937117669782023642619663478495411154947485465462621274442773192414400433429806278999733049690195823565751455854391570597194572996883952501011611451640003814388420874442263078990346481743469138944856297089328542289666102873657258985510581611393498819658667647562446309472487551571889907930027e233"),
           e_float("3.0663778268665829398595202017513173421905397631283458681005584335690843073292475426137689726845064193012336278300062947084708845770671550596417195801552445813475774579345870132945195402354082644980934322228670957826316425533050494427796233672277358572277882119575300208347892355161628009161215424031718800091374513558121219835161654115083068483741364501661535659382858776301426669573957191785344164197e236"),
           e_float("1.7501725103780088367175428281225148525157320551637115270604158399775592550196176783896995740059031394041537253893835253972556209506084688414525499005564124272727841981035473389559844499126330652108026978177877611716115064314025671630300716480262798673066778176009793759647041643476534383209062540477083222024156656784276961993680440621780965706145660817953034743708540392414568482540452551335880665267e239"),
           e_float("1.0083974126747892506846883353307928308688366126525840117044806216968697039900473475788450601442034680182739070280522189124277572787072699490684877222461992275775991987053366259530923863750143406762798644123780934618355350799856655951029447411626364723927281315301631689789372984782792033349833722689670839518220754685267645028346058190322612151286606782034925001569257256836859596147729423321722337817e242"),
           e_float("5.8646277095121109526064489155317601452273322989560307776803852087971952987828858014318679292180149398965514693312065614851124287903856622926949370556526654748541505650507872459066389429947686409032428514300340147506546976464419948713382506566119406978503728688313722248631166056715996037615546972198257794253416546291156445486904305501196262238603937132231100280310670818846840017788701920421816306917e244"),
           e_float("3.4424679405842392376787123313979981875500857317722674584743661938079110905273110709560175214899819087159865407531349512975947118145971940231419616642246337032237847655519122630944550800714394957220084525282491514256257008518763502071585957645644995818744463788043061754292779234368114888245639222759756864968936237030872003253934652160748719316292488523541726738380671010878783175303567317548297729491e247"),
           e_float("2.0393117701035960355651648663669505877813591587063140067060912872541267919886435523743984173026624652904976390040972902398885314069383341716174920785227332989314481142422557250902712458508762358185834070021550129574278517164699974585710162097390632670417313998446583172510714135328762996641372519159732763539535054722107239464212588845862168220799619825202392099079916216625777425149974742566320442551e250"),
           e_float("1.2191181378329090293619339588249747416985849697971659028528145556472846138355369682389710511446181393794939410407519805583186661213369984392474694381027167939156004117276770738029962470389996363373341439467696905609409464735439197511386507048614657056739720867437723924448032339815397785212764294582211569999781793522817837734214351195068763820992267856069379989906014299225882847874131017687831065751e253"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01023_poly_chebyshev_t(const bool b_write_output)
    {
      return TestCase_case_01023_poly_chebyshev_t().execute(b_write_output);
    }
  }
}
