
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00488_bessel_kv_at_v_301_3 : public TestCaseReal
    {
    public:
      TestCase_case_00488_bessel_kv_at_v_301_3() { }
      virtual ~TestCase_case_00488_bessel_kv_at_v_301_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00488_bessel_kv_at_v_301_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_k(100 + ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.0470481994329091254159295743208358156966539306169500811656115830428531615942887155197878915282693535407871238353392816879397197813195039304810260043262017515983119457780316161572708864952771905868351328567010366459510202172172806197617618298358047718092289026140575805948296049092234071443784186012788839931620372758802318443889850783341944833826831138555622142087090130183583938078583529761121950361e210"),
           e_float("4.3430723847180085942027559790295465231783868196659188455317813076775898531009319615577724209007914336130235047608237693286679820982034766321289604591582438323940231561526890605838462545488240960258774178014676550734237864079045579936254254604331022856612820155567025373679817444072157919596855612840871224834936724536173326397515265091060196420117921642743362052631272215581370686644553475757481647366e83"),
           e_float("2.0031158628140708639282646034645354624868227337445112004386854577697206385004590108309528969022085890504579184709746473696848643141118782755436350613151655999864830306148257158080727132103522994624258953154752516700978485728796570826528681916747166941310774320743637024665157529236649176399953632581853319739412467613572517271970284845408151932908451856770025378104697825387339333560274686419570953513e54"),
           e_float("3.1151933097836315602367521626956075045097940281802662632263986262552312896574520017894666087761111520465421350330344814632949457154555495261073253619085961068755975448816012447538464247106637250837731789807962477263303448345167281544879892467540872705111714734184207844767969843235351660321701790338989881512821066237416490330524653544745177509346594068036008167246899513980057166108603841810470583383e36"),
           e_float("2.5729662972633917228027459010604957825864136342549684856618726501586504833917568522916776489066196396742287338790721394195209918070716322960431058982593177987259091943976466548899170298825730781984227333744812890963518209069895873153344710973114364798773995053834109056571760616677466643804013297752381582667053407608036368991638091807515048778141954844812940987406162177711533249328312224526524537723e23"),
           e_float("7.3004218985721844114814373182712316942828685938574436292705342216944164609882837588533793596009610489236723806167317591740169873998923208997114752886110627252778193826317924261320049650432582977988905627219648900112392291533745370551799799236251021970991186884611521417340099780955992244623411166208859892132436298554201491954293911264667459400526108874424722536322803678642284460937487731385392701558e12"),
           e_float("7422.7826876917467095213755999816999878519236002910760330291794263499888122347103532368478056365726203582757593705231485704678919932093901158760846411049179302842217612963741032892865158421214895721195745846815648984029621647192799247058011828465390992584233710934164037621152796851228507550089541837490305397219652945129412801162800304966748966901623712281419227914549821540125169012089754531109040781"),
           e_float("0.000081297287056195033405492030618489704162123430100669600057638152200833844784374238940649489497333958138118453061458723926627985477718192041645814841966638953046071268744145963761025465331060527249900942407471340474048812540814068047957389498640863229391777775889267274058494954058850318618326262452500916485563875343408573868476492655732541213685908147093924938102733186577800574211147471754712063104317"),
           e_float("4.7149902827774184796559955955528804686255246860070639839218607019692587194889533167497224523878605522474155838625591614089804741642524261739085838276169773763759383575919035023621795696579866637777543679507262154844853000910228930671543318977751465522304593621818232199098739205268372717498779148303699120503001207611454567662154132837170141195423274986444328801439373917641363576596332513355376210092e-12"),
           e_float("9.2270074983195391008499589554708778105626143356154264120196541389723184954508551080809529041007080056767388624317424466874530095880106252991774991096006883092797151536431298227541473642466318192232016213856235367648599705375521525622389702843047585958504583590591330728791764020394114804613117208423522436979154118586165726767822613959745075920478251022050109360638645392156175072875910402686335823716e-19"),
           e_float("4.5078534548816814400532955868033189204937423109154439280960085914556867648319329999707447942687471220947491161561489452834307811944400170719516971212199649418346892708768975746371973839116822680682044911998126967382742072263237343638752488187239335529045618021054104079717227937193122464789566531699607386437650817286624359379459275816797409786611930248270244233024106055870216483725603623767971744674e-25"),
           e_float("4.4584953192184825690030911068470781039754112497262181402416805861661401148116257442091254528909189401820869778202341520274927850109528505422202786788690251531937780905264386509756588090858237192501044845762179088684305191300556730235324144303273982307445387159567380397172936925152554821554307817410022264594148996417842056650596747972634293904380671197423433664404908897827577606427669234363085736761e-31"),
           e_float("7.6802642522648678866454207129878091635309270205438551218347991656857950553842264690147071764893252640545723990993832340804469585663360291964557556911183452516154841104436103516526516226415093727421159475926829421683392911342595994546100684716873925261117614389219559783011558028597635036524116457735002670225510739527401304489564298205077223656184045708065486829527715331374637458917506730431694761775e-37"),
           e_float("2.0625445357536290042517804113223060537524360667618635431044730862398884625446340910611930497415085173630406233556075401774825233961291106536372986199871264315937248155448880244324314971338650439075064013468796652493545508085484653465086297880297207062172347919520751495094039306031294960994280761952784913914122646736190940223610057121805674527367317230785447120276839074226873415600444684140156291889e-42"),
           e_float("7.9440693961264574067530593020932664799587248112509334467247050055303445180389126775945947272962051573960366000933146638257648706762599399853741034917594194903152484328207282183515303587666684306351336841984318268094565305174910091370588646010958018081142006143865462938071063329767901968994090429519270723314014618239869259020453113906131275134749710268163798339557019521334815160835407552844953809974e-48"),
           e_float("4.1164187155686088266333137495497873426646767899438818695159135761408099139706705754187451784989907346699352797727185901235641765841339663653710330379614739985070678229001465604288628285730224435190936396934394535107048827847481487769430686782824930563741463859845496952265876010114365170948354824411316858831042831410769793475296316036044016177461997776553618581649519632279939485626469521781612201896e-53"),
           e_float("2.7301864309559604116530898951758310335852971025891252392028016534762413173305973605865423269397578830322384250825863717325411220855504808219401283080051168400307879221262396461402025042648255720808173791491235058917484527784634617732305672215928665711449350168232086126145376829190847992791872737133572729682452009396056364721696104937143427633075780438041956392268914974658472595398026928438948547517e-58"),
           e_float("2.2282348864075339986184117228693868478317504145201740363376650861290178883081622876707365744451237416101787706138039261135904065452485409077943040456232266337452595531689645687763126404714875193054234030866487672759239571796275493635211237181282771275778014118970128431213785442661024319325608976221701140135796520765149070099674620368804114695470366135203441913001686584688706907033960962597603620139e-63"),
           e_float("2.1684138879126213156983187930358697039503884076018987937598688256586625425350121610325423070622699214041170108493561827714960774878912891335047941525517625023457287233601215451993411609896472278205799054597311778180011717522735511209753099355882626544383992579717854764374404128835106024118162473081702606137117112303566760091449758707782046173516158541561014847570106192896489459998536309283644742675e-68"),
           e_float("2.4528038842930917828015683657598817185918987843720707665098973668328777418192851175497820277014633119515011306340035793759003384272517735832056881290023438568786941056393248301243007038198241059706107436370260677020279888017935259700961584848710763598781505357821486226228590750203564939892176162090087056426477573667501612867980840125520829347442646503295593786017443309886796719954961923367353621164e-73"),
           e_float("3.1584249187956436343980169787663750333229944082618115114447348543589986998889745208958254574925213954966760901856383808268829887705854152622071161402317444923874271881682747126885763968396374053554648063151778284597015325364265564491645452115998254890727900501139842879526679255469773073638822577493314644642206050259786731728817310468434663109490377348631397628514623002668647042904734721989712430273e-78"),
           e_float("4.5508902614720506230068282153330669963574733004694371049111381277823333141531959495945033375947291766489310877234477200371631516866670294722963716301699756329287934803436692191626100307012901785809547640900238847772869365812785120316160144035779984261626573815208263234772388543565956004335827400391764449663870898331698187272346222695351862410559784405808652265742427946094939049562448986570936411768e-83"),
           e_float("7.2331162339812174382964336316957624833883301157760393511659045183307197401565476940663361324257984744632633531504666475055766291342788005756457225062947613384296858516018216541774718548297604377305414882700100862021372899840630029977492522259714270849913321473618636175829978078135187962774675879128190976691973593400102930791017692160488729336401598358166774310515957730075626834066549881958504451677e-88"),
           e_float("1.2529867057724348256631794776313167833920082650351482825506814379266361880724596896483862421117573136151496533854868915520529895958098625283526304304518919331513580157323886939671693617708331573213346360839005696926430849372785401608524532818217565496910250595350790587636165411716381490437515450134823269250006045025308690035955345126818157432411834002566961406725418753908835874215625440896081346705e-92"),
           e_float("2.341845824466558985250319336606831984823861347383028925311796750624409312746500617149129910531768110245158628455639114714907843236750957681579996851399814331091724246080051836842793361129375918867425959584466880137712578803124767618208577532507550221419406253821438402385914691799579468566454105971255314955587231357810214702099258312135687907963261713766839839770309420485217645837741651326944524796e-97"),
           e_float("4.6818722115256000708583347257012941854881072430158690958310619465578342352297319213935699504366146721251838943554540764696384417954323431292856290095853510315231420025686556515546147554915332415123241088700171025865880035474598090314749970999404645901328294464001483139069051750195494932101270116473610087435827587820703036868133468240825345569642845722511047733911384013630652220160797575363439469251e-102"),
           e_float("9.9387144827226877475018946788602221385096952205148121836682626556864730977975163071914476585186546149946066681544081068473426281994423469512318314101271395005164449130321337975276761596709138050873778795770722031487238587128569200536130993820102799332033397425674130463798867203755693474190752406087042640472699220212070048699998732151001840278065242156677414998878236562286388165554167822742873545773e-107"),
           e_float("2.2260645465138523191980091587819887895716107068313100848314428464753531082895756439350942103362711576690658461834745317933755177394648201312355681250282443636824296775893784979612834377343640352360914394962469964503921756868043769858590001124877062917771084962197470469296426275599474970083883396292915184661894394519522039974302906836567681734526201833667806126660694619566217528078849070856591692976e-111"),
           e_float("5.2319312784548678223667217465075326190428928967279505125921651678663193644455823505816158246500102582556629853128337497209166905992215396356446742335138884171262473768767246405976385298299633458008299272081658154635178720538459161436455529244994875213250005213582651725344231380977586967862565236805175321766352104632950660736694846549754775620307787576988384057612830300785321186470269926679773527241e-116"),
           e_float("1.2842061295953144107573035683449691119350358694271495352844888566534219337358892044149023247776805024450696674222613356574765330797211518023378261804084655675623349883066206205794102564843559150446061617298472850360488820335309991707385464513191893189698923763892941446803062430291485376529792859997143235074096275728383045982154795886029586142672766723654093704362778563189633024578692028604900549081e-120"),
           e_float("3.2783115714363185129474054857154262461280017076988093911014107224611176319089652107901239227767244887622398108130056516839158513523659556379596946841306706866605344067071346656942777784480376854324528014903322846816196154556853255011653552194376792174883527409862897903877883216645832659750253226950992884296967221963856138884958314385075656969600281429816908742591790923133059846878287761858285696534e-125"),
           e_float("8.6721206426824362609091262008225729100828113818088359092089830054925294457416897601718225253053733803460146512739724437810904134939468511034276414472493218507237026619156438366999537144787802365586211676802679302380415885296588903253080048347448263431156225259889070255671165473719574565297032733403938399150398329035940955063067926950671747844620961075819314654055871230349060687933727338284294855919e-130"),
           e_float("2.3695517780011748948096298048489878618830396434153375530755775218396502890585012100891520582901574879186780873904337650461981666009646991201821484622599992732471263419292274776292166294197314810481019935605277648454836337626202092337264242516858005801855001300454981950922931659718866500751414771470426943663759236780059972727935933660549593453812532941677726947376484646645008548922131508315652384641e-134"),
           e_float("6.6686994273791541054616241323223039235283398124845528749980089333267758705872084896756783553758132228052505376199482543518458037388805227499700016400943897715917887217165764814699522934105204589621849826661086412118337035985001265370797875046882260473644908095659795364187247921785235110907358561411456936277989994898567130078385655020992400277493765057782790650338037665810130812868968148134232233764e-139"),
           e_float("1.9282246223558833104531886278148374924207010119952476260406396875415994315571840002053250130707842065887740333013865646250797102600751955234502534549685793313287390254999298906551477232629748787150438218168834501317112003957716537008191531289685732799759029739572463828163418439521849742925068156054040828601396976589015059760992249688796319745663596132173914748304625482022034172131420436424759492291e-143"),
           e_float("5.7153566406114812522910158902555964760327442836849451324322494257063981518484505581621701540285915888721022057086265377669104347126459407106300442420891942509487755071206666889848036016834127463195160788857362114838656770560353620253447036647550814454457450461509668227801161021630439921442135708254993329655866543728410790746416962859606463019016089664541166971057301795325650056593263721136814515781e-148"),
           e_float("1.7331260175946628610244320002358342078114738555098368722535256132655240341034584070449726956409735441782666777452699693652511074128203496308001104518797608806749380303191898343699715863849084286143988629555498425074998813296151526755675209897038481291030829565337652878182618455425774644928978054662405609956103613469796945396012034767364138175573840882920590021182818723003014441969610316600988999638e-152"),
           e_float("5.3671106087178575525552478967777594031107851667881082129205951536431839228668361068776416147762496575712308523589823452882841580896963142502613657947326373325585102085073812392163801382041465070671333883374020412360441384985830490820076370880224004005851127553455373297851639807987072703473587845626265046992160720644546307373450446680351492226452906578289752866697186953052415689832357492658777322026e-157"),
           e_float("1.6946351152228591139409832549674727118118101642070025504920744910150694262290242516560568839956498259414867984361035606275274649772926028148276839858974148483188147456648430044662562885193770744677605225266735951032218317695513064488344363507524974178381725131383844270244007807483440424391152703346810674265396123749984351037802401709915608197123178776611524661329715029367471904892042528764525779573e-161"),
           e_float("5.4476365672755329601588609088277450993790983531151251750706197918072045774647570467492882958899776074617845804959294234913482762446541605829228874074312288062689465878403336825830797954613014476395899236560980332964334641020236388077577081486138766735937519634687447503030585542556615412095677926622299194966656296600435169880126230259719382371085170959571089350909590193913577389914481634558178836109e-166"),
           e_float("1.7806080159459822283794309390420449679534526221470543857766823298283139459196960138864793455393752843825626910432948443472372795752509456159159318023568043745853690489738842550369587296523746653068256622991155459587789921895143181204274604375461585050723858770589644678558895295698503265140754569745698812093929550889992538214192822784747439951439448794633283148404607310355150557875814291938422871132e-170"),
           e_float("5.9107499739598471512986479027004433206892017894615583093137779549711219111923606407618560298942128005776012737101971400625322225236114507811807562843334010934228894424462342773397685203973273460154511718342772499575240330058386708455468194477110430063416817068456429437217699945159015345598728150102024720450001731686468565273556432650626331038702512745472903828076933511461380871891315442094805484174e-175"),
           e_float("1.9905097229427204379701950454049087403754351107985740829704009682402949677067805991547277721586938132744729563433397991112014126866888115182462438199012364104919842852045614756165213631594481787973766649130850826429436686649877970867907365099080736062941998738453921287107546830543565625859427939782536904612386452006259374787416405023523608303854392224224943846282532716135567570720023583874164184594e-179"),
           e_float("6.7937423256661255263674072890503188110542054915089246166545958007650812778258364780626252786132674255636253394295545503071915288188102787610730442402021021922209978952264684285096749778636647548315156113825270411500689958588306852663795058866628420868918800983726680229324185908737479471225958240545779032203085774853849340407753851561933846333525733095242137728115269176568891317164785775763210977762e-184"),
           e_float("2.3479565631877294148194065956097155067213589993336037921271349753257739468016397051693103811265947835612684118302964649675922814829085294144950169245642385935472134555115194157260150273151336910476145394222315601601670326405889019219971065056205706501359310426274953629508355734925968640648369898111331512325753647468880791312704716489573029968540653650541131920593332104928726010072027039252423003607e-188"),
           e_float("8.210203817043031169498519436515995854288992425632801431017682474176554173700887301275190359227880705262468856030945205651804961329121197802719084777414859269594586730122796450925216468685749938169561202928391538366914895964930252382668796265149293933196209293722633613051516998574836495897782870994616535674210369966826065966486344751367278294877954874145249856271441454266201334575341127011678213664e-193"),
           e_float("2.9025342126363768838920099705810504965323923719895755085228131833190637469662532876872970108026783529116263366390354691343799986891463695324876787479788395699809903527156768657840021729872708962327608088407465069363560472991931325105129662984054560289508576446585345833904040631054341877870167799079186301205839012378693447235205831439209732017485941191375830280889436446683266205610627903320409444995e-197"),
           e_float("1.0367254977335150548283464755349046472241867911544926460141821610311233846265930649482055005130328330514850705541292417839893804372478068234797236142089139085110302612484399600480964755154446091165449957522889127206281336143310394337734332410259479608189747792551702674868036611107276536213951526778911676000406202669828373441636253503314769151288508962463947566859045916999840176862439545032812525938e-201"),
           e_float("3.7388742797856146553202723789989202165359169741930594004368992009716140074720888661330575926548392361382979099813747944116099907336060812467139130608307912602387626350467305370346264971291399498709427173047532794026184434871477154156125119495754669530963191582520899247808552601999711024759643907499895201529703418602386285025400202014030622991775193076619898168556552558651267763284334082217008602517e-206"),
           e_float("1.360686107205172130836164595797166666741542697070761709024613017899818128941842042532629551565532850597208723032909850710266475684437714646511928801732157005535624633596594741920668743037472770355758413048874075036645984752356696586123325966738729270887014762138683932035965826405281501495177899151742542086712229893528399585633507465721561523625064405390257170828931183495541221990443390877422877653e-210"),
           e_float("4.9944079113925798651501997022402847070672261587840891437902642118681161037252698614573888380365005739189119691363943061926516848081614846662264384405926167161366126795705746704631828205400193910991736246132867464248488189657368611941816573177884495149558937824654021014858179651508429366448990341136158976891950353288978109013810752419330192482481773150136649585419304193059065136012886776179902034194e-215"),
           e_float("1.8480160340275993930829019449818764582558866546716350869732634275999375897180106131987647728199325141858729491427565859197981098335809679418445074987855133827662470694178490425984401159419973956452978552260814769549279016183854222064134148690312675250297456103934123440854212359556693210936270963313252297904480332115089663238104354771956315123482310449015683076344029203065195819801182829883051503446e-219"),
           e_float("6.8901057032315709657131626641888524431380992009273472524247148880145429164464734964628966904680846562635454147877333883704422002259778492642197088111384330696481218010745665910876376289684771568734999973390340826592522225809134575922433297224052086784325729387721871037644042912765586884024605281012110254223234870406693587305334907023250141177588770082816177550493980625976436999092438591027376873799e-224"),
           e_float("2.5873894230435953432011955587365685840970051465350229408383595879507981730810454573484088709404088546555065614247744176819269343148233657188835684288239503946582809538686937913757408849748156803817916966547917582183047156250857743047215093193172674475797094947763004234707018944082336036305121578451744210530934314971443251560426031183826540709963510750922294612962885443604793446575376384134168222012e-228"),
           e_float("9.7823697908927275902655013049219425151495052726557066175398877653509663070308025696888105483237211219805329957641959221470262321924206567942055217076001693227509967613608059824560044439074474015571875781518596823459310157609655309060291769941594134741069936879708975942499413361259079695217345778090763878747491180088227732707943916337528429147072897206797927882457419677679260312986655033248614540432e-233"),
           e_float("3.7223344792421589422873681052497151122462610635031373528432124583357007866702264258240202375785410153217262623120200482147744024911505728928231528840668833044106112022569293570363265424139812163193778993743282391373683384042423971712944495549553362229387317213970556607038802701245337610384482727141537302672583409461174795611661040289659326239766482251180664325260098203174036385878216041485812748336e-237"),
           e_float("1.4250478800253631924802885921617225223179040027301358218027267586809371100281277186780559348598418853154898497423856674092700640651987319681312402509368618701595380067403077288897070628058822356263034360370602847410008898597896211742024851825243791491462224146399023463925938166881828383782615443389835499435714000194435028937026220847137962318831971283823498228278889909265621632821673666319764517043e-241"),
           e_float("5.4871904512458327771312330970319326893700674157536280191655595407691771894865748470221318423579251452328740558925476946923302965078448811378841726462340961061920679164485122212936537143141832335778290525443308325006347045356251376626286455427110651229466748716702509682213995290799526136871332144704248391261541423392609660983124581903628672489989443530816576963681529856495420247158870404966900296884e-246"),
           e_float("2.1244676614927185340003312328622591490754133156167535985397589330741163287713465585884681034979111345404402902468522656836147490297503365355385233710568004505613511362298670604659495009830141578132717382302637503932837419352038393108114561100157173915409324365247524470937080305833670405710109154938347638074735231391723394072425460882752949464751807352781350035586699216810680038193045147665636941097e-250"),
           e_float("8.2682039307409291403523738454077116756633100499724914645111821908268688512610916573157997931115084766577680851990974574318813009677360357591858516476179244325833615468064963388408708879977971652339307658390003266654241039712542816089696844703390928132951328992266485345363737327174731516620814405291908836812268127602666695541481087333892333331208495439682619438456557484418504521420112195086562293177e-255"),
           e_float("3.2338689325101700959013124400896000551115735504200567111318312282761268016894907641339760913933747871231499543394443070342947487948240040275866731379899163880025280478869693335440915244189688087475700908643632809602990708548361069367794821542267796035177436988237739733947155645376503084570015190189847797953507321200001821088366208172265252654461462259021172030518615495046152207098227502803982662478e-259"),
           e_float("1.2708087049078933406801294909993776265579502133498698182166664184642633592186118090643365339880801722807041195724234856420101992443366529808300656325557456568850148640227092798162972217137541043565987247968998797401708069746508669177636259728054085622131534700428322314152405155231063717289019386783461507685787923393522360641251758798869324418748512920870722670550651787978559753253189240680170137382e-263"),
           e_float("5.0163450991557673586347003718231905835763480492452369332874433103942132164259634650501603222324181601705349128962926329608562538584309270506341639714438468376531238767865714321376593297458295239893022309752307440301714510271205301546751118963740092701438928657090120398464030086157489781229279051377743400381873770607677383898137151453194153463451949324031305473844591296240527156614136379460070004682e-268"),
           e_float("1.9886258240548501684673553997808161601044977302562162548307681577210112807277069138345366139589380846601606906294303260956524743762189145795476947835961102933855256835250777174582364031988044032843608171419949684237717413021172691693668703042872948102923087792955094175893053870285182378838057371308072216390175909000734196282895147516084385305456758929011752358555272693143466322961195479395159862189e-272"),
           e_float("7.9157444807706215080670145532232386375146645896766825312102291639674062883196532483725523064937854428816123394949302181957262534009818297241647042813014839065219816893166791894268544317763668376949567127274796844575151344175052044626924863632027541729013554547103521771435591703328847557705022785746141474749644283431341222673107117668576314066844048871675187796359325827889209279928286323273062812174e-277"),
           e_float("3.1631750949256458830765960074697174830030133809152403595966268279598845459798207292369459483851229583838752673162032526241115322753933713267287130873239425088697512475783242426304216516399988861971883292714413275789289385719013406770600771355248959514572535473171641578560709570094155802255781518429600595698944501692785768105350138453045514282984166284578861110915318712763825120827039886399159696445e-281"),
           e_float("1.2687381768245832195853701466900980360907367455227884346225004882495136620394328636213992516088619989540605428403304968580839009192772352873778671115398403504217904053942938668064069629363642086174352179014039086184118166648955205081492973319636686336223250721514276535961193054651244261404070634782046695505715467699605622849814394220311707645909551756437447400624277422619123761344920687360539422779e-285"),
           e_float("5.1070141749384401841861162309184341005368955022866327843164339307440943504424699924364589006227756159656265434561591675551007047755947573467921996370723643705599952603323291013240315651415395862115385840872638329770466556405195648282920756866728828353448463658267778846498322595809683017547126177303511563312322193301338042059033823088033311081582329920529036783993721011389982316698570098136880769363e-290"),
           e_float("2.0627257048206985123865655096929245583199057470173574635952983360188809705054568327656434394932071925314751091718977525335415849849928544309522224608437031920503095371605775452035010667353901257001092372089656762846414643489261124483528536568046935478344493776218474825579826344786420445465387032037766010040452107029632483524267707817487189779674792853021260619734432363444946461887846280689793070855e-294"),
           e_float("8.3585734306089477493888116147586518031742951203163410126241194725780801651658397649237615050809164322527462822969923885452904817023945682137571070052818048404386976716698714155752564624790523895665551450243557185272374308807710171497089905600627079308430867034357370371109705694774319041613649040252980839560838075090931387693825864243745249120276670805233552120510934115793195404525093959087772699544e-299"),
           e_float("3.3976572065701035232645297297569879094881792506964152037711767522407440950486011519737077916423829508982587318145242040433202602602344994465902526062622077627561966142538288101426511950186422985636142472871726907853587321468964746571700110836273329209688907770980548172361192261888392842492388520220135268049208394373448767056451714030510068720075637997827829870420496123850755784940328596341131736059e-303"),
           e_float("1.3852476808944619796764266757030608926282085147234243764122739639259481553614991621818151577067378734433498523139934202895310760713242611546941049376888144938510956762796518119713205659076750258461893302866582580060907169783220220693948236188577059658003914648287933880899232506284170375602300023960495885430191778890615896530308156489341438590267754361439561320753318086277635121471491561705795145115e-307"),
           e_float("5.6639917375439354956028894116114392577239949319229624703927679053305007570714066823633976762592885596155554051403764520433720567703643746260874730778378179666135991367709634458292106579428054472216148792544252183658609134058428254498549830565982413332105613049293634736288903614020564148403264485427706880388394009819399843070007190210364198433389350369282223522273337657756606809524994522137456197089e-312"),
           e_float("2.3222811829702855978161074057226511810704338106060064314336670834353918998810265589703151037373497080838738857553001690579261077790032481009764946155969635225408366407572327482914568282536790237108313793999328647711215246527197322144510615599867964628453780025033294895726285921522568968501048175751182901284960616316604198386086301057803046040727585335958051587803374286033769795356141728218444232761e-316"),
           e_float("9.5467685002641474997530871367232608988145250567004887828858602670691764510361852560961506010912006813847819777516721892200243908371071093545739488562114575941883476500921802175404799332151525350626481025936781479574578260711212601925280203673477111636256218138979707783920861759520576820704303738438196826846461101633057884951530551088781141695551527505817720525193260118256138723586600788960151481253e-321"),
           e_float("3.9346151731142122273603734505999019590831310854992384410825717161277705885119905507349518741455735582489806345017524144590010580367229583179858828104011791776561134921034964294229911536905840015548871097644612642034421018844277013733366834264847369406200327964837269315593799861200273381037443337335794948114253696681157730252809535094192391019930966707709195674298187272870818296780877117388258143368e-325"),
           e_float("1.6255848479875546646251075364571830677544184415452746217157111746342542248956096069064277589465485372490013924618419387841871227321492260929127694873321745562205840110179077649887129701536641064776648719446149083274297872611326774622248598971479419065063103933621927158739245336843733801475619180061827784548908492136456095955221982471604227532329281558836900988423576848897482643051222718714502593813e-329"),
           e_float("6.731904541241259284546304340484687155147157786549619210837008417469363077606283598149041549670511079399799244459828059197341578157965230014604108936367516259407854984218274536991621773596265321404219568665327129546927916392613067739007585654812520870556688696537797753634135533428137514006136079469438084884706336322786754640867410182336859124102302283406011672146058342735019068293496611683592415234e-334"),
           e_float("2.7941431391977353146167776504009842624713828671376247207906285655603920339337518032235002069342832778012351445101852020607867913585533719094620119777976153557909226588296031139680410678399286849933579737715272435429483455971508055281460578839417388337462830079305125165096037440934862895064215370384984203339399115065921213362093757750881821953069788383323831196805965592315125932205824776248034063164e-338"),
           e_float("1.1622649453723505613558714577676321340452601397992446748695418938234849512450282934779861978150203670478673310136855258064080140852406142142209490645311716713203466405617337451804454969220533278444454868356757564571069201802034491611452677921820646031445873136310545813598796673332681216630750436418334327034839769162638923766988468236697408378874589095377700835687239946306271225748268883108496076582e-342"),
           e_float("4.8447638506739496282616427124570379657282737381035347299979020121013052523636014002457557273929574395303339340324325313445269828728450826921348154472835251064927207536353204910251924976756379491321463222698745187963405118592745409652312488996513510706418140434381904289153789124619491733248130056291131263080839742229710038066286430268316814692422838168383573441903976425821347424340740783252773375721e-347"),
           e_float("2.0235687475416183019685096870750447769855432314371180099463461564473755030973595821450826118017306006764054098070526026940813892056118220846456266466686237321754999234237694572519343897982532336840714778282069212534754517861224178989998188906145702570623657641609985827022562592773964626942946064818996539725496256202019971928933387435265615845568952712230754143706682050169714527958705401256323775786e-351"),
           e_float("8.4685620845371376745739504101894727614343815354397824585848168692717528509932285003651447761106929442643303791538868407888753719871798111939921670592501872716421647074530463377743750234151377322521943121196800590755262069226349041912934139179174254956921306478614269695811214733631872779866200188133756160374634209637034310958990444226850185753814241814566852044223914809201103571084118501721129426036e-356"),
           e_float("3.5507306829397245439003891306885244788003483995037296205030404009741019453833246099766371425044410091716154195892483801517291323942837984974848224711550966452805734480992666840536394016657731625918541097721805773517651541992642817169503730735616239643724962354904432737542370500094350967227234201608221301878296532434908484784334524225308676261550752351233546433903314644138921448685651777298431484429e-360"),
           e_float("1.4914665866152308069899233752267485202468051664566356455586234210470685921924056655498011129941975373907698562548691438585418549958444242835444485736038001850061590273729876173715415145203540327768278464916448787592323963409894589596021363521978019694721649370078998342459283857390410091589408106109860574944690256145125949302217903221484807013654479089417439258851678920425630892198885431677113304052e-364"),
           e_float("6.2758099388722786268528936262726674966210814395964331129099159706492170743144917817161560747669685053152672101440746753883445217351921296830395321996865588114031909765055580241960848842275738561105141147360559793799504568974977730457370513556751707101973979186116931383740288685219210490962877299281499874819418120495714128936211664043500044581334117314132294881601622986696036996733138989407126234665e-369"),
           e_float("2.645211906575706786621299466369145112810212142333418688978034970421904200421316470160313290867846451169796082435633605912091514917185653825667663706591706044862996190371624241816044163610084229995922890820018791668992228517307315417612324444758532018653142946926322494426433782379818926885266894879866668600566746154039266897342721323196549422634818809660062794402598061747703941147520138524840138073e-373"),
           e_float("1.1167622897852881811876090530014760178429092284697708929639428002473767587262317494717853239362148994195979262837575185956216167440528360545207861039407189106987264452391635386934622675399148903623581118688225709099205033414558786507125360204301309946894234314362609103805208112188356793610129761574733042670380144891398700750614851938527836063140529471078349228051756829111540763097802819471644897843e-377"),
           e_float("4.7222270582461356425763535842557164057093234724313290766688107530844046627373116098303260544669891481736495194933737840344490631055443562355948657067037986164685648534459674317971963052587880114601963955135144129652329271606723778116104416188154163543059472912260747329213396820257673131687647874778834985657049372603026174235744316262848358373859103563707382241060773588980271073462033685689031470797e-382"),
           e_float("1.9998442044429925905970375356875337017903275550434264746446341322767334516915233700546695453397237986473453284134124341291570323073752458664285355734058807097239399697861966948290252914469049815282426774715263458691251623254849049880052647677697114549206035486173972330938451045325347297987566712342514032811423247777940074577409561413348623794068253168034848881559842395824868716944804734076671041478e-386"),
           e_float("8.4817789675060897387532241606908688870093644060880253155530626076383689268418066982381246621908205945050849003744377502926006188249729544738569548794879980481146707285079311443712970007030798891252864983688354943582212355672497267948946903971873959729587758622217979649888420590671700408499301390061924102891073134656611569120162369830494063369735246871563682273867041395863488940855377233664904215666e-391"),
           e_float("3.6024543134202059461590532975664215275670132411694268176664541401792880228427373202323494387648375264565981531566924122198317600034379031545268547016458493665713875417861025524916065681424907193301789023960871682569669063573210622885354105364948311417109154280919926645430229142948946501538449015794274900341024322797748454565321111466610958698992784319002207908663809350695245018786089654884232933362e-395"),
           e_float("1.5321839289476272894498849306397696539476491366852122959293133945250604321154576790953052792403340535660932666517422871617525012263535511294715326249852175380821781895610699629839855011338949878810144279409178209481032897210976995611946447650087727662250833613281770777949053065793948694793790795065507533843521078118756696178034775287596868350920023617214622421419541931303005315315901757172864298326e-399"),
           e_float("6.5253709027397014176494043172489124029657770228672388253681082305113315519758693655106672094970446809438366281899636618377682427212930752732775561050647500674873348190101124046773340484453717903819009909308184395483420738468307176809507782688576914133003722081277961227468014332707831495826628041072704628728601328369468647482807494961787686404718976905303199833915414134492161799276622645399886842723e-404"),
           e_float("2.7826793599173188976023398791443519187032113176191828244121429728001851975322735931989722667356556559074565486743139241690032734627148825962289513778712935587066281521606068704817537811551511982672216790657519605566291927926934733881831730091133793800808097358911660184148596869107689204354528196565046252742388962554957191320664694191569375872054381881493551835987190973415755652310951553148800085427e-408"),
           e_float("1.1881392434065732819406535609766953898411989093594816132644894962310560098024005692797635665526420314167023949608175992676287639705728452004107040561095152429170035948363497873422495206687172641194807873807626854258629571462892514271863118611028494041031125419296097195807256708323427587872141857384701213681778347719118746918630021724105245558316352444851152014461952750119839274774012240572893951006e-412"),
           e_float("5.0792663272097207097181862203589384663407092514539666177575159989585291519407297162633364313213952321934804032971087150140888188432634301709460809052216298546671990652587981885414625647759489595351272933981408504446004102516423825209528399909811339397538157817184222832279875930800038698897592423468609036534878296725908767503762922799539607463635462174608824997376826382665728172635885536254581480215e-417"),
           e_float("2.1739424550103001897771908253916336701860163828092858498588755865824835381702092244802874907990740163366621853011350394733561865414900348385832609375187840679821901699589918659299489198755151526241580484045038055039012777116703796808983401441763138073540655649050185690882019113978099686517604159908432529690941921656973640309876085303108311438372120208212982958917712073109372978317884523980608073581e-421"),
           e_float("9.3152197925012677588034024324122232180481773871966313881102872395833679902331624127481589496432574519271886966888949060169979683229303256363492448621439459558277284787312463945506666651205462034673289332585727250629878274898369593196034810934381888707246026685618539142908586967572701154711153797068449499045692133769796066834162744316151219796180109031303061349652465483081989462240485506233106221824e-426"),
           e_float("3.9959622563088420679120528739691025452837427252138645848168312936114963705095630206159283945036241939702104968141797849453921086829644876923355273397351335015498741351840723491456765651565867067287548501818897186988762045013569043948081735378223497253121331939489300038181070318589967966348426718512874283700459996796888882613798727380600537020440479535790709033878844204196480728818654177776531383561e-430"),
           e_float("1.7160053815420804865734944532680235494765494744111851219900295893311476367716302501631146212354347827776530316675121257143992954384900311639096614207332060243361123559824461378194959098284062906050184197712690059825784942878657643559496676839382970161673968299998099150584660289454896656877013111427037865741161272673018142533207082848560762459234665689907824332042899815193177593103930386111460753627e-434"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00488_bessel_kv_at_v_301_3(const bool b_write_output)
    {
      return TestCase_case_00488_bessel_kv_at_v_301_3().execute(b_write_output);
    }
  }
}
