
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00482_bessel_jv_at_v_1_3 : public TestCaseReal
    {
    public:
      TestCase_case_00482_bessel_jv_at_v_1_3() { }
      virtual ~TestCase_case_00482_bessel_jv_at_v_1_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00482_bessel_jv_at_v_1_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_j(ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.69463701267854686634564870716709111963703003267699506286087123770450826000293913147644780481484904407130157870490871602028775059459225545596878206673131693027088806417068316205830127804591955786190026060114179172701381254451730130316104179611246922743569585967336714944035650605649577129462533055057929602165931106433055065148811505120389238782312499367144597500609464087588030259352356998251247879595"),
           e_float("-0.24200228615935334500833893048103419093570868328453366417484843671771797111293366647103129634065014482317077137921636156262001121477172821331929594699725425658907641879479287579090504966055115066094172039124268875340928106568830116146816220708231168393231398998599217110739781141799191330894072968126185509065750193404127358431081550475688158925441336964195148419843379102573183570359845801229934726512"),
           e_float("0.16092802207938433744420585833042949277140519188832042613058635100368611927616146422522301817038661778767064153467159095714439719989377627476960342217302653976589096338255211401587644775815568097810484003963888710366560064258545106348167324717444661227209564240551997902797374766755059027434765304697184422372837399943820090758138058183675099818823735159464579853690471125430634547733896883471616448711"),
           e_float("-0.078973499049913969341358033816665183777594392866433551786877328092475329298351704928278242094939274599031876938220123066599656818399816381164095178702334032394488435236939142176078512932051873958847551333693831754360168398384445679460600392770073774411860360590135651104496092456657613253143619413325097335954460663868720432871304837424712616935990312632793784511973425404003731611569379563854093006156"),
           e_float("0.00042590207825414008391638460127749634324503176314473732625158007087242797471439880216227180660491169423131061907344821932718116088052692953007147992877299733746234627492876491222653521768103503704440558413191136094927022239815769709559342761241408021814277827093780773075556755166536039107487238396328562446234055376871177966827473921816509655777163289385087954859775436848740304869186498734303426014854"),
           e_float("0.060745539013148293456438691891492445066950591489373987691297432190759963720401089297159326661906574477461875559776235290294326134753961851057685695228870622192636861041377014448794454367174488644667977272885937723197231143878677588232882788353568828663301829797830856835299117231361393829971173836057533791320280808029846022211630528461349872378081003570244808217281624915571862278035684651491965654599"),
           e_float("-0.093470261287586434670238205046039043793494170105391169271580624447613868301548358481789146669872941176369531192443891981676289654836621976486901550814470614864629532624275163963328535722709254251469944369019156644865159566646171499472323466567782395313751905491937930616684675104993353692050066876506851660001422620973636744688304948295559647941038802933878677874475443781004015267985203358683208611016"),
           e_float("0.093876153273575859764974903683099123842126237143182838289502947867176247943222394824876771156154210778395826421469030533139406488705288950577204378600654531024359669179477038697934668637113870345818845647062061170053223552864447051058761031430637191467904904936426672316540951725763600499469311772233674012910526480571649404241301129386834519414001539873167676925829905924772090291927675344254793013247"),
           e_float("-0.066380884622090984954541876649605632848425824271131594497793455098279536480646382133307080233881061696132457825345824427383546182942250908127679161946635288249511272260097168399192994268075093308165826816163901447471176425341341479300904152825071552557223543586156680961002023783649029614015944257374050363034969803248637137874555063068211139108835244201839663248267158056692421059664318350949535388511"),
           e_float("0.02219499374214308320228433941622187340043385004897912068484150023374760271338633651087671645820245520681565798149906137593011195250293025726698799306616649145303919560558500451971458494530961866770578886660462857700748355618676821087187794689538532219815012534330205665713889833847515478517775191427650674675140374833534238601234689203921891238953350395884206078924173572872332902707448849288674146328"),
           e_float("0.024069999470540108452006527015124020857160854489157076936269169842279235760749040926090706663258146156024535422249937423846482294101855559343965303612168781448396786261973614027527577344221205357577694996260820731627593428462626246063068626107893396344491041742958330620536545801983907972190800540152578965255222626795967287193394331385660875439133728987172327509896506275969557227664096835776922543782"),
           e_float("-0.058608422970029782392397790811010040559550876333705871692361279868955260486881346727416372400756302650178748514061909686582829727410109043853865568787257195655651004469870658296973513352870286710277109965700650530590832972043656282186295531627099044031371941806258449972612502652874805211669648261429607848638372883906113846407099132168868415912687777272938170330152447743633496833827073246445195837051"),
           e_float("0.072199424040743930501222627372794528526898413379860461862241509343773089006219804713566897688669285699146526258819208335064489612433202475789945589706681201545122751460809242382981429307304338671975407947255635558129909959069037521013010929568596971872153314105001352026913470506421449691123621816398819977928778940941269861447649786680622055636583078498194292424922122817946586680685035349553077894231"),
           e_float("-0.06249187182783752737373388565798508988184336288357166097452420183278851728942184836786748169879029813304360628490503465465281849842217166093908412454258066359165564813745953316534133275950178201944394379818002815031484850952892542178497966799088525061425055861914764155314499829160524629178075774172550381675888332563576364950799972581963651438570367130538504339296338217619267483900202322986129849918"),
           e_float("0.034202421962896928511297087218115068162413833934154345135572019211017208901295868396065653304928449134117395437835421800615625274685513694135854091951233307202929010809440972683153025446431576556825298993662988313493973952923651730259890205726400206469482879907002683261437128175278467452422121361869425314097138001308380143572632516367741373908905634619614830723880893125531776238967088865997246074951"),
           e_float("0.0027370365448506016057320508029412119546081092096756148912096138006354227306596677124965549369386999416052346277323408127364318443557593057859051827206230996405381438722494570330842169024215750493641067826752554943043426455455139355375663078434172300060203884629371897552501379841989558063348945269898859828250528466305023379709731221343189293464870531259239387958371257764776111460960792110050220864891"),
           e_float("-0.036449179784799230119425721248690523800068164506719529946930951205963962052568439467273710248730518622697275123905331480095740182010244378931763647922262950255579125580868733500757611786776105472410947994067623127692140448259070757497272814646812498340282330566108250699528883289097952741884574264668968902828815643490572732331579921814652997407121364088225806781183910902419746992575058097254444182274"),
           e_float("0.056774170048158186700198121623625346790092466211724286114319047073829518893597514350145038948375531276222071694673893066474193662640893047843040650352456218179272852854754299250458790389789460248891181136143657793028556786932741762011135843473544303006355496885344778600134195281255283958767268737177878929325021083494259738774773793448027342282908164658201079116883446095501333245595799700560608538054"),
           e_float("-0.058226567528711777057093438738675821687659852575503853701635716258206788791435269281428341075870205871085878705914890613084861236626716442784854447049311709520815714831496184532954527805496624789181266511746569743353502862206868341714574197272716964149150226494106890343886522932493732688495254444253249383217635288713479157558801958276774689191470859207903577328948358187254874868092513235625754991448"),
           e_float("0.041400521884631342470426496651528742706251323787289844981859889858529759394003287813068288873858096362127856091501280204513223727523979335662305030506961846540620592580045779668621156055145931218011510814100643406414055438719569258632878497204310555639730562131842269932300725765011403828515951682674945491749332934205732729217932809743083016304842476600622483872589249627716785558082907387785156853001"),
           e_float("-0.012473771822162045252531827855503598699892359908052672472013963750974920499481063618716357220831501794737466082089124535821884333097283128029168787318406831128447746413784393593310910527030202408581668766679664529774891958655270737794364318245924089608774581398718746022775058360965273630895966441595410196361332930392915069324280828407988747245443352794440546935025107251147092616747574011567634819465"),
           e_float("-0.018955893778713147178720650599275098900984992807362421189260025098262366840294103741192829817314891797436525460192478531876459833108524183486374642445570779258996557917900803197064600705274725721302569825392235169983929624484868109008014266402401925584244203740860967869286916892559525207306973643677461332976257067724936680990782129919317586718462650448895528907738779309841071989049510330653736072192"),
           e_float("0.042975715031049621383522138537669206343384627041284170141841878770996935486679425340809456490312575810804256233739517312890730039004850705495353273673195103972934757411097518076850966745603804017417112905022621123059151160129959129915954656863661385518085118426578111998803518612495518539514760314502846704286006998740575775615361626547576003397531337526660360643776316592848425293663294759601790418495"),
           e_float("-0.052422346203594404859249476920607951226562119091684227292163924085315320456663855507047749566857333234534485250255085413581064171034131600667441776192495291052869391512514252869931293912192685321694338724087399809049879277354353402964294254305782316845177277376602674375559141365374781812884524738961150475906137851024863036918487115901688437761607564318696045108841148941557226958288770305240108881303"),
           e_float("0.044973098641710786340076047665864226388028810224227790439879178712647761131865151438522528031857607286099179806823512658883949980476332495138355811902356245302679143017294122167885631597130930026049018595267925115025287757748911937079020998906555888200210322888339962431617587323226490752272425775921578966270892649334032209453338604900754652363434277743223196028931685973575686162455067080175277126925"),
           e_float("-0.023662671076526120111592214203658544928072652403477463386542520460608565145459625598101868722175099731162906506315727036297763907820693667573089466609043956997114900711477926879491672176679512908151067391113128319787465804939188966628759852530093335922412043439887081908695401813579257216752516392730991844835109251123670109767297784147468613711951878778286638830400329925327600933920241790143380529596"),
           e_float("-0.0042730493737763856915361893658096753600690407882583081641266489262832301849966671884762111823744365464562291624243767688703242219045452972970305055952465033871529623597888952019460268088060009738185964280258803585401724417764262928514120301132229812522215336682245243697710909645044024711099710788065980565449247869201813388203157890905017182536039730377191293806015704297869557418801494532021871752605"),
           e_float("0.02980831373658065145433678080449952584117995636145325902851024020702461860981630385898575103612808021001912314160128252483459057325369083866277130736851355289412169006880365005771369246487992953368385531338989233228720437716106666037224489218743401637953204790766745922113676178435434910277498771341301461280760932861837788699480792227746816211264591123392351800836218118470622859166060348701156898576"),
           e_float("-0.045004841402232703851345571838798890037950913460578834028121780041870605296944351345036877202731354183588120412185390401669405268320851639549443826233040836495448214667157189272794518349047235307545337347231493015651233572488964018522521795187465777886760899245827357629463193190295804151851324809193439937684038341623088111845754901856197802586479815965671333883803385117410854227973004254859979244867"),
           e_float("0.045448994897919366271847654540702899177389424644459972591170866398744561276374528231067335498498749550652334970983139000559184397310625054266690685937564221757469918146018140275536609635939603822239126909041772271204599998168157946343088911706256437706995126354994768954280216977492588849924052364950585742351591276387932437181392270360011290946426181923045743364924124420209717647460342612553857733134"),
           e_float("-0.03150827454713443245785519700419138555281559299032302550988804835513808320746839943020550865928431914176412349642359950774970209812065757056001904373309380848327928000732730444541054686965001387685201496756061866962677155354763104227770302880357688599570625482715012222783143562830658676699120137254779217143316310612920558969918291780879259891795394482941960688194765927996489260043072906920804913209"),
           e_float("0.0080556636487209304168203897977612076789878585349833964682283075977963714335678739268675034596472711620019571700627754680206300183784366308589889033427566927352129662403464924751509416977976835554189367146269945355497380521255316417300956480727026960674875311199466952973977537471360742346259162055353841860851474364974034455463631527275432346557172916916331727841218576748160814401768487764730881560425"),
           e_float("0.017203594354758304212721083789666000726021952167810154008935949312565273010278447486415974571586362442193339450995969309103387012666908632162585295507947894598787682906701313950403731397872074007213262349478541061325823986103151925768715843470847621431812754883069538879834751691679930959810468074821698420737348175231852267271940790849490826877520262490927417144583635768608258526286426545596071882047"),
           e_float("-0.036238116516493979515418866501948612650716710523198914266394274997915104904336456551428215172578384571668315454956216069282930167966360716415732457110388941452456015900660327529860115024827035817026730971769989533421387598286227665438247934802517408740345295798209658406998509890227106573298176129685007717440240516673867558725011409749524620054519378630728990252782821360194848885444901972799851442999"),
           e_float("0.043222226332812702164367904176752625109800991632577819743312018632790670656479660906148246957383831087288954974046381012107495623894438435933059852319615827466199434116344064148398994383610572512654412481623658566641328647007042525960775441615273089895200080576138133754434823329143427139356917012803911428363176129054876859212828337057348577698240974550456794731634702453301540827248311562719772762108"),
           e_float("-0.036301568160882130239029657406151419851835373047387004172863879869661046792269362597776416461894150122257252667561342813120416758911989468144426829421373421524380194986119742386758341352638975306279024795192115946223049189410495437807174378742584274885629834563485004676414285468763633289099018083912849720150091462156547183473071742799066871924353659370570775851240643485871071114577450716290792941358"),
           e_float("0.01806189306680437759045831811322405149217427563430639940502073868260142756233141931831126571275057484123208912040169910149281776026498098481035143660685621915690249087727354770301920348212231605368271004955766462170367935861625164136920305484546922206101269521868477736098888148560704495933957303884278540582935207746310239918725502789140251214725505516133221957002950782340463051976885718081920628203"),
           e_float("0.0054098004187547713474944543352607088957639899035351605861564082663821740200822372230369083721467085325021951054321462812340759909253632514544394483406565654578270634675343792207565594963982690841482240098954420843635714328767915011293805160554508473726221642798811313159408693170379970694689480418816900631836138726692871066308369935793828086305192693468425474133616490856545087537967107948780904749819"),
           e_float("-0.026539211672794147457352193813088571011556216077250106930383776660982464991482972559163018664645272854692378535524329003664482621300670697880878561375523380776120645860806559640524486414086757457754978408623838892515220586109791546406814967904242840843924428471595968480149436712837515881141873026242303533620236060191076848139791161440000618537162342606692338236746780226374620703244044235768724662887"),
           e_float("0.038693143464319526842534766714966383951897575292734704733546857009613777275554343298598730915345143460151651481949042801176831701337183704597225000002909072252023422141140466711785078029456975557482303723165560586201400936456612745490138059773848257069258258066675220726935907429480961164620826305374595589899957281906619370638460628702890830637925540818502184383014048453642109546539232879743569402515"),
           e_float("-0.038248623234838637825946199955338425284311717609836923945863838236402094827265116480022398084110415070253338541144949292597917627227468228655331205268756770515675977055285111398252903441841598260775992622914918084485961777715232215066069145156876682644359813275501869285955998005760991498386123771970421531272428643919765743071369509515954342173385762677382978981825322910322127921923632270430509725931"),
           e_float("0.025661033251419757906076882958719357833937175764730139043455118406578440726994211706892095490731126254759512552254342236697539487243304616952239658703633189478565186067094529165370856369118022757745816281335959717836902283952172492211704225652459689666120286376292232341272888102201039587552663238116038490746749271765291201580257529061844696570679232863660352653957638200882880114219384302265826696474"),
           e_float("-0.005219631169465873284207411491855670075043288757048941188579924979173618936568693338073332056810326263706009133415108732756263890634527829192443099314891807940040811750040700841781317906991806925424859434187891901753985350334947918829826628184567519454697530455100937373114261565922881633222074653258691903688802133582764781208615765210303701406072967920848908822031045330250702292313419184610029931716"),
           e_float("-0.016401020751462059826927796516487156893976790469639501825952675873582613614776858470515820977776834145492708077427862166518741460077200615381263838298531022962933871016392239370623620190241698627936276498330008625635504556173652347450132270345950132367604087141308539555217026554729269341016357803079700464186814687034968531359586016380299275996607252061974496254637650265737934607240478686968834523779"),
           e_float("0.032308823615916011494810783293434896648925583945484378474699523321171819392880480895624244208142909095450885487211646050144348044665230835948529409055834295217152945546569735679632912332046557766372904257261662560200249796255915175502602274699718191276635441347665202900864345249373023162056555839633582426372030285645935778095485442773608036748540184710035137621542309107907722870416796562501774022308"),
           e_float("-0.037580776543782692821079764818391518997994370307963367932069815959565848677349101826433918638250268785383525388782657583677309434411359896579757685535469419315950103334738866535958637533898327745050223287603447605519617184822305240969497696510878162749717516677853605245530027876477455138547110415337789739435885900365493547116802669914390728689839612897988681399747735551158430652737176967202169204188"),
           e_float("0.030777830950993546620226663888518290730243934078466166124189924851511324752671305020487593868292247937143976972555328320384576630624685406031709871347569185544316873550824276949574868520496161947442226059807393340239066913316707918535407417381148513510450792097504997165503519189503122731617261452495938644625684639860726455693188858180015869640609387125551656495335835043547781192703015897035039530003"),
           e_float("-0.014324264690345438748119591184203014136435304714759870544752081878656143047147012847024510519508628064151129570900361999356176512259960525900346030986614749682946424109162306928786993692209410189914561882236367523632213853013890219570407760054068470925948870659510827667852106371919938816877297658441302370610300598869503702577302748770240811887573432231734113621350133453574379943922961285581572912416"),
           e_float("-0.0063438818116017294796605492044924829661318085797812804550297629598608308754994481506305931790105683066911196610912506862630954857037778211611024461620064908959206080784360711082542026003034359557291857302471577284507768255650141367905580998682011887516733740691670917941199959505512728221460819394073111664754244288862784990337771570092690719323169275083927023220825818339064793745466392650725062160427"),
           e_float("0.024566092800393007905105578257439841037765877336129646147074817778668001855052617980723935284632653590858398938806032142682804748530336367553488334792867935109909384485022205631284140238576820754151957644666171827298886143396714849564772484607353010386780639334589732601098340949229764265447389567276339115890747332749640299936144515450272929668023219744551496817775036483583358238551654988931870172492"),
           e_float("-0.034595624478556035906865364934273222752985951720361814787294831743605812876341180350030651748005773210485469447060498169203922056479641666421768632347433796358483541004869538809534500684847664124902167342563950522405775096306993809199993157311668556745270426190818154690927016161116835032832425563464992594032172059039616002109892853625181789184904257763787038615719638840431885102434290307410832097321"),
           e_float("0.033404811689598941012076521725746526083262360236906757996573729753446524626538673725268854677954903609884006400826023817757765710581064770878228850148829216267334840332486903023957967801480325228211176840628422776648975166371402592328493759780809374876539152094845286292191068365343123678856563627224313468604769642810120082050086990056679897682817115966874018058772249784057667653884491003803855511121"),
           e_float("-0.021592371821368397056097363911076770341906721020449816531831113164560906202236726223781308061736829909088495768879599100248749884902157725725739370317221656775063316234624692509256702874278906835781891026829546547962624763794124973591047095799199264068666254999212041541494762999411186130484475496388603556866626881671318177122901215687221419244305775365761413076821646495586160744487772894708706187114"),
           e_float("0.0031227681895004503745243841685148584085951487507491581669190300983094182930484682455175151889128737056248470407916042361073677695439784163125622918182292993206512923823831311685880471704724455758911468610444685855109827575305091827235755915538631713049191973104575492887495032239679499737830505598858664882078374022592166007582973393539629091193671950616471085348931509068489822237311144880790781433302"),
           e_float("0.015997426788249461467511462205143128750304539257517578582249734054014133825519289385676593708507041480834961505901761923851489780594903011572869239510183100455750970779308164131358308711229439228514741008189024088803123720173300981088173837450641099569168743933856225198255736240529087005639736189295486960099597808124571148297451195389409528944443745047311635367643590120030582250649429356638659541685"),
           e_float("-0.029666537494270803644461383940119460295261162235947776083255096692645889686139469271724817226096260288504633669424891637410702531334100751173755971987730518363496505327106155419393227098279860894932082121002714004156549448554627062955632740851051917033170693723958219594188802362951835665358249705400089530750436716323402422630488020430399086493664206120884280864304609582210365219957564118075552125349"),
           e_float("0.033629112094342573842155845453082227155823714120001270138034516974962909525268232963505477593883462529768184037621781915091326477090920842447388820777145197655280478701288582671863896109285268734914377050168745948729754568130280067897863774173355983436577694618430056620529302757939101445043281794444780993179350442594172198589810307048039215866464098873615584462167377375028340071599819907062899854118"),
           e_float("-0.02679569605957298180040537992967179806397191957599796073516609284283348337735967017473402983138690292538596696887580451697404654548385759572818122047913759909523960763115716898577103027313088157462967745388938950942994241556315322263612126892201128732419881676679347741283130838521580418499231013006222534567006900855738005184631630047864554493666752840515018582990691881152296912224919529324982809564"),
           e_float("0.011533207474645613364685752101598519790833502448960558656500391249879561414069181574984345134283261649642876406703800985013331318554553814339246040595931818368715779916093799555661853634355691889229783844643588538694570147202338569512952539789492973962175093878463100762133285152225136329115578798688967136126998389361593226433150105122604572778663490996858745762492255592161252249869311628012858561583"),
           e_float("0.0071482790617689004469050897544517890630223793056900043828447482274185995017544594292777944280664585446661136296350443162019849671858107545930266213212051199899493861801411954690875663130807170977068579148410980033236011172214537397032121371612479058873792037971628441942340363927690981092670384763706103123823093903535715376133902101494914905370561120167489720342383007571146983498235583228569105114231"),
           e_float("-0.023235075557431085379251631275554140748583519730286811208182179398734815612304976124965655793578124557550397789385594380511236887217209017719682577598599686023994612246984539512286394573664025872003328748535097090417836589129058872539295821431898326502544554680909451434444196258136663007403008253317933271106931611826525594982720253165111924708810180850174266003083858945459562401542697401122571237818"),
           e_float("0.031640880315651572737506555083593737903920982602352606850191005399835605559398823424527655129829341553141704588944441105804312589859224363302337149568339850431906465014166093033548801821481315425179882022249876073876815979969061586436301530561434837386618734304657225378332200651171590061691512921293253704142349828175517297482335232239263644515119394995519973037495064307595505093595860920069634132489"),
           e_float("-0.029810712876601304892673807393593311822188217413647271808552327334690330476198177775343194389966701914034179566439318392333847015439159908041342544290575347416734862519907118029066799831534443479901228587318087489651181243489604364241200586417434054014309286551232318439805051197299929492888114731637048013405388986987377180442977257067850209312017173714666588727658206585663585107945188251962281796755"),
           e_float("0.018493263940592517725135042960607193979895071808799017518346995969111285226428900807728289771306880795345725816688380618415281454436558817447329447316572373693089917451448860511287431109301063894803346941494402191252382015944950503173426605879315423518531682239055658061682240662256412245532928448336352145576632960564692060788100407763661554158891642180492567646851011324186546930978029330400797231674"),
           e_float("-0.001449468653915741731093338722522593886014354332472923282747471292818278851713099138668498360644067014135054449309758983959631759684902008156636117162470772172469710960860986357687591563335978709170107882715998668749182486959928759686527236188006051851228112534261161999313038222053007394763671656741166584731309006862584645152544648348724900833465457373043533104191102680860796042356743485894242632836"),
           e_float("-0.015793137984743072323828092706928557934976654644430373341352450636117399636561981536969880812710998311723152421887335537781554685734960270552738395344626648962636409923932771009302290937274274200788151430821635095767649787916984327592001876986704044830139987522357969307670731182760835253991871835233396807295840013389616799945318566648179862605782430933050574177026462673705374568880672082660446363863"),
           e_float("0.027729102411215154038604680415898384394015304052081713122317389580246875406484640750593303244070630918387018995317627712976128991940905338625467835514431518748778579037456504474070881641841293866270768098230468469724266875196311118039613241044120221381321071892750268607389723455870268888851034245633338272617382497740716758683083935173123766104367000130087100732771046601984215806565252497846738970146"),
           e_float("-0.030629244335844872483516282527665868502261947190785894380488321210543805606567483200788778141056018211009569095192090138525480817796987089443996251809454483024768987464078103408972225822440588701549598376457236899190276071325971417252877410184982472951163365578548864581647088379411577500449125609624328564864253456049187757220092678828818028047276652088766475855385334792317283888395343452213801839871"),
           e_float("0.023702553622083029753933835327861505985243829512209906554379028912239210999136625609813425996591613048756836498868223255551993200836700496322487471678197408588849249476118530744551452451949937722053161109884769146134736448084761681467467670723952249443072477192581732218029041832781851064947678587011981637698414949860921212025616766737735697275836703708427850024185966831221836560199223050275429834143"),
           e_float("-0.0093047403184138099088955694198603523447248797147479869216306343161751852301673638089432007860831191019008460684658578391722239848844597884601247038311175977400519330562991601116038448937617118738432215156739947153603632427298217118597765900958408787568015386326439291997804035500526806519501970129657708841602950067156364099705753834877072663073132424134883004310547064675917065122689738110301393394907"),
           e_float("-0.0078589453908427563529690404236412638287612220920608275118327038334690366129748889255979980462077563106675844289374700351152428980242813309387026355345653186134047736814192966433174513519924820461193306435715520852849650088806463309946523541021032898653402929058822406991229637096092323432098827227797505935304682460030841661342564498340569196712749502053315670568106172935938353829607868525072549324229"),
           e_float("0.022268151536092819308591906991580130329966236900644020653156054112228973984631614827418575330284714350425985364135445233264649784242813962850626867575508412171504932780678281467675239021190661415031738207712456566502982840005607520492298463403457063890477846457321742534579397081890062782136766114041034179147188257803224449196228402902878474209586716449684246046726250869728821935067829986558090493725"),
           e_float("-0.029359790893615679961205023652129160587277584474016194255680566003324320245367366877599727603876054216402580746850787808162155013060971669085707231553647994156201574056234693769177981327673331750669742418318355011002962413983161062947824557345092727790333506660654331688759007169495704942559480309120370369914725476664977635817904061171590415958096541353790903236524153597333307874053251519368584200872"),
           e_float("0.026970291929876814049424156314320709781673370355411787207785574390598661050556401792185552567346945135598574076552163397193708490278085096843686005250008032520772874746149860488143553182857651482126901411594948191550108969893043528153356801633750792012196628103567335117231565194972697127278673581462416756087839551835971890652032802751988907762967239960185395037077416611806514424801811916986496910464"),
           e_float("-0.015992726668297129859166251181529620733093512197064860028763849168920533034707790424966002727036817259850101095057285526315356363752956903065783357309610017432482762543270991736002007602726769515282757532319830248099174902573838879954508783254512386369853927013349129236511492163763120223925617041890455709802041184470786313077309251478715898833572708083430303015124299322353079488025551450886744512114"),
           e_float("0.00005014108171747339219701373247806340474323559544743678107819966111496890662796083611679182837727695542556305242629024378627602202247881150718104146417463579257430575783848824726683421079871520161960354823123484118196496437069540941635715856505112665209046883307252519198347642508888498181302533722322787209344247513876503324185583058823151007331502666546055825645993994588661004571401413027172066838665"),
           e_float("0.0156974653649005287798083392230131159500008494984291383866719837534619094759684833139008590772847360415337198657997023827251179681354698943098121393493896314852950355276022007169131192275476502751008292167035263909886722723595558711052908275377220117116020078098865486703109893324844986070663173672393185261044350124092849280412289998631477220271608837982563790920690356043852783549846191918271325996"),
           e_float("-0.026220571834141669494556430707254983004178785549825764683279547297001825294465398522596629882397290712587283956322072975533653650276660156901144658676306586747320441104690726054095696615677471587644873403065672771678295860709098204175381233096117617118979788388588860018563340795594704875507277327610094859343718610124052464510404216957403026223988412494974350739433026221378919819318668919525326576977"),
           e_float("0.028224014229773993438771007620136613323380153451944686235309571590276456580513922765880774958616826957102402323395780990179653552608706484662267795878367093859314189059237621560518727804224586216997498363304556048057345057337031716848027456312010606690335459539044767480217889818494244255681382582470554942011474009042039470020068019549135891427998199567004657231843573027691569341681618122932108615828"),
           e_float("-0.021176609077592925376408325143924966311305585159912039977607998863009237078194191270697433188682283066082510398962995587033315935080014527621900355502236702698074122155160614337660254962934318570318044899776562769799593614872665578443542777107433603747958894441325147253581652197740220464715145469027854865108467581265243126954123907333463871495933261584910159648669884243976246583142843132840675775105"),
           e_float("0.0074454698961518728282668304206048965822715841917715560403033442915271611524790682488859215113705935528700340200469827146161084985828901103687227931555117531193439960117131273053656396442825811854512693276690035678375447889406905396615283777011631503216003027179745929704814274478825582423901791791093889049948691815536623486367211707012445045580766534533743141274633387689239007210567640640978980933593"),
           e_float("0.0084964796393416674468706146192103532021661946344183650255697711535688623186649697267727707754434958592764904659202363861148997843584397150053594652141281949247638956593814464995991100357734190731699288911295051094505133666817379984626188433277263750404158387648733960901556396792183422720107349915840656742557731265888455476036729331792009250820761612296542598176307057083976896435645996271463792429463"),
           e_float("-0.021525327645794031074702894651159975901264635892310542396716180388977032197289590974096329742347548148006857143981388295571129099634804771150706825318177050398170664256072357083221766827971968298092266704738817548335328722638471570726880496146168287425074936447646749214296115207882486322786675642130856188549734751779781487279927666093405286012393324725605007473461916509021685664795481159577484741977"),
           e_float("0.027510881418583835699860788722093331761523639401616361163395804682962480645625097843470987207316206166952663292863165648906018437471541433953100887423805147604197503537842640925690055018269453404340030700024884855321462704212279478877957902833818605361326010006334791038966010653403393613816213283086779271145076100313930005605005212726926587114389952025867739160720418667988612603646165520159324580617"),
           e_float("-0.02462401890217618423279279675234646343626019584088795497450404091145666774832790600213716871427832845574398864176741718239270816935341175090203420128600400914927712666503188634456662027957988360575740087809981120323067412621555671238319759044530415029625632739198101856579803856486523392484191643330859556639657209345875146564996635472901357669538141969332510840713962667903229508743192836625600378922"),
           e_float("0.013893453267868849848235842582454123276155284635927335417932884767780427765015049980881351219944397765153022031680598867968632043260210403286900886822901871022971508364086342799033756327953020785872141782517296122593016464783296950518044829624340459478437778002706810136645703357992462960673599316121991229072766570320109984942713710922341785903812435984304110984084857199231207551294615187241840776768"),
           e_float("0.0011568733570458284997776152576993283129574679533786812980366218529625684514063122604299569191405846611462298360277636315465481945066656167299836015703750765460122734673270645192426315638405455211855489883959036735885651500362124242075089418197075539714305258537971693927325722048651254501539202440339716346807724427934332931054174454682848112957601806810520781111629083860139401170389887489055301116653"),
           e_float("-0.015663152118103041549672878670035713931270810425072073963724195723478243983823044523703359640490981255339748742375399978675690415703457954647798313292846125507372612640529010872367088663029304526344273881317463204927025748139300970843892391851217024477225537800027039110161346222984714626034928493962639464302396205368698859156667056185110777225386004052729345514793795144757755919400741463515860872531"),
           e_float("0.024991658976164309217257145266355869326974045588736371337484423198246596005905719058143192729936358629986257912238406787454665079588434693918043123754143701008832175182507064560640743063146555270500349459383095203360999915559336377054392422920259215595655409770378722781132024512722317104131110893356430329054205118883261460943518550421402117837217398429725810601432397920876801245272822676794309575082"),
           e_float("-0.026217149987561589173866049731161310445719489164397272068429464826806072907796306617461735420415420917092007129271885275601806531489248277311065867472669799495399790204238486589346489405311865668429441089592182984086086608456496562800090836200255649259783122381835050998985297713477292690669755788180566932315058543190302090885795662714035039763764873555071701710593759694650182416815521086595723626252"),
           e_float("0.019038561559330516793032255474195206288484442089637485218492867763421357729184617787844852764191120659430085828680546698259959683972171757641536376205710696855475580737782015155562635962620665349348836252081942720326011192393088072830977357075049969648473030600672035763087453506149802596407135470342729070462008836309134154713516945534237621318477193949542298979735057715745524698641820874260051461266"),
           e_float("-0.0058458596930309922716161599504608240682858195245654223210970173698509674751222997802535389997887359903417293208626815385493431609138243481258034262243517311242123452103293497986743511538290866361425637616581527935629462661008567906976738590466407164878745417898435082219639227492355340327460236777306564859826621440124223389574527322006173540830010009403794657954849896743255677962092961285175384573078"),
           e_float("-0.0090738591594458623500524730718652172131600103864533382148831028382652927250053628745369050586415999104458320544244852522598300955639388859558406512021072467203681267079234087590533209103197348214256579766705792139116172408883081625757848216254144368133127066125057420083761827613875098665328562545048739262734308242107712348505910107647225394395042638490443637998671022055247873636635686028663492222024"),
           e_float("0.020927887081122400995332339382805713104306044773054861026069440543720293315548798317347994697910886306694021111534258643354315873369518428679387546492983619845627577265131697318566413261976200893774109180572762773107300143740796748915540831926770544969525067660212187238952392962983675988154295289257672588202323240622636744350745583600799611501405853708708698556118061555891896020444025383794884111099"),
           e_float("-0.025955907739277257161912614066381691260232727792985160812065958630265626593702712081279833031033383543041118948810042106957282233220906203098484231231847904054917477489668639628567231166488543258338108440712225782886931301929202072908160808105679761177721827577781365126392058977029432880960439381033347708605963715970629222062535606686706767073192369845127550783903391726861596758250111646813220704405"),
           e_float("0.022621429654697573666335810930237883371321266671006843344204314525214628667964775699046789622753264157449588246245769404516455481427366209113878709201409053560209772511827312956228282848444751059522289578374641638949150679175498955920056205473939875591092925893161115413282079813281313244409814411825688470680651788657423095334892066800602335067927956607595347208009204185543007456704950768187671800427"),
           e_float("-0.012079584769004550652162131778543073954065120779542555534798052160862295571739060475687058808678568886166427819934636699086705739042798000617748030369562866910838108125925970159693927808373989728785990131227372389282239373534523258371675441189324153599283510401453130821539011816262892791463111031514995608032300966748664678515597993334845668094200459604326496811350487228399571447471378758180564057045"),
           e_float("-0.0022205820803206126664267539385606695270582051390268999826510888580021050372474667559462201551549710966963530103232418588271447266142926228808827000233819561254032310733418597033389974122184216776677165144125050589813443736259141102873106504285295641047142036500004809332640615693500782078188337757053470487332608423975976745277881422182972805724953844334227153822370200517025628817394342082363548198224"),
           e_float("0.015663163930590323313339358481767425810058472963789114540722608275133680022707690587646171332104364614576303299867330163287439065615602929083699702278507324439431203259460909367045773004648558252968134178352180199886727820370777635636987069636146821639273251877244316966102757251072684357379152602784037336130622636192729024708244326465990423312380476184734751942862810256441175305737331172073626406567"),
           e_float("-0.02395395475561261120694686255478430126254467361185055842374115000706160620750372006358315885176396263071314258247696382959676320687583155823209304010356150059635764245753835647740418204724668158545758766263026813572528312209124596120037005154538287237860647712636317096301660067211076823961151580699067296245221570328386808857289827465568878401252880852148773423528892150239402691058654879145963843199"),
           e_float("0.02449093267574517434215284343559620969668908700555338440268405559427242836598880848200941484881671686232521308987715616510934221234030649919299807627911423751929533860807335719112469389096931891180450465456987062589152190455966678466295331861670117136536802704645972390583669934102225936136670120467475235769246936306263200212614008107883474255708261810682025204317558706724819299474609028167101776053"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00482_bessel_jv_at_v_1_3(const bool b_write_output)
    {
      return TestCase_case_00482_bessel_jv_at_v_1_3().execute(b_write_output);
    }
  }
}
