
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00481_bessel_iv_at_v_1_3 : public TestCaseReal
    {
    public:
      TestCase_case_00481_bessel_iv_at_v_1_3() { }
      virtual ~TestCase_case_00481_bessel_iv_at_v_1_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00481_bessel_iv_at_v_1_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_i(ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.78711391165616095508418963452523607437177012952548489729889299162803892855948041073684141317394757778620487303516710341711882807549223893205415961921209103361912114470639873924957654879136957488956227666130183830761793232516979979807639755733034745863695472433879481289773297205414041697770130822696577607242119861632414846706322444390318730372851351145482364911117780261784405019027293340597726905461"),
           e_float("4845.6533187456259099807647506822158586743581255886024304269372748350420301602225127031695122704542823213549315211004226157856709501520656360732124823579092197763403381381005116190846136410007415855814852341480318838544802635893489876310261740152651377948892246917489107331308760529994284287619826598475378985392762735839300002132621923356459144239215637336951377072254718568136451955123635074498854222"),
           e_float("7.6259012225304011066461376024096927554844021270008904731798612932905307799818496305037387436431759394406308401124183103248891045057749838870284604754567798259935066692070987379209478443971609864388782974167588715715389277776666341032461327994687561867425785610746317299962835437310495727255616366643654350699462127126406623592495668902144514302665241217540754279970618825379497007243933598131810676654e7"),
           e_float("1.3763540460089798786569562222091881985353616541003083766369004647785640957446327025220469935509770329763095540129014980412948742695979004461321448834715648143427494784119704944020999110192666223352714857598607718503812652747868090515541405600346432121779893471152535838158979135435443127207999850872194212864965968481959850728056379106101585459327526436168719104834406473539075164824142357546518727986e12"),
           e_float("2.6301617350782642492339148132080540554226589901648489208349141339576272117397087098968054582560436683761601125452924700344776069227254517139535154521369701125231170733433190409118274771371878354113401299604992909725283403164202528831145660683436995394266411626954128940454881414221230327401749997578557364716125166209430119283279541468544642059529242443433675076248109180682271271795964600910121575444e16"),
           e_float("5.1872908728786366565396173258130420945678515266199054276117686323205201088241940412204668649903135907791613111402691206736071806326861465183838425862954294319433742453739463026617439478956356062308347719536786700730891254306565426113355761862134065982922752399386620733612781697654700735920027719794731100281819310236719041983454613515178585224022753565789017505039010692078521542842331049730878055351e20"),
           e_float("1.0437775481763269013022040564219170292767513795091201437106053993824362860691373430049760824826819605072088096692925421937593953726633097292292952171842425055050711110309646800126802549832493873642546666338224208807410590116679326966176439015587156576926990173815035643315172275816927579110429594740304878081579054378921335719938220344495135722748280723199218743180294191284668041850169488431556121281e25"),
           e_float("2.1296268461249566837433689244777861178130735703062348882741734267555415040487418569540790528206171027912004590103026105641431211960592093931032033092437932523285080891118182758055511194015641280388019915387161049701850063897701854839493425223367526446832002072298852733553641720247019048121635398979976397176062195400976733753078162939605410199831370226517126740654547474044037710546231445765314653596e29"),
           e_float("4.3895571917114630081557726847491702283763927709641312127220560676525099770383345937742477206908732537686996956491429367439321287136589471216636861551991827817358668408597639831825634395398934196491025347628141169664938177182759531235580606861934440737108786666382434391546343086808012139000607870501655180491580648493512877259689260701224359181267760076915921340048610490803667816043147375528975444419e33"),
           e_float("9.118436110029994892669198207384716642920408781184386468766121885584068691831850615755550942887729116172037989050010137851253654387053903124027700817998619572193906771624743935088464675435216904762098213430504348025606173167019441133069641617088422573467529911941010994849340117024185346366668290813188916891365470400775189076416854709841141286745779069264773818995282287686560536451728335267898904114e37"),
           e_float("1.9058617702290152482372251967790010266310805963906916731764789328421261624371036331580294220045684442659840301484072993983762547512920956294158304758376873421639381279788597540544762433702922079385804279755400147310133004375433591376285804496254833191614651847746315939139605077940937017078324784972753321767120349178014938389273738008094814169841989025728596246273359305771853777342774627498509249398e42"),
           e_float("4.0033708045903218843331611504041874387425671105098770554716621279947581206040050869446289619878899800887688780159690103089642769846239204405606954466530489181563385354405862604228095750402121240589669922752544422517945889588698416884066632183403572227812090005082715043199825955780887668058728436946764020451314568078320139913460476330506217550281420045789527431548986827115915339164338632117512479869e46"),
           e_float("8.4439959752088764257685224642495177646280856617795345626024745671581853436459724715151171146122003678852020480285530417898610741986799427384699699969874640339173475854345319409022461362054134268327100159346248864864280274344580841004941710885331271267751770386113939191650480249060433592615902776500489703574736503585099735670818409291627908336213892790251008810950816508915840814675465876198213219588e50"),
           e_float("1.7871970968617929050722404153173857077935641020281568773593487016964030625438511143766780719826357823420538229704218779168931497203585917943214555183374925017994659475725460841939581650655792013264110337522455800641490261573107523856232393345418684571596794239040053331028845530220558778708252521977547811567540525502197246491089784071915731539963146452020419796139335015028252041671294952316416269817e55"),
           e_float("3.7938219925787783179011569068128212710187586552093887719191848170388259386091079706559897521069558424238171153604197251848000522068695543843722276420237137860830396580431041915024569317708195881925596560338622854583064643102435523608748770571633958946724474263009755394878192484993518092462626930688905925216630778591838430186728895011174203048728292690024096276697728641535902017662959559779161732604e59"),
           e_float("8.0739351988255729542309844572824229677484822538924382724726412092797919261077623571486199270105618138167635514227420487443097395959319238087393160190963531436036456281107391588870069692321638947130625187595126704316234354016779031667414945057431584162231455983971880820794280127116985402853860607366652032176588942214360555268239685466818527429980926320209174985622193109816034793846261528452182811013e63"),
           e_float("1.7220874183225904089234674295501489270089054594334189389046134209808375149019283793596394495286202795646590067205785437441759883829367137467678690357279462324691649495829665350275000153552287094353071593351127708958089130276955607501258805141514800032800446981860153375751742842031105359453097304201797943928342492558325805473566969936066893954481059210086235116526210294618167254175326506554716153016e68"),
           e_float("3.680191228550209685061114052387116922164602769803139749602442526153064890922864873550597389478000564840469088911078268370949294353428470353890429231400249064746673135105553722508458195547996256395649139527799749049148938812987469134570206517302832443067750830389741902404355122646168595956930646186937307435028549938141360360117426118480954900549021272478366941645249271540226213121694346737830691863e72"),
           e_float("7.8783340564340307796069586177005177046601793782883754064098553947428474775439835845106291011281729691960930151005973085720083806241233714638454941531663475777948511708966925104217011220764301332352143116730610583036154431617318245895478645391977648600049742706519158657238949626931371726206386507729075692448890792529688841571365895838666313458594723165518771826619296855161914981485866271099278869104e76"),
           e_float("1.6891428795728581876823718259549514804926675944831394076800925814879601750326231690340395770846715049267049464511667163761719579075535108556940481554568857782802060287994852683588143126526147450039058566289138375520298357534300382724749423499223644488241698045682149618389647702920593254936640150743920152940575952364639817442896511852127259260498362853004886434461345661042806028177628953265704329271e81"),
           e_float("3.6265858685878857320649805796467699190229864383572176529578848107188093252514394808497989468085703431488145812394051311716351205168241453109628547812152334434721322735352050752722657569764322734253625007034044586309077331451205490477675787168856189705132410860964320243289352870710163989969868099461417952620499859403439051879512059650940294869006236636049427816172975149697478197089105514131594224264e85"),
           e_float("7.7959800327028811550207359453196448139829691803097098738625758297806176625082836629924055557087911822844941050982026657558703831368789467811833087836633415841711627264517239666171359438873964258751993948293012249280289171857841762581241069374161366400602225683886691000555581511092657885497502580447737122911581246154476173699511683384762282222598028798629252478031757005115698722957927764876574195187e89"),
           e_float("1.6777775467400078076797634546389156060447207663880885924203820099094886583634397300488016119568149071863204324616552774836486107650128286098489405074871462815023181434834192465559789490241961741046471696769403821790192873562727718623642231768432662610266801880468130946740146744970275167376911843078555845888849975873061599161005765207588477352051249980169153671658229698583737571878755715275235534759e94"),
           e_float("3.6144762100452994040862486685746063788621721635015502570692641980971117394933891219699045949779366237493629060075135247011074964722404511703500950418712974531841177936591328260110814642918801138195234390598659133477719182522204088415927504497437900344359134446839338322728682614871395189962929496654545603636456555102564566359411836393281044775553256806709449676240591781469045603452121862462046996595e98"),
           e_float("7.794094689555524219028265853243933335896736531242869443399099648999842960159922620704469906602988765972876031586509222492433620020241027687053672957948642674065467173705533195197315866111302570533383205653916070680865007511940473871136166980296515245308496911713022671353286044298025891788956496134361563429485920667496088508106665767318049285917928268104655072827471817102818109471052468885529193382e102"),
           e_float("1.6821391969134963450334959122566847087147054113434123407002293758850986165428528426581147736260665380398581246989396796286187730074112557749675676595261726459914884903759550727561768322501263213359773761398639995239632458504998236983326828017342134666906066091359545996349133199770753112211561252822700879799411371811336153817010316977463644590110814959134025628073086786404211832504379909471616614162e107"),
           e_float("3.6333286436452642030815442103827055223134141169160614967600319581495329798774730160563434575920212120599841775693719005405942629491608116913712295945396829048078812343237843916978634053283955044147265925852983881558236837963320757024439698361003613327370668254424930889397150497764344750566008735186998580840258426387226209675344421935574704063217415562585865836005325025751659687216890084683712960581e111"),
           e_float("7.8535826010367798568964643189687860262147258300356755803596929226688148586140368763917622330513240159033533085425426911532370744474665376129116790633118618572081193862076870394062742963139663680626194759831064303439649269987171082194868396237279472679463691915146455614211653308442628394860149483784564159741083479253055109352196929609934681786233494005399971488231732357316077027326235927842834317469e115"),
           e_float("1.6987444814205577430052635440425597455607630236192907137602926520462223755054042253440015251951889052005794395710821872394525315299767626076731451872511495787625766791752684943017154695684489100441020871494083460757729755234858270062428754503035439454369264697409841403855241030404067028872725631639201944016610077753968773426997889237752674716872561757143478861202039702871761905548180538094686736339e120"),
           e_float("3.6767541159017961613279036125558719296675137272855655507585130386286377949229124795555395297138734458815619800644154566703380722955931095186615888394857253079781750574319498051009141498301013046191163613804352436989057897304147954529749758980009641429777864252691105997905831040182340784145225569291005565722708329478738226618726956584340392930203310053268628558537921273497448348384409170488070158928e124"),
           e_float("7.9626695315885728463347945994236635019781429080545587772588766051243482960049810104760980936177866375486779769228282745032993230445053755673920431550367015047047309229523194207580782689822920781251828514471240567904025533298875222983000619620499949127735333055550117980004221585648584349253146292017508232979555339977527863693098160979723776410411452289744931837857578463508154580165857881692793025501e128"),
           e_float("1.7254147331129077663238165892411403185138781214836650139206166750808579350815194504295602594616218954139693575318174795622385472806316891770755162191882013978112137464723888655164865106627140213200462579205508101931554821637431412390941910602990848547427089006076942157634886553385416904355603910246031522767246704211447795971363401817948133694821992977655566408683547824393970524127285414246418021204e133"),
           e_float("3.7407075150313499785802756001369830594710615716824134360097073733401583871449075074354862150296521344892700696061002899509175920777927772779747376743781824440425840091805900228403673432537779317001699086159300426292058917816985849522070693466726067196223036244846653504016075505294736234513781786539898918619635885151647168658012257811996900243584616921247615830907340318246940611294169246733517500854e137"),
           e_float("8.1138240198141349728038834346125059566211903156591719993501609704045983837129573490032520898398552424101377977432721039195576644683465033811175010328070198813749133553284268060971824969847156730505330752620958305887882793826908899834739922596638449676715258732595788255501860318407479736084675379417624166879473836700238447000799251308678840059950860465836949132712488027128426870694789861474908597321e141"),
           e_float("1.760744659180913784302103380669845154199970081238153915308249593243356687792478140064839508579478574605981847494233202352740464562482493632719814905430269703911729735083134785058636983675862101724747707952687262330981633994366323297306821318208857539834407946862775651173535612123538158994261664694214883171910676416276311982913311125564526958722583460458014098682239869294836815067916088478853650044e146"),
           e_float("3.8225626944380195859970568987605787380597388297366822101810067157493892108359627408118813695680357182179819653678885393138683284160366835883694773272497644230705936472512880621365312160025082992483767547439875458820895876027430021958110766872565900223164544185732029547612948836558818478772540151481370780775063440307107657285145022966568643416019255928725658175718544093864130575141629769370860457025e150"),
           e_float("8.3021341540253048196618599218174038493405473669541907776965191487849200476121932025921436168505259692418147395405039356801846765154149757086354086800566994719299747178270263473191268653573303272616941282085173357793733681148305425454699572919483834098337720215903773293213574513433356237882209762297888982656870259740929034015221470736136950747248082128105059734330868120564373223463526639211371272669e154"),
           e_float("1.803815382139097358713760361647187327446240374089394468786397423031276810387578377596535140607530210315857101857994387114178309016575260095972893241847175002400829222619587137093804213811670618234629078963378756160798996768489414629481917886275136961530299252481872394599012385680901242767251483766049428720036965863815071606137123829846286063177630738581021749288178331836918857371432357134349629197e159"),
           e_float("3.9206017160005463163898961873995012083011106096732082327032345183687341696106903760090640076032926898258278787594675673178085649210419875802938776069740592888579461106597099284479946568252131455812697289668807078588000201273160914808493252778584347393527628376278278417047888793639689823416508816227926940107008702230235183338930887419716960788202823713729648418239549272662344336610267622078294453241e163"),
           e_float("8.5243927322069157631428978585045117767855348991018515753822333515739479820812136366695423186796037960867909884294546394390386619919255106225663359780031550675017928628182197179113871339918025566058958285846653257464996363299092361536390752323470676927176702126527472945345638713132027104978548866575200346252961752182402276982337966967575598215201729344055256881324714683350805308549803383664823859238e167"),
           e_float("1.8540296168124833838496758843407994255254523677517954695354647238663695763656591102680073770950979774421850879751270205243340285056536205129143002780022337816888184211443554860428217510316591459175010808651622499524273266495826415754770436007999186782694312597486454263446945312744461952065292725690430385263132704832258828676364321500613647522813528443800092599757651406583874399026088356520088753298e172"),
           e_float("4.0337162742597441121285498470882484769861390965792529797166067297566639193900104399051556836430476093399754363022025096302169207704034953225906523839841092147479117882095923286252741291038494023284094236458963636292884293961824670577460076264986122502446460319645783552873933396930758354899373965601341199489392740283737334003681182196711251100109183789190460345222076817370073017854851244056304648927e176"),
           e_float("8.7785536449132524124215876281674312599168795964411352545787417595260998593736780637369701981648152660957708490747000539469025812649954607389556441769929326138226284410307785249657389468334387031232943864487927863937559964501574064377619458550561483818252699131141437073419214176112766116023806418432642881042022298747399783400682132157448610847540149006545692603670245044200556940945636102383645964899e180"),
           e_float("1.9110122251141943775573106319844011997342602323768589300217226284114372343855888625344414425188628610283120981862145899448640948566912463050450969816808051499336810232571964324845157004929720637647472407632794462101037640150852317796444876661753011647095994555012635117722431515483724267900605875071787945830414592153179368770390325636526542301674790802649560590074419320287587551507849673822918698025e185"),
           e_float("4.1612249752966028158275327048686136713791680400513079434770701671906169506978242024076579656086021623136185346972329902839811075695384961023825313771414046905006758091612220462415687005130388706086211686972361186117355161295389357773557169654191457978316763956050966632885040748605617625936915101725780716498361105679565806510394077249929091406777504202868814535329278298040355763639050972426938311941e189"),
           e_float("9.0633947597400008570635027547520485929569589938398264340690461855356186378845503711141700864482891014509082028954284932122758363208193434157136573980886245259401935388861093887314065395001492642304668123844766090209111293213913881344818540694712132454130486010928230194797915675558642012420942708712825738585878639666103502726412420918109745869098059556647339050203026124179052307772851242513031968866e193"),
           e_float("1.9745477803269059835871964580893062344441381472910913761385692986472195498730154125090765165568100818289952696088087057189273332373523693159589180270304631770981668011797347008552649165324510422855131677989557500488793779380586683295344861958784462795528305165402462168481500896663648547356633597136250972050124173788115492349117328381441512924594219582212579262459734441936536847768663331289962431446e198"),
           e_float("4.3027572887096098621621568527456329966947189598970714521805649001419940534508364450502114161147804437041730152962583936965332840705902485975853564778721674555928002507841885641781932211205460730363244030456884780450752453627968663553233819674496007553151424748511694205787686665075340755613358965880868552796664994080724906650825825468217237186448222482762877949172903771136653068152775928502338274612e202"),
           e_float("9.3783015079205126816217660072125172681678510837466660428528396449519372300484289129431425293337255312410604925986378618007637562201780059943605508094120556643340666683899350634505623654852522791222201633596679093232493632449778624122383073845930972453211322628016337328809396869753205450095559791333577219148054337120637087725763057715512762553563491635863389187544901504725466263173806738714516609767e206"),
           e_float("2.0445400845051585592671475264937356054872938084451424151854621261490381262118591843586155886841174832310500826099103794818864035709094797926893191381340810088488081895693770648580372216392723173085914533660775239170256732058817690179362244279992927728473343997130995831327368096702003178700032434300933243419979078996538762792720325627128513615439949085783791070802308640782786153146720807270610392145e211"),
           e_float("4.4581776042307096289512788352932071817903423252217588648650236594989377543350110485743597957389429699413247427815528307476301104757235639804137530473048517204741380929481826686833590449926599569089661513535557176648509233179539404177504550004289528273582980381860125836213827393049848259546722031005401672321693461300796720181449852219160766052231179793600123264287526251735426548753855384737634301096e215"),
           e_float("9.7231240439468137364814380745684474430113827950991354683312173546679069380806190488166862538298627341659732503569588723476784905784897820107110270310805550415259403415186593029710305059349023748638578747526058648006177785302041252378920272164021224521449058478623081636828606085593253161313488407130906515864212896190189997171970551806988263665335461165912698676735255332833387710292042032083839199206e219"),
           e_float("2.120985237302058374061665062667117941194960791326564603619405065549489241425057950750072301262400416505939482066962952794280708099632951220592380045532900044408409721604354025815115668340188154209391797965374229221020274347470878617902649858759153257388535712532073953192187968698617895862070868628057178279658270019702433463380548033147331887670273081249341347363440915748425726283767744202158328028e224"),
           e_float("4.6275343446785755533062193208204161881340557250884164500229476765950658022401546331986866168483180373809439580206584825593315206594875236563483858859958026029743301767445099870216644384289502390610854349984529559325703046767699844098023828872302415899057428645707960853492863619191405670295291223450856413366118711931982472194999263801540876112970129618220366697480707888347153615302437691265623465829e228"),
           e_float("1.0098080904578034223233755639689679270852710873535023490623423109662024229563719844727746997518798562283498584991890520224301884066216350148150443317015705319439755852409516434370937249894376512131682526062478622106544706920090288029528033984154442457383000873807388118989538797278308770935258165131656339231250941422481263398176320831185802612063153007491363239631623391132327750376044685796815291429e233"),
           e_float("2.2039533646546065177563325921019216942718516690024014606892107570052197228008506350644585754953420022961673135455574571397212231560729322143169367351713413113303508869489481087857949346879909888263261709959983895516426412696147098474940768231059503533070406233347259967204954279132003420949986965096962159711446965492665486390838518297160890177620718115254264699185953165056269143405857914882314033185e237"),
           e_float("4.8110252616130906769000508626925292980323383023505746828906723272397358111747400986610959371967267444636223119654921474476926478385020708882781455171407213716330514630795133348452407956719532859701799333319613495059020095928105842035320669667967579145360197406823468156591674362110293724162795187069184287863268218896380304143362934527377833826288318096076328692425815701300570364148003622082112890165e241"),
           e_float("1.0503693007879469635687715767202327981226530845374489176725513690083239395710666400937753330035595665716198577303743908349638720555442633464057801283571994622308527902496565355651468529345811261009938374600907998507119581904886071650551551987035972387721826635546354147131766224134291027082349167268931471412270916398459830736444948813263067550525466062569038120419388895510129903986352502317336847846e246"),
           e_float("2.2935760538275646016708378660725481370758443591556666515844417143174742231879214323835621375367999470860452158470472949371459925429112314852626790566815355297267113278094308471953511893043084996188577237584537412591006613262142621046648904550421745414250944368698183839901291813663339785958192002800608754637596399784703047658365331901264303566892958818734274930502233450738860190028986682619005274795e250"),
           e_float("5.0089734965897047752034293677571417609388163473350571031417876465727742943673381879250995693982985056305709851473263155180199693528750448184092466435404935482146382364653335826881927673876895745587298055781627267435717299167729100679459160241207202663004532905142886093358367528843662948444869949299473092780758208258578227703150027853888999048372716437454581543870857651947015529162748015392332396634e254"),
           e_float("1.0940738023445177383398496647141209592937347681999490545293208253910565305527371017928626694768166576252334504988635617042768127551354882882887567521049685848401221051208338203701847603417167371823779900487384062947565072351408864968295746376365946632534866159323523677366097197896091555328096780116337855260738082060090899719298849965572180908070032937912315839301219531957620003114577368582357224653e259"),
           e_float("2.3900376544431822768386638050667707191295244829273699582783581289380800423159010921562038253433016452586464298272889692283885041813269019364696736455180374889703367688034743982733626172504634478482875333420115215856105911394737349388290285247037521988863826811993470401091870303456972735379429275137658482306800674847033459007440545673412778934789991370766930564120216740845494202959715141397298502499e263"),
           e_float("5.2218110001057940383171208880167394011382055530700972504436628472492995508444145496045232703659676456419328286678414989388926041766402775283131691031196990721640225711402895668561460827549391309684219152110149216578498316880997651706922779860793705780986938199766065532296095233824266233142349325665153198430191066603191742082458840999693401698203204822768965034128108266326642856413383043654420597084e267"),
           e_float("1.1410218784840095816901763034966213602075927349394405958956587857610217570693234623641463663416774713666282314850484862470902700694887415900288731971395952138579975087734978811151116367209134962101116596672922077274744184637180832632600194321735617382174112547353752494152499646573613066291194265870101055238524802932659999066740815557208606666896005869621771492589219846001256728396349417609507715051e272"),
           e_float("2.4935692668481092712937000057889714119971496247240961986206237554305877045681694535388560092417293654287640147402438307504702602838844842558385429130236820833581899949438252524618018225106187100244220223503679282051646638050967077125324495829497424799637639835027234311333033300917216449935828135932676392115278849732986614024889927006034300602168013782160165976553833339970298059513588936956774858043e276"),
           e_float("5.4500671073923346966107163600472038000287332705541523380434192023392790386741126915677440443753418947308388149342433027777133581670297330128104470201547022020780274778671263023433301596075257118242110963403721397282974657586596712824653875745363909945077660116211369935254032605552510990438459510054694736661554410335314080534233065942590567694257100785732239115504659418694905646266704110574806929249e280"),
           e_float("1.1913341624256855950411066002271917029728981257826280931445253453347701314246731734760039905998892134851206728263758364651040809678583630606509284550306804772440073561919658240988114564379353598655453989152600982177539604074636171848056099509002364477015850833094106665103936051386801802585808190868294807880669230991613795219818707883025763042594903193899668373963898636896745564454087062501537204805e285"),
           e_float("2.6044446446761862051425739118619909219492467221364812375197640985536035640498062294621164125318940108003760176097162102326011832718785587569801725854806985645141887531645919914645289192546134142712411335617093533582831497665027759180446950540728884080276273452027656889441795994237453966138826873409381607481221370128844628219270410138616484068220079706167328084452667140361295423678132772943756470274e289"),
           e_float("5.6943608168462736613262533991483942569964543606056929123084691579679697273324156638298559481139120473489484879986533084214620760097335590933428644316755280012350470726899250160568974232816120253355987254093994790894877476178025027025401726779404547633432056243590880365303357117569419789471627916858686808846101859095694329346358346712742916047314911946367918008929567077399329638114256216526857593954e293"),
           e_float("1.2451501888120945462377289236457272462153221467075532417966538804289155315854825802661292609384167164594312921685561372065747471522518545633574334825929637931990883769917346719293316694208205545770549311228719150257929828755881890175428702033789883838031965600037787043811664209669320221130876109410790410407934170127805035697610141997858006988777710464739175523321843269822485997349040560885345583752e298"),
           e_float("2.7229774937730200312885216930729917224262394163043200493750407510985592204809100747691313986060596942800225626283206904220849267564839400764324636531511321908130641748289118045998366804096362768904734697439590059886685610062979175247749185741733065558459991937566149477470735579336086872195021030817370027760029541995335371448774388432780764067746132576311000985837549819036543704904708490437570568041e302"),
           e_float("5.9553957909387064717716726994911008911463604868497960588979409552291314300021317608888061956663673500967484287459451536094505534241524242920152084147796859087252041322170931196680224939265662154138170054678288505363909101206622937623694145514771671851004267959470300767967162332404499311843769082132828258670119138341688921974184317584319516016996102552192052578382545259906854229426248172973997303973e306"),
           e_float("1.302627477484428355348104134280087902447915948806621961054538939082837018639931857679734680837792732757710213127976646002432048314182653910443657913832059170614618795010089552010886049201880242712585460829116534315957543564732194486226705868264279231060734242771659536308249379037803025867268865998622915697486007064075833837293560887299044355275969939861068220131441463569220780604442735909999436407e311"),
           e_float("2.8495198143420083993089029290685138692482822824298758218474977571345171999925488978322963755191948648258265003855734856805757240841199936623108894280376453204474560114014008163832895245641599543324740142627999063921083055938933959924593659231649402664702182992720335226114634920439905790853669666539189042176534209845166451060707127530631489164158908827809188196834153022387031374556498650535460738876e315"),
           e_float("6.2339574075524095289277972031861326093732747960363692664390167145829225131593882654390166642994978992410748439534854153286490995989253558845793846446085887586128880835112520593831346259640715115642921177863866707922233553280072894815178176949389367473214028815700787790793583804855315029675685174545375420837998765927654262246144248474214882027618463004944255937330370905466181744914108475948483632698e319"),
           e_float("1.3639410213741296752780026383878943513940995982072960860522398154578809634694641921210258217584084590910624791518525204649295297896743238059381516106411880856688792638630389827001575553666111948257873401478654226940342180423643250253714442796436244325997833673409984190227868374588004253745179486009892342082775342071773196928457025875050510421776764302510459703792966425015739561460252853973588427199e324"),
           e_float("2.9844610417787053110543438494410071485010441759223445406058605450679018172108582875627482737559566772599373055257919241678088534814618366857244079918880824288209781874571030764895285635112658969292937702849395774223515857483646477500884842094023192413294373945251705259483484091326106536930934453319270780839967570571941473692310335816151006624939345935787464786700843377711247886471844121454057828326e328"),
           e_float("6.5309113943005946742568899692254122598137047029693054454308987461045655836586449377469738123666923700489063246878815524281329799501763275941070473896329412417760412302705816787898836809145654713310515328166493230400362460979428539430413114188899719986386053227070320318708851513910290459407907538281310002371681310971738604221178545521959333564637007374275126502094153760244933169330573187899870645025e332"),
           e_float("1.4292830890392958168403307167931649626690072674910334992250692266349542431327072237763339183022495412293309345070859071927073580203873480472035044726329274398280238887511499915542206734784560683481321148501759582479780887127750206432183811676871497823973994623606598053681783853591774904818938031815240931023071722850217600792215526994762116021971236395624026958125841729676113256188931736811440835656e337"),
           e_float("3.1282278147417549910660675712915146838418809812683380989679824122659562661642941731955487585587176315662586183125750635861433873723990482869166062910801127214129339869488300931463109611369780791513475231622581595358777387683082428435394184502514764596121464123156944812109409304119382185951082759980202944087781579862245913015378284824816174043988843776498691027123911818508572523150271681245198882067e341"),
           e_float("6.8472037169337456532228983163491807192992478732005455166673384899927623879012356755918282016237480158328490894823078940738375643208717078990241936954892970264976484007693847386672962128887036900179375432477708799618006646434957845730256866859967474434530688123993431018752541230842726506878111988531541469960869416333709529411035607752990559573409879250322471506159372674724896280461630067047856909506e345"),
           e_float("1.4988632786964799026896698867191971930511358335149090470454600357277647416674097947007339320621232247342427537430953979788439744909863832672498334203753138897492222370995918025910664592160014862123156664828952048157480343811964957479684590743550425851326359078582210484427228924769018244343800031590716564555996729668782942293889932271876711298263002994020943234616174393872212628597612835508740973588e350"),
           e_float("3.2812842491136481650775016800448206616804776853297738245192099511526590438118186271408320493439724786764642529929718984140368194935408338635190460201159382945086600440789296152723152692968073041332803633647465238767884421386069304246865728962580881799849543513806477703328160722703144949397126491692576132880942262307420002735620049515474828774084254526822183052174684454008765823539098840111582388023e354"),
           e_float("7.1838614885045732660428700175616787179412123254243640171858039960392668739855380818776444751036140633835297698354871320817774950056958338256758193132959348952330882225931634054260987178892124104098502891310803407576401435393500647744591102564423307467228648880509432132319363581971734776302098144479976137703316601586106060045116431388853068011794251546883246179413809746887289654496080871491040557486e358"),
           e_float("1.57290877885985903353598062226985760262955611522578624473535699503352135489225179336350600027761720627440795324768400880044881352613569989264929795135335070337194549351333148619696643686213314851818924990695462987602014955090609813153309587157316563775548332429162536363044323918347303231887223060187157045321668042354530219174136692444037128318928757986559718902850273433501539604032575713039004265e363"),
           e_float("3.4441326314666240799825408159986254583303258076969580128137631984195772152602813207919925311847002888301245859199477787315661925990220754036447415720250393577468950652133445269754471948188237520183626321645412496047024239611579383276007990536274770591081372865648828847938027898306090956083888714467072907502066566409956555476095896097213472420818916829129122368689568260270875886089835681072569724888e367"),
           e_float("7.5419947330223440005049014272116074360517197589370403147398587478298034695293929724418091921644528388507665649864095919730151706668327096714461280166205714984946292061530172538489319691037024944520713287019922200281246772027867663431051312203060273964077845988125496733481297783942411987292652467351458030093107428849144507454690628119490887829954072926817302544999568197692217182982692388792286605216e371"),
           e_float("1.6516648035866148373045969196862948421966275561533701042289579342507102925750715979588762251562763208158904889430486780060074337374790935352437751282824060129388298952692011975325084330435677792778212460387697322085144699282891667325198521586853581119708525973997854752719322363553966770805285780773872180678730175189378621047871383441039065179761108440451131095753188691333485632725623012839696230778e376"),
           e_float("3.6173144704586007293904826519991168426321410561662233590932155774316590287130243266839803478154618528973453691622211736672842512167634090784069208058842631446051961474396045737372379056151003187244101148651912071876683928427902602242234989265230646982190202890944351424806144090257644818912881395111193838986092049276679633684585643216070077126892365819951651656319120727790330952456318739732876676393e380"),
           e_float("7.9227988851777306990876352303590632904764160567749141342605160985438664573662238296789230327863902253072254076214102793002939304034346597224051784827275229527987572497489980013473504868962653961185091403866371469936813355865743457450538587385940831357890406933787012045114412333090625529600992283428811237991695508241455871496390044683156792537537935095402319672262314677659334492069287173466871503876e384"),
           e_float("1.735395179572879424417531924966708731610346212104899584272434960755859196065181031901533247673783722930697248496493851203211583215876500059768578684088907754398958800541899176094357438662493846113454998189955537775507952051535964113223493895975445457724815448771192055319120765878831040163717096049911876095921906789992346745507500320454403610116885163892912901263202657401635196559578951742871953607e389"),
           e_float("3.8014118624805033844824084573158674158698123233119569575392588671764204267809385462902690078135683518719275890566172572666836833334543731975813606006731701666684466651586238036888161842324393193769358459273510402562623720433929065180647436977686376882574414591905860259763004573696525175665096463924860457126701652404039141203006143684824573773022985945713266027629345332622398805237106769994540179669e393"),
           e_float("8.3275579424244597024727844287792465159687398340682554884642116633687662061166088102189737791910058051322646917345897904179296319647053898609265628214987693043024061716185674585416533965327463752221824484575659453145620929868260389520634238528992938390730930357292532075033781493829470665483637398519219706975600483828106198521628538836411537875505124863732553976665037965415505894604411867360486992563e397"),
           e_float("1.8243830690869591639060287147706465352457090532676807384132369632355806649558249354058707454183701028378310192263114340669905076431308622614188918694692460829066171194147282859856604640198471062418502128529220020627927495205557554031015020303141451624711673698079318936775013668038027086436814124945962175520613142191787402234079959870390801022261874418785180545535183772717148703303005886736938731214e402"),
           e_float("3.9970491409992217274473444577389736165152514869181216863224279837406799237093168684576091972810209937783044485541031859501310126044026040269396356752009936435561767165825257571453862681555788816435017645712435357742382929350108812715054186672222725873579607842074549806286046380952781954474513824453993368329444477410387579451782475194246935115308623925945606445524885476255713950196903639619412444193e406"),
           e_float("8.7576482112929244059320006309767361644337248161335524311549462488057898947918933196610544062885266550293896964056214152809280253695676743043580652460231793639981946657980668422111367695947799725073179524913583245805695824183456033947931542135155128344658071749527531507417930890250388304417463741307780330052827241518665365307535856403107187852338067186457259855565939284917339313085606820759629897498e410"),
           e_float("1.9189318177256434673561139287754142529538572637243756290663290712690570090305032116544401324584085009857309952253503635613022042709324199024955111160112324705396374518758398129645184299562401025203411355353790767476624429900193180782402300584880159048026352704918446332384560337084273181782499781896088895570215870745863442454386883781946660262355928544374949219979698193719681605717080696110772641065e415"),
           e_float("4.2048947888254208677756216805726684567484929261101228395759920259930789429760527937504241533661730436634774091905203468442970828459321174676137039768943782516858418738923766629307779450601206565676291803703713329084676310547623833742160595139319458087917200107085105853206021438012218954385244362897175255318183455916044713169044696476057575066785291517479072082210278041606339497229466122917599222162e419"),
           e_float("9.2145426090008973821370793372888498038017986115479278478671552177075789900218012613747179754753957370287332305682424860515776334179384735960116345116057234451521383045586729076594183349556031076736363436403941031082627638607238797065282038166118561921805275670032751197914885431650340696726246615093710762165688464051486853785629281446061392926079879432921996894842247123819398688060356278275306768623e423"),
           e_float("2.01936591975034031280287520165510094826684199407942631923086799010477474596370481422899325269686287283054595794359104229096048633694313334768811954003903950722423837395939826585162761368063082020789932033984589723867205466453547488416413821816397588616549028911900244150271026260435549331114976893139863657623718200570469386322708080824443099218972418306502372095062745079480096998213492003114601593e428"),
           e_float("4.4256635999605686579680876554574416468096438556334410659310032733628356041702650578594581474788558997378592362811171810225330703836913537021404462578318675594493621295186903344960752615063590640027040270582376798845640404010787411720593528125428119188621246554550559265072580316525039949575279798834609828498552789984067799234676981686610000951065010635272207699885473161214042316649825423311651906435e432"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00481_bessel_iv_at_v_1_3(const bool b_write_output)
    {
      return TestCase_case_00481_bessel_iv_at_v_1_3().execute(b_write_output);
    }
  }
}
