
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00102_cos : public TestCaseReal
    {
    public:
      TestCase_case_00102_cos() { }
      virtual ~TestCase_case_00102_cos() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00102_cos");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cos(ef::euler_gamma() * ((100 * k) - 5000));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.50162154214905535006507934761566421365808962336874567677926739022768858180703782104157334491773507690211622144412751863172893119122904872120863946237533655183100979972269651012785895305465091942482860884709266947899655662267052604131701946158941092922207257375120965677001058006645609151579188243577188192831765423148813895489546306047297711022539509473462404019089733447430114238267379980532396311664"),
           e_float("0.60313571428133694309325113655636540756247392441681227046917143280974317371916820972719995253248954425492897594051861535050840463205496306256237562726891289696301688567930026444972968333329934552460084325207412884738539384203738886072440013640125030433738691853586812704775040754220545555524237855361445575868855139945713834823411715711428213828850093318644478373792898000948569667301322178250159228606"),
           e_float("0.96902885660223213449832417965462288346382027027907788639786102888188268413128284808786908788351970794814191573322198094839000459295090920127430762740525901384778314480815531039485728089512489227948630012091333107823627672161756650613535363845597750943844039360212709462602480040358932164638277463645635101178868520058961493135889052671922314786442189473233561252419424865659925386520422456933994031412"),
           e_float("0.14782491492260520954264860310453392894688582499520847868449990765772811594316839506757584243129175527745236732059643506743012867347391315093605558463510078020864683057368198129858823908327097108583620570511151521896111105026538667326749527786043478669088587777236123716686756088055458828079103458534402182273835161066708126746360741813126817035007484464329141515901214558732724557437706092450180726378"),
           e_float("-0.85447015139344948471094821054366626768019606763269341666053644333072070840260166961763856973284893831954425042860099172316086950440334996806598196522184690224018944138578542327045770832471332376269716674841615467614625539483750018876502303839670098606230317226296309325404589665701938190004997832683948796843166639576625281030300467522347494569768687089899397360725496800596493559470637547748735594697"),
           e_float("-0.81000689036588888102398287378618104836450574863713892332248232301021899106208419137911694670935600210389307190348154033680700645928539580731142634010602466147128679656911798991740456705453963764056901956423046807435258488930954638670002070774439646670450724500520094586192645160847046520311570082832431061691996839606591067443335185302732221888316818825870721496315105401624866741940813589284275695918"),
           e_float("0.2267455177003321384894005667464998092097833850092894238480831378466683827110057043871346060005709235569800215748516185659827893723700508589640891976972716570403665692613477548038629552153079218542242417184271182264022470709072429310981387965885388758575814101891100826647083444934684812292662215448102626341015149572372707444725994248777658076421636637760492982947444020394182326376291158696727384852"),
           e_float("0.98572607094681400469823142383450564975177916157871840422129452719452525174019803417354200370408054482797693621385765351670173144053171524005535725427317409189868483686977845578192854125777358818593005952568285102554187813023457756929121023181880198348203083841375515867843145321766318476866476607321938993078073105088587752971311300418067382395754489252201424628686354714684325074264340586434068083735"),
           e_float("0.53715481965030691887397316962489853948341836449029599646266321884877186476498260019355874856809552188645630606126976563119123530724283602396484950653123503399938294688332329634386257314146589125825636097592371320563696604271190825947497633567945681092924620382686009619110102110209885034787176755762448527267043281608584015012767667899712762371285806841811102653584612955459666723163160014123341963671"),
           e_float("-0.56945144858011886915780505911780725010620323062276283805115420871306570794972703588425077520601752861293077323301792800610549113139402646104081762175534061087117946244152125287975953108704696268847815261917377065241801643783329354778399526877290332215236634903080639679860355847620563822363712579548641527844739938293967364597110377469773489014211951212857101374318452911401420528677259991331090266005"),
           e_float("-0.97845810511310366097345864112668906661089075307983663561178996977421991305045684012227818895513901547325249161241097295038349597373820690088476031256136981855438584632935895625291791741570973153071536443895825053372019222244541345181800559983327493395843212471107951435623879503589116197386166395270332969985628390518342285544128149350904869144760786557644083102040293619728857795557725975446387638082"),
           e_float("-0.18881649076882036818094718893825891946691295900905829577570255489597056088743777799436529545269699011594065157007321752198038423373390670103253610646983030773571922979273600163598344653044825786274322207994738104766932351285365246017952816761886637102290439956065197679903357501267350062489863581450400525901254917975058272557102311416424438039867176899411547343130655797011597302924818642795986910776"),
           e_float("0.83213248256248718391648282211236200464150938178343837417522635579213705328552770623957486792338755433958256100224720251839082676782210674078979903328623897712870422600430978907177584667709552233768475968506874004560085480509103334782228549116928850495590090914133655583767781543886956699592465303315591578411513564172526903206600594554996369316967222569167592338646796759203865876228192676690576393957"),
           e_float("0.83368761966098380317914918853127190012005517198095141616372457983351189700156411681039093358761555771758536229588242982647239744187242300801829995961871412772468923394414109025642424234703592018655517051393077978860068845984020869413624371103031896740117407710299198562267502869147100200858539656754317575041431701939759759225389946719106478332366708137354276007919533255169664638235639383569564110075"),
           e_float("-0.18605618137227649584671124815631620875769157093190685600569736108086402885199167407702422320100843062616644714444408614621390574242763877642390939806307957026167805604628333909629405976831956784535026886701013223479257442178936513209253370459988519785036119662696969209506800793520534365946487576733594348627957021254017447520897947123358509837940617442852539597167693389591380189862319487892792923153"),
           e_float("-0.97787410706912947200700947809086987929552083940545236541182287303790608208610023257624198390105132776123115664110406549669787968717953162987933260638310530750565076435745587024443942712810356372635589174338356282870564205603334997652974637518927664227105047973535688395040777968082125500061259190313820373870936866720823176265958448162090987423326403872038897090958331050185525989399368410147697601184"),
           e_float("-0.57175918163121264025616107589630751551161205724757288681494194505248342228571881008866075970817690438186545379919710148119548771419260784258379302863349865022779589406640338106461807885184578720013258862884778613907350162349826641089246855371608494365729193629734711852175384638728815913727055118781471960575965215193534386589450370243853256890375165575818694142504618584610839931680003465519416417686"),
           e_float("0.53478241597498682890636923119124507573138434225226478301997338705931821657049944750562391125304256759887391004338167587322019260365925435302391176930331161896818003746464685277508807805130884660314731429722219318699505836398912422599554793162364836595300619860913573673921432325981205409702897337053197706014049687225094538593517626884763534008626048851538197945922313231461994435494917556595912129444"),
           e_float("0.98619528108436834444622772244233500550001863518169392038562682097011946713614830549103565779570404766638555367268020992254689671390965312890416679706192473068433717014095521991774567755994345709131209844512998942709582638991869821050636439257597063856249038092119512871640381123843890013812838185293393263756058350072768448458950380360337889770923256206901689904823829217396801268618019194906772703227"),
           e_float("0.22948154144509182369415746800698328364988547396475691620681392787566104183462052622980774444304368277802870979261579895452333488316470495027443871923297117956210113575448119970237881958246782891025814249305970662163236166516394039705137544157900789683194435211763787511069822409683486532927557658412323180776903688623277362060713475574739265599518489263464320833102602215450190502358534383949241852484"),
           e_float("-0.80835578582046670310464731711696478601773118159925609840597870029856375850957218864062941877059300809268098041286606529894870899049159003652074961379621476411176224648451902760457011220845176506086174749134555188467902316469475288975403773973857636373892326760376585744094430003550369691223550482756797212146056901318410686997010241891041855811922027651329719928389111111167862044112446757189042088046"),
           e_float("-0.85592663170679958406515397649643131309994249316454429005131578645085757570761552251729365670632975735279522675018975575836010210249068470527194075548251441076976420496548792075626757772699437483366302008026562909787676760497709271997930485538120627136230760141137536077186130465523928404376378372203755818590534658221264961808618483334189725855704258977192100851554017405085224133570406300901634686193"),
           e_float("0.14504509334766993343679732543237665601748015028110051986903855469561805431836897592755787294803720321294196670692675860425817019156006795472544060301573514970130737237352276407965078322598196015088783620318485742726789260216376389721616761481364286097504141935673467904417287244647363440435023754573347620436961058676078531225670052103877411944831266665091545142351559495386200504307614132116833066489"),
           e_float("0.96833108057454018135440242001894400433450486884893467698495154667147695605198346971512860434896301677316979407715828973045999189796179033252360390253384834782428911228350312995059296512013202981214049690155973624217982618572186690629393688668380855531415343035476364485845562203330354168788849023043609092864372997506131587372974589034738683570955059234741409975711088655065542622757333229038929539614"),
           e_float("0.60537478588662083093550030671881062835301187704838619957445140277346831579708290170559342372438997696786583564116411747796066131598667722839502247472418892060636953054544383896701697716904288008881811071365393348940494848858720140528491631498078923089892805069340832767510592701952499233084373444894649962175905154151059310656485499518493307751028032192138975110743944975104530590939205299365402172399"),
           e_float("-0.49918857050765127165246443100830980202323621859663295606411941969457362189652587284758726475585312743864487499288977743573076640209331558808543037798473406138898808010287039327632227491127621026484760216100025745074711422052006517238053729631745694408780163847537773119573702459176085803816861008338932982744241500509585746534632592189239382341678009278118030810458222678068124752194184440160812863357"),
           e_float("-0.99222700442041793244341637163672398376812477454144578739458582830385307501573374493329418110400264981611911650266336290704933803675752414608868505761080497715998786605323101072631863530928986865345605473152114701760347977346551445152252230086602267733482237318264916817026594817822201149718727077242483980112025554281082958570816251191650760457174817529165817706742958860474153596353298087887496342571"),
           e_float("-0.26974974384283529407135442904911380728022891803412415907499156005666362362451160206340942887714356745930732393405178421002248875485798257350416225295845333813028470892948983232570745331205136828532696050523659085855991735781739399449780199864580413509362957674310213115088541667662139444692787904342579506007770224294439456180398644394712078670122120840185549712701180444406705582313291159418160268707"),
           e_float("0.78318117881507218281256857540210491140619166393457160009274918850278377150347503811659906527658912201560000425062426213174077300808809107842767634667207644130246300983762258813379724135069575858579484972987736881337517572218810617863132592764984653001013079710817700332509430207238192747837232227382559069149116081099363790759716765670238049577887842168907894878101742345788299501918210802461045488336"),
           e_float("0.87668546801298894316611272503029374001219866661666136243743380759468378098691643969637456927472038354627520673349367283367324121916949272869177620477269451717775313582362761369952753768494804335788010017359300886827719062432162897060693014847129089532263482838487347672588768501033685070780610322543843882757687187812123549700825256897742477675410408774989851342602781239821815645715958753412070397601"),
           e_float("-0.10378317514630283035697337871092369012118223784464643078377333318832860627512487321975641507120202567300966096393096627338947655380820003149059343389474916418959764384086933825280338584080543377015355584259569741193189206873606119903440824298765910897401393832760642020478309582400187458069600297503471338694965049437285901431495005334289622152511502991672903524064211804721113695218039893263678813343"),
           e_float("-0.95711349446199095576893296201081918391006544549413893765144324906139169225887225012143883285387366088163020556116889558963741768284740305902934334806946850023570597825714830361465408561420292855043502515001498149850537134194706047165529988277670109220102766502269805527095332398862295461748072266537481745404509807754999697692445286508080110297609601749711507506133141464812431049826946597146636354781"),
           e_float("-0.63794350009531545667254180005058967014091074426028186874676752373058269762260454593384980188290943960936825811511438820242903324463297183316287071729253599410382790069375166807977207973311824805416905280934478728402362367738590911068930970233001798070025927580146476114118351752104439608955539133724726044901319895130615046919558595196176958507074369945336446902427277357686167969430099800901266255694"),
           e_float("0.46273146552227640776400067795797886210480882393837882658186448207173350896006259857463834781474074845803406523589452301046262359240960602310918185550315272791571940053255136983368027733514059954139407173745111843912155780937211468453669133666656749905679399238836226218178194842769436017337481617143672364099652685726181145621234602247890953107767351286824995678514316143524362442186848118247298539021"),
           e_float("0.99654284430835394575771581445263740011621544801262270069888725717770662527892701805906692059703566000057199727570596201090018843521079740099451243652812902235907552357808897819533630795824169795169152613897271256945242079733003533677278244438976511094582819587451104089603294510862191561695442770960262566234171127458107369852758518111412741106821369313642094603607640773678048962065297712686264798258"),
           e_float("0.30955146113330921967430965120100702675233631993391895373629969028737150573338643391886330012902676396897993034209801929950606565714260278367377830209837135331181218082619455762666764549875449196418398841614865341526715151403235213502358851080285994526097503071014059233244883279123955235243977740815084262049389088713424955579803462877942093968546097956762333725432236406001838616369819684003862992419"),
           e_float("-0.7566521966358354309951093880175904595961117293429649925035725302909818579817906207321292211570710827880191877879999303605651415336764708947953554392170782512559588243742231488130076898716985771987302881464753061056309847520640566277714873772103739495076986709669815846805764241489433274054604832770486905571732368583068561729787356544754173018704553303862640097086917153589464723040964231442327725739"),
           e_float("-0.89592822979483709059243413613768383910182989046075476634617095657797990928508436396136302337758704430356065256820357837873075721305029630953922861317062956315025129501726888033240428998214338302878323599895725515251065134297830575602290889130735518399074878206099064423045326729243958866358871543482110235173182896730253794606214425305515937065566938780643012662976806400899752708380354702107584200173"),
           e_float("0.06234178205498326768449331827227332778878332201276384069140804289468809818009465781317127499109411839409445261411097713389998386056235706454635141010244151932394411847811136494628546693592312682393427375069804704908617054121292472216996067137584186214292728977551151133236612796923969229055426308128461924845361007211592745940106076843829115607148914933190080636946774340167862449354032670081682503677"),
           e_float("0.94424074758905426693013670501578752072879728684274664557376317555913249162898450233304331602359948789616904949986891686512171337619053651010052765459159420933905715970952322156715741540214635674374384487833082591105216552403945633258288248064096802773248182125224091036161363816821787326423255076418870584794499423986465255713593740475609695103672895656428014974438779094737722426473065402390479127002"),
           e_float("0.66940900234972085772698395256659605212272643739109209667125733824405981903658617201709239065102665405063166964631091092744127095503906134074823656023393611554152837997449326176648259796105677009519668003831584281955537599169598905666609420488437109555473016150415050976685545370751598833602947303804286613228920011048601435648630323226945291269501824614939897919341523226599107705055297349402859236896"),
           e_float("-0.42547414721971330565409790138583216442479880361609527886964392881677619848933007107332651801952059053556471752375648666462158176314752197637071456256008899487321608724189395189615041157311878404609283475043414911337534183547148088572894035977423720231858134885165786681305346317203268564898788667422942217715710500639870156821380173286044798492696421543055302879445405671926952506373313300693015863574"),
           e_float("-0.99913533725625827895885420059533174260228060155728399323156205571706305217929202105237251086305720615246638608665744238167422868148494071388447512869369652666016804258416975268792629805702694345570129997561583877702300615841988105832696053353859384414627875276769517809636231032799628078938353066535288163274118038591394188369361821148103018841138634739652369087495081203873309267574158616396567307492"),
           e_float("-0.34881786319235757353608331390774426958801870286240250260169998305471883501204837208323576855595361379043170036069553791773607809536655382734659088580969476301635137094982435633208997311383294130223650445792658125459022909462690696664526317408366804098986643756477511847342019476173582109336405217301916061499808856137725615883817070458120962726145756438119220448588723418633370427189844667611481792962"),
           e_float("0.72881471652779599579578058763983370510799582516797066846624634893882199724038302182668125377701493863656762620352413750563017197413808000383697483717264271873855767687937510341726345841626061553517042595268476874385774311053499675017743616990623307920507987935959383718695693618200297497313502037997098069759583079411517535532519668785928165917878363955532156662323627880875149433884315003009524969368"),
           e_float("0.91362164005394510404798528088309623890018900746219043351480570272112701909791508825990618473644291633475042035900507995909672613140877257670920948316716218048879267235797825939302972470200910320624112626429381475376664864431458828213242682906890618620939480878412280722400697167591741919704297000951832259295785803906002953167528593565353099927772534139636590356175767293503013121188135804719329377757"),
           e_float("-0.020792579731020884570917489924829815990901072176716833800451630402659488568602453092320962870467062725056963726749091346237812411927788553678105022434525207164566719010754898510917339890499700846699846272929873718752144808990322962955858259663820680120429324521028803111432757858749225053719910422285494416920886558156485737807758736556364535329791051459890234311397811046030022550124420890079918499806"),
           e_float("-0.92973510112499140703211303301543817758564572287706026278579630272201180630168028836976329577763576080557925500836630218023453183589136530080853328463253256043937995662714702310301104590063206629677773404210676707719408386980510414385968423854465563338165624928483173590672543381355453313463456551085355191753472704341195875901211063845473814165083882940066653120643707041759352014177322989513249712945"),
           e_float("-0.69971687855481202313282264003416633874007708241691504684133936897916129633508695580324089944109853489892619325255884869329787559760565315713290477914000125094981765362135662354044758619666857636031878131847413243331348066629478769360995267702914881219005969303814156065237352978323936029385435868138673545623501852266665885946448589623038753247551331280396083996799682701685286072955536720942219340784"),
           e_float("0.38748104563009787102820133164016447769400048035334289735708379460553950678502357006276775381947203793501041447662719507628277154284594473586657342957139018292691624326995856690727098436205171520067762188653923456293311998678147550312423215288396830773761466919125058572139335774599032387616617354102353665454197825146894321951594670500888745959955736169293525665535786830770045479189693672271780123876"),
           e_float("1."),
           e_float("0.38748104563009787102820133164016447769400048035334289735708379460553950678502357006276775381947203793501041447662719507628277154284594473586657342957139018292691624326995856690727098436205171520067762188653923456293311998678147550312423215288396830773761466919125058572139335774599032387616617354102353665454197825146894321951594670500888745959955736169293525665535786830770045479189693672271780123876"),
           e_float("-0.69971687855481202313282264003416633874007708241691504684133936897916129633508695580324089944109853489892619325255884869329787559760565315713290477914000125094981765362135662354044758619666857636031878131847413243331348066629478769360995267702914881219005969303814156065237352978323936029385435868138673545623501852266665885946448589623038753247551331280396083996799682701685286072955536720942219340784"),
           e_float("-0.92973510112499140703211303301543817758564572287706026278579630272201180630168028836976329577763576080557925500836630218023453183589136530080853328463253256043937995662714702310301104590063206629677773404210676707719408386980510414385968423854465563338165624928483173590672543381355453313463456551085355191753472704341195875901211063845473814165083882940066653120643707041759352014177322989513249712945"),
           e_float("-0.020792579731020884570917489924829815990901072176716833800451630402659488568602453092320962870467062725056963726749091346237812411927788553678105022434525207164566719010754898510917339890499700846699846272929873718752144808990322962955858259663820680120429324521028803111432757858749225053719910422285494416920886558156485737807758736556364535329791051459890234311397811046030022550124420890079918499806"),
           e_float("0.91362164005394510404798528088309623890018900746219043351480570272112701909791508825990618473644291633475042035900507995909672613140877257670920948316716218048879267235797825939302972470200910320624112626429381475376664864431458828213242682906890618620939480878412280722400697167591741919704297000951832259295785803906002953167528593565353099927772534139636590356175767293503013121188135804719329377757"),
           e_float("0.72881471652779599579578058763983370510799582516797066846624634893882199724038302182668125377701493863656762620352413750563017197413808000383697483717264271873855767687937510341726345841626061553517042595268476874385774311053499675017743616990623307920507987935959383718695693618200297497313502037997098069759583079411517535532519668785928165917878363955532156662323627880875149433884315003009524969368"),
           e_float("-0.34881786319235757353608331390774426958801870286240250260169998305471883501204837208323576855595361379043170036069553791773607809536655382734659088580969476301635137094982435633208997311383294130223650445792658125459022909462690696664526317408366804098986643756477511847342019476173582109336405217301916061499808856137725615883817070458120962726145756438119220448588723418633370427189844667611481792962"),
           e_float("-0.99913533725625827895885420059533174260228060155728399323156205571706305217929202105237251086305720615246638608665744238167422868148494071388447512869369652666016804258416975268792629805702694345570129997561583877702300615841988105832696053353859384414627875276769517809636231032799628078938353066535288163274118038591394188369361821148103018841138634739652369087495081203873309267574158616396567307492"),
           e_float("-0.42547414721971330565409790138583216442479880361609527886964392881677619848933007107332651801952059053556471752375648666462158176314752197637071456256008899487321608724189395189615041157311878404609283475043414911337534183547148088572894035977423720231858134885165786681305346317203268564898788667422942217715710500639870156821380173286044798492696421543055302879445405671926952506373313300693015863574"),
           e_float("0.66940900234972085772698395256659605212272643739109209667125733824405981903658617201709239065102665405063166964631091092744127095503906134074823656023393611554152837997449326176648259796105677009519668003831584281955537599169598905666609420488437109555473016150415050976685545370751598833602947303804286613228920011048601435648630323226945291269501824614939897919341523226599107705055297349402859236896"),
           e_float("0.94424074758905426693013670501578752072879728684274664557376317555913249162898450233304331602359948789616904949986891686512171337619053651010052765459159420933905715970952322156715741540214635674374384487833082591105216552403945633258288248064096802773248182125224091036161363816821787326423255076418870584794499423986465255713593740475609695103672895656428014974438779094737722426473065402390479127002"),
           e_float("0.06234178205498326768449331827227332778878332201276384069140804289468809818009465781317127499109411839409445261411097713389998386056235706454635141010244151932394411847811136494628546693592312682393427375069804704908617054121292472216996067137584186214292728977551151133236612796923969229055426308128461924845361007211592745940106076843829115607148914933190080636946774340167862449354032670081682503677"),
           e_float("-0.89592822979483709059243413613768383910182989046075476634617095657797990928508436396136302337758704430356065256820357837873075721305029630953922861317062956315025129501726888033240428998214338302878323599895725515251065134297830575602290889130735518399074878206099064423045326729243958866358871543482110235173182896730253794606214425305515937065566938780643012662976806400899752708380354702107584200173"),
           e_float("-0.7566521966358354309951093880175904595961117293429649925035725302909818579817906207321292211570710827880191877879999303605651415336764708947953554392170782512559588243742231488130076898716985771987302881464753061056309847520640566277714873772103739495076986709669815846805764241489433274054604832770486905571732368583068561729787356544754173018704553303862640097086917153589464723040964231442327725739"),
           e_float("0.30955146113330921967430965120100702675233631993391895373629969028737150573338643391886330012902676396897993034209801929950606565714260278367377830209837135331181218082619455762666764549875449196418398841614865341526715151403235213502358851080285994526097503071014059233244883279123955235243977740815084262049389088713424955579803462877942093968546097956762333725432236406001838616369819684003862992419"),
           e_float("0.99654284430835394575771581445263740011621544801262270069888725717770662527892701805906692059703566000057199727570596201090018843521079740099451243652812902235907552357808897819533630795824169795169152613897271256945242079733003533677278244438976511094582819587451104089603294510862191561695442770960262566234171127458107369852758518111412741106821369313642094603607640773678048962065297712686264798258"),
           e_float("0.46273146552227640776400067795797886210480882393837882658186448207173350896006259857463834781474074845803406523589452301046262359240960602310918185550315272791571940053255136983368027733514059954139407173745111843912155780937211468453669133666656749905679399238836226218178194842769436017337481617143672364099652685726181145621234602247890953107767351286824995678514316143524362442186848118247298539021"),
           e_float("-0.63794350009531545667254180005058967014091074426028186874676752373058269762260454593384980188290943960936825811511438820242903324463297183316287071729253599410382790069375166807977207973311824805416905280934478728402362367738590911068930970233001798070025927580146476114118351752104439608955539133724726044901319895130615046919558595196176958507074369945336446902427277357686167969430099800901266255694"),
           e_float("-0.95711349446199095576893296201081918391006544549413893765144324906139169225887225012143883285387366088163020556116889558963741768284740305902934334806946850023570597825714830361465408561420292855043502515001498149850537134194706047165529988277670109220102766502269805527095332398862295461748072266537481745404509807754999697692445286508080110297609601749711507506133141464812431049826946597146636354781"),
           e_float("-0.10378317514630283035697337871092369012118223784464643078377333318832860627512487321975641507120202567300966096393096627338947655380820003149059343389474916418959764384086933825280338584080543377015355584259569741193189206873606119903440824298765910897401393832760642020478309582400187458069600297503471338694965049437285901431495005334289622152511502991672903524064211804721113695218039893263678813343"),
           e_float("0.87668546801298894316611272503029374001219866661666136243743380759468378098691643969637456927472038354627520673349367283367324121916949272869177620477269451717775313582362761369952753768494804335788010017359300886827719062432162897060693014847129089532263482838487347672588768501033685070780610322543843882757687187812123549700825256897742477675410408774989851342602781239821815645715958753412070397601"),
           e_float("0.78318117881507218281256857540210491140619166393457160009274918850278377150347503811659906527658912201560000425062426213174077300808809107842767634667207644130246300983762258813379724135069575858579484972987736881337517572218810617863132592764984653001013079710817700332509430207238192747837232227382559069149116081099363790759716765670238049577887842168907894878101742345788299501918210802461045488336"),
           e_float("-0.26974974384283529407135442904911380728022891803412415907499156005666362362451160206340942887714356745930732393405178421002248875485798257350416225295845333813028470892948983232570745331205136828532696050523659085855991735781739399449780199864580413509362957674310213115088541667662139444692787904342579506007770224294439456180398644394712078670122120840185549712701180444406705582313291159418160268707"),
           e_float("-0.99222700442041793244341637163672398376812477454144578739458582830385307501573374493329418110400264981611911650266336290704933803675752414608868505761080497715998786605323101072631863530928986865345605473152114701760347977346551445152252230086602267733482237318264916817026594817822201149718727077242483980112025554281082958570816251191650760457174817529165817706742958860474153596353298087887496342571"),
           e_float("-0.49918857050765127165246443100830980202323621859663295606411941969457362189652587284758726475585312743864487499288977743573076640209331558808543037798473406138898808010287039327632227491127621026484760216100025745074711422052006517238053729631745694408780163847537773119573702459176085803816861008338932982744241500509585746534632592189239382341678009278118030810458222678068124752194184440160812863357"),
           e_float("0.60537478588662083093550030671881062835301187704838619957445140277346831579708290170559342372438997696786583564116411747796066131598667722839502247472418892060636953054544383896701697716904288008881811071365393348940494848858720140528491631498078923089892805069340832767510592701952499233084373444894649962175905154151059310656485499518493307751028032192138975110743944975104530590939205299365402172399"),
           e_float("0.96833108057454018135440242001894400433450486884893467698495154667147695605198346971512860434896301677316979407715828973045999189796179033252360390253384834782428911228350312995059296512013202981214049690155973624217982618572186690629393688668380855531415343035476364485845562203330354168788849023043609092864372997506131587372974589034738683570955059234741409975711088655065542622757333229038929539614"),
           e_float("0.14504509334766993343679732543237665601748015028110051986903855469561805431836897592755787294803720321294196670692675860425817019156006795472544060301573514970130737237352276407965078322598196015088783620318485742726789260216376389721616761481364286097504141935673467904417287244647363440435023754573347620436961058676078531225670052103877411944831266665091545142351559495386200504307614132116833066489"),
           e_float("-0.85592663170679958406515397649643131309994249316454429005131578645085757570761552251729365670632975735279522675018975575836010210249068470527194075548251441076976420496548792075626757772699437483366302008026562909787676760497709271997930485538120627136230760141137536077186130465523928404376378372203755818590534658221264961808618483334189725855704258977192100851554017405085224133570406300901634686193"),
           e_float("-0.80835578582046670310464731711696478601773118159925609840597870029856375850957218864062941877059300809268098041286606529894870899049159003652074961379621476411176224648451902760457011220845176506086174749134555188467902316469475288975403773973857636373892326760376585744094430003550369691223550482756797212146056901318410686997010241891041855811922027651329719928389111111167862044112446757189042088046"),
           e_float("0.22948154144509182369415746800698328364988547396475691620681392787566104183462052622980774444304368277802870979261579895452333488316470495027443871923297117956210113575448119970237881958246782891025814249305970662163236166516394039705137544157900789683194435211763787511069822409683486532927557658412323180776903688623277362060713475574739265599518489263464320833102602215450190502358534383949241852484"),
           e_float("0.98619528108436834444622772244233500550001863518169392038562682097011946713614830549103565779570404766638555367268020992254689671390965312890416679706192473068433717014095521991774567755994345709131209844512998942709582638991869821050636439257597063856249038092119512871640381123843890013812838185293393263756058350072768448458950380360337889770923256206901689904823829217396801268618019194906772703227"),
           e_float("0.53478241597498682890636923119124507573138434225226478301997338705931821657049944750562391125304256759887391004338167587322019260365925435302391176930331161896818003746464685277508807805130884660314731429722219318699505836398912422599554793162364836595300619860913573673921432325981205409702897337053197706014049687225094538593517626884763534008626048851538197945922313231461994435494917556595912129444"),
           e_float("-0.57175918163121264025616107589630751551161205724757288681494194505248342228571881008866075970817690438186545379919710148119548771419260784258379302863349865022779589406640338106461807885184578720013258862884778613907350162349826641089246855371608494365729193629734711852175384638728815913727055118781471960575965215193534386589450370243853256890375165575818694142504618584610839931680003465519416417686"),
           e_float("-0.97787410706912947200700947809086987929552083940545236541182287303790608208610023257624198390105132776123115664110406549669787968717953162987933260638310530750565076435745587024443942712810356372635589174338356282870564205603334997652974637518927664227105047973535688395040777968082125500061259190313820373870936866720823176265958448162090987423326403872038897090958331050185525989399368410147697601184"),
           e_float("-0.18605618137227649584671124815631620875769157093190685600569736108086402885199167407702422320100843062616644714444408614621390574242763877642390939806307957026167805604628333909629405976831956784535026886701013223479257442178936513209253370459988519785036119662696969209506800793520534365946487576733594348627957021254017447520897947123358509837940617442852539597167693389591380189862319487892792923153"),
           e_float("0.83368761966098380317914918853127190012005517198095141616372457983351189700156411681039093358761555771758536229588242982647239744187242300801829995961871412772468923394414109025642424234703592018655517051393077978860068845984020869413624371103031896740117407710299198562267502869147100200858539656754317575041431701939759759225389946719106478332366708137354276007919533255169664638235639383569564110075"),
           e_float("0.83213248256248718391648282211236200464150938178343837417522635579213705328552770623957486792338755433958256100224720251839082676782210674078979903328623897712870422600430978907177584667709552233768475968506874004560085480509103334782228549116928850495590090914133655583767781543886956699592465303315591578411513564172526903206600594554996369316967222569167592338646796759203865876228192676690576393957"),
           e_float("-0.18881649076882036818094718893825891946691295900905829577570255489597056088743777799436529545269699011594065157007321752198038423373390670103253610646983030773571922979273600163598344653044825786274322207994738104766932351285365246017952816761886637102290439956065197679903357501267350062489863581450400525901254917975058272557102311416424438039867176899411547343130655797011597302924818642795986910776"),
           e_float("-0.97845810511310366097345864112668906661089075307983663561178996977421991305045684012227818895513901547325249161241097295038349597373820690088476031256136981855438584632935895625291791741570973153071536443895825053372019222244541345181800559983327493395843212471107951435623879503589116197386166395270332969985628390518342285544128149350904869144760786557644083102040293619728857795557725975446387638082"),
           e_float("-0.56945144858011886915780505911780725010620323062276283805115420871306570794972703588425077520601752861293077323301792800610549113139402646104081762175534061087117946244152125287975953108704696268847815261917377065241801643783329354778399526877290332215236634903080639679860355847620563822363712579548641527844739938293967364597110377469773489014211951212857101374318452911401420528677259991331090266005"),
           e_float("0.53715481965030691887397316962489853948341836449029599646266321884877186476498260019355874856809552188645630606126976563119123530724283602396484950653123503399938294688332329634386257314146589125825636097592371320563696604271190825947497633567945681092924620382686009619110102110209885034787176755762448527267043281608584015012767667899712762371285806841811102653584612955459666723163160014123341963671"),
           e_float("0.98572607094681400469823142383450564975177916157871840422129452719452525174019803417354200370408054482797693621385765351670173144053171524005535725427317409189868483686977845578192854125777358818593005952568285102554187813023457756929121023181880198348203083841375515867843145321766318476866476607321938993078073105088587752971311300418067382395754489252201424628686354714684325074264340586434068083735"),
           e_float("0.2267455177003321384894005667464998092097833850092894238480831378466683827110057043871346060005709235569800215748516185659827893723700508589640891976972716570403665692613477548038629552153079218542242417184271182264022470709072429310981387965885388758575814101891100826647083444934684812292662215448102626341015149572372707444725994248777658076421636637760492982947444020394182326376291158696727384852"),
           e_float("-0.81000689036588888102398287378618104836450574863713892332248232301021899106208419137911694670935600210389307190348154033680700645928539580731142634010602466147128679656911798991740456705453963764056901956423046807435258488930954638670002070774439646670450724500520094586192645160847046520311570082832431061691996839606591067443335185302732221888316818825870721496315105401624866741940813589284275695918"),
           e_float("-0.85447015139344948471094821054366626768019606763269341666053644333072070840260166961763856973284893831954425042860099172316086950440334996806598196522184690224018944138578542327045770832471332376269716674841615467614625539483750018876502303839670098606230317226296309325404589665701938190004997832683948796843166639576625281030300467522347494569768687089899397360725496800596493559470637547748735594697"),
           e_float("0.14782491492260520954264860310453392894688582499520847868449990765772811594316839506757584243129175527745236732059643506743012867347391315093605558463510078020864683057368198129858823908327097108583620570511151521896111105026538667326749527786043478669088587777236123716686756088055458828079103458534402182273835161066708126746360741813126817035007484464329141515901214558732724557437706092450180726378"),
           e_float("0.96902885660223213449832417965462288346382027027907788639786102888188268413128284808786908788351970794814191573322198094839000459295090920127430762740525901384778314480815531039485728089512489227948630012091333107823627672161756650613535363845597750943844039360212709462602480040358932164638277463645635101178868520058961493135889052671922314786442189473233561252419424865659925386520422456933994031412"),
           e_float("0.60313571428133694309325113655636540756247392441681227046917143280974317371916820972719995253248954425492897594051861535050840463205496306256237562726891289696301688567930026444972968333329934552460084325207412884738539384203738886072440013640125030433738691853586812704775040754220545555524237855361445575868855139945713834823411715711428213828850093318644478373792898000948569667301322178250159228606"),
           e_float("-0.50162154214905535006507934761566421365808962336874567677926739022768858180703782104157334491773507690211622144412751863172893119122904872120863946237533655183100979972269651012785895305465091942482860884709266947899655662267052604131701946158941092922207257375120965677001058006645609151579188243577188192831765423148813895489546306047297711022539509473462404019089733447430114238267379980532396311664"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00102_cos(const bool b_write_output)
    {
      return TestCase_case_00102_cos().execute(b_write_output);
    }
  }
}
