
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02902_z_zeta_all_x : public TestCaseImag
    {
    public:
      TestCase_case_02902_z_zeta_all_x() { }
      virtual ~TestCase_case_02902_z_zeta_all_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02902_z_zeta_all_x");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::pi() * static_cast<INT32>(k + static_cast<INT32>(1));
          const e_float y = ef::euler_gamma() * static_cast<INT32>(k + static_cast<INT32>(1));
          data[static_cast<std::size_t>(k)] = efz::riemann_zeta(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("1.14630559585616413282163674752732158790248209671904341614956506190822749114526045299203525788931176490086602055704686253913720813783566903574026229525468156783799700352261354212714529911398877856187330399588932378539160768180787666018505894149900671785869095818083693248969443756932327750879082814801205419006249905936464476051136381161879101536272991515736846676699083252768245267970104689079431372972"), e_float("-0.0882539492380860999695466298507178829394997553246703442099089827150327621574492108329409380717216963302377057595240954948047924548999314621493847564480202978686728259935136777008889251419971740634700687590517378746641866915990465041778845942600104238102829645235398002122463395947478875710323937786065782570157727724204447639313779956368148211608989158974918710865253703512149737434902389646653528358")),
           ef_complex(e_float("1.0092143631971810144438835118510491931527538521907365260439584253036020577721085180905516596330277237488504823371531982900500220609118509912371035953749701788949600859874607373091598462609678705693805583787232148639868303618806555553268744621980467221881543318697684454445069848948855642655690458991922850661131594764566405676287092071981938037559998922766103036912272507024890196443494625826694487981"), e_float("-0.01039333688259962673542638649485927113051819915700083246656950618818185485972233612469061102850218683844599522425930080245082359424242320873975919714309915660475801825042618261741894132590981862664920997674002292948401357006903976481951551334104422096519797717665188388404456264192925454050640854869124408067337789790242615084463363250446948857405734340608600759138107379580127710370853503102972660375")),
           ef_complex(e_float("1.00051460020794070274154056135735011257287436357774324562896065511954620724453881963307848097857157630066401131128247030706247331186514868235718706459420700424021492625555787513289892868492896775617569824295022500863064284362624354077987731955169240349335272285752889258960994296184534373371748051608779923990573193574480674811478149188757988578489685460847397658721885376507826717036891261970186692463"), e_float("-0.00138789497195216311723107871105951937013239732301495221329941854278840405604702244480513768880970718378005245767945774016268591753493252295535544795541457626226153456020903561224030421408613609728248444531157129709542082437210016324417121407244512843253540859724894644430685311702389014874234267874381297945827352783161440668111945065293010128466392048673070690185033629244762390218537742776071040643")),
           ef_complex(e_float("0.99999426363287575509699203298732710355222564239344857335625784886355015448651244706696064365676925454109462802133799396716058446447849130336368648321066885844118470303716792321431951386559423793943083740316326942491463551168450386622659196606175090436524614645065146145639445192231109503701073692462290456660507808343443091301600356589908034778182571283860319298904086203620041602370759466943332632588"), e_float("-0.00016537113288472162665361230657822570865238897782910261743157339870463648439676641265016369623762371949073134058790122578164368773021886714907063046137987668111261832940166151517641836091459967217698175713868472774096974571979373165984435069557478603955452526220972575023773204210825445880603388265950440451377170487518957925451783460872921545900315355937525412407233597513698088119761034334122734423")),
           ef_complex(e_float("0.99999218505616711955482571796436836555356597995561066802740185276232903532589500444259468913135124916148294013427839176834025599171225059441342441959546728080403346295915501885600421957746212276031431717431518300565849145479681844496092742955464012725556115115404657939156398120791197938454462055948472414352794725616141850759718242607972407586387730577690419892346994922534705934029352341995151298585"), e_float("-0.00001698291024361704291095079859238714725652646824484772209854460742381866851620501200667133995565249981348049830388317034818230537523463381310868714994276703062781592615092399167825859399266260764854286199783461162986406701334922393830696013562817102468937117107445472179218967320868737409127519804494603800748507825071719100619177877898898330147399053906914435121273208296591412546802441121248638265")),
           ef_complex(e_float("0.99999843732909569403762282307295194133759268351201094630381936531159523185124267044095121286197726574929219875005463326838144386973542455995022562642113990390489345407202989592801500824950700237454761819087994384857504238702080884361451737759179131480265717764778487986928534341343459562198013665922030341655868415090160344330829541989295856423764855695971310606266363404148300713843556851919675108757"), e_float("-1.4284237081915537748544092958057998731464174944936232283921178790800093364709405732595818881839659772547064152278746066256812504328627822027452844119773639921042395110013059687486488356592492764120564823584563602511138512170459259288056691941215396135726508737106362205829849521877456760936073772395787634085668776692845185881011486094453596813330178488621258138966149677850096428363157273041545e-6")),
           ef_complex(e_float("0.99999977391192498641864038088157681940195380917442798378516898168014091523345849390185841190229029723404343995550869459910894306812853339326945174936470462664047137814084003491291572980092903707380463242141862755500898770628768806352520034065973237037540869175060203614047728153423091672923773278771570913074128085253237794380788099945194494984723085231097056838764154766716246562151763975794140875151"), e_float("-8.017692536476508249197160857888208460952593696688223578911816103340371374351128834421326760672727761457674867784649909235437952510890482598640321552705167439887991162359766310911537535018022466502756979504183014192181951687089911780871717732404747098227376382475887368372978489189608689194145657137899838066004227290586732261718417887748969588718124101974080572724759577042228695593693765575584e-8")),
           ef_complex(e_float("0.99999997286533083083257695689470251735561058716768723727417833414206176940458806000158930000384687024088865420586051073737991030604359570753502467620538284393273673878970609014797238672541278381514433334445740017638236534865324783831467332818121427624827920180482342231421801578540148063113376801875294047342782122341593939613390758131048784734453919036490426848189958623244377809591011293253992056803"), e_float("1.60842766695290725846217892586801665484031148367314554120262769387480674714808163734329547025747416992249876891432353597318756330251567580722240683233233037404375404262803254530462588561973690761111926369873371328896814318425420073310882928462910956618286813626977320220047866254252676202031487988580644764252548701846560961577784047952335090238195589277026798053481726274979007008187492805863e-9")),
           ef_complex(e_float("0.99999999723901299762512285693899316485976633162398667176789651984746996568579664722982668710215851603613763288848481526814549296964192007682790213908700557675073835561852473009489721235288587816431058102587822331797605170701422094740990748667238123184821411211618681710259622046807530770271443710582274695207180676989873768026649215636332310022347451669139236590879195165715205042793828643795949027513"), e_float("1.36543567177045886478615791048196164323532604642993693639944770941892197324551220114199675107889009123108148513224681831419002095945540442825240221030464272340499977151692856240043458613286488186899138226535787688397154341276100635905300679797889274547754333257703733914913906345463880660560482682685100500707681027773446593570604592616210503630059534470384476347109986270075579063013098271606e-9")),
           ef_complex(e_float("0.99999999977211138650846136589117388569597129048572602585490407359581498436383932935117193149537835628516225140755546388134435859417687680055407535019258342439197529018278107623690588925773491238439774547327876117977323728050645438443512292989350553219801509469767194838241896197404524554274173562747340936351557971185774036817771941724181815449805210028705680671649439776937467823761308115627217133901"), e_float("2.6436488325730237478222397414431160344004894156629714104538818128256841052719780520785142492510213017935407058456285674275751409812436955639664039298308202882130822611966327091473749073793588563983066606820052570009722659812895039255428780817899537594588718787186643073512841351787085727886680605475565695996294609752199027486962277078888356701479818703199032746238867494404482722431522813161e-10")),
           ef_complex(e_float("0.99999999998788441408460818130358594927128766363931622383272597660377169539299594117579963183466457866411663457326399854161558150500680470838470087641335058855115139077276830749070339701967647371911064828847882947738089469255790141316407430286281208183201624073322357529160852121351663640425109297023899516354048337630147388755286197712468126884044600481272039750520179920560308936310414000488683231796"), e_float("3.764889476792174248547660869461230007864065284813159607634237410378563901288029889351209658157975819789280361858370833509340975224560238492516651562374635808212995594819461650875091764173424375455390949924727443873430676352355930840222034259683185666250746494212934812948819342299500525194175928342789523105819824562778086284130332474764515681195483772670142176927605401074731007673251340233e-11")),
           ef_complex(e_float("1.00000000000039725000760272791977700396011036686374090976572357092159264974894700070546668073486649024235868344738073429975811123788048963860643586726313720801563584248549474487869318709201097117674724110014190966819214268476549537927084782940350123410828665339320132030622907511565467547788440294886883816797240729469476389799645307324194159505931601252908770385710592177389495234255721684215627105105"), e_float("4.46399371386816917465494026456644181232299083935367949034575805801760664641180239869359541488289786099080342815463756810805905907632438381050074310708287282599036714112066936281280334764608382929424417957037198521786102916801828008673726279378127689139164846714372303392299968764350069579342847462785329019312061079227159326145723397227935755684936140345039469087354636740401834577075878163e-12")),
           ef_complex(e_float("1.00000000000023848559542150662882779393302776778485434985807216930504115420866965855196247956580304200781533018127843700856608806033888364451601292205182434056161138440513770091237424233999665252661614669826855537169467604490831070604120728848903096509585297525235300107443307032883717472949927542650519491606353063617093334759514564236500735667563394819754543777540173705083174741669742337717977369052"), e_float("4.4835398913938848015205579842199398003107822491075713802143957556593193793321686725665854072836421602447908824325125289630292242396530538459137852993715781637229569971134289349054129611208208741305177341804158162318421010699946322280138833174979569122608916287367321391087457544748891608611337840779752256664899656306955598083881542197407017061448083791147310197910930417517368337900453694e-13")),
           ef_complex(e_float("1.00000000000004467859389521778385363902348662563468587010980584615855758411920833291252715898319678930249323521317057112432164983444978845664454525957912792447897966685823444752915899377338811853477720976275486000050152619312060531993742492799904330384013236444081153736935909026752057170091840275451966169964320259854879377850601619464031866162301413229108776301319743638706680810170522807857012694763"), e_float("3.626673203952247653161103224074233646031385414659318380996795920268538956731690748325681297793299423119320773324198246005679081183925934245029743699750063375968764940282782689380477850775303603027266011236179863247805377836039162671629126934676912490257427276281173598047199712615602148858686027508523315615725938590161542386623901475874178628505556721078208701222163498234405276257205958e-14")),
           ef_complex(e_float("1.00000000000000626360421645859847034847479792814539988374069239710349270069458790773458733993174980206132619550215527150826237152251712639730542026233810658890498368364896074617604593224247278739106518387338612402135326590886709937436362836722738731939189985379489312915395414501599344698840858285436714624567162703670953400905318677832362700866513744817230431684235666110113018790517668567360794862709"), e_float("1.81302830616615646179044326904336621916739055539775936203627746368107156940512797664248526629947508398203434348964373500080096591670073171649696302275032488233843364680580705236067750681946433624666580272515078537434028793572443377109357948236813471020076477645499043676276697188000580671539898554069841828817210270834822914547173727269461836807553341164558644802073824973996519040082487e-15")),
           ef_complex(e_float("1.00000000000000073372587759082245084282967082990227170561689269523038705653008358751169383169632323862622225862833831275822870861717207311402876719448631652897965961777978340105771889379346639758693643907062245846300898544828374981498937108839244552920746440943651981000889606667267367330865747496089971003707428984042439609541299410940736106100104478291897848630886914649561875209701551275526688433165"), e_float("-8.723767244945718355819989323079843401321648289935927654509963089197052987904546886742263707872801287621678312094478459952723148723208585371511651760370781887582431337570508658085458291968360822644287654807715255757062564310701812020579563736863094651787387507477278923126096107699026202521019661639168916739223057088571368812015412534110121766229354327141715109964642186660450846149453e-17")),
           ef_complex(e_float("1.00000000000000007272532789062205314021568044375463873903483245365368716366252178667303080662129402921905185167144482377624205037747818702368310064003789533362442284347812389066557297734803512127916070900280924801804260310389841697829384600952918327571454289834782532770635650487257960585198641462262779460666665842830198259710877072143175252562406801726119876143375612051981739052834890484970415308443"), e_float("-4.148891660539588470826150424608176381147726492542175876787331741392559251207236424635582003530604232753542919064442859946265061118965827927650221294920949056661002639930710024049334835986125271850894058619172041397948906917855376887341213228800625368483115875934714746352145628878228733959078545505499005211825652618148636543483925406490925758971223021979018516531567876567937173283777e-17")),
           ef_complex(e_float("1.00000000000000000575883252467430582060203865949414178216279218863989045060235844326965184721230295871693297108154311026539723807943121246697977610000095850504380134919321306233829430470198625834414302035193769369601005742373324540825745956707582892296200200646371038911861994754192608881628198674403214188570326393979934727475946200179552843671754907096857704812419815978718168807624772578485707357912"), e_float("-7.53987714778923561721187026159160556271995610930594337676115036787341864008103673767073442173076820463379725258522531151373956321895197498887841889438163600017841932525030652055784686952319233659192272417418975009709902810485385451502618653330243466156296647072407414424903348812374564767921669210898938332263864413198073991174957613483280829592570253562995401471184546366621317020997e-18")),
           ef_complex(e_float("1.00000000000000000026823783803994374080175547843523286729480127048667872393608338510210747683804938011463231351575527998888916383495853836493462989515709031485601146760260518314156189032166063932786029960965239675867667686321570397449174658060994110777845414737866492064050302256222025398693999369446190524308912289152020390304774523011628372486387188505361024693899867173486941265185255123395024922619"), e_float("-1.04107997025610987476139302067158778144800877814830042847866763358340521996711297285691551990216780653605831134843105051065106760988950195179643462911819232466014077864324982102385797567515875334778217687362372231251844167205184362594014899541853897533654039991215799385207437613052206778799635197279277645252207197069572434109903250106174314124104764106257705877217339402919528410824e-18")),
           ef_complex(e_float("0.99999999999999999998204486352974670470429080529977832796269423700467441469673219077243312006663945182588080727527367704928205823853477874965739379011373352415393797089441848167065394832027895500611053210447780655637367885477785994433247350392609678937882486877339176818478065265282963580685778142525292416751210262344381146501497939644170407062262231925263114761982172766284530416694348597135666236513"), e_float("-1.2049206173414806989280168053684816914131236706146949086227252552020346360505783743701922642904375189746143159676379754271188145423451605304231774340694131663461369740447977156370875766429131821734764814316323785565914390018866845544157012981450161840467811883552105147645431898663823831411407305667846359125396962533759034749958721711262305753958216687156199595990649801757518203301e-19")),
           ef_complex(e_float("0.99999999999999999999280796877274624406078710785207779645544609376740733677849928322930597073348557223896997759514829348095590936421718758979633551179029815618919829241964575644981048490494964931740944895396331298162652535145358510667154042436948732994892652938131350940245579799483682102845776467941005742052315963767957666887169098316934561556831719611598300323625799756929094688686549541629573495192"), e_float("-1.17827404793047854884823986791877253448840352290817106049333851747393021294744291161359783555177128757322942526896938857781370235387139864472687209787463326673482967431096826993463867468244269606151689072631025449832691793712353246652892045477315587320050886344340612075081954833883940163867400920698207006634629095569645744350499664281619283551626315477721338991162183026195072142e-20")),
           ef_complex(e_float("0.99999999999999999999872934718887442886933876905165671403712814492774634049261035395333268204264744814506648905671282459077545311772205306936461580263498329470089614029807031439263720909808590550316396312636348991912013410947316158871237805953313707132723683925234199546435226215582754971342376648207729550828684162725810082110805658152655267909057071657048567429513553679272171578104133725619736303264"), e_float("-9.1227922468566034709645411461488082266811954945773719967203449517328512163824188866352458392831294456658190130510139064247379934022489619882840556777134949744624551930856625389985154067973389406071271392824754764283840489352315819546944081192118656022571019082163583841635362390019397549806704974170953158997995198147653027925975504634113418636480688878323273523167813197573612196e-22")),
           ef_complex(e_float("0.999999999999999999999827122516661459760247771187312267880136763688950345638719138164738603357934583162645257860518960447513108479621499011541241899490247506560489992447595091640728805884294678586853139435005819275853981214700189665029558746839466313380436805747958429490297304011743511452779963486825252905054193310193657846575251665690853725335973062512853094139959562187470191835809242889289338476"), e_float("-3.912800055677200580354775359160977123810189741842541692810837252266837518215070184000320968940400585757356207516538013052593006507034555374185236416164070189315495113987149449693797271355150690631064254074889189221903199788642516930123923802702167846122235691660425499949122477860778282367276645715043631317417397144294866550859473435527026590977039137127054921950188369111118566e-23")),
           ef_complex(e_float("0.99999999999999999999998023055856806747593753346053239392295021363979678589321364127696424307715493984237232592422751651477049593794516371429160184303380539339298942915642918409325569857108266728754478608462240183291767184404031634656049580303161550315410473647700076369362415012845339484420378897151095557642911001945262522150676938077403811313830172691222704045840548673215288830844557968543540403596"), e_float("3.54664164268550549707276663464360593486891100710711914801605017213887412885114754648612575049714906366047553737620762682639583596742018569695526650761289062398006171026828965644729633677764397469381911914941034046102245337992439191181580089885417070063551777584032078096938178783056344291005545992157834046828692719670547283079201108642895487693105208846805128466242852801403195e-24")),
           ef_complex(e_float("0.99999999999999999999999809328837791560460262602551843480661184349247108364457400651521389739247025177308249670064524281301738948639376444613265735957006210774030592352636018523161087217213807289363969935138192617780901041574372087759212090335724296198556593370499878418060656975045181504653669716977763641305953629488757705331212776757270985224493274495659419337594756473756788561152236655622080553282"), e_float("1.24270701847294212864645511616123434134003455451319239456155059875167458198588909055525414250094654130714484232852509041253513804270009902232112500201052780132217900319977673730644217095264960552794592050273532901543881386040040553309379090821356213919810359753223419785740063022774676133877350597858532378131290514754498640832906337296539910681040007821931101350828559432342597e-24")),
           ef_complex(e_float("0.99999999999999999999999985585405847565770304108153605130024859556708839513689592432960209052765426231464078306619381250259981615267114179121854739195597210490948808733275762227306752868657945277883746550331959895920491296543471068105053584514568888995852344224270572137395746237818631413056577614152788740539080503146920070983442978615111468337483172441364028366883190421071505956693713780049589745156"), e_float("2.1385196165802044718474692427516867568803172831062710796712294952044930993829546407481804248745922177734739562429522328614313997676569670658700802068162984943779597981880105249956793396427259457389981994035577432242778969681430135096337746004919886974218491429895287274112351145139739159059674727286308122539422409264772646874530041801603699686015729590980263343896389787176677e-25")),
           ef_complex(e_float("0.99999999999999999999999999439486651309736285730887850972817702353959989062515297797828026266200794210629704361917730519325132816887241179799575861287493947468282283018242501181719164077039086432288478774310984757661154565333615317378624791859434690359009834673357297210876751887420741499779525267751625135765012071782269341727050748258947713587175797689614925247976710836163708929133276314110047120818"), e_float("2.868092131132673441238787119220591428416088996351486986693488895830992004621685215326670320764875078682288196624698221849009909439434166356127911412210988676262389353860978636014187497925134115914099641312523108081422566284396771420859600114568797609514308052501052295210774958263268214850099662864419091441766036192986381371767904442832122560951475898555028505455246899736641e-26")),
           ef_complex(e_float("1.00000000000000000000000000068090093960072157391339855652051532262022687737450946627429201181706831514172964658211293249942702101631572383992135097565928664955566626636896669387070414579563272566316776493111439966522967981976109989402857604181291992132968657590225434633041464673143381811550739085169422472693751221058223213351568101185619853959628812969182661347939321342805490626681562829744203943003"), e_float("3.24069329766175164862797107135356907594843080398516924765695828824704855085731019594952348706743865459452956196045546346366505943907818633396610687970964485400244985252139684796177232267365943071965484602689559889546216276039924924214786558205367442841402336760751195505653112242522384224094546151366352266417392918572753619799522439029687843170293068496140658611233670610308e-27")),
           ef_complex(e_float("1.00000000000000000000000000021409642347576703783138198646875277802304651587007284383662712284488575234967188365970736702451534604346020242373096544667287707652913771707289661901222822477689357408299111266956300145955612354951142754213688979228775901132883843914461633822833007110100744775220507054986119698800524730420601825821294882786719861249696901979665795733607784202559110277344478302821984398001"), e_float("3.0816401716565701171892503567253103920457859643888718152086129089563792946471868706188486077019803984254798985720648089799994499331490625269294213322746186956410974830514283924627330743656947738268445342913332353643054893316161172053657305852335457923860958823471606087149758123369108530880139433321406080107575708176921149840066159503858256841895099549225453869469765308543e-28")),
           ef_complex(e_float("1.00000000000000000000000000003594566656147865064363650846195996270413479440813913799039535396847321367387151540761023666232933248285960466544539088158303561421997252909122157112927446895359423219785553882649510924003728034666208871045937571573913714988298037890331400663941381770442181315349390107749075759433111884418244864414865855537268411449024756247435659738953207630161315538579201977534333654006"), e_float("2.271218356885304825909849025811728626005051233715911682405427837726351014476341046648322579038478020831766867573584979925419822855349629949202237940481490888887772880708868593333900534545027942273840800298434104763794641741026850668674376715837415821467621747618107134937862678353834867686264521004573196296014721182760826833851877207353577916244756747142740281713258021202e-29")),
           ef_complex(e_float("1.00000000000000000000000000000475393290000008428744101821817160958672478115659566146668166291992354482309461390068774152276378311906433995492784304499205607575633038481432062621652016218567611295345009872716610598704740463979939515277091406019774442329163813360566085595138940987333723618743564893075489642020498501289698221223662572804533819854155244077387942668307873065718348005101572638260453345891"), e_float("7.83843524210758425814601289781625586688239101118132468861843628974637945787132622404388120983850810880779183898334953215817141792204231781396520402448873578275890545135589589817158384481623620288804292459681882401801938318080406678877307745964709628228325111705172629300325157540824663815128153765495681642203138337188091930951456626853958689181933592330393900723019469e-31")),
           ef_complex(e_float("1.0000000000000000000000000000005307432529786994963569002705570447851499059529729328616393422948284437469468176728362603213953290251372276619545961731657397087459550527542742842907889176330042136257350067959738808300517468380447014938224823321114253165628497834595835750110931925288542992531504515993172923735260675503080174936897013043054407374380660328918700187325295243165608667573262555272072309102"), e_float("-1.2801707669871816497897045057379121344379564634344549628443697064229866529034164930815101930792373344257103399043755367150385106706148796119866289323348221170418169976240102527361846315674985572535781213341054906387941305033224392679684788908642658470583768965632691194211152555331889027714042382067894071925500225985819011569392883880993451208963141496531706708252619749e-31")),
           ef_complex(e_float("1.0000000000000000000000000000000497410585431920776651648369151926278422126888160653265078510858827843148369607410102263822339788264187127338062572105749165855270384146427638310432243982826276549542283729349126535036460319657797061108512936093094444424492035300548767893637526654179839491064177761995604907095512294864758019904981323610765894024085953586189100492396373966691897466691398265157581302339"), e_float("-3.678588018654384778066903147904617785627314399435036945073443341029095250329083961902278651101182406217114133432141446973104081849710724372236616820475409506856522726425939270772646149891981188567358694111599760083680330812724776883752040128762742325675877000237353549083262837379482147665887340323830220665635144091065905713697358846769184093865707690408541844070418439e-32")),
           ef_complex(e_float("1.00000000000000000000000000000000356764311405980063747507193770831289176785782723786416532544575187878758341978600316993254716320758796897009029037683416267106033546228535168073068153396633430767423629317538289534698262026103888609896257953430769910120515802855086760715100831778947015908160636163380470135647677471900044805718001739466035589992464548600524668380484357948489670441678984613700578441316"), e_float("-6.03459013318017002463852842121015243652870265111168393240527195001997718823535507534334395613157900655193421393382099302067263118437570344756608414879859759290079879886176037560907533938580866821871734427182510768013672304134025755712920971661004087364692235297932830125574128514320239701984602142084471240600483978475186466233167716013050369953689326155401720287480097e-33")),
           ef_complex(e_float("1.00000000000000000000000000000000010599164915158653965294093252050643296849675523805009219886758794815098846398814878686855854979723968271231223205526728191181992320809965772123309812621145734019341829082100716513293394465591927109774680023614365726239089602268393354344328542795783719955843831396243068466874448360432624998177031118711462601734158337588621728372769740658743097124525009001143702622456"), e_float("-7.8726776047917663661854581831869288590655748198966960512038887117852852809566227431493373123582610893850076779812015077164718472357649712115363586889169918453182005502052071926265355835344143486779754945857820238824264551393653284895680821255571704351571200277951779248544523951445949826925872704062881582050786034398826402706917413410847333285172566184749447480573032e-34")),
           ef_complex(e_float("0.99999999999999999999999999999999997631440462418699752771905096768331243403804443081247992539313961863781892899097549305646254508652294272733875091160506963429755406106400853788178965454973670834809043058928353411944464449499487099095258239612706594606159924564783432228585235548055547251313075952370135352659747851925076970667903405197124399436577597158623173423386157219500851817254874751856466712724"), e_float("-8.684177950606360089784105542153410474251792108117311078552187511817124476145367896736606836079498194560275647515135155282217016568814100898170809476578152858163116881583890311085350928892763590051703923124235495580779185560822794249830572060378254135592845630375234836297714092258003978524280561972014683293556680657054125455722688691239888784916834007056081279408292e-35")),
           ef_complex(e_float("0.99999999999999999999999999999999999369512170789931557445160537947364286207594544408354649556979912445706435349539920964944384832737079372090000945429623411993431405347305515654883861312557891057551824007646115150880987586624750899992539760051639846963360694681943503061217715371373316689473604202294800805726409140975526290009453695229447589509681041329774441878933678373765118418243250126291052783824"), e_float("-8.0178855383983467375597864220618474292410234782414555562318966406640178776055827359930351310641751906208276212417057347744993521561923233219884823890170605076398802642698721339644734268931305341930388218276306794243695963974264251725196294267568934344664480807636915681161751784365529027535384242066342523956611121831074652426143376532684185392182246371754680185855e-36")),
           ef_complex(e_float("0.99999999999999999999999999999999999898810403323826112958549285646564919821423998288298963600780760982483156792737846590338465800720950779282294128762652757407909297507541150404045114490045552287856978476994191422854334719901616636557232216319300864023601610186277304265939812237150034722788916638154733366227617513985103535496022983234617760936277318301400757603264285549925691072906677740988800729445"), e_float("-5.5851408084519924572184715535277847307481032226407332784819617187432459569653510429170356887080192522704363871314664213760123350060171823791079640202975633673404396628986951537062096794752030711337357816092765430008063939244273681905053072396968832713483707254093224959773130074858663290909109858890365197352643266714871443493801637506033362722528821938277251869198e-37")),
           ef_complex(e_float("0.99999999999999999999999999999999999986974188096361000695525134542416398465770936300699570091063534104940726002140753102603086347297445947905364273077518055726888332269649946232922252340830181716971546426524749042215163160456985876719456948311371984296442222302460456608527125842237078432547157572448448428570333298045691775338215054969588365128969772330943125481764065440726933218644108518607475451168"), e_float("-1.362779719326260388298417489850286792338891950523215817894199692828111889216502444501581479390120903136120410542954519825647514932621922095745906147080232040069733200692073805254513229019202042739386900756240376105828073089283576684406235369452337581374940740692353102499830574273545717127712551852124822317116514198462220302491691914936050581991852214108053389105e-38")),
           ef_complex(e_float("0.99999999999999999999999999999999999998580404998478655752470741111612400939707817319609424184938729416498458817769653891926791055988618433874802160397205967093821275435383226001702005350909890135961228349746036599444277436646841902985405648214557773134339817229716567656927577513516330251723419139141580391680539591244546020540525089409069287975438450508114247862948575772299191533323547766864428171999"), e_float("4.32690282428479866406731990927481849624352628680060263439582038753215651016588371057153318499687534700721216787645963372617621166774993510329181589376728359294690548890097165393020326967253490274814931912834264808170235130083675595851873170591338727933105462692299988084864723070877865594283745485652090939710461149605022611387263582570190235418711091253332290313e-39")),
           ef_complex(e_float("0.99999999999999999999999999999999999999870940720896594722990124589170491487177793847193941082472972665373679608261539169726891277406904204929105937770493214688940517360446689588995477965246746546681635437130004523602674983928985652227321786195458037686994650799040164610132476518564030016137516039750001788141989075414830271114012974957402908043559625756181608829829119998597663327389817410010182361413"), e_float("1.07814338394162542728234861976540191086440241578850242741678157976595850911046308995124807738963128846946559026940019807909857969302686970097029201558454973397803607411042906866486625064627028794168431433045554682042770326401151392708575435802078534435656657255772804902388617826953292631949226601274427443411551246300892134240598986923864752625111925692331895287e-39")),
           ef_complex(e_float("0.99999999999999999999999999999999999999991289233997203154977595168474037021833092816344260469064313628586948817660969246521980796722101980417392959635554056455256416721723911821449906946370686505001061443144525707975763189755451120959120242517809895455460250398024925593735881216148761098649179866231005263617841323238618611671102122734036311622159078216190064853961681635813906038693389746627303598128"), e_float("1.6948367493982118346837707151677457959261483436185969719469360017772697757678451845265176902982367945785565448986967769604218392083834565975518903617326723321265091645755321448542099155998491158800304220900615581810650036129159458306980223012175948223647817693991834544060651908798884100267051829437267793746401955729281064712202565494611002387968468659992896644e-40")),
           ef_complex(e_float("0.99999999999999999999999999999999999999999838942534754568694626712900729258495966702328863473429635702749008772021746086773265981189946504592767226888407763600379157035873190561463015060251350998431689078756402785394263558332419725978805107545045641530299692525608217061871679698472680229253573287078610319386266001587703277174325954128932008301179793197216837872043521060797366835223505487924832995728"), e_float("2.153291298469399552380092751695554820440971775473328868974463487106437179616570212931543710206671701650316291113165855171306352453645571388433892979125875197616470289718021179332832137294239264034299561282407620832855942330152247131524437932026037551222432013150543595011105302789974114312980779625319413850374509863754440113219517617242149592778052747763458187e-41")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000078230518263063740765078562523769472247640961382962519026923615370541280445605073824948300527092967458671564775923824028174612768957854144443587396973692731991019574971526459858328914373919238923232127110974449934698206173245718032691548139474111356903524911400047201334382833394720308353518736242599486453380911825697844284716006951664101320598238709022067305"), e_float("2.31838032275430064323443272030901887578977251501145032117547511480560589086264267995748009905987910694571766162596397360898857577809468224900827810415647338217708892209497508516237472151036105977066063658108602694475378273705295877809715793230080296489602871291786633462006817087369256270572403538146938456112409313246670604531908174876210162894771057045292899e-42")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000018397159817308170385833824616694961738325268245626573292954800733465758632765847585065489276302419986790173467677350231907284994415646125012920194199008296430313950817851870209654438124076544392391502501079255975195817423161193652799740591485466380188582929908582349623152365313209266588431439845766313127840241648790914472245855078856588124326154119562806596"), e_float("2.0743064036665354952000937727645251040620106540581751502427375290929556448750550961534607184663182880782789616557849311425633204125300382991524375841430194296273690090173768859573664247910700325915824418577644222482320785339537715177041827079116159295795374592149521654489560814515986739874534076391069361886195117989573368735624365412680281366997000263458309e-43")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000002835562381789385515552745920820832366623702312036383086302391470208029203970330444495216601779639636785136688054654195380701356230410000474483031801863120878678943604545049169212426839070996002322559088395078590473543041467216839661337596340006996699608500311991785873796020015813918924459799166171027130539477677027974012060430394595989019832115220510273822"), e_float("1.352870052863592175029574142212393024817506993663591526866554402881127424756795776756218174223661601702729977956662878240642459390095503858217190894365683856435083981318453937107247135449403763091624904971198864531158142085162080067074174278616152374929886860886957158247712786218855647644215349306561524460647548245507047827711308662929124901181771408178772e-44")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000000355646427793029499907558966074345425248383684191170485272383756824594517554740986763647064236764816338024585896725114210300416139886026658213900441908353652870786768359284332491517932469874950569125200735161757132654613983101413311277076204787748430055665687732936011931259668713957346637455632684471879803366377877488600926342589148225845276165416641760271"), e_float("1.6040423386392288468634792153160798689263061212275066032611947866339567597126805051444173819333207196136078366277489686888050926068747305451911790577747343835252702968016956419776175621297674216917899450422003457560996529395623560037770630354722802305515667167617169870556902482255192244037494569105961502979835558044778350433580529409537106446812752010939e-46")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000000037825214758893875534968343720722240504103835385207245516396668077171527219014331177212052744894758070797879683955479132942140374680178900862382827486978124531640044572736256824772373974800386480686279100972926160356076837238868353095215265080364391145582048241021772109012862302895387365012316246135269335143531372325829178097589212958375749058359277291502"), e_float("-1.4023024847026117371215918683246591604903884628925627691457463630050126712992118017289040995930218360537042243568739531585372052622213073743386232072639210712256258894252640429250028640783543900307937990374153030499608432306387514905824333451198926527194686101440133101196712461583347900937639081545863522082987520049717729136379638991970270059248638107899e-46")),
           ef_complex(e_float("1.0000000000000000000000000000000000000000000000332871872790057859230761123008698328647346577126939032925458647739008167369983086644742906168795462771509190748485611246893351800907286539131131390981714024435578092047302447366641956624027695649861831384211790874041389679905932587100956951039392970344472359480573557945668357236574368274507661018914226774123687455783950012315329249412096916715756621883"), e_float("-3.133004645822883450755484816550630114251622006002036392203596862522207564024821378647392494621272840662628944054601403530682473338085980977954294799229156837384798392439043555023703738927758199825379934118004787421812458661629815618371762655201440878208041940738455324510491179407305787416345249108818669533465836325636828263155144227923032314370172919082e-47")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000000000209122847602968207951942153465563515411880692487778535075607420885520138481674887648025837710615171012374633190103685256573104487398427670858986501962521172787939169425771678206464672708082326015509213094604301854178135701414466095219421291253107420520836877088958239716586752393404811329541456469701599678602272411330192103233832205686796708982557592689"), e_float("-4.73896782993631105508108283934584300705316661041139517246613645573838660974054654013522723242746780247559260934044875927766411085740148837496758669803073985178211260622691367863180940578936590786084891139323158109688549660293179413159440821710929689036202757285930243255283009428532140326550192159554277853098711159820418248632719834430386142182630329357e-48")),
           ef_complex(e_float("1.00000000000000000000000000000000000000000000000000908940831412830882813209975423722765470407267873602037631424638441612095407757605336236471097625982553617485583836917424051326609134145637019094327772938914895415356823770700902454814911929552345928853079059172256543128417500379744360310231826582200848801255118814831146781392803253507396794630931854619961228715990795175060481874547336749711738781288"), e_float("-5.8688519391557438034127048475290730298692056825328218939084143939254648816546305747269298625261036477992245346067096344875954539952944456490355785343286623783773519776360301750424530533002304381256309159204379701683696753610328210936235060980425762340889970631939575060000590649533687471334746035174602207523859069920066828563155152400745912235503733582e-49")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02902_z_zeta_all_x(const bool b_write_output)
    {
      return TestCase_case_02902_z_zeta_all_x().execute(b_write_output);
    }
  }
}
