
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02201_z_gamma : public TestCaseImag
    {
    public:
      TestCase_case_02201_z_gamma() { }
      virtual ~TestCase_case_02201_z_gamma() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02201_z_gamma");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::tenth()   + (((10 * k) - 250) * ef::pi());
          const e_float y = ef::quarter() + (((10 * k) - 250) * ef::euler_gamma());
          data[static_cast<std::size_t>(k)] = efz::gamma(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("4.4264277960152618281112291756848601571628271238933377044303008216713379785420988546674745181833639848479762391610051652124682244946040399572650941554087009646526511386086283667853042460790794760935118511551859771696699902822231438108355017094065631585439066997089629111545696843914527166064680037299145051480196214603495461533455210540982531252904138620895394541147622226644323300417312921237022066848e-2125"), e_float("-2.2476087015385289704876329678368942516383216499302033873689743837152634637394923993909563777377614916548975090888499421910493420331328464777390973380493113371916208854975007755256317928259572851126035144841529281140454995796503889658000481720278467390850076545519659007840220572049911568690703359453902157929035214622772839908107480706075598917530146349376283966812336507200883469028227109718951565369e-2125")),
           ef_complex(e_float("3.452621226003181898307342159654187649829119979466148269879869047225678742243083656864767706876351009559984511644230497419930148749696139964276383111632351791058532393738990168331128845960234271656399614624143360825457292648189631220375188382367122756593977304669471381917764669465171924937863424055998421257918184238564140021817710780145827557713595327199939785603232837012047314786440429279448682147e-2028"), e_float("1.05790709915887198506259916488261352420223991373674316701550432823788237628510425246737409617997421307584725827504712220709786111730950685195528847621364212152065834643520021100084055160104480380992525330271381482262029819447643303290840361079799944916214255344796056449744871067153093204138890494639212597973146189878342955371581343242277547372551009562602374179944996648575731991128430638844860021983e-2026")),
           ef_complex(e_float("-6.0159341057994567694347314586179369080050577364356466439762477671868699142888474361400870533797384250138588059911639944937860200940347939502641151183134297382444869527089541586681808216536783622287999967544496699368298830660793658606106612117937291578471704555951798619962763179043234933524874253874847018894102293112291336709773046367916917316924559282982769890173051601295131144025779762704702001071e-1929"), e_float("-9.929892891629750282366107445067702035104231057730949301410933421519416258349052068847919529160660276969433363525012237197853745779936873303005447302885790970380630585466726224978342158116489476136796189190745818354542597674890762099428588980896260571122469305465308680476726757140094296069842784846459582936740140891289282701436133716402843040211944205474598050841948774246541530578093799151326882864e-1930")),
           ef_complex(e_float("9.687986076128859255586296352499428948770918278469489540932566095225994354760926747162758655971205324654394310691849532765601725687579503818490052453516501906697586600905833364145676435623651094113894349155032004165529398624730853834282679761917667069973598307732619338665123375848159491926894272118401740560847529337601114661252828963214881384069300045846348395296649498981105669700250675668390910576e-1833"), e_float("-8.9122021410802647324826212052900241960040469534143228217530670655214950999047375328994470670145836416799350506134490421513848880746390980338400517349487798500075211209713106453134958723838263728925655129499279702525610689916473008914827707438301642761169803817382651499463267150087245089158348813383956495691129481464607732463256136308671293292677427155092394679769628513128815575683503941337658205526e-1832")),
           ef_complex(e_float("3.0921364754168132237226331793450809667086550871558664905017791088541411995259800678232796470044921011020917716331933203271932123200037967269621007451490688797279141068523146390867467911194484982626144507778573885411639784697664571508493924295301995315764317206837487968220371743980759646907183414698534773162754527574436072851519929081166066571848012601882015036056739120133563808591759366680152710827e-1735"), e_float("-6.590765568385188027831962487180486831803195249993804805030979010337382485316078733011866848841359680583803275741175668366321479626279635236788914680266180074748035851011781304870955152724294845890440007429286588771956477480072572332568640526108531250150462697334100952934672621257201373362030200715458031950397569838560802101173831607831123925085348971637473573684387091393381872758779156319730205508e-1736")),
           ef_complex(e_float("1.7991322654020911750923487497953730946872195971764003702238263569300954266086376980065243613145022191508571330227329224436888833497156708137359586773231960219380726218941492519444848546365796897173171554052123369853869330163092993315001793036027041606298995039443351344381374204241939129800504095969050613154179163352489854486457562209928458178791490380946718822632588876073008432781485171297672741667e-1639"), e_float("1.7340310629109308440918358510535467430764754291623435934778766710503747820806243600715788339285731783840852529852187544855855228958984716293297364926949237165564112695416187713401826445500543305666745684038446501446258394533004917424368489687586258601536932018773789622320638874748591414609993795573999426591191358064604423220009688937490017898546123335640183221765249586304468088453919525543842354959e-1639")),
           ef_complex(e_float("4.761220854682675807073405339502918310903327718087854257105843134580758266092882650992672239092158843653842733404162229866164603397611674622626664182820995078232989371290073139210841446022670636386732778148680226382281965089518543100293994369391348324892164166876693226052460235737402982190014997236381840114432335612575280631789998089125736272579934395769421162931130500994652814008374473936858535848e-1545"), e_float("4.0790792393328792123427534298557247370933418529414664664019376094152864560701925329128902802104750931584002841788022619875692824766240420543676234850927501735022230286373540608622494026244142841170272473653736370025746614832262078628743837352751612498758243178075950078918446689823724734059384972732563549079892520737120915464623880683474830628689628984428974043041020825805157655670288335251001033509e-1544")),
           ef_complex(e_float("-3.4068441750111761509713617519194263095145156704124772441317581674165459513862938822931009792602211276625295098707787466341625362079260807513973194857828882384620443604119795014059360520455666885729278202061027491242592652613678632124304508624948605346374196771934251408604487903304120958087474311659421062406659134785553752116979371067888483205464950870888308807030429211556393514329461482006055707286e-1450"), e_float("1.24650052204382798552940618788348005841192567974065171073735355101896624726435015232731839521122443033209388640271484082318756067363987510817804437500341106497395940170591860332155395241703124764198064169650168156321464718118826789269306313187279408178820531747848024043454793909209309021445760776404662058657762588438291534237008181452260267833705646674974541857441151654495643613263870768911469495711e-1449")),
           ef_complex(e_float("-2.2888518013646487920861805700819838454986838178506963927648647453485163654088638610600138524017849029704209669847130631928149373595815163654895928360456175157710444398022659967082640192552661230238015285701234896255828056040194739506868860169499018854340595618336620576655452339810288977076547702991780317166452792253536339641910569685914311792073213603452869426783823449058521432806175569850549050962e-1356"), e_float("6.722208501930499254757571644267492278179565896581556720029598079448595455705580337316322333095331881476110996459934722284439768260897183608390349848494408423773932030906113203461884520887593679858802009185965306492621901053913771851431453708218285396985969034849484558575861412195449707291653256462805279393545334646724194631642945827461829107296000707216611535351829065592790658163126667578142680562e-1356")),
           ef_complex(e_float("-3.009968290293309862261417530549501779030777419551384745842420364104492558974625086008724621751707905163718985448643982922168642636783364595685552856577789641655451734776468232507086285509428362594376841067065261471866249214990077835648069912292991805578920481447472390467114132856730107659390246665238830933172014666363321599239947104853429520578621687001496367588045818572678117011941332249567488634e-1264"), e_float("6.1428530518819479941659613321491301932238178354709166025293422595779512861244936166113140450101887137261378211644352963532608151527496093868976885867169035123387388084277076231626976498025809747284162134979742715287391519955117657293242918417636677560427022017847501493436176595595502890426631711589667533718051294237491045739556818261033253471171071113370534702660424229979906885094584927233323517172e-1263")),
           ef_complex(e_float("4.1748297025830168375414308761879481744866078532395879346659990042562190657035285609921696507848047254015516169500313784048654380936955227861877240047516162339558542571645705463654147867841263177112263754199613642858197618029876030437138557667126720847141584219035616588870505082118356385449159530692617733430127709160280766519548097964774018388699181735295014489522301680647764743744836530573358233922e-1171"), e_float("6.2052493396570503006574051180506977402811718821015863999818315534270465889156437079369356024249527920423646652686273679530612426719981001765540325325487481008820453328717101415465656972941023484553297250245562060933522658962853667368281743700141509525802886190325016065327712213878243421603014510395903184330522748689671276494051660753367247982366213976918729627030437956431932942582815904469587303078e-1171")),
           ef_complex(e_float("1.1188817994881454477912554439280453189651157278340319008028814596053809075107674952733622615294120657412667879195376629424791575854488562573716484251621708678950948646750266186680626986041640586633418561905046611735424005116694802523012595997820156959029941053100240527054299608239173497951028299324493486532084367373812024909948075542100735016349075513122199716587757220380566468383498768988126656379e-1079"), e_float("-5.468012517043048551853099786994920595223498842453453687755632364738786172729399948463884978480686679377322749958894427328344476890016507437717280631051553790719854017869636960618660575803130565008383495625540042486968790859173975940783795154129240969274909781336583466334164109028455259129347571428092654804698248462268431443033134505859082998033500664507427470869009353965156497052623818038176632331e-1081")),
           ef_complex(e_float("1.433377220779751256013049301335563162180332274957871695051177736473203873820163795864350045264630023875364802756799431178529974224343800555597301091065613906738681678703828983138400313425298648116773032745795385168578082238429204793341261169437888730263458123840955865182602055243639939484547982982570735878189393851154801168267200539007813781256544086995509856050946240913626820111620966269692246918e-990"), e_float("-1.7735984469967177631298744670697400770167001590014636031042036327673947412544942937086317490406814412934244166574963029994661097014799806770672422292084414040378695654317748848690841174327262452173188349593246619723894795279257637717061033600653998151977232678750924497915686755464696326541978521423489424203103925766915830147929854738328170339782890771026941169967365825826934240664393081174208785884e-989")),
           ef_complex(e_float("-2.4519980215377311328777649760730934266099721967865130368290175552801722429237641164644365238437527618882906326174770234979085343652783264789706800441402934368882471990072710909387218166474375845535223290436150027527220951887153981668174759859817254627171277681562138876313559258959571384239499768795895377873863335362660453993727242677804209358542934399351802345771477171181836653187156075930746040134e-900"), e_float("5.891821993996528091379330217107733549712390698121271682598116023550198681933233617936044354908768246470833934204606074303878661118605414038383866846802565426860737527953699719265527308258833602327086945198089880262730247296501165865847919822286972552673076719529181795677427303819378178115313020762658031086097176026299580344350782196752814836780685748455449331935062193683208620599497189172430916053e-901")),
           ef_complex(e_float("2.2420198581069203767061067375235010789897074420787431071074320273437624395611222245111940270159968853209863401343390124196527634078372425701735089571150428274066373925940166698109005703218391014644970430757657112640746551090367265172136575421183460406686243611825546784914040003052877815182073157292026256771027302848142404043110130241719417156423000153071251706288069983181995224966943619596060959117e-812"), e_float("1.3293840404455525906723565359783110199746379007388238439282082744816955703644015573624358071155723476294513247664002024820087271394476889912368024422223759634004278121702219615749212635149585114520674839767121203039056587536890064700977516308179544957241706614719512145333247569162926406687351037289912297824728048945750129034495718038797147691323330468246053953711951781163959539052581647884207721022e-812")),
           ef_complex(e_float("-1.1019691771767180184519254695484269664497018315919165950825581899525159049458294150342231270769995633659655676376281718735320143768792881973198723374222602374282862554038056666144805379302251582694591136580774078460196826339805806246401363874136285736043120901512698527625862068042132301254095221615564556645796521084544919530946083648666865617366088283462214252966279917806331766641008668029461808014e-725"), e_float("-1.0873137081362482659918909649778365669532006939033887162677191026023080769646903788438595745140337410834695414188777742121073677940135904698322927794933315902599532856241647586772643987602318817890298665014342370315193844081678408694469053652819812782153239819610197271728101433727736627676608159009842426458506114388677875420541452020933459154651752779331520917985348282277532340027590708679351728273e-725")),
           ef_complex(e_float("3.587900776602469783463179229636092125777225208860568793708681905701622251049977219523642321874546574356539052912678283777058713930035174274724996498987874620415786042495596364638096319636811455924611664072682685172383013636577861441499539885197386490700692122089480374768512381813519099498290884400525755197117067064378779822359639734592969893393040323672946114606121066525356498559096162777603438932e-640"), e_float("1.6957277990506306140155420291288348215209965868840700193493178731372633891060910218368817402394338654765219292168016556493899087209341307940717482839458249093642545384630453611432237057415280662827315867530123345431852691553663937400211704047067379221353445347880398185968344988115995313400329391513901548424925310293168415011963290309917374046060342372727569898447303411530803346249401209223179323551e-640")),
           ef_complex(e_float("-2.6512561531784530483473844067182412285071431755789553061475534367664197117977143076535256348431535396519962116797177640591120934814835796084324015076974807877204841912100067101808262252937347624674239932164843905084150717117288863177988481842359117780809810622670378600069428907068257570789571559910931012677892786717870844112831740782877152943746257336772392716739891063063501962316845482469129182296e-556"), e_float("1.5945156931058190491021835198621212143589600562953667060857898416883865180090273806397445845524496015070231331899043426969213217938921604410947937987595652312194163226692940888184407359263566322649435144831523660863640276698845657154379486337930943403596414820819315425620352647865752485476833486799677215636590387726515421780619637617988733234752769703045464713529840476468447619447219523191829195413e-556")),
           ef_complex(e_float("-2.9798313838031083569757546269391834612482651567099131063469219125509303729270735992444156492023298966656698113249947119253861087477841362292509704151570428451904626341335936736411075350826280049175758894532254525420186676396512307904130124000419508441952819836263261925127636947243369161202196195640699471032727853332719937620212764736499351382849751943656335272092461192863106851125318774485381077963e-474"), e_float("-3.6775842531467931942859011896219170515144003373567734840992916418129323975732683227848861520657853850939410738729997359050080536141677457564496362727086216653306686028506281859468141977300783451295496220462266582316091676312032419643676002702884699482343368157883978393148120152443883148817150680289402978168576936089870555221308201480457996898491144510894543010977935513846023564667181124953294379217e-474")),
           ef_complex(e_float("-6.640850910591121594045652275618951535279883038338176895209544976928481990712703763797186133760475544763715247561011283876249281786706923504749461799504243623678161092636941526277351897750360870342169326510050755434404083304584773313010185901157805470632424204536601697182004973900725024349685366356313904411955831675461376419268291316469782783772176613561725093409158614443267646820627559764056245991e-395"), e_float("-8.0566005151937300220590601335706621601631436184923979158444939247738680510682491662284682795657563466980284540993182993091631375446810871970788995103173383871020086134236966973536577653091569538512208019615336048947323618204213253718369541281203119939752383229784717602111728127463536026588358280445106360980593248894023364926335248814382382105778743718003077847835504326347124671976730347314386465991e-394")),
           ef_complex(e_float("-3.1997125563332955358990629167277200533783646815786471658927200519373980475674079609709752749737969274820665214134454603972174781002670137550676368656906463362113051834497924572375785303246579119649104494819179943131769373850999413505314677968902192780201865653303826536507790329040533172096356235781076556755312025755829855210850197935467125653905840523385006971120706278134030176190992630727410382037e-316"), e_float("-6.506304904318757215402203306416877705962254454405910492127373097968100348125070110622100506968723641152820688890051096222997729582478692796500995340118744011863818469413176660807338536273179624404756124526651935116843577376561411193525980668313853139992641815799793848659331816885774518139972308628348156561023704005718674456174349640671913581159077182672801405920404531569306281969646978431775458471e-316")),
           ef_complex(e_float("-1.07354566598022915361693739357600169701091237005739515893035197532781088245188817177480710183377294095809177864101411117960521546436670440720209290701365695724790977672125706667581154289174039393358571231138765244512904451122896712450613209336972242312143623509645628612275457789383359440770001839286356967880993496048662194916243650158057301467969220384606880950531754534481530530174274159340044462662e-240"), e_float("4.9687885415490835572406462753143743459664949805871685874035108069627144231685762737031818889590759655904326785244136623383141115494268237932426850257530717834924771638770289535138506910080298228421971869367895463566509282320788647698760280909274363754708277682601033116785378739277805309701700086671708735267052721662564503897745078576926261851824551118094375830631780993982305464640567917508035773583e-241")),
           ef_complex(e_float("6.7248068823714922169054956640517764926592472392937607177951805387131208524672017904167330269623465945481545534798251420697353630312620502583155846636567245467850841649693885450791639118252604780633029273240876396455688827243406514830186517463379753872572566635125263397863367516168030048437650935440203600328009099769976680444981701728959712540209149062435103703187651703735164461202009439799131323938e-169"), e_float("-2.1808479111816311094696658944403486862433156541838675575668777678100804322401959980846126367710593558232244571108129528462217900662443791698286770099981711208351773173345740754205713249589083826358836685191460234398931129581353483730857026203374175022908667412096119308326993511345000366225074450078014126848216248875563288376339258085575051925897041469714364112425168598519198385486838716862998824809e-169")),
           ef_complex(e_float("5.8934835506894200862904177198423349455889304595498758231976587282440719030903827752910367463736321180855060599016893142733389004758094444917814480965928379375729449773928186525600906655580802688046117585627321224713467648139308363889733416148169030407457211990032089617709297494393599661800883195760609533568495323251487314208404996708115892994926958269949612145147155289275810490888815347124584203116e-102"), e_float("8.3702214939589137714164437289823397630264870497762224142942293926426381999931267515052428621975519500849264895937693533209852974214254986936778009640365157151783843860790186878173115072985610986495264999610370053190401190108450797056113368493689903841524398861258441317954981237369067665947070143186310668438634859133237524318389149958294174798902061303038361821123933715363059347122497632232851060606e-102")),
           ef_complex(e_float("7.8515581299301895048906185026383641480814171312924428486629569623288527082757513480378263583700203272362695313570336995491690062144489164266131031106402027105747603399539079625429379962924169049016166482809665005567578037270298060441515807194422611203302523086410566999640731749201855888145669524867074053771189715702863018500525118561915146220264766382795901164813369167186649895334696704057880248171e-42"), e_float("-9.1738279892790674508397521951262639347106826664242156200404981591415527295348986363484539130651959028296125532595192773861687849888514258728875000990844315030783891519990764999399911408502420754220853464114316831694218144200268118789301685141145338859881755134824219216484626403258042621466105191051433175595164281285085495497851936806804164350015559088366643978384199285997752489441942567614581497433e-42")),
           ef_complex(e_float("0.9320236849491945893679629161270007448848906457174033718762613947963028367069006340282799346358716232685625073627220496998394082467264490075822784805329956222588308717151510145389557457864952059798766053389946677184575890879684449517312091331930731542362333062679938840677603298590300885192806389149909964868593703879433070617431501891686299647246225805864726363857306767589305261217442636496975954596"), e_float("-3.2498640904080309036074744148410492216447314072347014637251090487386316225826272625606172775070561493144162976668112453109166683244674827766226839768569033236668718450471450015302224460417326104230083100010329668658514265003110752347305822966635687757050052996112807407269799627331139834303466051736713760977077565553610293432032212329640769572450753266755607167320029607873749252156098724537753956771")),
           ef_complex(e_float("-2.5716157502765602786055159935612594790798595896805409965386152150391293639888439590642031483032126399383695264889932605296697147085869454663792688108587780216343822790252402744973709726107953880320201763747373312623494020960651072149492934833390349645673416631677464211352412144197696226055081902100801068066485883798076117262960624886205385073450842628032591192181344189961963618811824499445304069569e32"), e_float("8.3010047855558597993116336026665721472358382572869308166201033399554874372656858178000902760163311417933815473136430258114351089023223468986543699919722738516398776193096190219149472542768760839335479513312736284781081944469625311505296080921306699851893811798399581268377468165824944325699889923740289397840292363360860865694285321328484492230570783178821776456372488956618297398548070686780486268787e32")),
           ef_complex(e_float("1.0435737409349810575812485249142499486999454846014118314006575561050421665595085443868070002007951850203643198123518760279566341197074951962774775317940066785597803222461214055464484746282665704904532401417596546460518044015933976428831907925094154651263376894827753944001088058344379948909140190672716773369343701486879013199515631530994841742404121395306090236213891020371783747144610832804666058372e84"), e_float("-7.7744129360498374657237510930029015200338896129989604012255388326046633897386835546940918092747322068706769047464567362336792359617438866407732502566016179378950138672623125137873965725669972904877322409343396406939799416853512171342805328064219918953734262147069065772960911837049576465585786772912764894596096344860120842329526256213156263949449761250934832759741529990866194722502551372196940131031e84")),
           ef_complex(e_float("-2.4711975251201179104881052474912654314422845005562563005700524725647395426345907092953011284838444533943730400020851007754265141890490907305492566927715851855534357214957646543603477615716660966540171470910714141596229011332760976824329743264727227513453569217477880283179741518718039015245327541287672795543007813782380216442591328255524320069549968502521618371436816081619972290826529122000073764029e143"), e_float("-1.06581903539173336590620988857608272716783643632044480017985359303181630901480233333932839461665358172117071552266216463466100106971164938172938334251024644775447605640764957835713429414320104329977799613813909613801055234947717342175660972318794766929831585749188166562966738790579235027932693242945005912344507386176888828814431616592054139734593086677329926441473378390244285312951974436085446327715e144")),
           ef_complex(e_float("6.7409929799642901776248965244537831285959837324634828044898994932019647008977910609666599130220844756564212100231619806518187713071954594799195609310552014139435642022036422075688555439426611256244423566784058869701018220623356355501942422330939086023854687786672823891042452504540570755392683484544030686766449380626708051602631346811243253785241868826895967078374010808071909729383427154611893143995e207"), e_float("-1.5658145184805921968883251728110401090599263626555200334307639783090419870519974711226841332106311520904649712614835423732771077793149535706083484891989510186503999114813592962089504203323971599420357430310822968850495213398322069655061495722277658372599320553199440524995640087720332096677767092816147893976785278852645813305771493898032219254645508954436243354674612254855021184493448523149345346546e207")),
           ef_complex(e_float("-1.17894783500136321966168720407255650336066484855021554742394643163996338005647877279687132620377239286922633206079439236236535118257787582471365320936061640839105904291439138590925500891549373852602222068659270089583920889178189792492744731027427820483247316456590952605061107845209136669818957676069407581573931295133910013343576181439659997472201742097502063622887217379781553511131326161908099823284e275"), e_float("4.4001084566702929606800032416605895859220728780894678540325972479363104505476121869146210593806897237564024701892085383235384280034747403775826784877604894977007822935906319469543289400339159243189076550024034652797794473200157144656862825979613133870175633693898041058908707982247439990245693704377387199421526217612389846478518104232974420204250542709278245138697244825598873602314070981512893298503e274")),
           ef_complex(e_float("1.0220574131800339756150139772300718476857681405269856368742409372386595220742877232489006084508242966225092144064767706327092804114944152828634066007965822080559940699690362951710523892105662877252170995378035797390974341452960815714668356023234291537103901655470481945415714780881547600674476346276830298739869185974391706782778502513238586947892297992632139681026534189993273978844978868337268556653e345"), e_float("8.0277650338805940989223650919474141526699134296344979640886626974674909232461606317868063621204153717598606557675257274885742459318948974146999961010176588637095175160392270480698549519147684656774675789425825561920800794591244049212057151388955864993115850427243821500107998300818411406727975441107801201527394715746028984182265504275758041496549224030790656657790720871471584466288651378821841161327e344")),
           ef_complex(e_float("2.3024600530184405490322204692740057007367905919125440599194035416742061310442794822308197919830013090829737719697603100793537994308673018820217037880778456058789000716887838708956421623219171246948351832726071379306199314912023561598731997249544601057878087074692429642533415050521508781166391462970040485535032420407073557925268192550238845800924199729684929783796318663461715851685423932143362155635e417"), e_float("-1.2379096318740418490934253671844673369724587072594518693491077950541367595336961489704143565396699063945778722631017491134495830135333301939755352153292490689257209732147008810441375213434416118026652351698926732694731704833487318463425313348798322624588227425300467362924722105601450483892033125778259674513626106024834126943266549619071454378269989795437322246680307662818879391456824195500949398357e417")),
           ef_complex(e_float("3.2311069780723651706427943008691372016760730293674832849401919820874619243461869904516410047889449004238588140268406880209434214612021708638660698889249333930894439261680775739789369610934957406362913703210956676801214440276165034925193453603862299657613751528421468332000331268448943547258396120540870904405025929174984249385044475986247708669912120956556307741367104732976019225528833861197595571032e491"), e_float("-3.5342551188071674019227532102928214699398997718268938491454980624412564198545489242135330075946007758261735311348197520121288311171243821930245083611538234484623707687017792769798127205389230302071465207604223724253951874274837714595026776418565168419479914812894358142347875677001467935488477839659683752311682684381281210587686924291286136595895790152897876373736751471215275583076264765398757045315e491")),
           ef_complex(e_float("4.0806781466495442652223198018447742560498707886542743980696392922764048512128696401864430432673293289542280306257299000525841979864073970544425524743109965218715765265995183618677684917576170175682118564144652938503610515804987254778595813137767037765493202820721747023838757302789008323947694264880159761498010866768502704112326071297686937301859440594154773010457672304535204190327835580579093933292e567"), e_float("-1.9590464399259001976601637555013373035704997989349828758330349740922642473483574761813685265988107865182245837764779789167120794273553106725527947875168751937052287711637743818915230495867475512174963721635952897675514312063978763447343710818359926469031582190752434389625881236000694879047842473194647013381151898545915916856366866102233522985889616511794551018045683530827233968424305136239695683807e567")),
           ef_complex(e_float("1.1928176784979019112400978497838357797354583682285961488902485603013391633585968953982281333263393923720166982318478498478401537737938501200524754077759932314528374943197740967595554594160744863639250683730367005836080613629080832302648741671130029480614934902211805471264871798687774749068551750125510012389117609271564966638485474295932832799111148451249641010370346839591856208888124154126668143333e645"), e_float("7.722752908304455681656946213008651442184759364989710001599156406319525635071311722119182297682338935020537968501689677578432041157791297798664556830499067263980869855679188966670998944930785164068727250072234051836363184516713321761145076257256322473153551306168287390763385747698175788095100416366127439940343135654937009143186070295982370980677125958390184382734485628229470239223613010830679610355e644")),
           ef_complex(e_float("-5.8966361093802988344500425791144973750086436277605646996972899015441186940955347132107397609031564811622495989927292851820587831743804686028114089301086853422720230190640453790415975419064806161720901459322105498348629618935757542404897060972932087008974395672232408722547313799380805948492668247755857223807788563620644951085593558286246523789953414339462711431155598140028819919466366952671440814505e723"), e_float("8.5896742364144928424188082356185959224722373163568774108024046545774841374573076019614520707664025934983781526662625574887485719450447629811212724045385671764237304863046772463130247587299782111109996259634458305513468550446228970243227860992782101085020346469992749586162639103505823353700970986217396621142119684476036873028240378492658647237366938949526062872229248519174627422839076347168748213733e723")),
           ef_complex(e_float("-5.4422162652261967008763588920456451742695636870010468783252883995449630111421199537806256303360787458378205055481959705012016026594220162039288374142746928878876925119356342469024269404427600328158943840202015439428620293650834139279197961664108946773034302152288972160075855209888430765795183976813000712449986222182270430614304534166397604711701599215877486159395173430562208281007621108914100256809e803"), e_float("-1.22262560497182848859278183068084049500218289509507072678520738049237680430478284796854298856352452508296763117645449841464291044911474333401743963711929857318132360271359591830320965843140875129849294584168868224525162581823245520457495693287566879031542160682731211677566267155754677435868191546378102578919190279140280448714042586257008865306190399959577475840202257053128968922078914920427281699617e804")),
           ef_complex(e_float("1.9407607817638221372142919147082319601638787557665287216714199843967200482619266580514856763739860583144400522700557656764634976799636068449176875303406945981054516044029279855461786763594592214870254093086675988619662686186723854612379034926449086392921723780102390108982569071097551460662118152726302044115725353179665387365922098670221280454332215443689042917025632938693407090092159292472004112948e885"), e_float("1.3606048077496232012193197869960514299246865252323465014597290704466249807178188331613844935751251637109160602889497470782576448811476357514115605321121205511078809125029922820193003310957504119373436925851381895092754463665489396788317634270614824377945471278079923750009952572759120802646891775450622051007924052887723992299920778255034547958202345308593871147930127930744475551394407446887235239044e885")),
           ef_complex(e_float("-4.1167721064633594116310481831680383761741766407870686053393155006296401397761616234857312790466707614568120746545028116069146232397275971440806050770229177490897244401249061302842421529471431308124724270054371868184752445797890873921862771792925192345538647020472050861744566475968824534355335361126578338171104605010914099456486695852491362171453307939278574194244822820497412185780594421761103424242e967"), e_float("-2.3235805091536989976015310111545789670047895776188461782997680370030378264326291405203817944000020047696335762124724864877880828742601675718905058515138838943896875812151681383751262455952134827318720078180840435955993731479930673711861461743970756813515314908137849489064094138584575083727322905192775559023238152271570688433421244434244348553942258666341936922780266585664868141991933182550490998602e967")),
           ef_complex(e_float("6.040319195053077942767994160502024575819590018457428517162003259288569285310106752459485399860983608823391726373415192316954763825098574228529047528131010255310570882433369752336795296632339734912841147632513322721138154109613177210162778287168276632881907885456559939503569731514301668601460089806183517985406613332076122669949453689159045221379142706860017626847336338335675668684497032859923846289e1050"), e_float("6.5731431275098887308438401040173100625140017680857199441048655041757932412341641640509416104457209985176193917821833499471658035218857311490589398908441020030610792093436096808919648390867898670880733950588525965957561206276475980220979049200198065437916697160531494856847118004169085394869942117589013458066081074826668884712904191784061465132078850666159240623367133196571208878294888283496017041151e1050")),
           ef_complex(e_float("-6.23779408145166794250033950393086818656302892850242328988993020699343261747940603818129584352437417417465687875153770883218529925164051676723943018321639517318181619896711404332078910030880034415072133650526659116461318327882238740458551843803988996929283578706668895465963382214339443540179391488336957501651076440391893834964985250487926877021293169673352475671663481309195449580785403011606448135e1133"), e_float("-1.37211164496134983816447784689117847994221126986733748162931322991920437133377617029864177503259197575394724700322968376149596229601832189779601249830702690044550834575213436233798154795014091857684371138239931907009867066418310840263582747019664460853116782368792270759121670518490177962620514337176303319964171408547487368755313638676992167214878672449088906685640463404275295349463139683759569917959e1135")),
           ef_complex(e_float("-1.2804801173716493024992461726216439107558770921302381398862810070528234901408143955422828417416786078520640006534325478079704370266005558427317592167640685179113363615110039994389227739137195079093162226026959184921767483577715418002944480837583986645070837363257468980518137874868787558447689030980617484982496847573141503913789109336892720914858921355769886700962692736259421230999703298344341224104e1220"), e_float("8.000529188027479461649237350044413491137195924785234306397598080224536325837584359448507347589087245742127543978490789927043355253922545092237763895516952268119716936311027008279109546210734690922641348664353006599189243489504649109135251601059200500784892584395717882553133359282472580373234864414661836235836990459343653019634681655498010703525296631863647979593189609285545251631291943414140167161e1219")),
           ef_complex(e_float("7.0630704986143637349151937685029866898362219887262671618098834659067469752579259926034918032635739662859351182911737066662472748370447024389074790985708788704198119061087660040919000787330484196067867566963058653175751208767913206708540870707184432356510036734833028836533326133348391704060711228683858105503259003468473305729459987310168728346886348150319307731832693726102376575091371485424669546454e1305"), e_float("7.8508707973486902533588076071336999816623880463790042007821759317293738903124864557874322027847963051416026389625961288819814316579451863321363617661546928130101245486082106944715655146064004285233053966454074605650206219655084755397465894604028635812063031384537961333273115383836576382410647438155718633864148223224128129025018432822776228992872202313850626480286419800096135658682449742682642121402e1305")),
           ef_complex(e_float("3.5306859520403310052287620642456811753340051770367040776831144351863732479926191763337462909869821341674131945761011360535260961089459290982648455841520816100168484764502698900158689657105307023355973008221257729973805016582983988824545796281000911627374481065261763057443368254583559825109363137264510501981713394686943936049435566089009992955620379887736509757850972730243435156528008354927567370735e1392"), e_float("-2.3472607071627667649819908818406912129858154693116686437834829918242125679915051000922931312021006039758384309827621197748319654524472134601701899482321343814501786942566501169117387838954934408008220248022218746772657012333031351096527324564008831639763071290962499842497974443192375575454495424336232738033577170478465307465597588046440093615555639189659116126870426614697519503386258170778765033861e1392")),
           ef_complex(e_float("-1.2219927866616847686349054628168106685178480333693058399541241843055634335039299407450542550641128885344313574166963401904307663296885915394713871775797316624460707798268893611579211082146061454517919111543775924278891818344779252470656112486620339507947554494370798711633783231734811739599851051215547594874555620109282114535572981563261359590381305866827209127509975022811683070405269546326804227764e1479"), e_float("-8.8263092184346037879402735972023941096399769803622694315191757965021853144928041467854922641136442783348921263733496668866219849016769319352339575298249230838484761017506918868080051974492418316489981681509365956975943071232241985173543981153772216235156442415544321620121899290500021138431745425411008536661780247658539677395337464621137790132702811536516983300607563167518858634498702651054302087013e1479")),
           ef_complex(e_float("-7.4490347571447086508998709924849004544090891553943012377494832216905064609006286984891076293721020170812032900036014905421024589881030863930307103299045380219145420697438885849242922244001281394716852026625943401559366600669192533765649026365120838140086600851680347936102129220064125529342542620797177532111186383378629310412298594654301159071705382773949643042816838760473438970188143519463573950943e1567"), e_float("-5.0925955155429615138863546425396335980119883731932867101010841657399277867857985914317877447871284262156361274538076581746930915451504906122195888959856459172261763736394338608039928453585709020301754641064957693454227494446787143914811727244198964604824533394855956285401686241796457517732113692946142257139582688488796117686571802032532392543483397003565448934688067263415656465621327064117859196411e1567")),
           ef_complex(e_float("-4.0815916745354663106635449909263815392709354684448648081260574984991577671262903161809881536149860766521882107187934178510153469511857046199309931790275230171199059750231057474883322648051554142387213923745263990044977645205215402660915106950361705078981849943602106457598271350661642040028609668054921834401563153950442240658361349744849335124388548254974888855105182351046737307015017119669848894456e1656"), e_float("-1.655033361549216003060212907564904624731963705787284295555455840377937422234681960567356606060054858260233880835722748700138373472546576202748390597239952288247492395099664984025789388912623781649764864922087319094467342549192331378388613606591098945987207198038232824982595304715766202159805480907079579435381003957432246562878853484186617227849523961470461295415054698042775989941463148599731809362e1655")),
           ef_complex(e_float("-7.4692630444328512833027468247024692822859677221891290535419521204502610059031670437782853881765452031167676595260909848592705564163923742977452625430264152041473412913828420177564358185311725916307887225876770902160272736469165347590286620472178591173088400664683425651497221336417129871505156421375539708784151393529317582823560016343448511368355707259965093042321526650009904179507114977808554131866e1745"), e_float("1.9604354099584375629498451861485796821073664433294095760285822991153289005435925373236739201813890503412962990615101805348457198724295532750015178411971514940724067899784902725813427861825510124488630730734998704833758793073797477812863938311651998391370998320217134560047232650135648012520346423963568138160467359411057928762099799950405914019175521797902378721894271139868114369988362952771755634339e1745")),
           ef_complex(e_float("-5.4668020615553867727630913788190114954805355940244455436056127813891002062468873823890300010758856621863514702955197018622844323975197216997615780766519707111553413981262635912184018748285997161738124761005629927053338788099024719427926372663262714854539813017486857264682154133390446183262335819165917264677392000656703506046155648355365510759278526543212433513184062333773739611619178805165317402001e1835"), e_float("1.7109427513758348621637583793841845837350395524891408551015621922608119391792062878066213893713843266153039450868420598121386080166422672605269490091169936389299153510278200654139923353987254650041200677778818462667400837785123755259179475160049024979714469198849388387637309521257940058223138581824791498963379243030760809327351965190458869151564759022286595081865658513588286084133103459601278683573e1835")),
           ef_complex(e_float("-1.5654466306223425188769442141624654969750337715063083826810449420170580414876172603820024866257254185786374153065172012852382198573256253576471225250991163491007734564311291493502367154445260111345672008630191354295262958391051305423759017847727453543063292687481807572103353695737413512680791877431572110665237336443680482499736797956129810463789951071170651344916699117789965842142471995084647163136e1926"), e_float("1.725903131405098383569890180584550534520378002554796497212268254705128891532161045090283597396004570754126743561689130094492528970903013674002794845240169818402596357360974889494377807507602206194310848506444098291958092540372017663425268520816815979910805152833815432586161968941911988307613339762080921904299427141560745138797331891833581714932587784657723524580901401825780527195162066456224345242e1925")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02201_z_gamma(const bool b_write_output)
    {
      return TestCase_case_02201_z_gamma().execute(b_write_output);
    }
  }
}
