
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02125_z_acosh : public TestCaseImag
    {
    public:
      TestCase_case_02125_z_acosh() { }
      virtual ~TestCase_case_02125_z_acosh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02125_z_acosh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        e_float ten_pow_k = ef::one();
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() * ten_pow_k;
          const e_float y = ef::catalan() * (ten_pow_k * static_cast<INT32>(3));
          data[static_cast<std::size_t>(k)] = efz::acosh(ef_complex(x, y));
          ten_pow_k *= static_cast<INT32>(10);
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("1.753616278176989136712842367963624250971834108725531523106224862430641905378124697966483218263743684163438308497726478758715085317687102161090856345193785088253783342572530840173994772918592873514199109235312082448689630689166056735258530702868079879561072008427489765560697141485909490295640848956063556787405863588977849289574827398338481037023392062728702855546913350512342832122477815866074374979"), e_float("1.3754892072538227025627069848357284781666569432603118712503488491949037262808350445734265207674166461692297958967448070724444820292625754754100166353684443988034875688997795371329435561553383443971257181732328857373469429935604317720856591724318947309952227631652845159216114575316139562013413784550865900252708207551424332594418442502529350573936541917495193835353226639167200814377869104046565948229")),
           ef_complex(e_float("4.0284474302929528469659547504354251155713166297614145509809067811367673108561197496725147546194655029502448787185295961762049892610595486340074691720877423006533007401259778851596218159219382307604234908998021635546224925528679556594958584540917484278596495758239371766395587033364594568704219460144480008023347140305968421434667802700868430206788804541347123708706228474148404686821862291322835023408"), e_float("1.3638767679947174599340613007614902378027025959420303582809964501072854226619863067764721846306627961217354727708220620930474902906273198340988909761014154439549862156241059012526219659633900920409751223647326367318866931576108183412488038316733051314546835704992982232668387551954356979338757348732164685481615763547789469174985766233566174126388781233261658790540077263181559277094754426460971043336")),
           ef_complex(e_float("6.330745235194785727210496284337273784617870444834240127428769589788559507172008215412275305184259623097614963050382056590566281719382957281552027460657043203353930232858407797621987579585715213967597633707694356820213723069333390627462314544809263077788409564006743116734612648241587784398260598933311934439693597470837605766623231512412224388264942432090646301952442305423273234258225135431071069085"), e_float("1.3637505689583852231170700983037260868247019103375250124793955994675515685935443840599523047919113961107014464247400741534271366018451179984930336479964075217842953806307204613345953556362904534135074858815637281339571145932932381345978345178244449686348961125058156700182786644134791156691772730549963168735459308965783307952119498871304251314898852278802098537702000673334819595647162481074463383999")),
           ef_complex(e_float("8.6333274542986742848204645998081314531105984953121735088515503632550868312099997676452864783150172865076448815083362936220766528045466212343690155241763330890430108446299128268897886825214202506905649828176410226403661456578439187638162067403379939144200156815508073935426860683703115878704887307558990242348491404358517471771869966339157513806534950260690815089079725370475317921176318087857096563489"), e_float("1.3637493058691294054932820490294119685563078671687317765727194195701588053367064372882322506332353336371070950012187432286746978079956284220102678071553976558851640100313187816428350233965521991685045801413645228091627853256878504263112197191508181712759436956915380777545051832993525349608718320924917098607664388721176223568554518815844530187828858317422551117483080025931288700582289082244891843771")),
           ef_complex(e_float("10.9359125185537174401243910090261836027025285920204273959862011985282001226383825723857708588322882569472750570522997890024671685717707293107908457630883370412237662811401334289817089924314774368236121677481571723273607519610842930726242019884448091541605880260996069062593327805332313084838427967699882802356903513690468044301154434496576659585017569288393460195193717739084365011188086296752952755209"), e_float("1.3637492932381268585778107299846171858849277700965578338625986069906747269258356447539867329908751946054505483572851420921391388266735333908714683160368591996328898416958526445839310463070736029180478439805843769607533045211448420533440110256500089089913768080879740578722748727773563508641142885962332627416208159603010303206602890133555738507034115141328432987202531294689444445731510352158755712216")),
           ef_complex(e_float("13.238497611260373088759462872073009127359589168561329895193195211502010666109000530641479305069671037034669909361849207180358269321188417555799884759552600612136775581752720211547563556453022781689022525422867519857767040348938039621869041075051562694500735533386696372423431906106379860461963885994463002808004554426297473727241108447104553611283356622178213231383924499742643200117035390457959040711"), e_float("1.3637492931118168221096825165653131383473186368839158346492365293131411537606989784529066361438926200828467140572394394343713025919099412825911041308867911494107063813006121332556624249518859548215855355329531620304054874799365387798794704213415246805253176465541023026434904206069293611697789104430397075649386134357195016814657559078511242519455255530316645005694275498086150320277175024266414732014")),
           ef_complex(e_float("15.541082704251544872422615552912937033952588836839620662111735386739611905412468558335832441963342973568021216788708317373445558664169614937918076099401245393016251526047549602525198583770892192683041748241979023642448943821264520964399469465153275681015668580853152778759808266836346126794049395118356949080182251499807062632371818628554259502470199271736463515342480618205287274019430464601980422586"), e_float("1.363749293110553721743901336981519454788385201352519109077011395313157098278151008961597570279203473992444939888342937939305526564386411097644116765998689820296383710715226234391977751392754225814618125572349947301501961798414576695877621575879793937919218592293798762476305230836321796600934566455994768325408343987023206892387859390109624065576042153353227494835179322828433063847155034779524484563")),
           ef_complex(e_float("17.843667797245561817437058518901064038509565567194262204013056234233681937858169185335954708879280866519297914134716773140553298825386644560136059509705015851409793510966226998802194470036601239061149486081928704016759847374185002601942620865811506872893472165198396358361218482325497208419103550361447423373935482084943092200054819976203996661371252305531596563317444075053418182602083469411500520395"), e_float("1.363749293110541090740243415195936458310721312879421150185629718640091363522486444091044754638203915692306382946851471239855566490696120066384106089516650448967584298639198548492529538207233664490735383312804759080938459402243103113109224326292392026163102727943091198199012557692200331176735500812912118998004667896184857844398904745862027071155928176183444348299521270426451348020209181711056755292")),
           ef_complex(e_float("20.146252890239607214065014488688370094796188461240420358499166548069362434646436077062382300968436400698177677071394359428400945732973802849455010788516276571914351559437100402839518603861678076341324016472438204455896674455557087998579067343754513035036975513258830199651025659903867815782187725863168057402147686354020612217495342798087449227533423644394823979205373249065039504591901259622391923873"), e_float("1.363749293110540964430206835967081653839880888772992760855374465979596019128015411223395238116301520912710418105777414802537909116919340775774888013966483269575250559661840301023569026399990013672295069894460078206467248648929219333191706084852452444981090580070930946703646535319600438677483769487178095716172762365709700970001350073424854215143183795345548522847736902686009040872411941304058388331")),
           ef_complex(e_float("22.448837983233652895209105588523762711306216760154724573099931988310491493340239433912546996100262788833224643866359022868977342856590982777479030190491083506315786940446385241619123150747756033455423198142004939446927045341211989214801201294258959348275420466300321856741556261211400336559748572361795185686857895542327201648344965165951755036595373010005862211360446968499490128785906129482886498704"), e_float("1.363749293110540963167106470174792005897721878053828540934593957349697161512516097578910470739753554079705991663467925335655936998523664771092441316928021244513802701114386044319768355607374873202005412958244932226309620731454100952985547291526635217077549488007574059431299320073276123542046830361498006796961820504614219190326609531196721085814158414196651254406870353156172315974081395860040677964")),
           ef_complex(e_float("24.751423076227698579198358039659637202895449724045975963314986689273367547479552781830572671793638617489749860435927803906372278894552925008314473636888067405339146696296707960862288124919315135713375758057919686482826316202171924891972870265643316144876089977505941667436822600858271112626617655090767881553607634797989960289896512725520178245945989550333435804123835206366330321363319281962180787584"), e_float("1.363749293110540963154475466516869109308310542885988989164017117955241086023000288620148550788878479857904030293280129187524485687142655568600942359612672128322297889526882156374509352864935560975159449521257842639889854979772141569216445990531480471517244516397101440624621663282480099402134214235540637141291795530659265293857917811325100729671370006230092735830778435705521918871327121653983938155")),
           ef_complex(e_float("27.054008169221744263216062104308516513336422431648089685800277520857487079450399444158070031477391610477585915985382734199460949870282138351568486629235880383375289735246124779302452345584636521266667788816215457478391696730637721740049086536392048767416089235825805380179987167714440551620639958362902024555953582593106409593778611002168400830616750183086537902755461713462988299670753347860158331227"), e_float("1.363749293110540963154349156480289880342405430559804528855254634891579196925408293321151743496176470255283173646896870053918429817046258039204110341922698176973728866063074481031869737809392151292411840963351058653616608377697035211308372963552435963998236121776313973498782572250164311092692805697726112580083489693834157397496009745225014192398337503486869812602566337064409486792692034750927608098")),
           ef_complex(e_float("29.356593262215789947234050685092525871965922631457018140894356065663544191873102814624567074857837244889242720436538396502044267705087264229004801523062227838598011600436049476546957016214370183164465315436353495030026148932777997309366113230944226476602179380807143863054136243661908312935610997122526328335645406740916095778744042936202744213731355884988492846794705741446044531710508962191150922048"), e_float("1.36374929311054096315434789337992408805274637833664523364568790428989784001508546880645992483581709893510824823931987653730006844393797943624480983279084605165325848864764899718983506100739923635507321732321342145280639525716032668656480856621447626474247707206832844838706688428459685035668391780287695611367501723227045339300935856764870615277762571984155404043387852950613821127425042415497128697")),
           ef_complex(e_float("31.659178355209835631252042111037886531077308107197491713925451096170954844538635178988771189805883164784154876176664645239429234061174121166996828791032944496849282340756573302484755944839376431250140526658078196209599852011638192379449739501789932286893839252924186604187697905796318655924492399596298463427189436330328591487176810395101156126245955737472871341798431297750761574133120919345746444189"), e_float("1.3637492931105409631543478807489204301298497878143036509485315890733038223944140193582219497584472749470856563309383022283945529360301101127834032937732731798982995870301889957187313721433433742678819403212777701834340743659775391804206451595991156529739168601662075129444290127893009390869961906241826671018592644899594619211212851094278321082634305915904765780387529870208148331341954310248238126")),
           ef_complex(e_float("33.961763448203881315270033565434860703193512435697381685832977384396235979965631588077706685246166492606087938982814404457245860622981909304243452627245848764372108489990136626430264408714995164025787134769952786081052240717043401457536339833711071942434818713480652467038106839667184754162524335118495912056815027772928292731813168087648228446619050486685689493837793720322547384738832509805273636324"), e_float("1.363749293110540963154347880622610393550620821909080224122585519856346824497702570275332748267097707128712724462495971064443971768562387498127528872770174195699761465620447134093910258405425845140850501250041608211330720528998667533562383414503870863890078491839953931942372164951219652116218993588751215167192132048725175692227505439866475808813726408244523483239786350234335321081245324129092666717")),
           ef_complex(e_float("36.264348541197926999288025020116351010439764952724865831824037691307981905915012483781291812995027912251181243862444245079066001695931242334589161979659964936587434007424411846211257743012511681231907260572531535137908382412709150625758014921032451624961499700651440852747718214710786937175871219046061843505078792529513409076220175027538514239048740444712602575524433671875897819334046580027991929748"), e_float("1.363749293110540963154347880621347293184828532250027989853226161713570775412963405211467249283497518976777317928210905141524516490895474088921423997731318674058596607558048510810790189780349415714594292580688557853685153991561549770729721684532604981503804521517149438297395255322271950036772331256604643535582609889641871088667932675797835145772537966155696346824106659089724056182044087562006226398")),
           ef_complex(e_float("38.566933634191972683306016474800686479037317951637625919556942815377203408378186701369582769222568551064342068699334114824215957837487817466571765217635745157930943373267682571360914424551162314447813745355695883677123545008099242158719765944342994669491490424046029999430114103487206964013735514307919194759322035219501819868240206176508703216680488142414453753697626644193864096679956373046338877473"), e_float("1.363749293110540963154347880621334662181170609353437467510532458142397954274205436355771191055198361913375701901309824614509017538778663377631759753003676094011654263844929041116097093562952225652454166995999362915516040483537328967073786449251111306252983065913147645560537991061420591592921588147087725781566671496194367660862298467595976598099168764811560235691760700259238729050033245243426494548")),
           ef_complex(e_float("40.86951872718601836732400792948505039924838395536923876670726648856569672769935970912442267361070346515608123038907802211248425436885223092999116817933985281620108910217992243584652279836639631305262371608692475875410668816223276438973094624889170956690196507715022300889626034654527949094896500952487745908315835237247960931356646612901767551340959860861118676674189283865639064402408190276091567134"), e_float("1.363749293110540963154347880621334535871134030124471562287105521095687251556753065609493724732491946260936984879957864149495032415456990197516500138100495101081040521211024902302140469322100334811919496394954852721303845058840802600915328954724908057940192926354772454722376542143156889017911380830277526409853505403745807603261550636826837610072243383172442995019418566099398622172536013760645263642")),
           ef_complex(e_float("43.172103820180064051341999384169414603975585089149040141451764347255477534895221990866622837669465845340838608286193859447686166903529782095426435161057656655178626618838877085743612626978167592801937180398581123153932041709296952123842161276208559424364330340804203994368488467702640585876855516280266576174496096391184756633707995566116996107784857533009800541229890615308797810945373719385059803626"), e_float("1.363749293110540963154347880621334534608033664332181903234871251725219044632127935422925178018690839662426650953145601363085081423286410272795321807988109235295596892330825628831532541120575502108679699843170385986159074293123049915852761361922243153426616466480842466424717547494203073302313017232515553811491815187486934780753318680610416814163330087108526848650971039272586115017885930856408526837")),
           ef_complex(e_float("45.474688913174109735359990838853778811547947574229323401472203947800272226446801776277305173801953402372802783512410373100386093618669651745739733169973117040173649840057576290731925657974672653268475484777524737317704578185227599830137337453354663416851631386399604650900521988233182125493191339110321034384126533662923967132526666400507744691073667074751163270383640099968712814279018457447032158241"), e_float("1.363749293110540963154347880621334534595402660674259006644348909031514362452891939060411581974347771192197249441435532348267919138413852804520877790971424844894728151872380937146770597685728729577066465375301548841077813993752450818167408187569741479888438909705224686151398300679998138832264002117260949045428066210127374891327698228556712312349435731342276971464228252296382113236081153012785741963")),
           ef_complex(e_float("47.777274006168155419377982293538143019148761672822611480345402965763617056942886433785765192512125913063457688316026519955035381404943964668109703310190092407241834329181625671435597838950331271697071100110062961563285279594795860005920665152442648557685658532223438597862093061533790939100087723063088852875230847908660983626657981098247713824502124420447455893948395754874391091838124589530628711975"), e_float("1.363749293110540963154347880621334534595276350637679777678443685604577315631088580122280381222846620001754530996401609697194539574400838307913297832389677118606683523319056195495492856216464514066335703945824564889988912913918557956232365963594053934868372585740883715326648604732328758778671597632431975576655818833587586061535156688495254572561786869535291104343608560821177983541792264487370619973")),
           ef_complex(e_float("50.079859099162201103395973748222507226749860287551029607407129577901147388828426234784909097334160968060888522281611016596271783312700616532986129450523260746697089078317408709281214426017783573729209308567489589789145361215349860447499700065524385374806839233248087127432871700280063062060207978906694933832122820918050211886701150764071204539817615021953948926692539260523888846416758113109055466065"), e_float("1.363749293110540963154347880621334534595275087537313985388784633370307945162870545433001618608852502717799529769508278688909946971453956847261192791319222422566456500911115332829847071581528107853358256360870799079685351045903670731052062104989020726659647275570625723112836146434375776084109676593474626336634662644265261318489507040582252763832546995723603183088871106331051150822729575127283173374")),
           ef_complex(e_float("52.382444192156246787413965202906871434350961747440799034950741465980419575727860588228436811628243257070864134441001816204662105047466241564800126516953960879883750667455517984570214038274319206848579216536319741952285295878330280022906549358306945970786798357818723303486659628825217363360667591632185883242610684168554501349429507827982678042777945840375808040046687536722531915558816608519233823132"), e_float("1.363749293110540963154347880621334534595275074906310327465888042847965251458188365085998841237651913634382774699835101079648824081777470844888216344147611479088107082123432738482394251811601514645241779155776484081697591293964045455418729846372156827940222531423560738575299498340476649831976205170035364726385389450596225493232843888597290011512510902987801623361631723050749373230177536234200713362")),
           ef_complex(e_float("54.685029285150292471431956657591235641952063235782181975499172206819109181177433887196509311714107111281822142084220897504670928727962459486333928604810023136483672555391002069200636946188410439247765219025246264755907326152845927364301304828017833262794106721235540554063944415392225231773955484436649743815872448918240550700066644945186704315882173707725482943269665232856161070439510167859389197451"), e_float("1.363749293110540963154347880621334534595275074780000290886659076942741824521141543282528802464965401678757549428632628879126295025084763516859197299249425442255738997151198398251218518040958978502131278839445555690042293183273785598668004042152193272557453851563704625317872356399790528433330643118978226355530236159221013941907194435728399641709435712948183191902116665215581365242981985185879901129")),
           ef_complex(e_float("56.987614378144338155449948112275599849553164724408081051177651136185392960812508575619827269752658487254076059377048450643462132124224671979004476858489616980775443130482968935731574748920580967892794733589026530481821457979663284341467512117777442840340612057649736025418434871316724923790282925452352110448893100044684186751477041443757943109006009863234049621020309055954202878849531736190514087576"), e_float("1.363749293110540963154347880621334534595275074778737190520866787283689590251771075064494102076138639108594818070148553583078626742735056749754340293359766048100838799909601549595451541671727655409743686458891271469626651628409812139535960627819219579337161302024479334644593211285842955337955544650058515180406980561132804058785763050259749460293386916909498708557225325522636322794459561539209380456")),
           ef_complex(e_float("59.290199471138383839467939566959964057154266213036825288207430547436952682189438277937697682371746215414553864374941565519543345937114175320193208452382079746802305741223407026454122213481860214964423026502115323147584532309565050468940207006751453724237769056308904697159544669988100374832299644077371539884130643048281191291005222121363984503130832078530771862034238990991730178721933466990023207342"), e_float("1.363749293110540963154347880621334534595275074778724559517208864387099067909077370382313755072250261493148130108653135625060745815612381404113809688853038873771024346448788460862299024350958480903026644420734582402385178019941123896570299820704763738806171471587973131712544868636472042152917799680166520495831450289062219589832541642868526204369657801506030277685385223721872517908419551092958030567")),
           ef_complex(e_float("61.592784564132429523485931021644328264755367701665597976850722963507365162983786530394513619536639408044610969342746192960699350072831898532957436503856450408479783151202984688547768504335772960862427412617471372978624114695313642135421827408722434389136668073018398397642605428404739022576941092723041188000112049207738263579672722548683272800008331748387111476203358016215639402380875970079090843283"), e_float("1.363749293110540963154347880621334534595275074778724433207172285158133162685650433335491951602211377705994688722973390387760061265916724732829607434504949052683174740482237653505010043623493046210875130479504449481393499098502567855200586515687567605250278030379482425173025408961288297280471990147640214435639830393606536147902524607681173600047008431170326244170517358494204504100582491243319984715")),
           ef_complex(e_float("63.895369657126475207503922476328692472356469190294370950010150509625966171372308968352719011946990655329458637016359221613200872300799770139133728551403000718958153108240903539618207191271048699036693661316969369943948171389467045565008250185943918213201541141996061389872959895596835475963157526711325594715388821464914217240404743033315335162859673011812331414271199854596951423847352705761499022961"), e_float("1.363749293110540963154347880621334534595275074778724431944071919365843503633416163965023733567510988868122054411665986456281282369845725723124982632266637752639595502763794064369953400137866896587623645076496077216782981663212864173620910373584257681826416631471928416440920072319379654671280070672781730514030678979061143611561012000247067721997284981677977212440673758854016512238693942407478607612")),
           ef_complex(e_float("66.197954750120520891521913931013056679957570678923143926014739407045049065036773148165938298909796483160855219794000945206424419186709045415863610869813422495924108353132385075619267887476409456268674375211515050664328608381010952720110734451638995131779980928340964155085073568034847683227116931634977623095186711248809876787213381926942712145151634863101830664093169154089595710051871940471127681654"), e_float("1.363749293110540963154347880621334534595275074778724431931440915707920607042893821271319051387163984979743327958563167356318584003679958328783637205966285156598876862546157238035609891490884867145793995190177795918259439214560109719246971767448006743710807704492951149541044514618674313102063890045106680077202991079286375347009636971515423234830475150068404093084802646506341132368544205124606857176")),
           ef_complex(e_float("68.500539843114566575539905385697420887558672167551916902047779917977136777553996745397707724818126856797717291823630652810148047176145436619517691037895573302521973351130564279469616950710779159319691198165714887141244444574957848354322591270530597733651277637439736953516800279603419947516719615214077772846562086612611786849387207767912796203873723263630587597685171026375548954463571327471112476532"), e_float("1.363749293110540963154347880621334534595275074778724431931314605671341378076988597844382004565360514940859540694021140190812892228960580149099799321785453833690165647759619058246709522223399997516648342908309349023678560014470753787046288531544015930940146976612334116667444476011557802734152081655771409011238055353199375988363914801128228791165323614145038987975711567815818079352734093159898227974")),
           ef_complex(e_float("70.803124936108612259557896840381785095159773656180689878081104945044354538259747936803662652115912475892634018745790335023682785262702793752630035050669137708447654150083775868126301968508194110415629717652421258590375818315973840541335217655795932763881623573974866241837092364036486436755868322682165527180476634942028037187484515193058028222772636737718756281101771732062740420675227368583027207843"), e_float("1.363749293110540963154347880621334534595275074778724431931313342570975585787329545610112634097142480240470702821375718819260384704734280595252386900500653737681383705208915140689901676324672160521586655717116294526289329820035395589705272422958933205496220140322251119903962717077826821294836792688689882822090923708644101733715393415366756282124656046127999635250199120539767163182377969942932391782")),
           ef_complex(e_float("73.105710029102657943575888295066149302760875144809462854114432817272923599447384404151359434427592647442131292216875317992792605061159969114513980604076235719997516256716880211114455053901401467569403904406486431857793859209101024856077191229926450205293695438068489506636944404355945986763859016721154679146764097758970915275907058226901113890963982455403932294064089515931819335292997669243354963902"), e_float("1.363749293110540963154347880621334534595275074778724431931313329939971927864432955087769940392460299893466814442649264605434869884431369689136707718883561437543017916300367817660658128215177764217919367985379593748243091140688960504354980382883461266371265800764173885528799074382783661078519631722307054104673170578193322664000808622005804167434643203282726709765376832895533008582938205211269931747")),
           ef_complex(e_float("75.408295122096703627593879749750513510361976633438235830147760717953106173639839724258473635289411764516174371153449553969559123373797235519542589874779887729550583266741750515889005103033295508051792248006032565006587092447973743427208585448541253833956597178413952065876514378802639199786251639926173567261721966880419807524275199142129076321572672870867729331854640202591055318846812909506286346514"), e_float("1.363749293110540963154347880621334534595275074778724431931313329813661891285203989182546513455413478089996775558862000063296603737253834515284493206561650090111716430614334040401980325087540003256576688554182407505506525449755720683513082861127581544686154951775734790359362667096555710994705196779521270067756185759530912277393324488461638576732710119773000525589684908483660236244876933186306575471")),
           ef_complex(e_float("77.710880215090749311611871204434877717963078122067008806181088618917804882962343232893182010336732271045462908144678682476402218766346008944288731477426694300949877022109569976984843430064825280167136609432112316268548886388340562829895670082217713575320425761800560300720917891830673378760873789572144930486620982889643826395112040190655890359843194019603275157599012871382933869278711346372195414612"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812398790919411699523494279186043009871962075170024127417875221074682161712939491955666380402594960423974694007798990708519498871787497144646580160867318906249719904805722403208392974066870554492639370374813684220202916596060906810237422661298127316012539242859567685372644614879701407194459310227430943400510871226577766649100653645079")),
           ef_complex(e_float("80.013465308084794995629862659119241925564179610695781782214416519885348753636147223413166327125907791469303899716454359908546079930703374409842977011962409436869819664400449832793564982306177668427882421767155889654021578585089672374670257557950647458615184258355510998920555253839584313293189333826948955410031743996179576920831443165530194287112451419354945674503907242806043156571648969597464169178"), e_float("1.36374929311054096315434788062133453459527507477872443193131332981238615991575377662690375684334930518978172816613574869142100724805633499517098129524685050066238861960911932950347777206996478399732082482950629673857266019560730120252703615053603823031117050586817974831836274539522049254038854009406353724523430346628186257895245729913040250166812309077078495233334527821157702117894079108198715768")),
           ef_complex(e_float("82.316050401078840679647854113803606133165281099324554758247744420852921075923464218752003403332501862032090415834035502829942948752778926743502364678677870606136859014222507255639730333833871365475999098392285914182001679213444710045324566479744694954083231924195925906146150013221755930757733988611131962461054187099419274988057570303811236499292937814848921927404421677019987081836880548659867478699"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386033605717197397937851619922368142959924696096864904156465109790076716994321682577864143922557161141033664892725694401441057751771512979319992026606326411286127184017844664429300651131341630034142527344863022606152422766678641759718807055619918037985889291477910079952823730128532425436836817362958928401496429805812025904724115517")),
           ef_complex(e_float("84.618635494072886363665845568487970340766382587953327734281072321820493682726916344139029007133270118096266387197074700406232347651431660955937573472824415321432139520141742648852579154851131899920252075379237494826442053834122238984928608046110340687318372875615688915362475956714701526461772140807859804099771201498144834730502282467327839246830582090807808461293226869360614885814791433736700798473"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032342616831605648192567688098772491706661396476066283819688407414134211455189000567801249386795982310365254835393929925417650779255105952827845113308673675650645197747092990610956482200079715292354496324287935154229334181902140885364683552816185056560503627540051248567139588770412798090219800732869254590581601621160719153372281")),
           ef_complex(e_float("86.921220587066932047683837023172334548367484076582100710314400222788066292375529820826536496209980116015456253112568478529070671850850166987161549955215881800796271914640852008388564441466437773080897241628979217043799458457786471541948693200954258970864396054215629954422781006392548976098499404995129899053889927769206572908577645101838719075318878144326926436234110170013922929253524588174423466145"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329985827947725295977165756078787024481049472177905093234193587508383626414075049777174744515125665728014157312647240778209485478850743669673085363394573056518442888779952633501234320894624109744874606912881808419547351418228313088370330175065368807820953271096283962234292508154088078111067600875394210886737596582404904477578")),
           ef_complex(e_float("89.2238056800609777317018284778566987559685855652108736863477281237556389020525949110270488041394495313531962579735868024573744853032763307365734142154374945588939536849734619978064430397008144145957405728539747578695211512161306205556914729740863317251157905992635634972323077323934262579704863914744363666301893914070561594021786274700995597097412041807069268749493793868018698179672045030940731178"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329859517911146067011260532651849977659246002139021305969651449242125348126314795622427933301259378775901326101916586134866768512702823930542712062540694091641726568644294684609693215894494203857529543502764396964975093513627311008227313818829298841796500874521895629556452574407714680211381694813053615946518698579307007870244")),
           ef_complex(e_float("91.526390773055023415719819932541062963569687053839646662381056024723211511729944517362691160257446540865121764224060371843732953648232571063167157353447503549485080235150101763712162437246078072825622589153031099473045750401547625662686607224881054138417248629699617630909956749245538037992622368018660051469722099844865229509378726808641073772906974740382172652402621739996877628981623693249136885432"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858254810780274721601480417580607191027967438632468097006027859462765343437191980983014582641610134329623747366287805653646512638506196386653464230015093621299574053147965570029348049076007397214706145982672994522390604016103109783585014505753130635334263373674789867337157313687123012765184627647035118450558574735106343832")),
           ef_complex(e_float("93.828975866049069099737811387225427171170788542468419638414383925690784121407296968859684816857328826318789125488428493684671968542114112155532719280235397511878111844053790396859779144971070070853558141973170479910607550577589965878899057276278229086648418764456270803785916810298566862894324360529541817457660144003892540125016815826129977049960939445671976608586348756415648741265434220308502363056"), e_float("1.36374929311054096315434788062133453459527507477872443193131332981238603232985824217977661679870488989523791348634578709162857971827957364563613951560841594445857565039478453733670166641654052318323732315482273519141640276037808962015856035781100673079084068818435094680191159848074964291910476955404290578096869221937254028981934969015298737719563396227946654281839504486547228345510113954066257331")),
           ef_complex(e_float("96.131560959043114783755802841909791378771890031097192614447711826658356731084649448808291986462029964531873905302935561050156788901484906255555999394911070324090110200605842379536762527688078014226437320473487724979592348680731194906892451556830754215510781469180245128382658167822492383710711297734443191871940613347550085755735649179116125168924373806567978360063856037291840585873243754113704037357"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242053466580219475923990014486549298965288158540834492309103497873257330128184093320262097810216575714725101302625928615403463037596551078664498133066558745056446904928306720936540913353876916406618886301736953825122160778376036835480591032062619859412173115569161571202986295446502777964805986321350146251850734184594681")),
           ef_complex(e_float("98.434146052037160467773794296594155586372991519725965590481039727625929340762001929041415291196779291272552859302944017870887067315510592885655856691465620924800308319404084104995125271925195138918960631539638245398315685025735132086549724190724539702488056967210312853181229763598952806997076669214216279419672716733546243710483047735161579869275604687763749469616945639044290644482236427504275952967"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052203479853683634330962252279928497070123840445654436458076490594747345306489667707114943022761625749916099672913626192483340050334272448578745861462828781198418372673830383234898390904330255498590875812991665562951027698239290846164677607251146127296042466291503325961597722841969108700930437684632844809776297410405")),
           ef_complex(e_float("100.736731145031206151791785751278519793974093008354738566514367628593501950439354409277383757282829099898507755044807488586169800310082828441056479759838960303395488436834264698492230418346990374326867003401078001720206749183983955519649990215042876706324036196332880215528465292490012831124739666480216776728526001707668790254186699114631848270579611268341990039227720178623606511021338658326492139451"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190848850025711434371729937234792387943493441766057731622276768121517477713631181565004361078424212253670438326072056074364796902621346135698312936383088231912569367917034950125274414417411421022938809538051681420818552744897282157291450361896859516888703508558857906555547456649204092140101153310005863616578934193")),
           ef_complex(e_float("103.039316238025251835809777205962884001575194496983511542547695529561074560116706889513380674982391913343315410204089509440398057850460529485710110485930487569769518374250865628366784081651489338543817424532417613491444457654608310441201878808726148339253872810150431590799603653052460548231466522834982181000152955245943797707979718589137007637808130633910787150436439233874922500966472058804975705628"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190722539989132205405824713807855341121689971727173944357734629855259199425870816309504963462617690812255088259690774285845126540507886807239452083471082649226109241082942923424605666319629395196786183296298073874887388288024791537343943640165580122670478496734323305413222369643863531379129834298279724929920899411")),
           ef_complex(e_float("105.341901331019297519827768660647248209176295985612284518581023430528647169794059369749377877198089856836311592957545715796015770636296285185256271288599196715021336809867330771699881936234101425743628475178322418513484664065059844985900875347366615387386040558792263135844708561612383943606170628338141371362979157615013238637002775678383158577523271363316121849784236319002803592216048335379431198837"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721276888766413116165661573585970653471937026785106485089208472596616642993212656949969485359728147234455653254910893917486845103972519124460636405197838533942499605224507303114107314045196945132815871501883256485511700894035718733313101100091844826150644227725150962356598363658678020620073087902520556697808986")),
           ef_complex(e_float("107.644486424013343203845760115331612416777397474241057494614351331496219779471411849985375082258949151629789660986943664006647377974586621431351357392033677679061933130465794557168574709700105572781837609138275062087502526358059321669262169224628580744277122758038469158212441351476928233471465493483385719423466267908601038669746492484894051731192084738878936932174987294931760544536826449363126616651"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264257762755193269071051243276948789756679781218106362754258769990815164436620424419545587038530839188679279975054940806203850755098273827681650685313951534301976426385392313743137259128038304308126343846726914402609026436695617908766994144811607711920639486684174979751197068870975797322747258768319432089192")),
           ef_complex(e_float("109.947071517007388887863751570015976624378498962869830470647679232463792389148764330221372287348260059936272547869101029635829124258401503482911932748475816361290417229914078329058623533302640701511291580879070074265702112172974592741044329157902678276891254790904644538554905500899844269573498585100934468728382885219735928330903790806258130764183491684069525129521016526639991752777450668936384118992"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264131452718614040105146019850011742934876311179222575489716631724556886148860059164046189311623676261503475434638830533657013793006237524403799111803338062671347117002079430780950632494748777305338850288560319594876279091574204999955793300643953150642253867479324931733794964414198587939713727120151118586319")),
           ef_complex(e_float("112.249656610001434571881743024700340831979600451498603446681007133431364998826116810457369492437855484377885482939785989439196371931671630992527162997448031620700780207150860300812885917416635909763767287083368280318965381417805330788207401176045159722981880868175931005038437148369010479434700920276621627569200088360063165837233958479740591456240566823874670200786625690988149402834396775601557496994"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130189618248247815486967615742372466658276478833737617071210341894303365982455511491195334354603532334266782755563658880971380942325378591325765665393391190285958606106092573832911742538522411672917836145986723052529502460008250656942668166893704684448004708363910102546088213409285457016140373273117880185")),
           ef_complex(e_float("114.552241702995480255899734479384705039580701940127376422714335034398937608503469290693366697527453753980849718492356225184305474618836310956722939795345547645882961973165527254565790437135746728288443821560910087787998189683554693136027431985378755834466443812245875473522635602837118200271048371146697573569705811477303697732757502005093832427950072316575805902668230596217530151904864847814028508068"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130176987244589892590377093399678761976096131829849238344756128067677538153679474965645394581912804932584951176083079556005899417441957954923062720973660621798871535616145170823984949567832126674316939583647492755123527599367188832431052717881515021667336547104803403615558315923657904765767210546213835884")),
           ef_complex(e_float("116.854826795989525939917725934069069247181803428756149398747662935366510218180821770929363902617052052035427467049745313688831995856139936445464522058732316678722861927067973058138681378210908703016790061382277192128136395229731903673817122697591297335687572042176441982715954650988417184152013620439786360860176380522893714254733276500439901158001886371919423219315417101372817453416053008778275736506"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130176860934553313361411188176251824929274328359810354557491585929411279875391714600389895184185897658557133885782208971698524096452699318641207894581159287728633017362592675391801906679580365050724636883053994349356664209027070371956714750443707127462296436431524495372760709901603893678146667430870683786")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02125_z_acosh(const bool b_write_output)
    {
      return TestCase_case_02125_z_acosh().execute(b_write_output);
    }
  }
}
