
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02112_z_acos : public TestCaseImag
    {
    public:
      TestCase_case_02112_z_acos() { }
      virtual ~TestCase_case_02112_z_acos() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02112_z_acos");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + k;
          const e_float y = ef::catalan() + static_cast<INT32>(k * k);
          data[static_cast<std::size_t>(k)] = efz::acos(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("1.1510450073486005371597672819923823385309746297412718180201013130075264256462493509247727179861211064591980442562179708334685430228032156520337678522112617848006458640174571758898284349913448359251643371832481162783778996234293362991533063388259048915107020134932424000690612957691313759676443711874810855926598870333949540259894522652436305402149687117832185597660247006654412813110507621241635848641"), e_float("-0.8835209259011382692217450526699483530124289225482245146269742648119890642926961453421894712808519228900712727558057784358216376052591459273543258303938339565978063850866333875413307909917621697280643610689585885691691181432640336275597054931424135868318572806500684614117254879616613997214221663260040097059126726201806290701615668182367978601418245226351387267501619601084490789629161981862194620615")),
           ef_complex(e_float("0.9208073589737217644541883878359263857820584719663737124272514465847064599698553609070026940347898449109465664331976366124689716604363037146291112932238167554329124453872905514684146466515522927505855238827379270157282200772084488376290741298390876330933783375647991331612681948807406312663628201233717564588498854765375162267494392115482259398356402038333166120091997052650980666968939127527129834489"), e_float("-1.6120188351214433861687445426692401978310423820192766877558441436465537733040649638719321675501249173420648652984001535325847307393944752116589174951985361167401507289246080615824022859868730945166652592474207861055513633025684389841578101874379229803835643590578344918376787951106032592995999028333889289674743951221763482946278843933818575661856851330021168611353459554970126767626272119618866234028")),
           ef_complex(e_float("1.0945161135946206641674316533126241848240748962650966425018854294277811825690571841474882467927748390275137759387370098398439715666533900624934904631527083885362814437333869935474238549413166358736656088682340757814843237623410266684359352800770550292378731617251725606194341203596059230195895206321968855227313971437313758925572479761442763185196923707091538409842849031524009283597830191547989274205"), e_float("-2.4116955836053260750523721053189742038337405672941060538837458524958004936663361205564702270702020809232655039516553926684882796558621750311673025673685575678996426544026365316913664398376125649690646664602634168632082532210683188670833406731888351484362263419055254224007581642579112002867781710390372648260347170705829627283453914234379285775452723173824138642356585381958535153282163831698331574017")),
           ef_complex(e_float("1.2260030460773857339925647583289488452099886712367412970602409246650975156267901794112817349065955986373234232198650792392691653707617320524184328818410662192159981450260443584928937694587504422693340730582188947691679352239559983294820090132842166468004144109949479865324033449230356384628009946195042421605547254179349725913559477463677355074007867924832284748659742682490895334296592663605711611346"), e_float("-3.0501955269052569761084637087111950434790658482848560917919526844266943298338120385699427356443900623215818019650066175421124165485102429780305997259046207481996634782670119683665016520397789757079241661395699405487515509214895126174041821882685040828166326674334126599351017226116515724565287190190140440236751684460710610217499130220554945251889242322071158276327644253563367185021060062471016532353")),
           ef_complex(e_float("1.3069484489801606987091938250145118061929467279387776928547785202303737787138760753589164379460070706954955356121106826354772914512610923801444169132119696964051328347632450194458114331706021003758611256163966300909570979630499388235112111342721964260878147310804053140884352282943444652422014222392860827979029896004464563590693983122822547953575621604756787355746224630475559814855504114391614029699"), e_float("-3.557437691819103470233064100136284018364316398260030015165248699355289100078236349808728554603135180204262899979671214051238892699946074112691782735066664587716263405568655142326486907653920426411123156392985706172273242622540073377954952706167859300727698087311184527016215510726207880070345265752663326872053724055114964293772644318634639533964489407412727620074884066110119854348660768567042255562")),
           ef_complex(e_float("1.3589715256844288666240293062428831722480133655436696425902733857940558608398856478038562891513758987759192652001180785144699734462974815895454161368705494722271375000252208096012421179333382739694147442636897567443716463454181199183202851770052842405793534701826212576168843866371532079079160478514117729606506810060757466323827595204523648437062718471551768469111914791905969191920442073107682788905"), e_float("-3.9709666561624879584104064431626114736280767493898197560187477435807016893069593232663755368030534673324900967838101410154133493139640649633569165214430343396489451228910426739104769117142933143910951008922260570765652333772454095992929227288423580681216813308350633580089085852039622101795950946801338125378120732812426187325887671956267108638681659712612741124070470960035520127336386738840177913439")),
           ef_complex(e_float("1.3945405746731050687256842287255880129067711166292357136582298965622028281038105896781239021666514550040641389657880010797489236519125988318578435714922658478115043031792180850354056291315102202191371425610901389737961808341733632221767543481940304929017956002527680807056845328178942730392741856496531193683812727000541267617880573993192863138839504220157346997147081417833364168923947372923145841979"), e_float("-4.3175832125800969181756252387468090023376746480165923932404977521745052416093750430329093227255041859178911299339885032197088498044277739020272570576059739223413729055379488292228401221126135278645058187681224649068126809603770016221999529808721561611470739510422470545603550875356578481127840172652312969696883112819383959100814828481009563807167987869293952560031772782293703027896019075288027885601")),
           ef_complex(e_float("1.4201760983308964897437750481402691852732568907455992091909314008390831310002686391926193612771098914530984061203684261409421553948059788766561302458075284723842838491827656842044131966548432511240428249587431840983775499564623693882670881918621621514050674367674881722133620357215534313480024426999004608694541947305270520101124442376073675110459704022494841852226158394282370345561808142349715022707"), e_float("-4.6149725248415864072320185806500179739571064376005293421016821468178453326941153241231397688242305583567792390358287880562959622765252916643598002898895315233153742636975144012031611361472614487361645057749520341663943261833214862612956718936534987725534420484191064285827065405479103737253519458572647938920007227373009739519867882169902498973562814751333561196092555652074052860542900290962783836904")),
           ef_complex(e_float("1.4394444171908807413606570897696133189169859780616437697592071299763209555504648743385964094778844495596877481392793711059720698464246503168524188474456419528153653898970721730552092717992587795901458087493125591370247857280302800683154253546147853573808934354553671439252194334862241588681149645722800422750958072460663980214370710186145885053853840609410140635087118433053360371883813603768311556631"), e_float("-4.8749506623678544509422396534572199146790645533534109545380004189982063687626965324188811683739485340888067241784325680640531644560743837714366933403204247259750485737375818480053150494906959967173733260243087054421760933394108960182112445903053746523440400336442093479920159857180698865141305712859379642258417631089471234185857534324151556567263890263200512810637696677420301158222341430132572368021")),
           ef_complex(e_float("1.4544180587062397911209165107612349972561783360391084020351848930137421077108629037173754577423040301849762170455336135427132454988137481585152281409518180470449962602318569580732883163785915362784547720662714268067784967403266455182239869575054201075635093645370274517071526818755307837682511759907671201903681951276921715298295763135915836356530988366183193809416339209674036118331812352001885070423"), e_float("-5.1056651372597638706445116713449610155926309743876837765330019199964509381349552054756756817307240413259897567820306477183933664462006681186847447335213012157371959891505995815754371388028609367143825556795465186556794045853934825561223753886643943638942726469709230213498898608224297505981772120285927989994796021733963332006035963921013915576214783727071789024415994000723411656439418551091903380363")),
           ef_complex(e_float("1.466370544501155972591732007373518568818144401035311256782582700960398847358911109496511872506130369567582364262474684596430866522142643718384474813147362316674585921117708694993484790885780861655375260639384770109393992210506472747584614072919991537263238897406252819990947900697668787103327443763247951640036533410226716572437134271223432809083278866088471936565866616235289656063697517082758609043"), e_float("-5.3129219182550612974717177975249025271865198920077143834162223920257313148870457121638590435162390591348655981322086953984450826648943403576816439118122375673666301740390875719843978834617096795563083776934626776818161792917577162603186372026963335336368116226572890234566907484119595378839913424361703312075519110966010819604645221770749248109694402011506261171421246685030907350589153070210557289139")),
           ef_complex(e_float("1.4761227462810929532498868978737476794659303552445767033478965468995819743440969088624322801363288667597955638183104256633392252357539522323088065444925139629234077517864590607998412713002131855141782472440785741106871566754188760649720274026599328668993247592999194247873203338903774626264140956997848108105151835998067008252269170603393192407140146837924277710964374459207783902276629599421702773297"), e_float("-5.5009841045640639021592528350419669019223125841878550562956569075367738772161882216967502701209225193513428669645751476233530634662847800342592078690136252854795968486291750742674493059589919335577603424388761665902465840540658395802362397688057455101340171815778416989692563595919183364946921267126967458521841651331011630461555974785948019448453034317104983591974831863851109272506907958759765663594")),
           ef_complex(e_float("1.4842255787766491102671214382545530273509604255754116624697638485656209786222807476193171652201474254668471122413698676337858822760336711831380580298147480808588846746160661577781157622129287332007186531427842493693626813685184421090081831941059089084119079876158235763390100069723321294687890291071760145116869907129159621482192473109277982658166372751382268318521078313029277856562654347435152589202"), e_float("-5.6730649597505299428564015479035022893306350290862200700187928612574880481211192483516653698250225245676140672669386021790579849398245135184995280493022278374446766125849479397153125795554744899043091255610685110553543767820972993169049643398255513295782128787091679389843437207863382299284094326153765522234451993622212761764817309973629081572954470812860394860468607483566385844545601583775777064861")),
           ef_complex(e_float("1.491061633566567292936816080537582266337580240188880063599537544173985680692856251372704217544755204593815403613986775824066525888953389887110736720535546318681432894022105664894896170720930612654718311185244992479169794327842292602734863482478300782170160667776461215094787735411545870367728605080372173605906146343905139142530786550670333058356667921168996207611004412634383187845069006884098308662"), e_float("-5.8316419640442112160448130709350765386381329122886933489322459356929206109670523086895759134768496605619357858269122694166487387629814853689004897916735867965718396454438735992390604927064797071439777673015485498252159605855147620388117385929419304346897804121795133729053200877201171595591114592575225650498736148011831413034813848641945118255682818346955893987955838336790446277946208942049803325492")),
           ef_complex(e_float("1.4969044573036647132770102659853650240189174799738305992107404880075245306949087514629730478690164424267827140778477161579940097562720995287918870436029696950779644077681737336947021055631221110595840972597086086048171476589555230056282059458814344171539186245523943484265995005959923931615518375109916806504364616637335168455234598451995351016496506843162159107379653953331261456805323419914525657927"), e_float("-5.9786631519261654641746281385327891665907624629492383217604240708067533816267000539274102628245941497719413677035056960005166944300108982457192781031665801306863071249352199246635004808608659471892968350948871465641189513390816398532790699393874961497921859199455885862926855929900564398331274310488989136957896969721251277390324843733865660364579177306421947182118616799697731000895171933230215265662")),
           ef_complex(e_float("1.5019545854188156307791423913003418309726761788296108907703033279403319570343217423051912547494329585562447388378861247779810448954281410511014462185870347904992818158340335269475715160496009722265822063002354960030207657927840170209548804535193839432326452273842996463622271818946066278023437546539377947182530584552705619845106142468470735648735733475722930988005241626962055126518566595254721792535"), e_float("-6.1156866188297921789103119198328258642177444249038714635036841441669848822715370870635428344920184400700313057944861689584117762393040689331932802693561436911665969695023119286193378006448889059393495758764340437510930596233496825223412204151834733522837007461325714298253355804151493320023219015630467984833821887872096088739250211528502276975745397011246747302702468897120464587958552361902557484178")),
           ef_complex(e_float("1.5063622504252404536493204947855249237178240028689106594568926461354320798838545383964013119192663924125803760394095102425461826413964526008095181799275519476262249472963075988083068212840057082812295503784050164234879033885563675369654114898075102670457172149953908493371572464775019251802115864150319872844184061867392258376400793817726861044193401857871181722573905673429467973663036724249893323465"), e_float("-6.2439773147919359750694225152062244860268688710303751085407500208750068616225106275820452938495089480719197229635537273781268165397258275342916344792915776453295693457460529795906105034701539380347600551899461508017089896007043184693977393163518565143841736512674904730770409816776698083393725444887178350092954538027944989316915893885707365841021086495578176849219126557482740168821414049820931031113")),
           ef_complex(e_float("1.5102421512727008569620965852333231441825081007169376245261848745496881103840593111876711760443931833259870976102795794230932914792567264902048575728292635555700599657914945430444435073373653941401268903045934636605114386040472925847847615092359471293939559042695256735298822367929282088038055869947837432298688350350236521378026213047607183194027937229553146917940007526014569021541111528966910711875"), e_float("-6.3645757768438302700816586074014252378373644770595073859553623894371993385057832465868179097131162100330263926992564673532998670469577569542688331318530246183228682040610436882673269185115195276708787936809060353195884164296772936844658937706746286381819884178304449939612058507238973446960982367591319826275642739233303706111051817060697225434199112042397772438481048753422435656663940731555443771796")),
           ef_complex(e_float("1.513683329400362404552929311515266957784888947440409364081206803134075730435612158702749825596198703344206751857645871119857307368209786903261060495508422281293691008297481980084049274124502576744251808446086505481940610178837234158458618778353922094750171890352686357421710644562587251204474980155492776109957932239016669724439602949710600657816826073301143778944328199736141880797947325303995488526"), e_float("-6.4783479570874625954474792971109038009099898503484558162459204968886251011042826869086207705648136650988906954143708904822347232775554695314646524328873425609759345522682034112619481725449496438081825866220135253573999374215808131621672923214267294963650003163330123893883186833751072121881307982002112179852782287407551614634106679026692248254340076878743289246239052396020839383887264773846468173083")),
           ef_complex(e_float("1.5167559366446443173332896088674854309819454656750127463088959513481923605904025695040261437384615892750889860899680145997318977322693536442522578100834406981111296487821327284595197496944946493746979419604157453917406325241757101121562860520679800600118896887107398088311799879004226244312664730642947597811601036257371452082661534115468344474612775922886740137049349043582118379648180444575781899223"), e_float("-6.5860220224110415776879788364217360454452591075079998539112423217515302611316847468832464139198217092653757539420086349770159456846823364253190611118942188804627721050557804011510637689469239843051660337969543766810510162736623184825394004011946261002700235924618036024459485377757602706669606756289934174251751833863699402987230093476744022991013042857803241970431536034723703467089554733224150769516")),
           ef_complex(e_float("1.5195159754134051641096432628553100477299015720235621098352517253155078090190063319889817333110783396998588594477507152502718232656010857605434392233938890757556613393160054554255556987843990124612761060836536355735256698642365631862743828520255954690062273636608923504866306546808986504431853354447655850923893381261909217305224852240748700078189943000544540844375861648680710274703183197934659610414"), e_float("-6.6882159889633781283392200110223442740000219469856727101877828930312875873162453548099868207992340755502380705074450696268216551394783516370414818377929937515341204200956217388348707584460072267409178631427841997683174314028523017452514961278482109240498569699985735962424318213479720499546242004799380765818536286136816591032365280650237072312910008039935153906091744041484372561183108924443793156102")),
           ef_complex(e_float("1.5220086840088966505861535283834019992992154921532122712779944968154352761500910566897923669298337192686846726513554827026464489001320443019913579347481182235430499502140951214156918228300330171985432825604929941636906041823424496467348438274113901446308140775856790634731629234095937183080665696851031746602435178252386567799598991343789565350005019296582427989806240212017645835980617620938367714928"), e_float("-6.7854587880444694754559686914909953552073643788468650464968448465420221616632947445291438353132002516640731784917353815433231520216609804444625439840206655522233976859639801311227325683712336438948762021937673635294939254445187235308132233273240169520859678381496841450480758699201734426194306853550327761115027502454977901175579670804174023405877900005702792542653919439228519164113705950039741993768")),
           ef_complex(e_float("1.5242709970790697154204618566267516688331377760451685055440172225932818426231557888251829033409774302398430783737351405976431475140199987509561569975677817630292097731297523857203272139416767445472976143942186170583123130776833501579621677230233465717811670084690539846726295337385186543597094613516610400280479403374454373484708108621339143263867179701776192787128379035158084039168854934220894613686"), e_float("-6.878206544386225606081081679787134789410066310747285713638421786076081629199862921520188647108623195962096467372134595304745946280498812390594069037218617600858829542588254483406805466589125945422470919003902352850173879871634837138664502871059000961670951552555108945781827479739471213560173329394855516069112216770944027010965605365479948415780717746478731763375176581412461930739136708759006810313")),
           ef_complex(e_float("1.5263333623937839203421068186784891890515972928592329828523259736816873732252466053259152622182958580918755403142063637899614295500448014351271947723788397791207526712166208417752547839349352209308707887043662921796304823372186422027976781980386397427260191628544925385033900740111782416413319489775527633606019152554483842501182868710623332125291521128447189897081964930441989256353140525645883299985"), e_float("-6.9668553110403110085905970804619130104783004266227238162848133532587902177153822835796577111618374619509201166772906388860278300592582149160550268238881909501595820540684844685204892868646012005039284857188019731760165601117049990639378947719935183813712375252788620223371000936259030796022830260196220660714174260003991029103801400424195690115924003674120054646418902889928608786706967260088721570525")),
           ef_complex(e_float("1.5282211017340535011388545807375945015467185015285568768883992408235263610692412328990816535112739125718480413370237345330368612980660827527791860800443012602812918850953548544289179340820617812468203112548565942946267409290229503497596738132035037634408508367102801646197880588350304883765598803008558310743363527207810346986842351024337062103825334369024537745649907815046486400517713655907870486182"), e_float("-7.0517511448466739516281369526564553825538395715605339543840256670993803775540376628021923815642625234742416692484715773289925983573680067517666803566228312783091265000794399059537613518162154601257500093858516290973446057384968884831855500809372388144919738032314233548123491555004885855074662971728622819504490520590217852460997243576960901994190449418285517808034065591031136832720790248749053826428")),
           ef_complex(e_float("1.5299554437116174790967362933981489177943663905216210506443222174892736013866291394662750545584001484133824637452787812956398396074095170219071351569256825670653222142346214626265816603960419777011782351047953523711123555758337993846892792351984639177811182926564187459763699984013698215296061021699081447624761063004250306735757601846937268649976948561507980071514657874196053374276061929687222124877"), e_float("-7.1331981602624340672280042251251945589432161753885463302745527119709111654405171744261212905416547541249786143454413213768444487294346688591718847973916782316480335750849934038316471713010699030903417653479455489190217960809960586013061519425106438355802291198191792666657466662117182946811362775990980067753450305627995852456900731685708266264594459579533701836842226134764330016342618066907264735763")),
           ef_complex(e_float("1.5315543170399933701733433320738374976797174886568977844700876328384649091663997725354417874838425923651069529018749627544009116850191228034327337946302344935123524276365415848476533559675423608535124419820745226834558889463092033192899186597719788206901689448823579982602075359876583893065668223233836194006678426324706564554015080065822818026592796651828160708516014125583723588398276593157870520061"), e_float("-7.2114650282549582680725248682481747581338288936190609171869479974518891198059853238990920909942107287605791515753897393020172484261787856548668160928739453217234754056804356109618490054406275177775011175618050824872602258006239740837852492748949616217713330599613404549707598477756077200998488172960133718117464673637791058169798985979692581235895709347573423612218391071676141976082449403220111794137")),
           ef_complex(e_float("1.5330329665447670168722624919370622765408570417869106187434196363864299083175323085011165393268935181136238360874443750840012924230882259556390464116073431395650254127166358270897914154104729717793253059682144774906238106747927246380009388922304710332523906190526636223170232413411219439011564404433429944568285566259107595900793680640602916285220709935431917266841748611446262020622105598473852051223"), e_float("-7.2867902662481363230526749340961426552546898900643249962588750180838065891426652905194446243376610311688695045481647639096714917406420019087768252551106484183915336052533092614440552089657752291550387618349859526974214534615429419735740819883308799045929903383127930427258490464508800753833932471204112021574947035489799093717808541099792494818773760973072359627823519823241258581078593482182700465859")),
           ef_complex(e_float("1.5344044363858844197518892864774766681476613708628614337646700003070109678234566794992512728637515990574766515857520163538413689888188255469545482158768324647086927609519283259086885024058663437829325773864438812907511102610396788900740107138122563008333293342968541607222287031256170648533287944961272492541867941995906949273825923523117213343751123704384350391924043101669220370859753772164763991641"), e_float("-7.359386578717334993873173093685358642726205790782409144793444136125734535891875844502056431221917343435935588614569246562483141740369248805314825620805947721491431670357599425401895869551426851546514830575540704550163748381077456307822855885732978184285786713799400550050117364669940007292522145747799888751002421885864315068643379967982894567052014946167646158938918450439753700234398580236873414957")),
           ef_complex(e_float("1.5356799526747605188953006602774819361537402660324665480577874436097924081047770303682460249980297662994070241571935626524851985343556355890570878374883334966672569405116974222123328215080431058220108994120831994370839774551922482101685362493257181870587651729055988608517957010291737312219070677142768742828806714159736808387778757862419474638123911814757643610422824801336417600710999738128529630966"), e_float("-7.4294444453828654916195208818637554747111292747572033455558838307149106386349343015823200899041731191148630875881829483006050040905719843610114768779386206967687417011444148984437950433811609481404623875979543076523364044845302310859881319883038923905724673044612733236703225419970189853957949139988732503033228958021443163929839174240833915261235050729319380297943841688550056389817774424326985236064")),
           ef_complex(e_float("1.5368692290665518548603973728774308069291860263327428846049597259410290648057803507861293621140061121677494658919178959737048824828368993637373158463913935481690647873829032111814725680953479235437249201652709941168028290115448420148564468387332052218296343631180771678361987925431699095689318149149374046553635212317997240226695419189662904513943013180054352261637951722443181325284072073550832760601"), e_float("-7.4971351079710413122312753533713730908868473475687697953931831835990701034398054105896410063466363624888785013150859697091368677849416976425696548859223075348137769934232805130160714719085998546630156516671175020091979010587928667888151723761223514564617013615225314579525502675286812376170727547017471702597091077270062744956538613513486396390624309924532173967056017905608826163361575062939918287509")),
           ef_complex(e_float("1.5379807128050453953058776177643903045868993063234253476992706826877278106825544479930957827292956868394141116728586676732249889524586147745515586730760738564719516256156153232570033230321257079670024041334051862454601010517692981321335074246444504199325688206925248678918416976918307716595639212797083839014779777500989068624781151752514314739834413543726272468142168270689430971934575240800348881306"), e_float("-7.5626130723796774929471296517993538614841377095838735200180408143643713852391385019676520932102961643915435031959888219130620491709770917425764493379487966398490930894964544733563295286745909574225953802188669324229918280434983667415044277716931451751642057954777439660454616677098950532529537163330972220303520493074826585527390993487466431251350166504433710815462398225489102686168261979355527830725")),
           ef_complex(e_float("1.5390217843136254228733239255849611786969747705316047427730852751451097730379658555752493199675829914015237354162686783766986097001952549364108790612640492418481753142780236512532796497315379856580898354879418839928002093382518511302749144441093703313011688135302185649237225068226066974560319648378859444932135436360866445162251230053401948154587289447821049114009351018985529969729297189596594787432"), e_float("-7.62601821748014701518209837594549960935627465052139679994647882681332561713278192040229478634311859024614573892379831242311512620541025098114590288189649466501437541424998252440415657398917684879172995456280058492756274393132616365772897775034140066786276290402599037464307217260310664507713886430572187207178935784916535092503192630912348137380119307841786672938322987720836305711424975156738053041")),
           ef_complex(e_float("1.5399989202397632005859881401271055957993875970833812434047610910842748915598649171818179052040294075828698259203179296205657352562618074556882552259460094573663290085034387856650210468081806895184757465395910454307417663213447358820986487192469392888010271299018210190312104380294172663590587998027492492809654380865618623097645831404408020105447488597831695239140404117725551602211025178574156022786"), e_float("-7.6874775823909040770943956619341911007988302760584287129312905896303474744022524568714864455448761305196558560412907019063545980429554259508376352006939155926158471589497397439047189960567217680961582523382827607922812788728368813025195880789711500541427763206328934486539133230629357944765594231265839761861119826717668370914126514696947068695592355151424342485480649578912195580911988574140582212666")),
           ef_complex(e_float("1.5409178275198448482784806414197976046436978900771114723817856551793813730780794699548230243059910688474486194629004897835982496547407146446732729175998739669960327151637997361475439711563069781356483759629484485247726054377761293439379738412134779158083835804125152186376461504749548349929928480584148269773072808940592428026199727427465926437069685891447781310476168764975802012754814560890226749773"), e_float("-7.7471068892272298960494801674977803675802969773817098753456190925153953305257408678678254873587200276568907107949909574604686805264611843183832733130889583127888659397316646665361176144034651612346243883806338241750336515861062676793415832361543825118493565029031467318338724332132870138296329330725564711570844679122201402303086410433752404523696414054415402152861166217639303684894996216601751310991")),
           ef_complex(e_float("1.5417835542940842172769188849338015949359627246284793815317708946786677964586803638288747316020213140547866600536897517646785101328355666084946945206824456628433945567989786816922913239416599437276658990525866776713409004839409652392611685505055947157793331952742385050786635483977778082909625772652956737275461902691376801775917972738901669002710498984728663300487168740330804147367315213729615121961"), e_float("-7.8050118468955588721568318569379310800366284526641258189807784821175608844612459481549320380649393270727844923856694101591015824539789193481730555880123752380753596184461125585970615540254814653920938042778768674148632234471429770811150862302606437609735183078619785938290839656167066520039646254351149930814761299442913066639644387854850416000926635526889803431105223252766329431368912246612438831566")),
           ef_complex(e_float("1.5426005821998291775403346987605262305784145935056249004064308732737876276853958842944217699233824537779643343633956085418806620278060356480126645017832977602210372743037982422223781611560122610275203646733509012342303303455788281663434914407414828384880147435019003072895554692552973069143802324488180154352480659306582878440567394826665795582298094209936549969978034840425676989828025077898540633351"), e_float("-7.8612892726099242956787943829433937438233734619806383094761485964121143878554726779338662387962758699851550787017684860225058607784356286426763144738392590283743229482014492005654530916518448648234402559489276740226408957041061819394889902895924029065512102376446239013696362367561612958635970870815066424142962884782969386138171872351150868314254046164667942228303855349516832436401760956418555417215")),
           ef_complex(e_float("1.5433729035877847741263189963860574187939926972054326433329208168862171270196759955441895042475911735749269435687835445315938731868320468343990097453395882714752638422852485544935950592334152653961223954801875573887480102957462623497895717861287482540698259747236384875496340888707062064217118158884928074628184330157434645390120120878520831129675892951273210904098810417472713337794944711534236418451"), e_float("-7.9160280608434853657825965631414018740939192479109258818305378604163149619185775577104963719316596287638661189578389112190597186484552117783643721010006713673246554977175041747930022567732704490218716920570489038053659186352578384775267233468900294170536200842231048442307153373600948144252327032703219556329327717178170215443044697276575267329710539765145593506938505038808522193518052071495686294983")),
           ef_complex(e_float("1.5441040864557537693721216104511242854015824837635732027070134188626366888356399171708928712070447933970173465867333277877197177474809995925062333550601980150866938617438204938055581437450018038624647366840940660180565954350192278204771460331658090309843748317971888030682532526634012640291525249024451019814191365995883143653830341859429674934917857486914866513521931449510950365759039302607758365042"), e_float("-7.9693100239332252364843922352559538199552660054387157887496206229791780202269138319468709459822275420292724172243069684707548910665413844088285027128207112372744353830793462449103766991276548548397968922807781492650288794751937634882520478928965834171461619519030152058851899305892637710623652858513623348896255339038857894814240848725812335311474804068633366870901973706555073629042807472099449501648")),
           ef_complex(e_float("1.5447973293183090871334741342415737732228565221903013240497382499302377994604029645712415233717855199822731618607235508052033676000670936899542234148869792134977049511632596528268273791034515445484716251204475472153043520240233360754927668344419253258665794603609801693536814602072089967903486618001034570939565663871317759773041207102205757084296277387365303315456167952258666602980564551384276472046"), e_float("-8.0212106241912013259006211658177106428293796452007760126413206322120412113635957282444312904181249856473320159262158710231423226975429518373565346013272146613998362161925234938092363467752399321738579146847093992349684088432028019320430547017921125074027366193765904559112831913333517184133978246767796811569029512931632967468361427908427846281684336969735905493745410294659480492859673550360002169326")),
           ef_complex(e_float("1.5454555077848015852412452763639068341577482795658024579995565172211299017032084267749230836020718791036415191950377447757422571994117492561347128052858892279985186314884057358821957521494016202512203307175118415897651317243740116157930513396876673646375865512438003393735451565083967160723289845118886767304413341291119924885900610903659617509229149023261422302044922427644875295702754161852548809052"), e_float("-8.0717996138865206748082622125221515886228549059058793750259860405720746342301028884603121685628486680338930838728149135788061047277478736179781473883987149565376712872462789558047406073989415046606777931027090291167208686778993940025469243820846118877321609317072899839365844250586964655197432990649930363793352435411560444867167256539956034615632527896136686418838510736959726675428165170764550199755")),
           ef_complex(e_float("1.5460812142704195520220623910833198212268570798146894151070856338893537127030183489877900890710610815978479401221802997185589391667808356714648449691324747254047200267973798007629942929160256074406434167525968629134111334719266949639672654146402788310444985230896236012441377096557538847699338265897596607611520269354371633399549370829845789908072745145868777660574516466248048114223049697758438806185"), e_float("-8.1211415966559754665977962469661624306374277607361558299244276951237379044273012428129822173251140571538258023307681080033727162809052570232176652285882626840828641217602060192873509794086857831174620693542277985497366539383308197279390778422381163940338024377766290803334895358007773934450215005661497690954042485020404543026889493481558268219724838585800767084921959733030486541285094590399562036291")),
           ef_complex(e_float("1.5466767919921636387037461766464976022603838534868262576262387764988621863946112992516685473167862288972605878670006028944483305443127164660419298818687030312683595275654086711525611585921702210163956353398402476136338333573232129353959030328610359535502015569886767652563988616500460403925751988367994745844234167484706713652743568030472331300527777020172446735679416266756561691014994430882321723672"), e_float("-8.1692965216313509644724197192649945481939016478062834718827952240950944945935551058452244930553445835102778685577346822509175851900266335843298933335302638683846691224579791248205877958323043990679223604545730193732484955305686513051982968793242126204688869093238145589807435254751857603162855569399486824967447509130493919070451667736242743541521421958392862753331958824168265644321435173043868194808")),
           ef_complex(e_float("1.5472443641861171943808762058680591417684744098025703009710580984775158235247569747263897893649123311724135118596366338403412643793577596574954389038950462091643895024782788531166335969362581714743360337179170810288098878367463102413392706807972713387577516087632851320927302655850473487318059256933786556101325362585924520550724024559316726518182556663923914482111889856053416724528257088521506099205"), e_float("-8.2163201197252961579752078923523127663850390719258189719338709438178204114573701013327465678194097144800360235365037729756994063286782405968684936546286641313645940451490709669228021755342090290640719857259047269228683406062533012411749924705455962594678694956162629472660993226191980380246754739075734907776366005224035242227423014058843925910648645572984144084805109813207628118603048738712088321251")),
           ef_complex(e_float("1.5477858593111901678919272242707285988439615872958951372199317241079870062185274806309480216573242594528417258663927287113308718215020802763072114159533420016603893169644100959636930180398926007576682953974992675521042580693370370734929153444577483479446333884138325768150906878754717197940404725173780779375246138539010844381934458101362774635260175060446885615100802231205745430571590361319326993537"), e_float("-8.2622642900084183814812895118888154165136713493741352405592442296427421522513256594204243074931863974397919919486739390101217146787002255318974382498343577801768098597335897982221317357405561950489902167760997500577289339242602043863861444964503313087494323340588811136671972604946310531447497161368896700331976356396698559306815666609899589800498934286578157637550104406519628704626568231404437871859")),
           ef_complex(e_float("1.5483030328677163745482483298740797497594005342137092340483625919087889430534542217462044287217827143731844083282037736473093722172730546815592187356852559716185282619025865575727728850135204256966975790896800318913077745890383845071447198124854924993835538657180386565538824279940435668460993875560545570428716507580449269986374369237817355026009468154404092065570575543870125017141088689845917013463"), e_float("-8.3071774428703632737870553403891308164105896864042377704098614630792896453789257768034664594032967020647985769854011347660024874346026445863468822446195325816990385940191691905061797372888096651201856248266928080676169743297245953044568984577749658876054607432453408234179499249787234919713915778871913344258420372813993540046638973609860992089894384613877205130737284534196245682780851398612903300192")),
           ef_complex(e_float("1.5487974863493801162802066120673438750245238539196478184428373359001912180768788215152834819449159179446317715116018318055023096039754382409746860655942558240828338562886852580763794710292336476855011599448428533648642699201547003334809016340070232989538720566604155828822870635596526874171547691912831092238866392189637382625974750301239478978701001106651337588114940722832931493504615667215495616662"), e_float("-8.3511048056342219437237383243401831060690009677861270001975017284588840190130541838475865843915194752949565452600433752740488813752790404253906098950843027502215632918399839955766472868779726283563820445750408466846570117763963119675679074700349883349447418944064954070360434793157115312188039823772519471357965933580758233250941622982415464853247408064832561991763731993194156085276150898916384435951")),
           ef_complex(e_float("1.549270683758193163521303696816676600006001143300953797794514756004972214830705057735014962080019406925950040539905916963444179419235030911311005393538979192249540012385560207820189252659362869731091123400630842273622688734032102119442684155152415290261426461771753287772725803274079044082081397686151073959554450517104817656301889489558087948072323124660744276090017998290341336463419031443580715185"), e_float("-8.3940886954450870136736434686000165522349577880955537298857879881917451890766002636510423507255547888154063133740614059224777506462802952226481379938660718971331108959890348364019819080647408288994680645154587942683082483743356297014455396914082635881448960453087907115541511764957508016518521692503725140781615734098855084510737778002202168958570476959181113599221987554557576199107953820044804620897")),
           ef_complex(e_float("1.5497239660402124460906924648545077789911801429736242542778202197941456079706577444783041969430839872211089974993231315904143556430256292885776317924887978745924252483641200372832301468441294235644049530565557702796642664779557343238300178849608982422610370667758302894843320829724349021494842325353871322838639364816915314072334526268402820041309202140083304705069450207498275239173541992388266464936"), e_float("-8.4361687635470595286468194333332000406076031725434136188325096322998040424762262987421238324066780845473500682955241694127641380257609768700612538338287660931168695889092704504167867936527830006777671471679325015242416818466246036148494525598928618051382152136310678712412393927552939637484134758296477869438952428889636360119632300060922445764490331637869700740231229907170155441686337863272264183521")),
           ef_complex(e_float("1.5501585637409547110928873131791774721345949711743671465945567781509057368167586694049286397574080687156494158378403271611685857352302404404288928643141241154534564534313467081122625777485992480443956222254807432815094949322731122602323920935828085993584144223954169809511656051405060523857031132495857894058947505851155469862258030854220395221369123546909573961165018181088212073018569498134840061771"), e_float("-8.4773822144723210683219471906115364071159886629245313258627433313403570380159958068771846877080019083469818363300894184363576711919571535993949426639793555265654810782596481929555279079494971134222095114228035846521630072935232474792412912761121478305859303735555301070071902578510572381811700292457960150494026842292075614620269485966489593244421428678606789189215224847967621477159835971575712067666")),
           ef_complex(e_float("1.5505756081313559873202975180393512710101119731126086579698272509057765767269325929058226956054760083878868480814773597682236760406963961294280418009959922814675501426056003997989076655486572097284642194825223438406724986768237950705957302459256287224071925198829412114106934200559211175834283776107169805730445501581980995707197231973237809936959105813762481020769546104288097437797980936352296238189"), e_float("-8.5177640031701084880202713878111386347727488140942245648802531779433717813983441204879785199222443358380652750875290620507903065528959253494597687472322532225238248323594005607594090662426962212225190453118982906784690216356332456364098560399596386214995666749882022090534555235242761045407584693055505294072712009758714384746425138568508392657012565344404055444340630326720624943320419933385811074939")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02112_z_acos(const bool b_write_output)
    {
      return TestCase_case_02112_z_acos().execute(b_write_output);
    }
  }
}
