
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01021_poly_legendre_p : public TestCaseReal
    {
    public:
      TestCase_case_01021_poly_legendre_p() { }
      virtual ~TestCase_case_01021_poly_legendre_p() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01021_poly_legendre_p");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::legendre_p(k, (ef::euler_gamma() + k) / 103);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1."),
           e_float("0.015312773445645950102975845534780606126622906174174015522386089659076385696870530785795602556230550966161470361648612451271461204024141192584700718423737121711199032366436284832404601386335876293661115689405196154836559911196438366763218724477665063184318385874618502330387585968797540718734022576907952026946944343023293728281237092366545044166132865075805672183277545679984767902887003617020008634284"),
           e_float("-0.49906088595766605946129544379818764436551587503760825844023368334279266612770198670655918773845809647817491299539033404724503327090419330450558348631419924293226951573137588924885562425440626827780665737739875460439430628153269281503707904274129845513595678034331513094069838237500064042625743003520312701782615169158943023142601587947533226752681308833511673508668552379750481163787170300476827087218"),
           e_float("-0.051990645544543113767230487702273035110715133565835821059934101309475482047252817497654621203602281946147804891359161042767866067569595889052891967793182571926765727844901380435094076111082067315137469618729457588489307180374074095602039283351336707609521107153579312559030741107017835920444285083441666898673569896226446166814501809195032183898880080600427914975976555265484506190348987802561499001179"),
           e_float("0.36761147380198924647964264530912922411201408988153952169315915739652520925945771447196025222249480765583570728359518050437640430574843514285595540705018360743955276632512388964324949426343307546111965283896676880321205785143280842014436702381539744275302805461208303283957577488672801896327374120288245379424480678105742626203058953691528653145120696625369257542867220921868251142542405899924375352995"),
           e_float("0.10014150128210528145808712479397747352778631830607288254891077760897833126875793765952061676851001873402134067806626341947860712224146075004917207144777285432935931330207273923843372586334608483113809168775095965722148805735390478507988017610346499673994174364364238565086143829964971030843794619552854163985307607663354130023332875447881993706434178839968447070663976364892255453657969519671419317456"),
           e_float("-0.28606680544242393249218849375508956052867289640640009158160080292100444727025925104534562270734759989412210870701466544121166472461795071179033447386917377619036946381674934075808538002081601796693674692549444763465953821292158132801853753379371652412849586060470144141299192663960167613600433370988128665890863531467858135026106195250213818995359834173346243642926133676452671625024509484151940790277"),
           e_float("-0.15317883725538474566701911348895548857981942623701678004541451881373634435698208654536920539261091408819889299288263349416435151618615123864491977986384743024316185130095268788338815691133349888349498486316131861714099661649855337181179712293240935333032512146517611963809616650439726338628099706491774846199083625552897594717815657941049841906095180385971934892052299401463607818828510090750224808952"),
           e_float("0.2077478698812093077576987857664524852135846758833302015210290957999375741466044323371580640332503316243254492918189343161927073339050395515722642861544011672653144038793299357675889545954275415443266129203303957711058210230057690259436088105924332373526237590947638716788954683453144019850232561341823462940212354831460825908073092566477783607365428418687060259959547014457803574803645142863464376159"),
           e_float("0.20077485923220310960356823387952806062652539747421753846583376563194847064054225246586797926780949048275781166304756188442142714961905472422794049312446518570693340868143054605286020217695074608502496259324506104889895932453019790740304091251158210942144533572265719806704577615471154103658461186275252708634479677180851670762546282955088248320669664223791330424354885341601663091547842561999365497785"),
           e_float("-0.11599618999280997994780039908789633218244064120190902899200888705137385659142844036758740821868605632248069070140948629490699432695374151251951751591300748696439540631165530943296335193533224653180794367750169723289732130523440922717758244355591878774545753411843632236940822134687523219498995468844691600119942433261803476735497960160106169837561794696908230655996000221354568925221648585456153347926"),
           e_float("-0.22710439988664249853608717474100320462211631343959316331489731257137476658535178245142908382301786654937312356275999465501916343556952078205582981463072392665410927886202451922829764559544224938394334242123399270901063480301020661687819761895253707714591148470791047833041395794146513074945262372293865849758712252846876790097287256053406333743630422800640473505560331938325590572221945975213521144449"),
           e_float("0.0089170196897713616469973177804384626702826734280192835378899542878664453421756689788804388090592946173381294463127048103006912767135177588141215093755177677329638962676710894191627303062684066377391419869443169682732547372137706324223527514503270453709661225089204541742913501660284465764361022826152182990998878653450611465298862927690767737845750538296593011661494186286602885521790659409356111819338"),
           e_float("0.21300699486289763943420274864373034566758757470229389750445675488086906573502525648406339280494374400259835101921841514384203388223045142289188873056853724401854843937670019144844704747333661637593012115577594336484432748785446681968995067072592407612805827658684514587830522626298986550960924478181894992176433473262468307881698764730610774789752393045366328763127346508731758253413058873620500167545"),
           e_float("0.098985639826211527834184450792162867609246652616922618956118454776448949581132309434975033465239707434248626370817344850081724281301134980049728261371627463297817002384864586003963235577841132228074305420377517083427664871174013567641834734489492225869747935536490666200857591663814898428685062646794341329045806100039371220277856356364145441393000124313259019150460160263134152582213928792930763232484"),
           e_float("-0.14435511969225575324845986547864940607767530979868644078341299527807700907921370837374469327250980441712441726043755357721451082241873187973985744361585398716049690365733743668639422023812353242246384856348988183579962259437449673657620316882243115891730926217235283108646803167567156668388175999247936559428192738185302256219750358350701960114478842126602985314083694161805257907653438154139255515346"),
           e_float("-0.17595206055270576902862253845116034643157124232699359094290540159058356393336050248052056597053163856978886715385027434711438830668169101808753307761025339700159320486799929570110256772874345396328647206634783756012825124763832749112766918294839376922644807776809065434364526669138274003304625880119746489595670351533090730628876893466847986441638478838632541787719492068667259946257040812987329760054"),
           e_float("0.026664106922629742693448352852948805327194756165290750781176563706693748955026596087444278026111132122799347085589250562533105267648296658555134966172934140064540683443290399813946290455742047131672069898199856926172272033207517691279102925057658270078774323685579201840698978587607550217233670121201899865853096625446476879765968094064399793105238253427329843594528028405794248738016001891556507794348"),
           e_float("0.18271599066905213711061942664993819713195675602437676284081318511804207663061948281689957912145823779867949167774413191020526117740934588855527974586971091903872215575712965202588061596311761375157803646194343826460968412087070162526537394683038935441566094641410709635094666779019718148474168931513191331059241210399993771775052781268034994707063897113553830275663349292792760534901864557808302260906"),
           e_float("0.10124089375792708993649477125486610218549264351227775361123636188418804404813544337119302177180961384301628015852803062671381044860756229704022322904817328627894607407336719454240898658775141812443461854522187868338339186903939615804998402005460452720666441583329439801542852701799269531619589519864124914554091877947395277363948273316120274159421019140191381269485778499710443555952496149149933125381"),
           e_float("-0.098726683954125467930069003539298871470163281639119940188115075679043765137114667033207986024688038923346661016932020186634264279007770102139325065085055699502091495598066678713262253792094213012612783657174496479795132295392402310101546765589896980192501237639191187668779116718438072422600758366140063062509232240105968431532412863069110926277382345544160717143538365509365015466029963958565794223086"),
           e_float("-0.17137928769442573875242257875648743127182333434898430416074257940582143269379495986954905123004895078854226290971515433914299129849767360891246092407790311128108789145244793663834968748953158573517790205515006022150994567649375257536322845248714440027130025607986014235434551379904522716325684222991691182497989707493415671355114044697559284153779447626792794679061909419890891140347382087499547742761"),
           e_float("-0.043961842486361342191611848436157232867525021106122722668797117331607096552815549632492948479665819750954007016051994471291386919179640208594017769420132858299835914629200144884463288472756429246146556956922621443749480184652186482947824898512532968367336303566697261577201281566230562264949686483412322164753329278608056721688794793317063465067538810458210162886190516137794034964754097116781250371703"),
           e_float("0.12581344511289458843076718019542571345434274229922629609513944081375808741925729798183399722875328946117345729099834596119325648149317852892315788020419303888237725839143411312054178220764056362504081293896887362142957617410977973256585425377579579709806960528265633425923429978684518159982542095644772099464299142735767839106852662668751644150684894539724338256966435454259448405474625933649665286586"),
           e_float("0.15195493139634418381405770959026630956749088769586947835645313470109616503364097328060155970829395661250126574703658673210028112151633156377431626855539205919998612989059603130197926204840796852029592461780349170624817953346428603179313081568126944526460787191536162771075032313454715248439161680638714600277931459583649616500250220227685106082810092173348278773657991212171589874577368656353326780287"),
           e_float("0.018777682304115848139209269848026822668012590037616577730182926843002174079883183714107488116843275693235145584231601635350799356390779964948475651622069213714898037625900791546787706133286057856196356151248201400103938971451849312339729928617673794710116624422140886109984403884855982265356412794060610609354371941426204782480423463926701604579780732410654524889893671519407532340447063951607788141497"),
           e_float("-0.12701767948359293947526599999593857224662977788254515768185355174083335526018282702319428623529919209804561166723687920494718468341129442028140731978834173600547990382682749772920695780562640214252951457871599429427956931542144568142611511855474256800953821947819165887651685835959805126820233493397696551016132976130721958164349441438162094785927204400612568836721889434743849511398498802553365645349"),
           e_float("-0.14282171053503332088015624501321749306160785667708401063972386741714827260388793949540642889801005506603990635716707327454985643954114661137309770904139189077724300082714140569902412832896625278187985638432076251434085971519415509590079904924245211179466724867467427686971824995230215683747957762240295627035444072595270688401099607331134653597271868568695706886206389516566514499300951493346354804173"),
           e_float("-0.024246288527284621204533422243278308708790342439003093925217978160321280204620015697320304722475724260142668020671337751614344423494471571433233369761399245312248224261634894068984944919941558750434537166278896912100425529702035453953547259627333948667190910538309477353374995790453447078276370365001685617543657094157662685328517685164237789158776987127346946796114776042965771040380082052930511790473"),
           e_float("0.11089436892207809605867354668425918898716549300533456727533115168815102892969050522205847417441526160624250173461690196214253499692221207223780086644824851744029985975695030055199913071610375320024335390582834733926186386618923398075787144271098150863281635797761722312492541782470236699585403438970743945000966139232124078613050205293202628763817105700921278183863564936484196108846672557914783032015"),
           e_float("0.14392349637619379221236562269373084434951631914689510198763761465358139200262755722896105156512175472333176676204329390075337353958372928138576327195550615260710623371411129417243766063654186841065558595176235591731638706494113188177820335147171834837378436271681627727188375916530178482834586021341561675052430321952851692894471803348281076527573455098392725427153634819562211711691428890184625208359"),
           e_float("0.055619288298372860620321767673577182280961729549371877204704641469326226782172861490672267204365632543017719821047353883009218714261796349807241090950212017824625314617032106542247976169571776798700776534586332535361109123718788310776773727807621081526648402534289349181166884764110559790450713642660049788192561207007651543650023377875629790384230937119932615049159627990848296321400553365333456759281"),
           e_float("-0.073316836972386391250826159528082218439543696759872752359216372196622208929844885969041504361354820910888825007219828307928742530357383863932054716780739502740497239578841251970183209110596389271655460889731716798961591176413543762831622295262291720583709822628266570007726240739975682649077205848373795151945908890392475376045085012816786746110757859022104836420502667529265046146010679859793118003413"),
           e_float("-0.14057961978653537770741608291500324921871464004006083638123558573052247770171798676898275941037673724568114668777279149346152014002421524890964370293370746459506912460559340909734478776779565863684572254929850792126537775386667566597788664379808062748360308845227395577823194913081742747659128555358001524023933122975712274343739805611557519372819833469022075135378984327566648201412372629133911483656"),
           e_float("-0.1020183737927397783894215575580190687139029675124732044531330766929844216579705323524286308588731268221456201102200712405926052260211323000494378310855973447989996540842191059250009680584023261324585779327440302811295445339573241793520163823188738932512097509838936534587257825246260287043739571758205601229124008054703089229599663562750216376628155295810077822812791644661968660382596426830076550438"),
           e_float("0.0062313148981641893522769888883913916025463485343573184287306899867308084320290693890016842595197176784209629375948834755775561972372809569758568426772442525031499525900896050231028223929026680231051790349383233338235736778967509990799219785406685481933263323500249341357549954051765090897814569160804331178324938264904600898961455837557092416468557663728338736852768004459215363851110437473996935862472"),
           e_float("0.10569489534318267342532158469389626556351784825793973176062572960995946533712195643604041137899126976058076121748603955841702965481876982755880648305167980212119720768359369415248102711865677879174745861819178375948385267945478104234863499816519862053348864935302609556923970470483511403279523266029247779336828662588380060257138851644823528037012047826450171259297133800475540085873455682110532291359"),
           e_float("0.13385636715528162463854570953431325129677967035897522528561701437037124974400187572758225558398084455718256066395449817962448025001150019105175192694067872803541080071045415463966582554218470573305058904171467137855106722175504933143513642597213570157884554293512382450260244517604308111721680452697071368829298157899725608557357165572328580675541222243469766279620539352588808176831645729075224054226"),
           e_float("0.080191474509127631984886558565939847874377100297811534586870397994796782224631604070278948085669505403555418910738888471087284565546512791938454796667075324960570694992169823857742473369723673361674727392822230571905328997135442436253561197423713447241282382543105147640611697312908004159328695298199495479067502525311448247028940598781857238185870878123594135838376748865324730717266182114351240008078"),
           e_float("-0.016898344264360546849088043897248080572203784486836182018786899757552352898912346623760617539653653433056739963214274640894819288807252557075643251232898915459608190494074643185371220055399292347357249739594249615923685125053986970332321231571637172045326829058840763347574226403045728972299947326302788006459720189198887635220897475239065021406572117212244476381846923578511772238713353667871178401682"),
           e_float("-0.10060600758127832789762411217549557988916816517620519197525171375363258745182732514418742444883212906990737641999586600981332736208963844424051587081387201769446047617845328657234032256713532786872612340948133888997925899135962381757263904867864028232425038633202580308318216025518058876384011115436937838247168206342649711135176693917594142195483615735734437180375336128815800123106267406064161767788"),
           e_float("-0.12940904098459591123515004198403739317362135822816187626706160791769619246486460671435265363141221804702879343278086721179796598782412908676095693010973977300765367812319415636980143667200935246979733534064995121670172854930389235332601121811772696902896579856986257196991158454177010070670515149370009429518612346052714965666585106049339304199301833857357139364203132137360323765242040748443074013132"),
           e_float("-0.094995526978453794765694603716614748869210394097045045689100891700285845356835248698702337182276142660049271304148082100150560578709771465517169405006203231913561504115217507543957592129302667387644212982298679295808759036185215238885857366805380948748072524804888204506462426670902427437761464933993406196901829900313234412570329833285906950406879418363327944166965191714458952346183208261742646999659"),
           e_float("-0.019543219852039828336377450444547482537157728071296279278667432210071488535607430671111529990769946266372623003375617826124178745691510461631874266418780301057462780220164748895601901057805953326123229043210966460386908688653404110061918221324128221375326290729903662177067534073206177481558193992247821098032147132212422195067466726794920249474229010252690348728227455199490049477336215933225693431127"),
           e_float("0.060561535243738336933059105609397429883847771904712298891604550854132302081774910180499860481562917052608870669654279968226831472091019539651955058732766547657339334041934871961238920295762066190544907593745783073756482087105996760272911946490096448837071999967166512784742645538409276968701376392138841055847188236841061905344038978604266415206979479544730175919738962591652890507384622631368052737059"),
           e_float("0.11314748576601097062514971938395870671690440132912211527268178139952592796941109505500422676785964392365122615377258834065682850691342036987221380673911768104236149176263940777754210453201424937893884731747290612850986833198059622633007017663424461956945641241532974033648700052576331949319384311418749962493763942709009040978688874944402615684060402810232970174527385220976641230302075562023086940334"),
           e_float("0.12209867571247313595824934778126369043339356423205993655263697470471307304156085210685110524131731031677694057197024592233710176566775788496647164327191763772260653623574784430455605605628270770682657960449116729241893073884458284410650444904392033355365474163672443981000457689170680125023019867052489028373421879601533359973260132619403982473601531299505209970115254140812580937916219856361535921207"),
           e_float("0.089663357077275164323264114794459830853870660089335803667327621055929669054436074312873424908991040524382149477746671877233857876090874052116911492565307484874586932410901020347994989231211213779403161446379346702069080912187663662825623064262637392194300181574728414043541940946237455817839586104309616153361851685742675093624451267414627335468161418350400408472859315010874575354437773468394652385398"),
           e_float("0.031280056939743421833319206715209248284408013042492978054393334083148793837526351368613481258115941844313103055177825060266970453502225168355198848666836757151901916590655024696887807440806550349749855186299516688438743753336519876338385808136358886875204838067545820812116445802351506868723413015605437763235721266970586443238066728833186793706772120495200834915344755155357207007312788637910119369044"),
           e_float("-0.03274524077597504822968084990662443889530825805748452872487028472186446407697988585860111152256127188199337164303983968744564508694623120738319497022569750642045427605807815657272403808945464362287930450466865715008459468416105248520387422091221096345353082222742711524388895698557216329756023595596385114946826476261691735584093642613824216064778496991452019609589625719683014250177147866004027953347"),
           e_float("-0.084709025800512596898345516539158006225419776075029497499193111733604899074103202633889551208834243215806260778475593898857038436880765360154052024664553016499631642830224495085472128070500615028830446447538194289994310272865839309935644559594744421101194911916028365345088802756336055032188622214817449570322801644076498335637533155342396001501050126940012234988090849472494078347027519683183757012111"),
           e_float("-0.11388351211394301989984940036210206708108037616873760103052095284770953822553630540530670807370861910156784159062202733716887689479401082740615634275892829303903696235395674978804111718280073515809072515838333940767248309348645733107392090515260947656027427166817627651306189471084032002961296547612017238041655996795563554864549065845097180883581901650555913611467321148784685049994859649885942276596"),
           e_float("-0.11745342423337950899456149283657455239803558285983270391010721254280250735775153557208240256131772883026876126559443783496397286703768515925732528984990831069786989585022420358049095302205088595972961302209357452024039212489871471049450972981437377785621744351287734753108951286333476193163353913723227525841505994574594678139671774290996672322453737659886162551666636721071194932253952186930684687914"),
           e_float("-0.098942647586044937326247237026144165530812365633470426466136242098297683148990539391566512450344900145207987921280020506131530602882500379825181253439267685094160354374119665925073373088878143598929857607325142347670241543898976557783466115471126741411411292207244264901173607577346178889133803759416622048955806916691565730589416102106672562339207380165643649506455923267857273291775569049887676380797"),
           e_float("-0.06549371313732472986779734658521654231657036561759406567443471912563629517014455508755517792543445542247320034821435426835579386110682515694939892308978221404598530423561801716363954729875413100934951602741014172452126745364457070006012068374709450890131590764155470265895483112064190267190599005726605801009112583467199814948617104935185481115516183968086624165069577290794820448606299685366030742917"),
           e_float("-0.025174219592187924870368154302464612151307710227794020805582048438545124562961455518190104151909194826254869671455402681518561029434822440405750296325391588457193741115276290766735489834530554860231522737829726801798888119728668956441346093951519076079113730189578348957020417985889446806823582229852856117730718059855140342289395632493801133670572289554399110989864965393077845379603208884590025607679"),
           e_float("0.014993070491997906091013160647686192069662431783133719261803188281770073508374764467199787674371019816639835289874355280541881311552424427978120223469409983061376954829967259820939992696663631562080443937143378743374451935498911711754148734332277185528333508353345534036697390825197611539988494481524554417950222585730660527969899085876147138345688327735147025031567145443230931359510694491703827788294"),
           e_float("0.050062899088364165265242360767584847755943615560917127781257271689635116871310769268526882588349687750527859549090292139852089922826759574721481155891501009554557267457307671410026809121560620340739399008700776946601509934411611469270047112468276476321698743616050452989367906587035063660423747209172234964209005354767625605132977745110954240895184893688252090462614715261423798353708906458844370363867"),
           e_float("0.077384984806920894165519655202434046321842752569362404381479510691182781525197384913279692537168089479314640513695497300253348198367145954997957036819758852218718508419854805685193921368531496629905683189079699349433449241407989652284631001435273976485768287263435878316413573736647006907140064084890386145125094091055915332402324957398388068193194841509463089848972714489330866021299702374751882340979"),
           e_float("0.096282741749030786316517519814822530094325766005938603932730887449774890712901688543475275816634152791697677817247724333905149184274551982334399495883086755377256670604053325542405750318356862758298040281991527380143978067026915705989949457138487793529686207871613259161652530845264259364256714061826179250151623644603268509233312518173276930152694682368184443568384611930745781558547560452968364557766"),
           e_float("0.10748173779159401392305955846663639953059106065687811431210677817168092010155654082372088909758866621339876179862691174906758857539272239097108024643696068769453152947027952046257642791032623288321015969713379177039095940111305936714333651788607053606082791155734649897188053979471070341348559092373776309446313630108476665261388819079219015924638133475617846981043530595609617234244333030448622353167"),
           e_float("0.11250906806202099737718778760126393487336267676327659332991040730484358225798546707247100963682272856859414550681031387462605350013891245325864208715756006266933123871508913070889816936104824202104826497325371954748700895830341539183087652577803173030696926451321405118005694775936399816622584006988984745582948822674655159096990654695312895000375199002114583711116430326600298709491958893787245290318"),
           e_float("0.11319354552522343303016331498158103145157921122158637819711645784115167279148758794621204729310549656300919707713225672556555626485253721985611587211888641449523509509740519061865801615027730962284934766795711865337761705545604998609486404593125491813094350737575694224438980583174903658283767956172336992711043474786500580149529697749127670742196937699048502534075356418005165936602292237179406978074"),
           e_float("0.11131626464871911970581042571904808840325835395777826953552785964424974243242399753341597580982374425997404377744284898301523186847762028055165739519190296695196269822233936622631098669112765727616043129567061292079039937451396820553167824971958607867285608962015459568208925194329762129702966631554350602811804547799107997398910624950006547543607842285782637465317962967506567105838733607527589788884"),
           e_float("0.108406246734081773168348485828104905630968532257494346710142924865477346866021011374880487924934306065647055594695089348781572618012516057290951818690956978559881817359823747337816228505678828394195017293160076657075996399773951133496340323087230557197974908446752053667534476037996430980410304388476939665794778539771711649197019293771663812165706189808984405580460865182882646098553335029010458769"),
           e_float("0.10564707868318129346797435076007100017339231805733435584416914049657234553098075033814716237718135915874038605669414338545899355179397108109476363626677624593724419599236070604437763379261372115856361231159806222673063025931666451879484557406151325424661984366734724881873574819913991656227924762923147696367874196450386498043047614044056121744306642235677450196443387985912923985529843240565824736842"),
           e_float("0.10385140379459080845830819393572167652778750739335232733319393494398217386066456615689230875859857251773549661229406267060849438066206993816174956572169408698104587919829505206068524912415268882339657983477308965496795248167868072472533643322586549705159563533194907703495033836716492257840296575439359154435693343532268174760826360184833065488626533926296843292424224015170974148582536504891872677377"),
           e_float("0.1034630664685675289968938911974676241991206362024623881969959823229979710942866266996354965261694838666986964342146425393818856821431200249172860092975517058722597420200987567422608714451583851940392472422954780691867073210362992323780217047455892823685762696239218822744841289152394512523454270816988668464082238662977550218808054152775379928466175116647903817206482243925727527580236123527552029742"),
           e_float("0.10455555287693537124894911124512547230198995573782889232066043560817170346716451248659579927259922229430883974147845711600143307111828241140053419430587081142116169396207089833756602009887728131447990550354185894038878939410565655898175695200845382407203889248823163694192215631142697907938946405938122094218438808732691245674643037970357008453520803223887026387812124882539601453349359054558217927719"),
           e_float("0.10680687607091082597923298425517454614826617992277574176890737960840803514698662165452164166610011007434883237146133102790004557580751116451413451492127554030636708174137674392215527500544816408139893311120683035629147907775163634920127217076000179447659175300846076406985841100762236970267165412624346806386954279598704552402691495379404270945541913827255436751602262394781084521101511327760954568811"),
           e_float("0.10944494013973398076884180768760085067344603302254347933707840472422592772070594713348564890159538340046166794497129453737444202135485676334579660304500274807164001257383551820220435884756900652043491529871486050971605978851307568775699757880180042984825590005393721243132656899969769316819970268564250021040639016510080886905147826911158228297132595149430942219776194427998291722748961882164480437321"),
           e_float("0.11117575580732638872643757476644131271847225852636004992297427515976074688584108209944411727836468617236332397167946696643641563338551784115530768104383265632393497020890216751186691348573657687319370601388313665804319235702742461738861138826600684917637002887777732634661330787578134331870783827556014556709239657357669691943131908126257342084757556126737565051694322257391558840187727463497792650711"),
           e_float("0.11013285567846689796556880625178311451003213978157885811615333567376139191144841299601671506105785576105973012559741497180822957092974913584857333722044364492365539207447689797835580387425728629641540803054803817923168143066138499131181341628521937028129161626846200719015070425481097408120591717027100761618076964514475459793340073518670806855130981700968740034607693951583166000571982396651293917803"),
           e_float("0.10392171040802248776907294154063359261023759930443356572321058642633921456655052174373453627540527842924758322201305413782174767739684805862125428740892415200422287990448208175856221717629973170944767351836501658573925538586794544745866480583893779013834106466045260212332787664720165039539088600399312325889058781272487357925457874087993084922472342355279875417215180252443806575898647199330515417082"),
           e_float("0.089873704417407639463022257742046555664277289846110414593283025709680641119143528726315105240961618176267708446449198465669643438827763359937706993365750081834952381337845640594465111107641777467946847149889433225305586531272872191293518865404163773264438800548613788502546105544282853378651290060756889797631518894193444374678264716433745074690050469825076153619868262987292346140023721353401889087876"),
           e_float("0.065652479813519653697954292816802493168278067035684803496542412005777262827877426408733693621774643370757864408120686853699269926588760798464684915616608662039980641506609091513798890918816784722756907650008675754062715441552361536219862501285537521262384217342078779470962477218936908392177103172380583368102115351745525155721277839614451392694061532965505920400453185888433842138149413852734378324104"),
           e_float("0.030330396744123183587528600872047479627685029931056220104475088609589914742315055717940694792896115790952333860053616350305450323939621728090341410307503382156150314279555514273752629866984548814163919628518695978492219869279816675837755733142117012616451481598162095071431408200355137297152183407489878611842900227242598113472573539996398351493930553926404368765252896576933721752949301765457754090008"),
           e_float("-0.014093647831896070681011426073756674105590612149842233181682296325782711415653640831160314291243576043234506950402567841263237934489242667721346307503295134333742945539986215899070516207155164554699728666748307378030613708101197777915377599166344303686098682136906423565505319341117599840587791225278844510829113430488504066755067818611732999744000243475771620174697563026542662611241814811576607455812"),
           e_float("-0.061109558012980916745178148811878592356829459677853551927517026765992470532969891669076887855808939052834782488685490707161842666708382618883251739418834810414886334648387658206563873265307207762170091403904015912486097621720745840638167028913153001914279401244258891712301668589824390681812419034122653888296092401805399270161233811791428354086361057086735106316621201347809653372082174917692448136854"),
           e_float("-0.098983125298349207776216259140419756862996164536385786582944633216637816638697828036668766618969809674184259943222937195384258325449802278416862202279959316293914438630002675185242274932339556632529681278329698949605986027865046269297796700066758506303899734279089770975119823599319799942413887021955417434149208199869668931286019357424088748107430840553662061730590105631129182680992204656771017131275"),
           e_float("-0.1124512052905512172074738531109260117478255376913573092353791220049787367296164721497281729850209649248524072407802398061401228240872636359039385256822934877553560734043484655224388346067135886996880033048458318426159107909808448252821810753465371306887603648790944367683220261837695537330410732670822442979293448488629906114779410862955000009629763804583382214455660315905320767015745406748908915123"),
           e_float("-0.088413189397359404088440809243574060560127164911551749371057461363249465664797260937292675011951821972647617448422365704530264663139460630839736594610927780012886791072153035295566584365786542427544790813911054814283506252077340002217811087864794098954891585351074504288895544750752928659958676955984194696971921877115463957104294648981840717241547601899541669586280320027610276399401448333638997969268"),
           e_float("-0.025693355373944395607706300668939023800873023350128350330648405867035615893078513746802857776862870200471650241249073796409373473420438937395240657669506953413193206608016448117151902852003864792106691823959894996248195652322753085042451919133724783762609541200743543339533924019161798853380049049606074015069884091767927115975686883287508498118364631483127956447415777948720675175181828448821156881553"),
           e_float("0.055038332050693365027191216866186408931108967499335396825841659349405907054224596135526716380877138054412400476081501647588592863063356658513240622290066972481295544186368631279122318727264011631403357925033419070201347671363464769546177458340544514862407594529441269621067030393416493918123926288137876844463870886471629807275166640287998634903672817829022131110165945577840373869422072903992616145622"),
           e_float("0.110672935171355314954342177220130058394155759025994274904998163420435720163361305864158193861128746282709081459374199559331122672813695953435013123893725921786073389838569673612767220917371890003702544831630441596612490251583572805150251906856838360298223003261220736860044345972747811440094109506869885371924602963638401762373566138946465027123253887189447038822546993700818450241758181937169232049"),
           e_float("0.09587869468591142223830658513705584170737050368050723948795884441439262463938631733968847926003895609972237080178882956807709981590030351663192336620120584914355564749416757432541862184954439941605665770772543432108276341208404007212416383599396763146814509237250306850867939301333051565158518917076702677497142823686362253932875939363258091492542474743647479670685786757409269352345387203752155058133"),
           e_float("0.0044198419773878367160652376807420729511124357169284029231887823778088107427753098843931098759683740551832990029184807174968059738356473365857869748549524929740600215178570770640714677823923580585613573254591276212670871094199066014866625908135731092503384175734368523076663025997455723234748365259346715397774632986740499042884218264680844556623123654626309336069227559816512431382365860401351133755589"),
           e_float("-0.097660435919949690220869070782538058547567941656984655272042327623323968144782775326822121553344802764410036665020464727079188862821515951082824717444923941555695948418513667376685887888917989026499187427802131109580270999451549968684110805167672124927427120008231000912138738377815802225270582991246896832731315031195202002832155121021255067755898684199548413916748342319493497465398369710050315134454"),
           e_float("-0.10344581987398665241606223348817325159117739495997725684023824156988349212305555226571330235082796791154206585662861803209532739649170994529787225370347252636440091069997915901839173205359597346279181287453982678063792982552397453705992723370909951329345732446318849639189077683789190463213083841639644909338671863806171318233979175684888835650393835597466416777050044899729008792419701296907717607889"),
           e_float("0.016458521116363375923946982799616036558098313104547330006419716283088962569477883843582098937235611374672867454564738623147915689653156624635154839457712927329492105860889267471126031386014406307137921036059577655465253424286903855931266479288217228574297740885059137475001827571844406037625846046082229701082455575905936628126643039623501029806264368104243374340575992346561393778302140982995238163538"),
           e_float("0.12040517945383952867954295537646016954460014296665984743770620933467588610092008926747319305796936291829974651801888947956675981567034064823923083466421421809405897623104930944063229116301529807724969181588196110324605117293546221357520109589882293147514131932648984178560153427173177410955900100160842313321148714571452899780700070404074579993264660871926855359393914656589094526310732348017641463209"),
           e_float("0.036628506902459697945754426013537984606657709412634231271374329488935479277270401832044142698189135440309108131444800677949275839212320844027996832154035814209220137300306314729055727587072722602446310861697531808186742495384988226180480280114009604679257507043602455199645195255862239238935606050517223627288808546560321096514792603356569249996193143088666554200805322653067800815261145638479788692652"),
           e_float("-0.11798430552484074129880225657438769457169244471057026960797802839541576189079136388950102416683070681032035358604456737459270358338299626118440773388866105864536099937345154002916888435913609514777799811892560805637671926676336995797815677522094666505525560725180981017864722716008794843180093878149135996369942867999518939692265393631839422197835936130881642623444587520944428961096930962716816472328"),
           e_float("-0.031258063359640885615400132982383019927113929466908441379423288352276946641889138880516113540573004651052680880042793489173300244179605292593196456808891134039727171330029307229722206164172046060634123644811739302608155360341279815054871029348847619534096556326710174277647742940927562355200200614551532646022727827170864535751069439461599524744374916691333307432693599049048723846075154824584556013011"),
           e_float("0.13041249994842362343819261509690950556017506815162698284405354017380541643972012946680434855063244229999792105234652685802733865238197384482101483404265786512888703068806979674943293961757516017140630373508012120980723504668681258037055568085135060389199857752608448266291245977312570198103785493143677145108903789386388376004704158675457562188936415711419780550040614934613504547777959565749603994643"),
           e_float("-0.056880113373093385361575114493960444049153824093869479479095935385393251170798030963254007739890876651003372104868865530991786332792383997978398860589625131719428955402792372168796040644993230434418664824648752930208431777341202533771197008219957024021066458547705353322403464646338907665847229638221662026180465464830911988463288321788239866530180468402312503708733871960344496522312952381704704445279"),
           e_float("-0.063966100196504746297939107559583243966728457252691293330095834885989015964065954968319379988723409459968305940835829818162052476778697456855933202251502714173415023438616753866350475041528579207869438600779881994809828514258597068041667317437791796723084536152578117892951630313763166866513989832760194152682151723172706508205635677679302820650202829891310670505401119795127998713884994466663933843902"),
           e_float("0.13000564969547093193736010059216885909525074496789271857129555119946331852248663297871438451019606096188493723406733536373919076924368162937813686654871824509232902594421495631992342652500231025151773537439364027006388115939300813039842138744850034464995629255949795237536109656930566582208536301965259940084749925254965636540735398342907779272998120978207712919240768204588695061384533645456249439003"),
           e_float("-0.14864506122890831346722447156291342875620110795648819068099035149500088488191849273888936391953511245393937293423106949837746990664946841119654448918362644965359757092646353727316847043535253591773162139280894228491405517230029350588754699810107456810876193874683991606014577440620634012189347401728490765173695711618947844134563246935045576928731727406874285827774605494163063085855735789946581485916"),
           e_float("0.15503017324108987930067468316632910165836340998727180593155061314333809425500318873943032382270061777339680033204164822356834664668495177230019661832584941207838391580514448889878270805418607195314264936691373339193041557761422842126374593121233831658799008224423717654637148486287461174765493682468032151738091778474121106590318019158759076880818993910836730999578487671162436603620429082419897667992"),
           e_float("-0.1009307114904135003709100315717405761174780125032448312581603472817201054167425624282321014464753284968706115571578125361523706405859959900592795537641695177319397411230054759623209024648281482050392763674990287760693012353869159845345947365419367235012928048049879816723839465338306149493350572259725830356014625830286492798040692532484451708037773672817698441245419885308756026151713066794283091951"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01021_poly_legendre_p(const bool b_write_output)
    {
      return TestCase_case_01021_poly_legendre_p().execute(b_write_output);
    }
  }
}
