
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00571_airy_ai : public TestCaseReal
    {
    public:
      TestCase_case_00571_airy_ai() { }
      virtual ~TestCase_case_00571_airy_ai() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00571_airy_ai");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_a(((20 * k) - 1000) * ef::pi());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.032490970921763350947243914364878633257211526850421096575626151143641642178161154871315703628982860819192590234318678025778829944168178886155966914598971294788546428639133942866834014733874191122904353850145174322852105412460827563918357832804034398875987975634949011897818917104910376924642500292233276301944175456392163321030865623100769943296936389361064882045434660245849876713038922495012440945373"),
           e_float("-0.075641502399587350630340011849841935274212612693286275105165753407943353431305497841229582963177132176600412971487565233735857705552450682048285873811009875445532229239378526570817637842281251723709394538604120162665085379903001838488804415753416025666248463479728028845275405307834410267123862994547597356085966985524553757497241227256952177803038903152914740605680374011425707513902258380121632937517"),
           e_float("-0.07446918953188015669539000538655152454486356121300667809901359972237872031767412335691955589037117537039366668572692751653647683511638419401559564777200051242899949629461033655972164748864266116807969176550967767515520248113446648924155011311532835092838199064206469435229848116662132198875926769197278589495814474791879088821487684765281914691538923510252170990995423507034171423092499408086989325245"),
           e_float("0.040101212829353427686664921271722433885789137789375644479598138235087766217812138904295987996141571467336786399116247137945827498754165569985788299031483307686694025075716968982443047903776750223245842530916086935116732538411048765572603589023146532268997199896947432297090754431908835702322644845285159017275373078347591329729956510055728970001848201434040376071093171644542320722973723369563243863086"),
           e_float("-0.049399959913455661188896785602544106489884744150714912575627341749810430136296330756032759601881543341953560573117250646808168323077277096646188178087273869936085467358241599468289553759757346675586278986603964646196917914634132449764767317933586926571341135520453751513277363934914054501555184828137225446613967394750578003359627211218026090991197911466543626192814866167614440712711149680213707702854"),
           e_float("0.074898518550667035299314406290410747222187282460066075022274188168286386587665962194921887303270951326979984388461793416759054642559385967730445648725615123522263412378789280498665047470062381124422090589550696668351281002989728241895940209709115064608187490774723538095951138402843364261376136578337749755833706523278422421904159379537009692816909769066861599158042510785318487845566098215409674506897"),
           e_float("0.029266114470136079797380608361930619220351205066205818172120779869045504992808258174212714613783020266171336561015140146700225231834509331214052349689068305841690392879363967093961276673930405730152665218300830238645251814153148816885891319521154520616915736245201565556982210307476942281534707955293120022462202012148204881027611414873904752098115402790530054543861873802126040346352203952225898935386"),
           e_float("-0.061142482888545451540773292497572116998131189502585008408113500581950913822997470904052381332390500515085834542448660491221074721367952888715415742358233965188832305812129894690562854710008263122515103820464017946789863376904906157612019973178783095072427458931350417389636387824025798886249118993013251185274122010024325147888499653516642743406976127651568141827673844444612357671215193081446003591617"),
           e_float("-0.049774647325548123354008127886709988801363748892910934977503325543009492304076842038821046505344689299620940011657927373218043146600287254815860846680306141203466028348159860989137437858120138079006763045098603928647695386263898990568918037623688915898056330506964406255660495153752809855179168545498481069255102823378313627177972468471021310744766500521761528260491656906845882229555836596134048710329"),
           e_float("0.079151266529940411550819778359224669729219772111005043681098094220110037435352106837140112465826790329579224049673839357679257355664342127642254055955696978403262451769289498552493017253846471901897550026950707279576675346402334873023050526650843144421427293470621964272554253101781851913486998976614672564175268615981171871128675658965237128371709153966231061338984641749172158878565802474932793465206"),
           e_float("-0.074246295521642603137483410929872639858636912073156349387409831758040624477029085251196448934257348166603373707162042935671219269621486634023466598609310812482586740078013268940522817361935303341680204627352547253785285878302974336720001427063605724823111730924585038326957049576566290853695347366678241408603526565155068557218387029439751106572247185764252534647200486874847927837920866803868842083564"),
           e_float("-0.058434779201195657410085296143641516323895889768157820259544834454946099350406806126448254194388908403793324420973252395176737798622658619290670852834628362606341872951731510685938216973826413172917392471011158510350341476115282530226133264793661813010170700573152379686660395817274269618634223893064547792833215686497811294131381099319402060867303555524700529419008649143250688461749968087642991351209"),
           e_float("-0.077156035206684469158662118480238072408547740125591196322786398842853838087465299297942873726812621745326544057940235313453667002002692437533120428898978927554885676141346391005788784630317692011673486904596266412580209554760926336409587885876478344559697757585333616881913595187177575607606813540816850411285686845519893471125477038641132991144016519738915915946057077397230004722192642989584010839479"),
           e_float("0.049988028257985982671772517204371262381095260221725126308072236907389653187855014899744979419964356641078810176512377832361503106119972594282037433614825423101280714566984159410632930400402172075869702835816803417359589442225369283252448888626348239902528123463918955499746819614142978416598747906779123393983236320194866305755925633627336440874640576158455448922910709210115571635504282336979163445748"),
           e_float("-0.0039138097577544476055176866851846049048614252133683284154626188667300191498195475112801465822965253462566906900258027790647501575872290769043748623575988339909569534441457781448601625092308828674449738155539934734552038597901343323104737990883389479611606316063520531561693311813208730457607939977402332322526461087053152230041538350947095079729195549534048090149038578467354243719965999733521317739309"),
           e_float("0.081496385101023146812121560236049725439005520273675939581462897752210810087913715001252957655429591997969088481791262644370105410291836920008087491904276236534240453089209036245144537642666373807748537928577481090684429583763558677619883482188878198979323578415591829494702713936541846487224820964337720342537583325201306257213408520685355567392409017675942480679233728492926935121127477699241623302714"),
           e_float("-0.065605551209670539181350278206907046422809610897569361220387455683805820577795835920880435744638383271085554269839364170179559185611112001535615240958711239241687008913037255250549551824558705603519451578057131127357292645803906106335208586385795111485589384224916810596796450872611879552070694248067507527576511981860820046783332646729012043752412653267892872526873187830774808312596957434744704136131"),
           e_float("-0.064066015745423528990269503430975430044796437320072639537299572152212617180823337485214098299568386679303973679001707506136181035959508285349316978482567943464284318272650030250555543730143085216310787558188081730695170237059593772240601997507020113112622402644710115774743025640162733640282040414380259603409564200623040641730111421959793377167236176433060027412464584501231956224742596103793185713397"),
           e_float("-0.012303354044714738305205273172217912617784152946931149428500455688405152319122017703703101189489561600648099142432615477530791996438828073076692853349860004109890445896132920960139677758021418330579458692712388942267552081393352104607459694906281917581353536501573820578668999985599405893849402480046993879507157737629824064797736439809765300352868917311154272587100875275966522352448418992090809557942"),
           e_float("0.049468380042465407335007167169417849393184506919509959103951123124489802060567917150540600525097217456848477580370912368479691463728204415134421472669654165602127247466386097005402853518325382630574809824225812789192088685820410758417100242227772045223439983262179184741270140991980681029462782154428077339660467942856660210312939795985417712517135320951071447955142524137239451170367977171661023867495"),
           e_float("0.072279731028459318144030613913149159080279363903427818273484732294154949927795820711974869454384200289113120502718463594850955608288739095714659235150334568556155207162776642899040003676190832983287074687454744872396421715048233584481396823448512018098670065737944668823160570641167693567828446064229656412790115209213371091150203159687862525015073104928104149875538655151681292412993882944042774442915"),
           e_float("-0.078666415761639461354551301605067753086535663205171700309698544413367295385322318952289407062812976724088550142908013704671756634385752562870806699981906134621036654179084681937219272811067128760583888743979799177043047390759695648890976196860693246449949426048470500919113825490992161608904281385373403319446717980068218961468628776577055295775932196032241713828097783215818373105056243119203999248265"),
           e_float("-0.07221456565656093916614105664310036774692436715518507063276273105306223928793519795938911378853857260374590842809024287744994572279017506836305514786159870778437268920538612572292807064205557164536187453156284719967745696980870546747044218382592389721389761466810981950994618714846399450815372221587319470904645748328877511244997968026889007055602417067445027199888524221350061332103797906075779091972"),
           e_float("-0.0088305324300291415095189562831228111755396344425159058755687538137477680681001865925170514114769482220713832407069441575330703614997448889606277133017204785142317782691088946890166161208183048312587849426365301791642720839454133853144424658451987735683646549210141746145416267636413698665499545593515111044771416861251258991964232882943908494689837708355177938555598879427571394205801189743411808851718"),
           e_float("-0.032399320234112468156729459233611286273287805663936124243672381865200711383625537114979655033633021219925086092115729622325034858246829530778912458639751566756943247612345582675523135309649495856813432954066117135499184681280126373256253763739487478013687702443024525743728581665095671282729345404170721776988856997701035195067519160454361022019415923446274786314891426806198864694015273442406634900642"),
           e_float("-0.078666923014034797537774410620047548034271167080965871594036747540729434440513262142450610105052776388819184660872709384067328685420678026387423679319389809506928453428493154777039265471105116519051016527446494676228870458784484530031106888664143407688187575733289652047945992081098267217814647252577359172603428073277182641292722643509267213624697489192223053634763044026872235769582704763527139586893"),
           e_float("0.079901658194901979635401756596713265380815245211520833602517568723665812129552617874662703153926847329354794146852390347562578489827579101989689476624922628263692902456466801819182754853655031735802589908904026209357425651342069998530979330500697639034066790871900192379939972025529507003985080530843131209757498631695163567800382449466440934690272198315332898751973367353687683600043994484130162669333"),
           e_float("0.042222742427333593528092301427904148454000023206658794574682543136229428285656378665040535066701174197427908873938492055946347002248161667636816723501392681757369829622943468184209110976783815204466041129822394634602542678261239819832439876678377442559656425773948623000676874394961727063479871149612832317701412344429034775064543225413854749236094094799174940731875441282707522815929922962424360626099"),
           e_float("0.049493830844574190777419313277300010514240525900712805521390695972044484567100655619839397607598682761180257721971174740402345118247725822003652150993081653085154512091167163618778841696878181078770385916353019079108957013145599689947414719260659148931872889837171794748389509837055590131954432101986164177816853767601041914108800036572534574126156168420512755773733460089764279177871120363738710110571"),
           e_float("-0.031297569012457239964451066602083084990288838405550001844602253210497228941858603651567163315140404700931055282464736670345230409727374315821263495806918952088696982962282773584635478834331667514427216500642310838579645683872945313907721801743449726562190397976848733665621509427529674681447401086513521502608123826529031680654940047255934655051627562700367749403028524509048007659534928348162520991179"),
           e_float("-0.082634174752671223032037217817002136732834139340699756211633492940995291061672241662716097932313311257955922580679116834262397352309986745433921520433630790285603606795856515395673149474698510531852579341701684994508306576048348769868355739019915242812085396275149067011921696307770102261003696997189205178542708254031562548451297281059174277694551809181825590253591344635708342641708202949227947592695"),
           e_float("-0.07642956750794262122081910032427918422833958920253445046689006130681388702030521254285321045760491066811958947566029778843290963840647255990232276489525744388889564286324459390460825631746540725250297470078810837572149137440073625325631790667303894139658540228828903170864133160289858821126274926326070443898116128123290721338282656108821606390155569013852287519041232689304337810267789864288906253728"),
           e_float("-0.095410319998521895492486166818474241359083375996048439152892428403567501456156296575041467531522018779825258374558132471888715830269638801534910332632848422533814424770595656682510904728089950166520273785664528928845847224396368060237005309284251771714735347023197297521278000748310770752585850974909177540390759780018098246302786559768584885484062458917425421063194914001077644167869471658125786220434"),
           e_float("0.073700070203349463112693617725797713932659387397773533316124948036182494839964264067271747403410424325298554503021540575826863444510659494225749881040206801781537682292577803810689993799232760586408876706327455262823004409824673915975634744943058727666421044531302503983934591434737647555072103546049692623259696010149561868423948700059147336695607172016685879923239195635259728302099152986229034682268"),
           e_float("0.086015572766023269114677199072318010638666866417632604438495212766696220946217555186670926681549834511582198965738701405725699413319162419260675112498363502092793504703391454183397223605190509776447682392921900859378832911650584617880585449344879728502582924664147035492599920419811225690206785690141694784887033731376790074877845604520689724391202973479854690838672667868438711988476129710553845290329"),
           e_float("0.062471968701195298778803260606698335395367804704204644522591171711175096770988953260877993182910813581560979080989033834014418922326023749557450790878157171072075944444514834463605869753635502129103908800209410284217876460669104308680888301398860354945476403729528128218699765694996560353855901466960078183266666745067073420214479440467688341653133138069422192705256553984555164167069664259918115928557"),
           e_float("0.10150161150076874067244098721208313204849995980347304278703448382621643777394681873847264969306333371962851977207202948125808928597804858272389041190839497279275911823058891788468252487058319445029675944132482901296306125784340915915637816792660835389563992725453925230747773389887094823178759458321441650502040373535833220386067854534887553083554980671363605645903354954250512384327514761235444879909"),
           e_float("0.035642482777599312345568516429666525133026867824102496270953452831015208802345111899624158756356652305472295278274444760308398881163024411298931842643965657105822530303162548125240884923931522625829809747203507095161699342453124275359686950855103245887457285687662948811340933426367048420170227132696707167004289525504220768961512720098486863499046492100208999963792285948745613667886650335116073698697"),
           e_float("-0.096250420651935706293110882067061104137973901517978535837473509681981378880743620952216484923693915817367162029060521270971883256928158274981117521934086577902931106534386509189184769846966558286690952810103906256219598257414780808136204922719511322000970565361224000653274724166747234853949929285131680210147476976499919380230910142990855490369260895631819329399673013554354698835261236396120992885027"),
           e_float("0.02683015452184493746521500743214858020710635897332177705624260732257042523888325964964243193503168921161583106302470585786370433003725689891148088201730800879432141307560975974142146770101025906547360795523001464879919124417255199173365076795547561096200464737867232691994204264503871412578035688981280545471916293432400265719183032100018358264355947122713885135971091174601638151370594633640683539296"),
           e_float("0.10923848409768541445228232052076651626743548265471499808897042772506965628848254413365338168538391050023139258215851861708363189929273536934045739221052171314677633316887568405296298155775393523164070263371802793439676790974887482739892987563946359701730592855651161485465668463015098000956100571612121398083522554301897617761221228869393794105059654657115645855968050372875400189867211683018967327395"),
           e_float("-0.053928258182482291641860409583488483566013850056126861569403657758932842455678050690427520391712742730967957721172562726832239500644022367329502098477256291065921782056927641885068726585430070613259158875827747442876364542114375561009501725551156809659041658447858182859971884429498401907418316245870298736347876373273668795875906937438762854197825242644061409516771254830637580812216962486236696436114"),
           e_float("-0.093476933173857787615738185612090238949349742195947644097886149868746520746408798564847822464979071396589129018722905275026486610860851261917366043160603137125211779447472960850162213428382501164492965322534593689496985032536454911832312555884165761860299947758489244945491290545620053289183649811544875686545026305821923470098612147192304249185964534494470696905619783330319062059328653500381745753255"),
           e_float("-0.11265793205914051172418164481251345324953944894021346510744694819766762426113218302697902402988644367559228891129209855190895347445658249918396398234961336178485283959689609897507322977622562909420549015578908977064045638151316047245376931762182160657825833919095195148163155064286450416363989054586012581182969756915198934550012217251825167889781233104769874113323131400420038427381954788052216513506"),
           e_float("-0.12641664866742878853541195310630809378224375107766236252374500540061198035893102944142358362438278456398579573248828534704916580561614045146504696755662328905997480093667518302457588047838687801988031207279895094564604109257249724666702233191192168234227672517234304118072993007134633943662655393075185150287064679634878095876621027877181894033547084663493285505437118122458366020793476589558565950498"),
           e_float("-0.047016682629597824688419282691061312584861685662184027920850984119162900323257321442955745341388045511401185465379664707299544052039819670225218702920725611600452972743777892365909666321116803596112131013760138704882337598815198555887801506463442027293226404411668380253755282902150971098790913693255877596343829917087010150047117239322242215453961999061335065184556744907621229676560448474847120645019"),
           e_float("-0.097059226244803285774208038476975145367791282549619959885261816772099384623934880648153514542847873934300065882961631551296571741144240964961795842129103718691615226974698046434333118410340897548607246084233532468392333449967387689258343734628381546107003620672935785071998473462085376522791319968008507841700512482166839264662783998226473402265509918480711483222698580327759757379922273008858360153153"),
           e_float("-0.14802724979620653089069006817542786977820920521536093687348611136278056648482390658965875205233399947235203082983440718594242406358022640117949945310435740532619351149238193810389312420180394714084843741181193020166293554331789206587033713224223220614830044023850314543791902240873895915682661195630441662500180883829144492534470380092989742745837316460282101778782708742563969351654335298845640658718"),
           e_float("-0.091557922739965909069396399312712892318495299570774208926374950692861200932686954165360756152154561651690380987994067456660160127524051757561030150358339372481170543759795457421715695594208384939167098121925965737854863721674436750181519865638969388321248084643517939461855775462468058903361947916828650416719848559215419219106890249153493899154225685729483698356352965666422071862949386617216564508505"),
           e_float("-0.038377157287944983179736409077339362456849527503108839526297146081827829308810334772154757960741341811349617812016685783955739581227778186574595236276326176688528983022422635892908600175527995859654769303708690712590744382056158473121522423202957100741525972713482507028687889287539028275079364433672350448155155685730831707415002599609933156929013619891185672098697598632216883926716849234263749975323"),
           e_float("0.35502805388781723926006318600418317639797917419917724058332651030081004245012671295717424605404027168842044873034949583975829267044616193710504024002258538638400990260103571281905156820329024916964476618232796777024189895947961734890864062573238976014176400567803973877338048631761087545202532334922238896963107976778170184076513520993704131557339153313266287571700397135560804917486391028135850253521"),
           e_float("6.3322512824757827913530082807448307231936138228403078913680741592189240342140526566553519562751967030382556677186539147589804914906764617553856156460636889494823176607771965507800833588317946056266668052447295123256795559633880864265717393184220055222191737893363368245915553831504188137852907194408169032288651533528337897392799342177262438294424000695435623848211144409918709663287045110118514459344e-146"),
           e_float("1.1711925030050237043866583977600515725598056640040473566782373095402624233050058459143015090912784299216781445003827480202843794495672376961959734842991798786120540969672543386840126528073894687143509029467971651979639777134802353062978202125618457608621398184061665999326326094859224150775323157847129251491547501281659849935666897741658703421755935217959543075012355390930843667758181025932453131612e-409"),
           e_float("3.9858716762980845204016649256753490627703681749130597758266591752891365008902816883991092464946621661699795725586932748521307745640495223085081704571106036401724874291354845570111561058706815537057923684869277575502752972241787846080746510997436555933981008388181389884260375249468004512880649860773791282253539622023005435688425038615386768023872053371883597889504547852987807380064096377579083576607e-751"),
           e_float("1.8059829310032920264907058030970344199674227348645017302731161989978351566053437063991115191382305213026212361980375797647856712339320555375904915169218099953057167637792182897995528157698807599050725612631556162868074064198431768583704296120223376156537664622448459357169924581623497145749097788255954524955064651685691645461858964181659401868675129332954325491446781073020304191485619235009505835396e-1155"),
           e_float("4.2659704450484549266617179187337513551560747240281976905617114458544246039586197429485558748398730736495107314697873926671350073636544942185105585843869707131010607443340827229064121789840511291695639703453973099629535043493845450449938184685804215916666949514271978815069868233674034932996558493547211223724132905088203045486115179563299382177089582737070123548468190846770892837391345306532402502564e-1614"),
           e_float("3.3076506257820506419782705410582521115871867122714951646147031213066472816495421568176909532582210880528876915420654750509793114923523854506989291571378310568025572378472243084175027511877131177313906281906931614869314670832817538175662162046866367340287585498435937201730814071848024690787300595888166738970604262780132924501317342493309963148883121604542704274668454401770563077253604261269792968597e-2121"),
           e_float("1.5240180163205824276074115937866567001610633119344230328390675593346884854581200039058811647121620795642540121940867754269178025835644322544998121418542792842323873792803047965298470299370125325568354187329727417766535698395002698776142857848448800685235013104621806212310778835630891822537870763043220589539918320194859794692471416895411679807861383023916303543478188087835064143525017075989186812085e-2672"),
           e_float("8.3102831570039488620128263237190038965508528145742110017912878188242331863859339483264662899893172330354227261370047147675911330896895911807207443800362880036339199112945913925661789346073221675810542062261552086648595431793279954086967701784349199348737664865493086431794617711893294604950860230541861054802302602518043813019299090689477879774319630851828369385150381602574615528214409123686848865172e-3265"),
           e_float("2.4202040819162758850140778336761386502406277375380898820106142378226218166574413837433467467857411976739556112631179798570599433607783399460177210956777863871539744941385232741808504077628119916628713239926745231023065895732328396794919161016969928715455478666930108172191159781559089361727244868139062309774188417674683584838476196344162617589662220897387746447930775937846082993827581844341064640411e-3895"),
           e_float("5.9117971630820330477081181781698367116611768354697926450130585702268462337856731232302355916461587581388080118754485047991908877229404803297803573057708683931781909210515225533027831978648205918927407044890990937429920152503205210588255242019488671820382854813832738526656116199710856233963414982901505383318818191547702451841647113614626409539025516964602698337290731308083717238766658997342986844098e-4562"),
           e_float("8.6975547694561380380257796241995470984740846495697563052123376367937098894833163914444961315079658355715142784571044388901642732381090952873027021875481122226309516310414317622479570667246727267224645335820679229040483494478284141142561277468307496167703411952401028789444550953323028785182435729198000952040749655360398423548696053461342450792807899750804801131892573667980335956193089105603653633559e-5263"),
           e_float("3.0396292401495872166630245157356771843256219760482086124745271143863161135520911123159900766453005451820960669582926619478884013636423080094985350771816404316761989453902168065552701271403741499612137296123962276579671773642174846782320791017256702711347723482410769724979398789857893923228360256432419972984062611838416750125979800953578500471802455494245657139539924271257456022428740122281717615167e-5996"),
           e_float("6.2141229266777389655191833787084424992167014571253632894485911437652338966007969565913442323638023903782261897016426358411517578461817834072582244836143036967467122395321671406339866061949192352687769796204189670976679804228702032045470757952492587777810992735322445425423134143915446280196285316835528331990528731957782728302551926849865771634050151407550607483621724766303384614698972503698170502182e-6761"),
           e_float("1.2537885626315565608026379826549859455026705117932764300997543379020104453506486862270329303828547468711789146139478839534939002072995522024530155595909435578039345485915565344713172289887392617430338170321358851066724025019836823358304971621508249105659043140175270254622007812494202618843083980378958139850453445413985581295307416912697643203487840374229543631093921810181983412958228956714740994257e-7555"),
           e_float("3.0920767172033283382703494583921685423134654480653738243474619847467012728157299253692562365812987205564621001041401615558675628456792859981460588978509604428704926768908526342592179701400625602579041283794045381219388512411017426653101554370051694827617534163366561376876589294716827620765020370369328945669251157998853645159927798269455443317987200833144888864466068137092635954573218757518517091739e-8379"),
           e_float("8.9317756917535713036384103163353141636714385508358560589053094632005780367452123372015421231603704656320657813167398704196913658578858588777499476415117389108307297618389011403319036241370228841083460155792225741048799301778376062603512004517817096783801285340348799009088619013486323798940250079003972049186097876939334452862455598843928029188563988984467355412671248239141913639739786312195387659707e-9231"),
           e_float("2.3339502492822492652257845023408432612248547928153079301388234864751972637901063642030958408234888608677050464865490286863346574930749797824655137669180151671589959081348080874196950907744905594646876771214690497899356340302377590721754554738608540698489871517309256558305900409635449690826572531895422464615897045277663982448425691360105665375813023948709962972277226836062242480505658503112585238177e-10109"),
           e_float("3.5469969666823017808280887388808159412604007049719302973520244907977631027066430434413435867548718118467230651301461411838241926879134148461719741191778534117210482493339056339728012516839062870598340261455671190910783261335341215921641945807748701364006677473806350790756465328734713937362857921933996189536028409902984395201323898121379076461511200410827875366343705899228227822927615296771070087626e-11014"),
           e_float("1.7218118599229733557094907236528651454112112725140000824812590553162641652900894365131052913915967742484188511053729953106962344508202131771794027244934275491213071630218000186009208076581256564414944746024037138842191373027359138633520629013773724633700563822038145093693542530832031935099919202985532576237006844922456070330724215391983659907875469534140250321507222670736991994841298361854561155168e-11944"),
           e_float("1.2792001814211292730191354159197028300827204011450363864676235816229700294257727684725503816149838431612514795293375628291349549451315892338246044857030266985106280059993713381736455816266790113682622056743245521728145371628967283936206951867266588167609062850766929213303430181546433835875202740840545483472289320365050271623558066969733964395904704788946278486189612291357494311693822314680210990298e-12899"),
           e_float("6.1864360331268015534165619203408462539482627242855143089007447460831582069828109708150075133559707953554554210887668172878348028068361055575314888272220553011727686745586242700695780474025543295924808605019474218899018960560941318058604654593921646552017386419237277268636140483657431529900064668650007609067780365827259351598994868671142344939926122157524302473429606650329470899739728157298827021836e-13879"),
           e_float("7.459470515893334475308788440122700060891247474162817544223564008946520158769755351612426010016703926803175410244396320202243550209715413285572193470031209708529073272931845442821786164903762630687282317855890334315388966852716638139364209396859063468225123943733227732094911354352706488391306931092499117997618446333409232388023420533956278471120532935596859384298694378012312696845646331263681153995e-14882"),
           e_float("7.8287244237453517499851067018060353720516476674701354087947755785644376206370746166267961649244109815034043070497415329374070900401462681140630470499859374838789848722266529829248938071776104378966148426993404450808333478320287614683201804700724393398506575878992115605959956176094045547341850324916033128273675742735684002447509484119105647233453063860585865608861388606469827918395534199750861926659e-15908"),
           e_float("2.2988185523620991985440438015122459194509563678263882549648877474550105096614676827828971026549300338281634571071196139735264954046781461777199032281208906704449220669566688594416431798055902399205527478689969787508294620900005563482332888173674166382953680476822824276023064630231624481845767608577514863044991352450388755778590394145817622770603776045377858126631801465497600529694712309209555102907e-16956"),
           e_float("5.6390559936239324267086946870595986295160861940325830443302915813236430104976309318976887851467544677777240209408368768146557134557597850886285060945871910756432110197308132925021548674636517789335519693138071750670579600208731459986245687286274724535546603578480536286932866985794202318665506521762633069195731466834213103591780079886034417996345639387675824500087807084950907631429258010235003504801e-18027"),
           e_float("3.2287750263596050434957264291506135654060412127487571816915276795736195385873330111680748244399146967520297311778784907219541050273116560939082623824267799547164259266326326603322802790348164177547153088571966945988534847370209464647940750438581228585671581491064875407469205057209746098979098792392363258558670124711154077540504720379272321422409518928427465594576142345762032433819270349521849155585e-19119"),
           e_float("1.1356004178340712725542568215057328820930835940618750485739082874805635948086810072232692588922616808983492746723811025013013757903325459629601382110025441838180256496013445796752449568085378208869949895804014199253601609526359285482699402284762897655273685048040075733726226165408679109926406722859899771840480479741448683285428975082521535920869288380500267227174224262656077722929592304495036184644e-20232"),
           e_float("6.1152651816233301565292708713645813149057221323972299633800432068804491663141648169383976515428967583920133114639815905033877348883419366286342051002485818474646680946421775824117711989951584166258638562754379208558991943806803013636661452478205134482405300869963024564737813555509301011010871034000447683817658201823706774681342635134489678151400991167772624059564377885899065394000182456324735006405e-21367"),
           e_float("1.196184066707925104177973268236466296665083948107467294706889271689423159246452907012895840247680067146352920824838755113727821899368993639124963762918283291669934738531146603100726429347330332534025868784861977999369222727566030638298951990023331184303599623251382648422132118090973953958757721418610087344806102070280586375078623049502673436319257477921950148793909431933312310702648228246403288879e-22521"),
           e_float("1.9274242742234635241045557727442777678551428022417376006485409710307475194432301395489712770760887492244564766272940700349384024790963476479671171079690541923849966595313981244639792240889100079500673616184584493473565054251113237310178944056254932383265984117720312952065197832653131921779974215358499476670183031008981289653514859221639217658490151648236835497596168243577158164382876711615805326133e-23696"),
           e_float("5.5669441659319599308825434498927039460763334752935462597645781651859092019732431193318143901793254659825742182107137399718740275542129111269890039380839286073420030305390960634586076026356377740485019539452988026657927795768266378216969174544825910428232450332310778641114656003649694585269777264794071071364336474482705426878437126458507500384647041247917618506815357967088068416683723040799146129221e-24891"),
           e_float("6.0380952239806697973602591267406658397524230556823976599822105282610030187780018814120925082352193436503898836518405976385220089923893198768279381548097974059245469423086566354414141892902706301049758267276679812709524673192996515093137932811604366608058972348780152715659176694453783601619260169295554545177253715733225631463601846958004100041819327225941178695080232197408173234710919653067069495908e-26105"),
           e_float("4.9754023909645064440540558406397532525015144003298929822004191450545105727917356552393158870217725546385577753945453652574956009581996950852491127682967287710246355208082012258108462903852172743720402510099347382601346721450996942159915981056638540370018568056673943591536803819621864426521456538296302780690883996530053561061854298542770937866401402868354853271733213922743439808325782821328523371835e-27338"),
           e_float("6.1007218103829491190203937697283413591772658896072204594903444353294383451360898612226940975770754174622655720007422289038579166315245150892233551392148665775560129253729219318325005717942315932814172500583392959421140348277804447153227107879594001928221023016158045974879397692337401370296752159147642212329326150893409396818407579246513139350111489254678268148368410053991597491947932124314928504921e-28590"),
           e_float("2.1161961101519117060827856677665934134977067143476821865997568436940521962331995531846814660094177444629389570392418606977087857736905971260100695747275777142906698160115857949593082585004308340057324969914767159804879761402543160211375253094697914663878713147242374472518972492208171140716506189396093904115565997050490411622613562816968886765921211619392362009658975623210312606529859135338861781275e-29860"),
           e_float("3.8397335767061082984756785518327063057562727386851211205310391922908412769693140471241723204642757737614422419442649146041953311861027347587507512752054352587865988769567193996862839847958337617500809489683366850552174925311294359017505304542235299511892074386830838266784398975568162244807313543154928722504641545413679211555227545152789033149308787612504657082988760611647494430769286589482755497747e-31149"),
           e_float("6.5669009878780451185404542805072829674742415068514590194669302150746677035025727486171007569087313119898822907852072088640635152258728661846851684774308940419953900939266545835260644963513141494722459223572498157976498056389596069518430822958756980577635151361174207416432959589193443775307875770977449212656562245781108320371154707455802227008409757640085493756039391007594195597978008666286852377119e-32456"),
           e_float("1.8622385262630982026450152136571740294208830437763140548591150837883430167863832010141209756823039905083810539786065648614149286837591199736249069490633696400508871203187182175690804802294106226143623683892405452082303227256151592430346591904550345145127602289652573082200495752435414127477154575430467227606515510285245266062648305333927489165926996472990215370477236978839664748436085820637091648062e-33780"),
           e_float("1.5061781236197753499107657440542753353122869747647742746833234514004247663687391272914714581821107180222098129949248039074771202590470285489609561280755089270653319490543502123858123393276493807409285671601127776569056824505459683256322516409975253182692789154132285680914536622863354619716318710559876509387555692477445035049573672808265041899969629012922873755054894065233232491191804010621952888199e-35122"),
           e_float("5.8521185185123161255880946881008954715459180188004551527485532755976257466236891677475350204542778392275820739147788396565343504276318503696026225882401953442230311103238166866761904415260162310340168410597456522637312170217643790225230020518674648342850016983670261549606210063139669838410781863548861970211044731712595407542204581866295981873146852943601032659944313305826455677473476315963272834013e-36482"),
           e_float("1.8039643594781433951297025595879396565686603406336499976243040426995942545672492476603977708475559361689234196421534563091887925254017762668553901761582486649967144508025475636478132299746710455281816698795477508700876754352548166592004176671232935111884104997771050213562937489416024866165121814324931734175140866859941092209497027497721775981323386363928149717982199077568098375558833153146584677885e-37858"),
           e_float("7.1528731148642219812627438034132383357324987121487261366078205027129582332585752277471545745724700752925886065620799526640042100620786306586935502433155637028692344887363744624695407882007905069276631926133821977804014095197291701690175718673622262484437544758395808498389176640370328620267151201280920899079404446911931797734491108897329750883125119301098189135851607265815222881640807454575491585406e-39252"),
           e_float("5.8128408421172103172331950583675389937484355366312238803743600682338886954501494858698824902860096686373201097342679034236447995709546262117703425627693043700328866048407833789973070742832712493038860246135191030083593886520294650023817301666738417654769987039504864544718271255428912699308782218981091406268568818696354963655629107120815948168173636559528966739452992184737345966156042459693896553057e-40662"),
           e_float("1.5176390006169861515327302625289529194333727736773608857074252333805851971212584368653548244784592787675710624652699482027572953953969576258425188987600795851425735987033744402334847998718772130430191052193090511135510256610752207591896421774411320421054783175983898641226046618323177965617717535367600378255049894967813305699001625024996879765699796201057413187960578364415442288644767061705937457383e-42088"),
           e_float("1.9649094727944841696755205896347985822326155049465587274516340155761779135112188552032405784262709379016699859849184939479424816354394436595908248734797512339600514488623059540685373872148544478521095325438847302115632357330693927135688521188348577223349607394618228127283137343851184799250361555068127834365589335252884990356000870274661142618466042142591045524496682568483425798591875259033259912151e-43531"),
           e_float("1.9191625662496240642749458538451529526917141947503768186612885481531588068651020715853468655366301539083478986264443534130351634696548555466253942686186312319477095583051474217183154505505279325896833934371143710555322915004632993676457541512628952296757949000358365613180900684278035829222160000911666235238121998882227144161449873297071675869103814660959725487062382604945522052184866030873462092685e-44990"),
           e_float("2.1217881457178287370239855041764589295551508715322705224344923189302297160231762407093305288855291712817289950283370752453937743688479574274411044938950773263093139513670499072804393528012726480111361674059902639795476585453045050492490163423290225303442913938486304559146995884014815362243321771616566019117891382591768388197169521131286876991489139409585700849545446914834383739871249937157080983258e-46465"),
           e_float("3.9326345685383390830358648178678112823493532114134063145708559144309770678339286445737319706867711567584842924631588162644478611986242135560810911144368275455675237559974148931424529519169630907745194358761677800057416051003534833097540049521989603877228762479788386846778195249080306564943219563696493555739244710150742522431954040099219050136874104929127510446929762420289002680048853103864348588763e-47956"),
           e_float("1.787587708839490176294482104704679537102089104800091955679275077332393071020120392428481027247123465610574751592033339786054620812148878325966508978005771065225456736417197724283952910401250094561693684495596908160182748219147911994846302693924857445668858782888048269010582988296358010067446872643310203016014209191471933092610197789170385305470825599548075355377570854757414252934250921688625403509e-49462"),
           e_float("2.8812418385625883211538331903659841906001337160389936610338525420102604851909740219498447094128177440510581327661639636413079770781636764921873891018530182648897787241496907534683625405514093353652309903476745028994315110692259215185061894559691882917652366056574556482627784469585317716779360303938733023077241754521023634092900908727283662612445710020212577357265529413928053661157368503987351696056e-50984"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00571_airy_ai(const bool b_write_output)
    {
      return TestCase_case_00571_airy_ai().execute(b_write_output);
    }
  }
}
