
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00453_bessel_kn : public TestCaseReal
    {
    public:
      TestCase_case_00453_bessel_kn() { }
      virtual ~TestCase_case_00453_bessel_kn() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00453_bessel_kn");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        static const e_float pi_over_ten = ef::pi() / 10;
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_k(500 - (5 * k), pi_over_ten + (5 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1.0627926579695902691434382163831984881523170880123819134593391317917145590767224985761895128149951608378178781960821123470863910524124140241598229060706891176691310227296110118686708657687967210705286458913228991320611499894374480777348267683919856675767978120906987253828435964960038544190181933407092652896714459125825456294587017736029719956902036214366685570681808165819101483669081902371852402715e1533"),
           e_float("3.2973597836039150393304225308040828741178205272126723371521941794435734458571922809011048910560497699580036129916984349195290287559357371603790417086003801266049943752002433336388108072691095924763458216600335632248203683699362341649638610541725852490254492467018020007184852974096079935685320392388812223435779895607698036917079074386388820838343277710681426225190594243964743705932472643705993058525e907"),
           e_float("1.1048913218463818422269663100380873049534124367570267047065513107867846840331907841731836747532659647151032828143340376956303930468898192871935421704367969458166314400713896934283297407795933175131096585132907334847540741215851809504933466915908513394090425796204215609588307062245091477262125705944621133965768150217405897949458778153497851190125131824513307871919595056391848554655442852180258264713e755"),
           e_float("7.655009668986381924528919758402342315499170784145474156448702285539699278715239993001075723420075421878204752801101014308598977538920911111365884672359074331602596159522957465381651681167289867584733927260667468595867885450285220533918629791280384179770480231325164794563257454620484899902513316239440625363736611437786177093095930733793463524849600544724984860489940613509553085788937340199441130108e661"),
           e_float("8.8999834379182189847703509300132521640062082378588501198045210808982702805780347140924576617867133795144254606282963746596319113822066130550151754908930770566613182352225596987885145011619636089243746575162731877307787371070683706866463278599495616090740527088281236093002049410794868657486705072417414339417318946063631276665418994918439245919448215951352596078872429559931334729725762113105915326425e593"),
           e_float("1.3938848026869635595336407844299368961416347543547015508315329797231853569425387711256919511355346522903341785398066009846107289125150768937851943671903369661774572021397906102206641845546449610196717142873757546141153893864132290567351959721445823304499048733522338922256613434269147048843087065229425430254613422208404372951918482691451652150451189199280903724663800883380746657520473908710050423735e540"),
           e_float("2.6776202000488109342942759119558393126644438969186932142511239607095560055779403227765153710710732205534901343957269584082239250123771596008741647098571938515371679922400684391525773168980402599175860966947600952390980512660787279290166167976066997100787868858702498501993052169945297090616603704991313028299022642485609306305998850502751284968993122881628766331890447816859347517001352046308195871259e495"),
           e_float("1.1863745522231202473376361616160340013394542602626662894791803433758152339851035021600488597802111703469929928529044547094340568989799284988869126336777030854992963166868682725629520568387975678998654112486653991371398023841939516401795965495969291553885278950249165261318026142977608859673562713434704207782109658824536151366651948473994797879998834822240475254469886044106078775168511446885683573109e457"),
           e_float("2.7487254810539614050431294805580892914537092653542003420581869573695904631638878430401816254103532949444464539805690511488534759263842602331032466659602606235590537409095225113150016596519809866225046477285269006245643371016803779773779324173435589275454238835075649214976871177024071857542780257035234844355263168939682572783277446937652130558259888480231203778501190928812196812386035494388536420046e423"),
           e_float("2.8319800445985512801939883108181037170449257260870141081169490723501017877293875352269129594931342272542903389745177382662448511062747484697801293196002845790788759868957045879147418072707399290912210389083612377871826419328608432247224730923938748826994808352641656534605638147137919941692366478310981857897153912907906792488989858890316850392193038858581850903478086656344672220365850714578542549433e393"),
           e_float("2.378787250283941535382033349206030577639533109272999579046033444200375223673759154831291220649586787400695669199427165477928593733256389200841733739990868839252933473601232248331432696287592473095258420978533738410605487968452036083308317577661244084955185910836844756725412869675603627011249598159351267263008171873711041722694598599470505851610491632661040496404093197482586072179296032099341978934e366"),
           e_float("4.8146304812914946612053934744946393397376522540541873564838937303600099692730251991436133151652377366129783159307975360203249950301038223127559724917645313867858087006719779294779800490034573425218760372993665126856274141498459218932757333426336791631462691010802077424707371492436590094805709865696065291005414691357940105520499282392727761314441582765519465571009961144148198306529532174689424050812e341"),
           e_float("9.4874627075830167841503700081632713197497084574672669331441665942540570197502687986665998001425192625481937546807339637735864154816543984695201131392932582377167916697619256334363407637268375639970885123941817562071606323289205361579191739577371642558521746236128382955782097232030994567650773316282064556265713261376842928359111023308375554360654932306408939718150096231067260712927300200176381105648e318"),
           e_float("9.1049494335819274162015902182657027950394641987634017416925102171989985624133315671447996961852618773015440855081115087818984804438001679699395787395912848910954357257342547166452782469830669789136810420228342342336181803205209655030830582524821757909059004430427390145206962859405529433700243073912893353185900157199347843390966922074402690163733246786647180433860557612050954109087875798687492846911e297"),
           e_float("2.4752402486360218225228012130380705419355223975919900067786170714069375338550509282405906538055795539725596204330197066748812806663524382975922172910779400845144227443338470758027360836678516416037963526421213834865511729454119587095363512423267178658982000667861901433288288348644497298911131544360783426411514433002058740880380649034170285807430316965031624706390225258075935794164064042414448558631e278"),
           e_float("1.2372786450328455897063700201553195568720623342789337153813874635299415411673640367460113958072007498642242061279161504303062016304584497812390429447149494879991516395993440194889738552771877701886199404170213219687189811828027235357450419116018156381891413599401117945006397035945467954825166853344627145249186134671667994029396092511977297141850987664788903020067425213466160387062147948307776251587e260"),
           e_float("8.0093487256222159886362349371530123183939086906527778732566963734355540458842637765518669825163494064278730711382748190207281203831802762929250421270368011195594683957060843148210871645614522275054634608591992437749529136653199663904325792621430832386011909752779306549127493258623101106216677956115906443550672764815806305754440856739370514774604556696392981988045281150622073904240554211620439502277e242"),
           e_float("5.0320919815897484818003894658751698602423007861287194470915282728333318558011686833446836375549233931879305554938635151329318795414621377522027351684625391581755826338132044529483501766851207871975434484393410102668392746787555965947282492463782351606188147944954271034613977943430721556466634309701749478073585364664351544837814596988610870439049126911709816685355803968966008065395604786857477260307e226"),
           e_float("2.4129463355608700070332830130658755315736565929507620081957882516279457349646579134502384430982147761965384414861507376109118902924083742679393148460443532626138205926534736933511482342470371462592791106414327381323867442483025916465055618511132105567513400158754916825004255586988225949031955228685850880892908253236598566334776182793309320205570500744211863773598422685518862889637339869418379091558e211"),
           e_float("7.2118618913825077262244716737313061382217953802432878071273224372256822771192503793043522738826519606340517856054072385617392416077492313810669329375202382845202880687179470727176224298971869794509237948895871443887103780768580692289174114218151751722531712306754102028431603364897481796880556594344952196524902080340518594324455539133341384782348748198767126390968440543739915716124546008274017858136e196"),
           e_float("1.1308458061363565878479014560528353186575129726403639738615076496559617992788631459513969363540389376147578511528042421887374569135900062823205497639863165844912171987574491520505120341838306011662649027746048047197111497519846212176829409526662676497067789487197336665150853942802251402505216272908052928219697922407784383130524891302499595615986880157175236816591470429168319440836263433925460416938e183"),
           e_float("8.0233001154113141144466214115033930820341700021515922592741317125533281494550160454839135916959813854203191171990630340291276739195898409522703745559516118781078022174175546616208839135758552934517509012989683889608470534823306127858010242836357909958476315964134685713627450552162024138053911615060787299758627936867298070868017677252864697526667633825112821123408032758556264638377210698687832190102e169"),
           e_float("2.2660799933314025751992723322973204631217962139349324399302387906193772456223850521325592271923044387701469278879662952618088479390073261687208196379159237191482101286797950019279545974441384084566969440158996947092303767122788072962995981787141939160817072127245475307844024841106664699411451095064955939647590844209663980694116131719991607543257448274357405340052036530859877853590069688553470787528e157"),
           e_float("2.278646234980910389644325474047142096387171466851285536035497497075610401555703294263478261744410340466852732546383986497967444380550383278377976095377418581989672341681307844501623354461687702402966907665861960053082445138858712837591178071027331497187070214779427985259769730601756892490691325768658050884869363596983832461196271416726222007137409002181860892541492793495499150103153755723642299385e145"),
           e_float("7.3960209716430230632379330362308000415453135100730892020498226105182399121700985351181293803322611257737928739634558946101989558502478727227721939205581421289328029223919744282132713815111139617804723022040980468511678749806906833817148842970309223971701082662529465673162040250904083802196722539511815500280200153209143715772486382605547780607854537751047083073100055103808360787251395408899934689907e133"),
           e_float("7.1065453325637819421616330873117033280499994645707212755418013897331978490666303085622773405400261236056549701319571235272967161460147765885092002620512509979104030474555139768450102077198826570039800801460560730412609977258883291977840421320237322134498508739426493524277445017267795292112424135396828733104848140539036859393187818712794514816389896855913917549658382126147429961816655557007595816043e122"),
           e_float("1.871925025942654690510797610060381213524359961970051712988917163553830201136201569486010176427247193026515734388811650504796406002001438810423288747675182364426321865915881891290842930433985134252247850808151912585558515800670467073536008557203954723317375619181380113864519691295192704363498297171625095146335389301396573379022111342234235904268612270820278286434339974836926669838476552473453393501e112"),
           e_float("1.2621285613943605396778326270346795947997340033664852355643338693832247110026739030294827363867131239753223966901398100509956941041014955304466394677506363470341608873879225242013561032632192739260876922815011793620495907436047982745936439269934827470996308017483640496499751216490640197921059007754467320250822215994761040888522663803348969329839716888645021562213496833720900002367246374222900084925e102"),
           e_float("2.0482924887561901597901188434287195116862316363704528305782550781504246305831034808602875598580550352241055370331342458917172607792073087268843932291492760930235459001293165290706249592344016574527425003192895049381802458201003307379565733698493074347422008636784379234385876960526247944983925401033811746965279526507802524616253524951784788703974669980030327953840133946932055492355580500973252317328e92"),
           e_float("7.5698936837353180873788791007623703652573449424844692651979491355587529910603774266836845269615554562045249782172767189260652897788165533546080499256257875571643213046264332163302523108741038590977612205719404923460154135138270027514615006423702744649937297262109474748822347096020431865359878993064471915875955068653145177456380306758470173733139566239536975812737783768849022847249968071383391222086e82"),
           e_float("6.0593813973810596164959432651402517469393425270880113462943021316384059628588531162696871509412077665972556591657516573782855042573039969600806340053314503240062039147185647307924359072550367301628610163143714693108825496708615109645765917511905019219357532352247988370115434656513956466465024643880156466984660078645197909904353363737446991040910357880134801733630203694591387460698291389943842035736e73"),
           e_float("1.0037785531279290963826300523137495737156043066450909455633205477454230302764909101342569251358415470715189488438815844993984973407409544482683877185357829620136029611935934600999009278936458117122443021215497686211974020490150160531871005506426178492936633149725328944537070993262888457712572997459556234582612606745237892358972024374836623071647169934220592872910867816107798874105707401048232183088e65"),
           e_float("3.3014039649063419559271745969868040032689786267012563226445823437183523945061264927716555926863249637263204206430986409393680084643918356268081601302409891798361116898039037279580438926666626794864892736832594732202361944219228434927246458044091463130907689503400354933847192590758550287898127804300789253656936418622646516767870727558911257996110255515582580972650452359161351920574802515043669914112e56"),
           e_float("2.0755279315818761120115776591428912999141829108670945706760603300438996821005065919634718912408566357534793671373358490634829984064021184283997345403290039997979900585827630901188317593123643281652546341366661590928118425121802776372952180930340440400597766101098595601169310363701972895644047138676849659665270793448001628559247042782742759316303452404087103985275560112083041490358091535064670559006e48"),
           e_float("2.4088141618037477848251671184948851014122229109689184654052990757964996093808209928263730375570550295472724495535157887824014224800479293907395051216524348690003205812786851213399541714215631764195757838723932245765079315475774703358041274917659200110679370054939396247651836984861114121179058434347107409293609867149653090084813081492435329678727652981942891657596420099459522839499277209101740858033e40"),
           e_float("4.9980608247056289767855586125132384670556596450173213180169083222271835135430168465377839303303028813784022637495212024299740611251126953098258084250065423312592822424955170817272712010257921807283623481013863963065904820405318705668332163056639752676571039569966758968208818623861796320503801133412368670907955292732829347855996528268440766944305661086402864660983157233486255110327508820382625494986e32"),
           e_float("1.7999984422049295849643136921733697877656349104047514214255569938095509543480558318236794553761230446514859749528197359342998341282463038547648300656710219229416930972457591780546597211430089004964208313023612064953615499759759512255153911783593815837823149456611563001913760299937722075150133941693414120063876243248640426617898691155558663351488482731339865218202674289994408924132615078241458793266e25"),
           e_float("1.0947603235854902987675572999502697297368740983306261257443596742157252302175430032035165659632108058360721718488995523118768997832712062077729416528356123610963402821359930381401977584350938207962556192875147532310131511438808556943998055516117381380532991220529721903438353264866317348475136336651329296921195831156506202252915966279105653232143639215826117062371487187896766190774982926898016153374e18"),
           e_float("1.096230014898423814521695956198679381925675904954799964735284309538192561919183869790135957024138501148693568732544898574451341248742436970222717335529774859870820160252795646554133714511854546351695968230479987904283357970176594424809231928194814266912385117358900601077477322963047306926545963098191989689094967098512063906771799509000934013630605130520124020434655676360843169779313746002643588856e11"),
           e_float("17650.133129418780950913997560239593984253584996124652714673152927811318703296119672710731615030935994068362453957149321719361681852991834528539093817682271134831652819090989546788182711123680972178420050927322526033134692974511646033609759073379318454186986296046472047743880111137976364714047576585243450171963649084322973042765203247034108626781678172604216104792766579908086545755918763353643692567"),
           e_float("0.0044697012596169693888980496473854966227593018462803213444360685274212138177674181406311053553228060251623340745696928623023840053130135960577138848764283956951530976319855205902027039670753328473588476497033515664662001526898569879514449749286433868118584168756768788110135540255439755505547898336904496672986796328000222812518143528574539297434021547797355226937114297675401074842038574675470954474464"),
           e_float("1.7439732884461561691378724115639108218071080938707565492419204886559128725836312420887944150407630037476993091362167649062782372432529511539588024453231600239362263608720010867554410796011363585289701259439377684134394073625431616559485428181428252878603493975896668829783455557669295866153276418576960811864107221507434802949975779442818182277139219908027242299770434516499528135874222882858125047639e-9"),
           e_float("1.0283621316623733213672844882507246971857029624165017856389691889705478731091199542700101789008067365067878507435312024071432237141367336564931456025262778277601827202813892677418093941039226473427839363712947883996316534813582445480611304226308352389784200642531386048752122438886934571290517114770462634079926718383174283524772953749672900638455443600967224363210357952116868900360656785519777745801e-15"),
           e_float("8.9996822647698230841714905110679965999654595914577989644396706672685597343996954035929637089525823106024062140559616161564823955665133419930951066917228248892024561415297502343886262163190704853711953631582172696142459670978120478261993592361129502100988720595967777010576692022869494516077295702430057989058936697081933770748555920524157494445411035840090384879031259550400167857121555871254184813011e-22"),
           e_float("1.149167230682251042159816251198273431227139927013000404396496884794826372959668809510200816187168505769507409535558836571719861576234362831670087673675245134541628970540606957085888019186500435621538170622347456598170018921784043792685197016607116773970426478066377280612941617072363589503137717990990974041146155197409674235373169147261387675214962544713776003729766737820118438862453949329362302567e-27"),
           e_float("2.1069004026757404767208719298958760473551574336482600614619205172593503998876182831413531912370832035788998480877994175872621147532034988026980207002855188016684578988141493451914242354267086955759642810580101063328463644695304924225462021643912245791050822241848891637081001856288621218782354598164338997045477364858691721680872715764555568336331282836098611629205372815439406392165712790021790445548e-33"),
           e_float("5.4630215842804935908219970694244483674170230734147324467848091944667073256860157557338677302138759074316165944118054422568564407272892123845825094862474885096989854435289872863431295376036912879539041830404566151292505129654570171228840517452440906151598450170848854264358270970557183270525012823399792234474742051012873919016893914676429199401828249683679389742317416679725099862498925208007490091082e-39"),
           e_float("1.9748539116092910364384026467797003530685415195107372122249929987357542598929943851590778957416810607886711793951786933497600993499820398437843712010713785567516738097099558556482222957409998131155809979648741346053548444940120884141114367100813862074276553824230067855966903255541480425522694848424189067804205878892927843139580502206877840123973734074462574476334524552170276249880577780922733910093e-44"),
           e_float("9.8190200742649574552595917102759064484006606627047693722779336910494813469529114846938963177700363106797908989910228438857898419659049040837354199516740483893433591629706302641750605627199582592996643832719990259698420902765469918789193488113251361490023385498478277011217221509810698695793192872463190442327236138260906719746399331419199162573111844028281749395502259058400943620489599773273174116347e-50"),
           e_float("6.6291484359272943378524497173480781739536465926550732462640659989015669070176453729144289811919309711724877316368512501922293829323032972423942644063817589931618758109621978902472425751864614905121004994263388975223520099506174132362369140044626490984901781952448156047650982821300541477024631695126615273846044587683358507326779696945230622885388552844717521828011719547607211616858840839763076132517e-55"),
           e_float("6.0036233967924114511693766084166856798497756818043891227631435193101685163079432752808508181092027925448565900991690254943589296165087472342493667002393062856704567132180273859632690308134602958315258614537995640936739527581619442651759645963491441477333548568682036402467440038404993943201579101752881752189817429737519930036005398705798070308938103537312697392358792856367745084846673926033370336631e-60"),
           e_float("7.209558364013569712602534411200677183962957289862209183268743038429079333266264212095698669863098993530481871626684263775739119735512165362395146129915812729815792756442994650203806109983643864233332097573082240837319765738683455171268054028284728571207163749267668041570925314471570734408025614276468255771050940447933190415558898988235119659303094681853504528989596491866579237568803630221279273003e-65"),
           e_float("1.1354342601582236752313641610026807286182358257479283467431154255524378319995553332625395152890078181832055831207658763362915859427098372621021823096215573667790268696533816197658760354018531484330605011148897528314503056852344150227579600597659972996868628624189917978242803541434550918225724853822738671616665842893597480703844092344376698031694994448967291711951282065339967028762503130539148221825e-69"),
           e_float("2.3207077106847424455546425960066692616951071071106241248750523979397830502052913354413411652188542396300974116530948497486673418831537839018047153313165963647155999664874423367706089225143124936926501255506480010266739443306171062590336748086027179630951102712695007305820912977730757452722685041376937980480775412652446819532135523559544576344800067724954088634488395625132924713546912025336801663352e-74"),
           e_float("6.0945872604421569583193600607785364076771459671333356721296308609035891356684817103433620765924408424216761003934704346114776314214227366563212540056221992458372080192969482937473436295173341395499198147236825772734177734254103146431160785114122444564259098550501744657606640826284095948618819691257242008880478820792347909322814739000914680513455906852044721843740346139796143137943109015709946375828e-79"),
           e_float("2.0370111646742772924716506591575929415916878953027027544709312672335259997153575273554262139831325507384442614152246983479511239435655207483312286716596380817723938175567780828486140177078593763108105920188035921080424994097368356044623086789580057945630197015382105294275226118257129917187557917493250834553431764965099240632363719003787053942771446554540519396370120335189955160301421055559685148572e-83"),
           e_float("8.5864718515214471776419737752218001991520817893084300741174472942466849090069234906239771877152194293350676410892504443029927504717573363728855825175935953639413093169256644821320583463238823869263616580756264521601537351869603024779646652152260612697326598655705330806298362686116852182115356515919650539629979374456711444439168673336361059029939681567350912520689470114273812745449789617196979168945e-88"),
           e_float("4.5251304645124383875397827686496870174833250099228079079839612022401642368876493327903832501224810599415392653409608568369278542888667352512823318565477951797928598539550688839160874039362637246063582717976506403186334649685942132059171726700526123470236344080646594424818551330719350432042005090117677083847983375393968871128923884720889587227686179854789896299948497301398219565759661629138535340031e-92"),
           e_float("2.9568598684644814770574003080242741314845236503406138176362420060081892233131232378705905096982224772087308294711930129646340101653363250202398977987657371226698178036128971503457801577722558475166552317590806883124796385615342247681131491826904203207538837509076964181946768169207592160564311434269763760663311231339697566371377184981306731115037733772191644737856325307283815209917520868112508095972e-96"),
           e_float("2.3766104195959718013077005822572548501854324126509894764352474017314400953592434029094932924074129525965970628990344545267316579039633590706600356277425268514752016337778398812940231944108273697759483627293154487675808148208325160090610213156708164774322543039926976960795111389047477041465442378240554526804549382798026657865340310416508155853660566673792210227031506893686489517918396580539565156014e-100"),
           e_float("2.3318715642000473088832582774078009909571879894283304980397120993488825680988716898205088810822795788073058955890953049280601352492770128185730168258449351004261923085232459694407207921077409553560972624209650001694838444657324568264112594326997583827913916680223697320647206391866544850311066803993115787356428057408317042860000540699063958898906024952063232964701065091632288586334624081692842168132e-104"),
           e_float("2.7726936738769148544285042204626450831697627007528615311300923262201716912257514212040347168379619355424649380814131119930400867300932242433382881561309424884199838687472355220936160022897276999272651446542582089391198775721027079116745695411988891146718035842931377684124420890442139802128195589727408390775977442586759649223775582001195805033018692414193570784647423506618123465100339955446252708496e-108"),
           e_float("3.967466365701288084051825191500763289847608795862235423798675888523864326655273635346687446501956059058557945380121748033719650946694655583412403524315316604604956415305605733085094819779979020744398340132563591729611333621257936162110068081439602877157503211128504622067865133512736333794885606971037777706565133555350051896226694324682371614927562300358804346200755311865796515941602789356223409331e-112"),
           e_float("6.7862154159952405919342175357690188589493959142545910407624391667754899602737997259002004416899149846507616599725288147458751193263693171269911074631774370006382165339843181821286496350257568741005722694142998210930284421820754797913299526849806599893448821577158169488250404768422491969022984448939545768064502806482227779919902513179052630465230022161200669351126032463452230089446255948692756136819e-116"),
           e_float("1.3786474348542483694232714586401779914509729183329673355441171309783553278038610598662628749388881892842882041275090788338601433529876380938910304973431505827988585439650338919792941092022899857016409925443340874888809759237073517610802297441096930950346005394916158744689621993279649601616545088263295351312553381172614991608369134785207992929972302520964754074432755887940393206128959426411290323189e-119"),
           e_float("3.3060665690394063609315606235105484733351406257360973659404540176890809025060347129732195161254109861585624795555398613551412503614457819755424215992454225693506398982359516253209757212400994321252485669054479134296288498736934994892913484960670978716562728207590541120995064772991098269149100012000792326824075627961724555387418036794188471568926631157482036581416275445898178811024748314278249148807e-123"),
           e_float("9.303202107959593490422104427986442063030879598332854289372397913500194268650200238097877670026030380169425208943242443748229612846914789975567422778076924127110710932111668650956878178377352604711926041662275797146454794172803863558618585773062840321179675264914420457335948641095486249935776163904713438068629640925975497186643710522752007916647806158159417873629698374930483458965431250085741315291e-127"),
           e_float("3.0545591398276864251377154504969067217357439285881164373319408556855608738229050738208955453484572563714787490651150743693906206762296416244966223306537324816199600058464460158564560417435975584013892672053900256336396294088520685496513009301175971573520631912028021942318784359723384334772590040971102219307722027559752099263354544030615907954803056072693649029215135047302104239032056401081569894378e-130"),
           e_float("1.1638337116812886911872976764567889651529968835243956652509653913850409161686546808570981884515874317033460550338088119607467723038720042517001461549172415435241019321439068474023722844822709767292956326792180503158551942582751543202534095727718354626708015461827978428801670283690159573847797781555379504969465100972275669367587283920765579379127094504358270494159219025603040607242914449019564622409e-133"),
           e_float("5.1189948046933273633696380827315180621338966123510572646735044344760549762858050342184997678280660869645089484475268483982046018058249136159630511019545729645779631703765120949616150435553818995835728554617205708139822544463385700876583228611604197504965572065088906679655488363668146466047981528406681172976823190458585502568888720538799424609527829640940835846845144060565599263467918495906510928125e-137"),
           e_float("2.586096178163833824660690865984021329056029882092410641952935097419763341804882497134345064623979141520384141180721783962042264136573310618646426818919679842271079247718717720177777470906337253398178821353809496413979960827849774959722986342681309359990456411158651576040115603141380502439722475424692725140405660892941208712197222297709852627178924969170708274725915790024633038941409213990096384238e-140"),
           e_float("1.4933846067940949321853044007396848010860906579066965037394716282981903234920701758382597954880303378963415554374049232319059459108953768009435468367040255430667079002824430897763326463166843550962994975854385536139402731359079389421286495839482347486462305847903573233500330210554980317594831503886477022814680785274309726977136999652342981739369910725493131965989977841489734217688805161843770430466e-143"),
           e_float("9.8118004720391623326959516162105587875347444134702541095808712281721775308148418981576896739087527356052316846699235851127680299032408504609331813315851206677647985697929865290201982296064757803527877094321136450842256705118026677791011661546086056905817991260444366347971868063158553813120066280919000196255633705922740806922458498432788403909011111236611387524053201687754860827024264256062080519837e-147"),
           e_float("7.301928317235341616740038429914618879764380156904557222787626794882152744320992433434670427485220247599734405714846587160879301717009617623534742630359007282609621368581946617846566696629839642705447966263933511382669978949284733169423266769509236114820647112070242452794361054911847187081952764355380574300429264998655414455146895031782113560789885305287536884285195742298005928975837652114011917245e-150"),
           e_float("6.1288003456614283323506036359799879840243466835772553034325650450498268501984575189237792136203647991691351718627409262118859702430936781241239510573480631075242790047879681445767521941293891517536510896131210167653585246730189242422860214096908396731079789595451739872184452331074568888424815395723566492252741585078835913345438377389779586045865142898207406514962015743314556580660949363997616043675e-153"),
           e_float("5.7779260626696424834492272566977190417747968845649080155217491313186393387315911551049623298834278814486525771137734142260526115668677228170882412624915225132715864833280148600167367374021153462837049152045510660992294540896252126801856098055498315122610947940561905781102980078125464698482699657860569844379904782895677321883435262346856162888926607418272234421429520357569870134218252134872119221545e-156"),
           e_float("6.0940492433756159825296312073289148040947410917708386990735273913567720931758202995938701188195979766556249425513896320940955689318270645974816502485895631235233945816196732364963230763195244827341194243512623955608865886641313493718048931522787338734700906225897268334661715829152058924975633877826664665543742256264499643433903524801120150143975122645072627672741628930327934077727364497304990462159e-159"),
           e_float("7.1634588664344994794590224778777346853181811830750497767706728136364825479454380201373650153726510036607000365573273381267284746979329655155614015259424227913315534286119079714249765017934583876440939588966437745848738589841106619142393701612874516929222082763588638433177242502141528235988898529364988824605090745099488469322726609766747693649726411139057177438356964098270996001354799612217086908803e-162"),
           e_float("9.3504292409576547622294273713432127235380783810586617831728035931188699903252939744077475220527306708058186769711329116098070515099381258699701101137160221092774224800727331365092474290507431691591748451561436292770004055494047282971088858195570578839996266200080893962996986993112847286949084220353520164116263452999379521700686204648841079872038939830720275538390829900428428518672197304389806853553e-165"),
           e_float("1.3505249116793935847434841202010590212314460539318964985441835958929794920732054696529551777543795290715357535445764277516584394274442162958408941372371184444549285852954211767376475856899441296515486661546057834651362340606972695063749636035712099626307509190029876679455054213121265279956167933364610331216394562315843409152938938987226803071313724065475915640181299876335760813583313154030318480337e-167"),
           e_float("2.1511214813398972985517451119217318099635476755144776663974248585737558047708185134335356638978400860647679770448595899632165174662251604237685904427851714050581639524372137999492297622251938933477014693917650959423293279860066567680934504616294316996633969178701551751075460042408992819213882884215572716250303931675213102213319292175452178434934900370869712988436476232403862696595449961795713970662e-170"),
           e_float("3.766204528356827685772625514451004508047199081478105712708867448841179225846482604501746823827037867227969646491282410337576644245060998879459048177482292187476887435079981478889221007934636328125108876479842931405219206183852095498073968139096948189196586456673307781865286999793949593456880739428900660589447590273468691987931435037115101973790093144411137206583395738438166664195587064980929135004e-173"),
           e_float("7.2253499989508004707013224232925150104538381328533861485286363120918544487522660772857233437637323945454317492522116971773566059329982709262239009485220096415250787297373202894268828099275835545207721615020736645805797064388766448133442415939051960464275473725053248667271343648940244021208947520024952435291567323380406323623737478181198512117022321961261026101777784731903420706926974921052368037462e-176"),
           e_float("1.51433228062940466345201265048704578909989021824515714688558086661814579979916775058020128911366809102609080753901924038181309305942050047910813810470771049192562679547893430493274581233866981714321993770620911447150841189726377010483720442870909131188536899052760819920693461292024440135179619030863512839019758591464388623899888323806779894860978713536281801687286376299784060561794474167684625797e-178"),
           e_float("3.4572584460228491471087733086895543478812913299712396471993731200063824347413179190164433998870910763590313191641118805843785400367780651724722186299104821425116262896960128492452358756251422247015092447084199976320037781714193585766202813682811454775788292093631741112673731565631349243848133892667114571929474121480594431905324616414848099697048560733092014402939248611763408389719825300163037186673e-181"),
           e_float("8.5739264229722716926116299543702183189105569859438788329159048897732507604833024637450009678781362586341221156061547831188052976356237522514757355206419024335113335409438158112123572381468995144982196163481036366477508054251353487004236503344443390854761256802765367991183979409546791382302645474414397356982103896901383084340603352826914952471203346724701072691843111041819790969543660204909610406079e-184"),
           e_float("2.303560561960113356472467522633022069004546479822096602338055540254498637755432742308029378341844604863679408084352822601394198391913464400692628488049643115872630126201226206178811571786529732671171223667704689947497987675668326601881324628250548887974579620621946829674715106509608249563839518253154844810842082950494928018064033947850961757199087102329980306469566101904968471372777267718483508028e-186"),
           e_float("6.6875995200032739615925786063934495509570307342988251522575370482711448927521010563713783111170992947533284065927254106887252375529957063677894274015360572651486647636589423969552277674169381871929852593783571158593332508337220589258363737860405950455919341764546220521570446060657552224034017027391194141208752672456670554544455660278886902549987171838301985405939462533888174787490376155126286412788e-189"),
           e_float("2.0927273314961265331500654094112068702141171470025315036208337092557743033897513330742322172422591004797449081313068102433636351253127213704419063046816690750360927591126112061039055481252183066571042398936876132976609605593957524341598284227302947486750420156051579041596215050753541251531754462795951761817116811798625060121178682046956307007065953250923958674528927731865221451923328433901353198548e-191"),
           e_float("7.0418761844566235492899036448271413173461196225564873029446272938029345856717318955678039814888709659239697859689434785974687133900691335720364600756795607053503354206456821889895328181159976984129214502400559943852044000104191080325325605341589413245214649804410730048618571025355501812432561525637609034655921109618512743752362037136168459119791907382310209821657209034569992787541699280340934207528e-194"),
           e_float("2.5421313614883468629299995145289570703368403195737235720948624336882722543368946125936388935241369613371036511696627320354051395827191195934376233281555245201876225164853948777916436595140992003838713959171020701263749893538339294894912036278754676325467890921167310250187544325526185625570498917874544889100791596948066949577057623063736625819647062401089125512970013487869809759433451441672931909897e-196"),
           e_float("9.823796059232034091932888197051732513679029087589563497902214479362248418195946247326256160930051611583336335808036872869258175439664015649885576701541656137117391522298421039980428630546839673834329597697972740198403091185057289159664746290831713446712210013750744329576783126931929431347665000281096181396820182312707043584937221190789731453528152989075943846771899890151511879326377168326157328036e-199"),
           e_float("4.0551430248255755276105890605242320987727085592539927350305417744544440998713360411529015990552510928951076693603960541896002028236140134694077470978135735204428697195791780025690042531734162345537779916224219958946619725570065800790060692871230792566557534066768916168088782509520183339328304012377106405052433354120298818312991432068494508262546147893233254446709139455104804673176231330837277795877e-201"),
           e_float("1.7843772045868580177429577696185342897550652311116252873902651123897794174175620780289785559480315352183012681434643244730732463081683000547662565524882831315195315064939765154310699860670143427858071547788558675027583787632255333992938618937084736558991738577282327468815856399340614955056029812388022059121542673710999488046583428740839050403730305992569003098924734374497912380659562255315298390403e-203"),
           e_float("8.3533755452942993287857992894068047661273880478312913240794611760371368907612601622998397600236999461271795893983362722480396179976388144367174339549798709871084489358137672701478298494152235628237096075192714105100139123205531915906004697446659966595807496352606992089473093982303458822630842533968172276867407843933262196808642300994453128179141765810418530887547249548850169884062477324268737758115e-206"),
           e_float("4.1524565908672203415380788628745675669855664456321689889517766872168979874210722758530595573014376567494593783610152358999198532277153028531525823053043899768564379109866587409228123778314582185304867663588519907941753525993334402534680233642738753375308776822406064143640821661911833490161187361573222635004646842203863062415322268060266696876383498693298308705593321468594368341342017742714380142241e-208"),
           e_float("2.1878587774922698611961493217101698139389355981359678527618038969020190397693962680555248043890551118007111873400357303231043731235320345225758550127191787732590118688409741974227047351365428988591348528290845509283797740700003203467083553395098749693415281565193911221675097676784599687495981591861686484825851500546910195501957156916448554867913322784785015927175659193787874829554706934608614983209e-210"),
           e_float("1.2196552869086282258273965270859930879831176035881547007413103896945639356764814923012788854045958315234397918789295145101132527080212445886669006675730874161524479318099087358385095487417308233056557276854600837271769249426475951630964329103135513678305058200877131185032419243672758656002296904284454049437379558136404048699901884965146682518217626462749032309956259092007176318497464928080173996859e-212"),
           e_float("7.1815655339586916455711987543654974832726802003269913455410046032916567424130775552486341916588343968897217938677425928908622110158223896516500359873029317525425712496185125271237774486562581975928916880272555922091367437207584938368301826791812266983575976240340902428126130689971263990739003621313387516155198892159190103676479535173342585284435031438821746575731583754494800514143290272488190951871e-215"),
           e_float("4.4591578204497698220306615836925190233291656377883759774767319578772067650121993515792534837611355787538675529772082922401406563963324213643397068984190895797616015134162391991988623459867748100162512765065268075501520987826976724013509269554856461035851250495350939816145223632973403389040378531129223715885059860180188028784120750278653285803518263310723627775560716687794439463534075176378077206288e-217"),
           e_float("2.9150872458169387667784552151291247949360953589618406233404073747256308998262355944439816505923046319600271698917905827498327584484015375289333917729415928238500398887099930569321684558099718368932114425138830782088571876094449538776989238641539558781730113691641579297404879898007616911873764094105606192200874433512769172465640227638878467447726006187535216462917927890565604420370221532730557528679e-219"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00453_bessel_kn(const bool b_write_output)
    {
      return TestCase_case_00453_bessel_kn().execute(b_write_output);
    }
  }
}
