
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00308_polygamma_fixed_n : public TestCaseReal
    {
    public:
      TestCase_case_00308_polygamma_fixed_n() { }
      virtual ~TestCase_case_00308_polygamma_fixed_n() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00308_polygamma_fixed_n");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::poly_gamma(11, ef::tenth() + (((20 * k) - 1000) * ef::pi()));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.3252606844068353932223396649512429147570348973890608028857288415599612737926103814924347022022784946435942960092307878080538613497623081684352343749240320917434679090184621828856480256043769002465226166080683322282039983133367445283987327629137400280506372096376716760577961049072143848134708815893736481999149498730958538336114137993021660649969280675905779535247236346848373746829632071364228952659e11"),
           e_float("1.7212300023075545967254816961784194232543397759612986293147670291758194695268485826318982971246897422507291151027480335765583080468928492105783412326627641557056330982411450264179115031671370455008457415364423679524777138666915106867603362141313581206946663270225964981137224688128711498796866539081217417357490238679832479986412825712732448205274834897060912558191885250838921076130752092387518921716e13"),
           e_float("6.3621070173347965450019223759018935258652881946123148709022629154353265685977005415731111668687747219649913194754751882317276999081551194621089609017774049153019690266526056597843116960406855551426162783857232861975306768241849237377215804928563211453503453593340748966425239470064901993781046637694770413067482134159505887599094479916835293181944385507236244389788306916121486332845912723288701145003e16"),
           e_float("1.1022494471503958815111645411293850072368854076522932833366951717684724920721407861271805051038590174613928717780858945485492352198815672887797859536743329306183653705499346874527454058223468372101720625553914316167664645475562152112315806689134450524880878343637519291248400410988664528445518106729825573863651319470836946349826855889890728879491505829600076976940560253765262990942105238596435730325e38"),
           e_float("9.63235324316986944605463648043546253458441561529196847709721071706860738219075558734019976286656759016597726165411536225462932931998438468077127379042980133077089828448745224271318552676925546456157672045537699039789664727968029553272157895566738584389227760123254782838571950858138127019969844288546280016277910175408385048248481010066550755084570681623955364462341091861741761461759144350433666483e16"),
           e_float("2.1176730198603982657447679719175484453070195415049787405800006507438755922784488926827758462706401067830815124372827079112778202281795065482571797130653483309739549159307003242509240008563881344144263384955736233315982390969105371848103869448428774710490413450714035759331552865508059680011785231754466956657569310238094305523912348834478767087308919072333313270657391654457050735488012328920429132742e13"),
           e_float("3.2723952213957309449418324681072845037462660263511382294620690046610160804916990529369477634914304166231971452069551238749752194324354598595439018394677018446757232883460110886865245516489235068537561537317399482269263849041945090695887527756545662959293737100396943514108894477199444743504924225460058025372864186687747524375991192332858212750076033277042721937603560619908254746643127080431387586159e11"),
           e_float("2.3662481599842346491161982961009045052678637969947676219758387786505217510802469840588881895412494758309487755777633114722255623702199740707372182798170365624555428961058480255704699866068178322236454208857922348275296133672336940531207980795968615398219791185591210921034513082223157176296292598252409836879755270039660885862335142178811784970655034698738364705675256087131074770909798955821382054351e13"),
           e_float("1.2063626381588298993407632652171285373111687347988492888820834656643687038286092384047753103703895031392113992956106766909269575290189066941565510847481765107009132650889047648803673522974058763145020740807529198352447375731398628643616833231304684268843409267663839986527141318567741025780431862337542511966255912224902505331357290883418593435968145369107605661886422443789077908413406666471083623879e17"),
           e_float("1.9243222932246972839786070772834686257216033337701536749145013053535145602689145698911454964898540938465366311486218300214107953359213929695144091509036155025997066063709490980097101582389772444318929606067606421942160151527843027867104226115344758541128133722347972300859581873628388815460014456305609265724029199281834747848558259272259247173973551943170848993034396825104823182308985833573199595171e34"),
           e_float("5.1390857497349353392880234701444822994746311567967423393334096063679336214239384198427482077056728543218367964884752745968457115808178318262235598524188079891490368446358248607756251804494500778903239992905858575497282910512159864631520578975156676879167676606040749033035524901285873552086325240078076527631200336447884620562265918667725672725810753440086454699082165521999694342680159942651140191394e16"),
           e_float("1.5449128928138201215760492485831152559199394112143651165999885052803213395016241439643226414135405480857690225902437746043387867622501915659157655772829861663574245091693547560005976484635120006917429783916125955391645436196114190432532519699962607591927271413657203249565438189584207011529985505017264715201274499059894569127450212005257247667680312460005364541683619233019285900548930141773039107751e13"),
           e_float("3.3815385243274824323164827680283200078871326052972295587529373071226566298410040657710518786255026470573015239356832625649543188660630043218814870112134680452748752720050485081833107533169237223590277689266320165851965079438939368083262006827792618612322343132058065803668444237233119172254783629088329499030047418546198474337507376062078676395445481794515934311599117765200205271831690893287820697938e11"),
           e_float("3.2814925735696312125677940960460571722874242594193471887737967306081049112512082087918915708597984670804766786188386404982838949239424128675146323830179884048639517455539337574956447322935726009203979190919974139158397758782447577170281180478138914908979280542937656601447023745179335927246705625519496481174140273890265720385750722249235392609809647408446902023984268611961712338925747467896510898514e13"),
           e_float("2.3714266978000512981245148408368424106825649770794381164060446472472120685734136474980938307389225639762268862406812536064929428785460902282700336781926043945961585115207678799242648845330021589168320861406439531961071014137002970417215991003276335033402855784334837090131197628527343964547864341904243577714564124340157610719487611665922814397268913391602659604939037849420722612258771718750953144167e17"),
           e_float("3.4498669148103702515521384424639327440463010562075235778069914175712199376192807741334379798714785974497640213060161164149695396482661465984037804445733351580344752036121686778053099427003711124476874625949700941796581212251711192046732456858006407882687673446976856191111011499013937639851847186124482908062928353263109241519712051293170849048356938648289025158204104360209739991551514073128769025621e29"),
           e_float("2.8288907518049648792212594807032909995920194562105714760103900673756606291736230560262703234687558942259823062828674559132638745469444888926368645633226962792751485923702185959870213332567159802574734070663853993735436502960573186047321466095030856698964647491825299601548022878879307063849193231713523992515426667082521670272102965524750654064396183544427144649885339935154915603339797478000708179937e16"),
           e_float("1.1363115911539488764860020031475232920021657385968047032222040806694488366020949040004720747630023446210359680586631791392287610035895941584701286213138160704543525206586968244577171566037204134809037346289222545043294941836556440262340429713741219149163122000225120488828646431587289421354718270496668380765312230374101338972785065298607571592492914097158526484015742790801054251206693137447206755303e13"),
           e_float("3.6599912918820476075465640420154043852705307022344135997271187795595167861263364328086118488250003276777568232358178071353238049726936931060978373768450713985887878736684538846649018270292685556726281044825957342784159351545436060505019761220922411236589660295220693036126666870771533639819904564150223416718154659872852763971124603166367543867454831408514152274431431339849228428605560732480660954426e11"),
           e_float("4.5927834925954876881994914351758371483659804155338676674610536349917487075254990262005066119066068646493304561815914897580669947071877373820049844880711519333588033056532238743455236971643569764175366625234465211473772786692501378121047287747597304702645824925471546123769272671135752027205929960510546068451154944015431419468900939859400940721319236403363775829083422114971293965306878341923032819201e13"),
           e_float("4.8536251582375740426183761373489679754704989020294108506027274632511308364871492131320803382276878027617976701784680434893600089490102627686714831799889777083129222663254224826206578205785675957664382118406565422064434770960418693008593574153421847322333316345397257776372494531792268064686105329282630391510453650491340670304761089052186832295619299703250592851986888598014909761088529907693499681118e17"),
           e_float("1.2462026007790964674118288381739506981512487013704432497434649347661642595061269266103804962443426349046131840265065133930364318857858035118148721952309369144863236605997603783488650602644742447770756575941711553617649652579930085037187721611308728765928274117255816957846968226993136868578018158440872744023717819294267112414874181604562467456635025828761863241839459376748696115484835283658799880155e27"),
           e_float("1.6019021177993315086413780170865439136748937622643520094538243442188492722736493955848018690403199178005351003089951079043497532752297199373369865268307927702443108947739105159351785715708205962048138518571579750109055104437057443407273967143956923610883045439969178268797472613067145998925204764301498263222506618948110214838397447514670314458489862544706623844335231243525091728839073732510748402721e16"),
           e_float("8.4233578331132474900544513750050288937106909274638118256919136955612882898239509916566872253863959756813461249328571337726158914549870567847661097215473381540625552715437217546193940974721205571291909188021139842301177245348332186652369463955171731723497887146942454771667211254902262310454936210941271321537624107853138513748273559541606116280395790240851597971923389020615817785698523992795966343303e12"),
           e_float("4.1265221996470738610981901246245205695229234715889814273323808820731322534226028000386220816511952998390420734975831930694667742798229615221428736304033748881051287990998921889758590697148755716824391832988878335628755058127295956625997438508157400131928559461705406243671212714739523151620578763785676158814550160035559233271137124237398848842105959667376179554743308455995996531896078747498571972139e11"),
           e_float("6.4908056404611554209997655266608051589249834016032235775678706878669923889838695255855798410294639876481997838878216426364114436702805520631358963871743430420905034862185155071660469016838081737580619534673869261679802651104326327178400520659499032267173456895951871392949521947720906695015142195757302566320216969625056962754616999559889520245010127096570943727554526527012971815969314409368579459057e13"),
           e_float("1.0396176031950942605477255925533000992387806455624478660434152821517262598299258525107814000159470071822866500192630462209559530698973393468050095969732619025610375544452637959821783907305653508674551799219014703461574063813014076065935221679881445784638797276755646660995797189530577799399905328477402173816254053108520618071813504335175244051495052789779361634159245949357863124069849141729075257219e18"),
           e_float("2.7494395962961330527923264531454556731016073388803420826645124579830954046816574726456966193257075529845229445192052916059452553193863364504052890272687827722604077691102886776496320863631070205178284335646700452059286163976581834589511443818993975705461625938987970297621715904083000175813864529174552267707593948901078095574345493754778926562673069740072469849081483168748686264570613051580661598858e25"),
           e_float("9.3074936499857218491436051025842071168948908015692234385944729018255479171785823132672795118824092835446557387358692662487849349780200068096085832617261194967013390264245015269789784559511134163596031283670731856893114793143286280367341770949942186505668800453202612339376924194489179570747975302610950345541744468849541736842218263747906996105703961241497585413721281914065967369309899188774196742566e15"),
           e_float("6.2912652318089588384117054425483242835303469806110744389866430458463199220624446776438144116697448036724880903826020445337808283816155089934300270301449078644631382630857464580805580639686731270678673802903950025786223945452333961493506482815958017447894918069808667235680810677826806770710608003790901798176559945308797676614173337525190971090976902298852107688884787848601446767502595840871499547052e12"),
           e_float("4.8130146886521731899257909399236924536753251963445982068685340964263730817997363872955508663914728354524857468105057811182286519773753874898870479124460710987164596628127571759140515748450215407713799375012097114686199523471368225404768515721893593763880865735701397848055292228452731641182581084426859981836333062442201282180948102114075386113482022542712887499719025499679799019369584865409550111222e11"),
           e_float("9.2680038390920691149833112927415759114308130248359323557800708344799036104607738065891407714918396147470407632665088575909333815355948035280244608810149422500251716809308454120487592443608713695349582383268817535821486170742281052190533338867878385122786934676171639925413814700511785718417552633440237847868948552893441179577434220296416156302090572039869204260315440747835107536052206084352478276044e13"),
           e_float("2.3448289508116293118320272403993034134579846876372442143783280650090003111556431963261477326739655005124141698575566660721340279894905189018920980354341879614320598808728766452188309851026423221349818509069933714173097503285372918932093003612312950741684586890598836106962817141738776245221790425720682169867492863304055344543224781775252635998611120002920502814569533879956987919822971721890697107905e18"),
           e_float("1.5286206170333235421664423760890780397566866251997362518496874116362269025173786464336412260572432807465593236503349015639838954295602412146583249495133715396596588380162179859310794669003994269020361344072363073528687263577342658273077323800293482694616081868008049704567880216320738154992742238155360366893895677458871010357939001659268121999269714560759996702212033718901741145241138040195025894414e24"),
           e_float("5.5365411384629411769144116168551249714697874873464791660453753051500816848610676122021319954553750208866293244536119479604930282087784930406624523785127596372308886849689186010490360938624904214883759311634235448932643966370316325098498004831278220245181658839678371090953886934736627862978505679630065103547477991092183944634870574329608967899976593401117163323084325078750773894270979974085877461133e15"),
           e_float("4.7332097682649700934237930287511575451795994303419830392035275560402864140425974459782294691392430525498939785599439546929721726263465808732088445198517838473186324394841949564365706554031209154653048056986907001998288111967069878680473839746842420839876182794119625792553711918915231219479508586994577641716233542238458559499711342005339294127907037469260621879609996453888685077905621722801839172851e12"),
           e_float("5.7673081802854543592101891248329270397645854320980089040418418880386106969526829933386359170149262593934619063886210895784740335491777907761872147851578152544392632530707723897535585978166423387508335171255498771624570152164587785276550228502559068692271229872255575873109691957818487059544890127520655015380181689449081445138669748170074844594872113840471919474234292673494476508492436889671966210844e11"),
           e_float("1.3378571187042243622181331234304304755182285967722994123153448547400108150208306965559426473400600089780856326454915869711365552601426158529725795505005175343569717287839530071223923034656952020615310010108236626348343280901875316678730231484076478685010252894536032104534447308781338463479061266097802234970750830897655859213476249297231134732925658404600221559831721271524625795960026341597026826082e14"),
           e_float("5.6110386750018865865452771476963824865913347425902931283368758496825795446453530386175970411681371983013622017099377327427790348786304465949326587034807628391073652916076279239181676337962351604810294173194334644305761690573551509348543802534835564581531468430815532754195508853841356905342315405893768162353436842061963344852211052826305551778422673004134059459847494719316820878166439336091598773124e18"),
           e_float("1.4916459235215741763989222851660288461345293801334833084110445405738407650889344258988073085735795688507409749120268072053276665367794069164797566333279663449428238941180679278465091725363497356202839398022602475895235953118914642867649030983426225779091028430098130188934893661950767743921287628228034284305294051075100986453832373566156783924597921985481847666665115276862861221488524309321412941682e23"),
           e_float("3.3651614636745237853988140508608176219631883897750052561789929361524212180231187433476421150702895890418777856554970567722597582114522799286719785879096728303314521806551295003446995020369882180099306718709792958619809141532320353808437205701521079899086782471191257144970757614756517006841093895139325998651677143399306959207667650693539661553220145932443160046727263303080814036341536846420866085032e15"),
           e_float("3.5865465304767419714298325870400234339675290418919209661615572216865193951901272141240309000077806766351609758183668126717228539875370861333830644579030244862334793751780925375603485232255068415240567190397853316251957028697406204584351672632183899716853241382736711839984388887205604717547346557997116795251402901860648712479591969570320978850341583163442143137637727788730718398592637753542942750717e12"),
           e_float("7.0575544016984508531707968668676395412880921706938105993671114118278718147149578842921934050246229799662971998771495847824504934750641143415670076586686148837353549071843268365935669592164751949663571899543379912976701377379364009392044245706213331051608412068461853902030159097663082200427176516023558404817541745939538842429757612463079507574372597355430811254586744956269452188942120040275568279159e11"),
           e_float("1.9537397683290916406933251801324308278833557949685819257024123605167828945451505886911636165461546809716079334283838549784514238222629541714394109956583004010448908113451500662412538147834602437849842659796727627125981126789354693663817626553263035778294555367959298609682296404582757791264519467281587603644325847123428439694655019642083125524295816916259696903196081972426042168392150194076052054889e14"),
           e_float("1.4378158320583407539974177279713591879647680713970815780856755035201382233314549636713929306099345277660816740979778756413820911065887630624720293872194343446870099328263265642312612610750830124295504063731336687329923187836187381542136678363868562421928965589111932859256377180973550917262348519869275375522908534894262863913782737301449358923459465606807475423538636841913088683131133866691911104596e19"),
           e_float("2.1259090759895170272356372675881995502085861140953168410963200771654053410903028006938326503476796372390039832286629513607902006610707725818007512439738794186285463942578430260523203904482317750746355438073693094954815005997897568408005154232187945342825886344889759039344459812017262618591368219366567278228316242159715015450210603349336206447617928193993228031931962606562984960608371891677895743142e22"),
           e_float("2.0863577972392796566228332644759491587282541398691151330447936573445103968753161583638964582991844324412005836344432807832078743240751452506612557578242781809043184003973026894725216586002980408628579133677819555682421652048446312255031058755931958029927421797290484505361970842974095674448908957113173964565473804813113020143140128097194807167430656296510091998121335294612717466337950283273440049588e15"),
           e_float("2.7370906860900922352149972188791017087622231627569022675417195404401172548335011564296606192942707694601823138500611965147622120892536839943918778017021662118876295139701520125967381765231218316595261536823906087432097764363757072101007636102869164567889696227633844752168205052117840447012200836681826516755462111109155969596824573534303287665557791226828175389403936642714581725385253004121221875487e12"),
           e_float("8.7785922868127683075467260179974309291889712382679789323968064274956063212767341291204280437713462206224814115373622189075454186246340168096286320300052175811370110086710645414093047831867984320360823069211569438516672303645619127349362886154898065915877313853107916386079023320306268263536878572960891956831432900928454123280848653608163981471819657316527565959247017021002715372516912472757454295054e11"),
           e_float("2.8885796618472707378789487610658861313153648945477719960739839116029954383724780019613476152149553682193907876176470589321751958122597298640389365964311567728065212007146430208851382115868058470579150123893732767870223858516496732431967372254005007776958002719983562136231805204224735926445574780744141370917104333517327111793160742642327606060938527463074357275851202906187171370958158852436349843215e14"),
           e_float("3.9916800000012724201772711720236076247420233960670489613249787624066805884629457473425769891714030818636178692083359873069026131700681882140580811506469221153262750800309599357386255605893763756837022681228701581481292307117690943612050064420892987045503833582957160338982234054662162837637875862488843765902681876056319881507527116157208293963359270131733549500615185589897515657562498070333534750178e19"),
           e_float("6.4518183324464295138059392448194501473738035067838832220159605535290685698219148487077303421469913609135576227693706025739677057569959215346049782516633367521785493477956512155347523603236715499836599660062176654386943271897521937774089268323184720337667724081934177317021357622416209272796245188933730098830280123318217632003398892018818827621422894823562900053966926414423432531784060355112134338595e-14"),
           e_float("3.0446193486178878206370278855447237527649995933281164164560594924376029246566463009830669508938818822471599633436919334151995755984286546226609841569948336318024584830971593365272207791403146496490242702282547107782874835391142031842580559090241041550321734809161573358703084889596269246924470693471643827011612697813747452948161032149839604156419984099662391031319131136780681428502452840095537224048e-17"),
           e_float("3.4796179197078753952371063403475576848509896266883616290683332246244926188644174234184674933666385487123461993717781762605859688728965509659969862862123035963572907019840022129208192176522002562674897927264222266640623951621837949491679777430403235773126872232754959997086032001943928821561149449926989829500763320023465332180963576606662999588016365427634663620419170147967372353061953427786749347484e-19"),
           e_float("1.4611537308055657283961026647001271400520243525349212817072091557532248247689426459791091900623854157319167833480561519258506272134683591249003067705201414968202492528349204913104895665742357582353797864935484153593343937114398429880690911061714531388070235869764728834525976676061214156006227298864018646350670002621744950770095358604946928361676204730854559384208780477154952780651268324137917589298e-20"),
           e_float("1.2507675804232841037797316403018958188166624272598637527653775806455521706872855866983181484150836940050963456265285131543038888787683592734573017897502489714331124303629807444854879312337158741848774349051044966547490581045276574757374581455147711612045562308413308567043536932531217945048590164562806635832978475217509055624674888933271786948779205799409116260903486467793509323434251292878036246526e-21"),
           e_float("1.6794821168442994507280651475620788398237201996420945815043083279009437377726239269730486719229218946466770229413795249261660197684311939832189899431690383184035658595161874544781504604846067234919725262842393298288563464769483991815894241834833079095194993133990382442716963117058052756195394089095798354544365995628560832346647803284173814091331705485002627077957244380404353564330481477272369016859e-22"),
           e_float("3.0763825574381453880091468958941856446002075851088551766560524752832450128372739054997746500929728843744439917252053863318110649657266051620844239207128571780688155450677578612888900081862900584163907293855140880791604515610376930566983113528566376567675044774986610537477957042663896194305646003399840480524669274414286028171420218920973548185287816137640264147225079070732714299517307592873126474438e-23"),
           e_float("7.0727494710626032163155761381189025494205021163171332073680621931024121656560247351111626275822264522671509701150462313994396198862606833642470084189106803771560661531998266485933101245636884358794178084185891885962903434734551555013617022363203924462351200082381261705268051961801434157726319753754297535030000242471489852059940184899217046345658692195609966678707496689764373546195355260821170453483e-24"),
           e_float("1.9341484237997789987038352342101605992601245249473644162519082400637352792940555864790090979113739623452695947517653646584779263897195786871653449155006834813622494893144038097825670942497965433063852677542032591631936666597873590338915753011491049366730809300647469977064822772927983628050792125337435992334236160533161105413030365602333130196427108648692287397844719211191261264430287828813825339157e-24"),
           e_float("6.0648585497158881088016698583192420485472720269563801105561592480232984534207536749645838641942391337183418722642216386082828336081300334479448418937946389686390130978018460668074135998410705037979618715161984107179087165663188107222438828133425361063478173061604597067260078643433774552188203420255104305832752565550134816909772635314930196338012025296105715223359603695324144969063168303402819337667e-25"),
           e_float("2.1243474169316853788322447742080985952452521213371012352796838222744303610508171115996144567202640801644671354521381047248736116983313677824793327943126519122237723248525514613699242770335992014132356691272227665904863535331836043658256058953097719557810652296318418066115200770803004436757973456249121078837290535357580716904824834523386675609849380327610496058764727300109791619763226173770865406321e-25"),
           e_float("8.1530788961145213275069868913254052112938684262140515972354069567166115221011294244924148603510611010982571009835573491198175050342318935066582962459006613718413328859893616677950675305437528954568895268677246721480027730903926344638489116253304104135316203623777398347006274260738700058465570647408085995195976284898964749026152537265686939111147361313898137370060385012878144411934936259473383782308e-26"),
           e_float("3.3786565357978439908216137004834062146027742314940689461449005997000217459515649812735542541918515559332926252170283715893066447259389113213907251858813919744117167485475230639398849536884381420365307478927740202957453594750615413777888404514687709085565070893046681449031663858028305902442037939917338462802947681501218072815352876594228902749631620334445471701218430546820736955890570032906725969584e-26"),
           e_float("1.4946717946644418379912502188023676116971009423947466747507518004543498031584301676739088100860124319316787702808949005124324271041481115707775707151930515633486480348496754287094319739512897845713831172218052643188753575509674823089694321692458236125315586732611338359726600007588005726378972850930083253949973423724639256917704955749352357592695309997651299969567076767382416872474543282893084597121e-26"),
           e_float("6.9952927407063158772133895119211712563749616011403004661616085023858908666041237886506135326124779206118720989647525958448913851035732437967964845504066783708874094211011143403017033214973224840043620517615734845370231484312644940666623634835936624466235301602150917138411389659173866314592195952895201318382138555737063211705616487073693944509119821044205323760969870956842616050354107461130594392038e-27"),
           e_float("3.4384561304591613368801525311736003588239446904098041706899604625111990094171740882141000492492410638615881756516478933148076139936885777798249212456311824368751337718379271466618921754135876822470412980869336876595032483457335272829724271257782368800796670452507085642491023419442992041947149845664733607823200667237549740003675058559216057503177543125767320965151487293831848846824381756900782590203e-27"),
           e_float("1.7645484068714853008672712535822591719086580116105210937580259817449241862419416491991474296251660696086400840934754748964722899123658724243970672702338491239506117486813499312053961174239434140957994206799199012665607958387138765906712810626778567789601114292431792407016956441589721051208704048256586116747305514479852885474845479188296684109960499089257875309791728384104987900019848601686881961611e-27"),
           e_float("9.4075158282057390162377043727063635003304878023194496627315322729910194472681869910478444495005623968705370592906026189563471986174132808399544785738071538831962366195405798990393351984325149312330664379464505472801183245294212302580118121448634794666639018454787874950025760344986242817470544580905110022141793200174150992582861340273346194451488008986336676351213289437409569991393659225942891291188e-28"),
           e_float("5.1891250642680909382573185992657258916249464781165024535585425559727153317828827283812987478984121488418584525499322405551886391667581964304879489168183661412779780884984027561195789971316064741513262191516529614182666820459256672814599510775068696820955364998147337425796781563751720962149243760646011706387442150434492212923774775634706157170640659727682247710120063945955324785138557274838408104101e-28"),
           e_float("2.9510318692640866248031121330424028640516346735592081259443820293695937135312528796627697280189178768621561538516716098475854507427428462413517059579649561224195250687531704879601794919349358682969378195918783117097153251619430346388765325803277828749402116572885318051184090778346356384829416503485372896799165013154911191703368183848886191644677078290289090771160497093188390863264801670594476764535e-28"),
           e_float("1.725120025482286335395184841762747396888287473160704499555513474862095670606369803057727595184213090064840115777393032427386548128135106602598422562706853344296885722202493471333065128135924289171961732815634982099529707221622019216868983883923030912750625843211681088329488282268143054590007202081439292932893158162653570489317724472192212952555383511932218879917419284159021472490615734697264633481e-28"),
           e_float("1.0339900114426524426703017135448631364657616930489546994743719726724690530003965499383843278958250584687234030016177273577151807719742372498007833489193657352258472515146105836074727704691111548374861170740568944004135762589633898661821008063063466617976254004008373373550304976128387038890412588405655447087174150011093650809208626276374639841089634105510390883404224619434593579444101026805087822917e-28"),
           e_float("6.3401512898413853090667787622514193745647230522348691963283276525012020138028455745557025124943162960600922587674821705393114267775310246132696047798632695108045429150064176253861909050182978851283924300389497268014519750956310357546310513910414357240382592260386434536935303627213459803745909876426544224442154217390188838410024356230748722660475446131877003022218058340040459895916460636738483249638e-29"),
           e_float("3.9694208019816156848222546726870142410448262038215342343597195193221554656390781135165295630734567520778141001590969111555066417237234439385558461650729580378006838692673526919487924423158970431478187433087626675105862106295789487949508952655733754322541632662576434137669380508007349451047406897188143878378469661142504941381168443957106293355162564949800369783302658916319683384676353833069802434366e-29"),
           e_float("2.5331452094152467461363843972042611135317661609572771465096301000591529674529889292247588279503242892827992365313202947595462791587045074818358011893041395177302702207203507827617393612555317906902010082687381666745418087285838583129528605933209562939780052843637997443649201441117079039097331843693511662213020981990753806415472659339561478283255502951615698458732282909248067327795795411719881211027e-29"),
           e_float("1.6453057899134288584180089331518361447847247689106765087050920975975270088673512129130267494857765108965380856217232730005473106290588693994340485998651172968413017361098847228940735297442426809406583791539887828394964566568144853475162908213445694818895288612852334633394297109956661251912053561088208605299234895783854754234283537731838790517290372341012934542642158636374370299742367994652774761132e-29"),
           e_float("1.0861974515200723044881305649631109721490929436958222799873023704758883804579337496936055390449665646321516511065866211726458156037651640394326974809440384115560768330691910659928678285015005960150766762534366067299153544365261867811786343898261248659412611257567803391582891207706252704587525810448682847928365036169865211529243507379732198029075549427945638529649782078995119114033298822895784887414e-29"),
           e_float("7.2800047183910360883090584732106483561388968991670721829098374695051970239281717130972388535530305261853321161382733194923238481429076682565186097860758543932398270430685418670891969339762140429804700702485740493450091043746913117302850702725012703234055195756897579143624019526463619532102662587962521004948035431740098315494154505878596330932370887411581716737332452709041849281867457691800019035465e-30"),
           e_float("4.9482840111526073907400736572486049905905404052482046460475471017905560429033589154367561579600942466312101046638417108376539983689970439591496045728607693235899069879334674530332933426482079012471347057886879001101363876654980562635942681728626750404901490787988845234760016560565388019409321672457100854002744290600035625110894122541694498737401299371866391772395456996965344734669038791136362361988e-30"),
           e_float("3.407719784624050922861833849964862921299151087362949144938015138462362703160498622299799887155046722994740339968490550247839675297051967717266842376193340177180276323144197210603060503963018967525696320307032561371918603114782739780709365629344232619489519328606879916149458510304113710284349989807664953525461779511105091054729605030701877233244963002170054736236046657495492715212009550689417196128e-30"),
           e_float("2.3756714544530183486031689044766662143421871463272226982634457259765753583351527122295213103477034982319738776222285125790090751042997276815179054982055169636581860875294082823501764838293786159245017551333192798656004446369966641313481561131247907846631520168058092558933234948297474446333574199022663536246160319013163125551456973554512605597922652809599381061740623642550454121456681517861662807535e-30"),
           e_float("1.675269278746362793753630960453624294723889981376465359893008471364489123035800457739330079026867325669896201089590450561619392551733141489737634144260955354382354003716594483296795966854077263791989565219123518751619860798367361748115678638562441793757672386514101885026115624613599410941541609326737848228933143148242576048734107656041999130323939836437515180140662100524291526455386841185078363984e-30"),
           e_float("1.194131835839350355618079757097024925788589590185519008955722367699385954635469265234344423670670040091940848758245963847633477252558714125013237058796149866765532440903995354720603264026578168423374844928652455062364411690791064655992307276061530788095635080507615010791469320240784214309094999738321924338009206708856942221313668965636177712951363309999890827388618152065818512427612216368973460721e-30"),
           e_float("8.5982575401331127888945459492220162526985783338969983281762173349366245887615990241299636779758703085156246777494883901878367379288714440246061912255317378316171710685166498342003662435139535814305371035837381265863381708549104644526060955158587021038366664972121439555471572258935304227780398364403385848916376525159706988626986284516654976386697474445931562599480468229776003355745572343692162534129e-31"),
           e_float("6.2503525825413783903420169714814854455072818378226194987023466956106165496298308426417160461971870709972171857975900923188761547703325499582060575715312761544181054281376736145391039394091406011100053173591927697536545680555243399467201776838020366267207774745275518470286689599737651059090187325821297789164105001005739975611156154459815784825641998115020336058135868821749964866642543254122981097673e-31"),
           e_float("4.584599276924258197495822975677096955563334893386520269198597364626761504797121597986425654809421463562775427420331656595130035454315086900274278796711902112710082355052342655807579035638273377227294090344848727440872659270746135717013365623422279764844962012996756172953846272272560989901469484604805210867213180948211757275961274845961370802748949230871156476844772677603271869940350092671489900426e-31"),
           e_float("3.3914632369539543738610064004960285634365003318785742108145193545207406832509283033698276214791476961562287987985263993877102897807141460583852765966314163061632866997709896411338297483360178641860246113350892220754209127797360213313572915879488788815696259074006718796513792939558848853926727747746440523263577300271955732699083311439260395519348057373203873268009876427501567905059916426566583767378e-31"),
           e_float("2.5290936095067519610138546685195433133701950768859342664822102809780589171643578486686200373217911063991111657115830879152887941170041617984468610293466619498665575088926801126043276741362169115977123555041628616096078735034643927787588785330410080666610006057503168946965336814174920699688646024820525406182080319576971546069319268121546472178760084049628385582502368396216669333668613696500223729629e-31"),
           e_float("1.9004361635163092991119699691935418387467954250442794605255069054001307537239411759406829119604568291183847426772523209946615718418473292164897103163172232290414414641240538299289964482394242041932221704801942495204280817454721660389340454138304411590352275542022262683866778339150304567779241983545237553432945642368248510424479725228806728263206777248128694549631719761709413749733137307342039460011e-31"),
           e_float("1.4384162470567123656841754725262535895575793507498022200644839058298074224487508210164758113512453660163346761727743644625707540483163150761776246654239315930274922090420251601988438537345094435018745671728589256976610942034816332501089463078593743880180488532307324569712846365059341977512572650164030290282447060493220257741731080064826658132677238619469775696060116153988091635614162437742469688071e-31"),
           e_float("1.0962346656056826606896531202152836388642663412671479073157045864047764837517228027735415676837697472758748223644695840249790598717252765655422609433404427299291493433248354194507522908410486324529465128444342926021663748496434884277722062062634448583532222522526320767962289246109350406603213866319830977117950087557312446983412023097574482919896012141000131040706624483833905209823271901869284021891e-31"),
           e_float("8.4094213631785982305778900360454009822287305385268532873188024203313860645367220545520179173214939540564311432374728881793172676097948811593677008298014923644565831534306023777278913479494447908441963745146759127525795318163980671028603794195283184543521467289170622276353817657825556807610723950740616982788156828315340207302534936446770870300323622121339283188489980605146231704045117938184019471189e-32"),
           e_float("6.4914014797896027011792773838254930714881233705072401079147752076384136980238059585384725653532330577292173436768983192212968018845640004813998314808510364619777519940129265480508949693365890814276003303282329000828759308394139045429894560036649627612295448609064625419414621343145067488577685268446237978843800613889783332495771463552939483777006175514384136115819285780625210752974646795742548631813e-32"),
           e_float("5.0407595097456165419042447784700427603748680488060104961007941251862188321867772211435305913882486736762681873778289279444986339645718939348166683319900514852443287212791576295105343430765122958259850202198667164405166888053667219024466806025306861591854572749635842822350414524187609471807442203156896809957642506513390037900985857761296063481209838599070510068539588748536987073820381055480123516152e-32"),
           e_float("3.936610254671677477603402319232829069332358789300056742035976477961576559663560417532581013607883577482205815118203022082738903478942941551103042180520359386456139402652272201137899398392404924311946098088391182401274310648352082097168986520529602633647524488369206893779945106437168963556055249709497613465958479843526681242617233086809511041926641405373049201239863288181838274458733882866384546265e-32"),
           e_float("3.0910728536331512014279407600014181924828779198902557306055365077149965237018795728491623611168483200710892657384155493661874645204840065216901711338566189583792409556942910161808512227383753089219369451715468163461594661008083278163792926370435348936274428794362973969038928744052999751409308596982429584815934150024368555319834286864871652803583409694369258315939726610473300883497421354361047283348e-32"),
           e_float("2.4398037552047984186585332118483500089335936292537535344023329931761595107285678661503129709940206641509205140961051359600261176587007944973977512366896541067886483384217512795076863193957698677917578534946374074414846004591936995002980239170858931156941770000943175988723076765291811036720880576947982851376661697445591576951837084034908548940311463895027666497626580757666957695538332178259725806227e-32"),
           e_float("1.9353710935284306319083856484288208674707592666855534406296966492422018212864789383605111708370631745371264725066108563970870267077313222204012481001970798335792517453156331126917936006291285277396303101640786727642736645556222490047497050822301730876022018852468752584525958484576117129813027324307653179503853420726388361433454703250973581212528069584033388213097610197579310670532524737162704597145e-32"),
           e_float("1.5425812892903432577574136634783199463006871212314794415278489062106317959513073951967417264325217357637663626120112391006282137316219161057637868930344360244707541595923789092168581304255053868308617937401254797915240186868435626881468756915603518625665762719331673249999195277345236218680241849206754858919960673160483864738785908720771901473345596406834073617535784997446999231048341364750163197724e-32"),
           e_float("1.235157918330846595223010311699228239258004695061715260629168435329263183728336462824108611595520998353013199353498751664424926573385658957471480039286865016711355385536575957506126862927024627707968499544561127468729572934453250458672846043787645125085142412701056244346115098590331051883201940776295915188033531550909268545346166912499336410677453527275876093047027319197310450155509725822548062658e-32"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00308_polygamma_fixed_n(const bool b_write_output)
    {
      return TestCase_case_00308_polygamma_fixed_n().execute(b_write_output);
    }
  }
}
