
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00307_polygamma : public TestCaseReal
    {
    public:
      TestCase_case_00307_polygamma() { }
      virtual ~TestCase_case_00307_polygamma() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00307_polygamma");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::poly_gamma(10 * k, (10 * k) + ef::pi());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.97721330794200673329206948640618234364083460999432563800952328653181059247771413173020756543629287343557694737251165998145915675079849161639941933262971545599819065711339215682791425102849671568380367151347054388268505800932590709342140009421579393210686479781218746950810342120205489943712476027052343660998684280843351874493690756277289908417670980234462579225321368100372490924822595425966135403576"),
           e_float("-3.3842334268995620990445868855091053293967329191638743326746217778170569522425491059708957257624347064530218924703456653789480178487192175991100622910931907774958611977076648261165394492426743829524247554996429089647041286341381211213726660260419156946665753007939832813749000572021158602125433226412041145653277746512949444482764598655366133849169203678671874386002100494271722936808756872718865325871e-6"),
           e_float("-9.3820824988042663845765355035235488587426264952411503808027182432307661239062269586904597239836184333570309575371819396823679705481978834894238786084811170040858492107378663200788883564876577791593927364395889257698135083475337226130649546928406645306137340011643133432019534079273043382277591262253645710850921422742217696859685686303393678380750981271849836341100594937830532952602630071956307421432e-11"),
           e_float("-3.2943482179158447776420148934340281171561530669714205812139333821772793730504261001009103412816900416906394939036849011462862610711368493591930229690231065786378880226860538566416918287770326731310107763291501569090830918874005260580099004298370149365902568729799256667953353816855997566553000367050586383899865661921590584550423112299880955774833164127943433264914854631192012084189263886884282727122e-15"),
           e_float("-1.2591863448460993317302031695298307389881218535781935964696737510202799371635297617651594834844237302646741317657190508949462883717967082660248333663888691706173116513119874070308916257631262424572059799045126375888198861457275506397466262501056762610958199779421450016192090876519439538024952350923810016416814868745590621044468999315274018925898702646445228123569058279661262750291911109666748669954e-19"),
           e_float("-5.0253102134951980372708695139793873550282143410726952855570748890867683780411087108421179901177622328645222819217834945833907701676689728800913175270586144808555619984776302661818005085134786156702327766734401985981324267892888445416793323502887808134315248939634708485612618336808315227098370275829146249479832514920372303484326806580733228922021497004776988064344386978435052928005648067025584390684e-24"),
           e_float("-2.0584334080500908297094879797980268977463699931320819339182798026536583495638832736124377266797301280344757967473397426881497310624545381757972239884370272247961112435388161474792435060232239642851336711480868591844045303668333918339573603138467996784902875240018358961309011978908384082713652381060484573409784295987914479703639712553329796560242298512724799115273396811391368606127229492686301220008e-28"),
           e_float("-8.5791886151281274457363409333826202455208196182538096442510637741390885011010200345535107719911251617033889903392314817089781838968096632373403895881551267316229381406430206046625353599096855721265990641943469351247189992237295507169801417005020909579599539066238408758919245452339195357396313901750444149377474288568441892676763460842921039411895384940878549082015311470798854026143208384117577145094e-33"),
           e_float("-3.6201870108725962147983830327527944513524364411535373318683394164944484153006387126980443753599973627335097922912494462983545902157081456849288745745257080050289745028207810461510095224941513604425114277004978078217141246262172353688398408194420504988080710648479219529211803473678241434887249115668635478677900531330224355407016201654768822856249757571771215105165882266373812140802554303382560492017e-37"),
           e_float("-1.5418423971647607659920849530791888526500067430430641087053716271347388217509519296717146322283081119186690374980384422562506806263825483288213287759111862366456063648884947998078416143868827462179229920430747481974754401850634736456899269082177023718903927164178004912890608169775805989679358687565937726753247774023315990503581264441325883227326793467540363715030570041607008655294442836663097141558e-41"),
           e_float("-6.6141311120949395940855773286241434953579716431879398755788934357919076532263869223964890670146994761896915437139909737195846078368295604095184893425401574478860381463412832355565602465795626074736718160675140223818785700452383890759268366679030085140810162178693236286250385671280123326756624404946508375746627675366060751046094464929923721295360351482164136143047878216726236803881271535443848987809e-46"),
           e_float("-2.8536449412336661505313641160711040090464089409419457155267762088424066600078510125329499870972250996016426200642558471785472264538629698202030810688782887033372641708967884725751707974665949399705357535361465754201098259989441291451913784454087825591578903038263315595019079556698054382119729714712453962543610976608858900846444065571003821507572365025283358963280934744994283134504158796146645868721e-50"),
           e_float("-1.2369843980843241177729474325842120615389425587340151393902100247066705731839397984698440159485079791078345026729681538599043044454359701089002347262332517507273291597954445604691840700610534239823695329164819920446766004906663144555291138162775549124630267379149839631722323083461233310696928270603427112024571099476336011707149352267198190279806423716139862054756061626939694081170194117493249951478e-54"),
           e_float("-5.3829867608908169618845875784161563282814801367341955699532473429545968575307986566344226036951258555340230801925533775997079741621607684850791996304883165526848548226713431547214842562540742644723412629009870576839406939209696523305494182796782137576658586009865615578440807570291434933645504044068098693929727659237023686259734518724541616793593857743444271368442234372510731193428937737794160481945e-59"),
           e_float("-2.3502511488788958050637543243153167165912190723301553818098198591865715265593911497786278962857242667609722075423928197188433260230228152570932171355971006150578029148101813888253670358333253573555850405772904923226295983047782466619426238546841523289056541588996256689410031703782274481032328814080023391850895737180609920740451382890987869733075961767193886283247504895415020265267037866131704202451e-63"),
           e_float("-1.0290366286172480335398444576008317641124501325979463481889801879083150994822052645285000966178061195966150231122043841004039744872952749136260177756832246856674717616251640709835430812356901437671241101350624986118038707697076519750527851873549957398001366673243634385844394691586476316279254778213088036039196094193568066412655722207518086187853477019443091802766648689954697970785846191680133035778e-67"),
           e_float("-4.516564471760073358177557058399159606661213471112566615833361396037721630686425848961998144790783504388267998091051916621242815988718958650135939190762583113388118851269495402520981017837040998410766594694210507908731177702501637095323086108679348547102592571618545085774554421107891471907107790048222508309054408763618485211827096165507574373572883098079413928324992177040396896202803488535159941253e-72"),
           e_float("-1.9866104589945357897929833405435520418197234556537158048331638905160415589594035005574332460046050179450888753041368661136734581804526323153673858952035216163674485578274297290568347093335433049780284721141257702981347608936985036203011395770403086485157684918892150379460036444161719211362784634178018777027280975126196344086412172381814577317830299391220314467408505523528836196928223764667562772796e-76"),
           e_float("-8.7545612506273948648397306828593670079817015359583750130809728271197014681309985869682589896591397576301339521335279135409206702082652335787594952458464721495168513524147373258454054680728603694337157328441234450793934427769083749311211752635609979635349308968892486398946172189913985478396613630986593664727134959570172127603286166569668289020404003824609488382418508939367211741962229519926623018489e-81"),
           e_float("-3.864396659167961938832321869973193868537548409735401303538484839771488257127732620507468129541031933012714524090866741939385313545560258208800853270274849060290430887828821946977084829836801796341870086056517279686498248731284408774319923547661467956530821143646572044707124936619646912115222708069451166484102607463089923957673809508330144827387297552546875953916851176668940132802269660357768234926e-85"),
           e_float("-1.708353234774717354264594686576771963682853569938871256285161995048893159058612661593641060594080741323236979696074328839338091867865916926202283144852440017771214574481578538014713158140251250377970288072534504284460288676507049202622281006330335324259482377468639981606180975948167415034478352420724798804004804930662580532489051691543981448511395568280368046210942358252923180764807296875017426416e-89"),
           e_float("-7.5623531106865357570802870030148724536972811124071199471988106088922400364034410418913003801410266059700111344061586826047719928632047706761366691521834758574623930821560018506581873563185118862309638155349194742652594840594917228237828661868448747358353877757093591696954870687910773678530188746058508314274794272570535865780442150919097065310580061877294980353517457476978198668078074076402886811345e-94"),
           e_float("-3.3516878352914932906154222950555111509845732552167671806253120818065566414022539277896655067667557903316909882970002547014749761563899618435910813321467156718138440748865123350941801302116049716676396847570524121397606564227368174463396527137207615951801890963520938843891853412266797914347058040994455106269696226274566313416906356077175917598452632037736851906421904930705172867170590365498962927237e-98"),
           e_float("-1.4871309678249758438311015114893407156193185743413246117082699861372120980068077681508233748206445802018760177174271797123698064471300059526102032150304269045220229696254794558299112716869772592650192607648383138787338651366830704431269693808110102870527293086402706841378957836173773884777594813024914527326884900957727360452476995638384727949660445266950546318173895940596181271848951742803017403235e-102"),
           e_float("-6.6049869092431277997369256117719288427832783284893700423561528105094805960295880224620829397788144042672141369538787547110735405518005098801221763231180316571208536382101758001810929865924000719636942654281608121835627046652575686393662626178794678897336758110481014204152985986693318011184397702192308950559909947436045521127058164707815870757362983710546692239643017991428276788401385466103967625716e-107"),
           e_float("-2.9362641044101634169994907824524639821395006354029076798950225083068750084018081598904900435806554768895669317201832432766492554826107499105092598157397514653484053926886096781342885440140793416374023511807927986736254764445896954880577711041492997901981560593864622686365800348346359579389008163178347397465820940873923716847420107530664032953443272794367293168105916123433638872505375608122136843267e-111"),
           e_float("-1.3064308584158397460382589768691631911009200820015954370680570532511517247959235629261169365275790290594575644408707897252992508503315529492997788145453765666705823058343902923534064632175469194815127551393519040797728677963064764405732863226791484920294857121582982822789895233490985290259223290246507939182441296665422824407289342700450598851876780108906426760654042588654510681344629995162110372933e-115"),
           e_float("-5.8172455315349566492661208777106294601414573821754523551699981366231864265209862792661686702257417480855319056471214052263813023789719865492594539937656710508852761444042989176779783243175304434792890979447794220416526519758087614710189181318523499293569282631302316931923798408571938720948699194025398402745964115300251247689691484873788107351377133084681141826788776981190554173634649620565450005954e-120"),
           e_float("-2.5921652629752497535932621738245243406101624463987108943830946908064559945820568289270704996612342951641130894354372296637955565153727491011247076821812357245889160050720308003740211124155189640900135188853636777225687721771870733965698478915285003712193427816460667008835364436554336153551948932976420160312718227260245264389216643965851189465412822173917604140065528579763434684395392428694280772578e-124"),
           e_float("-1.1558452970267613155519294618908695716352686640040951151955334025240746692356892993838072776018870117677059642498027303658508586264413313195073875668157823652769084138782343514996502539766836550450192188649443165215353721544441000487861395441174785854370043606798426401881386525673357660297176456105286260225329749603696140764849790276224322796883519260276214259996781011336916001542153488361213916778e-128"),
           e_float("-5.1571316873576914908214964644639954900560512556249731710634713724869234248778833680066585314410415418297946866696371378440534199203346783809393505867726738247834504372165203520937671154886420322129456410190277693304900132572062447149897432970681777145416324475924815282693709129538661986878177399170839788699736849613608642238482562093854640951317721185434058294638816227963280264789523573362160539645e-133"),
           e_float("-2.3023429215437134462025630027029868387298887161642636739282921158326760567090722692029541940020735521809180507172712833867114768056425946933830966618815740943311715057980099106236256856878482449400298916138381187785319464188105419775935413285442945959555473684754215850417561701442268523086806656965594036746151471471674996606110661470336626336324993706558580791840114300054838383184803746950275015023e-137"),
           e_float("-1.0284155584869791154008254656090220877117336378352948078553570557366693114444371289713562696134696942852301459834995550212767950454487440082565127135086550311682748789131892480088196886458948396449537581412188376489226770252741571517418495570727404880194869270958747800283507701763947196171857111273793943861509018361905722364928156882841433888987489277160258230908838695425012711490304025236636024136e-141"),
           e_float("-4.5960973342421901135843374324922152843329767451117563090034422250877466069990612847351276033557526515814146520378008119084729167470500355148630308727853061578439324747803977787445541296137391072269096016237956107527507594675862862138912209380970116808302687471695217535183461292041410500411511031579899328519034037014868486935765500838665472021898105950189902609092457887941472726955616033176873017588e-146"),
           e_float("-2.0550302491074904272592317933844096946632540088151792988754815293987362280005510260036045109540439995582747243057056649097295924300632954198598275526795897859379987339529893804080702045731338000607250841178080363522075833238855347156109384499937909329127221772621724823198519229710904720466643434066351721238173390728054051235243347968788560482036700352429517560547728670044912199749424699379589607511e-150"),
           e_float("-9.1927047954706294912879514438670415039638429732449074229705081679140245711704486303237244948648320351402866300825189312229730524604414538193433790119776249888547497966453374881915713700118569969636303665498915884695796663453339036654580928563151059791295589323134307351969859673237662363309286409251629211490099680944705530934643885473776399647036416958673002071621416335343956439106887164128919480808e-155"),
           e_float("-4.1138953102122257639045366644485123585202124447433649330947647033619138349322951555297535173379225074841169558301122758045502565633150573979272822409817953656995962337373681399433749373174099453920197767774104436169302319263907300739316748349630130912908099291133659718684130519096131883167425833339219933638993441620837979104401057053182802673068092737664322865646387639392509650880635376839629951218e-159"),
           e_float("-1.8417796106512950002925105520230788629786773374813333492292552205088320811480239952503087708281644444682750210950320313405915117935655882848006361666794065434867761874375137325668392402215986319273899490124268704072766145448868385627893405023489109956956972816896582233091995568438424744570209238118245873263226199588155185739924061780396057339669955167079001282099085169219415251198366813743189611501e-163"),
           e_float("-8.2487303560377098183054197154094017574824270384768251843655608007921706712221514370180597955366713433813818444177882142165212342173644241704436054789368578736614728414664261003915561377194699804301264443814042542844702582499073564819892175430241686541226868492664962664968225207554204292069617715951330533986689591781571114846727663281180213731266889423514863982675147830612214563073080177144970669695e-168"),
           e_float("-3.6956671052883399360338568519119549975384956511729611816318729335406942029440360500713552600323251211230620591584388345785503695369257166548715703089028701750876325257669484883300883788425559535149893069214402657691482906414135510548642871787082194847874158318532804941644041948884792946802209446292530495859008818353931414017517235635249581762494790484099342696742721072924208353260043471361693029463e-172"),
           e_float("-1.6563298054168304329168683983673482358809133699794506243180273130250824663970641715434522931254231473588713644967130293903543747330382225416078898914485066887341967915016619514654977545553357301778487346643131980830673824898096451743125474057926576242376784092559925113761124723169885223252501909105328247734583366226354888513028190728829152012129116147792444554433694370429673300041692019466440908122e-176"),
           e_float("-7.4257714163987784397241902838424807865674813510598754145529297530753277941254904859575916152708736756159049037195095636077027082812782228635720494366678377779840165141855785220552205222492570256223090858931029596181432694550803320065449756776790513165140733398927927071340303439562048479840276930752340776235042545438794104519376566796723674274169090397780783436825492484413183812989462273727986197429e-181"),
           e_float("-3.3301992719123381680001570678092595510603922903032838329159684595092003628174146256118253642501138402584786892478715556831413635623857151990034950707343022055669015297078581007319021218804622856470881258345867383784397068870274736762655192154610867127962785801061302474465627411963763668985919567835865172172845264520143048228509503255207103962682991082445034504667759056030351854356942333551963513803e-185"),
           e_float("-1.4939165764792726725107133928852665349542323860549352479609658534449406976221402255255340312737302302522569505003894267799504296312213016027590038671628488076413732946346060036863359625395261965829781042663964949088003205263529667937752710126074947228253615403317524540479425134906212994332107005384547188173545498934934929266239899225363842469630053691871141741087576610608211816436892619039163995336e-189"),
           e_float("-6.7035367305453286623252611243522162283327865709543420852123996923789428124251826658593611902828008440890419487435314992127389059990070405144800229160681687951322708023893759308555267636802125669656498395229361262362313793429876385887205747772951502663628450939586674083623715477081549278327601324281423960853856252035619009117023784511287223458366973849659745579719653363835563840395731047057814937648e-194"),
           e_float("-3.0088297436771193469143237057152734432991961190036741311206829287309163595319217375345204081489935017193251366589514334744775811236091586191598290623797117601253909972298277090021466382621296047652918895635970580232103750296327149400652527682107143792412085369487058069701628029520941705970696837488697326222342434792880058645875532014580610239227995277757039510468106237280198828301763110358445246792e-198"),
           e_float("-1.3508341437205532037934449925918483853874906807409024986719196646715114560112286388829267516623738180131145300032476898435802115374258114853465589627069401714570320713792046428166827632488703153664657668507508276580034486566530179001198827814195894368304743023324369065019144861573961040397192758143458619296548276954313709915586408978188367411945160032954059835549032927187278309412118413357523618698e-202"),
           e_float("-6.0661396176945652579320938354581651777526437838537867221445807327602546637261594966864665505975779684297096295506387091688157875176126813342051463158526244131995107893431200389019348917381792171717702101199775504877864331985872225865460416605959031979515534420078281445111698738361933588554487180152847622821888914166294482438947871359322928474515304414550421806044378482942924042925676755484481082734e-207"),
           e_float("-2.7247345729744108148579948308832970460877444346768662565973772255210052884873007494165883465979875248561026156997189239377181504247889101109527057751604992696333304985872446185227054458751237810527710304007154800165827669096819422747884855143606272745425076098127218774464461665004904386428324221332183866867464811233429376890368542432415037138711462224445326660343768691300851317046040970607644177213e-211"),
           e_float("-1.2241459122537065778440613033199510444164832043504866116062885276582743842667519666936197848431934618794784481198895289326591035297358513432056937994587087013224486519766567783383227372300445685053845110080014724939898194013355340520484821688375553033738350344472217833910474720026046888871482859807280916338607251301548004228925861242603083727591578349370130016388884928315204151277504250505880691588e-215"),
           e_float("-5.5009205348850460744886301264422836317211056616024856962412529043668453931188657339214750401804179343650879686519956637175348079791907121519096358087023726675796549877571270921096375001262881426077609147106873264457343301702701706603614216926754317369760769963047824659759935242267955401065117844047612045643691622498118915871632629037486803884798849429819108613206050527370701943763993617568530720371e-220"),
           e_float("-2.4724471241253930402424950170540254783786400831854952240135922242562615753389381409730897428670112313313040391220035110579883882710444966879149014862223205094314754005061032520177741697733481635025148736338927254737665984960474949429544194969675332836671721141069993189653190849718091315928994117569742770370328268662851706512150332745872986505081415386738982288487965227177960907690188160825695115703e-224"),
           e_float("-1.1114875128965398706475596776099970153243241078343412962094747313854623137997539925734711219867984317468752267382045651860519681614752913440523321222666150969674822897560061019833091828029301399327064227545781111579424740042890214990446979047331558175213974639690144393695214345729607438739900973093121771093827261743197232051148728748345170478877535123547244747442218537702434394946165154658213388643e-228"),
           e_float("-4.9976378141938883391335517489364192851841777667880051406303995512270372734853544926045256833011496419099724764384616391449642400081711931578797937894319431825509421363177945617458983059267004592614429781276691899227824268251240827188643603628141536043423624609587333701374262063917584195736897143624230548593419568974266791796145075566194928351137441296923505485536478548026068015098792365339282967752e-233"),
           e_float("-2.247524609189818774285535978951050585751210645042683857194971415989435621226050719094775181764943986977382287698329452265020647892924508910952885785778077040031902067890402579485614597299153846248889810770303464285372628304778625908197613557487795839788387423387311878731480315407489414313621135744428325292981996245397803949743913473231767290001777848218865597480463359462721034749865495178398089308e-237"),
           e_float("-1.0109290175744502730367812125492917374034755959358577062556261238486890618789372235553554601927473781663391826786311529887674724978796904392467218379203734951880536964725986622716579324002281389894835257851856306967787315765046098194566357051236641589941170490758096729816972218704194332730742680826518618587310071932336132146556554532746730526859714828796534659962120855398335894987910098843355629793e-241"),
           e_float("-4.5478968517168776688387623400588268842257387670732544886013860741285228141777339215778265895572165911293866606711208231753208094425131879212640880121288291611401138338642417153313268676008569713154121143076967396324689217449461434643559775397491658166167575617229790448096542758519489401765616520583404244888095692179277075927404656934726432218983139526017500560666630647786575348714007911584493317639e-246"),
           e_float("-2.0463110183424969894746822126428352093293033347212385248252871439697409834044288012663565543035955012714548030549065119005765720461465248363215539368890618877056551320783913270000375357784247446922480726385894172569925836330231175003163327299543889070830586605699164974516629944322522112740282137832675035605623490417801159640962009208929773175250842243538808702671316501563598928176045052070843234409e-250"),
           e_float("-9.2087624184664678441751962187006267414538839985494715243535519830874540007435163313825612000183364645960799154912843109762724500565627492020926781769890130825320358000902647278851121534635471877548577529230696769713543697252889378367172033505642253150319249473983285474499108549275869365625676584268320147720137986135869676329854638840674883768950840334352845405106246440313790739798019284499365161006e-255"),
           e_float("-4.1447382565256872832411335471601694638155744663093237471214205736725830540026917135394385765062243707029511197918588918744139914660330082676853660934337481060403263470487702806337188054464908924578401531025652358899178712925278612436505047923603335916937984493789552180470266206701606823049556757822282595592532900655218211892996498825101024260727336015018893080267260587476155238807004686289053653461e-259"),
           e_float("-1.8657648781815613220149918897846356530138427894692203800826694372420388883920570759891552174918336305542036944139599746567381382158464274869382843037893322874619437638658917663800001604106119880731034395034269926025988355658109315492127940076353089508942716180126407042356681080966405887245667736113091827665440045707027348589779212607881628825743461861971584002240735720731510491766417790619051012554e-263"),
           e_float("-8.3999855729401685243788989045484580116624588781125037542008931008968453135204759557987703013367738394420318781059200652989065967655239383573145552850470505621154330151321950589435756241709385376175103396573813860253186529337512855895172228033013145711861655238858222249674277899502804982577336592488119155115093117554740752045862130863381025440606129172636259553271021234076757495020395547228856408223e-268"),
           e_float("-3.7823346865488321662413124556407637986862126691623847696571672747908675641105912937417211915073359557507290273400735415158767118711244187722536914143941284754162738498288365028384851020850843722286413050796711130978936040416521396512053548978530517114655470063495686730628692108584412247943343813296689360628726808965342863305529087222900162479142445396296352758217803718947083643390053841915660561243e-272"),
           e_float("-1.7033316812807574420262586170077729670285689975914400942340327716988576990126845080720489864866704191062184438674151628694372492756542771243436671444691486465904370275810332681227471436231365784147596159213391086270369253033991975261705190487604431377538981982038794096113547521621815961806617096435368010026984179868065026054577664703432936969243355812319364152753633697752772708599091989853051083361e-276"),
           e_float("-7.6717510817806529269929153419861373360407964862075046099467544593007286491618558241197068748634418890247393940444551524530855150535909211557870111348031637196094369085240243156686796536050372138865070688566282596502497957647169433049759179946839251060874554640804072511556649387923401752536826189014966691115621105913064676752626947599817918101067086763018626862747743445602930524055188702943062159061e-281"),
           e_float("-3.4557636838707804980707223476414632998392295093069015121898440881133591086806864836021365602666836690449985010053861401575602863118752357435005991626191353654143797824159407461055264362173797371074870752362635900519422856334667650500531444195460050421626057252969847425826306113924907062466226213074534646672857105893734475309561889872973150242750370851526575428414293167599181239780018261495242423696e-285"),
           e_float("-1.5568477690545556605280889989607562614299013195209452032371053571007306603025520524096646038275844260774954270606944478172152790319010114878653034510722028892663357938420376579919634436408769337730539625577227262903815366398575762740623624234237529515030369911905478705821736559769590911132307271752942642332251680264854372478171683390799304458576541255068420339981582575552792961475800906990919717725e-289"),
           e_float("-7.0145407334999026150254869985342753084549072390792532139458740290676618006909263384659753860397620815128099946752930450552776622575153901105637248422826589905415322352931674510441360588235033143993686781494262173773609611459101975829352685421217304339190768503333174458021237054537621721226248237872505546803338958995635946185423450984466603123266770523711174925608085116900915543547640361480713115953e-294"),
           e_float("-3.1608347270431171691806023339548513828158754476189914355520470389652567010434454262117895099127226779672271100696284498352280365744800235844415649790272736380572916124222056179066044020895973152337453275837992661770272503446913528757434649889976174012838396116560933323232306819260345327348823110948746206581052787828547544841214401030830878982833617065382332406035604811225929240103540909794387714855e-298"),
           e_float("-1.4244667925928083242140292188536487845478679536188638132049454611004583292166151844121338717892105233616848993263394129436830866463835072954150597528045125725565449329907756592342132319777360977089760099419803345704358818690278808264152264644117109689996707749748033613697488843589538036381770236842008146110027939258355484681716034858789901038770133346569730568536315291304326751236435446165085585812e-302"),
           e_float("-6.4202134859357086574963849824521996744292839504374591856327185607088026737506578572199922747323620629814126322993089916548364051961590103845286346064195552633158499270177708413496202797781234876187014337596400003486742314704525497413355201286027478936111476226083487119087717798616047565016993995186729878775226325333334097590894369239577942860975301007303464396030555387140973061612659105300543458839e-307"),
           e_float("-2.893955662488625688773771891574748973195067849859963913425576631398789293302648255650837645870299589393060724928037145307678015254647431255753268797343472967196848579264897132379609588014350545805929054690169287302568209676807917556130133610885214485266225462894635208578982858598097892154144876526735855083994261917311590255271206052930114538617829456244268613006037389750730955432213477668256729391e-311"),
           e_float("-1.3046026643345620716842667637107552549532307621351074922702571843559670365520024549684548521598269662834986148504407195135909023518269596455342523383753735481972704707737287220477459288309800556984674285904742561447273309541982240174408116031181485354533822434907939203290650455351432412764320461081956974643436409019274408590252434844972430145179175127249221895714016960388389774563463878422252136689e-315"),
           e_float("-5.88176146908122600525984435710791702737668396466481654934024024556813759204756359623007881377495303567886792203229849341681850908730608349640178643266098687464932896684036823519256492387607781151669301282734732849262529573757138154717939684014224048518696492570026993455717473298826038058569627917636621643934765281809083532954487808505985522477928305478055595625670878837335339791138834411546424288e-320"),
           e_float("-2.6520282058218981935081340034095301168725171082635920366233793788338741554665754382182600021670496679772503164633292648098119652403988231577213287282848619926404441893829539084142288943022369796619703782637823915154281534176667545891332073363734582779482271478949368144567326756207749172156814983667710570098920826340358484340167199761259623515525623074616008076771613717813563720646682356997350639298e-324"),
           e_float("-1.195884745216256033909000905005938452810428147716099117888920732109721638155538377273041481604559398322991688285435391833279400002100101712098940074220450969428887689292174119004743993362919158218156466966774088708750597912049600450343041632012290821139731322721864929822315610982001116612382207179219685065696472999857621637930395424856378772348635888732157773366319300204217492220788199663035622856e-328"),
           e_float("-5.3931175684710467081326659814269888826591030385491234697056439957685764978829308084256904486297892572207490091054253770624234174895106747918012859144420170970553166774175267495766220812193581216606659793273828845988464953816538752186634635193647607110045027102831330298562856288339897244660022786413403941479536339640085972835239833605557537020487832144565485518575654587435334527283291803485811991895e-333"),
           e_float("-2.4323652211981581517248354598244762841709715042055471127843224021876020499404483494271752497916113401395516580901879538733662440548796838725013488976578756439890587774907781929807288304973762530421797325228670501471705480313809745609068911062584302126577150359669659082848646366845735470567352115078490603235869012956075680396995989902851983117194059028141912673540399580384820574800639949302070864241e-337"),
           e_float("-1.0971222405231484223102058607461745255726421902350223741077282084030292901449435873771412176997064259291107994135447873243627233989050073451613669542806861816359871985350482675951293646146795012164018156061555240136808796171838060016229769992437528304966002253691663850003332977945331129125185715215992641566973547273677145223585884996801343991176177406674764443104470004064626516124538189062382054131e-341"),
           e_float("-4.9490020033699625563270520361758052473940975498039173111862410484719075999162640524489074491775636252473628092796403391509930385367555345142692899362880045950474551406956465024708769751843484161710741309316643658210979718804145978732892963619408041914177002107971484649419319264109059399500667635029220975804535172453233650317283792837162779562879325212479442046476595361540826626832819797509676392122e-346"),
           e_float("-2.232624536456649833424051021379172529981487308777502103563855637613294400966553744455249494291115005322153695835446202767249945412691527395820183721950445497501253158479417483771517284545319899413402243908399944812304953639326024455595958460352143943860277074450795954277949456323777659372247800898695283985290964773109193301999174839715301285395118164867403417155246778606970654053538351035166039179e-350"),
           e_float("-1.0072756173399161417691321930172451072624710145122539089584725199023539580481231898464004667110917682782470721152056418476900999283588561060050041436624490477558270673742273154292546393033881223989776753855860990536639866044386394114057967894456440530795371433339870592527288313761814056101441651060251864204107746686235531921890010871219388934851149951731967420248599879971455031666597982256219911901e-354"),
           e_float("-4.544798760361228948137883201921241179240845372364190852276022656261079814912063854399085894408138107338606997815606610738977390892022419395845522092544671881531152307789316270160124573055541730457821662843718569415681708659948408829047294669770739404086971978517884950833948046891969077421101038785223684183544796111126522027334275036435517879664010463735554045578018383140979488311014170599569579371e-359"),
           e_float("-2.0507554689671090171189657492490357730493339059514043443662103945087827107418815895667277547729021844396309800375179578633367174616528358243014549565498044054892195102100691962306219504071816043257089086566255116166093916821406504191703788847578403036269577536163562631520346897684319631989737050384591343470419849048068821055277590341683663541094615592290652218416088977221132372528990387919701010719e-363"),
           e_float("-9.2543344027183505556357366632707305174921194504677802991771816707246438129445234415598868855739590146069012349314349267978314344202704729080715010217915221273063356181570289867443365242493692085625163151692223043051949007758329247293593950782434456778773207095169893825835366765302501134603668575090037856826224361299779706929299748040326436181273487810372790738207758011853363156030180556476028937015e-368"),
           e_float("-4.1764551519187055263390885281206663886731066455856251915209102226580946712019423498004557868954419402454447453706393162076436304409548404699127221082900844029064113683137406522983331929130847946384241793382911853418175065512935617939079454506197242326352359022449999874874563654386761576574091852907318409244937646097611738876274968268117133068023570200711002840242718304813343297954261399477128914446e-372"),
           e_float("-1.8849552328563149771258495082699154838770110089437754497461856316252629820305682508373955773038370895099745176091001773515173132695064624372768177405205247944214542816213730404234520618310968167935642771536763009574890454203662001001494624701732865886684869600323339520566511580215680350842685029261311243131789289380104613716998821589409996212216791113174958278048438104370273244686402763125888129084e-376"),
           e_float("-8.5079343439243265836729931563024843707485958451878504880109598073233450488242647021121938685425043282200512317713056115483442363451580053064495549242159114903660666819790707740919004144329275750276619378541883202091001078287472480053233862976374381774776184501068699072955191214161049062916413688238347113074710692703938817739002294152887994971392742673136656117471320785717982622155417845557377511921e-381"),
           e_float("-3.8403994792906770500139418538916434169657657193377758577556957675281993580396433093727968945412666534451109459867172110251861749333523061169785052424380911353091673102835430414804524939564980454332360119545203622884852685829011949099763214976799457996253962808169185431346137383021174344610904951720211645900573904509716773141308103790555905506845971599327572814029678439563533575169303543676747666493e-385"),
           e_float("-1.7336331084278068363245392869438432475004848234129335851164451434145656905904467088770088423568001499395662259906802777781219778085280100967857327636656673581159176759942574841567293901541176394808179370924421495398310685362975415985581423683779372610476428118470297632570351654359255242632624685799036143210895165048683086879879748097367041441084578214537349335860147595593980390458789468047334832357e-389"),
           e_float("-7.8264687977385615208560236999901990765303111016976792476882246121929408774297403047748889704353954465215231753984539016520931552547291938899495960812539152549822240220099846131789230373133349761128781055843399168011589286964339498781348847131428303061811427521252748320558114904580069782515891185601594842393932057938307655654456597329175933916270736698813871661393305531305223729461833457418481969081e-394"),
           e_float("-3.5334730096377078511368652592127901278866585742266082919999378960739742681366308228996611850441855703576532581212977319176759619023968788304752316577057918808211479249173246362746202174632420891899652780208476510951926665126519143368751540926612532639388259853462365498165086365023912460299965530996598457412534314729459457868888175885893470872596976765144993078846777311568983306586989283274601026983e-398"),
           e_float("-1.595380767990602695461257789181694905332629707705352628697224655859688529947469873220765218825631979916926596156638500654659809140047587226601402288958241260977607842870902176354735098619030706860638719526429936031699901454363969860143374542275008381076621080891592204671646520098231920537454542390248515897622479973740114498459523629748901038668452589308410040391240122887564368262271357379023012294e-402"),
           e_float("-7.203656564444950059502082877629308966698740007819763980296602568909691722066596931737826990065133307211790027754779966836031857400536025881696750226805556469684039413919264552724608231119382253565047932284087716671446798522146915379135122971982426535841363012210605869142870895649987153047927640641559022000666858408562027925885187271543145029757779527971005592164533340210289632963943940840527279007e-407"),
           e_float("-3.2528733746779218352903112635952162239527488886147022899529317728623422983630154431856876467299801460852174743713851707049885138073052566103029718998752964450635771386282576223698649584698862464282502767820620325823583965338041637781613501944453185848757429794772026891179393006707808131086194884517155928114114089833346894615893860963663033926884973606961678398073012908003617951384891502402795404873e-411"),
           e_float("-1.4689475282036148832923625383254140246655866035015873729629550233813464685924229778438454582886173504753148596643243454273190651334195152668353188772857056664653946259970547298490166891986110782449805826493105993894736382161420083877814900531569322664069405396360553817153844410359387768685457027549348055787012681127407317719911330294517013702893030535166197553348319641745800957352506716642956497443e-415"),
           e_float("-6.6339141628718444423997759143198370585067922740195546160399690056941244392031922484843726158576367168428605565544984663723526917441524499616040569003439825855082322143457976593836768119903756046996113454299486191578068666802376910496551234797504734967881740684842034379390432415300728405206137716916857688283164671422332049014534579078172691369664638026922807838757670595475345884846615121670008005456e-420"),
           e_float("-2.9961071602811126266700036328788510077493431182885332541397261998722047363647298580715734039617420700165076028200541415221288970678956409035643802314618690799328527780206687621271231209970687695976086757663109658444348277646548455346901649517345827121738722109689193150405459624095246223002778929348945611221736077128732312733365085899085671810291987212160780453648814526166887275648101646904659998981e-424"),
           e_float("-1.3532195774977097604260369136796822547261112028960009043718377114163669139526597976847622778783138319885356421713806657560076421221542635826321866231076049653943228558617390943110489970061997776780102451550087015471135170243094525116009413365388834114290520631057574980317816860910215125697340648302826579602123364504120757983830077763017470418421604269228987305537503105942935987020939394202237863475e-428"),
           e_float("-6.1122647562580874464551050886302603049590975914017882344505155153796884497098672704544314558295607537859916597844852711212999148665280303321950750537739222864272977276582928788305695390052325770712966318238960905150018343606533676878784006587498475167054876687125171155347997424714857591471256056896307161966989997456601089063040782160853396668528640715929801207328360535972650033070565677768327531283e-433"),
           e_float("-2.7609499506148075081414616943902631807750062601302113853612892109210489624129743108094225069173169120979542733593979022397333710339724384110629672391914732102690804567827572496208441711059716443570926381267269607064592476867756916383836086008411836337690570914764427637701553315316246116269444555586652075511260067425483516161859349052827369678634806770805684845193571322052430083672324061164331238066e-437"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00307_polygamma(const bool b_write_output)
    {
      return TestCase_case_00307_polygamma().execute(b_write_output);
    }
  }
}
