
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_03023_z_poly_chebyshev_t : public TestCaseImag
    {
    public:
      TestCase_case_03023_z_poly_chebyshev_t() { }
      virtual ~TestCase_case_03023_z_poly_chebyshev_t() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_03023_z_poly_chebyshev_t");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + (k - 10);
          const e_float y = ef::golden_ratio() + static_cast<INT32>(2 * k);
          data[static_cast<std::size_t>(k)] = efz::chebyshev_t(k + 1, ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 111u> a =
        {{
           ef_complex(e_float("-9.4227843350984671393934879099175975689578406640600764011942327651151322732223353290630529367082532504853685527501929175190394959855134571637758260023550764637464996662570626622623260572074047417529050839912647960518343291467668482233884713788004984920152062549142942599700786452138533059703956745784809412244647326686007459870325794862458604508883148971920157651224127949615689060026386274469391106687"), e_float("1.6180339887498948482045868343656381177203091798057628621354486227052604628189024497072072041893911374847540880753868917521266338622235369317931800607667263544333890865959395829056383226613199282902678806752087668925017116962070322210432162695486262963136144381497587012203408058879544547492461856953648644492410443207713449470495658467885098743394422125448770664780915884607499887124007652170575179788")),
           ef_complex(e_float("114.70625202366130588475644868608761975859800638860438130793955999309668879520656068852036021686663759723180614945988091035306085671024105588855760175283640983591570459046228258900687300385114247522404073309904655999676624445522023331416515871515525663571228728509106155998786750868760853898484749987288005989384673278103227369413455178853272617307802782132866628774295113673013642208422905204596477906"), e_float("-121.89568001718575206982163931255882477097678226157516171151315838659234974705054861969499109505387672732460017903906762500543432554746233882212820116914976802502403424497012220123325916255277380460339173999072188633344259880069736352396700755485734046433857768586581263687660948141972969138183120188036667504872307746448662028191299290853970599036823048056554556283301379047676812383496580764355772115")),
           ef_complex(e_float("1197.7164426892614405944374377292011388915202012501966589845209778933067360770407089376625397879943419832342033357177243794726690358450362619470910084814758434774750458270991499921923781768404322798652255531389570294230406393061370394599084530634643869401828746414394083068418556687557078996116553047964816666361588499599903013644016261620267397180815758735836772471219892474022162462162008861918204566"), e_float("2988.364323929639455274725569517140834380131701159595006323577938662567756777148584409199106491020217295246160072579740949178118138083851296513439396802663642216720190976196663219929945924518444594179943166620105419816513802953956580268488648420937810337900689358068572208432119481451585892816899073249327762264761580559189986230395678029377304472889514504340944247016160319693868910178383246288416653")),
           ef_complex(e_float("-74221.053504325413099006284723256237630237343090604249307795427274725554416807332571131124851518958538404128228996825202002659321616512404348264855367478205914749897187478198659534084964716111621178963295679365720179841567643100691890501522227131450986448679593883138811359596005125540294203026595964628244482832801974363133291793151072018374685636318146007598959223264132576236805899563320124750603448"), e_float("27059.348890252585858644590866521730769324481990449945097041293802258855475168424688321410919542810227395571522665638192904836227984043263965801524009457498916930722487512316001928811988318059168447012030903677201756518101205749681697524117573327672020088896252582071364369471463838808161799862569293524683807298760568045664776861648669904058869612279286798231450247936612584246674485731284369574442821")),
           ef_complex(e_float("-1.4541309979863881935257161976041528457364029545731416460118199548339990708148434140591836189424847870693049739674708550272087878904532360736600870952740492851554682372694955849809120578328385095095557734201723275729909857021151132708637882185017574137980896849904054210363715452734686497571808843655378432860214463466873127358557010755088375596652695737249822674099316105484866102968996584355326768453e6"), e_float("-2.2030921536481083651034061146316064412027999194490621048174153864064549011912773107262001734507104508184503338664183024972403488126050519369423603859010140482864686402951373235904772473296435658688001890771698471046902900183656481019782466224295973213700870037298453310670869183598487890123833163399637467634385465045008839566918654018521715966653886609342484046238695419131935033940806216668990110719e6")),
           ef_complex(e_float("6.7685301247569186324221418601737525521922645409406548131879631542757481004764069211779383912461683108975682397091938623484344325776017950389096452958692845067808508069488957367209622953412573928336811282110482152120333779506398450395374954841400117095569758718621469294564055906761783482056404508155892647315013915141746952495961630060949457966905581730522558393770667399681200741331294646249048194244e7"), e_float("-9.7832817001215890999023769003506969448314343407877546919116444486436974196099117290837026258096871349335430909301790436167976798163535338632322534634865755908663832260792209042282620297827697462550111482507790095528506025737495358660898004465324845721783409133665259593315715776854825603714781805707985289988175185761912662765099766600010599662792722864951786997370468794276447516898813140110615016394e7")),
           ef_complex(e_float("6.8654177770246303540391668115441218159195323806247157897380129760136946233617406878616041388202024028395720233612768890134877143584556067986216568697539245074220059465873496828240531898191659525639789741397939164373457649336018794377405747305397731111859799419825090120906431225089986797532173961882709200826842409678052474138498879405059334209139691899137462323808131971481077809639679574443608637634e9"), e_float("1.0285534937986815376708600369833789952685516339244509038595506534453427913879039840375316715556080949475959105879570307188676898700927660523123701926099615091051057704100578541929545485695376479438156129125985752758419804760457626474912112720026122473269965191466298486721199593315967462102762183826286840085183582690973375161932591931210587026655918055535006304703416836327794380662052672546079582151e9")),
           ef_complex(e_float("1.6841405801259536162824864739398426243333150407766764470727389593898076781857255027216042601443476058566436579867952809134641903332180882551118722017773440976961307185420320942087341244445110724472760492525269437448860549694824623336109741177853022606311205767271346885098002627751719929521679663797258819769895561537421645280117289503738536045172848710795322500372310632260623569141742784058194938662e11"), e_float("4.7307350263175507235512042250033897667626022981450341863219319795837322021942504865900837794676788927260886769578243583300448269775412148966526857141365912829362289450726983975024877718538010654732635180022982849448358620314308227789715179028164009369406430697946647407736056383161768906603996901530677012268532871642337470419364754533414323764570677948266314121347459276763722784683241693098713064551e11")),
           ef_complex(e_float("-2.8760728278794624381853984592016663783273263353060390709130173831093238659149272625026739750679386086363661139800384401002208300556700115766590298485434212419179722630813310567239964757805718285177143046753087290335550497543944684841955906266582319950539441393746614475255757594546707046100248253955160169146444677257848908459420100989984732917656671794034820143753127113754285981161941233847054895052e13"), e_float("3.2522702274480507601283338439364847052054616764175611440948734913294138661005414693534159983237339260371141678660095957435612943776322929759425233402321234063566996755451182967769922788853305729914272072388491757457335259356256587703470419707311154735262635743878040366268463643849283380655676394707823745163200445111296991203565086292050736736765797507947472075304726863317870474177065273663153687739e13")),
           ef_complex(e_float("-4.2610143340970101011111068601848134555430236553560890981031951385497392863178236622832140540199662660135967718590659455888736966527511100868958291109973928671313646515726615578073374413929353520532540851265799888263322697603682040574359252286237821643650166883590372758819408396942093956674853339611818657661061528390516456714962570940488806410558166829149593398662874033535626699905269172172849012291e15"), e_float("-9.313725977356730658457484773894407068667712616931006746028726762126212143365831906292914666725417456823739619438814718054381381974939604208534342346835747951808438315334222537945420565811059120786310002219978707405313368681201705413153344821942123901068804685854053316177276860785830329235591940688043140611502935375284032691414876811658382471303027345706278645352034780411889760946789228570386375981e14")),
           ef_complex(e_float("-1.4408892927600962916991979501011729910027111212567673835208962915058824442169837392192175245157196460629841121850016482533273037678730847652346364627168296848157140285144337482784042363221291486524098056999502975886322871634838474142752553945618227020462061747032925464631463768891170163643258100987950178589314725935076742900381456652043611394466690055516312802193757672201453715817621366427956354849e17"), e_float("-4.7705790200961556485450444179009356208319545090813726859446917058250497654486744590531464306212821156920491682981428882273516692175571757672414927452871118232074515048021483460696169356682276307798096773388688884773184888218483420071877900955707649805572708578008350539086674955297481026012160789125009451376978658475907137171895382387396021317409275222245227856603617733365527230844767542295414516121e17")),
           ef_complex(e_float("4.4406140161815908975720153084276439725064829138169016602742811678545650809567884409587392906450654288638260143881960612893566942410623773388179732635076149159583906519496195724562563627799563123063919878250164305835273336206154388293751128204922240443957110044053910163407580628449956057012954202120136403177153201804716792964946890226459100372234699512204671199928953038257328189203613546085346874724e19"), e_float("-4.5673141030073955880113536206923243217753514361774527901231137570218501764707201292223604356495174627966458810881211837800822680348142500826287472592377157931201105864924398256865754870858030582777102857354278761733141197375460902744976570980840871852980912576070111732389337672441162729866414336149687131415427264373822297331337706334949320902441669277459220180259645606422421983288225342671342038662e19")),
           ef_complex(e_float("8.6724148346128852667774227708235294311714194854823958633773544456829693131770298377674179618616717470193835032497553939871455235266554544819253256089609122682296075812200448928052252906821826594614368216353947130530343109188449102113996932034328230545431941681255666513976219638183451988397436522823142892286501647926364422550160201641526939151830738916125929984157177644442195481794097502798589416444e21"), e_float("2.3846336401581644359408955151022152907083415533649648288390933256896830162602669826470678588562287039185488607073731096055089568906958116989138667969706568772595448277151277458784033644977239950669657772480351210609169960407876320953587540305258097528756768828008361702959027171712218530842251027159914912320435158779495611978488571887209835795370621155206550051012769260015495213044181164846872171498e21")),
           ef_complex(e_float("3.1839696606497549931162321802066738104842816598791421937937575107948207198205035435508762971918548803864296745957252035739699276598608137370749260859333355151880711303726041764023081324217829753871962238389926330997073754220594406928728639787806065022027843756455283283834285873525836997090337766319849254910366384812020943881907336801178711140152374099377886027859529632772080138909835934875365768569e23"), e_float("1.35155386190819324823268066011725690143130951878640200044721651042076711322386088384710886872478465133577120064309262950359984470148784841274648723040824641774703686337622654192823546167534065599331299058737939758692706050552189267740075870982891578487800833240144641599508085397132386094886512586991584710750896811044733549232745119401548764195461767715572021669934986819435641120395630830168314252852e24")),
           ef_complex(e_float("-1.7356102145347647134337571331005110761233269835252621686495879456342587670825468485386225619754286498748923273318039966450816864020540438434362379994979184670604011207779213767029476939446737482995092585015359994167885009956577246405425341883705689651089219019673813749101213459850110203170396723983850242529811215729032175845996531304140134833070828420200140537277641789892716762587482082400771227749e26"), e_float("1.5465903817007905233745785103488256502474858417240904311614000921297193238734676435589175381153378237614300515370796754122815524318647968656487409530428913886500450943064782599627823537458072628453720412188537969646369101816621726626556578688925737614263939559854982120891486660785674743415832069435895854777655613518467061309510272933033579218080493249445480330141492605579135978804804445554824715439e26")),
           ef_complex(e_float("-3.9389979998926581065552955924429981808096667195950252629263808619494711946286554147693112246143281898190098736740697675655041763287692454402422677696977673067137040567801975526842159650945926456964980274381003167201153289063579408899876254288322090411308155559553751158260672411956699818903335807172259322384250079112567068769497576247144779468851094702994581839707969088194297144575522649957386019169e28"), e_float("-1.4349921508742490420749847196882604949481461016083743833019817076916783171821758824103181800180450033397359831802433352404075141605707192241743790168718651920918701225096368870505296733237379329505949910645464477285863258678066545913876964101706253581500715745474787805554866413753352259310125525227897249371983522496802869849180509904219476342429059819524938451483024897827103205877667209780005155222e28")),
           ef_complex(e_float("-1.1421465964813130000314853196426448213842873381184857222712628236947875470897418287777031345392246826245115474138040702160010478200251182495553348987242645546344889815939287712221510261824739958203715831868269576738038778608618265425515105119904868542224357313309911084485338693144961519786708934028767037171172789218257868632368989097425292064315301489715665714618027872787312139433364061615930904608e30"), e_float("-8.0161295269406761702363343250915391386769711383229700959261617329833921704570353595212765249054307161656316089912842036258610607496516318082627696699342790269244158498803042673877285698490328228698407105366947819262494774808242034811281702184467544795176434875314970584434447549143750304481380659708593844474050811768994152260759835291167219034143496527158028063732913063395258759555187968057687325635e30")),
           ef_complex(e_float("1.3469168257806287481592799387675370879483601644120931993551029469315165293708491756594772928972109854575673651079420048363019539099154690656050721775328917467189194726009147823975042295148165312683385257635163564064228095296800054217212853617083870557332522531421414190057263624971138943687773524528428774857310825056168668735335888037903759938790978084814200466255135862783071460049863207299239796184e33"), e_float("-9.82092457234900674532922093419779843221227807547052648088049525830502670206162774959543591627163587688506160923699063711006982784761804904482294062748697706054157524363679159970012800578321035602605545282892295330690066858918115555343955413449196089507608051043061253247109118098736089921954970359890685826567267513220037658727691076673763754866726989201238212713547933024078302613159665585494992291e32")),
           ef_complex(e_float("3.2729433519041999929536983991721120048966827857276454644514772057645234358278438645836446964470532165693994376910604244408312938442612749894101865625901529862507472189056921859934205314953266166782470677291921459911607335908663661018436193353537651808547488852253341705123710840247699528548543263857316888612595130732934745003859513104663523120062946154902009315376446315201828562985806952231341970547e35"), e_float("1.5989437397328379993972729649157226504626110310527332050181149214909443958728854868128902814253477348792944009653866730068904362905145632160198279965735810172363133554277794488334487676442644778362398956241442817196497048729644370798035748203485182345596345592009254805556637175716677703937017331975124428592192061795213237760428947043531886220611603336726569451555364976864791450920010939073188995382e35")),
           ef_complex(e_float("2.525665611118207577137131719898624911227561609737039552528590646732235832400868591304658728168288524192585903578803295188076722832868976867997424899552148015536177306215364865384599367151206512604215475038300013651812904529558747037481236024578015503739325482840650382034992021833188986252111934206716848847976597554580254482109879377410967146123569452349674731794411284217200561631862311401658012338e36"), e_float("8.4148841949014599069572413543303508736989123958088430282776966461357913129076953879845357822931539352986211524188479562276918596382296813135763846665809119251658985993347567287023747129926929327132635150422396077851497815285812913062206023266190305568272360982814755687376201036202053577491741438351570887420326040231485478420888761010026968909526325427008837037466804558958721652253824805383538630813e37")),
           ef_complex(e_float("-1.7874819140649260689519573586173465216039949456826806948236423317266812668919198778109547978554125161214974165489194048346900734941593032813834551285085707202215845746526145115743830240859025817641998198953161027511119250594393049688033442960145895039488036163081921916724501870154931742489954941509780349998027291722039440632391950228952448935342699236018453968467534914916746507327144093238259195344e40"), e_float("1.0062917815873509077307740830731527635715958066670276034269640962444550814022945292958638866638564384380724281956819706063008270545869823235841096944786537464536344223995164380634794761629131206437675140227208894917953715777633438838422467800973130205172824240499052508732361656441669485880937391018072820157228483088231853898325347870510895399626163555921887595538531326231689854851725637115744077595e40")),
           ef_complex(e_float("-4.4042733700624680366007918600894343951493650743549949350045957210587881993212361928113836292137930780320186266828340276753163075144241627957602637501881530311203939951133645699112656469484205400529167614256839887980542689553880657534558441421598416061736996668104942592282666508475438541063852347711948925586364204986685687176174727148064647137140312166008837110492877951520698428653302498699436249705e42"), e_float("-2.865628418560495526962782922532616664563189654232367440579295464551407534675437922448129172445168031321558416585548238705911632384048601203719663494662228715552248687777877619175387586556106151535916236989838785233841295354887789132712722427393037904988242080782122924335906208833278691208097018168262868888523301959350423338774707177979156446686751707742096639557946130253929251028547739474743785692e42")),
           ef_complex(e_float("1.3664153349611598741209712253352413041811121683695418612701274270520156021370131824469946241659639243882439303564593010229896952872462263199494752148254609249793502731428479008070529715149345083710935481026300921831968035092146340972697952043078650460057196526461294579557079043042691187392069949275901099557564318763670085124189982337980246404412099107761624280758418265564483652531309597921156169991e44"), e_float("-1.40482336103800004143517460583544643018134930558231882760878495582389704114005352841543253192094712758210935535197918665306328437434301336541278322038699588104922651043822936790638058418493705098895480920382446908194864432162704344642231996325729367184672282317484731218509925648534401105419971855691913402352929354679486376099600823340233342847857674810058307305719621929913600500581043228012175976489e45")),
           ef_complex(e_float("3.6814199091007352654172468760576320598121870861907522495784551691765245455627176497142577531663378963301202838572086059506158373311941620208523578030369482800733738143119005099655228410689021991958711400765784279760408537842414525652465557390618821185046196945179108481671491246711496848020384276544620124394469585140030817871966884144247698215418296657552301134775241349656521477839020595641802805838e47"), e_float("-1.477652409614972440503314963614783780672972454350677199387487295299759852694939767375279896966137608599695374371645116768850202542275554489094496562669094813257846173884007428233772219458723681137414417885458203646408056682277472048721067308617658809414105768886003647116661748169598170285655560960231130929130259674974925308032839334205034558163734142264329958701595450555126181660299574927829782636e47")),
           ef_complex(e_float("8.816534329504805026193380844908572692724640345061971352278282827753936880722882017274319607335738249834414350300331635649367285262819966904805485370649745169145023678583793327140876719519158445608179259814779774305726826161859185320467513206834899332287584637670724198980767142245980296506819458682123386181441116863449843264239056058793896035269398195574371163557488632421816200567598246289871925109e49"), e_float("7.601547871739269421018526546907648327028551981834915710228699294428172132857106534812635322421099593038991830915986935417687757439575880172193499748345575399692852017725025955474513644122027318342646290458992215102035450357432322872861493840054122446919891106218532944319574347706297700058395676769959220869620492312524290932581293925610677713917206338090249479825656510405249316710149654375909790986e49")),
           ef_complex(e_float("-8.287684265550468506547650301824950172544079304697371018962055347036301036971997509854746277325355658340792407764763276796081881774790018780945757664037690819520132937483554857970890064910915711289369916458034912620859127522102596276325892336975314236611132300654248510297048720531634135826725178133944384232915637431601432579656006576221564433843614592297091914867583718582928970130221534403336400831e51"), e_float("3.4624594415687428969504343730359848329737340605229644295188524358535111721231592556430381242661334431833449074027102928318122937956491173282787264814347563219705271044731165864949372497070982308188794071537595046750818468749043754571381819691129549010909734115404970215533483936977233204627845057175417419230992611498685478993077431566864266454099443533339645071070471409003757683231982588338151451149e52")),
           ef_complex(e_float("-1.10018606799763305364332604201129626261166032796116058128954543358623560329761159661953392076464110429417332278763015307073237794017647288715314248623767789255248083800178149103398929172111958942089778025046570662924566274240410264407245403801265637467693377937432633558965191077911045794545479706375256600703311977586464954288498606285898448623529412668699088305060141916740195074293817665589092358384e55"), e_float("2.7013314753764961140175653445969457587477616093906487917880683143426055311310538187733771742084339618566900350349425454940804437276612005724465786420036617350575294252000905543319847123528269907806235022186967420339572432496783138051587060329671298353880594821198501067445477751899227992629763405799222393303036838068604749727628072481861805280671385160437657015881799571059832291197473938446325952787e54")),
           ef_complex(e_float("-2.4569266241373684251798192277905393636605033003646198682499161691367195289523571760469060891927245742028953752070547819529706682786770591085035941774356017508935830114203597291121237509209782998850607605483990781048738328258906106904627109930299305825964948836837789465315129715525605164459029221882744755228415639828344405348176224366768000908122590941623805109680105177963486681642383323687850223716e57"), e_float("-2.8258174539919816641354317312963619394832998959872908951380161026713528120244176459173227926923086011558437199556008737806177409384958501815240351574511299383119929782103672009378007054999465958481700914341703501925085757067063258104420821243802121163019912361535093002951782876897854477811895019831856393068116691619061285323799268949862037437150646713789805656398550199129654812054266132097993282798e57")),
           ef_complex(e_float("4.7732384937609648365492202365687262795661957233438718734501777281391991748350252783353082175491687602386988516431863439585686755243311058842368253288615273969254541602674698534910045112696869646171731896370586195943008755954121543269350857364398256419068914981619949423539659408923529644870963803365759566346890936257246699743632468968195613261023700406802338426934144650580914446881788931126038065181e59"), e_float("-1.19185417540840329985519872682364277944206925534574501049817597412187835665460278370699005562133422154449157416648022872752102731835411811849015305810904606960549297828996825785117199021514565398412875229300172601281709654318198748313796084674291763605593680566989032537195190103698809955625167660295138935347610227286108166994388309053849825474532159827290236978959806212931391915872782435398256869883e60")),
           ef_complex(e_float("4.540542972275016982482259665242131709469712653710012926246271487773475633254963536081107235128308325686551328751612202120817837786899071727828563237776994340722534489368865077394553222333741442837271541320279568725841615824951499481176710457701693528621124645666971572693713640407330163893717909537749454433071784189676650382326257943178494937788206722762181248951997455430908638356184372850594718408e62"), e_float("-4.216666911950342974334017629781396957814709526431992606743789617331595849787691934909687843050464788329080908731274010124853081193838130247742829713839322260853726780046783713212197703708834944264793803492642306189289753361547717320957055853533228321088207657938242317819594373918696128556832114885994133739940776061293577183668908864714491072611225005727965064214881226783903190854029477809421463321e61")),
           ef_complex(e_float("8.979660643704121187826638192224368216871292770228390109604417160458996021036421345367809704930275231504335171515848454310757448871253708453932425768300738902004063557852275019240864392945217830049909058647083659553846623814139599244365158438842292798777158635655783975597802423327114012588975940105640224988474965657161649641148063225044255471791171963491866611991595045282028283082004854912721081272e64"), e_float("1.4148315385483374562529834645373403904614299849195912582296133959379433345565016567741931335625290471130543669761269131288801034792757194817191531526755276351532583245577203269712751221602288127458527879313074217158615132008181569424322336253224502780765144680746065336251175723894811586804640303488852342550155269676626201010807909622127662722376327931022635960798898746160622831216866553458504893223e65")),
           ef_complex(e_float("-3.2330058856604205217575651125775153796606745515255346022875185681648403282557420407207913143279487569591523706191466556186292655350726848725386973250822105168313841064642215342602553314983020620446092667111608375660747065567851185465154650178937452795976265452393683963177304417247493211290933121451671996536654590992093710204889143499103958353472391072490574109107869636801585338263448308316000003286e67"), e_float("5.481536547017477404784827002275321451296958472520956503230848670978055253433463751731157259064193440570325956696538173175612371177996673172489945992525136414544665843333485277936240386756905092791977908337938973999350471465075275889161485837251394957844613761896939548273088049786978425533787884221970882470804294580037589905405279962817172926959730367428536014161510792517544652712230152475015712349e67")),
           ef_complex(e_float("-2.490328743911741565474232978610225956839252535928559748786214052078092170711378114779553441365246013530709365913011888419770418119713953815453774408328795222379716275164688182250505819602590210711194946211713207912295862281758018534131789522348057415913569182324804899108416749471215262724763877845214580496264723490567590218052135939503651017450879686403265948980718732393980405365114663257818420084e70"), e_float("-1.521143519050587625720555382903473181401734774162089791872867688163158474461170278432211825720505402159973134771380918906858171763474569425565740681286305717094558040692190683184276888953306551744495419723628368985977508311788846044092053188077671113051136411184481166654506758861379366118593709158285970428678489572819101947531809382632127300745111072936535227112184442322186881964550332454993347663e69")),
           ef_complex(e_float("-4.0248454574801798340392936787414757876458564937160385978346205530026183808822243325172670347897164489805461461637245148872860778065205862941336970665409642834761358511788453416324423510214354064315107705943165291739221844558001547334860612624725875983739187441927004876036972059414224428994897965789953736795230723604463637464580719751192095270000965378759161281418271473391363096966528673902426228362e72"), e_float("-9.2499429019517739039123333006266805309882608326491073429799520043671428312190640501900827765750080324244946768019501084429482114130081938346802412542465962879790107258030260812016773259169944156843847128402456259109809997373908433254500848049312033148444129800455741118692371005688005846876739494315462296462350079537874245688369317653929809270819635000541222305456782106979105170770342446625457417976e72")),
           ef_complex(e_float("2.6729700414474563454437644816444188391052501559209051061162256929164134642078165892598864794718561074647227349505643316006513593552697387250059734582472770646824065727834230117542219576111894268260856655467437057119888142683719606296833592051823157827769310759225911909003077993593407765810213777809486201552994747673305877646002681159062264339193026417206570068723216578387182359791969032546428553941e75"), e_float("-3.2426725872716031300241600499911815784596281813882770280066496815905467400458903263426174666428318832452818095303624206058545034270433017974159717591099247115946664021438153079623080753255703599264382947094754674918553305727719767653780538512398249034332284571389871864856121598385328336647518045409525736409017111219341119425047685733194414310086384063097859997145897529890797080841362325460038335976e75")),
           ef_complex(e_float("1.7591675700123400153154584506910313939390826188621695521159439746979980632489182054402876772134090495867211501537192635738765406155543357167338416563929079884944303420911849755351043652732311199331668492986144797713772527583889320258620812095525108206416455954216509398258377265445635615873868169813577822636819527321007716262385209079582454548440311028773185277057465081059608923851275079875580823884e78"), e_float("3.911419447643168847787889363563703113746893521069392048138937500621166904018903360057444524146749296946400689447584699691027208085831473281612176160345499538748303540326569346525462137191799001897790740390136696678431250281024198019031627080259560690818144501869615109569961388558475978650122811701332696791378014983784555437841168573984364159341181419927238365259412278914480213600349730763568213696e77")),
           ef_complex(e_float("1.9778285983347596884766590768420477687433189962614215341081637889401568190252894778239905095303598494552544170080477978367341735229564797461425451287615988654309419964279465018744352596659593694033036543964086290520111074072815409335957735183951009794295495402206884246697559634614968857543190911832578706165813240410076290422298533963502797327363059697576854756230391258373641252158193136805952003155e80"), e_float("7.6989774230532222970629218075614836636235539434739922186468110341167612075113182146493211245004657926766783319905768275297506571462292688695687969818343142250502261766336093477655855042434924404812824938876619772514215449124074221363532603846383568112685722942681938038454537483535684361673780332398582552607156576488195656758176037540705154018123984331191014641091481656953370693973334077290489355291e80")),
           ef_complex(e_float("-2.7058931757192714310954549681239149492711837623827024696930264357857578839212544159303069516805289378179163832225135651707517737762182630426928184700806845168760556020157144026572442056325220364646856403288706571824805864146837677574580460966464963070505768773936943558019959662284419364011246587204196433759467347021866967795749113858910442121002090029843821531362192040861134520425559989259376123351e83"), e_float("2.3798044145026574048261634577539510944922577819909970874626557625393862759940326579604541610356031419186167443939814753199856806963871817191898260766061496692272101450567429813168879560862196993364801733710234080757710262702665962521385748089753969533753859955520775604033389135125564513865245567153089034571722554461717303465685970276191370741915816644446726229783157076107814695671495838661310857801e83")),
           ef_complex(e_float("-1.5581150674904980958286877061412381844143632141366993990264509967698856329680887615581477766601999127669974603846555359588925589311898013860452984299826063648040748049106018362243175852806220129318515958644071492972500536362314349520931432917342521330607793521355999955687627909332453235464012430425778647045372009823964459040744790242765002915882543015423222122642817110733695602029687056220458446797e86"), e_float("-6.220221677762044311139973147401621470713407178182129818181178673372905114973501021017096110774932395832955656679389395367865181387047157452665952251223423202985729270654807528908657270192330459669727169420351956753089068288280614952108709913276518305155345566038967378683705995917975291926695294858442427360004767374806712640360218696780382156289914784157425312300158500339104019278116985098125304012e85")),
           ef_complex(e_float("-7.163493456389889187356945572761244891146392373549116233083731138504198846414627348168151693101489338392043022676796735684270135457735180209179344346280964231006396777421665154256667983108059228975707864178328975828762753062858193083652096881284966000349865915986654913881392763073281505856955959916334318071326417845891618650865573591602971936982197595966322003768618134206432084045680153533876534815e87"), e_float("-7.9839625051186533169932450065988380870284940878627417231906025585716601004266484323760513942526543080401992796522839070681937855340273898361712649921005343645958713659907456277172872429528906754014902585124086402513455936899379562325195143374432488125618352765152430434594668373450492309036508338574583187141737164500960868601312502005038361733083303114721359557241599679936066209367158873725122777006e88")),
           ef_complex(e_float("3.3311747693294577570514951539301902621953952840422207107648302694914600989550050950980664131895233918285251678707637691658679806789728819717124408062085782496173963487400081628584254014286270210941168277113870054925867171945682671600680311137910033958439508349034953909774036464828437180576101019095409669930170356417178143533701401267671944378276939430800186971463812828550532473948464783862781779307e91"), e_float("-2.0816618721510343929946530624464752505318452291723180000522673071244731374864084660560839193847297705038783145725982960253030045797853090539256552251709279369471597782772186715324190391816478457262771782485187726737695038177787463851109979956634713265109086128232325354397785555210396844970075447723041433179351565876330912612327047698968200505982183581692587322186313472155454958247724976941938674347e91")),
           ef_complex(e_float("1.6886580766865477090542206764497708130221085518713148377460664931274922655236353837221419369969171488137091970455423159511799411769401479814974161066875949739275520679042560078333908087586973114307319323465075804331334678422552148406187921869222318576570804737287632257201255169082264498476945581170380474702494392901285499880510607695137261313706561372492257443441009815465276411694454695305624230939e94"), e_float("1.0202127779083439088665750507523993875612397632752041072473646258702390853823859963921872381781189209704406143840455122255197262234167693627671523442018714221080893275318617097474161665307080570833545630190434583856193282274049955178172611276984076581556653070497903424387928855604014064383815069461510378609876883709000926664623486161872689529478952518322400885467936435400613990888645782922192700582e94")),
           ef_complex(e_float("-7.595911415751356664842029882160898985489601590486879853589505871633931475240252814891571593771978215448538994395679223920735249778010979560934786163794361375918750563806575019295040621205871736648678459999457219467164810298229951161271696482934211935719347895261342503163473659788946358385332785170194678123817847358101521828030605190007191372230144892094835115618019743053939493413684139916886217165e95"), e_float("1.01217390257273562624151851022654588556298003003844354962927828875148079210012056105646238944157080675863818929831249291125240172384222177806522719745003083754999571663115131969658975604333591013679677898337776041610392589127727383620526731848565142055432481367170433473271755577954610320470334860282954012011904503093311697687091322203289073105390446463060814503478955430609659947110446226531335884986e97")),
           ef_complex(e_float("-4.9375866552919655038021249569636163208987484934094257585903923165252139341617229582998663330325232947642560111193324693081125456367524823233895451496715028979461763709418846743670908008389004114571687558809107644453592979177655974025521576523914175437326207648308375050308231086673586034178311319555909917923166740529013235795091988711567686639727204464541817266831703669558089244878563460656645452039e99"), e_float("2.0495169166806173665043731423683493202878722014969609385888084975242249357027032875234488222234637082996152780718314817920726039052626141030172607201309096133931741735384958163480877512439522222772446453323308546697888407490916532616920007136993463130039490523641026464325735492126630032444451238144382118901659651471422064613013342309778392619214403585761332763987367243413212315974093789680491071748e99")),
           ef_complex(e_float("-2.1863496511762397641358975066942090602365863144922990119982358605175017788960384161175038288779980905854609270396015650574326697470180061404321167075071658533561742038682099688911480310182263705225427401353480644607217644034284529325254665869175223183514031113490924836040892298952758194718984562460967323470735101944128385961301333418830929422684986551353210551405770096969763093257267455772215145232e102"), e_float("-1.8762267564887645071324835882571790004220628694892341428998331033182256632808516629846026053223021980692258766408033621126196541724292191525271226105008269972321001757214406954994086435269873877945231081720767059396797544949403300118677506414482257152528323880357136774895593602994788706936260671301872714784502291949291853736454936855116022249784476929133577630172372847867758729804905112179944762238e102")),
           ef_complex(e_float("3.793585217184926466338758148331996116954502045101469334818907984713312578555622130992005187522326109656602768050136320356556625088633920166648869107930787747913637929348529814313280807476962765656141474184199309190772980741587060077542410116687327725571763157330570744867024477857858424699134325596812415288073497595296318817817879145316298768391931266378669116731191171387718912752750171624632202816e104"), e_float("-1.541809542722051956039009711097749291683504368599152455983458439246356987937324075601409375055127229054701347625751764272162932928706632243032803266914347964976120506228342820883457485035671378078928164347321603865468930668698001342428461925504359607767418927268771602693924796918145620361099935415697681769564795083187897846616863933752157814876167629491282761348075315046392014519619409744444936144e105")),
           ef_complex(e_float("8.7159915412641145583532035997377685241104141130114240707686680074017104466246740721594155341750610016274469746569072733428170832226657115557927522039336009898548670792105712838040076034261397440394445248712494735642454117606192431239326849194494800070113532220023569977147430697224623800568822110180195438720348761734109723915619401026625068019392350821077064321265055193039509744865557907848276658966e107"), e_float("-2.0088249063121346642053071861751938286029582754970632680425588602281464417082632317586107801416113911911077388051717110662820278000530189103630029954907497304646656190553243800407095770132405554547146837861975941416355733242587237092934026754897891008987948418322903810155665726790895478565803676322194153665262193751370030653410856670081930029425496903020786693112863483947386015576047207360034882759e107")),
           ef_complex(e_float("3.2931636450576275241489550300986788859620988962869729506010098444889130042216927131074260885515364838909042183640628867084240224165986485152029310568132698108336631228282211665341465279629123456764181966758129982839214374900613626672279505192681254935150167451034145181503126167371678138431179541470035023398524440738413576683662950271497278327829221861730811611134817692600299605926214975660329273754e110"), e_float("3.9567043339344808886727318618913678996282158889327129647360531130533228031386558098813325707423358823850732717220647104319809479892922081228635563677688548761846062802904246029217382971502052141776168552388423317296711228038133509097817419901649765072380230209466537902471314325039298020995170542046294197329801672081423992816002249744896866908078174773733487475979146259679333939962863405095596191878e110")),
           ef_complex(e_float("-1.2038591332329265469992346791052649544608309754745032910916435021554906564645429400095708552884890515311711364942580799188791688135704179458136265853665290419053637001701309072416959313924736630105164265258171176897002209977443825909051462378067306450517579828872846971702400196606266210104354549286774698489775635482688706811278267991188782402843247254840185237252937207810434962973583036496590452453e113"), e_float("2.7757721410534226424927871983742054923351695622912297658923541671570428987377854146175123031287792807234599183970140435503997084156719325134834554913792780741038999187565394832467320495182611134218942253145059191477804132266505146883527735723820145166930334875205569845253404743479787676583559460533019792370540140534087810351056514522806550417694153161727219725725720416005139782952485217123286537965e113")),
           ef_complex(e_float("-1.8121071972298809658613161912910239096438474204136589948531456487200433645806822626127102096744353541500960644155801848972792150063015890007669052147990026306345482529705690383446673890815753539743719795824744998409514387227701023268744919554525905880251908912305554858950502113018201517354744580461394138392099630131410099302022678163385387385374597992483546427497623999959318610016510848028019108251e116"), e_float("1.053705439293482688890367069520541254381936783141015763150542732803479824547048460771863473900169782293192306830303278606331520078616801464113324054282911344260328346092487070361706485733589982956742107669191376449570709936117262368646287243512913920089978692942313935272140912265646769844478202716725982830588814108373038779203656439171037132002420147142375810770115733759197088004019075907553162411e115")),
           ef_complex(e_float("-5.5714887632270268403423380752411357935527796600943600593494646208105535449728452924800597112312659123681050943444205997981040689863191288670335826960105084583650802042024527669711644339354749621879588920734154858461199878891348596882496047759493697885758254748632808006901353566873178753253640064300787384054116087557945328350837010997816672504869377059452827385528836879571721062727584579603419529188e118"), e_float("-9.6135467854579144017936599988801353532653396320249744474321524685864570841607853945357853316887490682521886384097174603543098622256560237564038539411925235448165190180249996351990198575048766682270051890045609953747963247248613826232339075594635839992089267639708259913655349502151217246356578409228978607812939325107413431056699944375669322103586872019326438688913259699765311992675666854230752552248e118")),
           ef_complex(e_float("3.7931818741589199371815281357202944368599088846604728060544787333011482547962600807712712683915719288632848226261660568826338456793991722295767347373212779994439130486803486723528335106812317427670064229710374121514054971284187376251767719051224220006579760904870894640438502170046258897816871092939421157558466474988045341953526514857381194725283796330929919395237684604201557234263470837370518758309e121"), e_float("-5.8083140028218812800304106878502018182187614184631021641008757781524230331841488600753159248163268151357904722530966928737143955048649790108024096928858725741293923763879156129107845421144572058608346057219853751107635115421448025214993114708699985019212758064237890909299767387332996813714607313068710438908446020824748079682961081341906833247393756935811057248167618238482806816727494178103433996585e121")),
           ef_complex(e_float("4.3882626729267009238610973346447629128870353368623594296889367959049561528303546574824764065644819772428144846255660451129314000682644636909969545737410462505218335675160505434934296670201222096328137611038704046079141176228578643182693610038359201648810429217620722223337146882443098436503641340688223722588137060528558533781912435392125971441757234596516824759573439229221010693096536547352589091079e124"), e_float("4.918629691907486498381759793738680220288060230563199555791749658653938924472960944603731934974860647344728449129969322169846154762251197494945936915409411181717148694412559006192491386458546087586638391039044201082952343526988478609145325460523561372899048019037460867103797619860554628197769070964230723084355880729687398538968938966314648587300009331812291029962891082838751288435813673151087334131e123")),
           ef_complex(e_float("9.961518486624553014948170792730817434601488648196974277989194457299098104276801112059146970443248467114005905216570087744101126873283903851416794411802292154657024702758144853614983722795357173672245129589046265064943157916580860207785388733913509249828449897542422935189277555777077101241157161605211636549423243492041897501177584242254125267081399219113795411334255393777372891739140511811136367847e126"), e_float("2.6858186595785433010634203991266644310478740687866623482657615484862951072784833038572920518078356817285053568857737272951880443685099047993240767448245647985491592703185663357510943578443863565136367885066942184414865148914448882270840928946014870349908921517374073028040592372906305475902153227203601627286773385133679978751279899242310679933520446064973237574196344915110560991108457408190262391999e127")),
           ef_complex(e_float("-1.2890770658826931771587555164454540897549661753202827868529682773341304559528172124934292984629327292066999516619762637374823920463136709384339761367988498122788972567377269605482243081065017378188310859836959143862716763782727520942726066173215591750974732980636657779190929633384463500710692923485115477591223451347487645847102870589594039834417422117432509455632423356471362237976660981499104484803e130"), e_float("1.3866246627900820710278316828410217363067306024179496190830666199689300064107764722493058214870570599893465527898581688754447169428743401563867972705459235177389347731168319408710204718171748520646662501172145080932042763377865403773839326914639384505319896229991254256054769485866586121235822911719146496541895506890920130122518262374736520216182592562498420226398747567803721418815980767835009980788e130")),
           ef_complex(e_float("-1.22389559203672404703928655759406777093730273522891517272233612571440029041644156321367526359978561236503025997048828662074640860983996733045042866673203185433585905840428284038087640932052779759252510561129217497194006767718046869771369023225343354524926859283945933160465177239087012290338781898510543675265834509949051396648088856359992234891443858418035692557920186310717656554321297851140148058717e133"), e_float("-3.5510569975678670744749482831165936723273446525618596431493054346814980152869305808952401036904012842666816973454016085535352516615576830643113977238470986611692729498870306466840033060086414631252412338223927758632172137525071088238275701901174664783617818864589861996639819572507258254369509980036981529970729528391321117511820567318071282010278314419260321968351251420663465769222122664320973618327e132")),
           ef_complex(e_float("-1.5985205055881574322742263136775605174518700645031662981957310956397855820287168559052849249802609307773230013976296460452685871112780514235941232238368156112306832152539970281600570374054090051586686145142742222266429309310762752439058870158368141306840801554330052480844195072010712359742875491164790501820917909389114545880661669707431396260571403370352733050441801836400650026970016299936187805826e135"), e_float("-8.5856841062381143496410885881562458799566721105830035533178828547354421080492358137151510362923265481292218999035857366744415336143264712271431917690456071891509928071206670342545697058563852860816072540893979430800825637284301039444700087933830057852946575663411354730039452284113465855341849553959830158050347449579304755643086200871669330438780175312400788853023530672760898025902595724756142448866e135")),
           ef_complex(e_float("4.8475307330491445225893432776213065389596821032362555751786990537342984428305666181946986692658801799664635630565382880575319996671641838004701940023629455951579096247612232026116059316809605037978461899553238075387151088805109225094151207237494261519707877785329106657657420084848336491298746636583627073972435303164308549078251538954795352497623886311924216714265562191465981876049425578059895921395e138"), e_float("-3.6885418312604065874549582341698943298471861486785677775386334386784324756470400834122913561154212186403729788846139280967497920724519601926451835438781298154286598621565816383924723111138600117282946583812099869879215682087237998211489234296618746074466028282229238515130351885502504946458080856563360036693174867921733304100757013763963575367598149712557372819343215842259679311977089270711070065627e138")),
           ef_complex(e_float("3.8847927657959311008012825514371444126332551609054560876753252174170796634494179709792641533705713991997853578411137627640302098651766307055560943843037707161332169471547133100705543633662806940353639677872900136493515495643712148044603846904673321268578971963535292578553040984602486961596817440678350187808046650521965217663486471186612279003348795266807393360119089204410960211294866988586575473917e141"), e_float("1.896097893496291755434546729635610115431487235176684495160830902986947152688943898980269851760034885528757872429057461837708595273478868064615887903759062361899424101429378073662646342501167959597700073377680277917549182287009853386565760598193138867193768054956227449109836949792813533367835424426665354870658597633444558507337055985394674366731187150227178510097812220707986366365604761796340087571e141")),
           ef_complex(e_float("3.78382794787011819973793335546236946169000881024384145276863373196414677488595639548565884339831663872204589897066352093456262440111846986134053528345531767319435462373488282426347196348172786037277825231231505577126395033157250620494388922024172342644484967939838138296780539669772994256895569816869154809459479059997017358765321751002998357133127426578810931381406273668068589931717156897190824481e142"), e_float("3.1202343150188436472608785679889814509845031419713627430258414681918057472632610209607414460111117691177530725969811278381671582725922322935153067981187075380566801875491123364148796115554407779733319485409838279421104089311076651889435423852148993798189944531684575801237174785833088188343947855311973502554962619165048073295349306216190823631687832641706306324716572539541217491944020841767981923808e144")),
           ef_complex(e_float("-2.0335690253902291222291622795878793619606315853332439660784446575365005980362914268067744893660975387994928019470264856136230242662073578734610974481072988399936138373956334091440826757814318824986112095718466609548375858102941945413013438966751847593726071790290980164910449335501966298701484911006832774489521090302426461484291164089321686647664003191646713333085240074955159936317682715496496403569e147"), e_float("1.054148038043907086542221458880883882678605663236744551395584251534876723214305888250133903519518513090013745709705960395328948442097143075935142114827611144164544398759901538900208866318283555097110761114658730890107910325024975800643187463322184816108827026247230815395602670469234242076761366755385518096436315114948477550301914777719573938030764579195808597622870708398920699051987690651674571621e147")),
           ef_complex(e_float("-1.3846281928756554655444064014205400192358791457597563944961871808601206995129222671483992912484905698548926398980348380131354105845690453467267114174255421550531994058864444710485193025791836440376941207835887217625397096534860040400885531389699436696832506071487778136180654818603672660090352504826446572841409665590198902850493140542986191561951596813586362876003733106763271076376306589868147292095e150"), e_float("-1.0022013040528751957603244424284581325794856304566111391549961886833520549612460519130351801838407401485031192280824341052324607115398903844978599532036074689294303361062895220334759124702132342898206011865673359275607731482464863205740679710904558372203514515986548373593282540303105641515863335704372994617853965959328621906326688992713657127311411012591835021447944190170324203361654596965163359405e150")),
           ef_complex(e_float("2.0725207375097952221133444730142771756519176587550656942136115931986852799909568301483599413418342371357853023958046239643633865056457988956563546327556286298311205839289727608603801314288586310222475736044195131232649507834508068111630850286174330762511138151951058817689289307615027716198081300308326962004556118205848094739139446035208269701225873391125510832467011948415401907698222619245484091081e152"), e_float("-1.27964988617184002695295992825316416723864905612340268102025875091728010339821176980117898116645057558084793668182172046992445966990026912889482103913963752769493331646622872120957377674646328285365046370442479871692486560424318076081037477271664068196831922423968591417451845935933618699648696579697638229831188459094985802889016767894595828073899114793008686101789576965048697664490056036622176901247e153")),
           ef_complex(e_float("9.5273424620330739607601345718355582481224786488904468951901377706442545971325353222562714601519386377737566599087303276762777301555079023720200060772324555816051566229275011472306295940669533179261863047043531269641171081121135747298019925647721160671993587555631097035304662076654632476681079958471487190535996526439655217940996577092980365938493123028018211583946766683219875106736513130688428793707e155"), e_float("-3.0028011702733684186709294313136513643659268767923069062254951185353182564623361564334866004022773806208041198519377675896486834800774145571617844998297267274728571144834434345665546313305318174576191249450737456128372708647162766494749341086447877554621463603001175599266787277313777245922931666891106584595242732673583785102991579669434333811375198132056652680638541779739776313732146492897061263638e155")),
           ef_complex(e_float("5.4497448712431506324785795386314785817716201555642736711835615765855551428535303281697104152953132555110962043104208999560045791757714688196608182540934378656218529085131580538812999119786321982753817871166077516393673601188551445272569456534403179529503694563716437598445019088503246090461960756688681641823530103996267701639389818919341696778184100688114529064511607091282277966471836029788491989537e158"), e_float("5.607389918711059954339079678363002437453325771977694720974810546512372776372494591132754220541061901003729759843707449589281600900622571472376533056574703910540238500455204872214397552969576213432923965630933077201149586643668730627126858425425180346577214695471632832373069687458856492999231183488008303822179680171453774910015139921848871526359767955767299296788779168104233183491940902812768845894e158")),
           ef_complex(e_float("-2.0371727226474407222861132484809878298506785608597914396930575684531636960467091854275103468293967382494335488391061349398977278765084750728171690115090865522914201435360633734019449531247616078741999149240386464860013907033356588732876333584571355094285354967824494362573636619450563321998070993742182102078079745777273566833684886141603112188701993876292359253290423711777175520968105546830954578337e161"), e_float("5.8727120287743419029129602427608520137683842255000897370901023211003466808580256897242051564609101356710796044613625877745647510178838137814003070015529003634960381470907746220069157631415744527149581791961507262515766773950797254599415653933705498826616769757452207977052002253593850642184840170290935661434735051188995285342310447047140323801644354242981018073045779541195547420430334059263412497645e161")),
           ef_complex(e_float("-4.9736199490555695078297011949270932959533124759051053384458621557506688589113666249448290923132904231029825464463869871621478797543721394122594661831163051385671164479110141219241084580269490148069273299184699225717259542426003403259322984284895617832359883449022895960716565267147373835287877138542529632423301597474152866499730422085942823565604580675019762915280097990925224367587222223762566449284e164"), e_float("6.593105926422344680472175597126327835588007474812078630184646291197611155842752590436686189331648556493669539469440530018915961401986439125495006800418686593237125861361788720249643096523137713322361301268303559376683876964670629900326979538939842532245072224640094968239514169716173734010918742672577490273839943248361454856762197909419132959369172501670398735750083315440096283333580932334852304709e163")),
           ef_complex(e_float("-2.3122665440437228239072909546452324757195273927410501092346155846477628305730891231208065825944940733673267674563228558143670209762561632333412388327724239627305227014893145127698030175055128212858397651248371879077899177494462352620396039623123650475164052451958981697241116878013938777875866925194898958973783149083190568989194643228375430884050591620493368658887336002560395004326233676681902196919e167"), e_float("-3.3985655026446037986136897361825859352352807730785283495410994206643224356846445367606787680500564419159870865177613178570111520888099154697908276558388756566946033331703273086730982160964677156331719062105824147955058691017846502009766596566355844353764692231186168396910670484208127933557984604619996491347153167099541837770251798603749326036039737565749252893422346322424310437091088986602441419535e167")),
           ef_complex(e_float("1.661946651342076143165528045264935867567379450065588651618889950024691529022166706182972903488016528866721908930331331934094003510390212934019283688640083845376534737011210284718817172865872721276213492496294712856162315025271860568729506147162999345848017453201799162049570157545789889466214754590538666426089200210339413262054422341995636745202953850092748080449861239781495385057323327161356879045e170"), e_float("-2.9866143673765884286940964419024155151047154668177967354156715351699309258009203807255026827105981771908006572512894303933245469861373768955118138232861529476665162656039009419937764562727022199641487473335000548672217777179786402955857750935452357330138848839029861074971033227443780182007597740168463817365693838128354946634857400265343236501547156680477344503948017907726598327584837559329297094512e170")),
           ef_complex(e_float("2.880965373924252300382045596197507906680962805925519812181777034346994899421510629789513495604800784246561324547138861362357923193710176118000106997890431891499954575461191078496419100915897912964907345727272597844206246315421694889033091635071270046434075057416587822290650854710363360390161157259051580260998275328346524488156661136753397278454652474417708160745028494479435979108853626586133855518e173"), e_float("1.218543172786940341281808999249000822068609318737800773421197028925113223759336176275546707785386997485872697177790602118664262894456002975496523171524032781074474102577202737185923071669165322144088945038074725575910371427034554581615715482004102820666886664407452042722625289257671809222267911388548815993133245307396123098813053063065693524655250102360187671938929249160717426466762411295279435005e172")),
           ef_complex(e_float("1.0134931964737716518739940409133774383499236203171350195869929923344136107976553638117193002777252151420375712378696929958150143216948151879034662523182528721712947582177786999321994416371153036317843231131832116657737499103431815117677100259705882487339580117484573845986862326405950299501666883449079755969260076438094732881315129874918366074923867552892996329149177708465963704892598117559162438441e176"), e_float("2.2501332401276257998565195143900268354093548952997747090560131726202456572707775923934528982733355200713900728755272832523699603354712110712192335181492515128458157763765946695848545245517088685448686137528258065361704701780429705289468571317592515768235474195928382618493746101144986662252395222639146770417638437449092033687791454967107988287058413161533460703126618608106174770129587349869631700858e176")),
           ef_complex(e_float("-1.3505785931717808708000747187087224103959330501135152134523334959874377756271192544998956572617673759671729110156536180540206927352254699367840098210549297523145861656220470502355883056319560367784723106829348127563119858640687161594710817958862240640520637542411927808874033246563250557538904442285739356450785637930808088171260861913295278338422403454095756146391677286538431288077421063695468334115e179"), e_float("1.6627224250664068164345791622745752756630338811845191629803901943864520963174103573456626947374804584635239490998709856617580761481091314690562288750743046694442809037946022575203616452001986789253846757752303791883376524722108165565797344738877495583297792003423890569553403390457899284452841752722550623720243867692631232803057827939433468665672535082175949927459122349842768349847133368702356659326e179")),
           ef_complex(e_float("-1.8413381915563714655746422328467869111377270869885197620227168569833021292584640655293918703241978615177748261752302823351166775211706275967243898385145927949294502479208303957395865163312287092242581419705719425474416025101269736686373027388271066390183710318989627918061286407073288385145150720042006807873517009813274006356254271252163610402401268830449519811886499492622551270921506044021805809936e182"), e_float("-4.055875868580517090519014216595312573904671961891885547662784752213467365715676683150985403442928200671213061117378604907144076793207943626770361046245542890973316654662191195140969437006510488486076682409969978743378589512442372376253610590159368284128163293507314906641421014984927656947883606946074727487713111957255671313707353458749841880173306140574277104514358408885542926877099353876154755754e181")),
           ef_complex(e_float("-4.138522008514724079595365365024343927291483237805442059152041791532950195338695273451164494032824584710154237943539557239500572283690880899255411198869517380611312507953734000425171414976371328891350660788199859025390816204097350998006741673866781068456481123618850872996134193632117676811238333173681326029710711213605935338681952138392112962692847322591883018000668617392379559124468540936166174692e184"), e_float("-1.6308414500018319201019056074911458313673100089455622829712330899612696220244469591141640624069356220571237031269370328119847726962678859933102517599144894413820520773295632186533887598993864219312574707501395511739697623674843057421131513673174037274110757760092999025206347041105529893467287301201594442404473089499607929264124282788887813779494042266291314090182707097927942219037563190803774266581e185")),
           ef_complex(e_float("1.150382898001337982865436166202604905241664591631809431727809387214108753379928508062106037663554582641384681789473216903855213554969667974172099061926843908658938675545201659426695683414217481633131296863865763666345515616180368873550882654030026144774061670761609162884875043414970527500602561140810688464928983599544972516512210259055929795044840294347207741497380830690392566691443094235884284241e188"), e_float("-9.964162032013978913486049914218455346639789883231568895990642803380238886206739061898344996668233365273015929790445159173520921550190397551270167981444425406870971177980475455185750864094893560130372449944084573443386135392311621919803460750536799716031049880360406301971960048312656942513119440182406382884001012878015698430016370927389845802393356921286231052932699054594315760569800953285605161172e187")),
           ef_complex(e_float("1.28946031694258455250650398470882157939007163980872246551618442626229158856696913632811002847066778414131383342984529384574715840909853976816939061305320269047335890609493857491740596916842824680484799447541702706200665866988489009140154242729030001151649244980563543782040039761757414717759398346845415725398483498325459948380738459489733392475824560386774477068200358304597643846109247116572384389048e191"), e_float("5.3268747215096542943188578245330593887091988031214868889061175572085860201572887887086941984531789448263655090699968832628819129206481190984422033900571416163115049725496914676578329242169235833837550396973958685013739170920827143412736972915032846556452107352155328537554444512107149380639134713498005342145604181105516263148469609490524047924281455978831046019383211205289581158276870378494814522835e190")),
           ef_complex(e_float("9.509125674106221129343933559221863236265722726199912079641423060828297996912975108666863627041853763120726459514710290263442111561940449882617531404118321253782994213288724774408396954955530064568494189092487534260796306058529091022942579056609511050091928019200560078013875159137151507331177908208988604857816825309576576687390070743665716196239523325621419665393146166989377808119912325769311261898e192"), e_float("1.29244652454778548547977183893251294023890152892290777723504022664489841926023758247380624081551803201818192188503261375456369001171621462969394798790782251325345385984395300409400410836844632748100863303930660047246015326689294580919616587179986325856375043960738410577684182472755140654959758550779241959917920275427652599666798709989861856939663759051064726849946200275607786971800987201467806477981e194")),
           ef_complex(e_float("-1.04689762487154930062938268118995039209140218115185560176499037579569914813939645399925052256595033207800270050168736413085618163308151357131904766479232833530850986504999997410773718983207795160338506383685411099261216632997965582770333801412503388100811905750406083884084224654766036466763062702350265079653682337658546793059987770123680872830306326247303269997652732546221889893962465105353671616763e197"), e_float("6.2555225169326669967017242036755650682562605477944777290317159051728905482028412399979184488024481983293235317679524334615697262740215020742219294620651391463211782238762518618231649984014133713132388621010721912448192442107185207149102395471565072872968552551059902365424886040470125120119869054338904404362139448013673277307833122104317002181145737758455595941427231884298836903725705155343118496856e196")),
           ef_complex(e_float("-9.805523438928449429022405789858476850222033284529579177602924791095231301090613915189766725046199221092574218537039407095321021104699740364194866955176223877011800876546826012909580670064817723842463827353525245862610665205945138358368209466973588587352750463525793388203497926623384573624127785189189866765174945765998201146433549097821185502532347909900754395492156231208627149994360642874773857232e199"), e_float("-6.2446361809431725859441049126036365214743227009035296254263515047209435332381187272736515196332030478979032776918703538551349132542090972735354977170100166750515811591202837899113311070743462952959200124986458027577815365268768395164316543952332867956784924064382233248091549441748661880172194145972787289944207154502800364335589081532548968061307415411377797385563370214337136058716316658692938425169e199")),
           ef_complex(e_float("1.1426428861132495705657898527182069542146015791395067433703376417563333777552164624335247556314187714382383658892992294355897073054521973471746404073308239951118018174983821890390072689858247948604378695409667680950435121469809601447325168932358913471507010870695997659335737966476279725183145196222152128971759829299412775686787032062972253713524795618403815780986841920805498519759481401912315729273e202"), e_float("-1.1164592222655098373374179914053811819028774185370743583964442130449050373587892407956598611705927341228373896742321200118614210261164438991358137735987123199956197366967144292440309667353487070579456537626681947423544497475477923756255915424639217770129564811331680091547206022740189518339435162139214001455939536341312725104192916744117033510252168665059990507321028874927418608453139816215020391584e203")),
           ef_complex(e_float("1.02560412958272468271746996326623552760214640551457077606711075368217390753932811840269730555091271873319112685734609944294914830804833271565489151684142666129416336221276851363698535741827763314267705991583557284511337203986207294999183851891766066488738621420945985349755960316380734396788049872147308661575035883619007582487134289472903426928011609844454501193612007605053354706858136920349564068481e206"), e_float("-3.8962637685169371295592973322607973978769033315441316441182450993973207306979098991832254049562906524887586089899800660151886454941843886026858242537904810208136312728114130274515781699661385913684199552427817617519740872516218539534886414578699495989009695718985814894888967830887353768215952134666500466250185257865964532527015553825005265527141564922601125948521935774460348800322028396522937679656e205")),
           ef_complex(e_float("7.9988226755938732844058621723189080130296334308944359797109370906235586700091969258083083164173888123592159360657318680926954828020560310420594580313203721269267577028139579070155263167316671592353627132752356130632746223626981463591185768442243250924673216115382573985903896352184990861600331498202476013119967583649673092921555815099442265663969346383759343427315087059575707606257219708604272165608e208"), e_float("7.3436647622322105615489886607456017872008364296664844366283829529730003837343758641908225993820459531321026097538106305196525461857119292768044952220700403762259454601976487529005526450079984282979168970060195821645549105281605942772616498674301988577856853767508241282580503198465796653288634541379163682847769496910450047229238959315187217300301890846108855621994313895970358285897094972737953168533e208")),
           ef_complex(e_float("-2.9829472764374869644982628356978395875113166944432920006611321085581362022468090324171590775416517403322994048016700061184675390338002828663949801491795629999314181283338258415793638730246515457042606143914717672234495362990261818934118143039204885968981846946250738973485975046291628503607815497764041337518994553770708848144525403906341555020372782288765532917201337822312213107099943876028260743488e211"), e_float("1.04625102979413377872046402556758454198281350273870782481802663911420347811057394321719258901649541211050909759446784468270156142587183930822453553062269448878823884321546067735808597236074442033531506523940161802600521993861811039277341494108028178254238391284440664361466168604753770184607790616663604259942070010631716856876119459083364686644173921800976443431532707259242775259478148471361250571763e212")),
           ef_complex(e_float("-1.08398741070992522316556682509528395599163995004159482813523127737197133186643721370450170665194128222797605291634188218577344461234324167148641233889477378664555923679858241063041765169116851706669999834382944950141127509337756535121154839709404085139905011669868441758472454140102864048371379631944658910620943028567951297856627203033246456744522203192105531557286281637994945588946712472362568747463e215"), e_float("2.0533998459540578987425094326087762171818848562678957905367781619815169027677322577391449695695916836999694020267244240227800345623177260020954404822276591477024693278373409380334842214120416344987918330870716099112749796927645860329558245021980277646567200919767437423292489664270974543477479172681007379921912650012478200327344624457764816320074486082817557569022882368247233744355405473778361271255e214")),
           ef_complex(e_float("-6.8712993693918884703051936700190948261424721870931172363358405306962196807800101753046013236214268175760980322328311837970937455251818934219397933705927405930003832741442597112356223282031333319884403014107989535030973239066688316689440462168538854058109305754981387003056213188259499868873864629664529762774780211085237848060195219190864795495676141652133440616565504109473248671072738724329292263755e217"), e_float("-8.9988514963685169719877349056094397401405324936061064814611585118204941967842305832547549960115746172484386061657003731881923014538372907301246281170339633923331187442181599167627223598061963845166983859157870534151110657760277636943673721662739240749043180262379058205060955151261046007844975912595311643125178705131438436416986586525506720908866525549870330539458116068417923056164008328332563498586e217")),
           ef_complex(e_float("5.1539213753923229858429002392923192591069243218439499775304740229085158902576858990763729814846414379742318869767916982667491246327810135502786987290590550361458349536153386541393467124027263760750410240681485971297193808525523300727355329813441096329920709008845543800174719617139109780148768106170990010603757814675202755400034488838006813708331853487358894814774176117070719729994731093810238534329e220"), e_float("-1.05674652095316256055783349723352585061790225082977556924262086559450409549168197664092261448528107743511173269279445297515007446815899420386331081517346168838958131718704402242483019024614601693588700137970577240668946488693962868457808993674322875226133868749526363361073958569156312127010464465869132891506812595987444156323994299490260843610297609325896066331490421531321553882405498468246373701455e221")),
           ef_complex(e_float("1.23513570052489365776695864280858276075745098978480681082233401551063405984270411938985494166082983923921299754674591934896745568372685895836891221615121945089050517760266774319518094103692007146211316361111543148472232217125598582175125689522136820842200998079343758348996056313818804147403748394837000243264137254405372434977379693684472811819949183882680822552617117240970769258236630046103891226765e224"), e_float("-1.36993192893065145212733973803677647726065586498208951213627510393001975785604251939205804165025310978196803192276277845329794600777937868505513205509959046393140314410736487277736113061625614830694939004174046355277262210664180994421690564181795903989012885374651095331717130063026860433114257696695179282817462844197619657202323401054307220625829101327738266088310666502795851120472683375173571045e222")),
           ef_complex(e_float("6.0144462997905643226193372155610336183786813137505515220185719171956830622966867776773393116397101754366025355944703153536175535654419961977156896758146451660849649993173265700424540595535795816490275500489412520189038871316772228317632214823526649831603047309045877885320777878575761912575806837925523260518623151995091693801279063303723080943546025509592560092038467670767049164176000663457155592583e226"), e_float("1.16684704014859435920001433549281575298148876023818350565059642034585835149380633708581831441090435899908416574833450566273869490490473454240138949249319698259472002505388697859421471995357957370192954802167118331092420254465135155071420983985520589281155693515188813519419110605819750486919013302496000606704774647641931876146510837835815401854089060388006473073225910706051500062618513936840850136571e227")),
           ef_complex(e_float("-8.3140720718249558603586583523741573208405405074142087778162094570575471563855158909380991678072199823370660289062275021721947593459810717030603396572477417678201920699158836425039711674764511948787447016150617147043351665542688832571685007603441893961474470420028553069289324246619385297658396772381404856167073556328896462341227790283427324600003491020860044792158052861292188706529192284849863768769e229"), e_float("1.14015168688972596257453721810503823140362509202993144938908352384972172664768838458230107697311832605428273949363589991856380799449081757264692379495186910852805943772978648050408811264236981152454484070637666180335081008945364152695372741062923868156438271869017626998540606554030801979050951380014777530503216074556687317178739013819253028142228549842418202483002904290810679142745589062827854425165e230")),
           ef_complex(e_float("-1.5130895458542331015379943753057909991877172195216433510697819348863490793426213013275661603550284077012171088146649190625811722921987622231549261322200008428639867698694743149908172471736179181396212038818326110781151827531513471022287699281581886600015608928081602581991396818630698281315018670574302694602598460138057083808743222267712744185980492806861594402246701694335182075310084947202585783705e233"), e_float("-2.523811933969764596876135951374977784831999110859639436006285228735749742146218628496037615818772023274321277355036315772299233258477104449420959072440875032426299328602801526054500978150974723074791617598947636671049504228585694885100563702777914695666824109019105922874254958205346239668549592141448407366537025495397507627820601800261335626211085183843932952310554058739700249778981290267639829838e232")),
           ef_complex(e_float("-4.974900045248523053805168569701135636151159730568765309661043075799633725954913862653725858835335195875316253859958187337388918829874036083133767082933076025527893440999602401207919982409725808293905099283524601380999897821787452187624127146918602745852031164021147612520241630773535685643535460670264516743996250247838326260145139381410231673134740149606752876003459715586914772810205861914110163955e235"), e_float("-1.6112070147801243171172051349687591072846342876474492845582486360603910649084807746980679115474971549158906449661838933175737384850619509158306253718365981654068297955820450144013146270172706481574399120293056535692909172948952812454027406159855749757069456453333755356109098957611843222976455802112028137910149220869281454007194192158726633476559257456150588030678552777061222195137214412421079176745e236")),
           ef_complex(e_float("1.3530065454880207011050261700121188793002416149312012806595349329275980442663412406742965629595573431760378992395181210587457213789586608961279885052343799444776125506279347607193680400561706304354399190102834980989371275947356344775680653620185129178153670059981383150583646458596585038970622785439586316495145176051329335757579847614956708758002790240108033032602463169756329959972800321111341114208e239"), e_float("-1.2968696013710774466970198467962273363398978625829776402460113019481725611251429098611401596864123940027822600097029316952636307186468094061556902048362424983982343272217012601410219147969227878936374448282517222741591681618680646180088552943847383548058686024547972768870711309421925471797789158830718473675189062847135694261897853586708028809903031889446304443437357795495021636853577805511398971678e239")),
           ef_complex(e_float("1.9839466721428803136467947548045558839543813882814422764035754498716013941984564522227565015599675234559096156419781342116150014937972170841829943363072395682688991585153328296376933623677746080651753665845805248593457108539732820272522315991885871625857710330932807353066735894068539065647475440296265714412850376081053392004316137236463080025106278961617756603620550119840645984430650110071228785272e242"), e_float("7.05967884993282543020951595906238423579562125829934453429000304508607968213315676846305352548590806099039164786874029270627574677484320628182200448500279860610086541527686718104200190277429861740766345419387384797466910954028381196607790731636470968365167080157305620834683052277421436217270411459775123354062864746269439774405163239428375303082259626151916564723659678202142202814155759207300745714e241")),
           ef_complex(e_float("2.930137926412314089668554222242364355658409091164807620408948336645039382525669107021008635938180261353466756390205234971317569708240270429478489938434728756905363179124291776173097558720996787808159442168388577508684972377539775414748807292690682991616580953982808438382253628287762997519384305810106939097288345059754054620040472348718054438540895740463523906105653576356117649176406910324721923185e244"), e_float("2.3736893193471859162461591220383872872464383620721219785475307886004743282592268390656741802362493875472122316299067492461737723998970554655922220808603498666992438806039522018495586375823817228899593283236767641026546618811189548401915022075286982590362616946371394522139081759385203406797311901124676252033653934169951103840600701712154439204832433230026017918696091885480097114448388773131588548569e245")),
           ef_complex(e_float("-2.2851906431877748994765371448369346375926046274333284502474952232647165515322303095707383745500706886964571677565011806710815843520087807698406427661687159451464944426903955182105448871064216145617064149999218314660673728732005566574656018375223832695243635172844670776353636565623282419421888281874426860860889322627940191285930053027683147886912245842505106215263402753216536257256496474143633173523e248"), e_float("1.5217636750354374160460109324342754215543677897413575987027062522659756397828408652915888670214344468609182480734902983292316116254352979059056324134931518519910831729925699207695445316886554596467486120282339203151979399574581275230823467960995340024588236360233845471603155880589958236233587236595027173661576684021442222656387616272194201934634190621103516358507557440488581792410266039478381801372e248")),
           ef_complex(e_float("-2.7661806652185970575790492099511863581703450960855525192399455484428169658867279023771660679355354797318661114282628133394911103707376831546242057237536609062299956423084934526917051670745542060845703055657242125638475341899599678684116846417651482413472663398065384795590307690903776129082565704039986580073977485272821431665804586178858308274136601235175127578739866500661401867603611997657688183994e251"), e_float("-1.5788974956601560896653852710921430764273568765368126297538071619733393333824840814417205093629328985600467594104315829410758305507576474847317709011838171974114982382111999156641007928212407478380885931787347868191702048734073704274154287119805007617687919835172020463280389800791557621973990374038665537535851364317211692465374404060428415425206798885551815605791567402347140570836303510158410092612e251")),
           ef_complex(e_float("2.016579400134782287968909805850011400330530518000654274735150275953386085350416270517291036825930074272316107389975269229072378078145445350118576986077334640445140798122830735825886731887979857520883449676846294437613895297298904377268590172689784153291668222899574500826401788391794054346995758186383292086552796690101068983314681051990409904247622942558714790564630368525932857178856527006314827781e253"), e_float("-3.7282968803718820243167736932653416436409227736330641048955661887314023810570852020455514089120180726974909862713342992141305615476121511558536634487098031454738957526579187102075198192321254770653929693884068464024587005436296902919785158983543687974962734252886146011353561118766503804139235760168115605182490057772570282711377994927701023345021910414993304196879045966787873303436956275854297361581e254")),
           ef_complex(e_float("4.0548378884337300538360388923603677104321410143353686832672998001981891181369290062340300872301986972430772682127130761777117794192896054006439036534656639969145565337201324548658525766907996811800183703897668760039858949665703143627319447830723079254658235000895229482802006136510004907045095661417669684329456224551029002907218791410740916632412687355298034376171012585947742662637842870464299719512e257"), e_float("-1.7651084249216227580014897791499397697623821486120995828028027134545514588063954599971270745329130286259035411625546576096972082979029767594362082244611342481272867934402923657579855489188179433994583254691435450324189948540792868284484472887705946775936032849412894157842206217938825352036544479793340021829010901217885540276354847699976368830565091142987107587849311426888857827380684909890409763416e257")),
           ef_complex(e_float("4.0622108630637716333246371581770592618833947860171953550795614116676594289701876618034176753190233803278391012544574217103068052907034112264444831245829268729911907919011854653209858836486979233448956255938660825290655230738404565313278913485289076386260607034669599083445919871887468517460163638013142696367557043633209382144874719326299903961554182709274129536389190795839722878983519533035776443122e260"), e_float("3.391382930860228654111401266200461147426962832179847356028595702150733782332018758155921107963246724479918582647132497588196739418039860215981922225456967761813057501075231536956179178182935343623820067938616672038560671625592044089527412001318793339538239283542483284212096101490495448439509324091334891994802950985735440850652436316642642343901217373948944821930506529163211693959912437366229881091e260")),
           ef_complex(e_float("-1.4649333745456300324382398679577024312979191501684239396839716223656011693069697028104142250103173020050605502707589200115794123328532433136718293214313400837079339577421165763170689557059544814565962953396598101423966897390827149993891216873569397846445545243127513513132614784134262615036606082594636757976597664951337971535396199299381698668540494475487379090503289919423027140705769342608404575507e263"), e_float("6.2265082139928098038451061596350047770619903153175608735737576964448683184915772747860524648561115447455758634744232499327693259017939505934845305446416028097588869178051574063985682203355868499646512020577024776675139208968467379860348637139631577975623492583568065078929704111732270102100188044158386417860888193488668043945982717739471615074278080969103628645321435968682257013372361904477180957377e263")),
           ef_complex(e_float("-7.597790920435448398360650438242817794002375755847571621934967675187082806562188218781649854372820919835374539684138852172450237779165391186707498512975772564522503926610839758493589144186244475860546697835314741141085068790269916505608859059131779410832066332471807727573961856250835197973091852694430725391506723857826342935676368445700576523498936305376589554402281202032747295228333527971724832183e266"), e_float("1.8068747249359611377060823372034253863527503059437671045618144084921533683152498466288531935899284908367427785410880751291037770946361519161031668573948893120616561125670724387653172186620034528121761180062337786223981181372819190253497003114031980481282668481062431885553615181489285811543682612207673325737253689153136590351811700020626230308454088500229324344644350786245370880960525403425370317758e266")),
           ef_complex(e_float("-6.189202887084280953312828823959608444662521123945090145818194168555153669102917242606439236604200494117133447126573774467037973010999676982633842027929651153141513210836282452602854216367454362852210138649608042816424422669139864017706172890204072035438292053271436772538268771035773895665323319846244248913640666770918988686902702617862430895508811394560030309745049795147063437070434737919282503205e269"), e_float("-7.3778110472471295043191177347224338517697042620922120613103343387970814725774458965378518327586742052795538100342185595393729199248893430037721020675941559992649130446807899108574086027006182956967616091607150738431231851474695055806813482009678503513766798195723873847951667084533471025665188027620068365595156968939722702739568921659484079502170464806855126635685591229453745576760091090520878022725e269")),
           ef_complex(e_float("4.7610601277578634308211944093723563035945772380803675165711125628240513053997446852591746261554487919663731859922862262780368832175559918739135176876395975638736533464217538689310050259517108338566684473254773026085849456658063795549605511192366669268493676135132428731685490625611304589369095946171148741356975413775477698490667473595197916151857806855550955254180162802038442846720797831770920841124e272"), e_float("-1.10063035676844411360199905557958973837654773675585414098327378070449551062401905968846136693827393519518306367690726527406220046470839743086287746831851468908299034635062300192143868803748408799479661586326727916005171755281483471781327509975131873089757885375071695453310438811219693419188824794508217320050049479166326053623480092932251380294880187573668152479970944173437418125230747743804159972131e273")),
           ef_complex(e_float("1.505510283008335058929652471919096544875676919450084204181756774016544964576282648176684391825478828194643259754712520354158098450746869495409255229412781356196302393156908905890719649529455465406064208308393876403243987968335522522316566998372377770056602057381160849916738186914713023219088778229089327985878151779896948440912994718466950208435498843128270083018650809458258301686291840343480044802e276"), e_float("-8.47425405191678017291597652483848932393755743991723123438145824597220415268314936593937550533913587994273730903705324783025330874621194291558738272859596986273368350506337794175260006614706460442421261575600054879592574107392977123821866863293067406671620405331079876117200763621426540693267071494149735388776510162035553172420302668482032573315975510532731689099120288641905262575437476651587586194e274")),
           ef_complex(e_float("9.524109720814685642000659756580693459227636857646509401568520756883835781489935557052571677055581658048323896841393418121452514717998932878640145534085969242126093344130327284315816294845152446402800646988899000677000927261882495504283817217640733115479084818956378188410677569977109219085182649069178923952944315048949143805179097565739186178010458375888312342036095248140186440789674481020345355216e278"), e_float("1.6606787532840887131150342483959086472677290341091671151788299207829883303681877782327517758549657325911671338597471689322615531561488669537787928386935698357867733802507281388560352564789933372032627875691739662334348007943574638315322126160884223838846471688940046469457622309774340820524945485961931776578468110167184255559715680183286014472302857334095834627901709763979083706832942318908270926963e279")),
           ef_complex(e_float("-1.3562457763378871617293675076113272539767718054540449424128752259100764139882434874997977682837651815276859089996073107784202440546803613529796909794333549441670080537739395437414339342851926700574409143443299751494389569751231469478077319160189916921363260049057005668435663784701237769297688440702605298584761041889319315416630459841290478168229042699807753620546895311285218700129348402842093219788e282"), e_float("2.0449182627948151515967605007121427934874924327412891837943174379549145555285416798663486163603296867285541457184088026958152003624135986799567202124793922576954255692408851131853640284128968312454145844956952620225038316100324021836386225997458735994714679234248255433491983727064613015466753528423822542901997046309825185680777534754334316947868886658310316295511029038044620612110220683018885528039e282")),
           ef_complex(e_float("-3.1517247469255860861704377116101302072153977816510315416498498603629321271617337416057785897750587060409197361864880260974999656898876231692515012710798516330006519653373153806504555340058455523346551762127558997404728754666801324484304193023382241178634645646251262557547111459273021299227264539405004987318990429483273539142560535388600913237614452596379187026363150511380998078374483735578332461654e285"), e_float("-3.837617953190730157859098957647860952158207748305326995443459454064075038458916366282389962407100913583417283979648731327598128445449931287771670387881431082577928825585079385260517834385992622181633125047686236499157635814025129274269230754607741932510307234556313148770009825930207032496125744969179219685892567013640855280450330915782119119340748896168184312013946820670351350958640908094229893647e284")),
           ef_complex(e_float("-1.3956881507397244422986170439925768993009894722153246354255981540152421924966753820193866662724520503072334313302820856998552146373700463099663583355367613170594856445804359100760234108511617793449411665459065042674094575140090965087290372745774840970458153245373818455708706289226406602870547693377367288134686626298720468959776549661268063008220382501083438338197427564889517259224015986967817954538e288"), e_float("-3.9048814533319134607028120956001449128169743881152805660566802365089201362953489449878371609106172496227606806578264482558099449275855625308989690979107351308589092791842316518669205541207892131618415806802664491301943279655992007448602811113373215903857816482195547250482980925612165135890826183901819405100001014731736877764699289735183730424239001542713567247912786696489023858182897734019372766971e288")),
           ef_complex(e_float("3.7782753985267852608232929313171273482973309024109943341773547635373372684522734775270903143218025151491501253514480800390003537073923796862377207828786914954095925625122875087259379134178622816847714919603229762450532377249963411535728035306944427195458756318499760303559389763002911872899345892725786081487405415723487971341586462397173999415011298455220973729601128690841686195173063222188454812354e291"), e_float("-3.9506223143117394967147786673141906993294980581049353412905899841818060828040495357101399202588868783627191607916621808796098525617288730017203028905862127604049478312660619558222429290854228864776408410638098408248441809067097601400681934288038468821052436372738030960564833252716744115418642122828856002321957430177588934819398590724431101087030515741661643440766027074288518053432534691195406484547e291")),
           ef_complex(e_float("6.950677362198610673496813364308172725355344346558155338826013440629431755407957464078519594076061787946326656885805536715934578972150052775074510890133902105251158861404568015476163273053077983920979440899290431307678544543329440056077627493710791256557313949688771402225906416617445614753548947937941549481376939717387984215477380450144750235273909796132091037195227123934491496297419998183145845204e294"), e_float("2.140156429226842905141401951166992508416914349867226769415669547473146102511650851642399550377045858548406067929954015359108062039748040275686243250869235863944752780938821549328327545306220389943027226065597114766243349706541160354122246823273360188036474454419207694394709522089414104692343745407527132401062562436679058254656773060379635447702752604751566038431643446170640323244092004753352149608e294")),
           ef_complex(e_float("1.6105292252439388704579446013489105808702887667241854980164622700034354149389765312266496818607212899080877338760952934807603938796437857050637300844663456828475620380044244540488213140507584344304277321429121686059180376715309461682822029583596894798634403921757303662583333110545230877369612060961602724241731655565946343421656593492682946246826387754803332676943771438259369417613538307554134984808e297"), e_float("9.6303934583559702355322577541493486799738373005372838044359655167753870802404957104973023978855348510331014721458337194527815747323077883459802359644329502111718582170759634147124486401789169299179630004751956257138553672801885967744089974023664868728208889046427936174777626546761270161045575688692344196282381223066040531331870322556064517283576849817951897686709550655840991655587919997780054127953e297")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_03023_z_poly_chebyshev_t(const bool b_write_output)
    {
      return TestCase_case_03023_z_poly_chebyshev_t().execute(b_write_output);
    }
  }
}
