
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02111_z_asin : public TestCaseImag
    {
    public:
      TestCase_case_02111_z_asin() { }
      virtual ~TestCase_case_02111_z_asin() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02111_z_asin");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + k;
          const e_float y = ef::catalan() + static_cast<INT32>(k * k);
          data[static_cast<std::size_t>(k)] = efz::asin(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.41975131944629608207155440964736910356761006994628109246737098314638177749685514838924469468493742753187599900042318249007837928197207546382891185185297877392449618733351208466295138732012964154002664503115737155458882344080848781774008524380969606306212226996848777423616586755497532083598575338315577670084341612439913341477100821617099650564271347216307662023964056460896895194964131135180717094062"), e_float("0.88352092590113826922174505266994835301242892254822451462697426481198906429269614534218947128085192289007127275580577843582163760525914592735432583039383395659780638508663338754133079099176216972806436106895858856916911814326403362755970549314241358683185728065006846141172548796166139972142216632600400970591267262018062907016156681823679786014182452263513872675016196010844907896291619818621946206153")),
           ef_complex(e_float("0.6499889678211748547771333038038250563165262277211791980602208495692017431732491384070147186362686890801274768234435167110779506443389874012335684108404238032922296059636787090843651756599221847146054583316675608172385029870293752792643174527965133214794459458969310411439589684433660655372673044472651058346534176812565712140110212698664011060220419801129785679964655600093121665637981607232577723559"), e_float("1.6120188351214433861687445426692401978310423820192766877558441436465537733040649638719321675501249173420648652984001535325847307393944752116589174951985361167401507289246080615824022859868730945166652592474207861055513633025684389841578101874379229803835643590578344918376787951106032592995999028333889289674743951221763482946278843933818575661856851330021168611353459554970126767626272119618866234028")),
           ef_complex(e_float("0.4762802132002759550638900383271272572745098034224562679855868667261270205740473151665291658782836949635602673179041434837029507381219010533691892409115321701888606076175822670053559673701578415915253733461714120514823993018967974484574563025585459253349511217365576136857930429645007737840406039384399767707719060140627115482032125052703507273379898132371413390213803621220093049009090543211718283842"), e_float("2.4116955836053260750523721053189742038337405672941060538837458524958004936663361205564702270702020809232655039516553926684882796558621750311673025673685575678996426544026365316913664398376125649690646664602634168632082532210683188670833406731888351484362263419055254224007581642579112002867781710390372648260347170705829627283453914234379285775452723173824138642356585381958535153282163831698331574017")),
           ef_complex(e_float("0.3447932807175108852387569333108025968885960284508116134272313714888106875163143199027356777644629353537506200367760740842777569340135590634442468222231743395091439063249249020598860528527240351958569091561865930637987878402818257874113825693513843077724098724667821877728238184010710583408291299511326201329485777398591148494045127350468915384568953914630667051396909970253206998310328071153995946702"), e_float("3.0501955269052569761084637087111950434790658482848560917919526844266943298338120385699427356443900623215818019650066175421124165485102429780305997259046207481996634782670119683665016520397789757079241661395699405487515509214895126174041821882685040828166326674334126599351017226116515724565287190190140440236751684460710610217499130220554945251889242322071158276327644253563367185021060062471016532353")),
           ef_complex(e_float("0.2638478778147359205221278666252396359056379717487752176326937759235344244292284239551009747250514632955785076445304706880696308535141987357182627908522708623200092165877242411069683891408723770893298565980088577420096251011878852933821804483634045284850095523813248602167919350297622315614287023313507794956003135573476310816910621691323722505001200234706164444310428022268542517751416620368093528348"), e_float("3.557437691819103470233064100136284018364316398260030015165248699355289100078236349808728554603135180204262899979671214051238892699946074112691782735066664587716263405568655142326486907653920426411123156392985706172273242622540073377954952706167859300727698087311184527016215510726207880070345265752663326872053724055114964293772644318634639533964489407412727620074884066110119854348660768567042255562")),
           ef_complex(e_float("0.2118248011104677526072923853968682698505713341438832678971989103598523423032188515101611235196826352151547780565230748090769488584778095263172635671936910864980045513257484509515377043781362034957762379507157310885950767188197041985731064056303167139934708132791089166883427766869534888957140767192250893328526221517183408083777009609622622021514103367911183330944737860838133140686478661652024769142"), e_float("3.9709666561624879584104064431626114736280767493898197560187477435807016893069593232663755368030534673324900967838101410154133493139640649633569165214430343396489451228910426739104769117142933143910951008922260570765652333772454095992929227288423580681216813308350633580089085852039622101795950946801338125378120732812426187325887671956267108638681659712612741124070470960035520127336386738840177913439")),
           ef_complex(e_float("0.1762557521217915505056374629141634291918135830583171968292423995917053750392939096358935105044070789870099042908531522437979986528626922840048361325719747109136377481717511755173741931799642572460538396533153488591705422300644608947166372344415704616710286832089620935995426305062124237643559389209837429251220304577399606789724030820953407319737317619305604802909571234910738163682973361836561716068"), e_float("4.3175832125800969181756252387468090023376746480165923932404977521745052416093750430329093227255041859178911299339885032197088498044277739020272570576059739223413729055379488292228401221126135278645058187681224649068126809603770016221999529808721561611470739510422470545603550875356578481127840172652312969696883112819383959100814828481009563807167987869293952560031772782293703027896019075288027885601")),
           ef_complex(e_float("0.150620228464000129487546643499482256825327808941953701296540895314825072142835860121398051393948642537975637136272727182604766909969312239206549458256712086340858202168203576348366625656631226341148157255662303734589173107775454728626303390773438803167756846694242002091865127602553265455627681870736401424049108427267035430648016243807259534811711781696810994783049425846173198704511259240999253534"), e_float("4.6149725248415864072320185806500179739571064376005293421016821468178453326941153241231397688242305583567792390358287880562959622765252916643598002898895315233153742636975144012031611361472614487361645057749520341663943261833214862612956718936534987725534420484191064285827065405479103737253519458572647938920007227373009739519867882169902498973562814751333561196092555652074052860542900290962783836904")),
           ef_complex(e_float("0.1313519096040158778706646018701381231815987216259091407282651661775872475926396249754210031931740844313862951173617822175748524583506407990102608566185986059097766614538970874975705505122156978750451734650929286959419373362075440485779662280208155971919308480063630303800077298378825379355151599983568200184074959117276894193233894628000385404722981230052811164969534219690741960723107130991396001416"), e_float("4.8749506623678544509422396534572199146790645533534109545380004189982063687626965324188811683739485340888067241784325680640531644560743837714366933403204247259750485737375818480053150494906959967173733260243087054421760933394108960182112445903053746523440400336442093479920159857180698865141305712859379642258417631089471234185857534324151556567263890263200512810637696677420301158222341430132572368021")),
           ef_complex(e_float("0.1163782680886568281104051808785164448424063636484445084522874031401660954322415955966419549287545038060978262111075397808336768059615429573474515631124225116801457911191123024794915059328829411867362101481340610261882263239111785986694046251301808470093149189247027225980744814485759130353789485798697421031351080301019159109308841678230434102045833473279757990640313443070066214275108382757822487624"), e_float("5.1056651372597638706445116713449610155926309743876837765330019199964509381349552054756756817307240413259897567820306477183933664462006681186847447335213012157371959891505995815754371388028609367143825556795465186556794045853934825561223753886643943638942726469709230213498898608224297505981772120285927989994796021733963332006035963921013915576214783727071789024415994000723411656439418551091903380363")),
           ef_complex(e_float("0.1044257822937406466395896842662328732804402986522416537048895951935093557841933898175055401649281644234916789941664687271160557826326473974782048909168782420505561302332605655592950314256936158098157215750207177235727308537313513693087775097156094173095853860554773543142792626264379097003026808073889106534667697475673708683233262101911942367744033178578232434397986490391205771969945563932121467617"), e_float("5.3129219182550612974717177975249025271865198920077143834162223920257313148870457121638590435162390591348655981322086953984450826648943403576816439118122375673666301740390875719843978834617096795563083776934626776818161792917577162603186372026963335336368116226572890234566907484119595378839913424361703312075519110966010819604645221770749248109694402011506261171421246685030907350589153070210557289139")),
           ef_complex(e_float("0.094673580513803665981434793766003762632654344442976207139575749254326228799007590451585132534729667231278479438330727660207697069021338883553873159571726595801734299564510199752938551011261291951012734970326913722279566388818948051921364179975668087673499524161810749517906829433729234177216028870852051482988119557987386615533543421075307805143667500153867408909227819353631843033029113533800478475"), e_float("5.5009841045640639021592528350419669019223125841878550562956569075367738772161882216967502701209225193513428669645751476233530634662847800342592078690136252854795968486291750742674493059589919335577603424388761665902465840540658395802362397688057455101340171815778416989692563595919183364946921267126967458521841651331011630461555974785948019448453034317104983591974831863851109272506907958759765663594")),
           ef_complex(e_float("0.0865707480182475089642002533851984147476242741121412480177084475882872245208237516947002474509111085242269310152712856897610400287416199327246216742494924778662573767349031027746640600985457442644723290716212384636040416957193820078852083885296920461609162958459065979662171563517745673348410954634608477818163124448781252925412131704868287800410449088080683481535574339714824476044266387324554968845"), e_float("5.6730649597505299428564015479035022893306350290862200700187928612574880481211192483516653698250225245676140672669386021790579849398245135184995280493022278374446766125849479397153125795554744899043091255610685110553543767820972993169049643398255513295782128787091679389843437207863382299284094326153765522234451993622212761764817309973629081572954470812860394860468607483566385844545601583775777064861")),
           ef_complex(e_float("0.0797346932283293262945056111021691757610044594986728468879347519799225224502482479413131951263033293972586396426543774994803964158219012287519429835286942400437091573288635956578836515905438648104726710291604953537969287363955315141585281001573001724026636156852689592104394279125608264359015194902646886875971568138889482982296739307442939875010142627772989723946608526400270454156230665918724471427"), e_float("5.8316419640442112160448130709350765386381329122886933489322459356929206109670523086895759134768496605619357858269122694166487387629814853689004897916735867965718396454438735992390604927064797071439777673015485498252159605855147620388117385929419304346897804121795133729053200877201171595591114592575225650498736148011831413034813848641945118255682818346955893987955838336790446277946208942049803325492")),
           ef_complex(e_float("0.073891869491231905954311425654386418079667219713722311276731808146383672448195747851044364802042091564291329178793437165552912548503191587070792660461270863647177643582795526858077716748352366405606884954696879228149575405282301111265185636754166537418905658909335825878627662728114303642078287059645181643066841494060570595237000636215091944208031499630079269267699869941284087580159731484518190012"), e_float("5.9786631519261654641746281385327891665907624629492383217604240708067533816267000539274102628245941497719413677035056960005166944300108982457192781031665801306863071249352199246635004808608659471892968350948871465641189513390816398532790699393874961497921859199455885862926855929900564398331274310488989136957896969721251277390324843733865660364579177306421947182118616799697731000895171933230215265662")),
           ef_complex(e_float("0.0688417413760809884521793003394096111259085208579420197171689682135762461087827570088261579216255754348293044187550285455658774093471500647612334854772057682258602355169357336052083062618735052386087759141699918299459572714538070959385111291162170113401790560774305279429999814295000690012863699166990675752502447025235254562498462345675534809841088363740020812051411025782047206088354139504985765512"), e_float("6.1156866188297921789103119198328258642177444249038714635036841441669848822715370870635428344920184400700313057944861689584117762393040689331932802693561436911665969695023119286193378006448889059393495758764340437510930596233496825223412204151834733522837007461325714298253355804151493320023219015630467984833821887872096088739250211528502276975745397011246747302702468897120464587958552361902557484178")),
           ef_complex(e_float("0.0644340763696561655820011968542265183807606968186422510305796500184761232592499609176161007517921415784936672172316430810007396633788385150531615241366886110989171040546616617444730010274687691839614318360004714094788196756814565799279800928280906875271070684663393249680699168466047716234185381556048750090848969710548616031203810996419409414383419981591770077482746979314634358943884010509814234582"), e_float("6.2439773147919359750694225152062244860268688710303751085407500208750068616225106275820452938495089480719197229635537273781268165397258275342916344792915776453295693457460529795906105034701539380347600551899461508017089896007043184693977393163518565143841736512674904730770409816776698083393725444887178350092954538027944989316915893885707365841021086495578176849219126557482740168821414049820931031113")),
           ef_complex(e_float("0.0605541755221957622692251064064282979160765989706152859612874216042200927590451881263462366266653506650869456463615739004536308255185646256578221312349770031550820855594747175083363149741090833250640919098120241724552844601905315321086300733996538251788683791922045007753449265311784879998245375758531190636344681227704353029578391766539087264548884609909804882116645126729533311065809205792796846172"), e_float("6.3645757768438302700816586074014252378373644770595073859553623894371993385057832465868179097131162100330263926992564673532998670469577569542688331318530246183228682040610436882673269185115195276708787936809060353195884164296772936844658937706746286381819884178304449939612058507238973446960982367591319826275642739233303706111051817060697225434199112042397772438481048753422435656663940731555443771796")),
           ef_complex(e_float("0.0571129973945342146783923801244844843136957522471435464062654930198324727074923406112675870748598306468672913989952822036896149365655042126016192085558182774314510430534872804687305481869719007209391737683189823510261128854005899584347728042816788598226523931090438168835165187615194455991551444151440861835453709187774177163208575317040263880408561106451514010613370655382683524627447481719752672787"), e_float("6.4783479570874625954474792971109038009099898503484558162459204968886251011042826869086207705648136650988906954143708904822347232775554695314646524328873425609759345522682034112619481725449496438081825866220135253573999374215808131621672923214267294963650003163330123893883186833751072121881307982002112179852782287407551614634106679026692248254340076878743289246239052396020839383887264773846468173083")),
           ef_complex(e_float("0.0540403901502523018980320827722660111166392340125401641785763448057158425527019298099912689325969447159850571666731387238150245725059374716104218939807998606140124025688365320932600726169798280904930402539897424412260905400621140047371055305676208945609345947509903654740471754236840723723636515063421025123431995320569422324943070698677925983964045916576211663007303609161983952958740290183925658824"), e_float("6.5860220224110415776879788364217360454452591075079998539112423217515302611316847468832464139198217092653757539420086349770159456846823364253190611118942188804627721050557804011510637689469239843051660337969543766810510162736623184825394004011946261002700235924618036024459485377757602706669606756289934174251751833863699402987230093476744022991013042857803241970431536034723703467089554733224150769516")),
           ef_complex(e_float("0.0512803513814914551216784287844413943686831276639908006522205708384003941240981673250356793599801942912151838088904380732750990391742053553192404806703514829694807120349638051272241235270754650039148761307518522594410532000012609306190087306100054855665969198008378238185965086432080463604447891258712772011139650316031657102379752573397570380386878838918410955680791004063392057903737536825047947633"), e_float("6.6882159889633781283392200110223442740000219469856727101877828930312875873162453548099868207992340755502380705074450696268216551394783516370414818377929937515341204200956217388348707584460072267409178631427841997683174314028523017452514961278482109240498569699985735962424318213479720499546242004799380765818536286136816591032365280650237072312910008039935153906091744041484372561183108924443793156102")),
           ef_complex(e_float("0.0487876427859999686451681632563494427993692075343406392094777993384729269930134426242250457412248147223893706052856706209004734046432468138713217693161223351820921011368741391370879994814414602666476996539124936692761188818953744701585477552242108099420102058760511108320642399145129784955635548855336876332597853325554306608005613470356705108571802542880523810250412440726456496626303113821339843119"), e_float("6.7854587880444694754559686914909953552073643788468650464968448465420221616632947445291438353132002516640731784917353815433231520216609804444625439840206655522233976859639801311227325683712336438948762021937673635294939254445187235308132233273240169520859678381496841450480758699201734426194306853550327761115027502454977901175579670804174023405877900005702792542653919439228519164113705950039741993768")),
           ef_complex(e_float("0.0465253297158269038108598350129997732654469236423844049434550735606263605199487104888345093300811037512309648829060127259037747907552923649065227064964587956959322782212168748324526083697977329178933678201868707746544099865544739589312238596122543827916572749926761896325976295855880424439206632189758222654553628203486500922896496192807127194709642137686759012928273617586018293438065800538812944361"), e_float("6.878206544386225606081081679787134789410066310747285713638421786076081629199862921520188647108623195962096467372134595304745946280498812390594069037218617600858829542588254483406805466589125945422470919003902352850173879871634837138664502871059000961670951552555108945781827479739471213560173329394855516069112216770944027010965605365479948415780717746478731763375176581412461930739136708759006810313")),
           ef_complex(e_float("0.0444629644011126988892148729612622530469874068283199276351463224722208299178578939881021504527626758991985029424347895335854927547304896807354849316854007796043893801343484187775250383765392565343201935100391956533362407270191819140957133845969612118468051206072376358018370893129284551622981755930840989329013879023457031906421736103522938333285300711015761902974687722302113076253780209113824258062"), e_float("6.9668553110403110085905970804619130104783004266227238162848133532587902177153822835796577111618374619509201166772906388860278300592582149160550268238881909501595820540684844685204892868646012005039284857188019731760165601117049990639378947719935183813712375252788620223371000936259030796022830260196220660714174260003991029103801400424195690115924003674120054646418902889928608786706967260088721570525")),
           ef_complex(e_float("0.0425752250608431180924671109021569405518661981589960335990730553303818420738632664149357591597846214192260019196174187905100610067092083630834936240199392984438501662556144061238618882294126962183706709595488935383399821352148737671337177694320971911319734467514500096854391044890762084270702442697810312191669504370130527420762253789809208354751487470438414054406744837697615932089207078851837071865"), e_float("7.0517511448466739516281369526564553825538395715605339543840256670993803775540376628021923815642625234742416692484715773289925983573680067517666803566228312783091265000794399059537613518162154601257500093858516290973446057384968884831855500809372388144919738032314233548123491555004885855074662971728622819504490520590217852460997243576960901994190449418285517808034065591031136832720790248749053826428")),
           ef_complex(e_float("0.040840883083279140134585398241602524304218309165931859843150078664634601756475359847742358112658385577691579511362372027907082697365774093955544547138557991659819837116347797926198161915432499764012747109610135461854367488404024732204112347437137036791705990805311428328857164922736875274024022400728717531027196857369056767184700296720900180859987327795497172854199477854804895833085880507248543317"), e_float("7.1331981602624340672280042251251945589432161753885463302745527119709111654405171744261212905416547541249786143454413213768444487294346688591718847973916782316480335750849934038316471713010699030903417653479455489190217960809960586013061519425106438355802291198191792666657466662117182946811362775990980067753450305627995852456900731685708266264594459579533701836842226134764330016342618066907264735763")),
           ef_complex(e_float("0.0392420097549032490579783595659139444188672110306551260173846633154432939767047267785756251872159416259670903547661905691460106197561683124299459094340060652127896237144276757051264663439321166116785402323309651495108341179286207976034729228636221338826553385793721760450196273364483074970633022472532428928354605253234309853589524748323452431984025187634791091540638527160378744208644141601837037987"), e_float("7.2114650282549582680725248682481747581338288936190609171869479974518891198059853238990920909942107287605791515753897393020172484261787856548668160928739453217234754056804356109618490054406275177775011175618050824872602258006239740837852492748949616217713330599613404549707598477756077200998488172960133718117464673637791058169798985979692581235895709347573423612218391071676141976082449403220111794137")),
           ef_complex(e_float("0.0377633602501296023590591997026891655577276579006422917440526597674782948255721908129008733441650158774502071691967782395456298816870651602236332924568974191601166386343334334629884069010015056858656762461910103423429123894450994788924526904051299213204336644090665519882039219829847529024736841272938678366747465318833278506810924173543354173356111904031034533214904041297840311984815136285855506824"), e_float("7.2867902662481363230526749340961426552546898900643249962588750180838065891426652905194446243376610311688695045481647639096714917406420019087768252551106484183915336052533092614440552089657752291550387618349859526974214534615429419735740819883308799045929903383127930427258490464508800753833932471204112021574947035489799093717808541099792494818773760973072359627823519823241258581078593482182700465859")),
           ef_complex(e_float("0.0363918904090121994794324051622747739509233288246914767228022958468972353196478198147661398073069349335973916708891369697055533159564655689081314881874080940164492903990409346440913199056081336822584048279616065422156128031981452268193808688233446537394949491648760135829984601984896319503013300745096130393165089582033925133778681291029057114825698135078601408132609551074881961747166962594943566407"), e_float("7.359386578717334993873173093685358642726205790782409144793444136125734535891875844502056431221917343435935588614569246562483141740369248805314825620805947721491431670357599425401895869551426851546514830575540704550163748381077456307822855885732978184285786713799400550050117364669940007292522145747799888751002421885864315068643379967982894567052014946167646158938918450439753700234398580236873414957")),
           ef_complex(e_float("0.0351163741201361003360210313622695059448444336550863624296848525441157950383274689457713876730287676916670190994475906710617237704196555268055918665759070620578851108392718383404470008034313716431800828023222883958827456090455759067248553333098827675140591105561313134534314622949329655817230568563599880106226317418204066019825846951726795820452910024705308189633827851407684731895920996631177927081"), e_float("7.4294444453828654916195208818637554747111292747572033455558838307149106386349343015823200899041731191148630875881829483006050040905719843610114768779386206967687417011444148984437950433811609481404623875979543076523364044845302310859881319883038923905724673044612733236703225419970189853957949139988732503033228958021443163929839174240833915261235050729319380297943841688550056389817774424326985236064")),
           ef_complex(e_float("0.0339270977283447643709243187623206351693986733548100258825125702128791383373241485278880505570524218233245773647232573498420398219383917521253638576728470105560772639680660493713072542161265539214660620491344937161638940526929821020369447439023957327431899203436530064690283707809367872346983096556994576381397819259943634180909185624483365944633808659408599538418700930300921007322848661208874797447"), e_float("7.4971351079710413122312753533713730908868473475687697953931831835990701034398054105896410063466363624888785013150859697091368677849416976425696548859223075348137769934232805130160714719085998546630156516671175020091979010587928667888151723761223514564617013615225314579525502675286812376170727547017471702597091077270062744956538613513486396390624309924532173967056017905608826163361575062939918287509")),
           ef_complex(e_float("0.0328156139898512239254440738753611375116853933641275627882016134661803924605500513209216299417628471516599315837824856503219333523166763413111210309881667022531904257353539372957764992793487694981885780810003015875066220124685259847598841579911505346402554627692053064133854656322759251440662032909284783920253254076951805782823453061631955718742408295736679331914484382054671360672345493959358676742"), e_float("7.5626130723796774929471296517993538614841377095838735200180408143643713852391385019676520932102961643915435031959888219130620491709770917425764493379487966398490930894964544733563295286745909574225953802188669324229918280434983667415044277716931451751642057954777439660454616677098950532529537163330972220303520493074826585527390993487466431251350166504433710815462398225489102686168261979355527830725")),
           ef_complex(e_float("0.0317745424812711963579977660547902634016099291559481677143870210087984301051386437387680927034755425895503078403724749468483126045800361794518006428001913168769667370729456092995001725799364918071011467264636038401665137259859729866184771385262306232716554699315116093815046565014999993475981597327509178002897595217074429245353374760744322303989532391641902686047301633758572362877623545163112770616"), e_float("7.62601821748014701518209837594549960935627465052139679994647882681332561713278192040229478634311859024614573892379831242311512620541025098114590288189649466501437541424998252440415657398917684879172995456280058492756274393132616365772897775034140066786276290402599037464307217260310664507713886430572187207178935784916535092503192630912348137380119307841786672938322987720836305711424975156738053041")),
           ef_complex(e_float("0.0307974065551334186453335515126458462991971026041716670827112050696333115832395821321995074670291264082042173363232237029811870485134836601744244781182311013588130428475304748877587755032937879467152356748144424022249567428930882347947428633886616657717971535599091552740167252946894304445713247678876130125378650712322251309958773409738250353129333241631256560916248535018550730395895556185551535261"), e_float("7.6874775823909040770943956619341911007988302760584287129312905896303474744022524568714864455448761305196558560412907019063545980429554259508376352006939155926158471589497397439047189960567217680961582523382827607922812788728368813025195880789711500541427763206328934486539133230629357944765594231265839761861119826717668370914126514696947068695592355151424342485480649578912195580911988574140582212666")),
           ef_complex(e_float("0.0298784992750517709528410502199538374548868096104414381056866409745268300650250293591943883650674651436254237937406635399486726500345764711894067864643665917291093361871695244052358511551674993295426062514570393081941176264616947729554177414221230387644407030492149556675810128491518618106372765122220353161960222637348446381404877386680344021507135948015170489580483887768300319852106173869480808275"), e_float("7.7471068892272298960494801674977803675802969773817098753456190925153953305257408678678254873587200276568907107949909574604686805264611843183832733130889583127888659397316646665361176144034651612346243883806338241750336515861062676793415832361543825118493565029031467318338724332132870138296329330725564711570844679122201402303086410433752404523696414054415402152861166217639303684894996216601751310991")),
           ef_complex(e_float("0.0290127725008124019544028067059498471626219750590735289557014014752404066844241354851426810690372199362873832029514015588684121719397245073679851833817948958817474945519905788604884983698145337375250831618188101616258225802968588776322230321300062387934910881874916692265636149263288885126675473053411885659571128886564072631686632075244601455866322854734288499569483912413298185239605521030092436086"), e_float("7.8050118468955588721568318569379310800366284526641258189807784821175608844612459481549320380649393270727844923856694101591015824539789193481730555880123752380753596184461125585970615540254814653920938042778768674148632234471429770811150862302606437609735183078619785938290839656167066520039646254351149930814761299442913066639644387854850416000926635526889803431105223252766329431368912246612438831566")),
           ef_complex(e_float("0.0281957445950674416909869928792252115201701061819280100810414228801205754577086150195956427476760802131097088932455447816662602769692554678500152022809427985041047770471710183304016611554622164376706175410545865987363927186589959505499001418941181160848095399598298670156716940688093898892498921218188468582552372271357995967037209987480474876278727629526401830078617812318425342778895656861166924696"), e_float("7.8612892726099242956787943829433937438233734619806383094761485964121143878554726779338662387962758699851550787017684860225058607784356286426763144738392590283743229482014492005654530916518448648234402559489276740226408957041061819394889902895924029065512102376446239013696362367561612958635970870815066424142962884782969386138171872351150868314254046164667942228303855349516832436401760956418555417215")),
           ef_complex(e_float("0.0274234232071118451050026952536940233045920024821202671545514792676910761234285037698279084234673604161470996878576087919530491179432442814636699587246522872498782090657207060591847630780592120690685867342179304442187127684915617671038197965068527005029983087380916867555930744534004903819183086821440548306848701420506229017484483935625439328900928888189740895957842235271388994811976023225471139597"), e_float("7.9160280608434853657825965631414018740939192479109258818305378604163149619185775577104963719316596287638661189578389112190597186484552117783643721010006713673246554977175041747930022567732704490218716920570489038053659186352578384775267233468900294170536200842231048442307153373600948144252327032703219556329327717178170215443044697276575267329710539765145593506938505038808522193518052071495686294983")),
           ef_complex(e_float("0.0266922403391428498592000811886271566970022159239797077804588772912715143074645821431245414640137405940566966699078255358272045572942915233564463490040425436384481896071487667472216785664726736027262455303114218149101276292185962964162455494697919235884494516645413712369739106607054327744775996681917603120841665582057730753774262954716595523658964352548085286534721203233151966847881432151949193005"), e_float("7.9693100239332252364843922352559538199552660054387157887496206229791780202269138319468709459822275420292724172243069684707548910665413844088285027128207112372744353830793462449103766991276548548397968922807781492650288794751937634882520478928965834171461619519030152058851899305892637710623652858513623348896255339038857894814240848725812335311474804068633366870901973706555073629042807472099449501648")),
           ef_complex(e_float("0.0259989974765875320978475573981776688757281774972515864377340462236704036827015347427758892992730140088008813959176025183435547047081974259084562891772613452274371001877096077259524432080229329167193570939579406176623710402144880414006247481936756287062448231007500049515457031168977000132814627705334051995467367706623114634563397711940513374280544452097648484600484700485435729626356183375431086001"), e_float("8.0212106241912013259006211658177106428293796452007760126413206322120412113635957282444312904181249856473320159262158710231423226975429518373565346013272146613998362161925234938092363467752399321738579146847093992349684088432028019320430547017921125074027366193765904559112831913333517184133978246767796811569029512931632967468361427908427846281684336969735905493745410294659480492859673550360002169326")),
           ef_complex(e_float("0.0253408190100950339900764152758446079408364201217504524879157789327783014398960725390943290689866548874325240616034085478046651053635418597279668987783513307266234198625635246705840701620728572139706514968936462432015913398638125011003402429479335899352377322179298349316820068157099807313011400587481855630619690286820949521703993910486652949347672816201529498011730225099227036904166572907158748995"), e_float("8.0717996138865206748082622125221515886228549059058793750259860405720746342301028884603121685628486680338930838728149135788061047277478736179781473883987149565376712872462789558047406073989415046606777931027090291167208686778993940025469243820846118877321609317072899839365844250586964655197432990649930363793352435411560444867167256539956034615632527896136686418838510736959726675428165170764550199755")),
           ef_complex(e_float("0.0247151125244770672092593005564316208717276198728634953803866622645544904400861503262273235999974523932261031344608536049879831379944554443978347349317658333204220245535894597897855293954488700245475654618086249195555895923111291529261261679953221235283257603721065730610894536683528120336962979808772015323512762223569241008055233984300480550504076693594174139482136186496054218383871037001268751862"), e_float("8.1211415966559754665977962469661624306374277607361558299244276951237379044273012428129822173251140571538258023307681080033727162809052570232176652285882626840828641217602060192873509794086857831174620693542277985497366539383308197279390778422381163940338024377766290803334895358007773934450215005661497690954042485020404543026889493481558268219724838585800767084921959733030486541285094590399562036291")),
           ef_complex(e_float("0.0241195348027329805275755149932538398382008462007266528612335196550460167484932000623488653542723050938134553896405504290985917604625746498207498221955375274567825237855605894002186637193042564487953468745652402193328897069146111814974885497745650010226227264730534090488283016740606564110549257338373877090798864093234160754861036783673939158049044819290505064377236385987540641591926303877385834375"), e_float("8.1692965216313509644724197192649945481939016478062834718827952240950944945935551058452244930553445835102778685577346822509175851900266335843298933335302638683846691224579791248205877958323043990679223604545730193732484955305686513051982968793242126204688869093238145589807435254751857603162855569399486824967447509130493919070451667736242743541521421958392862753331958824168265644321435173043868194808")),
           ef_complex(e_float("0.0235519626087794248504454857716923003301102898849826095164141976763923796183475245876276233061462028186605313970045194832056579254175314583672408001691943495607525488726904074361462253752163059908549484964884068041568352274915138755541209018383296158150726746984450422124968977390593480718241988772582066833707668992016353856880580254829543940394265175539037317944762796690685608078663646238201458842"), e_float("8.2163201197252961579752078923523127663850390719258189719338709438178204114573701013327465678194097144800360235365037729756994063286782405968684936546286641313645940451490709669228021755342090290640719857259047269228683406062533012411749924705455962594678694956162629472660993226191980380246754739075734907776366005224035242227423014058843925910648645572984144084805109813207628118603048738712088321251")),
           ef_complex(e_float("0.023010467483706451339394467369022843254623112391657773267540572045921196924577018683069391013734274538232317390248424612216050483273210839555468288110898557064752734386559164589086804271581876707522686816906220280862464994900787043400476238177852606628190895047897597490136475448634977009589652053258784355978689303893003002567014671278349582331664677901606618495585042153835690203533037344038056451"), e_float("8.2622642900084183814812895118888154165136713493741352405592442296427421522513256594204243074931863974397919919486739390101217146787002255318974382498343577801768098597335897982221317357405561950489902167760997500577289339242602043863861444964503313087494323340588811136671972604946310531447497161368896700331976356396698559306815666609899589800498934286578157637550104406519628704626568231404437871859")),
           ef_complex(e_float("0.0224932939271802446830733617656716923391841654738436764391097042451192600896502775678129839492758196178896349284373796762375500875022364343034609683789845871066137894483827029800069372979540517684934031247254559416589484751994396097486717701501084551892704177436915177513447353300631299575307370145823052506316523997491604421230235576328915432567353685058859734486077108873977315465832044913790544584"), e_float("8.3071774428703632737870553403891308164105896864042377704098614630792896453789257768034664594032967020647985769854011347660024874346026445863468822446195325816990385940191691905061797372888096651201856248266928080676169743297245953044568984577749658876054607432453408234179499249787234919713915778871913344258420372813993540046638973609860992089894384613877205130737284534196245682780851398612903300192")),
           ef_complex(e_float("0.0219988404455165029511150795724075670740608457679050920446349602537169850662256777987339307261426160464422717450393215180446127007998528748879936384699847346423081950622840024764003512822408297796898222695626344681024531440831237834124899486285776556189522268013145914229400997644540093864753553793537530696166639388303491781629854512906791479875820732811614211941711929911170839102305067544211941386"), e_float("8.3511048056342219437237383243401831060690009677861270001975017284588840190130541838475865843915194752949565452600433752740488813752790404253906098950843027502215632918399839955766472868779726283563820445750408466846570117763963119675679074700349883349447418944064954070360434793157115312188039823772519471357965933580758233250941622982415464853247408064832561991763731993194156085276150898916384435951")),
           ef_complex(e_float("0.0215256430367034557100179948230748420925835563865991126929575401489359883123994415790024505910391270651240027167352363601027428855402602045516743105252613664756020389654090527325905696521116077340998588137746455593440343302057219974507074274831856643113978216899768865325013600500276527215487268844857883339488526406892697844585709918565390977853590592855509039156472669840688967972730420323900406197"), e_float("8.3940886954450870136736434686000165522349577880955537298857879881917451890766002636510423507255547888154063133740614059224777506462802952226481379938660718971331108959890348364019819080647408288994680645154587942683082483743356297014455396914082635881448960453087907115541511764957508016518521692503725140781615734098855084510737778002202168958570476959181113599221987554557576199107953820044804620897")),
           ef_complex(e_float("0.0210723607546841731406292267852436631074045567139286562096520763597625951724467548357132157279745467699650457573180217331325666617496618272850479115754426841327168029868492232695496754673450539007860291578497175533024565862820897930633736976747027123117872166858998848208950803516717946541458920352497300096393666761025560335270078545743450417267619699379647094987202445245827093433378742371441093111"), e_float("8.4361687635470595286468194333332000406076031725434136188325096322998040424762262987421238324066780845473500682955241694127641380257609768700612538338287660931168695889092704504167867936527830006777671471679325015242416818466246036148494525598928618051382152136310678712412393927552939637484134758296477869438952428889636360119632300060922445764490331637869700740231229907170155441686337863272264183521")),
           ef_complex(e_float("0.0206377630539419081384343784605739699639897285131857638929155180030024663263458299090887729136504652754246274188008261623783365695450506754337868397501164432716855979196225524405172445628752294207953599889247445514572281319647118566609994890527923552144098610663131933540615581836006444179270113210510728876085525726785404545346573959925875237207698292553377838891634471655890259588351236624867496276"), e_float("8.4773822144723210683219471906115364071159886629245313258627433313403570380159958068771846877080019083469818363300894184363576711919571535993949426639793555265654810782596481929555279079494971134222095114228035846521630072935232474792412912761121478305859303735555301070071902578510572381811700292457960150494026842292075614620269485966489593244421428678606789189215224847967621477159835971575712067666")),
           ef_complex(e_float("0.0202207186635406319110241736004001710884727265749442525176450452481316264161719064081947170655825256031871951751637935553232462640788949864346379030682482772575919087453688607538721567628172677367267627318831439922942243874140290462976613367099722321656317635787889628945337432681855792202017469599198817204587529995959878700407372840908460521617716025700470779287106548456004894808939798407411319858"), e_float("8.5177640031701084880202713878111386347727488140942245648802531779433717813983441204879785199222443358380652750875290620507903065528959253494597687472322532225238248323594005607594090662426962212225190453118982906784690216356332456364098560399596386214995666749882022090534555235242761045407584693055505294072712009758714384746425138568508392657012565344404055444340630326720624943320419933385811074939")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02111_z_asin(const bool b_write_output)
    {
      return TestCase_case_02111_z_asin().execute(b_write_output);
    }
  }
}
