
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00901_zeta_small_x : public TestCaseReal
    {
    public:
      TestCase_case_00901_zeta_small_x() { }
      virtual ~TestCase_case_00901_zeta_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00901_zeta_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::riemann_zeta((ef::pi() * (k + 1)) / 100);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.52989143886610873048354970600042257350804987660783636564262733355106082990624759925115064483832186739684236368864415708490918046044458556963594255635391126915911055917299174415129553799142744169386872054466172026220410696966856860176009735387632369076843115337291859273435227356928117741709603418856911969676668266121581238045853730146581288285736992850413680486727895404885009516008301945009218108427"),
           e_float("-0.56196387327534579021066656738127706453304344361511676017634194961213136781874435994452627022379349607190623051957594828597778203593857189990951955712121933131015432724404036059072908508607926951010425784758855709056260084109404363700460364298217964281235244834372307100893229861268223430784284396493773902978825693771772202895019492973174686565014049125956072989772521895126960870150223806162434221336"),
           e_float("-0.59644372010375187723132683987360673498752399037817549999962345855258627905276293783613405951091683578311279257527735088400193208620106361177392499297953586103549489733878746313773570431581747991660107394489075706351043665287046511827283477375736343238140158674548252870851283452390476103499457620054467776108646484227800940901497471437913218357164361596299678358307215044598318184622612782457601713646"),
           e_float("-0.63358991472764010082181804054335315967685194059571543642107729231637082043293616779207323440844549147101241280175292394821704006953391846489009693669677503544582035572108915736445556879848577782333530666579489360257381070734700317485115593068908590647947830775862497838805860343717705796858282923048923479754803258445890383657055592560810992923042948188078126134906612352960271360110020254311665125532"),
           e_float("-0.6736999714331105312097943977662236810744781644248848439176183169062350349695181340750308965706905245829423925687550752438463094106072914002619864219171752728452706165958186834400515339877067541256327683363728807826909601268665538261505038375469698710394963577386672552175339327782592023996284584409408814394932802149740686059765027351744608143264465048835630714942279885115480114423294687271241363135"),
           e_float("-0.71711745153098258240566265979853299359255642810206184381925933480561959487163823136746394353487439723034498130328380049372031842386480233423786219266032762878123463391044151055187501610347350955839379157460549116301160926648992182315690833698870558200296270015087532416910964629452343846234504526363856901688585570524839392131257353608595069368882132261441416303849950318655426119985595880179585805034"),
           e_float("-0.76424123601722623843170593770660015115121515940374058493986951820010920306078630160482508318948433568892188687837197431996288984643097558927891561035428776863364351274377313237186018302703717423640144552099372918692193260395828034751243419213360765910846476328753162020275358627477396398556522010680635670027374127032641716399469344012564732600707579301342964582572072197588488544681018424057085004209"),
           e_float("-0.81553713283714984035260900774859026088890471699986053005427790929448156188466388732044068953752001837914881596629292530721895217226574163853540260014424285519995107774876798989930777290970329303187311954968074475111893673180755474700000365438232830396116480217778123310514460713466512341272361713768275705425604465272023809756454166289975201697913727254307029221458424474330834433929690504673096985606"),
           e_float("-0.87155253454452573522220083269010669477699885399628093188170931456176548368298293629725971580140269231805120216721103304440417160338015781096068695051298328501975108196209494125379252136873206199384741793102780684955494482815901569684768730911271669339850922970508614303469163217135758812309944964651296897132311224314172987507777357378365298017874279958746003197510006509845187691335744021808409321817"),
           e_float("-0.93293510444964468380940690538797324310965250425264104723391506514170280594594016760262399958437442067230947016297035063116001069153584851820891831584586067434260323602915919016483225853096036855980598280172392465951431365243730757183618370690023037649495594106943246608571872095442355357161728851513548779804347069345009621314062544683235826220180357379971372858845021514859060547377515578398849824488"),
           e_float("-1.0004568449806677554028313441624355467960368977749072891734623715361861533073066061935553560441685297254190182159867770395731961599037945783013550219505501551363414690703000011632020948282298532337211926472620652347551392504542126399969610771136990146413862986397252844148358786921702284045435218683740018094593153410368779729593972952416643166160778324952210874324185474183510203109973806065396173165"),
           e_float("-1.0750454480872968085126981435684541374506687352307653311103879239613322707719606609300644660239333627739068303309232536394454077963647332959741022038430594025060067848305694180554390347122943165365198357163274892677337945235550875682168306160185300332837876631851499020666603909047519826060053183852809370989820513175495957054580722978638480210026005925088669541256584912564741722981371405399640198258"),
           e_float("-1.1578256346232961169718452709931364161118185258675822990898984247437800420799293028172224849164040815187185790611613639794701513499758819862816885556184435860041580920948521953047715200042248681302487416784861796651824367462550921970512099733034775044189628801608371738337667848718499753558554585282869583761551973681635276257628294496883476422874112957761856753833863078658027354639192964909244540543"),
           e_float("-1.2501744041307570819683822159645964891783696670784692826180359187546537447399887496235925714133344109007067428472707665608093913496944007430866734185385914569463924134497264404329018754985023763731237808982215343507953431100461572393802505783893813787234167890366714131586018511950077584223069750163145236795008476890508123842694514730924846285219934445610682491669008325807038654616945245665267586372"),
           e_float("-1.3537959803551555398720999206455954637984950403816451305249448213767592603558748336979246888238689834930465647053567112495204011852299020011033927561504287479250653645115870341692251160701860869529991761178850295239845502444988368656964634022880366642044040438181294155038634882233573339405530585008599061593293686605631148484032594433552810911192512600084497868547576216399558542873067048258226252656"),
           e_float("-1.470825161366827917565791221501521548527190074183346160500288564332970611305203469820543530706706095328036167511133326860325817588681785569244481914649239102601830171641648040837085272319795660777016252570840631185700247895747744385852305335329699437729060112342806513361216615505998011353003542449757556672800353039617109893826838731650766671958975700674894768468739392316616869647756973637719897465"),
           e_float("-1.6039724808287538306403145039882727638659941650890458530275756781983028683316014898180886916542389814454186023273562490653461178532117775585119432861495932275268487057767958075471613326413132534546868156390183677001444325678552649982675373559840579948442844189949591798742340127163839236930747511729023237996656921625761967384144984640372170652557611696389868489461157814774436107421075140132331164437"),
           e_float("-1.7567323414446068781526026584179842883936664057876046567381834597766952088129520218477240978309631432523552961820460306258360695262203789014177092334761746699839436870442602752526162019133405853917822856103148124262265833578539349008231377525341555189291761607685112740814592140965891916308275578901593276920388668258087798664133653052282224568824202716202520837963194553988396781477079626022133793709"),
           e_float("-1.933688475325504034370939780034054448761734426026108415086067321871618582682103222485644440299063056914362609654964349299677297023614491839054185015271901575767026338172250188527394051502159398105287476004856177306484840111116544024989046130650422030264790795720095847965829807688106325629351503617840450432532764474595046928601142176387535417608157554962388615782500707895264552446636600100882538947"),
           e_float("-2.1409743163555302862464475792813994120702889273529235535125034789105993577133141090277529559574831204427642719438578922449166747044601356627704109098692072418814375834793331018546228275199342698147690924828359700794236852688038634147953560837456808305397541746083634707365875050125554964374498133149056106042323248915731431678250113923869301368537289055846770372647634713302737651213784190227624220453"),
           e_float("-2.3869884032087202761846515388390460235813063899004498001615458479469100474321839456564501300682659934060665166104516924689994960303076467774709858888012060011890495343432089152766260067234788135585656172579020670336859259895039690860549664225863113078926985492561364528361779538825116346616930316353943311087898755601181402868875894296099374430486188984554368129329605546785317443334921295237947227397"),
           e_float("-2.6835464035600073256401466078975494577665423031397978761106415902994586820435250490444413190421341797916242015350331226024604777810246270484460366336110021413261595560616707545052125711303300315832517998426268181842777662129368256048062183415947112456433012316668115437113452325607694813264127235524764426872678762779197785458051327108785296529953700148135496045529143770531506285145870394812912144817"),
           e_float("-3.0478158530575126362326252790475156955054127762362610702046714222819969597487655109580237953609055075554192561789117524391681186553737265911068647525934473675255708455649704485973730014241093702310991739054394649825078615053063478652807985660673342743120855685067560659616042441505350883202944566853412936272953024895591917572174220882182959702586503706500117519192935125054230574992094038496829535458"),
           e_float("-3.5057332657142467977413249530491276837873949750637662725097123021494820737641029508892527781802896108006694003467341057872339478335917023846777478678816163621380374126613979557782376177414593738645976046276194898106215632155604483601297479675363348715340290531038515427402276831917355547727929035423785828208416340387454868554576289958920642169475002116736793896183347471149375850996160039780269733536"),
           e_float("-4.098422663768122742360745718501764199730342216599745002190379152963510391655332668829240002927421946734712628442788116348020914933706013684826548724044470046805479087373492325794834320116093900637026921371904177462404161070476159751825804376955144125783376469817588430097729063859220247353508538749053464877340982332820707780923845598745377428903046569840844470258367451216094708712426914089863776577"),
           e_float("-4.895218678662648226244856309674717229747537211704743117067361890939594860026954056568151776974238752681624116092973438485713670144439843671145551189801048036478245907402538215372973281270482537991006690867784091065766212900703729591926054091735238419580536979842840199153823479971318556838910125967858069182772319736257362046063576209011593577375182891385064709051121593293054793181007807172117263701"),
           e_float("-6.0228641065601728188074504660309513679230414192058061999566252972942694890056214984262037803361320738110392023487795658852603576251222087447823837174489433120612606087253910116664018260649736330436083574804856442192048778038084900655526635491285932843121401511199858653941980013435974865033229564428489097997721242702949282357823909803184079677691425802757259394630176674686044003106919591910560770574"),
           e_float("-7.7404359560013964639089817685186182879049249239735043398716702774174601584128273529982504950000961846704952291523517864554313142268035273462595366435554599220641863546830104692649067261680986216173589213817551157831869337531145264870042470016258791035673989468401612398240220232348644879848660623162346530029231565489650130216464663651072754237424389916853365477124792386133024168708185613424914988526"),
           e_float("-10.673069832974111650455191296949106381446931220643915676872011238123509164657482378630031041777468693373974023458500304765571161804733432406343219698844340119780715483660017131597001174032293108725590169438208953577204415816431803132829847255187728714900045722036121083835004641349386991185563784445755954437750948844099337377527658296335550539910192501797628792546638010043703611019738551643622971365"),
           e_float("-16.811580026370076066469443276533012882193971696363279242423276780364968775235036323878625910852030569945911751433087088300617645076314259292719879055490546741699375840907152904543782465278482793629571989698374956573938565532962676469752213311371383203226071786525425548044092672950430786139029759258607500706103000839912501388522951491133048222779599114618190309884051937093477851306846178928858891244"),
           e_float("-37.729651988478927072840247107647568411918319401494415321373829693133140004892242413153217848900028234106595897709061510771126490011265710174924371736851841746514030034651633620498179760767099423390572833193143724333356374457199721283965222149315361741409885859746169377457200857845950496091480153781456284217076092267929076943855312226569801082624442391612725271768044009497683999542633199992700184912"),
           e_float("188.91396336968452297932681362319970125039316309798103884461245533910687971344778706104550623788377894539835167194562746823882310155976030009581051452882195775168465634262357018015529824263356267527978757777157307572078893578258363692037173797646167816880894266334724948839869179465358210071075639622980132909708829727190674798876139414868809981424071020639265214929841914721727306686756989801680370106"),
           e_float("27.808864248026543054819942302103885976525915600490903690620681891917375038114321812769900444182934297564034162828378495871811338737084666081766431878717878178755142742866631613540726168214929717550069753311451855627746936453684627752617780112997650230627157917643984882169772455614299305494054887438002180173912326115593372246059722627055866533957104153140012196532690304405511918003760205972337188889"),
           e_float("15.257499051245731755988597034673052289717269047418977385351654155260158769625080038935697139262942423979105298241889218260838738534441713550717427998225971190319553705623621942995033629125644230097214186102374948641760668823306912546191107313034962416115157443025395652212883803239197211057264038422616952371884450613127115702062209721930172919841888739387770849171772002334191831575242780260408184212"),
           e_float("10.628870535403563452835991198176112298778009920170841556547570526388571429155475862234268213247813655340873955715717764590764689163941158149218043904250638066740109522353319198689431985451474119850654501308890765439693693061326385073985666900321575554126042964970224470737574552124745444667197768006341927273966443897840237350408298424391748682914052953434648211629496554407103787605528733076437964356"),
           e_float("8.2218094788851611316345527221943218597939423553280617494602576583511589560722646251570694071176553310267032201518046524572178490240974370102854997120518859569683221988649538529323245291799297173862621702862095895684256463711717282723589146322851644007780278896625195793743384652926380243521115383045321706685274954859451648386930016916461841941383114889316580281927695485299071403813417645704264317991"),
           e_float("6.7469528998420958111866668865034150551008159785514057047294179825971398643484123208067761363750496936909526928799544090250942723041251181136985969112338751234071846469723717822195916538909954097429215991872123378667400754056123966076418925580598447282639523679205710597654575871005445038180349158626033058057724902201485091682516599044459395188976837373977407614745511717525731348689440877314896049101"),
           e_float("5.7509634613031284294569701403709638311140894377788616982000457027125264819978035065632346877324958311996568599195488235829435334758594749010810974659185744083628298932527015794977026431258034315891491748642735796735369642151679942720238746812632988791646021454049931827294151938646806610881855272435728254941804830632305117332127228391156613872616522259343646801873235857864070284978107001717276757091"),
           e_float("5.0334465338988421296129780370747034086031199183790580280314466094574836328605748847724299374639314486229306031547957218676701569222727780970705846341662068102881661859355366777947673753889864265699923378218690610209058662983801360671197186547292654109444136579979382863299028955684123860899031444002417018941687594648018258151064741778607943384688060180080510640956996430022428142982366381287101600245"),
           e_float("4.4921317645424053156784162649890738347059513512332983555836831092192034934334368470902753518926882020769147422007694149394364287689683071448126736360631187644007902575828856953578533125034452618054761524077308323423653539188645584034375844395025564604958006194596971828981576012301377353214495148359732892738710114351911672963944347915504129941400615610676219313644050162825884151316839315071433743081"),
           e_float("4.069364431858354177072493211640754708914637303621929084453804719675118190748962035125062171945400630101450399486487228917837452885193252013853694108939406219145237034076303973371274534585712314401935633505356056549296912827803280687677806015155943751220453442767141334498645291951425791481393580889753265442295283089224605918419643264107873187924959119518472530395946811051440945049932790003866513726"),
           e_float("3.730168392518776045980786145385747544236516096830682821300325666590072400177243086653751446859996248220350143193326241211182084847272249321890801885970810460199475567884241415124470699889807805814158538914314051281424623039743636043571148527456748547301645841740799952573217290141460984779290335114505960722699694252658539655418708451446029421214083232583647294719455313465521935516687431207966369507"),
           e_float("3.452093626711042211154794340134403282289063900675416879674955208952226847351073808830378754007629902441800789525042170215288152097799254236826027032101285732968604891820933268467168034521883048736856271761078539622245277998651030750919709008114817736236158552937867967593678536731105255781732200102895725137863336929719356964556048731963092968941721788463295880400730389651917551091947677396118267375"),
           e_float("3.2200695088142627187819914542041982184691560866623483186773582094904471597154964858977517743321188286106505879583317589855077992546650840938624730512089814337630627251131624838980789736129858153263687507703421251073421166923476381360198039207261028686419747957440955377265075286497845821638600786687788820606774001325048469861755143126248729917735645209831691523223256114896526398321535248466282975207"),
           e_float("3.0236030054883225182225965404884603181716119751039192041379701768894139678879609151101845174159252875611353104122340530467195346779811278040495971283236297786474740808083397266857051500675954395744132746078841319570844743466693603039181469738426241578891076736632493157573324380837154366702509420732891285377740630310390216477561943174486467098721961307094620664155349691982811909232653529272470544449"),
           e_float("2.8551633228987592239610199354136159817352208843397535012264878569269364877663899597096201078978318730467813868836611093896998499606706992109026581622261126616678252975151127653618798791363040026296270429440966862435856538729915077398772612123559513893351134817624195102579217423906157268796170711363041577329392087120170273864067246147959577353065430251195138572869811662978609797705534208069256182088"),
           e_float("2.7092054958113678746614971060617559281901453821667609772613046661971992793596806261941291141316976139756967676448151974142368913770495535980010584007005489875193354656825637495965428781959617372476883543919675282108708900989856253977732266223683045358818837472334138268186661295769434947426881457167070310893261233391825317863417736600829652394016167394671796036474753927401106565322296580812419370343"),
           e_float("2.581556303432530594946456026830391401272426618925539629688316543088051517202781275393379712705111140960264337036715029510606571702056233946106191044536267468353481117823704937431129528411720446719151669585990725774784363826048831285224044882340080860681698145996432542280022210888360889009734240727034378765020751091898691363266772266854530952200613310064001246976003323331387382038583183518374831577"),
           e_float("2.4690147872856859980002423642650342530543479477209701198770351965153390401950044498620284350980678432161243828111483191408486831514164841183717293224815272695611697345252800637825629050758353073025061196296624264762684696351388030025387156861162663378619188967640799247596860651496004793368701425501052900963306709568229809656617510292525469860571002775076704730030990633229819252439868602415732142861"),
           e_float("2.3690846911023631843575714737220845826771250675561325595805850979689646847901737279205525247720364151864613383678295270822495906695509317269145979451864572587787137202920407685038080445505510658459229517782511824220089180311631977355667520437947601215599357817395730936098078506020463300085068000943026132359504788266425506555272117352316050644640601526872667055395662612349208166636538817785794995958"),
           e_float("2.2797906484070740099012141338809133959938770538830765327829975010747431977345068235444022745634538156176168201663470115824444279284378085751629534715545327284516229579883198978703130467596022712674911606548867328247266722311808432699347964616559785063265640984962098801723707011590535274115898629496145756977448363214995530734790397651272684301616862082075763723029558993879211588895662344727179421724"),
           e_float("2.1995490517280346276760056688286819602752556756758824097727751179153171587926158231043566279676587840791993478871425782073470311262998336286255253965428265515412682304644119347443139937304372513075658653907143786169616638085268253432226652606414426583122435861648000139206885977987876758847213595515851669939983090336868259901623543060925899018638855167036122923151356180913312349761259428419825510494"),
           e_float("2.1270755217494225169579099199736016141171918161376686034754407171445689549639734018725414796942819346888220586937156707336148903714211422626813771720459210637270424288708437350945988921523160918550860440491785042059183872405652001236456533994258597171970181402719976428430650358171654432527844378957481330232694872553432406141528150877357366295576993363157434318039824514092398868849904732637223769691"),
           e_float("2.0613174197513304008400728138957727838168680831048996375538386711025009579070170562734785945559794944985686177896214726651511688796103255923580604639322332857421230927662950170808274615455384301288384498125948732842676882769393648667068589831326044716820820173587528023435335761731720742164216248137380761573585015575575464072005674869605547751811614858730029880342159749295898666037895228279280613615"),
           e_float("2.0014038370666491692971711154286043834492943389991673621871269313464952717685778822139940388170169182806084918744140415092668711783299223809173913500977658634301541885342982831113057834213445377075540892943074255170249319702248072182066303860659071319602416938483729190721613814904704914946510802354613800664725665607376484818215016499821179231853133959356528854203924859400613804189242863962329217255"),
           e_float("1.946607999737656112231655413414961469780841329990683528170155997324023916813588653785719300266898971480834092985982785139560947982924878967797824308248031527405636967980521428922587644239896086063109621484560138043241472927330919402776848601219445316350883799733547911977559100471365594566514915869628358957368686171826552980666662458402871738340084034556656213992667251343825434489067119333525636066"),
           e_float("1.8963186354596716118956042091188047243691741122778480597834853413992773892865253728062504512544842465714578537484481506673509625903379276266654282113970074961130328264216663338313294373032671959343509652209753855467548274380586878424600043501969908182098681442248240609519871306983075405738355499002862035759829840625753540755300975197226093707209621482805666127443655920630830932051167428249181984643"),
           e_float("1.850017905472121073923238583751790025555227191464697366487919720114180235527951949130317169363368334841220602259870015713594068155332107877695674275587528435324563126191672297892748939328279588449085792845978048815672729079616575164883156989649335636575402546663499346966247515669131804436716966130171366698543799059908238667199122461806631726029737753258964068135837782515424304349337514143642005255"),
           e_float("1.8072642099614698815781608686487275110774220560045449605559152383668755495183406562828338795006723366294901100250068976228730039853277619181458410271479269385809849137809889420679864303232983454001787463329743151356781023599032246975257163011076347271272699723200050276936487803692323889519254612636407446028523053588037022252893852475776859052660469981573216205425454102789852638288074231665536862357"),
           e_float("1.7676786559082385825594239167631616115112460412661137130899090250302292389335192483383004622155810540223381508623588860429787317791812789654847328658120025027700107046366658149986421934984185523766470885214203739520782116700580926507520820799603862040006249284736081235750663635359828832859068467777505330942128928394585286220829668144338848533658541598123508498758458266596030096450673582187106389726"),
           e_float("1.7309343084622003744498248202707949360521407182170010046106187408395648640553206752180439920879575769625883563515044348544013874457896836519681919860137711558956914347841457801651912540657761288050100675601841487725173579705147870769914962581665487716368552526807912951996982061071860430370975297345970418974653883926097722220131803022719944603585344375272050028674430967477822691025141104894250071682"),
           e_float("1.6967475799944188804265727421086737458373189834746509197417280552988941170372866062293774057188351868850168294546729822403336187865474100251935144130295468864216470795811510225094664230766352083824062533588977000078245888128737563055558518798037289436346392981576020934952097896242950450807941196023931392226221087977198222942280003985728575768746593754289479848173649640865378424881135319377706635823"),
           e_float("1.6648712767423386366329502099462874412969554935124306387526779500151279281787497593124314863997017526096955400213599476609218520817740237745322867655854336548944415190815465946670248770016097596597399309746810513439407443659253956632749198224709448326456339191325784019832020189474489821714521462906846529176595526298111237417204686207748748967245050247605505940759083251100696336864681316643517988188"),
           e_float("1.6350889423545163608972947439826164627587579896101830537530996417194641570231587646689405169967717259353032796627045782821978187466642432082695414245499674402552980519575329698094317955022066391965848799780764300261873667097709963117502494039804880826716267669286280768021547638398569890906853603223926905105143759491359289710574859298073500130728435288616652211875639736693255804195756173743373965284"),
           e_float("1.6072102246368584577057912386409834002285136486786204522513042809007245352003508441709879017094556605383088825968477636787932510406842524250054156400401841243494148347005056126345412909249224211592403719115006721548156116600935453758556701052167889349857163171949722574879757370778374290530221096833146090680601704262321689433990104225924267708710817081721700887156602565783590662756032156619775145059"),
           e_float("1.5810670558832508818343287868131724638644803092139708995833035664348849137549102310872534054271748903833339403169746542067277216980900417244114807097266239754636286697384112381219870182223030915300341000044932699347772715294168942358857292509083677202429574441080293572193329150817205211790666863967880280345171533771996438434930584091676134904218102920063821115836075152154101371850403673808993408159"),
           e_float("1.5565104848556994034887490610706367721832149903735081458367438344876461295434192992022826699403966219231162907420548341933354945364265245877029006289601821645187460937640564612158443965477378249533036528197974993469942102638922340427787383349675670926025499368399372484446711274260350614680025451296531358053272082395481227449583272865519486917546293050594582633261491998593536503125622234583438151793"),
           e_float("1.5334080342964748569721710374924845590652044910893334584915476010028923905478032201740165035090751375395430121389684494821636459266738100383422157050731980166470627639963259922901117846171134318316159073148404205688257465688295770937925667796553962996140938150445242167878912896337737558888382817653922662814146935369399355018778565999452474519226541088784013791141207229748312319977789533098886028851"),
           e_float("1.511641484999415503898020884194330238335850744014373010978095693836433423872826223394239969292733516212094740084419029864742485648734498829643504354457740375568505706903349935136407957414846830573382891141018107728443144311354565654286561077992239076833826792406730426414939460405239706834084500380765031145833036376311444048589271917800495159872065700580045460991746479094595923651484067713073250659"),
           e_float("1.4911050082116657328651572127349334361808449853797321159123978866012720075996526004369668534130000703494535334313080462127198886828149098262739903508938981442085565754075991206436198788408330714243208689706205860287481830501779597359201110905511029227629335750497612528971810258056280615561638432304111914408065043676523415846527291662524498211624092283071394429009277172672966160897642245755032260073"),
           e_float("1.4717035841148071163187351479150452503498580679069430201805755859035215562024868634795765843581249699117167422870678455674723886919184816577111336105585289144170267838241505328115527991122534367086495199811558169308558030710957887998550920249017806140445027613961245707239448966925635864109587216590868775894052093224723121662214540994513319927893507832703487434360048453411821383578376491012604895102"),
           e_float("1.4533516565321632082553276921255162466997044199528848582164534796513376570875935421667436195432332637017147725870528117342147184396377593807140386388717460740085287200893295297080615389869392106994156987079140836864626099143955579915444743383892828437167069813262849809818314697214903413431487491529824537829024950374638788388011180175277593220884847113215020417917896571261947638740690548620020078585"),
           e_float("1.4359719836965834068944650538097094897250507013918692901987230066948226918509715404898347429952508371619175203628298635943828538342119338334128913187017216960654551986781503900417642468230306689580886719636442250620390022697579342963251020007597340613316894945061303608270322024945420031701455052329531794936604293163297097014919074380321230833592188323639847401735821827625971152220727147732400544456"),
           e_float("1.4194946525329572167895476571907970336639965221283954735101985513396933629006338716432007947628476804092041506749425321856027879215537126271401035328626790719022769255291962202004598187201121366695078129012758772986006582108866760048118582183193622094266196140127750736231364318129564815242574877892657998057480811575884898610302224435916623458779658736459256405816631743066203558953561182829385905977"),
           e_float("1.403856229941027892824395072652015849171100178282093760949211408863814792222395106814524140712925129315107616406949545414232233180063947642600257189623929209211795279036089478141151241852452999694177349009758557402236907874244907877848343739600497541310829010564107455261160304894058765354965385847453087485319637216231269963263556354002270907773034733649651717735315451385420455458409094728063461692"),
           e_float("1.3889990293664340814321164337730874593790816771265736785801757488178445383979448729312167711747146740136902125613090971575321074240410814773313486040281306959504353834768381493943457795617542912318525224861261642475726257456024804482250192509747757943864942573006431259263106711327185526542627145868108588809067155275100767846017904783950077049024227581181388758364507750808466309802868783787969488789"),
           e_float("1.3748704747933895941808980951419157228761225116558693334317403759716551902089519946162994057387622910896000669216857229215856892441425611406166769426224175931466473267862485520963476236368230309544744333245543250683377835354316890673713067568568989088886215812527480238051214548206852024557177719768750979671994279896163852022306874539434650837401227640043549733643172575862993197128818950769326482414"),
           e_float("1.3614225473882703476163873271031519453945793828460400103760343640793062385064581004264108550006400726648561135289825234636408295804524808302620957741361981329262767339257211464918359961416228033276979437285941886199256224053665853773058404643898851577740706465228269972093221717898006344429207888759199233031616515690160010978057599115733286394795968962793683762877681652083657433493957109988666208968"),
           e_float("1.3486113025285364725466067253958852943600877099017817241193080123924509676299799393246474738304144474899845736197243620889541937067426025811490257287244909796578664891384486478592443966611737437079765753240471793274675998930066598074965831360780063487307658859364904890203563448107736803387426336682560760592394314141564350621202071337026963132940791702216244576678349663986927056880916116411650387068"),
           e_float("1.3363964469885073305943290149472237637233374747017482417189076132962859339017802733314112223998620834836851612274112523767386624091179563093141853276803529317236761432658622639084540295221130162740129035828046574279926968635535420835781649697114302486908979282692716847240947845748514337680454219808413904116241009871793837520495977312349632913441017102263792350267730834452153921175825156208249351679"),
           e_float("1.3247409677177236590951839109344264639059769553292412305453547867579632850677685053368301856199679382107979983486577737410200109338403749955565136849179035950034483409670260905696677506327042857316180833838785861825487876052202222412992485748034839479334774132897221787754045316656839465322110389213575577184025490095884265783658629756147358882202548321018032807406861604320371779003924175203018230545"),
           e_float("1.3136108050132977182454137961596431667588077517395680158140847771483395694680383681728528316624933176326865140320189227478994407719294671644098499173064801447184821997145336273618028903252922787542066256264125050725110152135485280255827064499752227872781979587271460599856488064210852180565687936845593984043987473874438294344266515230239226071636197402507036817678127465876606278179233059606110495263"),
           e_float("1.3029745640131149649002312376667168329684179741230193106301820641283401713056196972306951306087227276053259442439660054217786630994673856653644488174848356236497135247541517740412983466355312480343873413897330795429818836356808915412553686186262401099947252006588645163542842793259074933070753138864443858651325111866942675864657064377419348263732491371951939998477211360942145796600044857512339495974"),
           e_float("1.2928032593680528524683798124237768750564381698866294122380602478641610389797680110153954872443931037881807296397548025174740181727695421126408698681366996437542661523037270005913761622178473910361351120710645915037827800617017036730659870450569916788744398430348886373722999541616485504243734283164034147635817590013988108832385340436661394026773057778274674679772340279783201086086635862224929229341"),
           e_float("1.2830700887250414766599430857207992176106734780289293078186791017807838265156516499114806292263386279587883889394804790959658997090415073688687441499591544349417386255988089863585487178436108400704902184989859084793554799639257909455801417182421570591290197134221805052569366869056144652908728197562222165299560450799304027625167751222887974251844882418102518555985531927925527551322331456110582657996"),
           e_float("1.2737502312979090080793724173324046202442434751909287190626089387096904133851314158583905234977157953239512380137075449465068170559959780317507298456564916535875130636866691348682122180833674864113592225052567332006353269115251143138418605001049705523829274568139805706956396325280334650598681011190632391598916853696946053907797261337142456865097369457791897941712250230745153623817310195313443001068"),
           e_float("1.2648206683428316502798151352238760119787913208617419872231188403166534409687999273369541740354495928313052292206652749074623779287874569236324386326720852806495663203773863001928914398107880612988396600107630019588203119265773831928381030256288526098212122623708115159615924991766192861741089401767577023635695676538988093186536956430507529905941525310769024062185612075288626347995365221510485906807"),
           e_float("1.2562600228085797998286770011468462477008980865502324443293052514479875152450313865718870082241404735299687669576583041711975497912961822865606486706245634339125863526618105176496472233272084090619702259245319381614743973747868790951098456639346050351041924424082097706778276233045701925737696730972073327573290943042084336569094206722262212999822743588991250453187375813906570349996196073987248427957"),
           e_float("1.2480484158137505886056654526322942894116379034339767017895221306596621351045052736952410933829902257635947383019596050744816709506011676479664823552311872902877177892257599472836153928004917109334148157720117435814826837474020305115534194294345775662839139747771964186016194942690522704122037524883808434893975416775342031733657224153872099604498823608242207172350295024114168551464212283789931149857"),
           e_float("1.2401673379260720684182473604179005539328104954012017210616434446041752471777526795765001868159220038471047541241998847912466625501359003015410858750875468194661357852654860338200139377546320963511262738985475607640873244674295276832745565579313943807325395718007604750589514955633957028657589769545598881005042016095864036910011178322948591867674320927880491998393436814888331322134192933502343041109"),
           e_float("1.2325995334926448698783544272217256808241905542564022891960448607941342764337271745500510172699376954921797448056736622463781794423810448413529012751601916686104751576125119724756013429042759327525197643753330271389882473866052958075180018425205256367208335124903882193902256604949278677149435252281054814910980874132471486790391708535535281261765910365958009288443950006441154650183369323373944612546"),
           e_float("1.2253288965028159899258654813838402283983374862870463995606477179919463834046453720802264621329571516292643675604017936746479910972608673206090196942056564778591350143047784578325010884995528786988994068216061542573645593465714464246109344161484075938325386748493199859884353247404897582478369516580962489779582882523407714578430823072303287440273400744738534438124377786837766323114518459634481850363"),
           e_float("1.2183403766639512882238726675306675535989706639326960729132996835637446740578633062558056045548360507440016835309811971297070386910056334470937622420071856755226415094867756169999816745790140611669192814598125013008060842990597300953186199025267608930633147300673618346577720483466834370107496375684479286867955243277779434499776238087380989062294065402237505476183236064473821545408995016137153272278"),
           e_float("1.2116198945401985873472344269247767785751090271445775645143159373809903057262803498637195251013151524972342515023706465833361381220113710675107646892965668877124194698109997179373229670912464452309104123518682893783830471786183260511694430885173314510866281188336407196185907220184514425332123473787585490818606232744899997653386153275556086458659899648169843565248844559241319485642688396343903587655"),
           e_float("1.2051542647499627215323716069164733812946617002085183949812617145443020546382766090977435977904673599085615793968784025247987934883423628560652796930455276649221006191625643105150532376045727616760234215121629685380429032989585918307216596392333831364224970645505677936226105061283331774264362209747642455405073763343202538052876561081070412094209716525897621347477707215492062962749680835318541739047"),
           e_float("1.198931126343018110607933616314611462308385329272320826888229914931692789455362305734444807554200309132958254196078107498602747180427006433118551664999084056818937724628801668014061400538545939289316265427978825366525477512528010695851028887930172907994830954036708759047494413036796430877004003980160714421676512546412091986593824456755977831208586782247741365354022098698778710792719209978880439219"),
           e_float("1.1929388795860976418562707596203673751642071578992335045168647841147835159941165469454799384959294019032398003598718805824444715125418214458743341050986114006556086765530478259778687691190375661049867407107546715457233769562679573122073685019434541029322395271913499891323851312651360073032085735737925110591081308349843724540850447973352725588179166014243663862166878644564596831589362009919026798071"),
           e_float("1.1871666284790319840970988408225954688271349680461051808940961092315356952145368364810592423649948093839675585261113453397862393663778143355963676904248895961242269613514110896832113168395969399611116678803079028876148246856400235060072411084641282405749408033818237200958982480300165531973896187573623589427219051566068534417626336459970991673898107252321824087400440887431744813300146169443085264836"),
           e_float("1.1816041284042561494288596329520398900668999757474229685066519051874786179654458371063159709022345302195430435652362448223186149851705958787439617971925702100058391778796102502143729009677106931674508145493557720482079292085827940754601878257475165076441884106372680181433901023714680277482471621245312204804533852332332975087829276435644154819453202035073715624789687193050417337461718485141511993297"),
           e_float("1.1762417383825827588721504519380520911697389900216558349605083462304087237681586183357208373255718311389456600814530083686969752901158193791439440633774525959356512432924761830245287225253682480509935601329034182957720362068427149543106043103832048353670452264557887145779766360000205618741908519172397946696783614673659892050530221732641770393665550622256501968284091715061280143774641994151736796336"),
           e_float("1.1710703774691052189192955346365235162098426242555059879157335902344141135446304438563494374501914271523665152519904594203025332337203728968000923753342689954185016914504970624985802400002128017548594778159664096501570326938360513430166323805514699046488180774850192061142813430107314401708699914400448431337102358798089808335188839766642645947478519908944262844549127762317374897274701486101038403342"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00901_zeta_small_x(const bool b_write_output)
    {
      return TestCase_case_00901_zeta_small_x().execute(b_write_output);
    }
  }
}
