
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00451_bessel_in : public TestCaseReal
    {
    public:
      TestCase_case_00451_bessel_in() { }
      virtual ~TestCase_case_00451_bessel_in() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00451_bessel_in");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        static const e_float pi_over_ten = ef::pi() / 10;
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_i(1000 - (10 * k), pi_over_ten + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.2752428942793798139753641732002573012820404776240319045681491092049631410357492039492039092067407441611009295417110640882069625290795405925264032516149015280426094470480263061327733150271915329292083946447697187193127166146844393781353110304211311715305234242696987004923251003813880278192496026784591680111266741190820789825248483833522919546960694500845559551567359097583581448856312177889730923563e-3372"),
           e_float("4.6473412050918457986138661489915216975524735945145246420122300604561927357555950778228150289748274095042849549784207750725751565027309904410984817052494617415991293935094916562611951984929189443176676619826018857686059216633490759491819996787111011216432342647282227602544935039678692089341132953347050810562827566338732246472014091071860421133305494035157809705633515636820117934210873817185137605007e-1833"),
           e_float("9.8050156329291410368851961866372542982907069175471870905728632277285693736395743956874956389541842776332498497461479204688272677684038038219764677842999457749007742581872666126708662630232522104189790635580993722713317970219363550791908425732110476839621607676210776709560993179410714100802499460561645326326668174159064572873001346736328839727090006743644058416515848655672238901258350803084492339276e-1522"),
           e_float("3.1941796415026972855641026237976633621328750633692960226195215473371906052741158661004408685624931082112547338071679036704386632483522040792519053921895415024422793003597153490620040259729700662156389650236256799734912644158334250850700574758187905385672266455038210062893552117557148732875489594148593515754770298648107139262277517407869319693387156267097260056525497025920613043672866591469546001543e-1333"),
           e_float("3.0629562144105150638566833412659383950410570996173079521554511139980703477735881744684737413857982035827532931630813841694937397247549203272681592211372115311015993048186490060845931877890163683279598093916003615044721512049966563743041331817887503122435521948521228098060175307628550841262090229069515021360671325533523531885858413969110669819630278484462518793897469415389120282447828603816014307348e-1196"),
           e_float("5.8948514065745854593556897086070911898742230274695947029688857338092673049761794717535879266764076783399893186131465656954578808179150741400395948876276686844691182844438104407728258370041579737483533865614486229991393314807917676317560649224950652277001318688411839438177650000376263288480808268367691156533181888132426490279868571288963262673025188357010740689508897485022511192115552937208023408374e-1088"),
           e_float("4.5329630393992564826009440485822533959865447265495843909229834548956940993991864082026804838091514133647894635408215221158081099114834249233157914804847596253084879696186876193099024861783693923284672895678340824829958747601052211413816827420346141688956559347617738688950115476236783097853443320375623277537485738841917279838207286262474784734187240514449432749380904883343837870869129186637134990006e-998"),
           e_float("4.8912948661785895264522415074731024268521335591567049063658484309470600970517631743613350110152461930317006991009967676522111317108675335867030033826751889820245958886802034441933898230966509495014581903236885753331654501904113399701650695965876732344167439191143218087618472681409764411115169238031485292157978459891700504536705172934048985937247459486207167128994964250382887700592364482759930371563e-921"),
           e_float("1.6067296865211486975467290137072997678260004222995863423487711005723376065551430844318581375765976583489421676876500204453653926837554323870108599374073438357331525305007790308141956648790296411124085534375642356148098555519985525566065146844905612487272004580587045675269121893189966710007689824554223946864399864057472923067406529784880403687151333738463567108033498642630914708157120827111371397131e-853"),
           e_float("2.3610679057519432847197960024342359527517892200085411238560269370745630523278824507283886490359614102177724258672393210500731573586607253284427952688399849352921557515345804567016472979638652422535346735577008412141240554528021669172993479140334106808526062477064463824048137220067312726271438761393167943274691220171106018357174549894522033794384220368087222375092037908140775323699798522279511164511e-793"),
           e_float("4.7895031359321928554127055983251198172444907894433492549106323499868574218651598671541020546466240173677978281851402287987844635372812370518460489437697327377875577179846621776869504155380363677534619021232420954223837420071645329337109610848504347372203523218578501235629217803306208192837600773239511423433218028551431416725757300783823605190578043327142906455502407967350153951343667183550135799194e-739"),
           e_float("1.5716253486990356304295374266183504695475843385964467662969109587051993712933416885396914334960000017205958447345367663838421422165881022043680047932819944805451797891985722814841028228090466082890759109979608518327357361434706016638020565947843887753187629240257375859028089538520002746195088913036274319721175244827964534016811623759195619517836381355445817050013481096173524115182406765048410333049e-689"),
           e_float("5.1900786463812148599824840928555632979715269911015888191380438539470534374242680606489312631900730984197505588384373943116253247909392878601202141689283794280730593360774650851190325384648321102829734874408685177305245227751913507315053464406468775075075624672534887966983146493206538032407332912627919880344427676198258264760811631547409235034486233303291101596920298237849218721411285950078127369283e-644"),
           e_float("6.9684084404127641939674381072838317497353990325270894234123191530759773289843039944821170336696964676079779760173074674945334177506673122282874631611432145255098341354565014544577192306933382579739838185760441766498560733677152586351713982557464286879599206362683626801148057311012980093438721316753346358302333476715800049435057623338665937857662695024354706750072198723713327050652354825476833361606e-602"),
           e_float("1.1330170460709460508917718837050888438800701622694659844057483711606341180033637109512172424061697034482013493703384722734236087027336799131121191080970865339363167373600410884277901966865440860782649074686099869851007419417289915632896391889274743614191586962078877464786136795154838888765766284010520029043892519126848889440333196896463558991236176727837008544842850433718759269777956341988759469772e-562"),
           e_float("5.3253259540717200315534072565898421721593595187786768556495618931288285788002977225209385091582582657976762279273304618434602308568555846099648028001785035769447976873118062889739721749118437640655252212139101537737092739299502426556615771793730671899885724881662380328193848584664000767830740694416282535126198920064275482189915971216231944413277360980908470603111653879066458740386074976699532351734e-526"),
           e_float("1.4647700247903247974616869893761172792009742263703366240195375535998576277386833623216591055624593947021421400251562803079789726200024958036608092295752182255132065604763387231951148701418230914464094909608494509813086128369234492917106538400328334993162433794979591799978507692612374072297497606171393162341130774505321308219864292620928967573544935423029429571287056278995247381130709660561822068877e-491"),
           e_float("4.2114570980756877712487453417847602208649467872884452072944614777490869186938279801258022339200400645302475717499618617685488350359464741908185304933390633142828832873415957757917076594100627271512882663105407399667905524220157279076540888970568729607960541821570295538072722661035521739742827696089672922067861872467967769992328452899178007952360793553839078036220954587515063716524746906952415519151e-459"),
           e_float("2.0520090520966678085413535782184681325794750338074123396979544120878183145315370546509692751324517691513344610303748887920039063071750367156305552034601333425314104612266502915243720320157013287345742452987706646393243830156794708048419106959023344912182354905428143313795379568341882909293621861308704685611648416144306788050413737254315037976428929831578097027606096278911361685636305992959568067126e-428"),
           e_float("2.5454753446416827457610364846828150978004212060731485463945289230824130429698027138395815214849528504060758356679138272804908064553863401846709269394628753667978773617387386148437463441671546204413571260017404071075122070583930864469041338788244587619672393951148270896664911424565577482168959451952998605185541965985888493096531565708846423929880530510729309305283574568062274352597197597015249365041e-399"),
           e_float("1.1365294088857650382992351326699108761307128403645650732202964090439027701728555360608753100914630269059831442524969444255669276067553852121261660141214000415815849944824815894768399401877673731933698537552080832618029026338712793133400712965802906600493852837265464869954171398507192760574141802421033429488433819537799527343328264953383428483764185615247131576201328554947679386905524750863085261801e-371"),
           e_float("2.4586560316876932968850708854277207576999651161279333556340730096533183198960727589344113913356395691652363376533147807759148233989407586125097259479599237650987466348780130989350742536830735317737478684891680482820007013535523072128490727787397115097119912939582664967901030060072979429680054078449530664414435015325060781271266753554780383080274470903209424660673801052683818933679228261267064399662e-345"),
           e_float("3.3328650161419844645962717255864915169438184122609025494813224961550998844690027858326600651650130575974330294617976045417428587681931650062645884446630018530945938509314774930173051872534836613421909370710436159596456251428083772908368365634403914680227360534987460489236217087932110876479594889381475951935507071360028558664825875275851423969356790908709734474667314401007347817476846355910723065151e-320"),
           e_float("3.5424330135801913879714829415213276544951216646932557224006905774646431451008150108208985956033900310324306368001522602441137675793983693524204815734106801912646704929186619769384902357048199830929277419739938136982392913838485620094894547260113886007242349416523922742749102705395631908277976379388417647983230538701600856158167623129530720981180962692453089805068587886186658527967708177943454252102e-296"),
           e_float("3.5940211027665772590674852516157151455982423557962457413421891953772398608916657146170888438251910389500407703211377635471230755468070994783297143237183677898115804117934967942468383266276997389560908742502256319430470604458990461965038751094349078662188366580222651146293945880260675326373745146199823328234190637544603072064563388094140447196917871438142631742652945774326728418822984819980131987478e-273"),
           e_float("4.1407185719938353755843488181279468428374151537207557161242638105510526329340295583873192383692578096893472436090444671205583898025869153723728180485501866188651137285041775441115635677580443635598388117789529269341572311253113822538281135670743484961693561185318900862552425872267579767841424262307153180034821776030380597375951666460910579351437182221023243210343478494419294075837713048287519089336e-251"),
           e_float("6.3204104792344382516124789798431759018948202938758456434174251853249663219431808633292241120287756591226620826906935656589855362043564701405006676105964755313655758504707301573974570751877572513520467990600345341495706740943791805125965183278031039853954591751674643808763762636408988271232345378817321652799814051739681895483637384410811091405891572831307207820498866202093798880069094976849005465066e-230"),
           e_float("1.4667071821805663244770178870708241169035634577015617397625114719708403310102329157349059096237630380543755472377421696747614204288712274112703557231116605668335282203405997053276584996703014387135454755249997665038890429930357574076472274981997030066465051959613777293225395099029492369437769307828717638736395162703827461057378038467258421343563583445004712489707395107369130226510789606734012788544e-209"),
           e_float("5.8539903099768214515532207490662834063748034170158938899805508109158482589115516586502699101515235114036844325911174419435553648588465594771481115443790779901013753530642196462502471443849447379283595649195307505977159051477658196272952296483494417669316368290837309535184968046487313563694907807563473090909363267391203816795493380494052227972168059969315155403730229859262184291552829347720362072547e-190"),
           e_float("4.49090336279317359735085751881277313410244162788520237747970677207424866456163780528841232728842446935429895860441457999787095266311399088026190097850300231645700401786186737376803601719537734391587746699957719781224017602007344191265222075270830274009186221102804795862874411453776295741181223747109453468367461725348452293817918149658457484404516718187059991135359417868103499986145614473696391125e-171"),
           e_float("7.322208341139911140434849268776976108653877184409183875052308264806093420835378951913469136836376997929190752699860921685977751461733829320642483877352978138798609380939789683646031206381757940628681547893635326646382478344106362172541242644359839661687791717174422330618395828027082844279626591443983946161167620028511278683833451916525067402543041542552738460644642878787979604035467914349494899689e-153"),
           e_float("2.7798185859597621866400430433334127630886694547131771478741705560445987144435385336728079889613309922103823657412455558146529518103144564096345233385755294987736313213346125618993994975946654584027878341021449529306210602229733708106006199327973039901814625096371718994831919578935698383088860227157625589662060859992948836851814271797165867353989599461263852220259150972382547295013689999197224377561e-135"),
           e_float("2.6704445222262739790813470892001401912281304139748566461877692891684062056021946129312919477728853084631350048427954469424500852346246953381741672098051425585408978576543116178324096113964302072315573451021964044928681634544409721413000290057728270744893397579084827636212592870339659743553520901099713721938615177999028932253602530118885989240749424917233736988582989665852740105937757564823436955568e-118"),
           e_float("7.0045913253855375586973020374782633634289834206133258576811818388495405703980831958335378297579098249967894060263066181575996411035905917158450083883599777396948812348648068707577142125083647494571686057580558156003421195914115046853110668467057417440577634343791072294240156645248980277422464904409524523994168773617341279827544076398992349833078171535692243318038579172178586481254388809610466733794e-102"),
           e_float("5.3793368450898844859606531616922111719917062831315931968472692359557303983476536421716765580690478691383465952389659866072869227151293141617402807710846929484226731617941406969652209383955723321089848865225181816987821533913111191920322994266944608953727937907875208485334493944973440089919184978185644457872146727403643278077496064044726931415887267408697339914989216475135604281889752133278451663136e-86"),
           e_float("1.2897976563820489442919095293165716682548843276096227606303661436207527870286975684586897294475858350303313460832427632650672981898724998148376425042483634747635806102571311826791060464504435051603609543675395698534002105316497791308427416797411865119601596704758119568195178358932264561527948451301558675783611949949345510642371672106715917598995392280769762079599768687384067635773597346775197405008e-70"),
           e_float("1.0245056815808836449439836133365683896311222797736089893765474742768655338352789671635906252415818583715633495891329043159655360798957146535145163724559946828472276543985729081446874024554100585712124426735625647157432269378852023366395631123204780678720741322024195993346156350100580805136578597558516754178910361059169974456965331373495430462697745318479128920324442374114428097971488805102696484867e-55"),
           e_float("2.8480254469364413036488374884116538060970694464059754521528117107213057740640638637744520511092188838855059443219385659525879664442953036842144308972056464588138563821260327901174718700696076738430596145611237763041882399887427880988288678715165720582934297502515208277874294202254267564114057169666703225023910649762810138103144541117065320895453450326569957138733047558395870978244931273454496111893e-41"),
           e_float("2.9156197815802364252436649135614221455620350750537119396370689135387507978042143124236538764332428742183885816885337831004454747362367494049235578508132572869881204754930006449360797796004884421529742892699300858793346706499984737981231361884437878147163800971626257283141236165399008111974176677269954581878498615810301709632636482961544073068806202587734034388840883885994471268672571624663380467674e-27"),
           e_float("1.1525367798776372380896780935655610216988409967054001668860653544110688904079114439556341749010747289092549700319668599374327162094011257179065936519979406167311927438251899773215153468541873640651143026562049800907594401736713749855233202356039312668512814366478346844815001240609432612959052311629684288985788648046971212966195939081570314864546432316014556513663222772299035406339041269366860634977e-13"),
           e_float("1.8386791260079065479196541448323197945750437294053684228060992253366387963121689960039430546223248247231251131778781266200009128550490900588563474506106386431244553698665772814186388661206697348908122779630170780059806612896062166665378549978862113795345431358032234364668424204650607543856244797377864376530969748756373608952488856101842793119042559372921816719821533871244801715184698314924127234901"),
           e_float("1.2337279688870114190389752713269649954991134172607752574389041362870058155381544735719680381616611089031706975171213647812186790329205532416264533178580401310898194781075187454221574797340571929736322836155633915009940014241105075420032634935674183890332892751110943555535877104526943702876384220669428652608237574117088367605293671908422609659942333531721027189678338387725455362342874967243803179707e13"),
           e_float("3.6190329238049296996063595079644123627253167614856200834472750908479070272455051111896254418483649632319047936879001267057879748156394416680342206984219547259827416280165530264631176238368660299692150807205486584286987509108113949179233175592261716460360535766214811899272636210536017065389198767462107835571589407973692668820563913026233825016443956503287911087017684219203029305255099197543441835871e25"),
           e_float("4.8126984170544713713997125097196940067537939436301532845850113508479677359327574081809534878514230165716186512820379392298068947487517290208594866166232185402621754045385926233344819479322649040963866331636912360476555906645323680017873077117452699277227241026112002394317969812004073211763061776074522853638996885380149879455412998415883917558623971109068884768653558021476966975355770152682855786309e37"),
           e_float("3.0021250697911902288057681460258272580976726605189115282081902316995992146637825517194494822259118678394671267914160786138597265213901964608061991215221872778052386911200885395066212816593922800922593331220996911284711991936977637068727068624179701941761258915386122257319716351986707447158526634860506568162084015022893671599732893164317473881090152155970604211138198831379682211845881086950259975831e49"),
           e_float("9.0713719836286510432405487943768942705572047444547614348816376355035160101824305694627533356913643090279512668698604290045551484454102002959253859155108990609057176750857977246069494898121506634390928581733027344571174690362850748148607338952792290438883978334680497212555859471474057889881505094690702893904688253022931546830803949510746250520306172122724020756700670649996269926367821411629868732139e60"),
           e_float("1.3686504866108539125380153286386675148057046463530332652275240260114122107940897724630227271812863431128548998209012813819079112139280477862218561352710164466710701816007728482486987251416453585847473228620039036487886297087779261714200745495369269233193856207844873940753645200090882075760307616300253013331422028794731547815144876841476342606606364984092771053516609168777833644850968204741710249218e72"),
           e_float("1.0610467037389508181939865861763275192846785674407446040767653048613767099994469084323326508791889893719426500954003814841592590355259329221580596750633940549149126567861323046179549833227188427663360519342061493085175514228313908455589112780084041826860239262634311901601224473179156996226771818348379801068757000216515179969076017217134432101895026928564588462654131819808371683851146872658041937458e83"),
           e_float("4.3428908335028426777693151017349912223849953120829418786657960768437932940453677663072637633572662149546105473067136828228857164587751551817134037722497171487954770392323717697928665580833974935031176408171926828473934968976267109803330201005107877410620032990187797390504300650026050974555112346385403459687175897774039126739862582867792959133356100883347328698501850022719316413790355842867714435474e93"),
           e_float("9.6292049683063941211461010363075922791238089283682819324322663218857775322372029115210373664700719504869424514106890284622325989718435284895021386665984083039961755494361955891374980361229837582464696411397652625972148969806973147278037546208243164511083108920845626130870434810399437947508485434605243530228033210562509848691703506088473539483455079970153052863298588973102080798039539206675281541464e103"),
           e_float("1.1851254242600171342759323060639570415094288943940068582868394062288305336537518363914301964564640985263455778946059117728944724643262320740805333701272492777290418399025264011873089660856523245731789034123087218194246846188475976710798156699445016516102825132259697702689915477973942079844720938811677728669948643795562890650915183985953566170722468652527350497424242725919289342447006490433736614233e114"),
           e_float("8.2864370970183511527604125845028737285380513924150308699821215160831050407319960254623388605854968180000959218857978219103961032668212617157720687980989328717476732418809549965625385496429583697146693190032947429295796740273772064356216275979805028938030244131108629709088294156693302921238939712882054278208227686504792872685468209855240228650911891467576504188498019849102279457021951707909302330272e123"),
           e_float("3.3649416907471655940962051326463859868011199199602476588235098689842157653046808707492939720404812892114301000664975696722487068797439348164245122861941809364539655955975269179010737254442669021339192061831783909304062494443801961336872948623937769864939724945349220292725856184513019292809732508457818608197613172263949054541382655414688899569013256687629799419101967943951563053460324041803017462919e133"),
           e_float("8.1042501434019610470856808537402965986899027843467401681111043844166408989616255176416984826204536352744014482899553662495216324713405746830635748912958852469217155402297009217651014092055085970821780970659353695716437219923486182016449181717248768991931418053082403022241126279964162495255204888032687645708921741835646930158031131908179134457737063467299504425665920591897558950282056561359775715765e142"),
           e_float("1.1810447348479720906892224202747757467570493420125523327043066623777151087252360817935764257474517825730276252966755295526595321947115837470832172084419835328923653166848019525456501942217960419216221082377371020336892756213355038707999121567918396235492261145164908324516725513094297377736062850085964582431323468207679858375434431050146054519617013434424772253538469658866840097854399037097157324984e152"),
           e_float("1.0615278791679604927610776927975953646893989608589940375388907824814864362037004964294343509661377955833587229792054239504864953648732229598620773566112883920945957389139058302555315129294693961991755420647559662243994248140192953689389019997605514704186399360859459527891123536649639096519930938542230970309382705789239637106004928523483026115533949480037738360370960233154652891164274671564025203851e161"),
           e_float("5.9927612729896008454564956964403522459087559307922320032002150178592965955572232945251881881483556510093287082722604331894370741321776768312494425714403846022540563409825703049141200889144459373611462240250199749563109499216557834579181789033137595263326089152797073677499854532704531305565479362315988191549190090315624087633657084830528556916111516628432840981019247572600338354046647001828152606458e169"),
           e_float("2.1623219110148327024531863704919529188780016183527665396080327457565575021424548584253299444721912538435102012400253860888660768970542654533484379074361488954740528792486525266874076343140068565123947823076836713488297444801321177077183341126641463895261871312583360154692225479699997717359388840058376205023727514568651643734927874758283512235982295042725590950120012670869468673198661113557265817629e178"),
           e_float("5.0704648447401071431382949395426737508498259316224014797994472129978304156912160254352125053583702108947913319279237361489466797741099831463163203864581284466542487926861374519191997195011154318615455190116766990305831293195341794164491309777272364717163324832755684951939979040481742427438625739806599458028538526813774162856224707552606786337917878360852943627220709557648550788432439316346158455882e186"),
           e_float("7.8511515478914644769821630727926021828031086954111993951114950851752765235952162904466582126521632752157309664023057299809367219337086942410172642497959051280287256465442363528866737725620092446435422014782035450480757154901681918537196129213505961059807876782589134366050938936543271877752095937804766118296535131329995539166213474042061966349572312629661482119378418709252232684641483036054391452811e194"),
           e_float("8.1509143332801994743062215536858382334206441294236646898670017767405760985357312542255988256499353469464478313442434451912603944417897894681287451580602155924342267228703236919224720603257754781496974212041311721482220768420990960089136188074845589135498733423127405456238701041804933071618308326919863906891845401702864149816598598394153753192882708448542554788557719855427819070145180988440165589643e202"),
           e_float("5.7572738638428555898538859544093662395657487214148755439976847406588502575145947627460073744457206056426315170065446902115879150595370601685965840315633968774582183360221810968828704572789116103165373044798584362286906130963056467381927999639189388503762692550320426702028342521922729702588240347939481901111004811748509756458419842747882796280034013256152797106536393814828410086894356626526649862347e210"),
           e_float("2.8057619560754052617879597465240696409178333052155920472152457903483631944234075298212235795413340497363897904197777162427761920063414250730235575042211786666082012976783160561043329196863096222971843221013595524074837497748223070376823029300498410141020837207241387277777853278786233376174862284242664767104988081907090207652269474951776167894371249649823828910750544340491641199244823717421466761769e218"),
           e_float("9.561872490189836257365590438551813087029785679263268602459927589425603159356782024615025381742341238848215689155944169129903485213715692863167330198645932898490390416742059996752038285692731015004833766697800577565095833028640313429165787999863636604260021663574332055167764153666388371615269381521803673418039137405547622976538468806338872723370915287615129701705570375716563648171730543710462602533e225"),
           e_float("2.3082857668416808929938075029004973808996752302065789295396368002141564385589872179385211310780715607843982621861669013721580299890003051677714351742377218055473372350232997454479091666421152605786693302498019480670240142841686934652593097584828554028514707214530237085924422229997904784740516958659557077052019556790854175837158161241811172619999178099392769501682374055895093429008816267586509045978e233"),
           e_float("3.9963180737173597555657776260768742743952532509136241371942471850627065709446138378098600757519536280998238825154548462138743687883366917357516171954222776924134108090395363225931149132336486780556276513406034177635643098095468699726021200563985124864371592563972303516412106124501952942342099020505115366972101564332916618716596121547711885086584137902504258983347721946723577142586840641852705560979e240"),
           e_float("5.0211997547262595883509551460167937332298013289637583844662947991513887741103129661369701575010386841634543159814947659133262803589143415795200911493978900774038090549304940125132881904197616879607488347059205278882440567897473047364196397660874564436009788564018222804914609504521155650342860828529254758784063464122796527494366812502876693931986353223526221052841868699157312818533857010147248893228e247"),
           e_float("4.6310434977301099756972349199911040480504943158678294223757507131988627201584852724144426646871997198181568984142937392697647842553218341656717853173644914553762868415489063205361207965925026403253076181339484973023871164407231828908122858711815020486778867467771954040392409100227408771681118186642564554024728360269665908695308326087226565574730591788896841938063564590709439125212997543183160590324e254"),
           e_float("3.1697443044340826704620182430514031942073983678864747420861293923361526120310841338593979776656271743427478536078414353703979824943190998625770628856197284938801906512598933865312624731318943033896320542228607783511826017799966505179931524896321233175067445893956287127764334464910903827428180465907024701464968265381111775149949281029080159282068334802307008908813841924894228919450736914179040547854e261"),
           e_float("1.6270678279796921238017939815257415596955914059396783013219314192888888187673754962937929060950122320796277084341836502576187682252266692556383707736992634234310933310229792565049886622372089041687271030383281005025773265008969522091895211551853949796428214595507535747538158642103476549193943440662222116618637939314240743927908116471903714706641584411824393923737965958578164815261065050338461807974e268"),
           e_float("6.3271101543964098530474016613036931679516774141037902466964749625618539627556626917066390865882805315368007780029151710291322678615026887171757305554824571269888882518436222554185125334135553429200299313673438780505108450763091267226352239443491244145286557277296854314750079310039678939648497484005920016015962696715152875304004121479534414975349617559226971461436411222272327975886255357318708210326e274"),
           e_float("1.882060909435811597447536672926976443113625219421918025813784456305158725665515973213648120618213551190458211880047267274039045060665311221299601352083117039672608434443173340485794001648892141684499716806041359812588340729456102875380845823961170525669015140826369366370939261722862356226674813997909830412900310435099706304417126243624098231245221862626601192513657089248551628873421996851663935197e281"),
           e_float("4.3225104040626390356464420141164187338409642334951188072259882632220559400988421048571414530850550348135422488709606288968920942727002897013163651046307104443624188165728821717008035223606728458845095644638218330770129577481812523305289125709684182451968043646966773867327433684333697211565648226572223480651968328949062950990363248794029011172735933830704297000753896911713982865162319146965566032312e287"),
           e_float("7.7339317726664876634667401805027148480834608371818107793594370211215018048096793858724087441303651360452224895615964031704343341247777515552823511859643401195535502421070291724993667041541549617721197011328148162690990016362085654305411898856917457518177615590755006504096709676348912244562888823982785813210250217871436908316357492692152966412397625827744013546180514036643565021590490881226950424446e293"),
           e_float("1.0873346376703889374183719783592719022283465661233746109114931641394333107150002888120550342604485356026891584353968194240205272124095248486207114079463343214191993289880380230172708357497391020930392928297309059563268729263178379317599757137744623655749306770374854196265502901397655418103067083974803020373208163467469196954094244203513974255084011402375152596750303795977982999323271480256659013928e300"),
           e_float("1.2112017921524672655613348070661035757890052584831086879117075175131231562188642578619251940610586408726786640970412616846881000410619118037262827150230009846539617208940026571951878367720144128474972845361965877259800815154083737592878755137145224845294013469777834280955267653950768169578161387235529488922833367909945961856042666103782390548574519607190041474253713526217160507267760242663790674183e306"),
           e_float("1.0774895155964264489844857818210267127653927989520459407542917395853760873494975575784710180660510130325224879591251353617159197456963098633125406127191116947025993985836112258240650142173083201658742368742189703191131907056691174127617673866165746512729434353393293827131816916749280406906979956459204593313053780719469363704240782973101525704559101614323094329562368568864775471949700267183826768919e312"),
           e_float("7.7138730565610978054535031557973037156794704072519970961933137190578617200980822109075891485431174278712044293075285235579237579986854887547632396738347930258231963660289507762206425058029260003249197766904972501277275212754722056632265276196651315047858631613756169852175644808570891815818877305044287093401418619399321956960085539348405502590632212796999031652147507275188605681391037445979244679798e317"),
           e_float("4.4769948409001290855466013900866355437231398189676443387100796375494193450133107781408890247512964845677573062450636793040074521615098750250736615184682094762816863370783941059427250134949481973949447381944192410168019297440423431239132756255382253374026911471533017162373237089061838244058070165434601380065139124399110093736581567472924059585987271000600407829114950048355778428319515322322673491e323"),
           e_float("2.1214094425651119337586247658362174300784353215914055577670135012074506631033037762213080881356013331933627654469584042181224864484773682957625261246749862905022865156452155796371837277902650129916906857553021047099871098537042126571295423221557386979811115960168946883383639017597918621821399331060231284360709859980886963790999988796952348760387682044685217294537309141692687935998774304465297827247e329"),
           e_float("8.262997365523041143162609330738436303114379920105979454980471025056343441209053563236289228742113203188028558765326628007478648248361106877228562099974977903352049283646985668122663896882117917815038186315336631028950394551312376988684261216427308042570004334880616809393801051028714968355653644106690525266974100000474675295298427203509157958192043633698031002095048885983350978876071936710729035069e334"),
           e_float("2.6629584343115836430402669411670320255981047249061196599484016705393023855267119930363051821513953921053336765382603461265101667979174676851247470889406959846675034424145674255759414376180353784970575883433732800952321572659795043022247315592939365783291938956325580075365117807733391502753248147005316361250358069052720027134595804818859704108607361369516636408838994013141544765787558234257245505386e340"),
           e_float("7.1455362777319778542691869671864958015137835072127763271191863868154934483941967037924702763129944218767732784142200027953254680321026747738343306167448622227403494124843555988647818406678065755270568553197288501697626196437785166000440222432490451582778019251955347278532510263895733986339903915516815908816829744994436501416774586510074668022971843532807514350991537149006992251140423562353605033895e345"),
           e_float("1.606108445372230094273251017869118977958030511094877490137107550089603835324796350781590574443219100601499711350121246887721604286876511839887790924949628345122501207080412800281631292313990242508861504070036055327359054673389135980494426565094523980155301288307831205217343775256429379153441617310899664340243958477922532952023037716732712841152137762140647007926625621370146058204120351173992710127e351"),
           e_float("3.0416589734750001431052150692349900988314507171168812254656323393936863875007282456677156843750810471787403297165620774211211908837093030120459957673804514666218679783598149506856556423537882143674410784374718432567685720530137183248731778023452720675798938223960116106925565681580070528912585769407796650021243879048907800489076909975901195027459705394459944868629873600188612042266301322925650094717e356"),
           e_float("4.8805852955557908955346716655518438044328318390178362643489099344687987862789683978266470124978805244488940200776005588246362268149808887379696384477230336529419479817058949253765790860630231763430956714583802920113657193619884520517029294351278984559186531555236369492963402190518647836611580150827688098012433304788809986967340217020011108435261743916611969197302878804863755453779587221560991175653e361"),
           e_float("6.6710943339089726635895815329132604772360347004953896969967917482944928887730125908643877077673357287320994844806945334960914232279981830148656024069867095837966944185205098705279083413884105403504716913123838282227234557419074669216725443440620400370057955414376239823096171857951862117433421067064582913562689363880061473914642549090420942680661037652059202615052584738289767662383933526787923704482e366"),
           e_float("7.8079266928999226956186012581074173493676535271713388468253053711389744568997295465302779871202993909272471234160654488337166892071187273344412410579960552101748368248086942571218153050988058083271703249861746425890997803946848808930478435198598705699835008237550420070856351276969791004964924714343044242868807653770398912908537103178040612010993664593895702287575135541657272380488009264228022154953e371"),
           e_float("7.8641664375220470497014855912879973594681356742567255937195710773801459408943872825231959861014867673992414173206163594835136536803358556070217675908812379887467977836827328174102007122793052856371215389266529254260981982212713610338931777659041970805609319114204165038430303341255549151651023486589601904198753774556628938302349297179982926207021934244924001877339104174456486535994638469805263101738e376"),
           e_float("6.8490670111649868047252082820176186916727135177553452743655515083365875910388812647905448484961508649385646010431614422167969522942515242985494987333007556739850881832410211452772564150305697788357994475184805643598541752487614702432044515904660862629883057512120085954888795453069798334423629167029583319319429238192349887868355445609013153931041822606363375819131736899325392572793474359089597661964e381"),
           e_float("5.181758271805438210244690289525204589247557308228501521218109112671269338512369034724622704292621052669977093792813544772147503673914404055715634396745708031585530020398596047409131421116769995557995518746112611319453753231179104090843413248639499714775038160820971487115921278136626896629833273626804972861759421095736590466217778890417354632114463006424637585237866983467879563736983845855374013461e386"),
           e_float("3.42074058120297710165980125883169864201545526157746660217063948349206545649278569978652036035488932350595719851136982644140172572829976018173836614664052307260439949880060869758624140483730922104796184001458340141271603411412321597056154118610338365778770588329208992947372025212140118093961188861879389449050669654179300193758687647702174281278542056096933324085072262060575470344548537760601313099e391"),
           e_float("1.9788761632621350463615004215694331129076253551110157978214622041234905409991268529205215659208804667186976500239977301484263178689020565107825805067218590248758145694620219081917773614192800704068950014360905543306936868166765441169963291762353781768902265752516673833761941790015707155250461421846029846904413874333553760017467330990721609763277317164842433347051640248250253683872004819645974055631e396"),
           e_float("1.0073066323334488147747197214721395482862127429321561208665633156222346250017472949327675336394103204630129780744275073123921367156897302013025686792367117972445522157159884743660704195846266357606722736103228989643969447989929990058002147209776167772037517458892144103327052225401453899724962212730101795220165278568189809722385122452688894084715061125485362092773370974845869448585745547605607731942e401"),
           e_float("4.5297281576186837906079444816855161702997994562123299219388744770473796837841616914792884073767780703666716962398713991502769588667764650201209791378490919744892837307944069950767088693191823233857410667680364856333654766522773771399765266761731102141335063441780513317236951698186666159509478294989536158493552908986444608987294667332439403323015190260816622130101520744148733295084260333950738180365e405"),
           e_float("1.8063797308965059228698046549209897436546660066108320358182617680612042264969004385197516946770895959117503165224172688492024188268355593311359114338738371579096196485816538702331378873533677742632010078157218857949500663284437584356010796360211091868394285878001085105341160151902156483275460998999713897710411590773412989685001102685852978326225385614070550140064936484780151938510910415854196520163e410"),
           e_float("6.411658902517635591888623016878321775905499077421296841056803084179572626909917363868621598092788468797242419090695103535543663955180101826789593921790944300323410312670971407143833966978880615747531994645192300805352886636180469569622390100653764777301597663854820056188978180573608330161765191093927971024767994709969131529473501450773039733203574153580989710919892378642918251346954116164905047663e414"),
           e_float("2.0328041413366377089845511630990155320728761869633659753740825346938556822606170680956194037741143662457794672987904345282303129059380700474353205989184151248849648740919692639630208319223540755271519948215250034142374648049318694389359218344827283322047682354668231414784548956188595569075089200235539913778641436617065407181672477668092327208090651264865875169383320883102254225350049731494264078088e419"),
           e_float("5.7765355658148000173189506963708937946561745130873471711039394956197399020421261120557049557719271112574800139246061834613571779374531649856632266525502560064978693623672531744064619838583135441416542726733031388746263334908223221768981028962164164774171461980929228262370107667286728409810035337424430541388013451596446569422457517292352077939987584255950816791244615744023665155153858955694316169747e423"),
           e_float("1.4760978036818947632120977923248806421248865804342086518424602162093851500698651400253325166353335370532635942233754726676278040863274564863705569271776222811951725455566755717163175486152909812287510320737964004076737597763791917949177259177116071323256263134257755573302406654707046670365592284982638678259011614594051837947972760904220576421193806282904401412401412077064577478626746759684502623011e428"),
           e_float("3.4026375726492461655988481336157806961708737059722475510006683111829299343198203922034552948030335558487514442839574640541954309797381993587939087823347570868678647634612215974480230138225559049093201378537364861976417638676683027424627333048008881381490689167593221971757697399503000241232438455814772911821027011743612295147133778653173008234411488412893836327820258292732568620534126738102403903034e432"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00451_bessel_in(const bool b_write_output)
    {
      return TestCase_case_00451_bessel_in().execute(b_write_output);
    }
  }
}
