
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00201_gamma : public TestCaseReal
    {
    public:
      TestCase_case_00201_gamma() { }
      virtual ~TestCase_case_00201_gamma() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00201_gamma");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::gamma(ef::tenth() + (((10 * k) - 500) * ef::pi()));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-4.3940055384053979887919915667575668753869325512014433712102785202345257293145102740129530493386923071876272786175943677783712413369884522528983596473447860226811792698377498505496227798105437582221221822623662209482128115341557192380862142438263527313902585093890327061142840655159146832189728230162243764148087860047777628953293168233377298348315571764463823380545354545095516628656236504683089404423e-4340"),
           e_float("8.7579881290147916367868733634638004521912317851397041461566139540444413525766408707674651392920460446735556733622603797497466048630364491251103384330078189640481068116807316479926866005315889085520274028719839220083056752513651544190091986371123483124022110798683688295644905445778783800032536364901046646874325538175368646781331116041241110878176552836604223857242433786653970197794240783240209999503e-4240"),
           e_float("1.6236519429138340829313777328912469321884295486066688634268115889399881834909864045463615834497408294914261319365194356279840272125809257095530239936090603763731730680435260021827760533115892956135653834699267724333842442243414641556593600094921381829243902822826576338112801902861770315269218789762647436618758039688927078759181705153628190826841969840356470661744726049193556183855206758828845317052e-4139"),
           e_float("-3.5059215760672360475842379717821658755283473164934044605386736386313237197176342189015668759659360146549038199956944468321743316869004603407396127736673099681779387774678862461963639493481245324591544078901189660481548954755623759540814711818359966480231762036308924558595209078001671030583817846293262032705264656761574084821320725027100619983718628054011211486465214979263300168232898383485716125871e-4040"),
           e_float("8.9459035298283356180688586142852661108340820792035558620006269494711965208396983488877049668195402672348917029532179526157780766538238838751853191988678615705033818389056554189708813512022750605576318309782480659433447600772759518708053211727882252423437669816266883206118518908009939960969825547721364755312932886359091258131444352148794888363115383134835283030013733660946581770981846259848821128834e-3940"),
           e_float("1.3098658218753384897582509946565525996137984840901251234545396775797942561534119615325998201167885184844431338217815791971952442979792570270640959237182553877417182721289711071332972978467988740136385104694717934732296278826670793080987245689835859565748407939426273354516101002034483999030439461965497368876780534509877678950707149182109574933907902228830496001278503826689354986129639409562606785802e-3841"),
           e_float("-1.3785791052728381167137076632461936324824929417211786670440037954143160754782027243547456783336772642111230477475083953283570813983012890250240541589216529766048634136830584265404850636909668567107008099666655662024820664341726938399005587139978046508706311596345761005326336763639706088224503350427475887724424939874778787578910769688550365720945085019850220429388802749326031347535711279526052032975e-3742"),
           e_float("-4.2312677589309901496798740541430295828668754417708979078068961267489224666640848350165063238196063182533023120889472967230309088743841393768555654980411775893896520575250232020251897610804581682430053897527257094079843199903985500866668744819798474314727341210690758642259253698920077597815325222176919267224477563265604759319107388977312139680372456300418526996018282268840260343581247490538170907877e-3644"),
           e_float("4.5308222642979942945327112387435080838517285350134936377023605800413708506567108020956469468205295835636229562771994859656368371265373056410941755145565935757785778792513172115441086264827119705195794788965318802931198876888353756449587146020557212592083049405134835015938964518276826579226448752526971346976250527092870176910444330704544774909986954484477592088192989247181606563409756140086223639611e-3546"),
           e_float("2.0949188505737214240769598249466424331328726130188965711117142445474107495722956733146509584126285038788534211607541633186030556003715458660945560332208236661770945453099809225745841591758899909594407768898392103432709888932532570052722868547226944415103414861271608357737704527037531815023370346077681970154901313797655704469128785299816350189815106581412127009265339455336711523500839968617178110071e-3447"),
           e_float("-1.07121930597554519852066368856462732605881700883664141516685228284102360841836292155668880485752328958865071745280964167161004539269879728846189215318501941590645934702810641255346830088110572718682266891690782960187430741926073964251806286946818139634791074474563025477980859952927968934698606050307420165431006381418778576168677243869651224682285137016503109385280061020135221468597372601537110935e-3350"),
           e_float("4.5082030811881815624042170182771477125558286778180456395699815104249212980224651197182766881987668855971806892526561535823909678052148733084394338521468730735355943311355156762183191877132912119990702946655056364228696810578874993417690631564229933091180888787637246745691188006231477762018788713739047450699906835259683026583138462400661234317883813992253912997179756354080018713809751016604623974348e-3253"),
           e_float("1.4736028073200573108841231908751574371947429383020668300214891081753138381237251523890173623503693538470453824632984406847807483074728995799891039593831521771810459185657225538025895863496879349649396718528586132144184563790662882775074658401676644144692844870659860993740280352570968240549473745832254862873799883019831836290075201787354471212418598045823237678105831423239536587570486097509175079403e-3156"),
           e_float("-4.595833799823454008392358892147311234740053350917122823278815785847203494113565639855444430709768951082498298806812802992063899076819050692810173748245097824323325984789655210508017043299912602765131220097464986685789238693933196730003511458909477639053341925899890833574893526408856076367636225546265331301315669268500917729288137471505951144261276280852634502536116231584878145052109489133736851267e-3060"),
           e_float("-1.2321333583842080764622437207039002907641794343911584820346573857260916208905464556673623369743614264289587051470036659781572179949074416840364901089638601050014420968668125294364215319641592240914785241504175743577112805697179831623778784671628400159015039721292013956548141225351293195733978605467242851351410009558164390473265439190788468103072876194206380411177860594863928891223310292378829730869e-2963"),
           e_float("2.6510872552343828979887002160536154728682194339946899125578501686851682517110080472215855831708862496571744108984168697568722267841184691868130460342425272936493682883128551925928690349885434789140623991253551609846778080938247418689882118824487888393973270007829871158007115871693388222994579348316261932011512772451543323997946210898966343683336363520134660914903292211563687959742673087043695536725e-2868"),
           e_float("-4.533754267997188368357382560282773473312346552104068122488033826446035091086421679406041854102733292780097623480677729950392523488661633978287271834098494825788320509442738894044682981224404429159960433492417362992491712330502305200596612756827398060231308135342135626332379414516082541455007883861656136589553233880246067582767506079099024277263193639880827044752677346979990519194979998228285036701e-2772"),
           e_float("-5.6870073756120995431386110036600306258609756335222050508000978566434576925861085502681400397067316985335115580771662994925150158657038506843277971140481347466880046982114224553441972195917769353770325674926233864180501941753534277500988754465365604450255243457515666968045919898354089482577733525231137264824674951374995646594789835872460008290909520849186858346102934123977173838463094048074225111825e-2678"),
           e_float("2.9496467889238292515203422601105637194645141576455024637372723832157831867659773599738384010749884979003627806106273055349043555247049786573112112950843791743664426154399335022395325684721586143440761070619739653736026163220113858268545002893767717846137208609258994461052930701729263616057039827786143925382992604288203292167842950456876945681150611894427082288236439663643724531702268027532347257736e-2583"),
           e_float("3.8537755772621900307192126501954262633997512661729687952136984677056860465821841806148321492991913561327038132437858156781348240120613461967750417482834439535610891512143280287193432885682862328108299229915393041591014437550007107783237900742155902750482464959035199186766353694494591777884969077811665786965632294685614325818415322862148348751263381795454774621531718905238918470110833670312822242668e-2489"),
           e_float("-1.173726543055987524068557320356354552575355106330300695503507283423177127173057990484784061094692619056167811220585939639675800575305760554886997196895106993421703767475880657236315461842390692006482193256247964693118103405005062887072076999839624269871954293313726155256767856706747026427336065460225921841844230497388167472089305288581683029770930082865282985330238460439514528333500182172777654929e-2395"),
           e_float("-1.4954311043156260589351784906223263859031130382440080343022054336490440340913388005058411250202834843848396503995167456008118510166304115179639159344347187316790504448020869770487701170587380018292771873503454837360618736539575399213138942881775745372403919854163105825563470043519509414549682888195738387531641712341335058373137299007829342335136419446990746187142030613859085693371798088203995333897e-2301"),
           e_float("1.0039998883947382819680664162661680739766654948185301775570364800423857086569642426325618663002545209265756174769648206222342436683512696754074257501528117779207700418264831372561411959092368532120799606539989316083727070079066614338256508146277153162461597690687525601046423201614707194270086764036214236348250678959646866436010691229411063093697674281657856637048865876842786819251599342345740734698e-2209"),
           e_float("-4.5297662349006142394990866772843087547298014617927527804052723099533340147149953100714213591470668583590423325803828462168656943817846044932307115021716565090556736121648650889777423525797402912038451779487143878578895152485081902889115066390948627372894363360601469117888503824228931930283851962989344605924879532553058288307630842414290833148440763153656436030987177077486539351358104423028895341999e-2117"),
           e_float("-1.3014813890276287165819548982193175161134594585608077907314978878608521313788753273089925918874345157867702100433277750065316381417540365745007961653579522884505756412787788336708681412122091220983870564147903526041429099963538533833874161221692448678394633424763971005190608938999676001060949894370983786440859038527503541915679116831459696131695327482614419887365352644027673247222476566246478502515e-2025"),
           e_float("2.1364344092004532192933223226551317838454819005151312476529350717660339707397047481166151155285489242734458073297645341127439281530154630868609112462409857663357571156158772419710066748860817184850420413471958797568552918013665168784430385104622513202699110210134437128896794107054526477755605920101561625405626385243224368264566125424438607122088287414803951490753679449154459146141311066773530499299e-1934"),
           e_float("2.2910923761057113788988331024133904860183647030287501195776557589662040624780325484499042891930015094292531727233957226872134412585210232047557803966323615819671871592257181157150529219412634336039001507479244933332537302293292839096647482969769068619495144585625530822223901679427311111758424435681814958451158199688529148072110859839866248768433189938028918759741227928813650739342070209348447680347e-1843"),
           e_float("-1.0833444521825272635619636992366322515265013980251111110602808514632610297060083312735414557021308974050251752470456720827053782027674102280511681348322870689312134799167593127140536575122120189783836783978584360783832164893524498152236361010800803389558322349207556102986642377247233541923849600626579695176270898344375452452283192577901250318602622712679356204711514690857707131447270586199562880621e-1753"),
           e_float("2.268395662435469568269310136949419075867972501131563215803697638900436984174005213704697159032719333293620452180687053152431171451057272068822420469508236590489779650861729157026860564917650167241299022400388908494992431633441961318818712372647946979563039423898817786335113930987003997690550182781469419094126710899451867754133306850551178569194938426035705618925635131491184608253000972089787776139e-1663"),
           e_float("3.1209706717849360501477244947297251081228570765579269385870872180542343179421655174391394713003036880646936640318007874827165393465765703583237515676438243295581949019059381663734717856564753578055713157353043447944954313343502783990437104693130185923592989307911784901466927334164552987812535054488058103931744252361959267871062808893993437068937425684937764512527785164376329978508094802392853593243e-1575"),
           e_float("-8.0126269013535464473698203593290348970196022788088062027667599225600100340406575391607320315227752103626422170260506220896462952063171061869358803016698613407205186350575099478673378763830774818226089114767198847558037721119298646595560158893536731063538267449206758846763939173348173647680189962405556234462554857579587395562704813879745343675711293396383720776436502658828508003982789119454754500004e-1487"),
           e_float("-3.2424971781458091230722177477450572539959329011767711043777224648750102033258357419036411279404218578988957871572869211585816572424416595733370897217304867072527636948037976528016631568826978838166798276652432501586837069134942696753554319211074043472064084054976792426348836101424113612278533687381128085076209417622749920719218168278015241947165373474590394839775887244266662900464510475255153860579e-1399"),
           e_float("1.4280502463628141816290604770750707969260306053722501363793834278374783559269397305403710860743229111078806792699771228850841800786631153463530628630158459303602792546851974006014565279411097699992982680053336734505268193629972072097801295116861701698188890557428607994434618128367637369743708625610950683527981801495814858921519337870634834074544767047442315943041067987181704954126149460695800394093e-1312"),
           e_float("1.8096091552782900029309212391849588419060459247462867060983429735230500016409384954587195120300166604943858889724003635630492210055204030664746172290188493735608311932822196911349059882213614150540683463476778446081460278610003828507681702987196734104205481786424259794238078814939595359800488073127378824892263926284840325781105222720300586905954393187110783006999461080258330784494237151853949142371e-1225"),
           e_float("-3.295217431772865005669049445504540569836055102443379570782921063084983226050062931955849832336735266806391169458860596527757079769137385996684968738100727340396577683815733893760200655426622361655039197259398979123906731330478269803324789621272386027587419562537707756868822567655833928656112833767447082639083604790538118261085874367949324466988787727100438804555297760012808476801222729181413696557e-1141"),
           e_float("2.1086333748558980515687899003908108746068872689581355663519900762147788743393992582516682763739398754285840705991052521696502280242990605676825959447050278200881597238650729307960900445214990883959914875339449791554268057540117415441908280046937728708247443268086073189035965510232750576558961405796580342196881785070116612478182366504963474773271443839538713819163617262017514714949639599800609642915e-1056"),
           e_float("3.9415058824002178231381634895654941132867376651031022616651202496936239445723138122579334301920776521983193514481374431790552564690685703017627098819050137972465720076731960674295666460961800769644680107583565530272752930600068786624905155456982962804931626309866341356227520055983600955651523235723074488949008122417411291622664896560250995092181419662946505226364327555542291869467410147629947202233e-973"),
           e_float("-1.3147989863615176281983304367488873008077701062194016929407466700265551824271254279360033572763867889846056011771114592668322838225011269594754906142915795469293419203190762057044815208540605843083837097377277754084761668767087003532015620398255843881649106797400520847611987355039007013293117247861414208033929565216636688764108605384973554925469607948697549018518541939882865436636638232729846009417e-890"),
           e_float("-1.0306093776060914048947345156376061975479781244814140975671921293422977159771487199018729454030574106674947642642786381677228650891967267980750709545327076146978035885397173812647671010394042193883659061113062837466592874651418129327062603599971680231069793377950786014484227848800330674801706079064370621928901439756275891522865611099424379135916114094390151249188939788136255331006647564026806191765e-808"),
           e_float("8.0906312032971477426769593283339005931241752724700811245186802284670282251076122055803210671741465581918115456888316914825791133000827572662642418391965663391559508853335994998765065624372213399443258072688786316852732418435057338756879419889478482055621768756279665044074920889962220205898420820781560571246308136936919187922426025933022561617757910474859819970046255437880888965100753589058134261885e-729"),
           e_float("-5.8421697067320265178352657003034550831883262010170926109899676267027545574532442616518626267820727021032482183977783434198010404037982330206772758126864998641874863829436380170192606764629666219831011599109553496074722082125339444822663269890155230390540566726244202077642031149024271083605980486929037524597998531852658982925433667485622027632249313472577982736258907466253787437078968180207220451628e-649"),
           e_float("-6.9511449476490376230874932691729274431026616018362872172966527891972378106298441132439182930581823105130351480554811117073003327648940071419962341288716241291204375659695841344166996454195893716328234516587472756465709337703971576939476999090670330644106241457123438173709506139764471674492632398654358501326703621123829728268426525364034638626629716976906283395573816610721661345431647171924067608233e-572"),
           e_float("1.6809880132008637854302823075515667488762807446345839631784861032942620642168588320542968385445672869367171755316444294338906039121069369441516381298693854408216412644629308439850895968490218962082601204632211322370989965424572029462831356204102818840837954356946586738391184868722032362310974452140421961789130259001463503017487313474749918657240252456538390595370674929452886802116359403133381494495e-495"),
           e_float("6.8140988140643492269235220839043631113750767744722527040724286267838980492302584746653727008373887820101865236851258718791580548969765867683274316619138795698992431517991852087720008876375597833029194376417123667415324134082169014308548853956789295185224236773697133044820831206527467422515861972450140923414496203073586575656804705381278139307604064161506384098669596997113003357711615941400378601756e-421"),
           e_float("-1.5491160331361115116084433697512417371458263929823631265700892990910615945873981488051570647874491729352715538597913822651519716224591199573370108648422466642902027181129976171270927641087306105140561299001431476116717255195007303600642776909999627500440250722766832400229770582230552663680941625998141166616826549372326161585321574752247407731362816815019161705494502781231767751775033613075973541686e-348"),
           e_float("-4.6433626457615950088166270555497445238894308164085069738824672742207602170461607831413853624834367132981388471874332310019781862989679007716737893546776059401151616200916600064276952611982843962416758389900070793556790880862972889962288189297307148134247042696370365599032027058189270955479958131269511475358446574637715723444477261556951261104730652813233094900106916390087411946220266340975603477003e-277"),
           e_float("1.1157391082943222232728389801045713141387706188747251347792425134203843588276813346314288304455914158199594898585188540368552588995902311308924226922099311932765863261866027636684258517051967440284063757037297691737782143558160610022295533445367988891324003941193428197006846900872156787077039965527623092307043645598345734470302613795027557881585777841721607833498936339609851221737766306984901081925e-210"),
           e_float("-3.294167460944391284838914946744526760642289589721385575845552237381630223056002418575085631419929671363867091929268012192425497910043659565611513219899702593934745265889958063830807659743809930781310907279592293242022629811765387067767007251654442679783397941412864843974932874495771549460122886583192366369795591717714014946104426811562750545870456019165267411837996333542061495848794704962079227846e-146"),
           e_float("-6.4594077593622821485983514068524414348135133976156106149836085115401133276455946456124695617274439911613939747557376745421517362191845683455898043017881374513915592655695872007108186499287416523271302463371176018795619183386220059640316893154845538377425188245868875682842030732173631729003192506648649740704834733250642033927552720105988184327018424016394246842512085533315271565254782655102146287752e-87"),
           e_float("1.5316045014399602378308935443129539390259549633110990647887753102342278882121219169250120762129103568981579890416231919245434965882112217157793946144386125285344023228226852108505860098018025005784658123072445150816487799249051928738125089744940805776459782079266726318661620829945380929933239484088258685378183028967042714922981061949353125099033107297175723580408691207505960241492496508927774952635e-34"),
           e_float("9.5135076986687318362924871772654021925505786260883773430500007704342653833228210115371637942664472097973952589211021534398110449840829907939520968633135461868090666093921415266987443947462056052945940983001627341351603564332481255922073658659022819642234589638764298485355791447803444130475970108860521715535213151027783021873866710176377025530688737305900132232369511327337747876354182498408103002856"),
           e_float("1.5536175269874989851396346266415687841630243878286331654105116723368814558555928588193267475985120172172271202657430983061076579174309318863105333863056253502921033316092781323775666092492782163233953505650842448924361729997820225589446326222046126452184781267330252190450852071947412037953532707960554014432394354010130579090208289201774297613716014770311821905159779826613870158831127112321190418126e33"),
           e_float("2.3742611819845888850006564503277998843083643272096089420110251800470858826106502206587058718163104747542158502866864574937772605661671905314082255282333127483227309484436521550308468722658948935546899283466530043460324876227034143546597981737901251498311046997088374008113876767349256431097827465276000235298290240039034020864153945352332183806511302682912977609682269222978316036354877613434646666322e85"),
           e_float("5.6096700305494224041773141349059634848512345520816816459098785153830664751595830796752941057742287311281498084454771702787176068436490375687428926468270430054593195734245322740432191336017033975905397197736643285710187846122306196725110680748272867024398727814093248055330445499394669930854900970142194819066351492836217574756830732316447400960659172651738386911076144936752944065507340001107649156967e144"),
           e_float("6.0114001225802942667937706229260718942033493947284001766696841210740129838685951429812002556475286168002413395256710881253561810245025488610989209509058167959051079292825788379834869690331423158115852291532512108009717128408976316319548506313807736848565499776425898443071138214195326459447073705754245911475737995908739087726077661476053652803293149071135754040877043896865458615777237381794511528139e208"),
           e_float("1.8519692594904384091592337268407909304270502208838363276414404558962946458511713914153758556239132584270454734748507322557099484862280837912744521971337200128342597536315527940536231999780495928778120309468814339048876312828910176978899754098213564128178905377805144473750551317932073219841743096700456548871587947488041052745277712049911233654059195074202426066580937332340353743985158084466402628473e276"),
           e_float("3.2406645552002526309158789868615129473580252607868823828488741847532626480894406500962815887712325537810484642805283756696049875751086843640556684384365874906685648639684948288138471848847021245227623734098045885830299944283049568446823851416209601183257487078667148947521038721591929194988004156335466248268318911595394045387974767184479211219187701049711428123651116300131621637953620434729131491561e346"),
           e_float("1.1044349226257792606091266209645288126640568562083716707603990896473281041228161984954423639643791289405034583256057821003579473678300395846782790954929179052460261888254168350936776605156553582259274642295619219811108328666757076250630725388324442083595214767233788475755258021203724994824051126811418101395494767760043927380211002739817376135361503163389515969152270146832718296062556202345038206964e419"),
           e_float("3.427872699512829396605863423264408592111898544325445505369671677521375496802210102385842701215427000781399182257203382989986529216689160116403472406107161788243942630189057298605070833118445795734228265306441488006411560418015743657209669202101338430272073036110343921415114913815665770773520598210032297130768649224872570924630361714875803132309972763097505802181515739882647397520603447156786555736e493"),
           e_float("5.490183660030434073596894062121914823472917786914245450665547877093086029860880553011241571116795995854984811080748970390941231922859075165985147365586935639258805393586176460556779336192795162457170284200094975917555108854580901434379965552735013224304442592908014506838103548398749915362366720937080251937378601586478969450808714294762783329512624074618234891336878752905063626609243140030346737974e569"),
           e_float("2.9202300349823703413820294592548318822972571662045448206063883918596586209727937731006992383123958550317159880255827592782834344386276097380886180493545437832741782856577842030129811800299046646446724794673751818942683265521577250122364639775054369112189972264244797841317646480752496122975964784922027325089089477678298853271119456910044816748180142340596578100043407510167822767206667315878686657e647"),
           e_float("3.6278866073432690268778634957213715369173511184449468972814758449782903467086611312326027685929031932569120690465083635348049550962495728012617576755256946655592443004662711889859760618804571304373206767048120358352667310096500283372969868940704613460882211429762404410597472004783035523876467538449230210408028467040969489176124423103630705603057947961280303743291315286381052629768197203067347600911e726"),
           e_float("7.8956714757270373337410848224259309825242124895273992861922605290876026189635239155289687551049024714451280215191082195202633136285641010272534286347299597897586841813959071573756335465345609979201417543681202508635246097316913233150655401306878746497699242463267253893028523713235294857619019378540911938652156616665531179993422024201414052921643704024193646519420330203860342089786288403285402154508e806"),
           e_float("2.3693845235970595814244847480782202958948912853990147500462051171568499959127777765813503898856953943150259292275722711925134479997926336279348587630888313987608150140986592266015413714906771414280806168740679461359164498865555242063384827281331063919235427601363015471508971875130972704734516173164283034709285696314602855122306826890815975368195292754725712032418319374035664418994160731645262923757e888"),
           e_float("8.007025994308717783682484355499927503455982195399456388108699390164270697812522417414860173259101699519983857692585719245463944597402668267097457908215357186358715882387130307452535130721457264279847959835385157811845847722126744264942953901405822463040047924212317954300048852122955027924861384641825436865577687022804625809691789106674097125443815647535653233273718655881621137512855857744892195036e970"),
           e_float("2.5620101054003729614898335721392260432367963750212200197149613610557945558337316335074549437744565798339330819194882852682836394339794016086365716822064596372721839370642363226832157835848161289736484174414886066371696195121188411565047754336167654623417207983424218218191581617275616059836222106866655322826495595235673297142447407962853397457816045032708859816834921370267046961372697796224284892525e1054"),
           e_float("6.6791893580907761808974661012696349399289288853867365998825194452589942367882971214026430586522873645127319763322682720951500041659782768921420731258227958780493363816735878175144704718431469505017200349712610687186986036421354350941439973815188317701090459632566161368863600195971507333715544182994498615448719881385414573279903230726324276591245356461191342601763708236401370365938242438940822527878e1138"),
           e_float("1.2440507683958091957849078371348724418419180055768701355531140783164628207377420060176051920403586645362144598872894437897447592083325133683432248517672243448895714314450307565579912522664260468500176524925282791323261220822619645885333348959421660775891667059040196881276909642817300172010358827200638634285578343947869363486036281914580673243492574895895130347694404034402181280984359798475735148368e1224"),
           e_float("1.4743229399145694740259829512075860709877003128516733061847952274246571799197600974591486606625267824336182591403151573086168688795099130830502684344488189049931162602401888206601166506460667688381798700853969149465518182238368477498887916726169854704267968792451095985096463915889594029906692620988950271329620585176372844025376909075852688300753568892689076953804985324394666141633200684029291441251e1310"),
           e_float("1.0029091091884302454001264892057033790826684846930587178156737273245336186397050277827358640959121842479267356481634789791431557982688278376810648191520699540287462063255662978305785162873638417556243234414160617756856437154751968053547338181416913823178137294272110898459881860341507930725299450319583994242304178606622684143391850536559099792506397431106629378536340899742324342690690057178996876905e1397"),
           e_float("3.5713900081959148188210297580127601846274531050738101944334243310642822943349404806713963290992389587034504894849915568126331675477306523243325284598816829435186672411839409141358857869816694541514092340811754214347222583508054973733720169073754166916080929660500328394439340816453940818617319803724662485762573052281362292439944757996723666791900228498846677070320751534841568278886904428810658024039e1484"),
           e_float("6.1280268594381152241648476714409228769839637877457647252056083397306455244206655655337715325433539449935288226880196513615158187034266954289927241008282016127106075998591528021190149843644441688200927390850793635285463949648887101588402992357187769620397843599071329831885295926861171326556951598605294989840485874550481895558161952580095932590672543289285154046760200924693758141377866199774781877595e1572"),
           e_float("4.7005352199627557238219520556585860457958472077501376994285451457689668506974701652726068275310610351168817909779451131765541457935934153049333458449237466761207984719553288352216842475375126973285560718267352565680220483668651709815859767350048058229865094974719717909614358686918552225010440761851307431958792438447184230243149734256427025139238589573231254890405822501121634649852649335877741535358e1661"),
           e_float("1.5056296485428819250026881265600595616002884494243503369739503204739104715964546425477173732158510837224971060820667816855401946255577212326839781573566770746567934103389986138833993787001500969325591906000217714981012053386434220033405015868069440459619684945985515029847403009675976942036042997366874383422077325567880465458824588072132306420570920243534343087203011291136429736681299359261588305913e1751"),
           e_float("1.892395644910698414484711203663322411763015788187029296126924146292033876435370178327461824164475098946789710616490897867238398542452769824503931084403801668760054159043739464686130976890565600287015077856750318476252522567367576223997656210053139448444629071924694935342978975642464500713013277866328996777369521685188121750302082611157100423072718801504727576052885885937614948703382469289476103284e1841"),
           e_float("8.8158138100802945323163699493090756712593129009359560596438056223751313307584350885801930313765527889619894109271699760768345954418565139697250460264493661484857148960201517102939591502641272253125873327302820654192132050167273649434523674683800173630161339027210965895605839478386859859345741399967894639829722241862280310482456881659529218756053166422335902922072944554849981757321674451085480652479e1931"),
           e_float("1.4443993552901934166586079695929938764007106278668467552431021889695076851813268098888080990899060748669720281826685895374206907100836398609410630093807596637274798000921484382354888527190263809792639894710877336216208457224931625570808685945280559054352227344812050040944693267450366965146448657911321087248609499606337443847910981514295815087863738041021942068748753918503235625790178293307131289049e2023"),
           e_float("7.9297406504676428760866999069277719132148113491996552648832456625577966173577963490904267806714366963873730056899361481600250257272643791977126683862571299361057011549211484505653528471466452962274296963353814569680698913562800067673902876818575109434912997774144003314750113687648912141145951003959834697389624804699455626193648835501978490515882130578939924850674922499407369999587876427801228306583e2114"),
           e_float("1.394791727058714179439872907722097363238995980644809494078216306888526786900403821039966255687142732663128899868241345494195459292843996393852263962171253813959444491164378014425704709545438757486637028555122286568354645360095486967267827735914270787449018348148294604319815087414859141173591482176282209882569342214183685696716346281848971394977982956203972457273146744748229771261682630796808010577e2207"),
           e_float("7.5398450446463356256007929576571159036680961236241388569169850171785935946371611524967607180610127828012142553443092362412785034477516138390456340409395297359639125503194951772827731224534537692006936790209144561375379985419494717276432331027992036482502157986642534416337746586746959381183712175094967698814654480538522298452925180085111575553184241665301940755639990142054909212269982949315293339869e2299"),
           e_float("1.2050084489236443833357935554847684476124401606699250144747695079956036109900332074034303200360954871202032185698503433849898578391741988546027040091549461797301418794073520021083897011559015564169769495361143999383023205722592239525860116329645239481538712478203295938178441901450683017511646366945602464153829886087355290001525893480920728783883523654060329689633286523826990441396404293509573142004e2393"),
           e_float("5.4914534426183999126051178016203307747784254921232465931086765687861857813990094448264671225472544034727405940729387277942083309273058810866906100778210204354999631381496436761680248733399707860437529142808735038312249965224230177644498877174000048197622804532355919937222206036275161439144602325081383568176138255639239949775800814397975098547267408342742671443055165771834844208125341755923563035176e2486"),
           e_float("6.8986352635644560502281461268713467978122403467683514293817055748910354402699270696985852978242905520316730772178073503483350376301305448386196401592876451291787551512078761070632542967134377529333474508361484688944015075419920911830133363542034422227839681860158226478653688568549285912375944172154486599248244689755270620443899568455389667493098013373951238496838822967719085728194107778762841692181e2580"),
           e_float("2.3144396303514990581235883494542811182837911332695049088020138587672785729867990675280804414846033060135468579187661233221632376100514325757471354102900452859961308428306793395456461457734432721502674095421348713681415674599275426638468172062439542376086075905700425107451462034614883258860494724172693143658292904835620843031025911789125549874172681663217967105223266340502412703698028766648501089631e2675"),
           e_float("2.0127917007052335602113375465220593785525046474893796411767402919868306043562370534205921980352080316839639567804630484676111118337412950646482585963015468037277199929554751478038854502386034454638076970995814184654461157662456312526187574809125894997819567073614180208084646870305291911435082949244114178981335564253136843037442150840834343066307199733690249973664533783137452942599304804783475499393e2770"),
           e_float("4.412118970857419411334924519037920285600526083182925804761871885229790312695803924233922277387091272810643523527216907661563188563180991333954493101080568459355757210777606908224514690537836674846329244522245532055563979702092150857016015008513880245451503198123962608952418433848162487001830808040023502826203249080464680836703336857799667922467949554265284384055589088366618486856520914186730750282e2865"),
           e_float("2.3741729834967066529427192077276471601689593150379802568609992203445605138153772054665998980688655129798424595044625693758890820427135906264383264497386146729220248737533406103602080629968636043553288899375906702431902224597321970683254228153716471555494324119611639916160977074631957993993632918649732651991847104793095336215624901715824310781779647834336500663502516249608379716249724660219184923778e2961"),
           e_float("3.0588191778436375407964431594423663232177011793124840911672377802750709905227533782108531588563603214696922763960889475297295082843888914603646178143242312325113022797649190978337011344374027639110467793500471558130981167036506533878839717407259626003327016845015401796082064916942005626544164975933444012065549266004025345868487782223169100025369586561320201215252544680896862554398089558437972444081e3057"),
           e_float("9.2154698651365947682846865155253683738494999831399753920870016716648893358210440420163306534632208399789627884205989001738282346235746633864678739615350131301921067819002966218740220316120241985263215761885223873388538624886299805514317319639502629767275657561728856405911721374577582390247278529073541595722951182707313421059626587639293701407110464981367123573575036939176815406677724697548907353029e3153"),
           e_float("6.3487669882422675035041746183926737420488091550488641913872690608754334752699875574704098460949018344603308157134785271116347228333179781615770111891533240230930844398807961593803271835714927470303923415012809752687474200478758308842472632679865629508437758836601457466283331305889353554446976165608818578313815062191522168100848190675269146044138708215871832884000508477267815230148060788550122870162e3250"),
           e_float("9.7916074963027905405145274169120069099743116311984866424775266866741838715687422736470997853579287379452945305840628391733835342783968321681887152658205105988979497861035159711442305805637480206627147258144554042635054709389963425049354301338295913488252211401479456942249752681005064828227486028548663588344479221051974721851357297896325847506677963016771798422975020322905093071797074573278370005679e3347"),
           e_float("3.3132702155766186188874113015546084954221636885903064236873852285172801985423996323013928065351640798328171620606153697368110036193124838025079087090249023006451483028573382845440685061071547738666771078112845256880796975398508178874717374775804804747688511576325259827778471421251557254895962304858610033153723642192323674480952843505578566059263627643030580077609466773614848685739909008352301574497e3445"),
           e_float("2.4130750365285525955645434029328424674248147215583476496754089050983617931781017232252620824400959967093174517399727211619573927165315797928909556742982128045347473761176001998698869641798221186827879688263779182721097714391988979824441147810291149322800632307340897885694740199032902829586033406335112037964279498337229294689717780458931254990318350438057164397298837050029424060749988401233309140563e3543"),
           e_float("3.714202102064138335105945726615325450477380784547266806401345441329942594335160807285220571818126230667576882911551086404368444806207185639907204603139674264743595604456820691310275760908609646165530696648727938339216943884913359835161704759238517332663689514459754130366600723940203257453906990306370695800182591342374405529404189005264547950813000351651407889395181270616768604033936868709907313395e3641"),
           e_float("1.1873524713189297953457393050729572744378916550573946229399887117961742585589134196362687104633479727151849596639296290304472034310229296124343028240228667829667686352626193068837036460272926017082581733165581136659902878542000783409167923515844508081002254540746118925012896365625919801238363603325604329060011954056924917034962316753452572582359913920038188648455095321326391610799770791218651338142e3740"),
           e_float("7.7534642833326184753948667642248421821439494259066289847447353309742064567575649321857299428054973418571506387951721921121353352619140482064554663873228075217517948376211829071985206754919018937773179423087995284822586623198476386512716249591874841292543687344778830629146091773286462421380507735442292925484674564883576753781816720104474596666345951015500464415057477137098791942424478982261008695057e3838"),
           e_float("1.0179289001923780372362702787121824172536382079006560025711233258243664173242356811505663299254144294096990892659369346291473976690088021620697189149668909955195853549540685452041010410803270411406687563577168693629621888522205113210523173197337051484821892275057311525390583790567754541347624911161573439980015333307257952924743878989770445097844616102053386855485027608703209821329757391064622052463e3938"),
           e_float("2.6463552733485761653091422547631302372733116703393170832835317638801986026180373710951032049841390076078303509556900323214172901793160591372899441547413909211297939443025176737583076429972194253859398812704842586844419533922797732035386589681910500124209603142767873884386236902637230153004996401451496421286215277781495008758060642635603345933976804657380367865946956684030222910996201104148612891545e4037"),
           e_float("1.3426792194000602516363930340794480985916428210283696507628217880969359891649377381312534620181308448845662501760261835568885715541028071325847551063540177315322798839013159797636904000311454117172575792843061884401974866196560482120280941553338503162270365506988887506603281393900034697307312588735014658078138813699656851622540869853382533500029854090189946177300392737991875664945045047297199341111e4137"),
           e_float("1.3111049295985528424120741637869296380081102773545059061455783248373725691847616943993323099984738409880133919879773680049656989860141593584140261668879655681153598867754538070469569340780115145149331330029378767756917993169644486775351929020724502912589445565754599295918895708241286525007713477805806133779127559500991585809803263192683404121820782674361812239184982213852330088454952205677094598378e4237"),
           e_float("2.4312996912209738454084420220477116568945817076895770384893622896586596149512534292335103863174371316507784974269973110114534262165101442445354256157215448503161278029402632036485474555111731963110782913331701476086475139336006659904576097634581809100926617240540643898255775095817325528361629918358067908459408786749344627092444965702942451204113325323477263381767471297357700093719977972152611323576e4337"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00201_gamma(const bool b_write_output)
    {
      return TestCase_case_00201_gamma().execute(b_write_output);
    }
  }
}
