
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02124_z_asinh : public TestCaseImag
    {
    public:
      TestCase_case_02124_z_asinh() { }
      virtual ~TestCase_case_02124_z_asinh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02124_z_asinh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        e_float ten_pow_k = ef::one();
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() * ten_pow_k;
          const e_float y = ef::catalan() * (ten_pow_k * static_cast<INT32>(3));
          data[static_cast<std::size_t>(k)] = efz::asinh(ef_complex(x, y));
          ten_pow_k *= static_cast<INT32>(10);
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("1.6954898969027803072751582919050704957956149780864170765444154648735493734322401813679102605323000994540289849908423993183573853146819791446381776695441438114407091804941691145225981426224447322040283506303688861375917662542975343069660554316123813473385535725162000184578870804092720666548601621987090376448729184576008186275709119927715364902343189086611426713381777067040243660818058859011625768607"), e_float("1.3497694187400061293908071215842733375332725698989841764521807892686906155170650071151890894968937013442532847948680254167559198510963932066366086063637099336123812671938074780817801577595537668051245083371834542854810149814903805418161792133269191859732717631617051699248918875686992064162560517343280484244996302197515685275989653810378246728932908112468400021195167579933880729096952919246804107781")),
           ef_complex(e_float("4.0278668442941025171601803044048030648004379711230400263055366289346380041734121348830386502391809617509758651402504930262554199612014980617390190087513630434226859650692271492014142447243207670193291641408827324548591601206330966792966783759863691978944210780775986249358666678640188684859715967491831059130013487116080922536412583316208911031852655731817175122744014764397832545478387635612795320677"), e_float("1.3636215960024606441509188864044359416291135839215547522839313323526035090003447225067629071788512062361252170335077828684817974784408924815226058674971035303165475655847417762384168322579332389523397368720663074414295112977421899243661942783803118115021443661837939254098352055580073083023739828899860583659786816527029162651986130928221988727504303906171141559641524741330921246029861502750390907682")),
           ef_complex(e_float("6.3307394293354829334374544672298578397875267330593584993686458035170541486105110334522385073219668677190051041078253566186333378358289604483749266009646574850632507214112741757161081062547758889958310010042780797127004499505581938373878122721103162576088762460548748516723808233263359531022050067825548333438363810728326898041513369730955312582666474377674918490644387964557383688015462713854463032438"), e_float("1.3637480172404743304352848334604093568712144979845697107779678094306510187267061345724774425960255157609010375865483680271357380234405198999150597907010183925702180107165496660913320271291913126229012672722317307803053642442048538203769529012608930723968561414892564989706975840077182461882973083748616393376259369180869462555822475011874568750475781024270835115871626538771563648457141276022729750949")),
           ef_complex(e_float("8.6333273962400812575684444807319397509089687235771405743566105850067935195455902919179405851017711280887784697817792983730901327806693253332323392377827119427363282419325693381190325937242093650489998153869208239378555165963786947363113168678459042831557859034949024887264311220035370932742602463695812485482917644432676168231672683795912386746138043264819729540756836351003022375273015956688914730328"), e_float("1.3637492803519502985781382543890290643335508681462778865680607017331650378745458634354983577202159525532082551506992207785813150123700543299249535139517497945298418348897582466879904881447471674305796055984800459521752085462990188282088943662060517269889686270575445871809836287236299831758820152138760279266199569364021575792222303416477069817621136080735344905704438019271969061139258581032399442372")),
           ef_complex(e_float("10.9359125179731315098518714935457208579707116701520188774937897949401667056966895376801073320171774638211339725789592796076781521293431725782484986093584439065166421963429468623430349892723837122984611582301574289132357206604380665960846198677793312364585064809996042286141395386878296964760641783146789386214041106183697346650866269090591559503852557942945344845372380139698697142824967085589103578147"), e_float("1.3637492929829550675086613037122712230891903853342923907277844611257572127086057820328540297495941427046164257626892814781400125292561904478680575201140699332547352122334041285235991958922561296916676495630218912971369254371296108160036512605365086226931665707362460889146183811881974647868014530686532998349136646161402168195744522397805683209222383656906557906516091093075222727305850933306132793991")),
           ef_complex(e_float("13.2384976112545672294567376769188902102114432972827958703337984485218828361650121201247126880329797397577279159326072774311644262919504512972753719199273014668519436580595773251303348558825704395582455155303162845110434550167922701489483849988189160708420549798441733274472321403914487344368374828409951560985003346791750239118443199971748515576261765489950715328766073982386376030491515656658271473012"), e_float("1.3637492931092651041989910223046013527772274953461011194021151975412965865365770045716498438393116107971392070240451430886023322084084373059064970425457530615093032557950810674804048074224279710594850607315882396940879217292053908371832302449504204304877613958391349606829181383194705401022451423717950262487238736598149436552998013831307297554517852863967132296774540192221095347433688138611209023677")),
           ef_complex(e_float("15.54108270425148681382958830096139584546681767729913326278727916577551799460586723090113694578560399184822246879480134099284817656299255122190542651626037883842568785235204102002117054057474207116103205008977971047808734213454159763386801790471280322908850802335018683965588521754004858755748411234816742003526273949095499345149134451841717110654898409015096839068818859411884340793357903838229372485"), e_float("1.363749293110528204564794422038912338944358347803373270314441637344765245082404857891450590891867106336625459692603234906764314295267066563989534422210365983161263347245114648315891665327078558655182916323229904668096618347152460860195556514714126466374420987623072506047692688645532143661968137009508240372310125507714578954068088765187819283777056872695633758647506698771634877514414418954636772129")),
           ef_complex(e_float("17.843667797245561236851128246381548626624708541309156502317752596239195406571306295920816743098872806248816142806681628018596923077866213316490841721746772186494352802315216977255925565708863026951102325441891710550767726534594913914087742819539261910418669278510029997349756873662233310701553021056137659176115329082532331050282771598643079853963860500170655906598764012823052256884272496357929230136"), e_float("1.363749293110540835568452346046510387152283056017987558030312410820059021429373149680612933079965856873128805263186327851222905945293381581350675268689805304387710971371714153127998423188923618248230862183112809553761363976068974838887169332086211449552239016309984428195335067765479280172931991383048722911699657464605420790959420213941290036565514995041523851444127668514838215576107269305469345958")),
           ef_complex(e_float("20.146252890239607208259155185963174940677339890982255011781385809630341784495716043582738343621685199524578189807239600776633087742172330166071799089268756011955135558968767782256238938753236088611650100003341048313303889312111539360426321081643500242030662395470505171053049011599458583754481771358474179875317392934613925671907934824300809722872535431799627259000586667201595892274061699432872775193"), e_float("1.363749293110540961878488925275587393128296506206390098991687525209785455344480339834683189230887854039473258751201564984323414910497627734329331493486853198468648263339277160655028567078621176514074833157625382948827596707274023301966704701624198513317720345563387080635103475509197561976023707994048225716929287985312350768535328655979480271896972674563675496042294921685312995794070250295188246765")),
           ef_complex(e_float("22.448837983233652895151046995496510759765028274452142920318464480098399227762947395727120048455355944184574447889687391339843818127388674492211153622020389291095668762088005116749434512161222032148382741201134620803007980721804950512240425782720842215324856353871885321655875231320482474834173867143251163041183263188515153887959776501711505489680964039462333263775424743863236284991441746811146770046"), e_float("1.363749293110540963141589291067877063290606034228162516327631145808231364264440384259666867914291264485739382836304791453261044559287786336410667280450353477815782185131901333460214175300748371931761637333552883300398619262563332475044404311910462300834798674350771670552836536697455562350807545375946603809861773126250048347954036766333035069558440938949385664181857728222763759587647011102095705701")),
           ef_complex(e_float("24.751423076227698579197777453729364683380037839188950146787172699901545797121720785663880551686758885346044557192980620540060794343479473075171324886277562239574727560605204413446143635884208942271173476574897240847815114927315040513875795209784795063011012136958905797676931689563755616529749688116287292264132929731588211462121662920828534207734204329417561644957084062086519231680678809030264028512"), e_float("1.363749293110540963154220294725799959882239384447732328917949501513884294282827921246593509403999716580923690661376469012501810797765871508377400859478153001085221385445070103174978322627080485879102244329524221972906056709786522397154949963170361135793577933560789774649938615730500207391359634846381776991050200046773322782131232279894746134747738208106468411545237842536556400108856889397247247336")),
           ef_complex(e_float("27.054008169221744263216056298449213788141268312799519427634999380964454572245993422137327325438472182725492906508363362748432847702528479380480865751510140281776010609339445126656508788998120927562454575779735311333009363401610602235047145174863131722196693008613355793377703939321306293138468067340193833168663215167036509291435293265474145234097876464508078931626189658363998495731061050624104561757"), e_float("1.36374929311054096315434660476237918884814471897542196225279395872917730306587280195580595271972232599835880883261551498919988734754419103933302888485817811657919348220717057993424493218577362298491032227882632972356046992094693240333552281911234017033698555091070059592239417785893243394101119728121247651515790160451507686839690715424863078623449514909795984017486975945068186727182076979469266273")),
           ef_complex(e_float("29.356593262215789947234050627033932844713971090268532438312703284264613867486769053576657588721663212761091359685812532275055507674732611766160111491062830969860562355538016445256221413043889935651831541901737625567353313479441484083996346994556913866705343435321841788556916277205169724017038404000328421201775906988447286992372776200596256594252614390617354970254981723887971584551101730138995296522"), e_float("1.363749293110540963154347867862744981137803771220801407979663297528273823088164171759038775317812194887182380436614226986605542567833290205758706331889805572566953323974998292341889072226518680915839529563723507285957482003789676663211325039126175976496443495696202616851779638795011317983545338425143616476270389911295954742983161855926161668960507402109135315073650160303605474822538595648844052863")),
           ef_complex(e_float("31.659178355209835631252042110457300600804788591785606856899634568356965541294772527088591267242462348678035511938726730641488911390133679800883529393878191099319165201889117567590214759126010459798423300793434121537611767741979977428321611851608933922161327009336864322767431865384509512083669484097765400834474929033782964877049394787134765057970515860398737958587412534352322974768014717848693977059"), e_float("1.363749293110540963154347880493748639060700361743145212691871343005687582225146818061805604495575615666243792296287091170051465826155724062500586976152753102963722731530914850219851475197216133454712169327274518996562418913067140665624734107928427438496834353159846918086947534246180693060548972441304310841374313627000215898416428816176340799524372539443876330424348803787479970367124595314254460993")),
           ef_complex(e_float("33.961763448203881315270033565429054843890787240543262837262719219118096086933192961559390596319704582385950960502584394880610501725836441894461689531984906459335284855188488158109710704851347766150582574207620492292920765836575256312709688485260821412157191643488925259176934039368731701928515317044633366550120952710551150086146081076601951629941944566973952565735061904365915468515071925319352132601"), e_float("1.363749293110540963154347880620058675639929327648368639740018917395670662096009898264380258872335222844294065459544102329705978061321778343908253956807746903898861219176807007942009708722299136532275639113295682571605719655538748891917541232336141209705611587185283082504978580253146873467210443708524418142865228829727973764387226639606808265893049706046119349723064616096230181134794115779508670714")),
           ef_complex(e_float("36.264348541197926999288025020116292951846737700773324643338335109655200506984688097516108652791473592321277815001857107132669217451004117225428349002154675362498604915923722586487108485115962829686810537188068477652341487400035972435450150443466650980530460584290868449456146811473909842790637257736159466496475378177971992198585219584130814073782262993952320547932034182307943434275280452210912976685"), e_float("1.363749293110540963154347880621321776005721617307420874009400495688964013788946478491357726401223952000165439727941023848820512399260231855513936114087212737435402625586945987484402134156840104935550732178777149725111719144102970435310410230160451421400889745338458349798727193967421079263876184165370384644254847559721546778399446888598668922809388203894674927436947136850344071570019345616011391676")),
           ef_complex(e_float("38.566933634191972683306016474800685898451387679118110507672085789560675594388883457506930937620533693575342206708669167659914139364607890259809722024865345786917646157727451546727876954821772693095023174671912669172273770290312087095427723294266715766499301640299435106343103946666251654947409851619029618944073832412409779705008526362496549033640381066954184611724810235008693092016407922299814847652"), e_float("1.363749293110540963154347880621334407009379540204011396352094201482151886657965267088570095826377637917667449351615515561219372141238156392461543008872100408359985731091929114421492324795918570545127305431416345168807989964934585292702373317652470449037873027616915949864326604920735856440248468179549804693380073160006933276459604602292208161007974391469272483084255671459325556783330387728002385703")),
           ef_complex(e_float("40.86951872718601836732400792948505039344252465264404361258841791830753144955946667668579615529468311658187694206834367058176545134627280122726759207697708582714448086535636971175962348993682317279429264554798727295994817991038935822631676952308244231488839122994388676437775432778319966721048117958268624254722545822105024159924458107972619662674377251590363321299446063321487020371447463035552678065"), e_float("1.36374929311054096315434788062133453331941611943297730157552113852908479088059066391682171378020373902299157641232715336735189559887622850351023513451731404908989753626652468097146202081401990512810938471073378867965788681957138328170152874035060956198060780411596215960551374767900907427570410424257782761732107319434182141941603850272403961238729305662824549341696955553447941248439226299874653891")),
           ef_complex(e_float("43.172103820180064051341999384169414603917526496121788189910575861552895882113823060542236572486305641855096566088696815104676919797519149947768768744078358550225065189995376891126407214463294439326479615527959883447087187145715405345617414694346928452715591149677427797006660393581394242934134688101889791555745485006971548910647621753331802763231186351938566573715671837516619353480990178429819905533"), e_float("1.363749293110540963154347880621334534582516485225266960627755407899553020025366311405998457909167957590047198880143352121495958444880240050498635003389441282910390327855081008229965964025610783453796277756067622417293823201825100408092022515487647424839602378698310777610768403520261718655078897218054709475638367532325345189322316195011935167149456781947779821096705191331242741391457015085546329302")),
           ef_complex(e_float("45.474688913174109735359990838853778811547366988299050881956792062943246409918987786974061311150121800337945363090436088367255173445550469639425305875372668103453679162773794813521086227590512233270134467275201338752564577461397341262137112591825633300108739852407474290408265779465072012811898211792395602151289897368909145010683311756363769102334047346898880010460394947445119249316107690322612850139"), e_float("1.363749293110540963154347880621334534595147488883189857218277750593257702206824322820242314773252542371473454920707521529909894140938180861935305566301283602534734220932488864641136543513182699618854963714314332121494484598726469684831734107386879394367360437385842409193601980353370087306935662652316415950292912909707041791083561771398723580948620651295584711518852059341569966545706815540225331213")),
           ef_complex(e_float("47.777274006168155419377982293538143019148755866963308755150248846915046798777608293892732753885607597043109114111806777108389782502385070787970774199393457487218678951973724861317014179979113408493140000559981437062511409422384708898305066482139436465593862670130563178235686836468632454660589375871628475537436749900900728168649741831854174699677365370438743228525358608902110642108515596074177844291"), e_float("1.363749293110540963154347880621334534595273798919769086184182974020194749028627903959878688550835667713547293051194329591022633382292313896877201747537619082028520747867791979635810216056350652156190439977772421667124473842957239188365221691425258383185266382071112360720423614006476360176212025590155654424793779235067520517991339702227809650687594226784917422302246867497826976937959162386309312256")),
           ef_complex(e_float("50.079859099162201103395973748222507226749860229492436580155178036712661686246773453385978772947895784900685036539568819167805328009385326766482681083630456546866426868589659266117033242952806727720910993625073476906985463701361953554212955110475681945593077742209155628247610413014521873862975157417308028894460758485205792150780313752597720978386154304918570884401144949349336022942719203331652649616"), e_float("1.363749293110540963154347880621334534595275062020134878473842026254464119496845938671377601682132393194917457390056205887848229921206929469383140220230339236844050718593766548805955110553627350845855193156623288476308167892640328344081016644126586476845857864407332344615417450855922260176212539045560505208588122928881634410615331453848996993233046288733756983242291282629193985372950492294656526149")),
           ef_complex(e_float("52.382444192156246787413965202906871434350961746860213104678221950568534718702044060414447508384380605239262099583581394230377440494433774377434264331225957053047593414927584534468137163448322963123828857127891633908243467493145424321198936677231283887548427488027696309686956427751848816235969094610794129191830355444123714537576604330611355969463852289662869668167076686565289581097285556439880472832"), e_float("1.363749293110540963154347880621334534595275074651138536396738616776806813201528119018382601068384712539153953976040580351638206911277012245167302050745112406868277667676104687806013466906187880775548360122123444408532844541004901168425024880566172596260468847620575926071542688190863982575488603000703458774311723037764755092483747502763811227465287427182586889173447592208275687021975355866035989972")),
           ef_complex(e_float("54.685029285150292471431956657591235641952063235776376116196447011664990332607175721918369418681668484763506121735646693284928082082432134815145980282125041039139526145015092304043660507005087481464042450763785724671519992648772409536518979489563908814693053395976882907284558049450392785669224444704954738179079846330227929378952135783957722729946094443457796628673946651304730989235421012505929302495"), e_float("1.363749293110540963154347880621334534595275074777448572975967582682030240138574940821852640063272729667805261221394683671846188853379758932873662214181632759923300340401368493589891874050039547028808045030720623682746078584755092351998429037560142710998432958266352936567655794303359440748895423598412442551493787622030281961355152397142100937938688490616989496335054813571220397579310269116371624742")),
           ef_complex(e_float("56.987614378144338155449948112275599849553164724408022992584623884233851772326805993967045870822334100988892899173562708601264703657769368732292598060973066332099942590594371987449574328573077303251962159431147257704718580697707328941521192176564830309001980625518170821170514916647601615622423925578945517707905849574164764642134980521510499921855791831894174279381397989861859832692430560202014149037"), e_float("1.363749293110540963154347880621334534595275074778711673341759872341082474407945409039887340452121712388485295188076174131005825681018006703914486954183145987509822803101740645192214120668982319229715319494504403761152078917857494217966043040406466656636903898679915940950897205558554622004919003866135533860877704470873930369803276746700268458975119630195487722068431513714250482577335351473225492306")),
           ef_complex(e_float("59.290199471138383839467939566959964057154266213036824707621500274917437270304581252121169868382442971551902032772906708099121371652449622287726089664407599950614723033765445272133451578847729222647579637765190055155146127277741543999720522138842717178593209719997710803117501483612043207083600242006142892267874597803898429614631905868290552038225459998852357543064235442586773792479536289395175009422"), e_float("1.363749293110540963154347880621334534595275074778724304345417795237672996750639113722067687456010092225947034879832411830540017804995210903655411155463284347222980418789099611455661293516776464705084495455956087425682043891225036150223611541608657038973864064577938290966907760636923731002831975328015584293475293578345609257058838272229091551384419204433952495594984231775320299675956368633254192302")),
           ef_complex(e_float("61.592784564132429523485931021644328264755367701665597971044863660782170008864937960136348341396746375605984451026725844386495130329985253002632765315976705611203617623300703011928776960138801220283303308295039124952224465977619148066782715339821678527069809889256475852387045060674898000863191939185313118503287289349201347473306221824658494673107730720121233957188345685004990707516750984077982277811"), e_float("1.36374929311054096315434788062133453459527507477872443065545437446663890197406605076888949092604897601332267777068518314981485398581055302782502344917105150942936835907187307340070330370979460189433287284799136939700016813882700536717255250190750331627277017062726032534542274965926253771869978299938646048669756789845168198446295001920452071661351778633092217917427867032110775245563986116226567862")),
           ef_complex(e_float("63.895369657126475207503922476328692472356469190294370949952091916598714219831120482650137359165591725005072371833199018127458830103371303683830481839524203270985392138672179895149958200044241131000471764318074612400688828427025433248062855118339690432912375949745852539687219115135911406035360636846756047755017182151521390930260553542103994659387024754853013742612416393450074946397811549025674291507"), e_float("1.363749293110540963154347880621334534595275074778724431918554740258928561026300320139357708960749364851195334302143104383901830297044664006074936792413298777207059450623748284801218722498367306787834067937344804550643913727316490160339019468879326049833419573689619095283163748096977227093197664912465935027369339407887435845520182317915722255815238078284944774429949514864662314315611434078754753991")),
           ef_complex(e_float("66.19795475012052089152191393101305667995757067892314392601415882111477654552136126330891248238198249385761135714216934317156699876473476075131057840269463452144438074343738354947375769550506559575046152581087014741846095195604006133227390424195900593875686760792185165399359150445280377273781027271391266222661345452732219661139398584590691128090383305407400681120474970810726320587402418661778876248"), e_float("1.363749293110540963154347880621334534595275074778724431931185743916851457616822662833062391141096368739574060757467938535594789482951947711613136747567751766844551502026768454297788777022879630885190742794631720355456183240066519679495764456790392860259888630693148871542366650092379771695803688727601009947329995190164959044437881150586335951128814916613559314735660090436843052601052983943382215327")),
           ef_complex(e_float("68.500539843114566575539905385697420887558672167551916902047774112117834052358842626549137466652848716904684853197112336789799472971925693772872160713224385422777176075033614264893872147963363661638724231821078007452830097575645144093968958301057538837774131284013877331895472869342943738717930969979740202882308861455186254201380897378622171560983865683652947588644012260132820744284300856115366806077"), e_float("1.363749293110540963154347880621334534595275074778724431931312053953430686582727886259999437962899838778457848022010187902605654283753300042928094317201468499792622394154425172421005368944952253543801947778997264113487691312860522752022476840049038181541070654885232871908272910265993559069195060388388152927905268053750824883509699031296201500787294233724635877606874422286745673663746649671567007317")),
           ef_complex(e_float("70.803124936108612259557896840381785095159773656180689878081104886985761511007796395615176949534259694493703694359525151863479299520660596324163579747422425829650206177322806367980545206191019127736760972204137039163061018890310278435736334850836534798663848163525387423952382479521292050012110743108320927492270057329330982288281573091799073125024495863483425958768386100897581515673420174950100674879"), e_float("1.363749293110540963154347880621334534595275074778724431931313317053796478872386938494268808431117873478846685894655609296378312325282207794190669850454813884342408272672863201831646646465945549314166581525460568320563266570183151414059899679744365039600618812537849118353149022235584078556888970163559067175575119853640087431912425075955297056456936980134299144467239139571667295654756824666840328755")),
           ef_complex(e_float("73.10571002910265794357588829506614930276087514480946285411443281669233766917486488873947457740177611962814198897301266616119057020373954714022931605104376860120954177698927051611299748627891542804178751489292780482567008078418843356458613940653038096097414142496004780323787563701418363030679678515572311172606578553263421462475243514680282369901268769031401975018123421315800389038854071329302384406"), e_float("1.363749293110540963154347880621334534595275074778724431931313329684800136795283529016611502135800053825850574273382063510206049160636848961126090548383103039009628161975007298272075577918602172163711399551852796123580473884035875226456661360316689285093921385875765298382301834212382048864039852198803433349421153969418991116658769360843759426717520515681265392243415716431781594681809605517907531955")),
           ef_complex(e_float("75.408295122096703627593879749750513510361976633438235830147760717947300314337114529104354786719153599238034478121010927451243103025223031299799743229249563058362703521944474418938990527357070648342226383283194919660481016813094186858338004495244297795038136970906608644895608470907553079611268427985863481894393559949650764519417113850798132240331848621910977655146044909531310781885100450195617422914"), e_float("1.363749293110540963154347880621334534595275074778724431931313329811110173374512494921834929072846875629320613157169328052344315530015889308004387034856645506126382533071080435208094499584574249347708666736079447919019536671832565676171263529036618690247081889238449093923330563705748472893375611883984935607891066792404221448853668832360918479061215588919339697589877470875738884297204331095313819121")),
           ef_complex(e_float("77.710880215090749311611871204434877717963078122067008806181088618917746824369315980941640821851029689392681509214354296211219058562860266902091303010971391054237998224661597216015343284308063031570041636495183112113028749847153916633776308317014308951935894684460819490252104885836502295890627347040152204977178005698912327460161538412341876699275976246440339302230126028314543783851655717076317770679"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812373273740304784580887163342217343847355313546007200697765698192609782260866690893949330356755107084999261471747051850264469214248410476102456997503762426121578067899024830452235922573031029135714379129447713334601877534576671535203680197652230412510269174910916738020970861095677089796594052157151515574216938048543275396044603014432")),
           ef_complex(e_float("80.013465308084794995629862659119241925564179610695781782214416519885348173050216950893650915241050765652776085727151116045894248328668516989421002727297856404402700876425970105183869980848610045941911472038472307911638675160602021074858433509642657741946275952235638326148490864775695687244265200905018615565312658454579140507673433245903536491916395117834422621645673069299544155887633095060895090764"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812385904743962707477477685684911048529535660549895579424219912019235611200650253284629680000203990086219365004142958383487414487421929958146076739162803327702715642470854703798819904879230909957164303536246314634928645534794557084121746927821675033133006849300664907459921066078193548559794884596085747252083564278811628611413781944396")),
           ef_complex(e_float("82.316050401078840679647854113803606133165281099324554758247744420852921070117604916026808249213653291773925137694142470391316430436758578169298144935831225075812187826342762458363633383819295689251139388894999079050288149351497774456541610388631184400960872406071731832943164701954858040550329527060244162452194406619347500930804566396110068077831059435660976471084208728645996345687448063965473018224"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386031053999286706443590908337985576357464019934463211484454157501869479049114402471692438917973175807136121639120500515615554786017604312485698462522690952589518986460758735555515163057702882681808630597842923113085062624653196210892418982199538234351840906382435780520364673280720668506945985613227881454134262465196167867474650527")),
           ef_complex(e_float("84.61863549407288636366584556848797034076638258795332773428107232182049368266885775111177705559208163239368473441567577008184608246827145747019553127539594886612889280826294520087981818535098614315800347828426462647512560424580194192698170270036135495135649332476401191163509962833736517130069414927713070443118599328075449233416005930682701905771411979709888691141093730455647470931818889926468165522"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032317099652498733249960572254946825682054634852049357099578884532061832003116199506084199340956128971389822299341991067162621121716019284484909474483993146550795530565993339267744977309129405627150233719460640605167331151083118266111699596633202233119718478332995655441508654599682161361653622529888436102321657941667711691422137")),
           ef_complex(e_float("86.921220587066932047683837023172334548367484076582100710314400222788066292374949234896263976694568231158430436584754489225826809199018564952304129533241597136243239447522064033908836831771436315513274755658029488360286293962588978870541522088420984275654146828051157513950444247762300347879512366075875692836982407190422256894989567100540589449619208619546327303693269363020560042719310064700557442934"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329730656156656146551094597640530364234981855937735826033098358687659831893347039160004244056727132338259831952127852195659188903459876986243728975149779439577812449277345879706513915360966450256690115569474236629308932708427522328709501510013561388626001477727475718379182126081089097757976019181107467906814126721982672089238")),
           ef_complex(e_float("89.223805680060977731701828477856698755968585565210873686347728123755638902052589105167746078944295412504625999808308662564342046676758014716224840011217751712248423360302274118061645763603864400020064347994265260582686019571178646314687700435258939902378850256371488116871913929744128425213031853708984820621105095979599819631630157065430808720362783676954219040114053936714032584554588972173938392119"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329856966193235375516999821067467411056785325976619613297640496953918110181107515516256228296675393442003782848311392249041265546948915263708418498658246157483994322115500925461505649233801003108084862447465026112446409708140901490066138401189677545625366569487906248865588871785944324715237711566311069857784077781838780574681")),
           ef_complex(e_float("91.526390773055023415719819932541062963569687053839646662381056024723211511729944459304098133005494999676636061642407590444802629261967387902963671611405306121018624931903389884914714464485108572679865826904434004500177399085098105920277255209791952518130803441432846246675696855548609996669701347376338159750627309975370444443176631692004761607243497413920837069152424975578957238743893764743970991136"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858229293601167806658873301736781525003360677008451170285918336580692963985119179921297532595770280990648314830235866795391482980967109718310528591190614279724263261917894210855862142106470033096104772593537420701969139661620626200362695762225928570400941138547795759130267974870618417438052182112179857884552013336596329388")),
           ef_complex(e_float("93.828975866049069099737811387225427171170788542468419638414383925690784121407296968279098886584809310906904268462611965870682665298251460323930684422814975537593447291021323278071804665243460375852100574350684508960878867064425470681474963756813048369617852253497818252092943780705641912046032154976643333873092937101250677054133126378353201338679648902714241828945341886927959620321039017419677585556"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858241924604825729555463824079475229685541024012339549012372550407318791813895216447958479894326138803311912091180003794654772858247344324732973403989844826742807251910380075065338137504415210555368960592295451039035259775871781326748067421372701138180913245822532649013263770638988898064083354717510663419641395266323907534")),
           ef_complex(e_float("96.131560959043114783755802841909791378771890031097192614447711826658356731084649448802486127159304769377755056732677395772016895869046279737239979046336866104347263555075517708348882782890801917276422744797262865270095061845599549954918210621636103094050774976368601527080890586896132478246557940615918860560830273902264663178111592062969860801398971276482631319146022160092061851153882760066912185809"), e_float("1.36374929311054096315434788062133453459527507477872443193131332981238603232985824205091486230878442972930290216673236282748237843279963709254558505009218297681321409039280563259038082755804902073472957796007184264241183020456918411081089891584592405183773938163886290931357858715079304047218828519770153016599365595465045366377589681956904263510459218407774347401782288804447604133282982349176254767")),
           ef_complex(e_float("98.434146052037160467773794296594155586372991519725965590481039727625929340762001929041357232603752039321011670817241436218105668385186206620472696487979878882602879852948780858283246474477222377949460485782875996801220712157383815637029981781372593191274142612581368715109136302951838577511779179972595973111215138074426013225702860248779895557103740249873271343438074178848484352233199307646766016548"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052177962674576719388355136436102831045517078821637509737966967712674965854416866645397892976921772410940667136861687334228310392795185780235810222638349439623107782631283562937363512226962616977910915369402694631745255064485447801618695402759974727575376011923016680668788445510383254969152218191179017976436443390256")),
           ef_complex(e_float("100.736731145031206151791785751278519793974093008354738566514367628593501950439354409277383176696898827378992343159950462769641986320779584578404648157804102882973514152169711666025111630372510646717172001943510379234235799455300442355154792790949357241211897053472301073320042298807756850979256260931844903230378430574602323281962638235821116207236224127352672668341275694328527024290343385284407123045"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190593678234642284945658778796535727697425825525888464421181539300793683192903170947833860620025678863916112965552667491814500327230479452268956548138294816159463467491566749161599685509967344205898842496805347954197990265493556577205328698596743909117471833884888231648269896233044256570006359574427229590567326562")),
           ef_complex(e_float("103.039316238025251835809777205962884001575194496983511542547695529561074560116706889513380669176532610618120256085240939182232779710567497047083592169910138995565298631404220098042112893771744541267720474517841937266584748157321475309556926834485213144602751418721826485087818595413578912645173838149067806309501044471617786562992810604089896370259476540832397366314985164376202012977738297569653011954"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190719988271221513911564002223472774519229295564772251685723677567051961480663536203333258458033705478357545006085580400019623574753978140405158519588634715068578182078688241414970930704612820660924173385523005183597028100394612416247947797232960578191155615420452619560927614854914832722130634048325137549295090722")),
           ef_complex(e_float("105.341901331019297519827768660647248209176295985612284518581023430528647169794059369749377877140031263809059641416357230093434117854897354860870006105438993229279294612438864316396635224355303977770867505678176661751236066970086976634584425827624206035439529344877977084788276421335167425191231916653431597185416682836834915530206431333865311205843837907165116283446411365718191731566467876343269466998"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721251371587306201223054457742144987447330265161089558369098949714544263541139855888252435313888293895480220718858955059231815446433432456117700766373359192367189015181960483017759959906705257640428080783892206967251474863171091380487847536139349762969013804021876972844547593790006246949779787150662084090510533")),
           ef_complex(e_float("107.644486424013343203845760115331612416777397474241057494614351331496219779471411849985375082258368565699517141471531779149621561446772632128107494740202075644204512708491509892615542242581317598302109999443273604519880040387109592985749004729431156650757657645899326297701877030759866367459614047290753783831060212504863585003615533694973608590099031400370511656289940548788501836305674875079643575524"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264002590964124119644980084838692129510612164977937095553163541170091369915892413802375086580132305798924954614535552223653554179707407144252294297069158118548870525959924112779663717745133103442114668975206178857401409503894781544372593210152030780485946848040870517499700266962278875832713949951482393417407")),
           ef_complex(e_float("109.94707151700738888786375157001597662437849896286983047064767923246379238914876433022137228734825425407696982267394691078725886609312336358987949412195750034094184302569433548241309320863145282176649430478212005969002588731326509545420919751295070403595606013978325310994979985769267433662367924293694907358762097403526789783857204615536357985750789377442543692984694583751006255528254952853777959546"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264128901000703348610885308265629176332415635016820882817705679436349648203652779057874484307039690927605932181033636647831510827252328857569505547920890128513816057997824748771315897080919727308352791406077420629183840316889572481749013149432062246701607322704490276546712865406008396745628606931681449947289")),
           ef_complex(e_float("112.249656610001434571881743024700340831979600451498603446681007133431364998826116810457369492437855426319292455687834448250710669350018849593596838611182848460497294465108662872346430614169924030966319314322398780173208619169208235815339049859595639980572528921664717090752386091936938780105888437154154071558716684410367855101654685362796582951827335580110853059785938068876628442362837351607946795989"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130164101069140900544360499898546800633669717209720690351100819012230986530382710429478284308763678995291350219511720022716351284786291922982830026568911848710648016063545753736564388400231911705068921379023965703994874350556568850720303818632930349906912960997175149064702656196394441853309986601320892496")),
           ef_complex(e_float("114.552241702995480255899734479384705039580701940127376422714335034398937608503469290693366697527453753400263788219836709772420617593019783142733636551482895814280927115745105280281125884103279609500469341833300392786540622061068722186298748472214260637042350292780763334379775092272797483277760247001183197181898918362021906774771278617968721907842944657662903063881964716049499722078480756963679811433"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130176732072798823440951022241240505315850064213609069077555032838856814359158746955028224081454406399195196850722560167423349120866567088239633364585415828383118429715719702623021476026449221674638452447651923047870489708032309409012204919836071136456630495004836435692342849786961863625035684700311078907")),
           ef_complex(e_float("116.854826795989525939917725934069069247181803428756149398747662935366510218180821770929363902617052052029621607747020118534713147285881771167324629026293690160406841578493768838395834732680584031828910316585001095178121819553507043964319835862459652383713331106981790861324526045882773976982080739198331902806597483889681820560315563636137994097130380032334947715662887066312133202202568946201275639127"), e_float("1.363749293110540963154347880621334534595275074778724431931313329812386032329858242052190721264130176858382835402669916927464667442362671867683647952864819574977123072637446507320283723479181313673223236342528603777812698593486945409974373601017276839794475486303588420709792271944166536000727852011696050326342000062422111337359920915839098125774047510615390199393910166838626368699608363069189677032")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02124_z_asinh(const bool b_write_output)
    {
      return TestCase_case_02124_z_asinh().execute(b_write_output);
    }
  }
}
