% SHEPLOGAN_MPT  Modified Shepp-Logan phantom.
%  
% Reference: 1) Matlab Image Processing Toolbox help
%
% Called by:
%  1) exampleFunctions1d.m, 2) exampleFunctions2d.m
% 
% Last modified: October 17, 2007

function s = shepLogan_mpt(x,y) 

   s =         1.*( ( (x/0.69).^2 + (y/0.92).^2 )<=1 ) ...
           - 0.8.*( ( (x/0.6624).^2 + ((y+0.0184)/0.874).^2 )<=1 ) ...
        - 0.2.*( ( ((x-0.22)/0.11).^2 + (y/0.31).^2 )<=1) ...
        - 0.2.*( ( ((x+0.22)/0.16).^2 + (y/0.41).^2 )<=1) ...
        + 0.1.*( ( (x./0.21).^2 + ((y-0.35)/0.25).^2 )<=1 ) ...
        + 0.1.*( ( (x./0.046).^2 + ((y-0.1)/0.046).^2 )<=1 ) ...
        + 0.1.*( ( (x./0.046).^2 + ((y+0.1)/0.046).^2 )<=1 ) ...
        + 0.1.*( ( ((x+0.08)./0.046).^2 + ((y+0.605)/0.023).^2 )<=1 ) ...
        + 0.1.*( ( (x./0.023).^2 + ((y+0.606)/0.023).^2 )<=1 ) ...
        + 0.1.*( ( ((x-0.06)./0.023).^2 + ((y+0.605)/0.046).^2 )<=1 );
end
