! An example for the scaling and squaring algorithm.

program examplesquare
  use scalesquare, only : sasmtrphif       ! All the others are not necessary.
  implicit none

  integer,          parameter :: n = 64, upto = 5
  double precision, parameter :: one = 1
  double precision :: a(n,n), d(n,n), u(n,n,0:upto), idj, eps
  integer          :: i, j

  print '(a)', '# This program computes phi-functions of a random square matrix'
  print '(a)', '# in double precision and evaluates how accurate the equation,'
  print '(a)', '#    phi_j(A) = I/(j!) + A phi_{j+1}(A),'
  print '(a)', '# holds. The relative residual is printed for each j.'
  print '(a)', '# j    residual'

  a = generate_matrix(n)
  u = sasmtrphif(upto, one, a)

  do j=0,upto-1
    d = u(:,:,j) - matmul(a,u(:,:,j+1))
    idj = one / factorial(j)
    do i=1,n; d(i,i) = d(i,i) - idj; end do
    print '(i3,e15.7)', j, norm1(d) / norm1(u(:,:,j))
  end do

  eps = epsilon(one) / 2
  print '(a,e14.7,a)', '# The unit roundoff of double precision is ', eps, '.'
  print '(a)', '# (Within our experience, this relation usually holds very'
  print '(a)', '#  accurately even when functions are not computed accurately.)'

contains

  ! a matrix generated by a sequence of random numbers
  function generate_matrix(n)
    integer, intent(in) :: n
    double precision    :: generate_matrix(n,n), temp
    integer             :: i, j
    do i=1,n
      do j=1,n
        call random_number(temp)               ! calls the intrinsic subroutine.
        generate_matrix(i,j) = (temp*2-1)*5
      end do
    end do
  end function generate_matrix

  ! the factorial
  pure function factorial(m)
    integer, intent(in) :: m
    integer :: factorial, i
    factorial = 1
    do i=2,m; factorial = factorial * i; end do
  end function factorial

  ! the matrix 1-norm
  pure function norm1(a)
    double precision, intent(in) :: a(:,:)
    double precision :: norm1, v(size(a,1))
    integer          :: i
    do i=1,size(a,1); v(i) = sum(abs(a(:,i))); end do
    norm1 = maxval(v)
  end function norm1
end program examplesquare

