#include <iostream>
#include <iomanip>
using namespace std;

#include "MpIeee.hh"
#include "CMpIeee.hh"
#include "ArithmosIO.hh"

/* interpolation/integ_eval_macro.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* function for doing the spline integral evaluation
   which is common to both the cspline and akima methods
 */

static inline MpIeee integ_eval(MpIeee ai, MpIeee bi, MpIeee ci, MpIeee di, MpIeee xi, MpIeee a,
            MpIeee b)
{
  const MpIeee r1=  a - xi;
  const MpIeee r2=  b - xi;
  const MpIeee r12=  r1 + r2;
  const MpIeee bterm=  0.5 * bi * r12;
  const MpIeee cterm=  (1.0 / 3.0) * ci * (r1 * r1 + r2 * r2 + r1 * r2);
  const MpIeee dterm=  0.25 * di * r12 * (r1 * r1 + r2 * r2);

  return (b - a) * (ai + bterm + cterm + dterm);
}
