.TH QGLQFD 3 "20 March 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file laguerre/qglqfd.f
.\" by fortran-to-man-page.awk on Tue Nov  4 08:23:53 MST 2003.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
qglqfd \- Gauss-Laguerre logarithmic Quadrature with Function and Derivative values
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "SUBROUTINE qglqfd(x, w, deltaw, deltax, alpha, nquad, ierr)"
.B "REAL*16             alpha,       deltax(*),   deltaw(*),   w(*)"
.B "REAL*16             x(*)"
.B "INTEGER             ierr,        nquad"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.nf
.B "void qglqfd(fortran_quadruple_precision x_[],"
.B "            fortran_quadruple_precision w_[],"
.B "            fortran_quadruple_precision deltaw_[],"
.B "            fortran_quadruple_precision deltax_[],"
.B "            const fortran_quadruple_precision * alpha_,"
.B "            const fortran_integer * nquad_,"
.B "            fortran_integer * ierr_);"
.fi
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.\"=====================================================================
.SH DESCRIPTION
.PP
Compute the nodes and weights for the evaluation of the integral
.PP
.RS
.nf
\eint_0^\einfty x^\ealpha e^{\(mix} \eln(x) f(x) dx
.fi
.RE
.PP
as the quadrature sum:
.PP
.RS
.nf
\esum_{i=1}^{N}[\edelta W_i(\ealpha) f(x_i(\ealpha)) + \edelta x_i(\ealpha) f'(x_i(\ealpha))]
.fi
.RE
.PP
The nonlogarithmic ordinary Gauss-Laguerre integral
.PP
.RS
.nf
\eint_0^\einfty x^\ealpha e^{\(mix} f(x) dx
.fi
.RE
.PP
can be computed from the quadrature sum
.PP
.RS
.nf
\esum_{i=1}^{N}[\W_i(\ealpha) f(x_i(\ealpha))]
.fi
.RE
.PP
The quadrature is exact to machine precision for f(x) of
polynomial order less than or equal to 2*\fBnquad\fP\& \(mi 1.
.PP
This form of the quadrature requires values of the function 
.I "and its derivative"
at N (== \fBnquad\fP\&) points. For a derivative-free
quadrature at 2N points, see the companion routine, qglqf().
.PP
On entry:
.PP
.RS
.TP \w'\fBalpha\fP\&'u+2n
\fBalpha\fP\&
Power of x in the integrand (\fBalpha\fP\& > \(mi1).
.TP
\fBnquad\fP\&
Number of quadrature points to compute. It
must be less than the limit MAXPTS defined
in the header file,
.I maxpts.inc.
The default value chosen there should be large
enough for any realistic application.
.fi
.RE
.PP
On return:
.PP
.RS
.TP \w'\fBdeltaw\fP\&(1.\|.\fBnquad\fP\&)'u+2n
x(1.\|.\fBnquad\fP\&)
Nodes of both parts of the quadrature,
denoted x_i(\ealpha) above.
.TP
\fBw\fP\&(1.\|.\fBnquad\fP\&)
Internal weights of both parts of the
quadrature, denoted W_i(\ealpha) above.
.TP
\fBdeltaw\fP\&(1.\|.\fBnquad\fP\&)
Weights of the second part of the
quadrature, denoted \edelta W_i(\ealpha) above.
.TP
\fBdeltax\fP\&(1.\|.\fBnquad\fP\&)
Weights of the first part of the quadrature,
denoted \edelta x_i above.
.TP
\fBierr\fP\&
Error indicator:
.nf
= 0 (success),
1 (eigensolution could not be obtained),
2 (destructive overflow),
3 (\fBnquad\fP\& out of range),
4 (\fBalpha\fP\& out of range).
.fi
.RE
.PP
The integral can then be computed by code like this:
.PP
.RS
.nf
\fP      sum = 0.0q+00
      do 10 i = 1,nquad
          sum = sum + deltaw(i)*f(x(i)) + deltax(i)*fprime(x(i))
   10 continue\fP
.fi
.RE
.PP
where \fCfprime(x(i))\fP\& is the derivative of the function f(x) with
respect to x, evaluated at x = \fCx(i)\fP\&.
.PP
The nonlogarithmic integral can be computed by:
.PP
.RS
.nf
\fC      sum = 0.0q+00
      do 20 i = 1,nquad
          sum = sum + w(i)*f(x(i))
   20 continue\fP
.fi
.RE
.\"=====================================================================
.SH "SEE ALSO"
.BR qglqf (3),
.BR qglqrc (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Fast Gaussian Quadrature for Two Classes of Logarithmic Weight Functions"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 20xx, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
