.TH DVSUM 3 "04 October 2003" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/dvsum.f
.\" by fortran-to-man-page.awk on Tue Nov  4 06:19:18 MST 2003.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
dvsum \- Double-precision vector sum
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "DOUBLE PRECISION FUNCTION dvsum(x,n)"
.B "DOUBLE PRECISION    x(*)"
.B "INTEGER             n"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.nf
.B "void dvsum(fortran_double_precision * x_,"
.B "           const fortran_integer * n_);"
.fi
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.\"=====================================================================
.SH DESCRIPTION
Return an accurate estimate of the sum
.I "x(1) + x(2) + ... + x(n)"
using Kahan error-compensating summation.
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Fast Gaussian Quadrature for Two Classes of Logarithmic Weight Functions"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 20xx, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
