.TH AINF 3 "12 June 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/ainf.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:01:58 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
ainf \- Single-precision +Infinity
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "REAL FUNCTION ainf()"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gampsi.h>"
.RE
to get this prototype:
.RS
.B "fortran_real ainf(void);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 12-Jun-2000
.\"=====================================================================
.SH DESCRIPTION
Return single-precision +Infinity, or else on non-IEEE 754
systems, the largest representable floating-point number.
.PP
For IEEE 754 systems, each call to this function intentionally
produces a trappable zero divide, rather than saving the
computed value on the first call, and then just returning the
saved value on subsequent calls.
.PP
This function exists because of at least one abberant software
implementation of quadruple-precision arithmetic (on IBM RS/6000
AIX 4.x), which produces NaN, instead of Infinity, for the square
of large numbers. Fortunately, it correctly produces Infinity
for 1.0/0.0, so that is how we generate it here.
.PP
Relegating the computation of Infinity to a separate function
also provides a convenient single debugger breakpoint location.
.\"=====================================================================
.SH "SEE ALSO"
.BR dinf (3),
.BR qinf (3),
.BR isainf (3),
.BR isdinf (3),
.BR isqinf (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
