% This is a test program for scra.  A variety of test cases can be
% generated by altering the parameters below.  For an explanation
% of these parameters see the prologue to testspqr.

% Coded by G. W. (Pete) Stewart
% Jun 24 2004

% Set parameters.

m = 10;
n = 20;
p = min([m,n]);
tol = 1.0e-5;
svalmin = 3;
gappos = 4;
gapfac = 1e-6
maxnrc = p;

disp(sprintf('m, n = %3d, %3d', m , n))
disp(sprintf('svalmin, gappos, gapfac = %3d, %3d, %9.1e', ...
              svalmin, gappos, gapfac))

% Generate the matrix

if m >= n
   [U, temp] = qr(randn(m,n),0);
   [V, temp] = qr(randn(n));
else
   [U, temp] = qr(randn(m));
   [V, temp] = qr(randn(n,m),0);
end
if p>1
   S = logspace(0,-svalmin,p);
else
   S = [1];
end
gp = min(gappos,p);
S(gp:p) = gapfac*S(gp:p);
S = diag(S);
A = U*S*V';

% Compute the decomposition and print out the results.

[nc, cx, nr, rx, T, rsd] = scra(A, tol, maxnrc);

disp(sprintf('number of columns and column indices:\n%3d',nc))
disp(sprintf('%d ',cx))
disp(sprintf('number of rows and row indices:\n%3d',nc))
disp(sprintf('%d ',rx))
disp(sprintf('error, estimated error: %9.1e, %9.1e', ...
             norm(A - A(:,cx)*T*A(rx,:), 'fro'), rsd))
disp(' ')
