      SUBROUTINE BBINIH ( N, X, G, H, NRMG, IDENTY, SCDIAG, UPDATT,
     -                                INNER, IW, RW, DW           )

C## A R G U M E N T S:
                        INTEGER   N,  UPDATT, IW(*)
                        LOGICAL   IDENTY, SCDIAG

      DOUBLE PRECISION  X(N), G(N), H(N), NRMG
C!!!! REAL              X(N), G(N), H(N), NRMG

      EXTERNAL          INNER
      DOUBLE PRECISION  INNER, DW(*)
      REAL                     RW(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   D O U B L E   PRECISION.
C!!!!           THIS VERSION IS IN   S I N G L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.

C>RCS $HEADER: INIH.F,V 1.12 91/12/31 14:52:50 BUCKLEY EXP $
C>RCS $LOG:     INIH.F,V $
C>RCS REVISION 1.12  91/12/31  14:52:50  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.11  91/11/19  15:34:56  BUCKLEY
C>RCS FINAL SUBMISSION FOR TOMS
C>RCS
C>RCS REVISION 1.10  90/07/31  10:49:39  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:12:47  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3  89/05/18  12:39:17  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:55:24  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:54:27  BUCKLEY
C>RCS INITIAL REVISION
C>RCS

C## D E S C R I P T I O N:
C
C     THE PURPOSE OF THIS ROUTINE IS TO DEFINE THE INITIAL
C     MATRIX H[0]. THIS IS STORED IN THE FIRST N LOCATIONS OF THE
C     ARRAY H AND DEFINES A DIAGONAL MATRIX.
C
C     TO BE MORE SPECIFIC, A DIAGONAL MATRIX  H  IS DEFINED WITH
C     ELEMENTS  H(1,1), H(2,2), ... , H(N,N), BUT FOR STORAGE
C     CONVENIENCE, H IS ACTUALLY DEFINED AS A VECTOR OF N ELEMENTS
C     AND THESE N VALUES ARE STORED IN H(1),...,H(N).
C
C     NOTE THAT, IF  SCDIAG  IS FALSE ON ENTRY, THEN  H  IS CHOSEN
C     TO BE THE IDENTITY AND NO VALUES ARE STORED IN THE ENTRIES OF  H.
C     WHEN H IS THE IDENTITY, IDENTY IS SET TO TRUE.
C
C     IF FACTORED FORM UPDATING IS BEING DONE, THEN THE SQUARE ROOTS
C     OF THE DIAGONAL ELEMENTS ARE STORED, SINCE THEY ARE THE ELEMENTS
C     OF Z, AND ZZ^T=H.
C
C     ON ENTRY, THE CURRENT POINT  X  AND THE GRADIENT  G  AT  X
C     MUST BE DEFINED,  ALONG WITH THE 2-NORM (NRMG) OF G.
C
C     BOTH  X  AND  G  ARE USED TO COMPUTE THE DIAGONAL SCALING
C     ENTRIES OF  H.  NRMG, THE NORM OF G, MAY BE USED AS WELL.
C     THE SCALING USED IS QUITE PRIMITIVE AND NOT
C     PARTICULARLY TO BE RECOMMENDED.  THE MAIN POINT IS THAT THE
C     FACILITY IS AVAILABLE, AND ANYONE SO DESIRING CAN EASILY
C     IMPLEMENT THEIR OWN SCALING. THE DEFAULT IS THAT SCDIAG IS
C     FALSE, SO NO SCALING IS DONE.
C
C     NOTE THAT INNER IS AVAILABLE, WHICH NEEDS IW, RW AND DW. IT CAN
C     BE USED TO COMPUTE ANY REQUIRED INNER PRODUCTS. IT IS UNUSED IN
C     THE CURRENT VERSION.
C
C## E N T R Y   P O I N T S: BBINIH  THE NATURAL ENTRY POINT.
C## S U B R O U T I N E S:   ABS     INTRINSIC FUNCTION.
C                            INNER   INNER PRODUCT (ARGUMENT)

C## P A R A M E T E R S:

      LOGICAL     DONORM,          NONORM
      PARAMETER ( DONORM = .TRUE., NONORM = .FALSE. )

       INTEGER     SUMFRM,     PRDFRM,     MJDFRM
       PARAMETER ( SUMFRM = 1, PRDFRM = 2, MJDFRM = 3 )
      DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
C!!!! REAL              ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
C!!!! REAL              FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      DOUBLE PRECISION  EIGHT,         NINE,          TEN
C!!!! REAL              EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

C## L O C A L   D E C L:
                             INTEGER   J
C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NO DATA VALUES SET.
C##                                            E X E C U T I O N
C##                                            E X E C U T I O N
      IDENTY = .NOT. SCDIAG

      IF ( SCDIAG ) THEN
C                         DEFINE DIAGONAL SCALING MATRIX.
         DO 1200 J=1,N

            IF ( G(J) .NE. ZERO ) THEN
               H(J) = ABS (X(J)/G(J))
            ELSE
               H(J) = ABS (X(J))
            ENDIF

            IF ( UPDATT .EQ.  MJDFRM ) THEN
               H(J)    = SQRT (H(J))
            ENDIF

 1200    CONTINUE

      ENDIF

      GOTO 90000

C## E X I T
90000      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF BBINIH.
                    END
