      SUBROUTINE ZZFNS ( IFG, N, X, F, G, IW, WORK, DUMMY )
C!!!! SUBROUTINE ZZFNS ( IFG, N, X, F, G, IW, DUMMY, WORK )

C## A R G U M E N T S:
                       INTEGER            N, IFG, IW(*)
                       REAL               F, X(N), G(N), WORK(*)
C!!!!                  DOUBLE PRECISION   F, X(N), G(N), WORK(*)

C ***           THESE ARE **DELIBERATELY** OPPOSITE TO OTHER PAIRS.
                       DOUBLE PRECISION   DUMMY(*)
C!!!!                  REAL               DUMMY(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: FNS.F,V 2.1 91/11/20 10:52:45 BUCKLEY EXP $
C>RCS $LOG:     FNS.F,V $
C>RCS REVISION 2.1  91/11/20  10:52:45  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.0  90/07/31  11:29:18  BUCKLEY
C>RCS DRIVER LEFT AFTER SPLITTING INTO 4 PARTS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:32:52  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.5  89/05/29  21:57:35  BUCKLEY
C>RCS FIXES FUNCTION NO = 0
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  16:42:37  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:20:24  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:47:22  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:50:08  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C         THIS ROUTINE DETERMINES THE SUBROUTINE TO BE CALLED THAT
C     WILL EVALUATE ONE OF THE STANDARD TEST FUNCTIONS.  THE TEST
C     FUNCTIONS ARE SEPARATED INTO FOUR ROUTINES BECAUSE A SINGLE
C     ROUTINE IS TOO LARGE FOR SOME COMPILERS.  THE ARGUMENTS IN THE
C     CALLING SEQUENCE HAVE PRECISELY THE SAME MEANING AS IN THE
C     ROUTINE ZZEVAL.
C
C         THE TEST FUNCTION TO USE IS SELECTED BY CALLING THE ENTRY
C     POINT ZZFSET.  THE VALUE OF THE INTEGER ARGUMENT FUNC SPECIFIES
C     WHICH OF THE TEST FUNCTIONS IS TO BE  USED; THE SUBROUTINE
C     CONTAINING THE SPECIFIED TEST FUNCTION IS CHOSEN USING A COMPUTED
C     GOTO.
C
C         SOME OF THE FUNCTIONS NEED SPECIAL ARGUMENTS (OTHER THAN THE
C     VALUE OF X); THESE ARE PROVIDED THROUGH THE ENTRY POINT ZZFPAR. A
C     MAXIMUM OF FNO (CURRENTLY TEN) ARGUMENTS ARE PROVIDED. IF THE
C     MAXIMUM NUMBER OF ARGUMENTS IS TO BE INCREASED, THE PARAMETER FNO
C     SHOULD BE INCREASED IN THE APPROPRIATE INCLUDE FILE.
C
C         ALL FUNCTION ARGUMENTS ARE REAL (OR DOUBLE PRECISION). INTEGER
C     VALUES MAY BE PASSED BY ASSIGNING THE INTEGER VALUE TO A REAL
C     ARGUMENT AND THEN USING NINT TO RECOVER THE INTEGER VALUE.
C
C         THE AMOUNT OF SPACE AVAILABLE IN THE ARRAY WORK IS DEFINED
C     BY CALLING THE ENTRY POINT ZZFSET. THIS MEANS THAT IT DOES NOT
C     HAVE TO BE PROVIDED IN THE CALL TO ZZFNS OR IN THE CALL TO ZZEVAL.
C     IT IS ALSO EASIER SINCE IT SELDOM CHANGES.
C
C>>>>>    NOTE : IF WE SUPPOSE THAT EACH OF THE TEST FUNCTIONS HAD
C>>>>>           BEEN CODED AS A SEPARATE ROUTINE, THEN, UNLESS
C>>>>>           OTHERWISE SPECIFIED, ALL TEST FUNCTIONS WOULD HAVE
C>>>>>           HAD AN ARGUMENT LIST AS FOLLOWS:
C>>>>>
C>>>>>                  ( IFG, N, X, F, G )
C>>>>>
C>>>>>           THOSE WHICH WOULD REQUIRE ADDITIONAL ARGUMENTS ARE
C>>>>>           NOTED BY GIVING A SUITABLE CALLING SEQUENCE. THIS
C>>>>>           SERVES TO DEFINE THE SPECIAL ARGUMENTS FOR THOSE TEST
C>>>>>           FUNCTIONS. SEE FOR EXAMPLE PENAL2 AT 5100 IN ZZFNS1.
C
C## E N T R Y   P O I N T S:
C
C     ZZFNS    THE NATURAL ENTRY POINT.
C     ZZFSET   THE ENTRY POINT TO SELECT A PARTICULAR FUNCTION.
C              IT ALSO SETS THE SIZE OF WORKING STORAGE AVAILABLE.
C     ZZFFDF   AN ENTRY TO REDEFINE CODES FOR FUNCTION EVALUATIONS.
C     ZZFRDF   AN ENTRY TO REDEFINE CODES FOR RETURN CODES.
C     ZZFPAR   AN ENTRY TO DEFINE ARGUMENTS NEEDED BY TEST FUNCTIONS.
C
C## S U B R O U T I N E S:
C
C     ZZFNS1, ZZFNS2, ZZFNS3, ZZFNS4:  ROUTINES CONTAINING THE TEST
C                                      FUNCTIONS.
C
C## P A R A M E T E R S:


      INTEGER     JUSTF,     BOTH,     JUSTG,      NOOP
      PARAMETER ( JUSTF = 1, BOTH = 0, JUSTG = -1, NOOP = 2 )

      INTEGER     PNAMLN,     FNAMLN,          GNAMLN
      PARAMETER ( PNAMLN = 8, FNAMLN = PNAMLN, GNAMLN = PNAMLN )

      INTEGER     TITLEN,      PDESCL
      PARAMETER ( TITLEN = 72, PDESCL = 72 )

      INTEGER     NOFNS,      DFPRBS,       MXGRPS,      MXGSZ
      PARAMETER ( NOFNS = 80, DFPRBS = 450, MXGRPS = 50, MXGSZ = 200 )

      INTEGER     FNO
      PARAMETER ( FNO = 10 )
C   THE RETURN CODES TO BE USED BY THE FUNCTION EVALUATION ROUTINE
C   TO INDICATE TO THE MINIMIZATION ROUTINE WHETHER OR NOT THE CALL
C   WAS SUCCESSFUL.

      INTEGER     COK,     CABORT,      CLIMIT
      PARAMETER ( COK = 0, CABORT = -1, CLIMIT = -2 )

      INTEGER     CNOF,      CNOG,      CNOFG
      PARAMETER ( CNOF = -3, CNOG = -4, CNOFG = -5 )

C## L O C A L   D E C L:

      INTEGER    SOK, SABORT, SLIMIT, SNOF, SNOG, SNOFG

      CHARACTER*(FNAMLN)  NAMES(NOFNS), SETFNC
      INTEGER             DIMNS(NOFNS)

      INTEGER           FUNCNO, SIZE,   SDOF, SDOFG, SDOG, SNOOP
      INTEGER           SETSIZ, DIMN, FUNC, I, STATUS(7)
      INTEGER           DOF, DOFG, DOG, NEITHR

      LOGICAL           FIRST,   FONLY, GONLY

      REAL              FARG ( FNO ),   SARG ( FNO )
C!!!! DOUBLE PRECISION  FARG ( FNO ),   SARG ( FNO )

C## S A V E:

      SAVE  FUNCNO, FARG, SIZE, FIRST
      SAVE  DOF, DOG, DOFG, NEITHR
      SAVE  STATUS
      SAVE  NAMES

C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:

      DATA  NAMES  /'ROSENB','HELIX ','PWSING','WOODS ','NONDIA',
     -              'TRIDIA','POWER ','EXTRSN','CHNRSN','MANCIN',
     -              'BIGGS ','POWBSC','JENSMP','FRDRTH','BROWNB',
     -              'BOX66 ','HILBRT','HIMM1 ','HIMLN3','BEAL58',
     -              'ENGVL1','DIXON ','ZANGWL','SCHMVT','ENGVL2',
     -              'BARD70','CRGLVY','HIMM25','QUARTC','TRIGTO',
     -              'HIMM28','TOINT ','GULF  ','ARGAUS','MEYER ',
     -              'BROWND','KOWOSB','OSBRN1','OSBRN2','PENAL1',
     -              'PENAL2','WATSON','PENAL3','VAROSB','VARDIM',
     -              'RECIPE','CLIFF ','CHEBYQ','HIMM32','HIMM27',
     -              'BRYTRI','BRWNAL','ARGQDN','ARGQDO','ARGQDZ',
     -              'MOREBV','BROY7D','BRKMCC','HIMM29','HIMM33',
     -              'HIMM30','GOTTFR','BRYBND','CLUSTR','ARTRIG',
     -              'SQRTMX','MNSRF1','HYPCIR','SISSER','DIX7DG',
     -              'MORCIN','BOOTH ','POWSSQ','MNSRF2','GENRSN',
     -              'FRANK ','TDQUAD','TOIN2 ','TOIN4 ','      '/

      DATA DIMNS / 2,   3,   4,   4,   2,   2,   2,   2,   2,   2,
     -             3,   2,   2,   2,   2,   2,   2,   2,   2,   2,
     -             2,   2,   3,   3,   3,   3,   4,   2,   2,  25,
     -             2,  50,   3,   2,   3,   4,   4,   5,  11,   2,
     -             2,   2,   2,   2,   2,   3,   2,   2,   4,   2,
     -             2,   2,   2,   2,   2,   2,  60,   2,   2,   2,
     -             3,   2,   2,   2,   2,   9,   2,   2,   2,   9,
     -            10,   2,   2,   2,   2,   2,   3,   3,   4,   0/

      DATA  FUNCNO /1/, SIZE   /1/

      DATA  FARG / FNO * 1.D0 /

      DATA  FIRST/.TRUE./

      DATA  DOF/JUSTF/,  DOFG/  BOTH/,    DOG/JUSTG/, NEITHR/NOOP/

      DATA  STATUS(1),  STATUS(2),  STATUS(3)
     -     / COK,        CABORT,     CLIMIT /
      DATA  STATUS(4),  STATUS(5),  STATUS(6)
     -     / CNOF,       CNOG,       CNOFG  /

C##                                                E X E C U T I O N
C##                                                E X E C U T I O N

C---------                 SET LOGICAL FLAGS AND SELECT FUNCTION.

      FONLY = IFG .EQ. DOF
      GONLY = IFG .EQ. DOG

      GOTO(
     -     1000, 2000, 1000, 2000, 2000, 2000, 2000, 2000, 3000, 2000,
     -     1000, 2000, 2000, 2000, 2000, 1000, 2000, 2000, 2000, 2000,
     -     2000, 2000, 2000, 1000, 1000, 1000, 1000, 2000, 2000, 3000,
     -     3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 1000,
     -     1000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000, 3000,
     -     3000, 3000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
     -     4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000, 4000,
     -     4000, 4000, 4000, 4000, 2000, 2000, 2000, 2000, 2000,  900
     -    ) FUNCNO

  900 IFG = STATUS(2)
      GOTO 90000

 1000 CALL ZZFNS1( N, X, F, G, WORK, SIZE, FONLY, GONLY, FIRST, FARG,
     -             FUNCNO, STATUS )
      IFG = STATUS(7)
      GOTO 90000

 2000 CALL ZZFNS2( N, X, F, G, WORK, SIZE, FONLY, GONLY, FIRST, FARG,
     -             FUNCNO, STATUS )
      IFG = STATUS(7)
      GOTO 90000

 3000 CALL ZZFNS3( N, X, F, G, WORK, SIZE, FONLY, GONLY, FIRST, FARG,
     -             FUNCNO, STATUS )
      IFG = STATUS(7)
      GOTO 90000

 4000 CALL ZZFNS4( N, X, F, G, WORK, SIZE, FONLY, GONLY, FIRST, FARG,
     -             FUNCNO, STATUS )
      IFG = STATUS(7)
      GOTO 90000

C## E N T R Y  ZZFFDF:
                      ENTRY  ZZFFDF ( SDOF, SDOG, SDOFG, SNOOP )
      DOF    = SDOF
      DOG    = SDOG
      DOFG   = SDOFG
      NEITHR = SNOOP
      RETURN

C## E N T R Y  ZZFRDF:
                      ENTRY  ZZFRDF(SOK,SABORT,SLIMIT,SNOF,SNOG,SNOFG)
      STATUS(1) = SOK
      STATUS(2) = SABORT
      STATUS(3) = SLIMIT
      STATUS(4) = SNOF
      STATUS(5) = SNOG
      STATUS(6) = SNOFG
      RETURN

C## E N T R Y  ZZFSET:
                       ENTRY  ZZFSET ( SETFNC, SETSIZ, FUNC, DIMN )
      FUNCNO = 0
      DO 82000 I = 1,NOFNS
         IF ( SETFNC .EQ. NAMES(I) ) THEN
            FUNCNO = I
            GOTO 82100
         ENDIF
82000 CONTINUE

82100 SIZE   = SETSIZ
      FIRST  = .TRUE.
      FUNC   = FUNCNO
      IF ( DIMN .NE. 0 ) THEN
          IF ( FUNCNO .GT. 0  ) THEN
             DIMN   = DIMNS(FUNCNO)
          ELSE
             DIMN = 2
          ENDIF
      ENDIF
C     PRINT*,'FUNCNO = ',FUNC
      RETURN

C## E N T R Y  ZZFPAR:
                        ENTRY ZZFPAR ( SARG )
      DO 80000 I = 1, FNO
         FARG (I) = SARG (I)
80000 CONTINUE
      RETURN

C## E X I T
90000       CONTINUE
      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZFNS.
                    END
