      SUBROUTINE BBVALS ( INTS, LOGS, REALS )

C## A R G U M E N T S:
                      INTEGER    INTS(*)
                      LOGICAL    LOGS(*)
                      REAL             REALS(*)
C!!!!                 DOUBLE PRECISION REALS(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: VALS.F,V 1.12 91/12/31 14:53:10 BUCKLEY EXP $
C>RCS $LOG:     VALS.F,V $
C>RCS REVISION 1.12  91/12/31  14:53:10  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.11  91/11/19  15:29:16  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.10  90/07/31  10:50:20  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:12:53  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3  89/05/18  12:39:28  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:55:41  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:54:31  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE CONTAINS THE DEFAULT VALUES FOR INITIALIZING
C     THE ROUTINES  ZZPRNT,  ZZEVAL,  ZZTERM  AND  BBLNIR.  IT RETURNS
C     THESE VALUES IN THE THREE ARRAYS IN THE CALLING SEQUENCE WHEN
C     CALLED. THE SPECIFIC ENTRIES ASSIGNED MAY BE SEEN BY LOOKING
C     AT THE TABLE BELOW.
C
C     REFERENCES ARE TO THE PUBLISHED ALGORITHM TOMS ALGORITHM 630,
C     OR, IF INDICATED BY (REM), TO THE LATER PUBLISHED REMARK ON
C     ALGORITHM 630.
C
C------------
C ARRAY INTS|
C------------
C INDEX INDEX NAME DEFAULT          USE
C CODE
C ------ ---  ----   ---            ---
C XDRVMD 1   DERVMD CANAL  CONTROL OF DERIVATIVE MODE; SEE SECTION 3.13
C XNORM  2   NORM   NL2    CONTROL OF NORM; SEE  SECTION 3.14 (REM)
C XSCALE 3   SCALE    0    SCALING TO APPLY TO F; SEE SECTION 3.13 (REM)
C XLTRCU 4   LTRACU   6    UNIT FOR BBLNIR TRACE OUTPUT; SEE LOGS(1-15)
C XETRCU 5   TRACEU   6    UNIT FOR OUTPUT OF F AND G; SEE LOGS(11,12)
C XPTRCU 6   UNIT     6    UNIT FOR ZZPRNT OUTPUT ; SEE SECTION 3.12 (REM)
C XTTRCU 7   TTRACU   6    UNIT FOR OUTPUT OF ZZTERM TRACE; SEE LOGS(27)
C XMETH  8   METH     0    SEE BBLSET IN LISTING OF  BBLNIR
C XQUADN 9   QUADIN   2    NOW 4. SEE BBLSET IN LISTING OF  BBLNIR
C XALPS1 10  ALPIS1   1    NOW 4. SEE BBLSET IN LISTING OF  BBLNIR
C XSCGMM 11  SCGAMM GAMONE SEE BBLSET IN LISTING OF  BBLNIR
C XHTEST 12  HTEST    1    SEE BBLSET IN LISTING OF  BBLNIR
C XUPDTT 13  UPDATT SUMFRM NOCEDAL UPDATES FLAG; SEE SECTION 2.7 (REM)
C XSTSTP 14  STSTEP   2    SEE BBLSET IN LISTING OF  BBLNIR
C
C------------
C ARRAY LOGS|
C------------
C INDEX INDEX NAME DEFAULT          USE
C CODE
C ------ ---  ----   ---            ---
C XTRACE 1--15 TRACES F THE 15 TRACE FLAGS; SEE LISTING OF BBLSET
C XTRF   16  TRF      F TRACE THE EVALUATION OF F IN ZZEVAL
C XTRG   17  TRG      F TRACE THE EVALUATION OF G IN ZZEVAL
C XTTRCE 18  TTRACE   F TRACE THE TERMINATION TESTS; SECTION 3.13 (REM)
C XTRTST 19  TRTEST   F TRACE DERIVATIVE TESTS; SEE SECTION 3.13 (REM)
C XGRAD  20  GRAD     T INCLUDE THE GRADIENT IN OUTPUT FROM ZZPRNT
C XPOINT 21  POINT    T INCLUDE THE POINT X IN OUTPUT FROM ZZPRNT
C XTGRAD 22  TGRAD    F INCLUDE THE GRADIENT TEST FOR TERMINATION
C XTSTEP 23  TSTEP    T INCLUDE THE STEP TEST FOR TERMINATION
C XTSHXG 24  TSHXG    T INCLUDE SHANNO'S TEST FOR TERMINATION
C XTFUNC 25  TFUNC    F INCLUDE THE FUNCTION TEST FOR TERMINATION
C XRELF  26  RELF     T MAKE FUNCTION TESTS RELATIVE TO F(X(0))
C XRELG  27  RELG     T MAKE GRADIENT TESTS RELATIVE TO G(X(0))
C XFQUAD 28  FQUAD    F SEE BBLSET IN LISTING OF BBLNIR
C XDIAGL 29  DIAGNL   F SEE BBLSET IN LISTING OF BBLNIR
C XSHNNO 30  SHANNO   F SEE BBLSET IN LISTING OF BBLNIR
C XFRMRS 31  FROMRS   F SEE BBLSET IN LISTING OF BBLNIR
C XFRCEF 32  FORCEF   T SEE BBLSET IN LISTING OF BBLNIR
C
C-------------
C ARRAY REALS|
C-------------
C INDEX INDEX NAME DEFAULT          USE
C CODE
C ------ ---  ----   ---            ---
C XRO      1  RO     0.2   SEE BBLSET IN LISTING OF BBLNIR
C XBETA    2  BETA   1.0   SEE BBLSET IN LISTING OF BBLNIR
C
C## E N T R Y   P O I N T S: BBVALS   NATURAL ENTRY POINT.
C                            BBDVAL   SET ANALYTIC DERIVATIVE CODE.
C                            BBRVAL   RESET BY READING NEW DATA IN.
C                            BBSVAL   RESET THE VALUES.
C
C## S U B R O U T I N E S:   NONE ARE CALLED.
C## P A R A M E T E R S:

      CHARACTER*(*) BLANK,        QUOTE,        HASH
      PARAMETER (   BLANK  = ' ', QUOTE  = '"', HASH   = '#' )

      CHARACTER*(*) PERIOD,       COMMA,        SEMICN
      PARAMETER (   PERIOD = '.', COMMA  = ',', SEMICN = ';' )

      CHARACTER*(*) COLON,        DASH,         EQUALS
      PARAMETER (   COLON  = ':', DASH   = '-', EQUALS = '=' )

      CHARACTER*(*) OBRACE,       CBRACE,       UNDERS
      PARAMETER (   OBRACE = '{', CBRACE = '}', UNDERS = '_' )

      CHARACTER*(*) PLUS,         MINUS,        EXCLAM
      PARAMETER (   PLUS   = '+', MINUS  = '-', EXCLAM = '!' )

      CHARACTER*(*) GTHAN,        LTHAN,        QUESMK
      PARAMETER (   GTHAN  = '>', LTHAN  = '<', QUESMK = '?' )

      CHARACTER*(*) SLASH,        BSLASH,       PERCNT
      PARAMETER (   SLASH  = '/', BSLASH = '\\',PERCNT = '%' )

      CHARACTER*(*) CARAT,        ATSIGN,       TILDE
      PARAMETER (   CARAT  = '^', ATSIGN = '@', TILDE = '~' )

      INTEGER     NINTS,      NLOGS,      NREALS,     NTRACF
      PARAMETER ( NINTS = 14, NLOGS = 32, NREALS = 2, NTRACF = 15 )

      INTEGER     XDRVMD,     XNORM,      XSCALE,     XLTRCU
      PARAMETER ( XDRVMD = 1, XNORM = 2,  XSCALE = 3, XLTRCU = 4 )

      INTEGER     XETRCU,     XPTRCU,     XTTRCU
      PARAMETER ( XETRCU = 5, XPTRCU = 6, XTTRCU = 7 )

      INTEGER     XMETH,      XQUADN,     XALPS1,      XSCGMM
      PARAMETER ( XMETH = 8,  XQUADN = 9, XALPS1 = 10, XSCGMM = 11 )

      INTEGER     XHTEST,     XUPDTT,      XSTSTP
      PARAMETER ( XHTEST = 12,XUPDTT = 13, XSTSTP = 14 )

      INTEGER     XTRACE
      PARAMETER ( XTRACE = 1 )

      INTEGER     XTRF,       XTRG,        XTTRCE,      XTRTST
      PARAMETER ( XTRF =  16, XTRG =   17, XTTRCE = 18, XTRTST = 19 )

      INTEGER     XGRAD,      XPOINT,      XTGRAD
      PARAMETER ( XGRAD = 20, XPOINT = 21, XTGRAD = 22 )

      INTEGER     XTSTEP,     XTSHXG,      XTFUNC,      XRELF
      PARAMETER ( XTSTEP = 23,XTSHXG = 24, XTFUNC = 25, XRELF = 26 )

      INTEGER     XRELG,      XFQUAD,      XDIAGL
      PARAMETER ( XRELG = 27, XFQUAD = 28, XDIAGL = 29 )

      INTEGER     XSHNNO,     XFRMRS,      XFRCEF
      PARAMETER ( XSHNNO = 30,XFRMRS = 31, XFRCEF = 32 )

      INTEGER     XRO,        XBETA
      PARAMETER ( XRO = 1,    XBETA = 2 )

      LOGICAL     T,          F
      PARAMETER ( T = .TRUE., F = .FALSE. )

      CHARACTER*(*) TRUE,          QT,       FALSE,           QF
      PARAMETER (   TRUE = 'TRUE', QT = 'T', FALSE = 'FALSE', QF = 'F' )

      INTEGER     ITRUE,     IFALSE
      PARAMETER ( ITRUE = 1, IFALSE = 0 )

      REAL              RTRUE,        RFALSE
C!!!! DOUBLE PRECISION  RTRUE,        RFALSE
      PARAMETER      (  RTRUE = 1.D0, RFALSE = 0.D0 )

      INTEGER     CTOUPP,     CTOLOW,     CTOCAP
      PARAMETER ( CTOUPP = 1, CTOLOW = 2, CTOCAP = 3 )

      INTEGER     CANAL,     CDIFF,     CTEST,     CFIRST
      PARAMETER ( CANAL = 1, CDIFF = 2, CTEST = 3, CFIRST = 4 )

       INTEGER     SUMFRM,     PRDFRM,     MJDFRM
       PARAMETER ( SUMFRM = 1, PRDFRM = 2, MJDFRM = 3 )

      INTEGER     NL1,     NL2,     NLINF
      PARAMETER ( NL1 = 1, NL2 = 2, NLINF = 3 )

      INTEGER     NQUITS
      PARAMETER ( NQUITS = 4 )

      INTEGER     PGRAD,     PSTEP,     PSHXG,     PFUNC
      PARAMETER ( PGRAD = 1, PSTEP = 2, PSHXG = 3, PFUNC = 4 )

      INTEGER     GAMOFF,     GAMONE,     GAMALL
      PARAMETER ( GAMOFF = 0, GAMONE = 1, GAMALL = 2 )

C--ZZEVAL.
         LOGICAL     TRF,     TRG,     TRTEST
         PARAMETER ( TRF = F, TRG = F, TRTEST = F )

         INTEGER     ETRACU,     SCALE,     DERVMD
         PARAMETER ( ETRACU = 6, SCALE = 0, DERVMD = CANAL )
C--ZZPRNT.
         INTEGER                          PTRACU
         LOGICAL     GRAD,     POINT
         PARAMETER ( GRAD = T, POINT = T, PTRACU = 6 )
C--ZZTERM.
         INTEGER     NORM,       TTRACU
         PARAMETER ( NORM = NL2, TTRACU = 6 )

         LOGICAL     TGRAD,     TSTEP,    TSHXG,     TFUNC
         PARAMETER ( TGRAD = F, TSTEP= T, TSHXG = T, TFUNC = F )

         LOGICAL     RELF,      RELG,     TTRACE
         PARAMETER ( RELF = T,  RELG = T, TTRACE = F )

C--BBLNIR.
         INTEGER     METH,       QUADIN,     ALPIS1,     STSTEP
C         PARAMETER ( METH = 0,   QUADIN = 2, ALPIS1 = 1, STSTEP = 2 )
         PARAMETER ( METH = 0,   QUADIN = 4, ALPIS1 = 4, STSTEP = 2 )
         INTEGER     SCGAMM,          HTEST,      UPDATT
         PARAMETER ( SCGAMM = GAMONE, HTEST = 1,  UPDATT = SUMFRM )

         REAL              RO,         BETA
C!!!!    DOUBLE PRECISION  RO,         BETA
         PARAMETER       ( RO = 0.2D0, BETA = 1.0D0 )

         LOGICAL     FQUAD,      DIAGNL,     SHANNO
         PARAMETER ( FQUAD = F,  DIAGNL = F, SHANNO = F )
         LOGICAL     FROMRS,     FORCEF
         PARAMETER ( FROMRS = F, FORCEF = T )

         INTEGER     LTRACU
         LOGICAL                 TRACE
         PARAMETER ( LTRACU = 6, TRACE = F )

C## L O C A L   D E C L:

      INTEGER KEEPI(NINTS), SINTS(NINTS), I, RUNIT, WUNIT, SANAL
      LOGICAL KEEPL(NLOGS), SLOGS(NLOGS), ON, OFF

      CHARACTER*(NLOGS)  CHECK

      REAL             KEEPR(NREALS), SREALS(NREALS)
C!!!! DOUBLE PRECISION KEEPR(NREALS), SREALS(NREALS)

C## S A V E:      EVERYTHING
            SAVE

C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NO VALUES ARE SET.

      DATA  KEEPI(XDRVMD) /DERVMD/, KEEPI(XNORM ) /NORM  /
      DATA  KEEPI(XSCALE) /SCALE /, KEEPI(XLTRCU) /LTRACU/
      DATA  KEEPI(XETRCU) /ETRACU/, KEEPI(XPTRCU) /PTRACU/
      DATA  KEEPI(XTTRCU) /TTRACU/, KEEPI(XMETH ) /METH  /
      DATA  KEEPI(XQUADN) /QUADIN/, KEEPI(XALPS1) /ALPIS1/
      DATA  KEEPI(XSCGMM) /SCGAMM/, KEEPI(XHTEST) /HTEST /
      DATA  KEEPI(XUPDTT) /UPDATT/, KEEPI(XSTSTP) /STSTEP/

      DATA  KEEPL(XTRF  ) /TRF   /, KEEPL(XTRG  ) /TRG   /
      DATA  KEEPL(XTTRCE) /TTRACE/, KEEPL(XTRTST) /TRTEST/
      DATA  KEEPL(XGRAD ) /GRAD  /, KEEPL(XPOINT) /POINT /
      DATA  KEEPL(XTGRAD) /TGRAD /, KEEPL(XTSTEP) /TSTEP /
      DATA  KEEPL(XTSHXG) /TSHXG /, KEEPL(XTFUNC) /TFUNC /
      DATA  KEEPL(XRELF ) /RELF  /, KEEPL(XRELG ) /RELG  /
      DATA  KEEPL(XFQUAD) /FQUAD /, KEEPL(XDIAGL) /DIAGNL/
      DATA  KEEPL(XSHNNO) /SHANNO/, KEEPL(XFRMRS) /FROMRS/
      DATA  KEEPL(XFRCEF) /FORCEF/

      DATA  (KEEPL(I),I=XTRACE,XTRACE+NTRACF-1) /NTRACF*TRACE/

      DATA  KEEPR(XRO   ) /RO/,     KEEPR(XBETA ) /BETA  /

C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
C---STATEMENT FUNCTION.

      ON(I)  = CHECK(I:I) .EQ. 'Y' .OR. CHECK(I:I) .EQ. 'T'
      OFF(I) = CHECK(I:I) .EQ. 'N' .OR. CHECK(I:I) .EQ. 'F'
C----
      DO 100 I = 1, NINTS
         INTS(I) = KEEPI(I)
  100 CONTINUE

      DO 200 I = 1,NLOGS
         LOGS(I) = KEEPL(I)
  200 CONTINUE

      CALL ZZCOPY ( NREALS, KEEPR, 1, REALS, 1 )

      GOTO 90000

C## E N T R Y  BBRVAL:
                     ENTRY  BBRVAL (WUNIT, RUNIT)

C     THIS IS USED TO INTERACTIVELY READ IN REPLACEMENT VALUES FOR
C     CONTROL PARAMETERS. IF AN END-OF-FILE IS ENCOUNTERED, EXECUTION
C     OF THIS ROUTINE TERMINATES IMMEDIATELY AND NO FURTHER VALUES
C     ARE READ.

      CHECK = BLANK
      WRITE( WUNIT, '(A,I3,A)')
     -    ' ENTER STRING OF T, F OR BLANK'
     -  //' CHARACTERS TO DEFINE UP TO ',NLOGS,' LOGICAL VALUES:'
      READ ( RUNIT, '(A)' ,END = 399 ) CHECK
      CALL ZZCASE (CHECK,CTOUPP)

      DO 350 I=1,NLOGS
         IF      ( ON(I) ) THEN
            KEEPL(I) = T
         ELSE IF ( OFF(I) ) THEN
            KEEPL(I) = F
         ENDIF
  350 CONTINUE

      WRITE( WUNIT, '(A,I3,A)')
     -    ' ENTER FREE FORMAT LIST OF UP TO ',NINTS, ' INTEGER VALUES:'
      READ ( RUNIT,   *, END = 399    ) (KEEPI(I),I=1,NINTS )

      WRITE( WUNIT, '(A,I3,A)')
     -    ' ENTER FREE FORMAT LIST OF UP TO ', NREALS, ' REAL VALUES:'
      READ ( RUNIT,   *, END = 399    ) (KEEPR(I),I=1,NREALS)

  399 CONTINUE
      RETURN

C## E N T R Y  BBSVAL:
                      ENTRY  BBSVAL ( SINTS, SLOGS, SREALS )
      DO 400 I = 1,NINTS
         KEEPI(I) = SINTS(I)
  400 CONTINUE

      DO 500 I = 1,NLOGS
         KEEPL(I) = SLOGS(I)
  500 CONTINUE

      CALL ZZCOPY ( NREALS, SREALS, 1, KEEPR, 1 )
      RETURN

C## E N T R Y  BBDVAL:
C                     REDEFINE ANALYTIC CODE FOR DERIVATIVE MODE.
      ENTRY  BBDVAL ( SANAL )

      KEEPI(XDRVMD) = SANAL
      RETURN

C## E X I T
90000       RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF BBVALS.
                    END
