      SUBROUTINE ZZTERM ( FIRST, N, FX, G, XI, XIM1, EPS, LESS )

C## A R G U M E N T S:
                      INTEGER          N
                      LOGICAL          LESS, FIRST

                      REAL             EPS, G(N), XI(N), XIM1(N), FX
C!!!!                 DOUBLE PRECISION EPS, G(N), XI(N), XIM1(N), FX

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: TERM.F,V 2.1 91/11/20 10:47:03 BUCKLEY EXP $
C>RCS $LOG:     TERM.F,V $
C>RCS REVISION 2.1  91/11/20  10:47:03  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.0  90/07/31  11:12:58  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:11:51  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3  89/05/18  12:40:18  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:49:32  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM..
C>RCS
C>RCS REVISION 1.1  89/01/07  14:36:12  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE IS USED TO TEST WHETHER OR NOT TO TERMINATE A
C     MINIMIZATION ROUTINE. IT PROVIDES A MEANS OF USING UNIFORM
C     CRITERIA FOR DIFFERENT ROUTINES. A CHOICE OF CRITERIA IS
C     PROVIDED, ACCORDING TO VARIABLES WHICH ARE PASSED IN THE
C     ENTRY ZZTSET.
C
C     NOTE THAT IN ONE CASE, THE TEST CANNOT BE APPLIED ON THE
C     FIRST POINT SINCE A PAIR OF SUCCESSIVE POINTS IS REQUIRED.
C     THUS A FLAG FIRST IS REQUIRED IN THE CALLING SEQUENCE. IF IT
C     IS TRUE, IT IS ASSUMED THAT THE ALGORITHM IS AT AN INITIAL
C     POINT AND LESS IS ALWAYS RETURNED AS FALSE IF ONE INCLUDES THE
C     TEST WHICH LOOKS AT MORE THAN ONE POINT.
C
C     NOTE THAT IT WILL ALWAYS RETURN A TRUE VALUE IF THE NORM
C     OF THE GRADIENT COMPUTES TO 0, SINCE IN THIS CASE, NO FURTHER
C     STEPS CAN BE TAKEN ANYWAY.
C
C     HERE !! V !! DENOTES THE APPROPRIATE NORM OF THE VECTOR V.
C
C     N     IS THE LENGTH OF THE VECTORS.
C
C-----ENTRY ZZTSET ( NORM, TESTS, TRACE, TRACUN )
C
C     THE CRITERIA ARE DETERMINED AS FOLLOWS:
C
C     NORM  = NL1  [1]   USE THE   NL1     (ABSSUM) NORM OF VECTORS.
C           = NL2  [2]   USE THE   NL2  (EUCLIDEAN) NORM OF VECTORS.
C           = NLINF[3]   USE THE MAXIMUM (INFINITY) NORM OF VECTORS.
C
C     TESTS  THIS IS A CHARACTER STRING OF LENGTH 4. EACH CHARACTER
C            CAN BE 'T' TO INDICATE THAT THE CORRESPONDING TEST
C            IS TO BE APPLIED, OR ANYTHING ELSE TO INDICATE NOT.
C            THE DIGIT IN [.] BELOW INDICATES WHICH CHARACTER
C            IN THE STRING CONTROLS EACH TEST.
C
C            IF THE TRACE ARGUMENT IS SET TO TRUE, THEN THE RESULT OF
C            EACH TEST WILL BE PRINTED ON UNIT TRACUN. NOTE THAT WHEN
C            SEVERAL TESTS ARE BEING APPLIED, THE TRACE WILL SHOW EACH
C            SEPARATELY.
C
C            THE TESTS MAY BE SCALED RELATIVE TO CERTAIN VALUES,
C            NORMALLY THE VALUE OF THE FUNCTION AND GRADIENT AT THE
C            INITIAL POINT. THIS IS DESCRIBED FURTHER IN THE DESCRIPTION
C            OF THE ENTRY POINT ZZTINT BELOW.
C
C     TYPE  = GRAD[1] TEST IF THE APPROPRIATE NORM OF G IS < OR = EPS.
C                     THIS FIRST TYPE OF TEST IS MOST COMMONLY USED TO
C                     SEE IF THE GRADIENT IS SUFFICIENTLY SMALL. THUS
C                     THE TEST APPLIED IS
C
C                           !!G!! <= EPS * NG0
C
C           = STEP[2] TEST IF THE APPROPRIATE NORM OF THE DIFFERENCE
C                     BETWEEN XI AND XIM1 IS <= EPS. THE TEST IS
C                     ABSOLUTE IF THE NORM OF XI IS LESS THAN ONE, AND
C                     RELATIVE OTHERWISE. THIS TYPE OF TEST IS NORMALLY
C                     USED TO TEST THE DISTANCE BETWEEN SUCCESSIVE
C                     POINTS. THUS THE TEST IS
C
C                       !! XI-XIM1 !! <= EPS * MAX(1,!!XI!!)
C
C           = SHXG[3] USE A TEST APPEARING IN SHANNO'S CONMIN USING X
C                     AND G. TERMINATION IS INDICATED WHEN
C
C                              !!G!!
C                           ------------  <=   EPS * NG0
C                           MAX(1,!!X!!)
C
C           = FUNC[4] TERMINATE IF THE FUNCTION VALUE IS SUFFICIENTLY
C                     SMALL. THIS TEST WOULD NORMALLY ONLY BE USED IN
C                     A RELATIVE MANNER. THUS THE TEST IS
C
C                         !FX! <= EPS * !FX0!
C
C          NOTE THAT SEVERAL OF THESE TESTS MAY BE APPLIED. THIS IS
C          DETERMINED BY THE NUMBER OF CHARACTERS IN THE STRING TESTS
C          WHICH ARE SET TO 'T'.
C
C     OTHER POINTS TO NOTE ARE:
C
C     SOME TESTS ARE ACTUALLY DONE BY COMPARING THE SQUARES OF THE
C     NORMS AGAINST EPS**2. THUS IT IS POSSIBLE THAT THIS VERSION
C     OF THIS ROUTINE MIGHT GENERATE AN UNWANTED OVERFLOW OR
C     UNDERFLOW.
C
C     NOTE:  NEITHER  G  NOR XI NOR XIM1 IS ALTERED BY THIS ROUTINE.
C            ONLY THOSE VECTORS USED IN THE TEST ARE ACTUALLY
C            REFERENCED. FOR EXAMPLE, IF TYPE=GRAD (ONLY), XIM1 IS NOT
C            REFERENCED.
C
C     ON RETURN:  IF THE DESIRED TESTS ARE *ALL* PASSED, THEN  LESS
C                 IS SET TO .TRUE.; OTHERWISE IT IS SET TO .FALSE..
C
C-----ENTRY TGET ( GSQ, XSG, DIFFSQ )
C
C     GSQ, XSQ - THE VECTOR NORMS COMPUTED DURING APPLICATION OF THE
C     DIFFSQ     TESTS ARE DECLARED AS SAVE VARIABLES SO THAT THE
C                VALUES CAN BE ACCESSED IF DESIRED BY CALLING THE
C                ENTRY POINT  ZZTGET. OF COURSE, ONLY THOSE WHICH
C                WERE ACTUALLY COMPUTED IN APPLYING THE DESIRED TESTS
C                WILL BE DEFINED.
C
C                WE HAVE SPECIFICALLY:
C
C        GSQ    NORM SQUARED OF  G,         GSQ    = !!G!!**2
C
C        XSQ    NORM SQUARED OF  XI,        XSQ    = !!XI!!**2
C
C        DIFFSQ NORM SQUARED OF  XI-XIM1,   DIFFSQ = !!XI-XIM1!!**2
C
C-----ENTRY POINT ZZTINT (FX0, NG0)
C
C     IT IS OFTEN DESIRED TO MAKE TERMINATION TESTS RELATIVE TO THE
C     FUNCTION AND/OR GRADIENT VALUES AT THE INITIAL POINT. IN THE
C     TESTS ABOVE, THE VALUES  FX0  AND  NG0 ARE USED; THESE MAY BE
C     THOUGHT OF AS THE FUNCTION VALUE AT X0, ALONG WITH THE NORM OF
C     THE GRADIENT AT THAT POINT.  THE VALUES FOR  FX0  AND NG0 ARE SET
C     BY CALLING THIS ENTRY POINT JUST AFTER THE FIRST FUNCTION AND
C     GRADIENT HAVE BEEN EVALUATED.  IF RELATIVE TESTS ARE NOT DESIRED,
C     THESE VALUES SHOULD BE SET TO 1. IF THE ENTRY POINT IS NOT CALLED,
C     THE DEFAULT VALUE FOR THESE IS IN FACT 1.
C
C## E N T R Y   P O I N T S: ZZTERM  ...THE NATURAL ENTRY.
C                            ZZTGET  ...RETURN NORMS.
C                            ZZTSET  ...SET THE CONTROL VALUES.
C                            ZZTINT  ...SET INITIAL SCALING VALUES.
C## S U B R O U T I N E S:   ABS   AND  MAX ...INTRINSIC
C## P A R A M E T E R S:
      REAL              ZERO,       ONE,       TWO,       THREE
C!!!! DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      REAL              FOUR,       FIVE,      SIX,       SEVEN
C!!!! DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      REAL              EIGHT,         NINE,          TEN
C!!!! DOUBLE PRECISION  EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

      LOGICAL     T,          F
      PARAMETER ( T = .TRUE., F = .FALSE. )

      CHARACTER*(*) TRUE,          QT,       FALSE,           QF
      PARAMETER (   TRUE = 'TRUE', QT = 'T', FALSE = 'FALSE', QF = 'F' )

      INTEGER     ITRUE,     IFALSE
      PARAMETER ( ITRUE = 1, IFALSE = 0 )

      REAL              RTRUE,        RFALSE
C!!!! DOUBLE PRECISION  RTRUE,        RFALSE
      PARAMETER      (  RTRUE = 1.D0, RFALSE = 0.D0 )
C----                               NORM AND TEST TYPES

      INTEGER     NL1,     NL2,     NLINF
      PARAMETER ( NL1 = 1, NL2 = 2, NLINF = 3 )

      INTEGER     NQUITS
      PARAMETER ( NQUITS = 4 )

      INTEGER     PGRAD,     PSTEP,     PSHXG,     PFUNC
      PARAMETER ( PGRAD = 1, PSTEP = 2, PSHXG = 3, PFUNC = 4 )

C## L O C A L   D E C L:

      INTEGER   I

      REAL             GSQ, XSQ, DIFFSQ
C!!!! DOUBLE PRECISION GSQ, XSQ, DIFFSQ

      LOGICAL  LIST

C-----DECLARATIONS FOR ENTRY POINT DUMMY ARGUMENTS.

      CHARACTER*(4)      TESTS
      LOGICAL            GRAD, STEP, SHXG, FUNC, TRACE, STRACE

      INTEGER            NORM, SNORM, TRACUN, STRCUN

      REAL               VGSQ, VXSQ, VDIFSQ, FX0, SF0, NG0, SNG0
C!!!! DOUBLE PRECISION   VGSQ, VXSQ, VDIFSQ, FX0, SF0, NG0, SNG0

C## S A V E:
            SAVE GSQ, XSQ, DIFFSQ, FX0, NG0, GRAD, STEP
            SAVE TRACE, TRACUN, SHXG, FUNC, NORM

C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:
      DATA  FX0/ONE/,  NG0/ONE/
      DATA  NORM/2/,  TRACE/.FALSE./, TRACUN/6/
      DATA  GRAD/.FALSE./, STEP/.TRUE./, SHXG/.TRUE./, FUNC/.FALSE./

C##                                                E X E C U T I O N
C##                                                E X E C U T I O N

      IF ( .NOT. FIRST .OR. GRAD .OR. SHXG ) THEN

         IF ( GRAD .OR. SHXG ) THEN

            GSQ = ZERO
            DO 500 I=1,N
               IF     ( NORM .EQ. NL1 ) THEN
                  GSQ = GSQ +  ABS(G(I))
               ELSEIF ( NORM .EQ. NL2 ) THEN
                  GSQ = GSQ + (G(I))**2
               ELSEIF ( NORM .EQ. NLINF ) THEN
                  GSQ = MAX( GSQ, ABS(G(I)) )
               ENDIF
  500       CONTINUE

            IF ( GSQ .EQ. ZERO ) THEN
               LESS = T
               GOTO 90000
            ENDIF
         ENDIF

         IF ( STEP .OR. SHXG ) THEN

            XSQ = ZERO
            DO 700 I=1,N
               IF     ( NORM .EQ. NL1 ) THEN
                  XSQ = XSQ +  ABS(XI(I))
               ELSEIF ( NORM .EQ. NL2 ) THEN
                  XSQ = XSQ + (XI(I))**2
               ELSEIF ( NORM .EQ. NLINF ) THEN
                  XSQ = MAX( XSQ, ABS(XI(I)) )
               ENDIF
  700       CONTINUE
         ENDIF

         IF ( STEP ) THEN

            DIFFSQ = ZERO
            DO 900 I=1,N
               IF     ( NORM .EQ. NL1 ) THEN
                  DIFFSQ = DIFFSQ +  ABS(XI(I) - XIM1(I))
               ELSEIF ( NORM .EQ. NL2 ) THEN
                  DIFFSQ = DIFFSQ + ( XI(I)-XIM1(I) )**2
               ELSEIF ( NORM .EQ. NLINF ) THEN
                  DIFFSQ = MAX( DIFFSQ, ABS(XI(I) - XIM1(I)) )
               ENDIF
  900       CONTINUE
         ENDIF
      ENDIF

      IF ( FIRST .AND. STEP ) THEN
         LESS = .FALSE.
         IF ( TRACE ) WRITE(TRACUN,99999) ' [TERM] FIRST POINT;'
     -                        //' NO STEPSIZE; NO TEST DONE.'
      ELSE
         LESS = .TRUE.
         IF ( GRAD ) THEN
            LIST = GSQ .LE. (EPS*NG0)**2
            LESS = LESS .AND.  LIST
            IF (TRACE) WRITE(TRACUN,99998)
     -          LIST,'(GRAD) GSQ,EPS,NG0=',GSQ,EPS,NG0
         ENDIF

         IF ( STEP .AND. (LESS .OR. TRACE) ) THEN
            LIST = DIFFSQ .LE. EPS**2 * MAX(ONE,XSQ)
            LESS = LESS .AND.  LIST
            IF (TRACE) WRITE(TRACUN,99998)
     -           LIST, '(STEP) DIFFSQ,XSQ,EPS=', DIFFSQ,XSQ,EPS
         ENDIF

         IF ( SHXG .AND. (LESS .OR. TRACE) ) THEN
            LIST = GSQ .LE. (EPS*NG0)**2 * MAX(ONE,XSQ)
            LESS = LESS .AND.  LIST
            IF (TRACE) WRITE(TRACUN,99997)  LIST,
     -             ' (SHXG) G,XSQ;EPS,NG0=',GSQ,XSQ,EPS,NG0
         ENDIF

         IF ( FUNC .AND. (LESS .OR. TRACE) ) THEN
            LIST = ABS(FX) .LE. EPS * ABS(FX0)
            LESS = LESS .AND.  LIST
            IF (TRACE) WRITE(TRACUN,99998)
     -          LIST, '(FUNC) FX, FX0, EPS=',FX, FX0, EPS
         ENDIF
      ENDIF
      GOTO 90000

C## E N T R Y  ZZTSET:
                      ENTRY ZZTSET ( SNORM, TESTS, STRACE, STRCUN )
      NORM  = SNORM
      GRAD  = TESTS(PGRAD:PGRAD) .EQ. 'T'
      STEP  = TESTS(PSTEP:PSTEP) .EQ. 'T'
      SHXG  = TESTS(PSHXG:PSHXG) .EQ. 'T'
      FUNC  = TESTS(PFUNC:PFUNC) .EQ. 'T'
      TRACE  = STRACE
      TRACUN = STRCUN
      RETURN

C## E N T R Y  ZZTINT:
                       ENTRY  ZZTINT ( SF0, SNG0 )
      FX0 = SF0
      NG0 = SNG0
      RETURN

C## E N T R Y  ZZTGET:
                      ENTRY  ZZTGET ( VGSQ, VXSQ, VDIFSQ )
      VGSQ   = GSQ
      VXSQ   = XSQ
      VDIFSQ = DIFFSQ
      RETURN

C## E X I T
90000      RETURN

C## F O R M A T S:  NONE ARE DEFINED.

99999 FORMAT ( A )
99998 FORMAT ( ' [TERM] LESS=',L1,'; ',A,3G14.3 )
99997 FORMAT ( ' [TERM] LESS=',L1,'; ',A,4G11.3 )

C##                 E N D         OF ZZTERM.
                    END
