      SUBROUTINE ZZLADV ( LOOPC, LOOPX, N, OVER )

C## A R G U M E N T S:
                       INTEGER  LOOPX(*), N
                       LOGICAL  OVER
                       REAL              LOOPC(*)
C!!!!                  DOUBLE PRECISION  LOOPC(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C      THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!  THIS VERSION IS IN   D O U B L E   PRECISION.
C
C>RCS $HEADER: LADV.F,V 1.10 91/11/20 10:52:57 BUCKLEY EXP $
C>RCS $LOG:     LADV.F,V $
C>RCS REVISION 1.10  91/11/20  10:52:57  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:38:18  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  16:42:51  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:20:40  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:47:58  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:50:10  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C              THIS ROUTINE ADVANCES THE LOOPING CONTROL.
C
C
C      THE LOOP CONTROL IS STRUCTURED AS FOLLOWS:
C
C  THE REAL ARRAY LOOPC CONTAINS THE LOOP INFORMATION FOR EITHER A LOOP
C  OR A LIST. THE ARRAY LOOPX FUNCTIONS LIKE AN AUTOMOBILE ODOMETER
C  WHERE EACH "POSITION" OF THE ODOMETER MAY BE A LIST OR A LOOP. IT
C  SPECIFIES WHERE THE INFORMATION FOR EACH "POSITION" MAY BE FOUND,
C  I.E. IT IS AN INDEX INTO LOOPC. THE TOTAL NUMBER OF "POSITIONS"
C  OF THE ODOMETER IS N.
C
C      CONSIDER FOR EXAMPLE N = 2 WITH
C
C               LOOPX = (6,1)
C               LOOPC = (0.0,3.0,1.0,7.0,2.0,4.0,2.0,6.1,7.3,2.6,1.8)
C
C  THE "RIGHTMOST" COLUMN TO THE ODOMETER (I.E. THE ONE THAT
C  INCREMENTS MOST RAPIDLY) IS IN LOOPX(2), WHICH POINTS TO
C  LOOPC(1). SINCE LOOPC(1) IS ZERO, THIS DEFINES A LOOP. THE
C  LAST LOOP VALUE PROCESSED WAS 3.0 AND THE LOOP IS DEFINED
C  FROM 1.0 TO 7.0 IN ADDITIVE STEPS OF 2.0.
C
C      IF LOOPC(1) WERE -1, IT WOULD ALSO DEFINE A LOOP, BUT
C  IT WOULD BE MULTIPLICATIVE, AND HENCE IT WOULD DEFINE A
C  GEOMETRIC PROGRESSION, RATHER THAN AN ARITHMETIC ONE.
C  NOTE THAT THE MULTIPLYING FACTOR CAN BE GREATER OR LESS THAN
C  ONE IN MAGNITUDE. IT CAN ALSO BE NEGATIVE, BUT THE TEST FOR
C  TERMINATION IS BASED SOLELY ON ABSOLUTE VALUES OF THE GIVEN
C  QUANTITIES.
C
C      WHEN LOOPC(1) IS -2, IT DEFINES THE SAME TYPE OF PROGRESSION
C  AS WHEN IT IS 0, EXCEPT THAT IT IS ASSUMED THAT THE SEQUENCE IS
C  INTENDED TO CONTAIN ONLY INTEGRAL VALUES AND HENCE ALL VALUES
C  GENERATED AND USED IN COMPARISONS FOR TERMINATION ARE FORCED TO
C  BE INTEGRAL. THE SAME APPLIES WHEN IT IS -3, EXCEPT THAT IT IS
C  COMPARABLE TO THE -1 CASE. NOTE THAT IT IS THE RESPONSIBILITY OF
C  THE USER TO ENSURE THAT ROUNDING TO INTEGRAL VALUES IS SENSIBLE.
C
C      THE NEXT COLUMN OF THE ODOMETER TO ADVANCE IS LOOPX(1), WHICH
C  POINTS AT LOOPC(6). SINCE THE VALUE THERE IS 4.0, THIS EXPLICITLY
C  DEFINES A LIST OF 4 ELEMENTS. THE LAST ONE PROCESSED WAS THE 2ND
C  I.E. 7.3. THE ELEMENTS IN THE LIST ARE 6.1, 7.3, 2.6 AND 1.8.
C
C      WHEN ONE POSITION OF THE ODOMETER GOES PAST ITS LAST VALUE, IT IS
C  RESET TO ITS FIRST VALUE AND THE POSITION TO ITS IMMEDIATE LEFT IS
C  ADVANCED.
C
C      THE FLAG 'OVER' IS SET TO TRUE IF THE ODOMETER 'TURNS OVER',
C  I.E. IF ALL COLUMNS HAVE REACHED THEIR MAXIMUM VALUE AND ADVANCING
C  IT CAUSES THEM ALL TO BE RESET TO THEIR INITIAL VALUES. IF NOT, THEN
C  OVER IS SET FALSE.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZLADV
C## S U B R O U T I N E S:   NINT, ABS, DBLE(REAL)  ... INTRINSICS
C                            RD    ... INTEGER TO REAL (DBLE).
C
C## P A R A M E T E R S:
      REAL              ZERO,       ONE,       TWO,       THREE
C!!!! DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      REAL              FOUR,       FIVE,      SIX,       SEVEN
C!!!! DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      REAL              EIGHT,         NINE,          TEN
C!!!! DOUBLE PRECISION  EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

C## L O C A L   D E C L:
                         INTEGER  I, J, COUNT, K, I3, I4, IC
                         REAL              CURR, RD, FACTOR
C!!!!                    DOUBLE PRECISION  CURR, RD, FACTOR

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
C------             DEFINE A FUNCTION STATEMENT.
      RD(I) = REAL(I)
C!!!! RD(I) = DBLE(I)

      OVER = .FALSE.
      DO  2000 I = N, 1, -1
         J     =       LOOPX(I)
         COUNT = NINT( LOOPC(J) )
         IF ( COUNT .EQ. 0 ) THEN
C                                  REAL ARITHMETIC PROGRESSION
            CURR = LOOPC(J+1) + LOOPC(J+4)
            IF (( LOOPC(J+4) .GT. ZERO .AND. CURR .LE. LOOPC(J+3))  .OR.
     -         ( LOOPC(J+4) .LE. ZERO .AND. CURR .GE. LOOPC(J+3) )) THEN
               LOOPC(J+1) = CURR
               GOTO 90000
            ELSE
               LOOPC(J+1) = LOOPC(J+2)
            ENDIF

         ELSE IF ( COUNT .EQ. -1 ) THEN
C                                         REAL GEOMETRIC PROGRESSION
            CURR = LOOPC(J+1) * LOOPC(J+4)
            IF  (  (     ABS(LOOPC(J+4)) .GT. ONE
     -             .AND. ABS(CURR) .LE. ABS(LOOPC(J+3)) )
     -                          .OR.
     -              (    ABS(LOOPC(J+4)) .LE. ONE
     -              .AND. ABS(CURR) .GE. ABS(LOOPC(J+3)) ) )  THEN
               LOOPC(J+1) = CURR
               GOTO 90000
            ELSE
               LOOPC(J+1) = LOOPC(J+2)
            ENDIF

         ELSE IF ( COUNT .EQ. -2 ) THEN
C                                      INTEGRAL ARITHMETIC PROGRESSION
            IC = NINT(LOOPC(J+1)) + NINT(LOOPC(J+4))
            I4 = NINT(LOOPC(J+4))
            I3 = NINT(LOOPC(J+3))
            IF ( ( I4 .GT. 0 .AND. IC .LE. I3 )   .OR.
     -           ( I4 .LE. 0 .AND. IC .GE. I3 ) ) THEN
               LOOPC(J+1) = RD(IC)
               GOTO 90000
            ELSE
               LOOPC(J+1) = LOOPC(J+2)
            ENDIF

         ELSE IF ( COUNT .EQ. -3 ) THEN
C                                         INTEGRAL GEOMETRIC PROGRESSION
            FACTOR = LOOPC(J+4)
            I4     = NINT(FACTOR)

            IF ( FACTOR .GT. ONE ) THEN
                IC = NINT(LOOPC(J+1)) * I4
            ELSE
                IC = NINT(LOOPC(J+1)) / NINT(ONE/LOOPC(J+4))
            ENDIF

            I3 = NINT(LOOPC(J+3))
            IF  (( ABS(FACTOR) .GT. 1 .AND. ABS(IC) .LE. ABS(I3) ) .OR.
     -           ( ABS(FACTOR) .LE. 1 .AND. ABS(IC) .GE. ABS(I3) )) THEN
               LOOPC(J+1) = RD(IC)
               GOTO 90000
            ELSE
               LOOPC(J+1) = LOOPC(J+2)
            ENDIF

         ELSE
C                            LIST SPECIFICATION
            K = NINT( LOOPC(J+1) )
            IF ( K .LT. COUNT ) THEN
               LOOPC(J+1) = K+1
               GOTO 90000
            ELSE
               LOOPC(J+1) = 1
            ENDIF
         ENDIF

C     NOTE THAT THE LOOP WILL BE REPEATED WHENEVER ONE POSITION
C     "TURNS OVER", AND HENCE TRIGGERS THE NEXT POSITION. IF
C     IT DID NOT TURN OVER, THE LOOP WILL HAVE BEEN EXITED.

 2000 CONTINUE

C     IF ALL POSITIONS "TURNED OVER" SO THAT THE ODOMETER IS BACK
C     TO ITS ORIGINAL POSITION, SET THE FLAG OVER.

      OVER = .TRUE.

C## E X I T
90000       RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZLADV.
                    END
