      SUBROUTINE ZZPRNT ( N, X, F, G, NRMG, INCR )

C## A R G U M E N T S:
                      INTEGER             N, INCR

                      REAL                F, X(N), G(N), NRMG
C!!!!                 DOUBLE PRECISION    F, X(N), G(N), NRMG

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: PRNT.F,V 2.2 91/12/16 12:12:48 BUCKLEY EXP $
C>RCS $LOG:     PRNT.F,V $
C>RCS REVISION 2.2  91/12/16  12:12:48  BUCKLEY
C>RCS MINOR FIX FOR TOMS.
C>RCS
C>RCS REVISION 2.1  91/11/20  10:47:02  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.0  90/07/31  11:12:40  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:11:49  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.4  89/05/21  12:44:25  BUCKLEY
C>RCS REVISED FOR COPY
C>RCS
C>RCS REVISION 1.3  89/05/18  12:40:15  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:49:27  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM..
C>RCS
C>RCS REVISION 1.1  89/01/07  14:36:05  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE PRINTS (OPTIONALLY) A POINT  X , THE VALUE F OF
C     SOME FUNCTION AT THE POINT  X, ALONG WITH THE NORM OF THE GRADIENT
C     AT THAT POINT, AND (OPTIONALLY) THE VALUE OF THE GRADIENT
C     G  AT THE POINT X.
C
C     TWO OUTPUT UNITS MAY BE SIMULTANEOUSLY DEFINED; EITHER OR BOTH
C     MAY BE USED. THE PRINT INTERVAL MAY BE DEFINED INDEPENDENTLY FOR
C     EACH. IF FORCE IS SET, IT APPLIES TO BOTH, IF BOTH ARE DEFINED.
C     THE DESCRIPTION BELOW ONLY APPLIES TO ONE UNIT. IDENTICAL COMMENTS
C     APPLY TO THE OTHER. OUTPUT TO A UNIT MAY BE TURNED OFF BY SETTING
C     THE LEVEL TO 0, OR THE UNIT NUMBER TO 0. ONLY ONE CALL IS NEEDED
C     AT EACH ITERATE; PRINTING WILL BE DONE ON EITHER OR BOTH UNITS,
C     AS NEEDED.
C
C     SOME OF THE CONTROL OF  PRINT  IS THROUGH VARIABLES WHICH ARE
C     SET THROUGH AN ENTRY POINT CALL TO ZZPSET. THESE ARE DECLARED
C     AS  SAVE VARIABLES.  ZZPSET SHOULD BE CALLED TO INITIALIZE ZZPRNT
C     EACH TIME A FUNCTION IS TO BE MINIMIZED. THE DESCRIPTION OF THE
C     CONTROL FOLLOWS.
C
C---DESCRIPTION OF PARAMETERS.
C
C   N      THE DIMENSION OF THE PROBLEM.
C   X      THE CURRENT POINT.
C   F      THE FUNCTION VALUE AT X.
C   G      THE GRADIENT VALUE AT X, IF NEEDED.
C   NRMG   THE NORM OF THE GRADIENT.
C   INCR   SEE (5) BELOW.
C
C---NOTE: 1. CONTROL IS UNDER  PLEV1. (PLEV MEANS PRINT LEVEL)
C            SEE ENTRY POINT ZZP1ST BELOW.
C
C            LET  IP = ABS(PLEV1). THEN IF
C
C              PLEV1 = 0   THERE IS NO OUTPUT.
C
C              PLEV1 < 0   PRINT EVERY IP-TH ITERATION:
C
C                             THE ITERATION NUMBER IN ITCT,
C                             THE FUNCTION VALUE IN F,
C                             THE NO. OF FUNC EVALUATIONS IN IFNCT.
C                             THE NO. OF GRAD EVALUATIONS IN IGRCT.
C
C                             THESE COUNTS ARE OBTAINED THROUGH A CALL
C                             TO THE ENTRY POINT  ZZEGET  IN ZZEVAL.
C
C              PLEV1 > 0   PRINT EVERY IP-TH ITERATION, AS FOR
C                           PLEV1 < 0, BUT ALSO PRINT:
C
C                             THE POINT X, AND
C                             THE GRADIENT G (SEE POINT 2 BELOW).
C
C         2. SETTING GRAD1 = FALSE WILL ENSURE THAT THE GRADIENTS ARE
C            NEVER PRINTED, REGARDLESS OF THE VALUE OF PLEV1.  THIS
C            WOULD BE APPROPRIATE WHEN GRADIENTS ARE NOT AVAILABLE OR
C            TO PRINT  X  WITHOUT PRINTING  G  WHEN PLEV1 > 0. THE
C            SAME COMMENTS APPLY TO SUPPRESSING X WITH POINT1=FALSE.
C
C         3. PRPT1 RECORDS THE NUMBER OF THE NEXT ITERATION AT WHICH
C            TO PRINT.  WHEN ZZP1ST IS CALLED, THE ITERATION COUNT
C            ITCT IS INITIALIZED (TO -1) AND PRPT1 IS SET TO 0; THIS
C            IS WHY  ZZP1ST  MUST BE CALLED BEFORE EACH FUNCTION IS
C            MINIMIZED.  ON ENTRY TO ZZPRNT, ITCT IS FIRST INCREMENTED
C            BY 1. THEN, IF  ITCT  IS LESS THAN  PRPT1, NO ACTION TAKES
C            PLACE AT ALL.  IF ON THE OTHER HAND, ITCT = PRPT1, THEN
C            PRINTING OF THE APPROPRIATE INFORMATION IS DONE, AND
C            THEN PRPT1 IS ADVANCED BY ABS(PLEV1) TO MARK THE POINT
C            AT WHICH NEXT TO PRINT. IF ON ENTRY THE VALUE OF ITCT
C            IS BEYOND THAT OF PRPT1, PRPT1 IS REPEATEDLY INCREMENTED BY
C            ABS(PLEV1) UNTIL ONE OF THE FIRST TWO CASES OCCURS. OF
C            COURSE THIS IS NOT SUPPOSED TO HAPPEN IF ZZP1ST WAS
C            CALLED TO INITIALIZE ZZPRNT.
C
C         4. ITCT IS INCREMENTED INTERNALLY, BUT THE COUNTING OF
C            IFNCT AND IGRCT WILL BE DONE BY ZZEVAL; THE VALUES ARE
C            OBTAINED BY A CALL TO THE ENTRY POINT ZZEGET.
C
C         5. SETTING INCR CAN BE USED TO FORCE PRINTING, REGARDLESS
C            OF THE VALUES OF PRPT1 AND ITCT.  THIS IS USEFUL FOR
C            FORCING PRINTING OF THE FINAL POINT REACHED. IN FACT,
C            INCR DEFINES THE AMOUNT BY WHICH TO INCREMENT THE INTERNAL
C            ITERATION COUNTER OF ZZPRNT. THUS, NORMALLY ZZPRNT WILL
C            BE CALLED WITH INCR = 1. TO FORCE PRINTING, ZZPRNT MAY BE
C            CALLED WITH INCR = 0; THE POINT IS PRINTED BUT  THE ITERA-
C            TION COUNTER IS NOT ADVANCED. FINALLY, IF ONE WISHES TO
C            INSIST THAT THE ITERATION COUNTER BE UPDATED CORRECTLY AND
C            THAT THE POINT BE PRINTED REGARDLESS OF THE VALUE OF PRPT1,
C            ONE MAY CALL ZZPRNT WITH INCR = -1; BECAUSE INCR <=0, THE
C            PRINT OF THE POINT WILL BE FORCED, AND IT IS IN FACT
C            ABS(INCR) THAT IS USED TO UPDATE THE ITERATION COUNT. THIS
C            PARTICULAR CASE IS USEFUL AT THE FINAL POINT.
C
C            NOTE THAT PRPT1 IS STILL ADVANCED, BUT ONLY IF APPROPRIATE,
C            I.E. IF PRINTING WOULD HAVE BEEN DONE ANYWAY, AS EXPLAINED
C            IN 2.
C
C            ALSO, WHEN FORCING IS DONE, THE ROUTINE IS CAREFUL NOT
C            TO REPEAT A PRINTING REQUEST.  IF THE OUTPUT UNIT OR
C            THE STATUS OF GRAD1 OR THE ITERATION COUNT ITCT IS
C            DIFFERENT, THEN THE PRINTING IS DONE; OTHERWISE IT
C            IS CONSIDERED A REPEAT OF A PREVIOUS REQUEST AND IT
C            IS IGNORED.
C
C         6. PRTIME IS USED FOR ACCUMULATING THE TIME SPENT IN THE
C            PRINT ROUTINE.  IT IS INITIALIZED TO ZERO AT THE CALL
C            TO ZZP1ST, AND EACH CALL TO ZZPRNT INCREMENTS PRTIME BY
C            THE AMOUNT OF TIME SPENT IN THE ROUTINE.
C
C---ALSO AVAILABLE THROUGH  ZZPGET (TIME, ITER).
C
C      THE USER MAY CALL ZZPGET AT ANY TIME TO GET THE AMOUNT OF TIME
C      SPENT IN THE PRINT ROUTINE AND THE CURRENT ITERATION COUNT.
C      THESE ARE, RESP., THE ARGUMENTS ITER AND  TIME.
C
C## E N T R Y   P O I N T S:
C
C     ZZPRNT   ...THE NATURAL ENTRY.
C     ZZP1ST   ...TO INITIALIZE CONTROL VARIABLES FOR FIRST UNIT.
C     ZZP2ST   ...TO INITIALIZE CONTROL VARIABLES FOR SECOND UNIT.
C     ZZPGET   ...TO RETURN ITERATION COUNT AND TIME.
C
C## S U B R O U T I N E S:
C
C     ABS      ...INTRINSIC FUNCTION.
C     ZZSECS   ...FOR PRINT TIMING.
C     ZZEGET   ...ENTRY TO ZZEVAL FOR FUNCTION/GRADIENT COUNTS.
C
C## P A R A M E T E R S:
      REAL              ZERO,       ONE,       TWO,       THREE
C!!!! DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      REAL              FOUR,       FIVE,      SIX,       SEVEN
C!!!! DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      REAL              EIGHT,         NINE,          TEN
C!!!! DOUBLE PRECISION  EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

C## L O C A L   D E C L:

      INTEGER  IFNCT, IGRCT, ITCT,  COPYUN
      INTEGER  PRPT1, PLEV1, UNIT1, LSTIT1, LSTUN1
      INTEGER  PRPT2, PLEV2, UNIT2, LSTIT2, LSTUN2

      LOGICAL   GRAD1, LSTGR1, POINT1, LSTPT1, COPY
      LOGICAL   GRAD2, LSTGR2, POINT2, LSTPT2, FORCE, GOT

      REAL             SECS, PRTIME, DTIME
C!!!! DOUBLE PRECISION SECS, PRTIME, DTIME

C-----DECLARATIONS FOR ENTRY POINT DUMMY ARGUMENTS.

      LOGICAL  DGRAD1, DPINT1, DGRAD2, DPINT2, CP
      INTEGER  DPRUN1, DPRNT1, DPRUN2, DPRNT2, ITER, CU

      REAL              TIME
C!!!! DOUBLE PRECISION  TIME

C## S A V E:

           SAVE   PRTIME,  ITCT,  COPY,   COPYUN
           SAVE    PRPT1,  GRAD1, PLEV1,  UNIT1, POINT1
           SAVE    PRPT2,  GRAD2, PLEV2,  UNIT2, POINT2
           SAVE   LSTIT1, LSTUN1, LSTGR1, LSTPT1
           SAVE   LSTIT2, LSTUN2, LSTGR2, LSTPT2

C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:
            DATA PLEV1/0/, PLEV2/0/, UNIT1/6/, UNIT2/0/
            DATA COPY/.FALSE./,  COPYUN/6/
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      FORCE = INCR .LE.  0

      ITCT  = ITCT + ABS(INCR)

      CALL     ZZSECS  (SECS)
      PRTIME = PRTIME - SECS

      GOT = .FALSE.
      IF ( FORCE .AND. (   ITCT .EQ.  LSTIT1 )
     -           .AND. (  UNIT1 .EQ.  LSTUN1 )
     -           .AND. ( POINT1 .EQV. LSTPT1 )
     -           .AND. (  GRAD1 .EQV. LSTGR1 ) ) THEN
C                                     DON'T REPEAT AN EARLIER REQUEST.
         GOTO 2000
      ENDIF

  100 IF ( PLEV1 .NE. 0 .AND. ITCT .GT. PRPT1 ) THEN
         PRPT1 = PRPT1 + ABS(PLEV1)
         GOTO  100
      ENDIF

      IF (  (UNIT1 .NE. 0 ) .AND.
     -      (PLEV1 .NE. 0 ) .AND.
     -      (FORCE .OR. (ITCT .EQ. PRPT1)) ) THEN

C                -----SAVE INFORMATION DEFINING THIS PRINT REQUEST.
         LSTIT1 = ITCT
         LSTUN1 = UNIT1
         LSTGR1 = GRAD1
         LSTPT1 = POINT1

C        ------PRINT ITERATION NUMBER, FUNCTION VALUE, NORM OF G, AND
C                            NUMBER  OF FUNCTION/GRADIENT EVALUATIONS.
         CALL ZZEGET ( IFNCT, IGRCT, DTIME )
         GOT = .TRUE.

         WRITE ( UNIT1, 99999 ) ITCT,F,IFNCT,NRMG,IGRCT,DTIME

C                          ------IF PLEV1 > 0   , ALSO PRINT X AND G.
         IF ( PLEV1 .GT. 0 ) THEN
            IF ( POINT1) THEN
               WRITE (UNIT1,99998) X
            ENDIF

            IF ( GRAD1 ) THEN
               WRITE (UNIT1,99997) G
            ENDIF
         ENDIF

C                           ------UPDATE COUNTER.
         IF (ITCT .EQ. PRPT1) PRPT1 = PRPT1 + ABS(PLEV1)
      ENDIF

 2000 IF ( FORCE .AND. (   ITCT .EQ.  LSTIT2 )
     -           .AND. (  UNIT2 .EQ.  LSTUN2 )
     -           .AND. ( POINT2 .EQV. LSTPT2 )
     -           .AND. (  GRAD2 .EQV. LSTGR2 ) ) THEN
C                                     DON'T REPEAT AN EARLIER REQUEST.
         GOTO 4000
      ENDIF

 2200 IF ( PLEV2 .NE. 0 .AND. ITCT .GT. PRPT2 ) THEN
         PRPT2 = PRPT2 + ABS(PLEV2)
         GOTO  2200
      ENDIF

      IF (  (UNIT2 .NE. 0 ) .AND.
     -      (PLEV2 .NE. 0 ) .AND.
     -      (FORCE .OR. (ITCT .EQ. PRPT2)) ) THEN

C                   -----SAVE INFORMATION DEFINING THIS PRINT REQUEST.
         LSTIT2 = ITCT
         LSTUN2 = UNIT2
         LSTGR2 = GRAD2
         LSTPT2 = POINT2
C        ------PRINT ITERATION NUMBER, FUNCTION VALUE, NORM OF G, AND
C              NUMBER  OF FUNCTION/GRADIENT EVALUATIONS.

         IF ( .NOT. GOT ) CALL ZZEGET ( IFNCT, IGRCT, DTIME )
         WRITE ( UNIT2,  99989 ) ITCT,F,IFNCT,NRMG
         IF ( COPY ) WRITE ( COPYUN, 99989 ) ITCT,F,IFNCT,NRMG

C                            ------IF PLEV2 > 0   , ALSO PRINT X AND G.
         IF ( PLEV2 .GT. 0 ) THEN
            IF ( POINT2) THEN
               WRITE (UNIT2,99988) X
               IF (COPY) WRITE (COPYUN,99988) X
            ENDIF

            IF ( GRAD2 ) THEN
               WRITE (UNIT2,99987) G
               IF (COPY) WRITE (COPYUN,99987) G
            ENDIF
         ENDIF

C                                                  ------UPDATE COUNTER.
         IF (ITCT .EQ. PRPT2) PRPT2 = PRPT2 + ABS(PLEV2)
      ENDIF
 4000 GOTO 90000

C## E N T R Y  ZZP1ST:
                      ENTRY  ZZP1ST ( DPRUN1, DGRAD1, DPINT1, DPRNT1 )
      UNIT1  = DPRUN1
      GRAD1  = DGRAD1
      POINT1 = DPINT1
      PLEV1  = DPRNT1
      PRPT1  = 0
      ITCT   = -1
      LSTIT1 = -2
      LSTUN1 =  0
      LSTPT1 = -1
      LSTGR1 = -1
      PRTIME = ZERO
      RETURN

C## E N T R Y  ZZP2ST:
                      ENTRY ZZP2ST (DPRUN2,DGRAD2,DPINT2,DPRNT2,CP,CU )
      UNIT2  = DPRUN2
      GRAD2  = DGRAD2
      POINT2 = DPINT2
      PLEV2  = DPRNT2
      COPY   = CP
      COPYUN = CU
      PRPT2  = 0
      ITCT   = -1
      PRTIME = ZERO
      RETURN

C## E N T R Y  ZZPGET:
                      ENTRY  ZZPGET ( TIME, ITER )
      TIME = PRTIME
      ITER = ITCT
      RETURN

C## E X I T

90000 CALL     ZZSECS  (SECS)
      PRTIME = PRTIME + SECS

91000 RETURN

C## F O R M A T S:

99987 FORMAT(' GRAD:   ', 7G9.2 / (1X,8G9.2) )
99988 FORMAT(' POINT X:', 7G9.2 / (1X,8G9.2) )
99989 FORMAT(' PT #',I3,'; F=',G15.8,'(#',I3,') !!G!!=',E7.2)
99997 FORMAT(' THE GRADIENT AT THIS POINT IS ', 3G15.8 / (1X,5G15.8) )
99998 FORMAT(' THE VARIABLES HAVE THE CURRENT VALUES GIVEN BY ',4X,
     -            G26.16 / (2X,3G26.16) )
99999 FORMAT(' ',' ...PT ',I3,'; F=',G23.16,'(#',I3,') !!G!!=',
     -                     E7.2, '(#',I3,'); ',F8.3,' SECS'    )

C##                 E N D         OF ZZPRNT.
                    END
