      SUBROUTINE ZZLMOD (LOOPC, MXSIZE, LOOPX, ORDER, N, NEW, NEWX,LC,*)

C## A R G U M E N T S:
                       INTEGER  MXSIZE, N
                       INTEGER  LOOPX(N+1), ORDER(N), NEWX, LC
                       REAL              LOOPC(MXSIZE), NEW(*)
C!!!!                  DOUBLE PRECISION  LOOPC(MXSIZE), NEW(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   S I N G L E   PRECISION.
C!!!!           THIS VERSION IS IN   D O U B L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: LMOD.F,V 2.1 91/11/20 10:52:59 BUCKLEY EXP $
C>RCS $LOG:     LMOD.F,V $
C>RCS REVISION 2.1  91/11/20  10:52:59  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 2.0  90/07/31  11:31:58  BUCKLEY
C>RCS MINOR CHANGES TO ARGUMENT DECLARATIONS.
C>RCS
C>RCS REVISION 1.9.1.1  89/06/30  17:13:33  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.9  89/06/30  13:38:19  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  16:42:52  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:20:42  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:48:01  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:50:11  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C          THIS ROUTINE MODIFIES THE ODOMETER FOR REVISED DATA.
C
C
C      THE ARRAYS LOOPC AND LOOPX ARE DEFINED IN THE ROUTINE ZZLADV.
C  MXSIZE IS THE DEFINED SIZE OF LOOPC. IT IS ASSUMED THAT LOOPX(N+1)
C  POINTS AT THE FIRST FREE LOCATION IN LOOPC. THE NUMBER OF POSITIONS
C  CURRENTLY IN THE ODOMETER IS N. THE DEFINITION OF ORDER IS DESCRIBED
C  IN ZZLPCK.
C
C      THE ARRAY NEW HAS THE SAME FORMAT AS LOOPC. THE INFORMATION
C  IN NEW IS INSERTED INTO LOOPC. NOTE THAT THE NUMBER OF POSITIONS IN
C  THE ODOMETER DOES NOT CHANGE. AN ELEMENT WHICH DOES NOT LOOP, I.E.
C  FOR WHICH THERE IS NO SET OF VALUES DEFINED, IS SIMPLY ENTERED AS
C  A LIST WITH ONE ELEMENT.
C
C      NEWX FUNCTIONS LIKE THE POINTER PT IN ZZLPCK. IT SPECIFIES
C  THE POSITION IN THE ODOMETER WHERE THE NEW INFORMATION IS TO BE
C  PLACED.
C
C      IF THERE IS INSUFFICIENT ROOM TO MAKE THE UPDATE, THEN NO
C  CHANGE IS MADE TO THE ODOMETER AND THE ALTERNATE RETURN IS TAKEN
C  TO THE CALLING ROUTINE.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZLMOD
C## S U B R O U T I N E S:   NINT ... INTRINSIC

C## P A R A M E T E R S:
      REAL              ZERO,       ONE,       TWO,       THREE
C!!!! DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      REAL              FOUR,       FIVE,      SIX,       SEVEN
C!!!! DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      REAL              EIGHT,         NINE,          TEN
C!!!! DOUBLE PRECISION  EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

      INTEGER     LLIST,     LARITH,     LGEOMT
      PARAMETER ( LLIST = 1, LARITH = 2, LGEOMT = 3 )

      DOUBLE PRECISION  DEFADD,          DEFMUL
      PARAMETER       ( DEFADD = 1.0D0,  DEFMUL = 10.0D0 )

C     ANY FORM OF LOOP REQUIRES 5 ENTRIES IN LOOPC, WHEREAS A LIST
C     REQUIRES 2, PLUS THE NUMBER OF LIST ELEMENTS, ENTRIES.

      INTEGER     LOOPSP,     LISTSP
      PARAMETER ( LOOPSP = 5, LISTSP = 2 )

      LOGICAL     T,          F
      PARAMETER ( T = .TRUE., F = .FALSE. )

      CHARACTER*(*) TRUE,          QT,       FALSE,           QF
      PARAMETER (   TRUE = 'TRUE', QT = 'T', FALSE = 'FALSE', QF = 'F' )

      INTEGER     ITRUE,     IFALSE
      PARAMETER ( ITRUE = 1, IFALSE = 0 )

      REAL              RTRUE,        RFALSE
C!!!! DOUBLE PRECISION  RTRUE,        RFALSE
      PARAMETER      (  RTRUE = 1.D0, RFALSE = 0.D0 )

C## L O C A L   D E C L:
                        INTEGER   I, J, SPACE, K, FREE, NEWSZ

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N

      K = ORDER (NEWX)
      J = LOOPX ( K )

C     DETERMINE THE SPACE TO BE FREED BY REMOVING CURRENT DATA.

      SPACE = NINT ( LOOPC(J) )
      IF ( SPACE .LE. 0 ) THEN
         SPACE = LOOPSP
      ELSE
         SPACE = SPACE + LISTSP
      ENDIF

C     DETERMINE THE SPACE REQUIRED FOR THE NEW DATA.

      NEWSZ  = NINT( NEW(1) )

      IF ( NEWSZ .LE. 0 ) THEN
         NEWSZ = LOOPSP
      ELSE
         NEWSZ = NEWSZ + LISTSP
      ENDIF

C     DETERMINE THE TOTAL SPACE REQUIRED AFTER UPDATING.

      FREE = LOOPX(N+1) + NEWSZ - SPACE
      IF ( FREE .GT. MXSIZE + 1 ) THEN
         GOTO 91000
      ELSE

C        CHECK IF MISSING THIRD LOOP CONTROL ARGUMENT. FILL IN DEFAULT.
C        1 FOR ADDITIVE, 10 FOR MULTIPLICATIVE

         IF ( LC .NE. LLIST ) THEN
            IF      ( LC .EQ. LARITH .AND. NEW(LOOPSP) .EQ. ZERO ) THEN
               NEW(LOOPSP) = DEFADD
            ELSE IF ( LC .EQ. LGEOMT .AND. NEW(LOOPSP) .EQ. ZERO ) THEN
               NEW(LOOPSP) = DEFMUL
            ENDIF
         ENDIF

C        MOVE THE ELEMENTS IN LOOPC LEFT OVER BLOCK BEING REMOVED.

         DO 300 I = J, LOOPX(N+1) - SPACE - 1
            LOOPC(I) = LOOPC(I + SPACE)
 300     CONTINUE

C        MOVE THE POINTERS IN LOOPX. ONLY MOVE THOSE WHICH CHANGE.

         DO 700 I = 1, K-1
            IF (LOOPX(I) .GT. J) THEN
                LOOPX(I) = LOOPX(I) - SPACE
            ENDIF
 700     CONTINUE

C        NOTE: WE REMOVE THE K-TH POINTER.

         DO 1000 I = K+1, N
            IF (LOOPX(I) .GT. J) THEN
                 LOOPX(I-1) = LOOPX(I) -SPACE
            ELSE
                 LOOPX(I-1) = LOOPX(I)
            ENDIF
 1000    CONTINUE

C        REDEFINE THE N-TH LOCATION

         LOOPX(N) = FREE - NEWSZ

C        REDEFINE FIRST FREE LOCATION.

         LOOPX(N+1) = FREE

C        NOW USE FREE AS A TEMPORARY POINTER.

         FREE = LOOPX(N)

C        AND FILL IN THE NEW ENTRIES IN LOOPC.

         DO 2000 I = 1, NEWSZ
            LOOPC(FREE+I-1) = NEW(I)
 2000    CONTINUE

C        REVISE THE PERMUTATION VECTOR IN ORDER TO ACCOUNT FOR MOVEMENT
C        IN THE INDEX ARRAY LOOPX.

         DO 3000 I = 1,N
            IF ( ORDER(I) .GT. K ) THEN
               ORDER(I) = ORDER(I) - 1
            ENDIF
 3000    CONTINUE

C        THE NEW ELEMENT ALWAYS ENTERS AT THE RIGHTMOST POSITION OF THE
C        ODOMETER.

         ORDER(NEWX) = N
      ENDIF
      GOTO 90000

C## E X I T
90000       RETURN
91000       RETURN 1

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZLMOD.
                    END
