% Encode the character array 'abacabdabaceabacabdfg' into array
% huffmanCode with dynamic Huffman code (character array of
% '1' and '0').
%
inputArray = 'abacabdabaceabacabdfg'
huffmanCode = vitter673('mode', 'encode', 'input', inputArray)
% or
huffmanCode = vitter673('mode', 'encode', 'input', inputArray, 'inputKind', 'array')
%
% The same without auxiliary output:
%
huffmanCode = vitter673('mode', 'encode', 'input', inputArray, 'auxiliaryOutput', 'off')
%
% The same with output to file outputEncoded.txt:
%
huffmanCode = vitter673('mode', 'encode', 'input', inputArray, 'outputFilename', 'outputEncoded.txt')
%
% Encode the integer array inputArray into array huffmanCode with dynamic
% Huffman code (integer array of '1' and '0').
% In this example the input array contains the ASCII decimal values of
% characters from previous example.
%
inputArray = int16([97,98,97,99,97,98,100,97,98,97,99,101,97,98,97,99,97,98,100,102,103])
huffmanCode = vitter673('mode', 'encode', 'input', inputArray)
%
% Encode the file input.txt into the output array huffmanCode with dynamic
% Huffman code (output array is an array of integers '1' and '0').
%
huffmanCode = vitter673('mode', 'encode', 'input', 'input.txt', 'inputKind', 'file')
%
% Decode the array huffmanCode with dynamic Huffman code (array of integers
% or characters '1' and '0') into array sourceMessage.
%
sourceMessage = vitter673('mode', 'decode', 'input', huffmanCode)

