/**************************************************************
 * Sparse SVD Via Trace Minimization Procedure for Equivalent *
 * 2-Cyclic and A'A Eigensystems.                             *
 *                                                            *
 * Global variables and common areas used by tms1 and its     *
 * procedures.                                                *
 **************************************************************/

int    ierr,           /* error flag                         */
        ncol,           /* number of columns of A             */
        nrow;           /* number of rows of A                */

/**************************************************************
 * pointers to areas holding input matrix which is stored in  *
 * harwell-boeing format.                                     *
 **************************************************************/

int    *pointr = NULL, /* pointer to column start array      */
        *rowind = NULL; /* pointer to row indices array       */
float  *value  = NULL; /* pointer to nonzero values array    */

float  alpha,          /* 1-norm of the matrix A             */
        tol,
        eps;            /* positive machine epsilon           */

int    *iw,**iwork,*lwork;

float  *w1,*w2,*w3,*w4,*w5,*yy;
float  **work1, **work2, **work3, **work4, **work5, **y;
float  *z, *v2, *r, *r2, *pp, *z2, *zz; /* temporary variables  */
        
FILE    *fp_out1 = NULL;/* output file pointers               */
int    fp_out2; /* output file pointers                      */

char    *error[10] = { /*error messages used by function      *
                        *check_parameters                     */
          NULL,
          "SORRY, YOUR MATRIX IS TOO BIG ",
          NULL,
          "*** P CANNOT EXCEED MAXI ***",
          "*** N = NROW + NCOL MUST BE GREATER THAN ZERO ***",
          "*** MAXI (NUMBER OF MIN. ITERATIONS) IS INVALID ***",
          "*** P (NUMBER OF EIGENPAIRS DESIRED) IS INVALID ***",
          NULL,
          NULL,
          NULL};
