// File: tms.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 15 Nov, 2003


// (c) Suvrit Sra 2004 All Rights Reserved

#ifndef _S_TMS_BASE_H
#define _S_TMS_BASE_H

#include "svdpack.h"

namespace ssvd {

class tms : public svdpack {
protected:
  double  *z, 
          *v2,
          *r,
          *r2,
          *pp,
          *z2,
          *zz; /* temporary variables  */


  double  epslon(double x);
  long    ierr;           /* error flag                         */
  double  alpha,          /* 1-norm of the matrix A             */
          tol,
          eps;            /* positive machine epsilon           */


  long    *iw,**iwork,*lwork;

  double  *w1,*w2,*w3,*w4,*w5,*yy;
  double  **work1, **work2, **work3, **work4, **work5, **y;
  

  void cgt (long n, long left, double *w, double **v, long *cgiter, 
	    double sig, double sigmax, long *kount, double eps);

  void cgts(long n, long left, double *w, double **v, long *cgiter,
	    double sig, double sigold, double sigmax, double shift,
	    long *kount, double eps);
  void clus(long i, long size, double *resid, double tol, long *init,
	    double *ireso, double *creso, double *tmp, long s);
  
  void disk  (long n, double *sig, double *rad, long *csize,
	      long *clus);
  void dtrsm (char side, char uplo, long transa, char diag, long m,
	      long n, double alpha, double **a, double **b);

  void isol  (long i, double resid, double tol, long *init, double *,
	      double *creso, long s);

  void porth (long p, long f, long n, double **x, double *tmp,
	     double *tmp1, double *tmp2, double *tmp3,
	     double *tmp4, double e, long degree, double alpha);
  void pmul  (long, double *, double *, double *, double *,
	      double *, double, long, double);
  void myopb(long n, double *x, double *y, double shift);
public:

  tms() : svdpack() {}
  tms(long nm, long nz, long sd) : svdpack(nm, nz, sd) {}

};

}
#endif
