// File: s_opts.cc
// Author: Suvrit Sra
// Date: 13 Jan 04

// Sets the options for various types of algorithms from specified
// file. This function is sometimes useful when we are using libmyssvd. It
// makes things a little unclean though, coz. we put in details about the
// various s_run... type files in here but it can't be helped, coz as it
// is...the style and idea of having a s_opts.h file is quite messy.

// (c) Suvrit Sra 2004 All Rights Reserved


#include "s_opts.h"
#include <cstring>
#include <cstdio>
#include <cstdlib>

namespace ssvd {
  void OptionsStruct::setFromFile(int algo, char* file)
  {
    FILE* fp = fopen(file, "r");
    if (!fp) {
      fprintf(stderr, "s_opts: Could not read options from file %s\n", file);
      return;
    }
  
    int asc;			// ascii file for svecs

    in1 = fp;
    fscanf(fp, "%s %s", out1, out2);

    switch (algo) {
      // BLS1, BLS2 have similar options file
    case 0:
    case 1:
      fscanf (fp,"%s%ld%ld%ld%ld%lf%s%d", name, &maxit, &nc, &nb, &nums, &tol, vtf, &asc);
      break;
      // LAS1, LAS2
    case 2:
    case 3:
      fscanf (fp,"%s %ld %ld %lf %lf %s %lf %d", name, &lanmax, &nums, &endl, &endr, vtf, &kappa, &asc);
      break;
      // SIS1, SIS2
    case 4: 
    case 5:
      fscanf(fp,"%s%s%ld%ld%ld%lf%s%d", out3, name, &maxsubsp, &numextra, &km, &eps, vtf, &asc);
      break;
      // TMS1, TMS2
    case 6:
    case 7:
      fscanf (fp,"%s %ld %ld %ld %lf %lf %s %ld %d", name, &nums, &maxsubsp, &accel, &tol, &red, vtf, &maxit, &asc);
      break;
    default:
      fprintf(stderr, "s_opts: Invalid algorithm requested Algo==%d\n", algo);
      return;
    }
    // Common settings pertaining to singular vectors for all algorithms.
    if (!(strcmp(vtf, "TRUE"))) {
      vectors = true;
      if (asc > 0) 
	ascii = true;
    } else
      vectors = false;
  }
}
