// File: s_bls2.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 12 Nov, 2003

// (c) Suvrit Sra 2004 All Rights Reserved


#ifndef _S_BLS2_H_
#define _S_BLS2_H_

#include "bls.h"

namespace ssvd {
/****************************************************************
 * Sparse SVD Via Hybrid Block Lanczos Procedure for Equivalent *
 * A'A Eigensystems.                                            *
 *                                                              *
 * Global variables and common areas used by bls2 and its       *
 * functions.                                                   *
 ****************************************************************/
class s_bls2 : public bls {
  long polong2(long *k, long m, long n, 
	       double *v, double *res, double *eig, double tol);
  
  void block2(double **sp, double **rp, double **bigsp, long m, long n, 
		      long nb, long ns, long *irand);

public:
  // Taken from bls2.c
  long   blklan2(FILE* fp, long, long, long, long, double *, double *,
		 long, long, double, double *, long, long *, long *,
		 long *, long*);

  virtual int    runIt() = 0;
};

}
#endif
