// File: driver.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 15 Nov, 2003

// The driver class for testing out the various SVD routines

// (c) Suvrit Sra 2004 All Rights Reserved

#ifndef _S_DRIVER_H_
#define _S_DRIVER_H_

#include "s_bls1.h"
#include "s_bls2.h"
#include "s_las1.h"
#include "s_las2.h"
#include "s_sis1.h"
#include "s_sis2.h"
#include "s_tms1.h"
#include "s_tms2.h"
#include "s_opts.h"

namespace ssvd {
class Driver {
  OptionsStruct* options;
  svdpack* svd;

  char fname[1024];
  char txx[6];
  char* m_progname;
  char*  algoname;
  int  cmdok;
  enum AlgoType { BLS1, BLS2, LAS1, LAS2, SIS1, SIS2, TMS1, TMS2};
  int   algo;
  int  verbose;
  bool ascii;
  char optionsFile[1024];
  bool vectors;
public:
  Driver(char**);
  Driver(int algo, OptionsStruct* opt = 0);

  double* getSing() { return svd->getSing();}
  int execute();
  int executeWithOptions();

  virtual ~Driver() {}
  void setOptions(OptionsStruct*);
  OptionsStruct* getOptions() const { return options;}
  void showHelp(int l = 0);
  

};

}
#endif 
