#include <string.h>
#include "parpre_subdomains.h"
#include "parpre_pipeline.h"
#include "./pipeline_impl.h"
#include "petscsys.h"
#include "src/vec/impls/mpi/pvecimpl.h" /* definition of VecScatter_MPI_Gen */
#include "src/mat/matimpl.h"
#include "src/sles/pc/pcimpl.h"
#include "src/mat/impls/aij/mpi/mpiaij.h"
#include "pinclude/pviewer.h"

#undef __FUNC__
#define __FUNC__ "VecPipelineIsStartOfPipe"
/*@
   VecPipelineIsStartOfPipe - Test whether this processor has no predecessors.
@*/
int VecPipelineIsStartOfPipe(VecPipeline ctx,PipelineDirection pmode,int *flg)
{
  VecScatter_MPI_General *gen_from;
  int ierr;

  PetscFunctionBegin;
  if (!ctx->setupcalled) {
    ierr = VecPipelineSetup(ctx); CHKERRQ(ierr);
  }

  if (pmode==PIPELINE_UP) {
    gen_from = (VecScatter_MPI_General *) ctx->upfrom;
  } else if (pmode==PIPELINE_DOWN) {
    gen_from = (VecScatter_MPI_General *) ctx->dnfrom;
  } else SETERRQ(1,pmode,
		 "VecPipelineIsStartOfPipe: unknown or not implemented pipeline mode");

  *flg = gen_from->n==0;

  PetscFunctionReturn(0);
}

#undef __FUNC__
#define __FUNC__ "PCCustomPipelineSetFromOptions"
int PCCustomPipelineSetFromOptions(PC pc)
{
  char *prefix,value[20];
  int flag,ierr;

  ierr = PCGetOptionsPrefix(pc,&prefix); CHKERRQ(ierr);
  if (prefix) printf("Found prefix %s\n",prefix);
  ierr = OptionsGetString(prefix,"-pc_pipeline",value,20,&flag); CHKERRQ(ierr);
  if (flag) {
    value[4]='\0';
    if (strcmp(value,"none")==0) {
      ierr = PCParallelSubdomainPipelineSetType
	(pc,PIPELINE_NONE,(PetscObject)PETSC_NULL);
      CHKERRQ(ierr);
    } else if (strcmp(value,"sequ")==0) {
      ierr = PCParallelSubdomainPipelineSetType
	(pc,PIPELINE_SEQUENTIAL,(PetscObject)PETSC_NULL);
      CHKERRQ(ierr);
    } else if (strcmp(value,"redb")==0) {
      ierr = PCParallelSubdomainPipelineSetType
	(pc,PIPELINE_REDBLACK,(PetscObject)PETSC_NULL);
      CHKERRQ(ierr);
    } else if (strcmp(value,"mult")==0) {
      ierr = PCParallelSubdomainPipelineSetType
	(pc,PIPELINE_MULTICOLOR,(PetscObject)pc->pmat);
      CHKERRQ(ierr);
    } else SETERRQ(1,0,"unknown custom pipeline option");
  }
  return 0;
}

