#include "petscpc.h"
#include "src/sles/pc/pcimpl.h"
#include "petscsles.h"
#include "parpre_structure.h"
#include "parpre_subdomains.h"
#include "subdomains_impl.h"

#undef __FUNC__
#define __FUNC__ "PCParallelGetSubdomains"
int PCParallelGetSubdomains(PC pc,PCParallelSubdomainStruct *subdomains)
{
  PCParallelStruct *pc_data = (PCParallelStruct *) pc->data;
  if (!pc_data->subdomains)
    SETERRQ(1,0,"PCParallelGetSubdomains: no subdomains");
  *subdomains = pc_data->subdomains;

  return 0;
}

#undef __FUNC__
#define __FUNC__ "PCParallelSetSubdomains"
int PCParallelSetSubdomains(PC pc,PCParallelSubdomainStruct subdomains)
{
  PCParallelStruct *pc_data = (PCParallelStruct *) pc->data;
  pc_data->subdomains = subdomains;

  return 0;
}
