#include "mpi.h"
#include "petsc.h"
#include "petscis.h"
#include "parpre_is.h"

#undef __FUNC__
#define __FUNC__ "ISGetGlobalContent"
int ISGetGlobalContent(MPI_Comm comm,IS is,IS *gis)
{
  IS nis;
  int np,n_loc,n,*n_ar,*idxs_loc,*idxs,*disp,ierr;

  MPI_Comm_size(comm,&np);

  /* make an array of local sizes of all processors concerned */
  n_ar = (int *) PetscMalloc(np*sizeof(int)); CHKPTRQ(n_ar);
  ierr = ISGetSize(is,&n_loc); CHKERRQ(ierr);
  MPI_Allgather((void *)&n_loc,1,MPI_INT,(void *)n_ar,1,MPI_INT,comm);

  /* compute processor offsets, total size, and allocate an array that big */
  disp = (int *) PetscMalloc((np+1)*sizeof(int)); CHKPTRQ(disp);
  {int i; disp[0] = 0; for (i=0; i<np; i++) disp[i+1] = disp[i]+n_ar[i];}
  n = disp[np];
  idxs = (int *) PetscMalloc( (n+1)*sizeof(int) ); CHKPTRQ(idxs);
  ierr = ISGetIndices(is,&idxs_loc); CHKERRQ(ierr);
  MPI_Allgatherv((void *)idxs_loc,n_loc,MPI_INT,
		 (void *)idxs,n_ar,disp,MPI_INT,comm);
  ierr = ISRestoreIndices(is,&idxs_loc); CHKERRQ(ierr);

  /* make actual index set */
  ierr = ISCreateGeneral(comm,n,idxs,&nis); CHKERRQ(ierr); *gis = nis;

  /* clean up */
  PetscFree(n_ar); PetscFree(disp); PetscFree(idxs);

  return 0;
}

