#include "mpi.h"
#include "petscmat.h"
#include "src/mat/parpre_matimpl.h"
#include "src/mat/impls/aij/mpi/mpiaij.h"
#include "./ml_impl.h"

/****************************************************************
 * Strong and weak connections                                  *
 ****************************************************************/
#undef __FUNC__
#define __FUNC__ "MakeStrongMatrix"
int MakeStrongMatrix(Mat mat,int modification,double weight,
		     Vec u,Vec v,Mat *strong_matrix,int trace)
{
  Mat strong_mat;
    Mat_MPIAIJ  *Aij = (Mat_MPIAIJ *) mat->data;
    Mat A = Aij->A, B = Aij->B;
  MPI_Comm comm = mat->comm;
  int rstart,rend,local_size,iRow,ierr;
  int K=0,D=0;
  
#define WEIGH 1
  Scalar *dA,*rA,*cB;

  PetscFunctionBegin;
  if (trace & AMLTraceProgress) PetscPrintf(comm,"..making strong matrix\n");
  ierr = MatGetOwnershipRange(mat,&rstart,&rend); CHKERRQ(ierr);
  local_size = rend-rstart;

  /* allocate the strong matrix */
  {
    int *band;
    band = (int *) PetscMalloc((local_size+1)*sizeof(int));
    for (iRow=0; iRow<local_size; iRow++) {
      ierr = MatGetRow(A,iRow,band+iRow,PETSC_NULL,PETSC_NULL);
      CHKERRQ(ierr);
      ierr = MatRestoreRow(A,iRow,band+iRow,PETSC_NULL,PETSC_NULL);
      CHKERRQ(ierr);
    }
    ierr = MatCreateMPIAIJ
      (comm,local_size,local_size,PETSC_DECIDE,PETSC_DECIDE,
       0,band,0,band, &strong_mat);
    CHKERRQ(ierr);
    PetscFree(band);
  }

  /* get the diagonal to compare to */
  ierr = MatGetDiagonal(mat,v); CHKERRQ(ierr);

  /* compare strong connections to max off diag element per row 
     ierr = MatMaxRowOffDiagElement_MPIAIJ(mat,u); CHKERRQ(ierr);
     ierr = VecSet(&zero,v); CHKERRQ(ierr);
     ierr = MatMaxColOffDiagElement_MPIAIJ(mat,v); CHKERRQ(ierr);*/
  ierr = VecScatterBegin(v,Aij->lvec,INSERT_VALUES,
			 SCATTER_FORWARD,Aij->Mvctx); CHKERRQ(ierr);
  ierr = VecScatterEnd(v,Aij->lvec,INSERT_VALUES,
		       SCATTER_FORWARD,Aij->Mvctx); CHKERRQ(ierr);
  ierr = VecGetArray(v,&dA); CHKERRQ(ierr);
  ierr = VecGetArray(u,&rA); CHKERRQ(ierr);
  ierr = VecGetArray(Aij->lvec,&cB); CHKERRQ(ierr);
  
  for (iRow=0; iRow<local_size; iRow++) {
    int Row=rstart+iRow,ncols,*cols,iCol; Scalar *vals;

    /* get the row for as far as it's in A */
    ierr = MatGetRow(A,iRow,&ncols,&cols,&vals); CHKERRQ(ierr);
    for (iCol=0; iCol<ncols; iCol++) {
      int Col=rstart+cols[iCol]; Scalar val=vals[iCol]; double d=0.;

      d=sqrt(PetscAbsScalar(dA[iRow]*(dA[cols[iCol]])));
      if ( (Col==Row) || (PetscAbsScalar(val)>weight*d) ) {
	K++;
	ierr = MatSetValues
	  (strong_mat,1,&Row,1,&Col,&val,ADD_VALUES); CHKERRQ(ierr);
      } else {
	D++;
	if (modification) {
	  ierr = MatSetValues
	    (strong_mat,1,&Row,1,&Row,&val,ADD_VALUES); CHKERRQ(ierr);
	}}}
    ierr = MatRestoreRow(A,iRow,&ncols,&cols,&vals); CHKERRQ(ierr);

    /* get the row for as far as it's in B */
    ierr = MatGetRow(B,iRow,&ncols,&cols,&vals); CHKERRQ(ierr);
    for (iCol=0; iCol<ncols; iCol++) {
      int Col=Aij->garray[cols[iCol]]; Scalar val=vals[iCol]; double d=0.;

      d=sqrt(PetscAbsScalar(dA[iRow]*(cB[cols[iCol]])));
      if (PetscAbsScalar(val)>weight*d) {
	K++;
	ierr = MatSetValues
	  (strong_mat,1,&Row,1,&Col,&val,ADD_VALUES); CHKERRQ(ierr);
      } else {
	D++;
	if (modification) {
	  ierr = MatSetValues
	    (strong_mat,1,&Row,1,&Row,&val,ADD_VALUES); CHKERRQ(ierr);
	}}}
    ierr = MatRestoreRow(B,iRow,&ncols,&cols,&vals); CHKERRQ(ierr);
  }

  ierr = VecRestoreArray(v,&dA); CHKERRQ(ierr);
  ierr = VecRestoreArray(u,&rA); CHKERRQ(ierr);
  ierr = VecRestoreArray(Aij->lvec,&cB); CHKERRQ(ierr);

  ierr = MatAssemblyBegin(strong_mat,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  ierr = MatAssemblyEnd(strong_mat,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);
  *strong_matrix = strong_mat;
/*printf("strong matrix\n"); MatView(strong_mat,0);*/


  if (trace & AMLTraceFill) {
    int gD,gK,pc;
    MPI_Reduce(&D,&gD,1,MPI_INT,MPI_SUM,0,comm);
    MPI_Reduce(&K,&gK,1,MPI_INT,MPI_SUM,0,comm);
    if (gD==0) pc=0; else pc=(100*gD)/(gD+gK);
    PetscPrintf(comm,"Making strong matrix, discard %d=%d pct\n",D,pc);
  }
  
  return 0;
}

